/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.WebSyncManager;
import android.webkit.WebViewDatabase;
import java.util.ArrayList;
import java.util.Iterator;

public final class CookieSyncManager
extends WebSyncManager {
    private static CookieSyncManager sRef;
    private long mLastUpdate;

    private CookieSyncManager(Context context) {
        super(context, "CookieSyncManager");
    }

    public static CookieSyncManager createInstance(Context context) {
        synchronized (CookieSyncManager.class) {
            if (sRef == null) {
                Context context2 = context.getApplicationContext();
                sRef = new CookieSyncManager(context2);
            }
            CookieSyncManager cookieSyncManager = sRef;
            return cookieSyncManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CookieSyncManager getInstance() {
        synchronized (CookieSyncManager.class) {
            if (sRef != null) return sRef;
            throw new IllegalStateException("CookieSyncManager::createInstance() needs to be called before CookieSyncManager::getInstance()");
        }
    }

    private void syncFromRamToFlash(ArrayList<CookieManager.Cookie> arrayList) {
        Iterator<CookieManager.Cookie> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CookieManager.Cookie cookie = iterator.next();
            if (cookie.mode == 1) continue;
            if (cookie.mode != null) {
                WebViewDatabase webViewDatabase = this.mDataBase;
                String string2 = cookie.domain;
                String string3 = cookie.path;
                String string4 = cookie.name;
                webViewDatabase.deleteCookies(string2, string3, string4);
            }
            if (cookie.mode != 2) {
                this.mDataBase.addCookie(cookie);
                CookieManager.getInstance().syncedACookie(cookie);
                continue;
            }
            CookieManager.getInstance().deleteACookie(cookie);
        }
        return;
    }

    void clearAllCookies() {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearCookies();
    }

    void clearExpiredCookies(long l) {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearExpiredCookies(l);
    }

    void clearSessionCookies() {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearSessionCookies();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArrayList<CookieManager.Cookie> getCookiesForDomain(String string2) {
        void var2_3;
        if (this.mDataBase == null) {
            ArrayList arrayList = new ArrayList();
            return var2_3;
        }
        ArrayList<CookieManager.Cookie> arrayList = this.mDataBase.getCookiesForDomain(string2);
        return var2_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hasCookies() {
        if (this.mDataBase != null) return this.mDataBase.hasCookies();
        return false;
    }

    @Override
    protected void syncFromRamToFlash() {
        long l;
        if (!CookieManager.getInstance().acceptCookie()) {
            return;
        }
        CookieManager cookieManager = CookieManager.getInstance();
        long l2 = this.mLastUpdate;
        ArrayList<CookieManager.Cookie> arrayList = cookieManager.getUpdatedCookiesSince(l2);
        this.mLastUpdate = l = System.currentTimeMillis();
        this.syncFromRamToFlash(arrayList);
        ArrayList<CookieManager.Cookie> arrayList2 = CookieManager.getInstance().deleteLRUDomain();
        this.syncFromRamToFlash(arrayList2);
    }
}

