/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.ParseException;
import android.net.WebAddress;
import android.net.http.EventHandler;
import android.net.http.RequestHandle;
import android.webkit.CacheLoader;
import android.webkit.CacheManager;
import android.webkit.ContentLoader;
import android.webkit.CookieManager;
import android.webkit.DataLoader;
import android.webkit.FileLoader;
import android.webkit.LoadListener;
import android.webkit.Network;
import android.webkit.URLUtil;
import android.webkit.WebSettings;
import android.webkit.WebViewWorker;
import java.util.HashMap;
import java.util.Map;

class FrameLoader {
    private static final String CONTENT_TYPE = "content-type";
    static final String HEADER_STR = "text/xml, text/html, application/xhtml+xml, image/png, text/plain, */*;q=0.8";
    private static final String LOGTAG = "webkit";
    private static final int URI_PROTOCOL = 256;
    private static final String mAboutBlank = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EB\"><html><head><title>about:blank</title></head><body></body></html>";
    private int mCacheMode;
    private String mContentType;
    private Map<String, String> mHeaders;
    private final LoadListener mListener;
    private final String mMethod;
    private Network mNetwork;
    private byte[] mPostData;
    private String mReferrer;
    private final WebSettings mSettings;

    FrameLoader(LoadListener loadListener, WebSettings webSettings, String string2) {
        this.mListener = loadListener;
        this.mHeaders = null;
        this.mMethod = string2;
        this.mCacheMode = 0;
        this.mSettings = webSettings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleCache() {
        switch (this.mCacheMode) {
            default: {
                LoadListener loadListener = this.mListener;
                Map<String, String> map = this.mHeaders;
                return loadListener.checkCache(map);
            }
            case 3: {
                String string2 = this.mListener.url();
                long l = this.mListener.postIdentifier();
                CacheManager.CacheResult cacheResult = CacheManager.getCacheFile(string2, l, null);
                if (cacheResult != null) {
                    this.startCacheLoad(cacheResult);
                    return true;
                }
                LoadListener loadListener = this.mListener;
                Context context = this.mListener.getContext();
                int[] nArray = EventHandler.errorStringResources;
                int n = Math.abs(65522);
                int n2 = nArray[n];
                String string3 = ((Object)context.getText(n2)).toString();
                loadListener.error(65522, string3);
                return true;
            }
            case 1: {
                String string4 = this.mListener.url();
                long l = this.mListener.postIdentifier();
                CacheManager.CacheResult cacheResult = CacheManager.getCacheFile(string4, l, null);
                if (cacheResult == null) return false;
                this.startCacheLoad(cacheResult);
                return true;
            }
            case 2: 
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean handleLocalFile(String string2, LoadListener loadListener, WebSettings webSettings) {
        String string3;
        block14: {
            try {
                byte[] byArray = URLUtil.decode(string2.getBytes());
                string3 = new String(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string4 = loadListener.getContext().getString(17039367);
                loadListener.error(65524, string4);
                return true;
            }
            if (!URLUtil.isAssetUrl(string3)) break block14;
            if (loadListener.isSynchronous()) {
                new FileLoader(string3, loadListener, 1, true).load();
                return true;
            }
            WebViewWorker webViewWorker = WebViewWorker.getHandler();
            FileLoader fileLoader = new FileLoader(string3, loadListener, 1, true);
            webViewWorker.obtainMessage(101, fileLoader).sendToTarget();
            return true;
        }
        if (URLUtil.isResourceUrl(string3)) {
            if (loadListener.isSynchronous()) {
                new FileLoader(string3, loadListener, 2, true).load();
                return true;
            }
            WebViewWorker webViewWorker = WebViewWorker.getHandler();
            FileLoader fileLoader = new FileLoader(string3, loadListener, 2, true);
            webViewWorker.obtainMessage(101, fileLoader).sendToTarget();
            return true;
        }
        if (URLUtil.isFileUrl(string3)) {
            if (loadListener.isSynchronous()) {
                boolean bl = webSettings.getAllowFileAccess();
                new FileLoader(string3, loadListener, 3, bl).load();
                return true;
            }
            WebViewWorker webViewWorker = WebViewWorker.getHandler();
            boolean bl = webSettings.getAllowFileAccess();
            FileLoader fileLoader = new FileLoader(string3, loadListener, 3, bl);
            webViewWorker.obtainMessage(101, fileLoader).sendToTarget();
            return true;
        }
        if (URLUtil.isContentUrl(string3)) {
            if (loadListener.isSynchronous()) {
                String string5 = loadListener.url();
                new ContentLoader(string5, loadListener).load();
                return true;
            }
            WebViewWorker webViewWorker = WebViewWorker.getHandler();
            String string6 = loadListener.url();
            ContentLoader contentLoader = new ContentLoader(string6, loadListener);
            webViewWorker.obtainMessage(101, contentLoader).sendToTarget();
            return true;
        }
        if (URLUtil.isDataUrl(string3)) {
            new DataLoader(string3, loadListener).load();
            return true;
        }
        if (!URLUtil.isAboutUrl(string3)) return false;
        byte[] byArray = mAboutBlank.getBytes();
        int n = mAboutBlank.length();
        loadListener.data(byArray, n);
        loadListener.endData();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void populateHeaders() {
        WebAddress webAddress;
        CookieManager cookieManager;
        String string2;
        if (this.mReferrer != null) {
            Map<String, String> map = this.mHeaders;
            String string3 = this.mReferrer;
            String string4 = map.put("Referer", string3);
        }
        if (this.mContentType != null) {
            Map<String, String> map = this.mHeaders;
            String string5 = this.mContentType;
            String string6 = map.put(CONTENT_TYPE, string5);
        }
        if (this.mNetwork.isValidProxySet()) {
            Network network = this.mNetwork;
            // MONITORENTER : network
            String string7 = this.mNetwork.getProxyUsername();
            String string8 = this.mNetwork.getProxyPassword();
            // MONITOREXIT : network
            if (string7 != null && string8 != null) {
                String string9 = RequestHandle.authorizationHeader(true);
                Map<String, String> map = this.mHeaders;
                StringBuilder stringBuilder = new StringBuilder().append("Basic ");
                String string10 = RequestHandle.computeBasicAuthResponse(string7, string8);
                String string11 = stringBuilder.append(string10).toString();
                String string12 = map.put(string9, string11);
            }
        }
        if ((string2 = (cookieManager = CookieManager.getInstance()).getCookie(webAddress = this.mListener.getWebAddress())) == null) {
            return;
        }
        if (string2.length() <= 0) {
            return;
        }
        String string13 = this.mHeaders.put("Cookie", string2);
    }

    private void populateStaticHeaders() {
        String string2 = this.mHeaders.get("Accept");
        if (string2 == null || string2.length() == 0) {
            String string3 = this.mHeaders.put("Accept", HEADER_STR);
        }
        String string4 = this.mHeaders.put("Accept-Charset", "utf-8, iso-8859-1, utf-16, *;q=0.7");
        String string5 = this.mSettings.getAcceptLanguage();
        if (string5.length() > 0) {
            String string6 = this.mHeaders.put("Accept-Language", string5);
        }
        Map<String, String> map = this.mHeaders;
        String string7 = this.mSettings.getUserAgentString();
        String string8 = map.put("User-Agent", string7);
    }

    private void startCacheLoad(CacheManager.CacheResult cacheResult) {
        LoadListener loadListener = this.mListener;
        CacheLoader cacheLoader = new CacheLoader(loadListener, cacheResult);
        this.mListener.setCacheLoader(cacheLoader);
        if (this.mListener.isSynchronous()) {
            cacheLoader.load();
            return;
        }
        WebViewWorker.getHandler().obtainMessage(101, cacheLoader).sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeLoad() {
        String string2 = this.mListener.url();
        if (URLUtil.isNetworkUrl(string2)) {
            Network network;
            if (this.mSettings.getBlockNetworkLoads()) {
                LoadListener loadListener = this.mListener;
                String string3 = this.mListener.getContext().getString(17039367);
                loadListener.error(65524, string3);
                return false;
            }
            if (!URLUtil.verifyURLEncoding(this.mListener.host())) {
                LoadListener loadListener = this.mListener;
                String string4 = this.mListener.getContext().getString(17039367);
                loadListener.error(65524, string4);
                return false;
            }
            this.mNetwork = network = Network.getInstance(this.mListener.getContext());
            if (this.mListener.isSynchronous()) {
                return this.handleHTTPLoad();
            }
            WebViewWorker.getHandler().obtainMessage(102, this).sendToTarget();
            return true;
        }
        LoadListener loadListener = this.mListener;
        WebSettings webSettings = this.mSettings;
        if (FrameLoader.handleLocalFile(string2, loadListener, webSettings)) {
            return true;
        }
        LoadListener loadListener2 = this.mListener;
        String string5 = ((Object)this.mListener.getContext().getText(17039368)).toString();
        loadListener2.error(65526, string5);
        return false;
    }

    public LoadListener getLoadListener() {
        return this.mListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean handleHTTPLoad() {
        if (this.mHeaders == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.mHeaders = hashMap;
        }
        this.populateStaticHeaders();
        this.populateHeaders();
        if (this.handleCache()) {
            LoadListener loadListener = this.mListener;
            String string2 = this.mMethod;
            Map<String, String> map = this.mHeaders;
            byte[] byArray = this.mPostData;
            loadListener.setRequestData(string2, map, byArray);
            return true;
        }
        boolean bl = false;
        int n = 65526;
        try {
            boolean bl2;
            Network network = this.mNetwork;
            String string3 = this.mMethod;
            Map<String, String> map = this.mHeaders;
            byte[] byArray = this.mPostData;
            LoadListener loadListener = this.mListener;
            bl = bl2 = network.requestURL(string3, map, byArray, loadListener);
        }
        catch (ParseException parseException) {
            n = 65524;
        }
        catch (RuntimeException runtimeException) {
            n = 65524;
        }
        if (bl) return true;
        LoadListener loadListener = this.mListener;
        Context context = this.mListener.getContext();
        int[] nArray = EventHandler.errorStringResources;
        int n2 = Math.abs(n);
        int n3 = nArray[n2];
        String string4 = ((Object)context.getText(n3)).toString();
        loadListener.error(n, string4);
        return false;
    }

    public void setCacheMode(int n) {
        this.mCacheMode = n;
    }

    public void setContentTypeForPost(String string2) {
        this.mContentType = string2;
    }

    public void setHeaders(HashMap hashMap) {
        this.mHeaders = hashMap;
    }

    public void setPostData(byte[] byArray) {
        this.mPostData = byArray;
    }

    public void setReferrer(String string2) {
        if (!URLUtil.isNetworkUrl(string2)) {
            return;
        }
        this.mReferrer = string2;
    }
}

