/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.webkit.ValueCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class GeolocationPermissions {
    static final int ALLOW = 3;
    private static final String ALLOWED = "allowed";
    private static final String CALLBACK = "callback";
    static final int CLEAR = 2;
    static final int CLEAR_ALL = 4;
    static final int GET_ALLOWED = 1;
    static final int GET_ORIGINS = 0;
    private static final String ORIGIN = "origin";
    private static final String ORIGINS = "origins";
    static final int RETURN_ALLOWED = 1;
    static final int RETURN_ORIGINS = 0;
    private static final String TAG = "geolocationPermissions";
    private static GeolocationPermissions sInstance;
    private Handler mHandler;
    private Vector<Message> mQueuedMessages;
    private Handler mUIHandler;

    public static GeolocationPermissions getInstance() {
        if (sInstance == null) {
            sInstance = new GeolocationPermissions();
        }
        return sInstance;
    }

    private static native void nativeAllow(String var0);

    private static native void nativeClear(String var0);

    private static native void nativeClearAll();

    private static native boolean nativeGetAllowed(String var0);

    private static native Set nativeGetOrigins();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postMessage(Message message) {
        synchronized (this) {
            if (this.mHandler == null) {
                if (this.mQueuedMessages == null) {
                    Vector vector = new Vector();
                    this.mQueuedMessages = vector;
                }
                boolean bl = this.mQueuedMessages.add(message);
            } else {
                boolean bl = this.mHandler.sendMessage(message);
            }
            return;
        }
    }

    private void postUIMessage(Message message) {
        if (this.mUIHandler == null) {
            return;
        }
        boolean bl = this.mUIHandler.sendMessage(message);
    }

    public void allow(String string2) {
        Message message = Message.obtain(null, 3, string2);
        this.postMessage(message);
    }

    public void clear(String string2) {
        Message message = Message.obtain(null, 2, string2);
        this.postMessage(message);
    }

    public void clearAll() {
        Message message = Message.obtain(null, 4);
        this.postMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createHandler() {
        synchronized (this) {
            if (this.mHandler == null) {
                Handler handler;
                this.mHandler = handler = new Handler(){

                    @Override
                    public void handleMessage(Message message) {
                        switch (message.what) {
                            default: {
                                return;
                            }
                            case 0: {
                                Set set = GeolocationPermissions.nativeGetOrigins();
                                ValueCallback valueCallback = (ValueCallback)message.obj;
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                ValueCallback valueCallback2 = hashMap.put(GeolocationPermissions.CALLBACK, valueCallback);
                                Set set2 = hashMap.put(GeolocationPermissions.ORIGINS, set);
                                GeolocationPermissions geolocationPermissions = GeolocationPermissions.this;
                                Message message2 = Message.obtain(null, 0, hashMap);
                                geolocationPermissions.postUIMessage(message2);
                                return;
                            }
                            case 1: {
                                Map map = (Map)message.obj;
                                String string2 = (String)map.get(GeolocationPermissions.ORIGIN);
                                ValueCallback valueCallback = (ValueCallback)map.get(GeolocationPermissions.CALLBACK);
                                boolean bl = GeolocationPermissions.nativeGetAllowed(string2);
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                ValueCallback valueCallback3 = hashMap.put(GeolocationPermissions.CALLBACK, valueCallback);
                                Boolean bl2 = new Boolean(bl);
                                Boolean bl3 = hashMap.put(GeolocationPermissions.ALLOWED, bl2);
                                GeolocationPermissions geolocationPermissions = GeolocationPermissions.this;
                                Message message3 = Message.obtain(null, 1, hashMap);
                                geolocationPermissions.postUIMessage(message3);
                                return;
                            }
                            case 2: {
                                GeolocationPermissions.nativeClear((String)message.obj);
                                return;
                            }
                            case 3: {
                                GeolocationPermissions.nativeAllow((String)message.obj);
                                return;
                            }
                            case 4: 
                        }
                        GeolocationPermissions.nativeClearAll();
                    }
                };
                if (this.mQueuedMessages != null) {
                    while (!this.mQueuedMessages.isEmpty()) {
                        Handler handler2 = this.mHandler;
                        Message message = this.mQueuedMessages.remove(0);
                        boolean bl = handler2.sendMessage(message);
                    }
                    Object var6_5 = null;
                    this.mQueuedMessages = var6_5;
                }
            }
            return;
        }
    }

    public void createUIHandler() {
        Handler handler;
        if (this.mUIHandler != null) {
            return;
        }
        this.mUIHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 0: {
                        Map map = (Map)message.obj;
                        Set set = (Set)map.get(GeolocationPermissions.ORIGINS);
                        ((ValueCallback)map.get(GeolocationPermissions.CALLBACK)).onReceiveValue(set);
                        return;
                    }
                    case 1: 
                }
                Map map = (Map)message.obj;
                Boolean bl = (Boolean)map.get(GeolocationPermissions.ALLOWED);
                ((ValueCallback)map.get(GeolocationPermissions.CALLBACK)).onReceiveValue(bl);
            }
        };
    }

    public void getAllowed(String string2, ValueCallback<Boolean> valueCallback) {
        if (valueCallback == null) {
            return;
        }
        if (string2 == null) {
            valueCallback.onReceiveValue(null);
            return;
        }
        String string3 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string3)) {
            boolean bl = GeolocationPermissions.nativeGetAllowed(string2);
            Boolean bl2 = new Boolean(bl);
            valueCallback.onReceiveValue(bl2);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string4 = hashMap.put(ORIGIN, string2);
        ValueCallback<Boolean> valueCallback2 = hashMap.put(CALLBACK, valueCallback);
        Message message = Message.obtain(null, 1, hashMap);
        this.postMessage(message);
    }

    public void getOrigins(ValueCallback<Set<String>> valueCallback) {
        if (valueCallback == null) {
            return;
        }
        String string2 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string2)) {
            Set set = GeolocationPermissions.nativeGetOrigins();
            valueCallback.onReceiveValue(set);
            return;
        }
        Message message = Message.obtain(null, 0, valueCallback);
        this.postMessage(message);
    }

    public static interface Callback {
        public void invoke(String var1, boolean var2, boolean var3);
    }
}

