/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityThread;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;

final class GeolocationService
implements LocationListener {
    private static final String TAG = "geolocationService";
    private boolean mIsGpsEnabled;
    private boolean mIsGpsProviderAvailable;
    private boolean mIsNetworkProviderAvailable;
    private boolean mIsRunning;
    private LocationManager mLocationManager;
    private long mNativeObject;

    public GeolocationService(long l) {
        LocationManager locationManager;
        this.mNativeObject = l;
        this.mLocationManager = locationManager = (LocationManager)((Context)ActivityThread.systemMain().getApplication()).getSystemService("location");
        if (this.mLocationManager != null) {
            return;
        }
        int n = Log.e(TAG, "Could not get location manager.");
    }

    private void maybeReportError(String string2) {
        if (!this.mIsRunning) {
            return;
        }
        if (this.mIsNetworkProviderAvailable) {
            return;
        }
        if (this.mIsGpsProviderAvailable) {
            return;
        }
        GeolocationService.nativeNewErrorAvailable(this.mNativeObject, string2);
    }

    private static native void nativeNewErrorAvailable(long var0, String var2);

    private static native void nativeNewLocationAvailable(long var0, Location var2);

    private void registerForLocationUpdates() {
        try {
            LocationManager locationManager = this.mLocationManager;
            GeolocationService geolocationService = this;
            locationManager.requestLocationUpdates("network", 0L, 0.0f, geolocationService);
            this.mIsNetworkProviderAvailable = true;
            if (!this.mIsGpsEnabled) {
                return;
            }
            LocationManager locationManager2 = this.mLocationManager;
            GeolocationService geolocationService2 = this;
            locationManager2.requestLocationUpdates("gps", 0L, 0.0f, geolocationService2);
            this.mIsGpsProviderAvailable = true;
            return;
        }
        catch (SecurityException securityException) {
            int n = Log.e(TAG, "Caught security exception registering for location updates from system. This should only happen in DumpRenderTree.");
            return;
        }
    }

    private void unregisterFromLocationUpdates() {
        this.mLocationManager.removeUpdates(this);
    }

    @Override
    public void onLocationChanged(Location location) {
        if (!this.mIsRunning) {
            return;
        }
        GeolocationService.nativeNewLocationAvailable(this.mNativeObject, location);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onProviderDisabled(String string2) {
        if ("network".equals(string2)) {
            this.mIsNetworkProviderAvailable = false;
        } else if ("gps".equals(string2)) {
            this.mIsGpsProviderAvailable = false;
        }
        this.maybeReportError("The last location provider was disabled");
    }

    @Override
    public void onProviderEnabled(String string2) {
        if ("network".equals(string2)) {
            this.mIsNetworkProviderAvailable = true;
            return;
        }
        if (!"gps".equals(string2)) {
            return;
        }
        this.mIsGpsProviderAvailable = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onStatusChanged(String string2, int n, Bundle bundle) {
        boolean bl = n == 2;
        if ("network".equals(string2)) {
            this.mIsNetworkProviderAvailable = bl;
        } else if ("gps".equals(string2)) {
            this.mIsGpsProviderAvailable = bl;
        }
        this.maybeReportError("The last location provider is no longer available");
    }

    public void setEnableGps(boolean bl) {
        if (this.mIsGpsEnabled != bl) {
            return;
        }
        this.mIsGpsEnabled = bl;
        if (!this.mIsRunning) {
            return;
        }
        this.unregisterFromLocationUpdates();
        this.registerForLocationUpdates();
    }

    public void start() {
        this.registerForLocationUpdates();
        this.mIsRunning = true;
    }

    public void stop() {
        this.unregisterFromLocationUpdates();
        this.mIsRunning = false;
    }
}

