/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

class HTML5Audio
extends Handler
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnSeekCompleteListener {
    private static int COMPLETE = 0;
    private static int ERROR = 0;
    private static int IDLE = 0;
    private static int INITIALIZED = 0;
    private static final String LOGTAG = "HTML5Audio";
    private static int PAUSED = 0;
    private static int PREPARED = 0;
    private static int STARTED = 0;
    private static int STOPPED = 0;
    private static final int TIMEUPDATE = 100;
    private static final int TIMEUPDATE_PERIOD = 250;
    private boolean mAskToPlay;
    private MediaPlayer mMediaPlayer;
    private int mNativePointer;
    private int mState;
    private Timer mTimer;
    private String mUrl;

    static {
        IDLE = 0;
        INITIALIZED = 1;
        PREPARED = 2;
        STARTED = 4;
        COMPLETE = 5;
        PAUSED = 6;
        STOPPED = -1;
        ERROR = -1;
    }

    public HTML5Audio(int n) {
        int n2;
        this.mState = n2 = IDLE;
        this.mAskToPlay = false;
        this.mNativePointer = n;
        this.resetMediaPlayer();
    }

    private float getMaxTimeSeekable() {
        return (float)this.mMediaPlayer.getDuration() / 1000.0f;
    }

    private native void nativeOnBuffering(int var1, int var2);

    private native void nativeOnEnded(int var1);

    private native void nativeOnPrepared(int var1, int var2, int var3, int var4);

    private native void nativeOnTimeupdate(int var1, int var2);

    private void pause() {
        int n;
        int n2 = this.mState;
        int n3 = STARTED;
        if (n2 != n3) {
            return;
        }
        if (this.mTimer != null) {
            int n4 = this.mTimer.purge();
        }
        this.mMediaPlayer.pause();
        this.mState = n = PAUSED;
    }

    private void play() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.mState;
        int n7 = ERROR;
        if ((n6 == n7 || (n5 = this.mState) != (n4 = IDLE)) && this.mUrl != null) {
            this.resetMediaPlayer();
            String string2 = this.mUrl;
            this.setDataSource(string2);
            this.mAskToPlay = true;
        }
        if ((n3 = this.mState) < (n2 = PREPARED)) {
            return;
        }
        this.mMediaPlayer.start();
        this.mState = n = STARTED;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resetMediaPlayer() {
        int n;
        Timer timer;
        if (this.mMediaPlayer == null) {
            MediaPlayer mediaPlayer;
            this.mMediaPlayer = mediaPlayer = new MediaPlayer();
        } else {
            this.mMediaPlayer.reset();
        }
        this.mMediaPlayer.setOnBufferingUpdateListener(this);
        this.mMediaPlayer.setOnCompletionListener(this);
        this.mMediaPlayer.setOnErrorListener(this);
        this.mMediaPlayer.setOnPreparedListener(this);
        this.mMediaPlayer.setOnSeekCompleteListener(this);
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = timer = new Timer();
        this.mState = n = IDLE;
    }

    private void seek(int n) {
        int n2 = this.mState;
        int n3 = PREPARED;
        if (n2 < n3) {
            return;
        }
        this.mMediaPlayer.seekTo(n);
    }

    private void setDataSource(String string2) {
        this.mUrl = string2;
        try {
            int n;
            int n2 = this.mState;
            int n3 = IDLE;
            if (n2 != n3) {
                this.resetMediaPlayer();
            }
            this.mMediaPlayer.setDataSource(string2);
            this.mState = n = INITIALIZED;
            this.mMediaPlayer.prepareAsync();
            return;
        }
        catch (IOException iOException) {
            String string3 = "couldn't load the resource: " + string2 + " exc: " + iOException;
            int n = Log.e(LOGTAG, string3);
            this.resetMediaPlayer();
            return;
        }
    }

    private void teardown() {
        int n;
        this.mMediaPlayer.release();
        this.mState = n = ERROR;
        this.mNativePointer = 0;
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 100: 
        }
        try {
            int n = this.mState;
            int n2 = ERROR;
            if (n != n2) {
                return;
            }
            if (!this.mMediaPlayer.isPlaying()) {
                return;
            }
            int n3 = this.mMediaPlayer.getCurrentPosition();
            int n4 = this.mNativePointer;
            this.nativeOnTimeupdate(n3, n4);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            int n;
            this.mState = n = ERROR;
            return;
        }
    }

    @Override
    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        int n2 = this.mNativePointer;
        this.nativeOnBuffering(n, n2);
    }

    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        int n;
        this.resetMediaPlayer();
        this.mState = n = IDLE;
        int n2 = this.mNativePointer;
        this.nativeOnEnded(n2);
    }

    @Override
    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        int n4;
        this.mState = n4 = ERROR;
        this.resetMediaPlayer();
        this.mState = n3 = IDLE;
        return false;
    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        int n;
        this.mState = n = PREPARED;
        if (this.mTimer != null) {
            Timer timer = this.mTimer;
            TimeupdateTask timeupdateTask = new TimeupdateTask();
            long l = 250L;
            timer.schedule((TimerTask)timeupdateTask, 250L, l);
        }
        int n2 = mediaPlayer.getDuration();
        int n3 = this.mNativePointer;
        this.nativeOnPrepared(n2, 0, 0, n3);
        if (!this.mAskToPlay) {
            return;
        }
        this.mAskToPlay = false;
        this.play();
    }

    @Override
    public void onSeekComplete(MediaPlayer mediaPlayer) {
        int n = mediaPlayer.getCurrentPosition();
        int n2 = this.mNativePointer;
        this.nativeOnTimeupdate(n, n2);
    }

    private final class TimeupdateTask
    extends TimerTask {
        private TimeupdateTask() {
        }

        @Override
        public void run() {
            HTML5Audio.this.obtainMessage(100).sendToTarget();
        }
    }
}

