/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.RequestHandle;
import android.net.http.RequestQueue;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.VideoView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

class HTML5VideoViewProxy
extends Handler
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private static final String COOKIE = "Cookie";
    private static final int ENDED = 201;
    private static final int ERROR = 103;
    private static final int LOAD_DEFAULT_POSTER = 104;
    private static final String LOGTAG = "HTML5VideoViewProxy";
    private static final int PAUSE = 102;
    private static final int PAUSED = 203;
    private static final int PLAY = 100;
    private static final int POSTER_FETCHED = 202;
    private static final int PREPARED = 200;
    private static final int SEEK = 101;
    private static final int TIMEUPDATE = 300;
    int mNativePointer;
    private Bitmap mPoster;
    private PosterDownloader mPosterDownloader;
    private int mSeekPosition;
    private Handler mWebCoreHandler;
    private WebView mWebView;

    private HTML5VideoViewProxy(WebView webView, int n) {
        Looper looper = Looper.getMainLooper();
        super(looper);
        this.mWebView = webView;
        this.mNativePointer = n;
        this.createWebCoreHandler();
    }

    private void createWebCoreHandler() {
        Handler handler;
        this.mWebCoreHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 200: {
                        Map map = (Map)message.obj;
                        Integer n = (Integer)map.get("dur");
                        Integer n2 = (Integer)map.get("width");
                        Integer n3 = (Integer)map.get("height");
                        HTML5VideoViewProxy hTML5VideoViewProxy = HTML5VideoViewProxy.this;
                        int n4 = n;
                        int n5 = n2;
                        int n6 = n3;
                        int n7 = HTML5VideoViewProxy.this.mNativePointer;
                        hTML5VideoViewProxy.nativeOnPrepared(n4, n5, n6, n7);
                        return;
                    }
                    case 201: {
                        HTML5VideoViewProxy hTML5VideoViewProxy = HTML5VideoViewProxy.this;
                        int n = HTML5VideoViewProxy.this.mNativePointer;
                        hTML5VideoViewProxy.nativeOnEnded(n);
                        return;
                    }
                    case 203: {
                        HTML5VideoViewProxy hTML5VideoViewProxy = HTML5VideoViewProxy.this;
                        int n = HTML5VideoViewProxy.this.mNativePointer;
                        hTML5VideoViewProxy.nativeOnPaused(n);
                        return;
                    }
                    case 202: {
                        Bitmap bitmap = (Bitmap)message.obj;
                        HTML5VideoViewProxy hTML5VideoViewProxy = HTML5VideoViewProxy.this;
                        int n = HTML5VideoViewProxy.this.mNativePointer;
                        hTML5VideoViewProxy.nativeOnPosterFetched(bitmap, n);
                        return;
                    }
                    case 300: 
                }
                HTML5VideoViewProxy hTML5VideoViewProxy = HTML5VideoViewProxy.this;
                int n = message.arg1;
                int n8 = HTML5VideoViewProxy.this.mNativePointer;
                hTML5VideoViewProxy.nativeOnTimeupdate(n, n8);
            }
        };
    }

    private void doSetPoster(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        this.mPoster = bitmap;
        Message message = Message.obtain(this.mWebCoreHandler, 202);
        message.obj = bitmap;
        boolean bl = this.mWebCoreHandler.sendMessage(message);
    }

    public static HTML5VideoViewProxy getInstance(WebViewCore webViewCore, int n) {
        WebView webView = webViewCore.getWebView();
        return new HTML5VideoViewProxy(webView, n);
    }

    private native void nativeOnEnded(int var1);

    private native void nativeOnPaused(int var1);

    private native void nativeOnPosterFetched(Bitmap var1, int var2);

    private native void nativeOnPrepared(int var1, int var2, int var3, int var4);

    private native void nativeOnTimeupdate(int var1, int var2);

    private void sendTimeupdate() {
        int n;
        Message message = Message.obtain(this.mWebCoreHandler, 300);
        message.arg1 = n = VideoPlayer.getCurrentPosition();
        boolean bl = this.mWebCoreHandler.sendMessage(message);
    }

    public void dispatchOnEnded() {
        Message message = Message.obtain(this.mWebCoreHandler, 201);
        boolean bl = this.mWebCoreHandler.sendMessage(message);
    }

    public void dispatchOnPaused() {
        Message message = Message.obtain(this.mWebCoreHandler, 203);
        boolean bl = this.mWebCoreHandler.sendMessage(message);
    }

    public Context getContext() {
        return this.mWebView.getContext();
    }

    WebView getWebView() {
        return this.mWebView;
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 100: {
                String string2 = (String)message.obj;
                WebChromeClient webChromeClient = this.mWebView.getWebChromeClient();
                if (webChromeClient == null) {
                    return;
                }
                int n = this.mSeekPosition;
                VideoPlayer.play(string2, n, this, webChromeClient);
                return;
            }
            case 101: {
                int n;
                this.mSeekPosition = n = ((Integer)message.obj).intValue();
                VideoPlayer.seek(this.mSeekPosition, this);
                return;
            }
            case 102: {
                VideoPlayer.pause(this);
                return;
            }
            case 201: {
                if (message.arg1 == 1) {
                    VideoPlayer.isVideoSelfEnded = true;
                }
            }
            case 103: {
                WebChromeClient webChromeClient = this.mWebView.getWebChromeClient();
                if (webChromeClient == null) {
                    return;
                }
                webChromeClient.onHideCustomView();
                return;
            }
            case 104: {
                WebChromeClient webChromeClient = this.mWebView.getWebChromeClient();
                if (webChromeClient == null) {
                    return;
                }
                Bitmap bitmap = webChromeClient.getDefaultVideoPoster();
                this.doSetPoster(bitmap);
                return;
            }
            case 300: 
        }
        if (!VideoPlayer.isPlaying(this)) {
            return;
        }
        this.sendTimeupdate();
    }

    public void loadPoster(String string2) {
        PosterDownloader posterDownloader;
        if (string2 == null) {
            Message message = this.obtainMessage(104);
            boolean bl = this.sendMessage(message);
            return;
        }
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mPosterDownloader = posterDownloader = new PosterDownloader(string2, this);
        this.mPosterDownloader.start();
    }

    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        Message message = this.obtainMessage(201, 1, 0);
        boolean bl = this.sendMessage(message);
    }

    @Override
    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        Message message = this.obtainMessage(103);
        boolean bl = this.sendMessage(message);
        return false;
    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        VideoPlayer.onPrepared();
        Message message = Message.obtain(this.mWebCoreHandler, 200);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = mediaPlayer.getDuration();
        Integer n2 = new Integer(n);
        Integer n3 = hashMap.put("dur", n2);
        int n4 = mediaPlayer.getVideoWidth();
        Integer n5 = new Integer(n4);
        Integer n6 = hashMap.put("width", n5);
        int n7 = mediaPlayer.getVideoHeight();
        Integer n8 = new Integer(n7);
        Integer n9 = hashMap.put("height", n8);
        message.obj = hashMap;
        boolean bl = this.mWebCoreHandler.sendMessage(message);
    }

    public void onTimeupdate() {
        Message message = this.obtainMessage(300);
        boolean bl = this.sendMessage(message);
    }

    public void pause() {
        Message message = this.obtainMessage(102);
        boolean bl = this.sendMessage(message);
    }

    public void play(String string2) {
        if (string2 == null) {
            return;
        }
        Message message = this.obtainMessage(100);
        message.obj = string2;
        boolean bl = this.sendMessage(message);
    }

    public void seek(int n) {
        Message message = this.obtainMessage(101);
        Integer n2 = new Integer(n);
        message.obj = n2;
        boolean bl = this.sendMessage(message);
    }

    public void teardown() {
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mNativePointer = 0;
    }

    private static final class PosterDownloader
    implements EventHandler {
        private static int mQueueRefCount = 0;
        private static RequestQueue mRequestQueue;
        private Handler mHandler;
        private Headers mHeaders;
        private ByteArrayOutputStream mPosterBytes;
        private final HTML5VideoViewProxy mProxy;
        private RequestHandle mRequestHandle;
        private int mStatusCode;
        private String mUrl;

        public PosterDownloader(String string2, HTML5VideoViewProxy hTML5VideoViewProxy) {
            Handler handler;
            this.mUrl = string2;
            this.mProxy = hTML5VideoViewProxy;
            this.mHandler = handler = new Handler();
        }

        /*
         * Unable to fully structure code
         */
        private void cleanup() {
            if (this.mPosterBytes == null) {
                return;
            }
            try {
                this.mPosterBytes.close();
lbl5:
                // 2 sources

                while (true) {
                    this.mPosterBytes = null;
                    return;
                }
            }
            catch (Throwable var1_1) {
                this.mPosterBytes = null;
                throw var1_1;
            }
            catch (IOException var2_2) {
                ** continue;
            }
        }

        private void releaseQueue() {
            int n;
            if (mQueueRefCount == 0) {
                return;
            }
            mQueueRefCount = n = mQueueRefCount - 1;
            if (n != 0) {
                return;
            }
            mRequestQueue.shutdown();
            mRequestQueue = null;
        }

        private void retainQueue() {
            if (mRequestQueue == null) {
                Context context = this.mProxy.getContext();
                mRequestQueue = new RequestQueue(context);
            }
            ++mQueueRefCount;
        }

        public void cancelAndReleaseQueue() {
            if (this.mRequestHandle != null) {
                this.mRequestHandle.cancel();
                this.mRequestHandle = null;
            }
            this.releaseQueue();
        }

        @Override
        public void certificate(SslCertificate sslCertificate) {
        }

        @Override
        public void data(byte[] byArray, int n) {
            if (this.mPosterBytes == null) {
                ByteArrayOutputStream byteArrayOutputStream;
                this.mPosterBytes = byteArrayOutputStream = new ByteArrayOutputStream();
            }
            this.mPosterBytes.write(byArray, 0, n);
        }

        @Override
        public void endData() {
            String string2;
            if (this.mStatusCode == 200) {
                if (this.mPosterBytes.size() > 0) {
                    byte[] byArray = this.mPosterBytes.toByteArray();
                    int n = this.mPosterBytes.size();
                    Bitmap bitmap = BitmapFactory.decodeByteArray(byArray, 0, n);
                    this.mProxy.doSetPoster(bitmap);
                }
                this.cleanup();
                return;
            }
            if (this.mStatusCode < 300) {
                return;
            }
            if (this.mStatusCode >= 400) {
                return;
            }
            this.mUrl = string2 = this.mHeaders.getLocation();
            if (this.mUrl == null) {
                return;
            }
            Handler handler = this.mHandler;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (PosterDownloader.this.mRequestHandle == null) {
                        return;
                    }
                    RequestHandle requestHandle = PosterDownloader.this.mRequestHandle;
                    String string2 = PosterDownloader.this.mUrl;
                    int n = PosterDownloader.this.mStatusCode;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    boolean bl = requestHandle.setupRedirect(string2, n, hashMap);
                }
            };
            boolean bl = handler.post(runnable);
        }

        @Override
        public void error(int n, String string2) {
            this.cleanup();
        }

        @Override
        public boolean handleSslErrorRequest(SslError sslError) {
            return false;
        }

        @Override
        public void headers(Headers headers) {
            this.mHeaders = headers;
        }

        public void start() {
            RequestHandle requestHandle;
            this.retainQueue();
            RequestQueue requestQueue = mRequestQueue;
            String string2 = this.mUrl;
            PosterDownloader posterDownloader = this;
            InputStream inputStream = null;
            this.mRequestHandle = requestHandle = requestQueue.queueRequest(string2, "GET", null, posterDownloader, inputStream, 0);
        }

        @Override
        public void status(int n, int n2, int n3, String string2) {
            this.mStatusCode = n3;
        }
    }

    private static final class VideoPlayer {
        private static final int TIMEUPDATE_PERIOD = 250;
        static boolean isVideoSelfEnded = false;
        private static final WebChromeClient.CustomViewCallback mCallback = new WebChromeClient.CustomViewCallback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onCustomViewHidden() {
                mTimer.cancel();
                Timer timer = VideoPlayer.access$002(null);
                if (mVideoView.isPlaying()) {
                    mVideoView.stopPlayback();
                }
                if (isVideoSelfEnded) {
                    mCurrentProxy.dispatchOnEnded();
                } else {
                    mCurrentProxy.dispatchOnPaused();
                }
                mCurrentProxy.getWebView().getViewManager().showAll();
                isVideoSelfEnded = false;
                HTML5VideoViewProxy hTML5VideoViewProxy = VideoPlayer.access$202(null);
                FrameLayout frameLayout = mLayout;
                VideoView videoView = mVideoView;
                frameLayout.removeView(videoView);
                VideoView videoView2 = VideoPlayer.access$102(null);
                if (mProgressView != null) {
                    FrameLayout frameLayout2 = mLayout;
                    View view = mProgressView;
                    frameLayout2.removeView(view);
                    View view2 = VideoPlayer.access$402(null);
                }
                FrameLayout frameLayout3 = VideoPlayer.access$302(null);
            }
        };
        private static HTML5VideoViewProxy mCurrentProxy;
        private static FrameLayout mLayout;
        private static View mProgressView;
        private static Timer mTimer;
        private static VideoView mVideoView;

        private VideoPlayer() {
        }

        static /* synthetic */ Timer access$002(Timer timer) {
            mTimer = timer;
            return timer;
        }

        static /* synthetic */ VideoView access$102(VideoView videoView) {
            mVideoView = videoView;
            return videoView;
        }

        static /* synthetic */ HTML5VideoViewProxy access$202(HTML5VideoViewProxy hTML5VideoViewProxy) {
            mCurrentProxy = hTML5VideoViewProxy;
            return hTML5VideoViewProxy;
        }

        static /* synthetic */ FrameLayout access$302(FrameLayout frameLayout) {
            mLayout = frameLayout;
            return frameLayout;
        }

        static /* synthetic */ View access$402(View view) {
            mProgressView = view;
            return view;
        }

        public static int getCurrentPosition() {
            int n = 0;
            if (mVideoView != null) {
                n = mVideoView.getCurrentPosition();
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean isPlaying(HTML5VideoViewProxy hTML5VideoViewProxy) {
            if (mCurrentProxy != hTML5VideoViewProxy) return false;
            if (mVideoView == null) return false;
            if (!mVideoView.isPlaying()) return false;
            return true;
        }

        public static void onPrepared() {
            if (mProgressView == null) {
                return;
            }
            if (mLayout == null) {
                return;
            }
            Timer timer = mTimer;
            HTML5VideoViewProxy hTML5VideoViewProxy = mCurrentProxy;
            TimeupdateTask timeupdateTask = new TimeupdateTask(hTML5VideoViewProxy);
            long l = 250L;
            timer.schedule((TimerTask)timeupdateTask, 250L, l);
            mProgressView.setVisibility(8);
            FrameLayout frameLayout = mLayout;
            View view = mProgressView;
            frameLayout.removeView(view);
            mProgressView = null;
        }

        public static void pause(HTML5VideoViewProxy hTML5VideoViewProxy) {
            if (mCurrentProxy != hTML5VideoViewProxy) {
                return;
            }
            if (mVideoView == null) {
                return;
            }
            mVideoView.pause();
            int n = mTimer.purge();
        }

        public static void play(String string2, int n, HTML5VideoViewProxy hTML5VideoViewProxy, WebChromeClient webChromeClient) {
            if (mCurrentProxy == hTML5VideoViewProxy) {
                if (mVideoView.isPlaying()) {
                    return;
                }
                mVideoView.start();
                return;
            }
            if (mCurrentProxy != null) {
                hTML5VideoViewProxy.dispatchOnEnded();
                return;
            }
            mCurrentProxy = hTML5VideoViewProxy;
            Context context = hTML5VideoViewProxy.getContext();
            mLayout = new FrameLayout(context);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
            Context context2 = hTML5VideoViewProxy.getContext();
            mVideoView = new VideoView(context2);
            mVideoView.setWillNotDraw(false);
            VideoView videoView = mVideoView;
            Context context3 = hTML5VideoViewProxy.getContext();
            MediaController mediaController = new MediaController(context3);
            videoView.setMediaController(mediaController);
            String string3 = CookieManager.getInstance().getCookie(string2);
            HashMap<String, String> hashMap = null;
            if (string3 != null) {
                hashMap = new HashMap<String, String>();
                String string4 = hashMap.put(HTML5VideoViewProxy.COOKIE, string3);
            }
            VideoView videoView2 = mVideoView;
            Uri uri = Uri.parse(string2);
            videoView2.setVideoURI(uri, hashMap);
            mVideoView.setOnCompletionListener(hTML5VideoViewProxy);
            mVideoView.setOnPreparedListener(hTML5VideoViewProxy);
            mVideoView.setOnErrorListener(hTML5VideoViewProxy);
            mVideoView.seekTo(n);
            FrameLayout frameLayout = mLayout;
            VideoView videoView3 = mVideoView;
            frameLayout.addView((View)videoView3, layoutParams);
            mProgressView = webChromeClient.getVideoLoadingProgressView();
            if (mProgressView != null) {
                FrameLayout frameLayout2 = mLayout;
                View view = mProgressView;
                frameLayout2.addView(view, layoutParams);
                mProgressView.setVisibility(0);
            }
            mLayout.setVisibility(0);
            mTimer = new Timer();
            mVideoView.start();
            FrameLayout frameLayout3 = mLayout;
            WebChromeClient.CustomViewCallback customViewCallback = mCallback;
            webChromeClient.onShowCustomView(frameLayout3, customViewCallback);
            mCurrentProxy.getWebView().getViewManager().hideAll();
        }

        public static void seek(int n, HTML5VideoViewProxy hTML5VideoViewProxy) {
            if (mCurrentProxy != hTML5VideoViewProxy) {
                return;
            }
            if (n < 0) {
                return;
            }
            if (mVideoView == null) {
                return;
            }
            mVideoView.seekTo(n);
        }

        private static final class TimeupdateTask
        extends TimerTask {
            private HTML5VideoViewProxy mProxy;

            public TimeupdateTask(HTML5VideoViewProxy hTML5VideoViewProxy) {
                this.mProxy = hTML5VideoViewProxy;
            }

            @Override
            public void run() {
                this.mProxy.onTimeupdate();
            }
        }
    }
}

