/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.CallbackProxy;
import android.webkit.LoadListener;
import android.webkit.Network;
import java.util.LinkedList;

public class HttpAuthHandler
extends Handler {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int AUTH_CANCEL = 200;
    private static final int AUTH_PROCEED = 100;
    private static final String LOGTAG = "network";
    private LinkedList<LoadListener> mLoaderQueue;
    private Network mNetwork;
    String mPassword;
    boolean mRequestInFlight;
    Object mRequestInFlightLock;
    String mUsername;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !HttpAuthHandler.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    HttpAuthHandler(Network network) {
        Object object;
        this.mRequestInFlightLock = object = new Object();
        this.mNetwork = network;
        LinkedList linkedList = new LinkedList();
        this.mLoaderQueue = linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleResponseForSynchronousRequest(String string2, String string3) {
        LoadListener loadListener;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            loadListener = this.mLoaderQueue.peek();
        }
        if (!loadListener.isSynchronous()) return false;
        this.mUsername = string2;
        this.mPassword = string3;
        return true;
    }

    public static void onReceivedCredentials(LoadListener loadListener, String string2, String string3, String string4, String string5) {
        loadListener.getFrame().getCallbackProxy().onReceivedHttpAuthCredentials(string2, string3, string4, string5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processNextLoader() {
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        // MONITORENTER : linkedList
        LoadListener loadListener = this.mLoaderQueue.peek();
        // MONITOREXIT : linkedList
        if (loadListener == null) {
            return;
        }
        Object object = this.mRequestInFlightLock;
        // MONITORENTER : object
        if (!$assertionsDisabled && this.mRequestInFlight) {
            throw new AssertionError();
        }
        linkedList = null;
        this.mRequestInFlight = linkedList;
        // MONITOREXIT : object
        CallbackProxy callbackProxy = loadListener.getFrame().getCallbackProxy();
        String string2 = loadListener.proxyAuthenticate() ? this.mNetwork.getProxyHostname() : loadListener.host();
        String string3 = loadListener.realm();
        callbackProxy.onReceivedHttpAuthRequest(this, string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void signalRequestComplete() {
        Object object = this.mRequestInFlightLock;
        synchronized (object) {
            boolean bl;
            if (!$assertionsDisabled && !this.mRequestInFlight) {
                throw new AssertionError();
            }
            this.mRequestInFlight = bl = false;
            this.mRequestInFlightLock.notify();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForRequestToComplete() {
        Object object = this.mRequestInFlightLock;
        synchronized (object) {
            boolean bl;
            while (bl = this.mRequestInFlight) {
                try {
                    this.mRequestInFlightLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    int n = Log.e(LOGTAG, "Interrupted while waiting for request to complete");
                    continue;
                }
                break;
            }
            return;
        }
    }

    public void cancel() {
        if (this.handleResponseForSynchronousRequest(null, null)) {
            this.signalRequestComplete();
            return;
        }
        Message message = this.obtainMessage(200);
        boolean bl = this.sendMessage(message);
        this.signalRequestComplete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void handleAuthRequest(LoadListener loadListener) {
        if (loadListener.isSynchronous()) {
            this.waitForRequestToComplete();
            LinkedList<LoadListener> linkedList = this.mLoaderQueue;
            // MONITORENTER : linkedList
            this.mLoaderQueue.addFirst(loadListener);
            // MONITOREXIT : linkedList
            this.processNextLoader();
            this.waitForRequestToComplete();
            LinkedList<LoadListener> linkedList2 = this.mLoaderQueue;
            // MONITORENTER : linkedList2
            if (!$assertionsDisabled && this.mLoaderQueue.peek() != loadListener) {
                throw new AssertionError();
            }
            LoadListener loadListener2 = this.mLoaderQueue.poll();
            // MONITOREXIT : linkedList2
            String string2 = this.mUsername;
            String string3 = this.mPassword;
            loadListener.handleAuthResponse(string2, string3);
            return;
        }
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        // MONITORENTER : linkedList
        boolean bl = this.mLoaderQueue.offer(loadListener);
        boolean bl2 = this.mLoaderQueue.size() == 1;
        // MONITOREXIT : linkedList
        if (!bl2) {
            return;
        }
        this.processNextLoader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void handleMessage(Message message) {
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        // MONITORENTER : linkedList
        LoadListener loadListener = this.mLoaderQueue.poll();
        // MONITOREXIT : linkedList
        if (!$assertionsDisabled && loadListener.isSynchronous()) {
            throw new AssertionError();
        }
        switch (message.what) {
            case 100: {
                String string2 = message.getData().getString("username");
                String string3 = message.getData().getString("password");
                loadListener.handleAuthResponse(string2, string3);
            }
            default: {
                break;
            }
            case 200: {
                loadListener.handleAuthResponse(null, null);
            }
        }
        this.processNextLoader();
    }

    public void proceed(String string2, String string3) {
        if (this.handleResponseForSynchronousRequest(string2, string3)) {
            this.signalRequestComplete();
            return;
        }
        Message message = this.obtainMessage(100);
        message.getData().putString("username", string2);
        message.getData().putString("password", string3);
        boolean bl = this.sendMessage(message);
        this.signalRequestComplete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean useHttpAuthUsernamePassword() {
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        // MONITORENTER : linkedList
        LoadListener loadListener = this.mLoaderQueue.peek();
        // MONITOREXIT : linkedList
        if (loadListener == null) {
            return false;
        }
        if (loadListener.authCredentialsInvalid()) return false;
        return true;
    }
}

