/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.HttpAuthHeader;
import android.net.http.RequestHandle;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.BrowserFrame;
import android.webkit.ByteArrayBuilder;
import android.webkit.CacheLoader;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.CertTool;
import android.webkit.CookieManager;
import android.webkit.HttpAuthHandler;
import android.webkit.MimeTypeMap;
import android.webkit.Network;
import android.webkit.PerfChecker;
import android.webkit.URLUtil;
import android.webkit.WebViewWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LoadListener
extends Handler
implements EventHandler {
    private static final Pattern CONTENT_TYPE_PATTERN;
    private static final int HTTP_AUTH = 401;
    private static final int HTTP_FOUND = 302;
    private static final int HTTP_MOVED_PERMANENTLY = 301;
    private static final int HTTP_NOT_FOUND = 404;
    private static final int HTTP_NOT_MODIFIED = 304;
    private static final int HTTP_OK = 200;
    private static final int HTTP_PARTIAL_CONTENT = 206;
    private static final int HTTP_PROXY_AUTH = 407;
    private static final int HTTP_SEE_OTHER = 303;
    private static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final String LOGTAG = "webkit";
    private static final int MSG_CONTENT_DATA = 110;
    private static final int MSG_CONTENT_ERROR = 130;
    private static final int MSG_CONTENT_FINISHED = 120;
    private static final int MSG_CONTENT_HEADERS = 100;
    private static final int MSG_LOCATION_CHANGED = 140;
    private static final int MSG_LOCATION_CHANGED_REQUEST = 150;
    private static final int MSG_SSL_CERTIFICATE = 170;
    private static final int MSG_SSL_ERROR = 180;
    private static final int MSG_STATUS = 160;
    private static final String XML_MIME_TYPE = "^[\\w_\\-+~!$\\^{}|.%'`#&*]+/[\\w_\\-+~!$\\^{}|.%'`#&*]+\\+xml$";
    private static HashMap<String, String> sCertificateTypeMap;
    private static int sNativeLoaderCount;
    private boolean mAuthFailed;
    private HttpAuthHeader mAuthHeader;
    private BrowserFrame mBrowserFrame;
    private CacheLoader mCacheLoader;
    private int mCacheRedirectCount;
    private boolean mCancelled;
    public long mContentLength;
    private Context mContext;
    private final ByteArrayBuilder mDataBuilder;
    private String mEncoding;
    private String mErrorDescription;
    private int mErrorID;
    private boolean mFromCache;
    private Headers mHeaders;
    private boolean mIsMainPageLoader;
    private final boolean mIsMainResourceLoader;
    private Vector<Message> mMessageQueue;
    private String mMethod;
    private String mMimeType;
    private int mNativeLoader;
    private String mOriginalUrl;
    private final String mPassword;
    private boolean mPermanent;
    private byte[] mPostData;
    private long mPostIdentifier;
    private RequestHandle mRequestHandle;
    private Map<String, String> mRequestHeaders;
    private SslError mSslError;
    private RequestHandle mSslErrorRequestHandle;
    private int mStatusCode;
    private String mStatusText;
    private boolean mSynchronous;
    private String mTransferEncoding;
    private WebAddress mUri;
    private String mUrl;
    private final boolean mUserGesture;
    private final String mUsername;

    static {
        sCertificateTypeMap = new HashMap();
        String string2 = sCertificateTypeMap.put("application/x-x509-ca-cert", "CERT");
        String string3 = sCertificateTypeMap.put("application/x-x509-user-cert", "CERT");
        String string4 = sCertificateTypeMap.put("application/x-pkcs12", "PKCS12");
        CONTENT_TYPE_PATTERN = Pattern.compile("^((?:[xX]-)?[a-zA-Z\\*]+/[\\w\\+\\*-]+[\\.[\\w\\+-]+]*)$");
    }

    LoadListener(Context context, BrowserFrame browserFrame, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, String string3, String string4) {
        ByteArrayBuilder byteArrayBuilder;
        this.mDataBuilder = byteArrayBuilder = new ByteArrayBuilder();
        this.mFromCache = false;
        this.mErrorID = 0;
        this.mContext = context;
        this.mBrowserFrame = browserFrame;
        this.setUrl(string2);
        this.mNativeLoader = n;
        this.mSynchronous = bl;
        if (bl) {
            Vector vector = new Vector();
            this.mMessageQueue = vector;
        }
        this.mIsMainPageLoader = bl2;
        this.mIsMainResourceLoader = bl3;
        this.mUserGesture = bl4;
        this.mPostIdentifier = l;
        this.mUsername = string3;
        this.mPassword = string4;
    }

    private void clearNativeLoader() {
        --sNativeLoaderCount;
        this.mNativeLoader = 0;
    }

    private void commitHeaders() {
        String string2;
        HashMap<String, String> hashMap;
        if (this.mIsMainPageLoader && (hashMap = sCertificateTypeMap).containsKey(string2 = this.mMimeType)) {
            return;
        }
        if (this.mAuthHeader != null) {
            return;
        }
        int n = this.createNativeResponse();
        this.nativeReceivedResponse(n);
    }

    private void commitHeadersCheckRedirect() {
        if (this.mCancelled) {
            return;
        }
        if (this.mStatusCode >= 301 && this.mStatusCode <= 303) {
            return;
        }
        if (this.mStatusCode == 307) {
            return;
        }
        if (this.mStatusCode == 304 && this.mCacheLoader != null) {
            return;
        }
        this.commitHeaders();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitLoad() {
        String string2;
        HashMap<String, String> hashMap;
        String string3;
        if (this.mCancelled) {
            return;
        }
        if (this.mIsMainPageLoader && (string3 = (hashMap = sCertificateTypeMap).get(string2 = this.mMimeType)) != null) {
            ByteArrayBuilder byteArrayBuilder = this.mDataBuilder;
            synchronized (byteArrayBuilder) {
                byte[] byArray = new byte[this.mDataBuilder.getByteSize()];
                int n = 0;
                while (true) {
                    ByteArrayBuilder.Chunk chunk;
                    if ((chunk = this.mDataBuilder.getFirstChunk()) == null) {
                        CertTool.addCertificate(this.mContext, string3, byArray);
                        this.mBrowserFrame.stopLoading();
                        return;
                    }
                    if (chunk.mLength != 0) {
                        byte[] byArray2 = chunk.mArray;
                        int n2 = chunk.mLength;
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                        int n3 = chunk.mLength;
                        int n4 = n + n3;
                    }
                    chunk.release();
                }
            }
        }
        PerfChecker perfChecker = new PerfChecker();
        ByteArrayBuilder.Chunk chunk;
        while ((chunk = this.mDataBuilder.getFirstChunk()) != null) {
            if (chunk.mLength != 0) {
                byte[] byArray = chunk.mArray;
                int n = chunk.mLength;
                this.nativeAddData(byArray, n);
                WebViewWorker.CacheData cacheData = new WebViewWorker.CacheData();
                cacheData.mListener = this;
                cacheData.mChunk = chunk;
                WebViewWorker.getHandler().obtainMessage(105, cacheData).sendToTarget();
            } else {
                chunk.release();
            }
            perfChecker.responseAlert("res nativeAddData");
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int createNativeResponse() {
        int n = this.mStatusCode == 304 && this.mCacheLoader != null ? 200 : this.mStatusCode;
        String string2 = this.originalUrl();
        String string3 = this.mStatusText;
        String string4 = this.mMimeType;
        long l = this.mContentLength;
        String string5 = this.mEncoding;
        final int n2 = this.nativeCreateResponse(string2, n, string3, string4, l, string5);
        if (this.mHeaders != null) {
            Headers headers = this.mHeaders;
            Headers.HeaderCallback headerCallback = new Headers.HeaderCallback(){

                @Override
                public void header(String string2, String string3) {
                    LoadListener loadListener = LoadListener.this;
                    int n = n2;
                    loadListener.nativeSetResponseHeader(n, string2, string3);
                }
            };
            headers.getHeaders(headerCallback);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRedirect() {
        int n;
        Map<String, String> map;
        if (this.mCancelled) {
            return;
        }
        if (this.mCacheRedirectCount >= 16) {
            String string2 = this.mContext.getString(17039619);
            this.handleError(65527, string2);
            return;
        }
        String string3 = this.mHeaders.getLocation();
        if (string3 == null) {
            this.commitHeaders();
            this.commitLoad();
            this.tearDown();
            return;
        }
        int n2 = this.createNativeResponse();
        String string4 = this.mUrl;
        string3 = this.nativeRedirectedToUrl(string4, string3, n2);
        if (this.mCancelled) {
            return;
        }
        if (string3 == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Redirection failed for ");
            String string5 = this.mHeaders.getLocation();
            String string6 = stringBuilder.append(string5).toString();
            int n3 = Log.d(LOGTAG, string6);
            this.cancel();
            return;
        }
        if (!URLUtil.isNetworkUrl(string3)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string7 = this.mContext.getString(17040064);
            String string8 = stringBuilder.append(string7).append("\n").append(string3).toString();
            byte[] byArray = string8.getBytes();
            int n4 = string8.length();
            this.nativeAddData(byArray, n4);
            this.nativeFinished();
            this.clearNativeLoader();
            return;
        }
        if (this.getErrorID() == 0) {
            long l;
            String string9;
            WebViewWorker.CacheSaveData cacheSaveData = new WebViewWorker.CacheSaveData();
            cacheSaveData.mListener = this;
            cacheSaveData.mUrl = string9 = this.mUrl;
            cacheSaveData.mPostId = l = this.mPostIdentifier;
            WebViewWorker.getHandler().obtainMessage(106, cacheSaveData).sendToTarget();
        } else {
            WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        }
        this.mOriginalUrl = string3;
        this.setUrl(string3);
        if (this.mRequestHeaders == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.mRequestHeaders = hashMap;
        }
        boolean bl = false;
        if (this.mCacheLoader != null) {
            int n5;
            this.mCacheRedirectCount = n5 = this.mCacheRedirectCount + 1;
            bl = true;
        }
        if (!this.checkCache(map = this.mRequestHeaders)) {
            if (this.mRequestHandle != null) {
                try {
                    RequestHandle requestHandle = this.mRequestHandle;
                    String string10 = this.mUrl;
                    int n6 = this.mStatusCode;
                    Map<String, String> map2 = this.mRequestHeaders;
                    boolean bl2 = requestHandle.setupRedirect(string10, n6, map2);
                }
                catch (RuntimeException runtimeException) {
                    String string11 = runtimeException.getMessage();
                    int n7 = Log.e(LOGTAG, string11);
                    String string12 = this.mContext.getString(17039367);
                    this.handleError(65524, string12);
                    return;
                }
            } else {
                byte[] byArray;
                Map<String, String> map3;
                String string13;
                Network network = Network.getInstance(this.getContext());
                if (!network.requestURL(string13 = this.mMethod, map3 = this.mRequestHeaders, byArray = this.mPostData, this)) {
                    String string14 = this.mContext.getString(17039367);
                    this.handleError(65524, string14);
                    return;
                }
            }
            if (!bl) {
                return;
            }
            RequestHandle requestHandle = this.mRequestHandle;
            int n8 = this.mCacheRedirectCount;
            requestHandle.setRedirectCount(n8);
            return;
        }
        if (bl) {
            return;
        }
        this.mCacheRedirectCount = n = this.mRequestHandle.getRedirectCount() + 1;
    }

    private String getErrorDescription() {
        return this.mErrorDescription;
    }

    private int getErrorID() {
        return this.mErrorID;
    }

    public static LoadListener getLoadListener(Context context, BrowserFrame browserFrame, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, String string3, String string4) {
        ++sNativeLoaderCount;
        Context context2 = context;
        BrowserFrame browserFrame2 = browserFrame;
        String string5 = string2;
        int n2 = n;
        boolean bl5 = bl;
        boolean bl6 = bl2;
        boolean bl7 = bl3;
        boolean bl8 = bl4;
        long l2 = l;
        String string6 = string3;
        String string7 = string4;
        return new LoadListener(context2, browserFrame2, string5, n2, bl5, bl6, bl7, bl8, l2, string6, string7);
    }

    public static int getNativeLoaderCount() {
        return sNativeLoaderCount;
    }

    private void guessMimeType() {
        if (URLUtil.isDataUrl(this.mUrl) && this.mMimeType.length() != 0) {
            this.cancel();
            String string2 = this.mContext.getString(17039367);
            this.handleError(65524, string2);
            return;
        }
        this.mMimeType = "text/html";
        String string3 = this.mUrl;
        String string4 = this.guessMimeTypeFromExtension(string3);
        if (string4 == null) {
            return;
        }
        this.mMimeType = string4;
    }

    private String guessMimeTypeFromExtension(String string2) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String string3 = MimeTypeMap.getFileExtensionFromUrl(string2);
        return mimeTypeMap.getMimeTypeFromExtension(string3);
    }

    private void handleCertificate(SslCertificate sslCertificate) {
        if (!this.mIsMainPageLoader) {
            return;
        }
        if (!this.mIsMainResourceLoader) {
            return;
        }
        this.mBrowserFrame.certificate(sslCertificate);
    }

    /*
     * Unable to fully structure code
     */
    private void handleEndData() {
        if (this.mCancelled) {
            return;
        }
        switch (this.mStatusCode) lbl-1000:
        // 2 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    this.detachRequestHandle();
                    this.tearDown();
                    return;
                }
            }
            case 301: {
                this.mPermanent = true;
            }
            case 302: 
            case 303: 
            case 307: {
                if (this.mStatusCode == 307) {
                    if (this.mRequestHandle != null && this.mRequestHandle.getMethod().equals("POST")) {
                        var1_1 = this.obtainMessage(150);
                        this.sendMessageInternal(var1_1);
                        return;
                    }
                    if (this.mMethod != null && this.mMethod.equals("POST")) {
                        var2_2 = this.obtainMessage(150);
                        this.sendMessageInternal(var2_2);
                        return;
                    }
                    var3_3 = this.obtainMessage(140);
                    this.sendMessageInternal(var3_3);
                    return;
                }
                var4_4 = this.obtainMessage(140);
                this.sendMessageInternal(var4_4);
                return;
            }
            case 401: 
            case 407: {
                if (this.mAuthHeader == null || !Network.getInstance(this.mContext).isValidProxySet() && this.mAuthHeader.isProxy()) ** GOTO lbl-1000
                if (!this.mAuthFailed && this.mUsername != null && this.mPassword != null) {
                    if (this.mAuthHeader.isProxy()) {
                        var5_5 = Network.getInstance(this.mContext).getProxyHostname();
lbl32:
                        // 2 sources

                        while (true) {
                            var6_6 = this.mAuthHeader.getRealm();
                            var7_7 = this.mUsername;
                            var8_8 = this.mPassword;
                            HttpAuthHandler.onReceivedCredentials(this, var5_5, var6_6, var7_7, var8_8);
                            var9_9 = this.mUsername;
                            var10_10 = this.mPassword;
                            this.makeAuthResponse(var9_9, var10_10);
                            return;
                        }
                    }
                    var5_5 = this.mUri.mHost;
                    ** continue;
                }
                Network.getInstance(this.mContext).handleAuthRequest(this);
                return;
            }
            case 304: 
        }
        ** while (this.mCacheLoader == null)
lbl47:
        // 1 sources

        if (this.isSynchronous()) {
            this.mCacheLoader.load();
lbl49:
            // 2 sources

            while (true) {
                this.mFromCache = true;
                return;
            }
        }
        var11_11 = WebViewWorker.getHandler();
        var12_12 = this.mCacheLoader;
        var11_11.obtainMessage(101, var12_12).sendToTarget();
        ** while (true)
    }

    private void handleError(int n, String string2) {
        this.mErrorID = n;
        this.mErrorDescription = string2;
        this.detachRequestHandle();
        this.notifyError();
        this.tearDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleHeaders(Headers headers) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        String string2;
        block25: {
            block23: {
                block24: {
                    String string3;
                    LoadListener loadListener;
                    String string4;
                    long l;
                    long l2;
                    Headers headers2;
                    if (this.mCancelled) {
                        return;
                    }
                    int n14 = this.mStatusCode;
                    int n15 = 206;
                    if (n14 == n15) {
                        WebViewWorker webViewWorker = WebViewWorker.getHandler();
                        int n16 = 107;
                        LoadListener loadListener2 = this;
                        webViewWorker.obtainMessage(n16, loadListener2).sendToTarget();
                        return;
                    }
                    this.mHeaders = headers2 = headers;
                    long l3 = headers.getContentLength();
                    this.mContentLength = l3 != 65535L ? (l2 = l3) : (l = 0L);
                    String string5 = headers.getContentType();
                    if (string5 == null) break block23;
                    LoadListener loadListener3 = this;
                    String string6 = string5;
                    loadListener3.parseContentTypeHeader(string6);
                    if (!this.mMimeType.equals("text/plain") && !this.mMimeType.equals("application/octet-stream")) break block24;
                    String string7 = headers.getContentDisposition();
                    String string8 = null;
                    if (string7 != null) {
                        string8 = URLUtil.parseContentDisposition(string7);
                    }
                    if (string8 == null) {
                        string8 = this.mUrl;
                    }
                    if ((string4 = (loadListener = this).guessMimeTypeFromExtension(string3 = string8)) != null) {
                        String string9;
                        this.mMimeType = string9 = string4;
                    }
                    break block25;
                }
                if (this.mMimeType.equals("text/vnd.wap.wml")) {
                    String string10;
                    this.mMimeType = string10 = "text/plain";
                    break block25;
                } else if (this.mMimeType.equals("application/vnd.wap.xhtml+xml")) {
                    String string11;
                    this.mMimeType = string11 = "application/xhtml+xml";
                }
                break block25;
            }
            this.guessMimeType();
        }
        if (this.mIsMainPageLoader && this.mIsMainResourceLoader && this.mUserGesture && Pattern.matches(XML_MIME_TYPE, string2 = this.mMimeType) && !this.mMimeType.equalsIgnoreCase("application/xhtml+xml")) {
            String string12;
            String string13;
            Intent intent;
            Intent intent2 = intent;
            String string14 = "android.intent.action.VIEW";
            intent2(string14);
            Uri uri = Uri.parse(this.url());
            String string15 = this.mMimeType;
            Intent intent3 = intent;
            Uri uri2 = uri;
            String string16 = string15;
            Intent intent4 = intent3.setDataAndType(uri2, string16);
            PackageManager packageManager = this.mContext.getPackageManager();
            Intent intent5 = intent;
            int n17 = 65536;
            ResolveInfo resolveInfo = packageManager.resolveActivity(intent5, n17);
            if (resolveInfo != null && !(string13 = this.mContext.getPackageName()).equals(string12 = resolveInfo.activityInfo.packageName)) {
                try {
                    Context context = this.mContext;
                    Intent intent6 = intent;
                    context.startActivity(intent6);
                    this.mBrowserFrame.stopLoading();
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }
        }
        n11 = (n13 = this.mStatusCode) == (n12 = 401) || (n11 = this.mStatusCode) == (n10 = 407) ? 1 : 0;
        int n18 = this.mStatusCode;
        int n19 = 407;
        n18 = n18 == n19 ? 1 : 0;
        this.mAuthFailed = n9 = 0;
        if (this.mAuthHeader != null) {
            Network network;
            boolean bl;
            int n20;
            int n21;
            boolean bl2 = n11 != 0 && (n9 = n18) != (n21 = (n20 = this.mAuthHeader.isProxy()));
            this.mAuthFailed = bl = bl2;
            if (!this.mAuthFailed && this.mAuthHeader.isProxy() && (network = Network.getInstance(this.mContext)).isValidProxySet()) {
                synchronized (network) {
                    String string17 = this.mAuthHeader.getUsername();
                    Network network2 = network;
                    String string18 = string17;
                    network2.setProxyUsername(string18);
                    String string19 = this.mAuthHeader.getPassword();
                    Network network3 = network;
                    String string20 = string19;
                    network3.setProxyPassword(string20);
                }
            }
        }
        Object var61_56 = null;
        this.mAuthHeader = var61_56;
        if (n11 != 0) {
            int n22 = this.mStatusCode;
            int n23 = 401;
            if (n22 == n23) {
                HttpAuthHeader httpAuthHeader;
                String string21 = headers.getWwwAuthenticate();
                LoadListener loadListener = this;
                String string22 = string21;
                this.mAuthHeader = httpAuthHeader = loadListener.parseAuthHeader(string22);
            } else {
                HttpAuthHeader httpAuthHeader;
                String string23 = headers.getProxyAuthenticate();
                LoadListener loadListener = this;
                String string24 = string23;
                this.mAuthHeader = httpAuthHeader = loadListener.parseAuthHeader(string24);
                if (this.mAuthHeader != null) {
                    this.mAuthHeader.setProxy();
                }
            }
        }
        if (((n8 = this.mStatusCode) == (n7 = 200) || (n6 = this.mStatusCode) == (n5 = 302) || (n4 = this.mStatusCode) == (n3 = 301) || (n2 = this.mStatusCode) == (n = 307)) && this.mNativeLoader != 0) {
            LoadListener loadListener;
            String string25;
            if (!(this.mFromCache || this.mRequestHandle == null || this.mRequestHandle.getMethod().equals("POST") && this.mPostIdentifier == 0L)) {
                Headers headers3;
                long l;
                int n24;
                String string26;
                String string27;
                LoadListener loadListener4;
                WebViewWorker.CacheCreateData cacheCreateData = new WebViewWorker.CacheCreateData();
                cacheCreateData.mListener = loadListener4 = this;
                cacheCreateData.mUrl = string27 = this.mUrl;
                cacheCreateData.mMimeType = string26 = this.mMimeType;
                cacheCreateData.mStatusCode = n24 = this.mStatusCode;
                cacheCreateData.mPostId = l = this.mPostIdentifier;
                cacheCreateData.mHeaders = headers3 = headers;
                WebViewWorker webViewWorker = WebViewWorker.getHandler();
                int n25 = 103;
                WebViewWorker.CacheCreateData cacheCreateData2 = cacheCreateData;
                webViewWorker.obtainMessage(n25, cacheCreateData2).sendToTarget();
            }
            WebViewWorker.CacheEncoding cacheEncoding = new WebViewWorker.CacheEncoding();
            cacheEncoding.mEncoding = string25 = this.mEncoding;
            cacheEncoding.mListener = loadListener = this;
            WebViewWorker webViewWorker = WebViewWorker.getHandler();
            int n26 = 104;
            WebViewWorker.CacheEncoding cacheEncoding2 = cacheEncoding;
            webViewWorker.obtainMessage(n26, cacheEncoding2).sendToTarget();
        }
        this.commitHeadersCheckRedirect();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleSslError(SslError sslError) {
        if (!this.mCancelled) {
            this.mSslError = sslError;
            Network.getInstance(this.mContext).handleSslErrorRequest(this);
        } else if (this.mSslErrorRequestHandle != null) {
            this.mSslErrorRequestHandle.handleSslErrorResponse(true);
        }
        this.mSslErrorRequestHandle = null;
    }

    private void handleStatus(int n, int n2, int n3, String string2) {
        if (this.mCancelled) {
            return;
        }
        this.mStatusCode = n3;
        this.mStatusText = string2;
        this.mPermanent = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean ignoreCallbacks() {
        if (this.mCancelled) return true;
        if (this.mAuthHeader != null) return true;
        if (this.mStatusCode <= 300) return false;
        if (this.mStatusCode >= 400) return false;
        if (this.mStatusCode == 305) return false;
        return true;
    }

    private native void nativeAddData(byte[] var1, int var2);

    private native int nativeCreateResponse(String var1, int var2, String var3, String var4, long var5, String var7);

    private native void nativeError(int var1, String var2, String var3);

    private native void nativeFinished();

    private native void nativeReceivedResponse(int var1);

    private native String nativeRedirectedToUrl(String var1, String var2, int var3);

    private native void nativeSetResponseHeader(int var1, String var2, String var3);

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private HttpAuthHeader parseAuthHeader(String string2) {
        HttpAuthHeader httpAuthHeader;
        int n;
        int n2;
        int n3;
        if (string2 == null) return null;
        int n4 = 256;
        int n5 = 0;
        int[] nArray = new int[n4];
        boolean bl = true;
        while (true) {
            int n6;
            block13: {
                block14: {
                    block10: {
                        block11: {
                            block15: {
                                boolean bl2;
                                block12: {
                                    int n7;
                                    int n8;
                                    block9: {
                                        if (!bl || (bl = false)) break block9;
                                        n3 = string2.length();
                                        if (n3 <= 0) break block10;
                                        bl2 = false;
                                        n2 = 0;
                                        n6 = n5;
                                    }
                                    if (n2 >= n3 || (n8 = n6) >= (n7 = n4)) break block11;
                                    String string3 = string2;
                                    int n9 = n2;
                                    if (string3.charAt(n9) != '\"') break block12;
                                    bl2 = !bl2;
                                    n5 = n6;
                                    break block13;
                                }
                                if (bl2) break block14;
                                int n10 = "Basic".length();
                                if (!string2.regionMatches(true, n2, "Basic", 0, n10)) break block15;
                                n5 = n6 + 1;
                                nArray[n6] = n2;
                                break block13;
                            }
                            int n11 = "Digest".length();
                            if (!string2.regionMatches(true, n2, "Digest", 0, n11)) break block14;
                            n5 = n6 + 1;
                            nArray[n6] = n2;
                            break block13;
                        }
                        n5 = n6;
                    }
                    if (n5 <= 0) return null;
                    break;
                }
                n5 = n6;
            }
            int n12 = n2 + 1;
            n6 = n5;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            int n13;
            int n14;
            String string4;
            String string5;
            int n15 = nArray[n2];
            int n16 = "Digest".length();
            if (!string2.regionMatches(true, n15, "Digest", 0, n16)) continue;
            int n17 = nArray[n2];
            if (n2 + 1 < n5) {
                int n18 = n2 + 1;
                n = nArray[n18];
            } else {
                n = n3;
            }
            if (!(httpAuthHeader = new HttpAuthHeader(string5 = (string4 = string2).substring(n14 = n17, n13 = n))).isSupportedScheme()) continue;
            return httpAuthHeader;
        }
        n2 = 0;
        while (n2 < n5) {
            int n19 = nArray[n2];
            int n20 = "Basic".length();
            if (string2.regionMatches(true, n19, "Basic", 0, n20)) {
                int n21;
                int n22;
                String string6;
                String string7;
                int n23 = nArray[n2];
                if (n2 + 1 < n5) {
                    int n24 = n2 + 1;
                    n = nArray[n24];
                } else {
                    n = n3;
                }
                if ((httpAuthHeader = new HttpAuthHeader(string7 = (string6 = string2).substring(n22 = n23, n21 = n))).isSupportedScheme()) {
                    return httpAuthHeader;
                }
            }
            ++n2;
        }
        return null;
    }

    private void sendMessageInternal(Message message) {
        if (this.mSynchronous) {
            boolean bl = this.mMessageQueue.add(message);
            return;
        }
        boolean bl = this.sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean willLoadFromCache(String string2, long l) {
        if (CacheManager.getCacheFile(string2, l, null) == null) return false;
        return true;
    }

    void attachRequestHandle(RequestHandle requestHandle) {
        this.mRequestHandle = requestHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean authCredentialsInvalid() {
        if (!this.mAuthFailed) return false;
        if (!this.mAuthHeader.isDigest()) return true;
        if (this.mAuthHeader.getStale()) return false;
        return true;
    }

    public void cancel() {
        if (this.mRequestHandle != null) {
            this.mRequestHandle.cancel();
            this.mRequestHandle = null;
        }
        WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        this.mCancelled = true;
        this.clearNativeLoader();
    }

    public boolean cancelled() {
        return this.mCancelled;
    }

    @Override
    public void certificate(SslCertificate sslCertificate) {
        Message message = this.obtainMessage(170, sslCertificate);
        this.sendMessageInternal(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean checkCache(Map<String, String> map) {
        CacheLoader cacheLoader;
        String string2 = this.url();
        long l = this.mPostIdentifier;
        CacheManager.CacheResult cacheResult = CacheManager.getCacheFile(string2, l, map);
        this.mCacheLoader = null;
        this.mFromCache = false;
        if (cacheResult == null) return false;
        this.mCacheLoader = cacheLoader = new CacheLoader(this, cacheResult);
        if (map.containsKey("if-none-match")) return false;
        if (map.containsKey("if-modified-since")) return false;
        if (this.isSynchronous()) {
            this.mCacheLoader.load();
        } else {
            WebViewWorker webViewWorker = WebViewWorker.getHandler();
            CacheLoader cacheLoader2 = this.mCacheLoader;
            webViewWorker.obtainMessage(101, cacheLoader2).sendToTarget();
        }
        this.mFromCache = true;
        return true;
    }

    long contentLength() {
        return this.mContentLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void data(byte[] byArray, int n) {
        ByteArrayBuilder byteArrayBuilder = this.mDataBuilder;
        // MONITORENTER : byteArrayBuilder
        boolean bl = this.mDataBuilder.isEmpty();
        this.mDataBuilder.append(byArray, 0, n);
        // MONITOREXIT : byteArrayBuilder
        if (!bl) {
            return;
        }
        Message message = this.obtainMessage(110);
        this.sendMessageInternal(message);
    }

    void detachRequestHandle() {
        this.mRequestHandle = null;
    }

    void downloadFile() {
        WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        CallbackProxy callbackProxy = this.mBrowserFrame.getCallbackProxy();
        String string2 = this.url();
        String string3 = this.mBrowserFrame.getUserAgentString();
        String string4 = this.mHeaders.getContentDisposition();
        String string5 = this.mMimeType;
        long l = this.mContentLength;
        boolean bl = callbackProxy.onDownloadStart(string2, string3, string4, string5, l);
        this.cancel();
    }

    @Override
    public void endData() {
        Message message = this.obtainMessage(120);
        this.sendMessageInternal(message);
    }

    @Override
    public void error(int n, String string2) {
        Message message = this.obtainMessage(130, n, 0, string2);
        this.sendMessageInternal(message);
    }

    Context getContext() {
        return this.mContext;
    }

    BrowserFrame getFrame() {
        return this.mBrowserFrame;
    }

    WebAddress getWebAddress() {
        return this.mUri;
    }

    void handleAuthResponse(String string2, String string3) {
        if (string2 != null && string3 != null) {
            this.makeAuthResponse(string2, string3);
            return;
        }
        this.commitLoad();
        this.tearDown();
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 100: {
                Headers headers = (Headers)message.obj;
                this.handleHeaders(headers);
                return;
            }
            case 110: {
                if (this.mNativeLoader == 0) {
                    return;
                }
                if (this.ignoreCallbacks()) {
                    return;
                }
                this.commitLoad();
                return;
            }
            case 120: {
                this.handleEndData();
                return;
            }
            case 130: {
                int n = message.arg1;
                String string2 = (String)message.obj;
                this.handleError(n, string2);
                return;
            }
            case 140: {
                this.doRedirect();
                return;
            }
            case 150: {
                Message message2 = this.obtainMessage(140);
                Message message3 = this.obtainMessage(120);
                this.mBrowserFrame.getCallbackProxy().onFormResubmission(message3, message2);
                return;
            }
            case 160: {
                HashMap hashMap = (HashMap)message.obj;
                int n = (Integer)hashMap.get("major");
                int n2 = (Integer)hashMap.get("minor");
                int n3 = (Integer)hashMap.get("code");
                String string3 = (String)hashMap.get("reason");
                this.handleStatus(n, n2, n3, string3);
                return;
            }
            case 170: {
                SslCertificate sslCertificate = (SslCertificate)message.obj;
                this.handleCertificate(sslCertificate);
                return;
            }
            case 180: 
        }
        SslError sslError = (SslError)message.obj;
        this.handleSslError(sslError);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleSslErrorRequest(SslError sslError) {
        if (Network.getInstance(this.mContext).checkSslPrefTable(this, sslError)) {
            return true;
        }
        if (this.isSynchronous()) {
            this.mRequestHandle.handleSslErrorResponse(false);
            return true;
        }
        Message message = this.obtainMessage(180, sslError);
        this.sendMessageInternal(message);
        if (!this.mCancelled) {
            RequestHandle requestHandle;
            this.mSslErrorRequestHandle = requestHandle = this.mRequestHandle;
        }
        if (this.mCancelled) return false;
        return true;
    }

    void handleSslErrorResponse(boolean bl) {
        if (this.mRequestHandle != null) {
            this.mRequestHandle.handleSslErrorResponse(bl);
        }
        if (bl) {
            return;
        }
        this.commitLoad();
        this.tearDown();
    }

    @Override
    public void headers(Headers headers) {
        int n;
        if (this.mCancelled) {
            return;
        }
        ArrayList<String> arrayList = headers.getSetCookie();
        for (int i = 0; i < (n = arrayList.size()); ++i) {
            CookieManager cookieManager = CookieManager.getInstance();
            WebAddress webAddress = this.mUri;
            String string2 = arrayList.get(i);
            cookieManager.setCookie(webAddress, string2);
        }
        Message message = this.obtainMessage(100, headers);
        this.sendMessageInternal(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String host() {
        if (this.mUri == null) return null;
        return this.mUri.mHost;
    }

    boolean isSynchronous() {
        return this.mSynchronous;
    }

    void loadSynchronousMessages() {
        while (!this.mMessageQueue.isEmpty()) {
            Message message = this.mMessageQueue.remove(0);
            this.handleMessage(message);
        }
        return;
    }

    void makeAuthResponse(String string2, String string3) {
        if (this.mAuthHeader == null) {
            return;
        }
        if (this.mRequestHandle == null) {
            return;
        }
        this.mAuthHeader.setUsername(string2);
        this.mAuthHeader.setPassword(string3);
        int n = this.mAuthHeader.getScheme();
        if (n == 1) {
            boolean bl = this.mAuthHeader.isProxy();
            this.mRequestHandle.setupBasicAuthResponse(bl, string2, string3);
            return;
        }
        if (n != 2) {
            return;
        }
        boolean bl = this.mAuthHeader.isProxy();
        String string4 = this.mAuthHeader.getRealm();
        String string5 = this.mAuthHeader.getNonce();
        String string6 = this.mAuthHeader.getQop();
        String string7 = this.mAuthHeader.getAlgorithm();
        String string8 = this.mAuthHeader.getOpaque();
        RequestHandle requestHandle = this.mRequestHandle;
        String string9 = string2;
        String string10 = string3;
        requestHandle.setupDigestAuthResponse(bl, string9, string10, string4, string5, string6, string7, string8);
    }

    String mimeType() {
        return this.mMimeType;
    }

    void notifyError() {
        if (this.mNativeLoader == 0) {
            return;
        }
        String string2 = this.getErrorDescription();
        if (string2 == null) {
            string2 = "";
        }
        int n = this.getErrorID();
        String string3 = this.url();
        this.nativeError(n, string2, string3);
        this.clearNativeLoader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String originalUrl() {
        if (this.mOriginalUrl == null) return this.mUrl;
        return this.mOriginalUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseContentTypeHeader(String string2) {
        String string3;
        if (string2 != null) {
            String string4;
            int n = string2.indexOf(59);
            if (n >= 0) {
                String string5;
                String string6;
                this.mMimeType = string6 = string2.substring(0, n);
                int n2 = string2.indexOf(61, n);
                if (n2 > 0) {
                    String string7;
                    n = string2.indexOf(59, n2);
                    if (n < n2) {
                        n = string2.length();
                    }
                    int n3 = n2 + 1;
                    this.mEncoding = string7 = string2.substring(n3, n);
                } else {
                    String string8;
                    int n4 = n + 1;
                    this.mEncoding = string8 = string2.substring(n4);
                }
                this.mEncoding = string5 = this.mEncoding.trim().toLowerCase();
                int n5 = string2.length() - 1;
                if (n < n5) {
                    String string9;
                    int n6 = n + 1;
                    this.mTransferEncoding = string9 = string2.substring(n6).trim().toLowerCase();
                }
            } else {
                this.mMimeType = string2;
            }
            this.mMimeType = string4 = this.mMimeType.trim();
            try {
                Pattern pattern = CONTENT_TYPE_PATTERN;
                String string10 = this.mMimeType;
                Matcher matcher = pattern.matcher(string10);
                if (matcher.find()) {
                    String string11;
                    this.mMimeType = string11 = matcher.group(1);
                } else {
                    this.guessMimeType();
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.guessMimeType();
            }
        }
        this.mMimeType = string3 = this.mMimeType.toLowerCase();
    }

    void pauseLoad(boolean bl) {
        if (this.mRequestHandle == null) {
            return;
        }
        this.mRequestHandle.pauseRequest(bl);
    }

    long postIdentifier() {
        return this.mPostIdentifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean proxyAuthenticate() {
        if (this.mAuthHeader == null) return false;
        return this.mAuthHeader.isProxy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String realm() {
        if (this.mAuthHeader != null) return this.mAuthHeader.getRealm();
        return null;
    }

    void resetCancel() {
        this.mCancelled = false;
    }

    void setCacheLoader(CacheLoader cacheLoader) {
        this.mCacheLoader = cacheLoader;
        this.mFromCache = true;
    }

    void setRequestData(String string2, Map<String, String> map, byte[] byArray) {
        this.mMethod = string2;
        this.mRequestHeaders = map;
        this.mPostData = byArray;
    }

    void setUrl(String string2) {
        if (string2 == null) {
            return;
        }
        this.mUri = null;
        if (URLUtil.isNetworkUrl(string2)) {
            String string3;
            this.mUrl = string3 = URLUtil.stripAnchor(string2);
            try {
                WebAddress webAddress;
                String string4 = this.mUrl;
                this.mUri = webAddress = new WebAddress(string4);
                return;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return;
            }
        }
        this.mUrl = string2;
    }

    SslError sslError() {
        return this.mSslError;
    }

    @Override
    public void status(int n, int n2, int n3, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Integer n4 = n;
        Integer n5 = hashMap.put("major", n4);
        Integer n6 = n2;
        Integer n7 = hashMap.put("minor", n6);
        Integer n8 = n3;
        Integer n9 = hashMap.put("code", n8);
        String string3 = hashMap.put("reason", string2);
        this.mDataBuilder.clear();
        this.mMimeType = "";
        this.mEncoding = "";
        this.mTransferEncoding = "";
        Message message = this.obtainMessage(160, hashMap);
        this.sendMessageInternal(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    void tearDown() {
        if (this.getErrorID() == 0) {
            long l;
            String string2;
            WebViewWorker.CacheSaveData cacheSaveData = new WebViewWorker.CacheSaveData();
            cacheSaveData.mListener = this;
            cacheSaveData.mUrl = string2 = this.mUrl;
            cacheSaveData.mPostId = l = this.mPostIdentifier;
            WebViewWorker.getHandler().obtainMessage(106, cacheSaveData).sendToTarget();
        } else {
            WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        }
        if (this.mNativeLoader == 0) {
            return;
        }
        PerfChecker perfChecker = new PerfChecker();
        this.nativeFinished();
        perfChecker.responseAlert("res nativeFinished");
        this.clearNativeLoader();
    }

    String transferEncoding() {
        return this.mTransferEncoding;
    }

    String url() {
        return this.mUrl;
    }
}

