/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.Dialog;
import android.content.Context;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewCore;

class PluginFullScreenHolder
extends Dialog {
    private View mContentView;
    private final int mNpp;
    private final WebView mWebView;

    PluginFullScreenHolder(WebView webView, int n) {
        Context context = webView.getContext();
        super(context, 16973831);
        this.mWebView = webView;
        this.mNpp = n;
    }

    @Override
    public void onBackPressed() {
        this.mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (keyEvent.isSystem()) {
            return super.onKeyDown(n, keyEvent);
        }
        boolean bl = this.mWebView.onKeyDown(n, keyEvent);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (keyEvent.isSystem()) {
            return super.onKeyUp(n, keyEvent);
        }
        boolean bl = this.mWebView.onKeyUp(n, keyEvent);
        return true;
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mContentView != null && this.mContentView.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)this.mContentView.getParent();
            View view = this.mContentView;
            viewGroup.removeView(view);
        }
        WebViewCore webViewCore = this.mWebView.getWebViewCore();
        int n = this.mNpp;
        webViewCore.sendMessage(182, n, 0);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        boolean bl = this.mWebView.onTrackballEvent(motionEvent);
        return true;
    }

    @Override
    public void setContentView(View view) {
        SurfaceView surfaceView;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        view.setLayoutParams(layoutParams);
        if (view instanceof SurfaceView && (surfaceView = (SurfaceView)view).isFixedSize()) {
            surfaceView.getHolder().setSizeFromLayout();
        }
        super.setContentView(view);
        this.mContentView = view;
    }
}

