/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.os.SystemProperties;
import android.util.Log;
import android.webkit.BrowserFrame;
import android.webkit.JWebCoreJavaBridge;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PluginManager {
    private static final String LOGTAG = "PluginManager";
    public static final String PLUGIN_ACTION = "android.webkit.PLUGIN";
    public static final String PLUGIN_PERMISSION = "android.webkit.permission.PLUGIN";
    private static final String PLUGIN_SYSTEM_LIB = "/system/lib/plugins/";
    private static final String PLUGIN_TYPE = "type";
    private static final Signature[] SIGNATURES;
    private static final String SIGNATURE_1 = "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";
    private static final String TYPE_NATIVE = "native";
    private static PluginManager mInstance;
    private final Context mContext;
    private ArrayList<PackageInfo> mPackageInfoCache;

    static {
        mInstance = null;
        Signature signature = new Signature(SIGNATURE_1);
        Signature[] signatureArray = new Signature[]{signature};
        SIGNATURES = signatureArray;
    }

    private PluginManager(Context context) {
        this.mContext = context;
        ArrayList arrayList = new ArrayList();
        this.mPackageInfoCache = arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PluginManager getInstance(Context context) {
        synchronized (PluginManager.class) {
            if (mInstance != null) return mInstance;
            if (context == null) {
                throw new IllegalStateException("First call to PluginManager need a valid context.");
            }
            Context context2 = context.getApplicationContext();
            mInstance = new PluginManager(context2);
            return mInstance;
        }
    }

    Class<?> getPluginClass(String string2, String string3) throws PackageManager.NameNotFoundException, ClassNotFoundException {
        return this.mContext.createPackageContext(string2, 3).getClassLoader().loadClass(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] getPluginDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = new Intent(PLUGIN_ACTION);
        PackageManager packageManager2 = packageManager;
        Intent intent2 = intent;
        int n = 132;
        List<ResolveInfo> list = packageManager2.queryIntentServices(intent2, n);
        ArrayList<PackageInfo> arrayList2 = this.mPackageInfoCache;
        synchronized (arrayList2) {
            this.mPackageInfoCache.clear();
            Iterator<ResolveInfo> iterator = list.iterator();
            block8: while (true) {
                String string2;
                PackageInfo packageInfo;
                ServiceInfo serviceInfo;
                block18: {
                    boolean bl;
                    Object[] objectArray;
                    boolean bl2;
                    if (!iterator.hasNext()) {
                        // MONITOREXIT @DISABLED, blocks:[16, 4, 8] lbl14 : MonitorExitStatement: MONITOREXIT : var8_8
                        String[] stringArray = new String[arrayList.size()];
                        ArrayList<String> arrayList3 = arrayList;
                        String[] stringArray2 = stringArray;
                        return arrayList3.toArray(stringArray2);
                    }
                    serviceInfo = iterator.next().serviceInfo;
                    if (serviceInfo == null) {
                        int n2 = Log.w(LOGTAG, "Ignore bad plugin");
                        continue;
                    }
                    try {
                        String[] stringArray;
                        PackageManager packageManager3 = packageManager;
                        String string3 = serviceInfo.packageName;
                        String string4 = string3;
                        int n3 = 4160;
                        PackageInfo packageInfo2 = packageManager3.getPackageInfo(string4, n3);
                        packageInfo = packageInfo2;
                        if (packageInfo == null) continue;
                        StringBuilder stringBuilder = new StringBuilder();
                        String string5 = packageInfo.applicationInfo.dataDir;
                        string2 = stringBuilder.append(string5).append("/lib").toString();
                        int n4 = packageInfo.applicationInfo.flags & 0x81;
                        int n5 = 1;
                        if (n4 == n5) {
                            StringBuilder stringBuilder2 = new StringBuilder().append(PLUGIN_SYSTEM_LIB);
                            String string6 = packageInfo.packageName;
                            string2 = stringBuilder2.append(string6).toString();
                        }
                        if ((stringArray = packageInfo.requestedPermissions) == null) continue;
                        bl2 = false;
                        objectArray = stringArray;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        StringBuilder stringBuilder = new StringBuilder().append("Can't find plugin: ");
                        String string7 = serviceInfo.packageName;
                        String string8 = stringBuilder.append(string7).toString();
                        int n6 = Log.w(LOGTAG, string8);
                        continue;
                    }
                    int n7 = objectArray.length;
                    int n8 = 0;
                    while (true) {
                        block20: {
                            Signature[] signatureArray;
                            block19: {
                                if (n8 >= n7) break block19;
                                String string9 = PLUGIN_PERMISSION;
                                String string10 = objectArray[n8];
                                String string11 = string10;
                                if (!string9.equals(string11)) break block20;
                                bl2 = true;
                            }
                            if (!bl2 || (signatureArray = packageInfo.signatures) == null) continue block8;
                            if (!SystemProperties.getBoolean("ro.secure", false)) break block18;
                            bl = false;
                            block10: for (Signature signature : signatureArray) {
                                int n9;
                                int n10;
                                int n11;
                                int n12 = 0;
                                while ((n11 = ++n12) < (n10 = (n9 = SIGNATURES.length))) {
                                    Signature signature2 = SIGNATURES[n12];
                                    Signature signature3 = signature;
                                    if (!signature2.equals(signature3)) continue;
                                    bl = true;
                                    continue block10;
                                }
                            }
                            break;
                        }
                        ++n8;
                    }
                    if (!bl) continue;
                }
                if (serviceInfo.metaData == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("The plugin '");
                    String string12 = serviceInfo.name;
                    String string13 = stringBuilder.append(string12).append("' has no type defined").toString();
                    int n13 = Log.e(LOGTAG, string13);
                    continue;
                }
                String string14 = TYPE_NATIVE;
                String string15 = serviceInfo.metaData.getString(PLUGIN_TYPE);
                String string16 = string15;
                if (!string14.equals(string16)) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unrecognized plugin type: ");
                    String string17 = string15;
                    String string18 = stringBuilder.append(string17).toString();
                    int n14 = Log.e(LOGTAG, string18);
                    continue;
                }
                try {
                    String string19 = serviceInfo.packageName;
                    String string20 = serviceInfo.name;
                    PluginManager pluginManager = this;
                    String string21 = string19;
                    String string22 = string20;
                    Class<?> clazz = pluginManager.getPluginClass(string21, string22);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Can't find plugin: ");
                    String string23 = serviceInfo.packageName;
                    String string24 = stringBuilder.append(string23).toString();
                    int n15 = Log.e(LOGTAG, string24);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Can't find plugin's class: ");
                    String string25 = serviceInfo.name;
                    String string26 = stringBuilder.append(string25).toString();
                    int n16 = Log.e(LOGTAG, string26);
                    continue;
                }
                ArrayList<PackageInfo> arrayList4 = this.mPackageInfoCache;
                PackageInfo packageInfo3 = packageInfo;
                boolean bl = arrayList4.add(packageInfo3);
                boolean bl3 = arrayList.add(string2);
            }
        }
    }

    String getPluginSharedDataDirectory() {
        return this.mContext.getDir("plugins", 0).getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getPluginsAPKName(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) {
            return null;
        }
        ArrayList<PackageInfo> arrayList = this.mPackageInfoCache;
        synchronized (arrayList) {
            PackageInfo packageInfo;
            String string3;
            Iterator<PackageInfo> iterator = this.mPackageInfoCache.iterator();
            do {
                if (!iterator.hasNext()) return null;
                packageInfo = iterator.next();
            } while (!string2.contains(string3 = packageInfo.packageName));
            String string4 = packageInfo.packageName;
            return string4;
        }
    }

    public void refreshPlugins(boolean bl) {
        JWebCoreJavaBridge jWebCoreJavaBridge = BrowserFrame.sJavaBridge;
        Boolean bl2 = bl;
        jWebCoreJavaBridge.obtainMessage(100, bl2).sendToTarget();
    }
}

