/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.SslError;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.webkit.CallbackProxy;
import android.webkit.LoadListener;
import java.util.LinkedList;

public class SslErrorHandler
extends Handler {
    private static final int HANDLE_RESPONSE = 100;
    private static final String LOGTAG = "network";
    private final LoadListener mLoadListener;
    private LinkedList<LoadListener> mLoaderQueue;
    private final SslErrorHandler mOriginHandler;
    private Bundle mSslPrefTable;

    SslErrorHandler() {
        Bundle bundle;
        LinkedList linkedList = new LinkedList();
        this.mLoaderQueue = linkedList;
        this.mSslPrefTable = bundle = new Bundle();
        this.mOriginHandler = null;
        this.mLoadListener = null;
    }

    private SslErrorHandler(SslErrorHandler sslErrorHandler, LoadListener loadListener) {
        this.mOriginHandler = sslErrorHandler;
        this.mLoadListener = loadListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processNextLoader() {
        synchronized (this) {
            LoadListener loadListener;
            block5: {
                loadListener = this.mLoaderQueue.peek();
                if (loadListener == null) return false;
                if (!loadListener.cancelled()) break block5;
                boolean bl = this.mLoaderQueue.remove(loadListener);
                return true;
            }
            SslError sslError = loadListener.sslError();
            if (this.checkSslPrefTable(loadListener, sslError)) {
                boolean bl = this.mLoaderQueue.remove(loadListener);
                return true;
            }
            CallbackProxy callbackProxy = loadListener.getFrame().getCallbackProxy();
            SslErrorHandler sslErrorHandler = new SslErrorHandler(this, loadListener);
            callbackProxy.onReceivedSslError(sslErrorHandler, sslError);
            return false;
        }
    }

    public void cancel() {
        SslErrorHandler sslErrorHandler = this.mOriginHandler;
        SslErrorHandler sslErrorHandler2 = this.mOriginHandler;
        LoadListener loadListener = this.mLoadListener;
        Message message = sslErrorHandler2.obtainMessage(100, 0, 0, loadListener);
        boolean bl = sslErrorHandler.sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkSslPrefTable(LoadListener loadListener, SslError sslError) {
        synchronized (this) {
            String string2 = loadListener.host();
            int n = sslError.getPrimaryError();
            if (!this.mSslPrefTable.containsKey(string2)) return false;
            int n2 = this.mSslPrefTable.getInt(string2);
            if (n > n2) return false;
            this.handleSslErrorResponse(loadListener, sslError, true);
            return true;
        }
    }

    void clear() {
        synchronized (this) {
            this.mSslPrefTable.clear();
            return;
        }
    }

    void fastProcessQueuedSslErrors() {
        while (this.processNextLoader()) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 100: 
        }
        LoadListener loadListener = (LoadListener)message.obj;
        synchronized (this) {
            SslError sslError = loadListener.sslError();
            boolean bl = message.arg1 == 1;
            this.handleSslErrorResponse(loadListener, sslError, bl);
            boolean bl2 = this.mLoaderQueue.remove(loadListener);
            this.fastProcessQueuedSslErrors();
            return;
        }
    }

    void handleSslErrorRequest(LoadListener loadListener) {
        synchronized (this) {
            if (!loadListener.cancelled()) {
                boolean bl = this.mLoaderQueue.offer(loadListener);
                LoadListener loadListener2 = this.mLoaderQueue.peek();
                if (loadListener == loadListener2) {
                    this.fastProcessQueuedSslErrors();
                }
            }
            return;
        }
    }

    void handleSslErrorResponse(LoadListener loadListener, SslError sslError, boolean bl) {
        synchronized (this) {
            if (!loadListener.cancelled()) {
                if (bl) {
                    int n;
                    int n2 = sslError.getPrimaryError();
                    String string2 = loadListener.host();
                    if (!this.mSslPrefTable.containsKey(string2) || n2 > (n = this.mSslPrefTable.getInt(string2))) {
                        this.mSslPrefTable.putInt(string2, n2);
                    }
                }
                loadListener.handleSslErrorResponse(bl);
            }
            return;
        }
    }

    public void proceed() {
        SslErrorHandler sslErrorHandler = this.mOriginHandler;
        SslErrorHandler sslErrorHandler2 = this.mOriginHandler;
        LoadListener loadListener = this.mLoadListener;
        Message message = sslErrorHandler2.obtainMessage(100, 1, 0, loadListener);
        boolean bl = sslErrorHandler.sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean restoreState(Bundle bundle) {
        synchronized (this) {
            Bundle bundle2;
            if (bundle == null) return false;
            boolean bl = true;
            if (!bl) return bl;
            bl = bundle.containsKey("ssl-error-handler");
            if (!bl) return bl;
            this.mSslPrefTable = bundle2 = bundle.getBundle("ssl-error-handler");
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean saveState(Bundle bundle) {
        synchronized (this) {
            if (bundle == null) return false;
            boolean bl = true;
            if (!bl) return bl;
            Bundle bundle2 = this.mSslPrefTable;
            bundle.putBundle("ssl-error-handler", bundle2);
            return bl;
        }
    }
}

