/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.Headers;
import android.os.Handler;
import android.os.Message;
import android.webkit.LoadListener;
import java.io.IOException;
import java.io.InputStream;

abstract class StreamLoader
implements Handler.Callback {
    private static final int MSG_DATA = 102;
    private static final int MSG_END = 103;
    private static final int MSG_HEADERS = 101;
    private static final int MSG_STATUS = 100;
    protected long mContentLength;
    protected final Context mContext;
    private byte[] mData;
    protected InputStream mDataStream;
    private Handler mHandler;
    protected final LoadListener mLoadListener;

    StreamLoader(LoadListener loadListener) {
        Context context;
        this.mLoadListener = loadListener;
        this.mContext = context = loadListener.getContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeStreamAndSendEndData() {
        if (this.mDataStream != null) {
            try {
                this.mDataStream.close();
            }
            catch (IOException iOException) {}
        }
        this.mLoadListener.endData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sendData() {
        if (this.mDataStream == null) return true;
        try {
            InputStream inputStream = this.mDataStream;
            byte[] byArray = this.mData;
            int n = inputStream.read(byArray);
            if (n <= 0) return true;
            LoadListener loadListener = this.mLoadListener;
            byte[] byArray2 = this.mData;
            loadListener.data(byArray2, n);
            return false;
        }
        catch (IOException iOException) {
            LoadListener loadListener = this.mLoadListener;
            String string2 = iOException.getMessage();
            loadListener.error(65523, string2);
        }
        return true;
    }

    private void sendHeaders() {
        Headers headers = new Headers();
        if (this.mContentLength > 0L) {
            long l = this.mContentLength;
            headers.setContentLength(l);
        }
        this.buildHeaders(headers);
        this.mLoadListener.headers(headers);
    }

    protected abstract void buildHeaders(Headers var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleMessage(Message message) {
        if (this.mLoadListener.isSynchronous()) {
            throw new AssertionError();
        }
        if (this.mLoadListener.cancelled()) {
            this.closeStreamAndSendEndData();
            return true;
        }
        switch (message.what) {
            default: {
                return false;
            }
            case 100: {
                if (!this.setupStreamAndSendStatus()) return true;
                byte[] byArray = new byte[8192];
                this.mData = byArray;
                boolean bl = this.mHandler.sendEmptyMessage(101);
                return true;
            }
            case 101: {
                this.sendHeaders();
                boolean bl = this.mHandler.sendEmptyMessage(102);
                return true;
            }
            case 102: {
                if (this.sendData()) {
                    boolean bl = this.mHandler.sendEmptyMessage(103);
                    return true;
                }
                boolean bl = this.mHandler.sendEmptyMessage(102);
                return true;
            }
            case 103: 
        }
        this.closeStreamAndSendEndData();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void load() {
        // MONITORENTER : this
        if (this.mHandler == null) {
            Handler handler;
            this.mHandler = handler = new Handler(this);
        }
        // MONITOREXIT : this
        if (!this.mLoadListener.isSynchronous()) {
            boolean bl = this.mHandler.sendEmptyMessage(100);
            return;
        }
        if (!this.setupStreamAndSendStatus()) {
            return;
        }
        byte[] byArray = new byte[8192];
        this.mData = byArray;
        this.sendHeaders();
        while (!this.sendData() && !this.mLoadListener.cancelled()) {
        }
        this.closeStreamAndSendEndData();
        this.mLoadListener.loadSynchronousMessages();
    }

    protected abstract boolean setupStreamAndSendStatus();
}

