/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URLUtil {
    static final String ASSET_BASE = "file:///android_asset/";
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*(\"?)([^\"]*)\\1\\s*$", 2);
    static final String FILE_BASE = "file://";
    private static final String LOGTAG = "webkit";
    static final String PROXY_BASE = "file:///cookieless_proxy/";
    static final String RESOURCE_BASE = "file:///android_res/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String composeSearchUrl(String string2, String string3, String string4) {
        int n = string3.indexOf(string4);
        if (n < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = string3.substring(0, n);
        StringBuilder stringBuilder2 = stringBuilder.append(string5);
        try {
            String string6 = URLEncoder.encode(string2, "utf-8");
            StringBuilder stringBuilder3 = stringBuilder.append(string6);
            int n2 = string4.length() + n;
            String string7 = string3.substring(n2);
            StringBuilder stringBuilder4 = stringBuilder.append(string7);
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] decode(byte[] byArray) throws IllegalArgumentException {
        int n;
        if (byArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (int i = 0; i < (n = byArray.length); ++i) {
            byte by = byArray[i];
            if (by == 37) {
                if (byArray.length - i <= 2) throw new IllegalArgumentException("Invalid format");
                int n3 = i + 1;
                int n4 = URLUtil.parseHex(byArray[n3]) * 16;
                int n5 = i + 2;
                int n6 = URLUtil.parseHex(byArray[n5]);
                by = (byte)(n4 + n6);
                i += 2;
            }
            int n7 = n2 + 1;
            byArray2[n2] = by;
            n2 = n7;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String guessFileName(String string2, String string3, String string4) {
        int n;
        String string5;
        int n2;
        String string6 = null;
        String string7 = null;
        if (string6 == null && string3 != null && (string6 = URLUtil.parseContentDisposition(string3)) != null && (n2 = string6.lastIndexOf(47) + 1) > 0) {
            string6 = string6.substring(n2);
        }
        if (string6 == null && (string5 = Uri.decode(string2)) != null) {
            int n3 = string5.indexOf(63);
            if (n3 > 0) {
                string5 = string5.substring(0, n3);
            }
            if (!string5.endsWith("/") && (n2 = string5.lastIndexOf(47) + 1) > 0) {
                string6 = string5.substring(n2);
            }
        }
        if (string6 == null) {
            string6 = "downloadfile";
        }
        if ((n = string6.indexOf(46)) < 0) {
            if (string4 != null && (string7 = MimeTypeMap.getSingleton().getExtensionFromMimeType(string4)) != null) {
                string7 = "." + string7;
            }
            if (string7 != null) return string6 + string7;
            if (string4 != null && string4.toLowerCase().startsWith("text/")) {
                if (string4.equalsIgnoreCase("text/html")) {
                    string7 = ".html";
                    return string6 + string7;
                }
                string7 = ".txt";
                return string6 + string7;
            }
            string7 = ".bin";
            return string6 + string7;
        }
        if (string4 != null) {
            int n4;
            String string8;
            int n5 = string6.lastIndexOf(46);
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            String string9 = mimeTypeMap.getMimeTypeFromExtension(string8 = string6.substring(n4 = n5 + 1));
            if (string9 != null && !string9.equalsIgnoreCase(string4) && (string7 = MimeTypeMap.getSingleton().getExtensionFromMimeType(string4)) != null) {
                string7 = "." + string7;
            }
        }
        if (string7 == null) {
            string7 = string6.substring(n);
        }
        string6 = string6.substring(0, n);
        return string6 + string7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String guessUrl(String string2) {
        String string3;
        WebAddress webAddress;
        String string4 = string2;
        String string5 = "guessURL before queueRequest: " + string2;
        int n = Log.v(LOGTAG, string5);
        if (string2.length() == 0) {
            return string2;
        }
        if (string2.startsWith("about:")) {
            return string2;
        }
        if (string2.startsWith("data:")) {
            return string2;
        }
        if (string2.startsWith("file:")) {
            return string2;
        }
        if (string2.startsWith("javascript:")) {
            return string2;
        }
        if (string2.endsWith(".")) {
            int n2 = string2.length() - 1;
            string2 = string2.substring(0, n2);
        }
        try {
            webAddress = new WebAddress(string2);
        }
        catch (ParseException parseException) {
            return string4;
        }
        if (webAddress.mHost.indexOf(46) != -1) return webAddress.toString();
        StringBuilder stringBuilder = new StringBuilder().append("www.");
        String string6 = webAddress.mHost;
        webAddress.mHost = string3 = stringBuilder.append(string6).append(".com").toString();
        return webAddress.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAboutUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("about:")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAssetUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith(ASSET_BASE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isContentUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("content:")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static boolean isCookielessProxyUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith(PROXY_BASE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDataUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("data:")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFileUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith(FILE_BASE)) return false;
        if (string2.startsWith(ASSET_BASE)) return false;
        if (string2.startsWith(PROXY_BASE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHttpUrl(String string2) {
        if (string2 == null) return false;
        if (string2.length() <= 6) return false;
        if (!string2.substring(0, 7).equalsIgnoreCase("http://")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHttpsUrl(String string2) {
        if (string2 == null) return false;
        if (string2.length() <= 7) return false;
        if (!string2.substring(0, 8).equalsIgnoreCase("https://")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isJavaScriptUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith("javascript:")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNetworkUrl(String string2) {
        if (string2 == null) return false;
        if (string2.length() == 0) {
            return false;
        }
        if (URLUtil.isHttpUrl(string2)) return true;
        if (!URLUtil.isHttpsUrl(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isResourceUrl(String string2) {
        if (string2 == null) return false;
        if (!string2.startsWith(RESOURCE_BASE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidUrl(String string2) {
        if (string2 == null) return false;
        if (string2.length() == 0) {
            return false;
        }
        if (URLUtil.isAssetUrl(string2)) return true;
        if (URLUtil.isResourceUrl(string2)) return true;
        if (URLUtil.isFileUrl(string2)) return true;
        if (URLUtil.isAboutUrl(string2)) return true;
        if (URLUtil.isHttpUrl(string2)) return true;
        if (URLUtil.isHttpsUrl(string2)) return true;
        if (URLUtil.isJavaScriptUrl(string2)) return true;
        if (!URLUtil.isContentUrl(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String parseContentDisposition(String string2) {
        try {
            Matcher matcher = CONTENT_DISPOSITION_PATTERN.matcher(string2);
            if (!matcher.find()) return null;
            String string3 = matcher.group(2);
            return string3;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseHex(byte by) {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 65 + 10;
        }
        if (by >= 97 && by <= 102) {
            return by - 97 + 10;
        }
        String string2 = "Invalid hex char '" + by + "'";
        throw new IllegalArgumentException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stripAnchor(String string2) {
        int n = string2.indexOf(35);
        if (n == -1) return string2;
        return string2.substring(0, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean verifyURLEncoding(String string2) {
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        int n2 = string2.indexOf(37);
        while (n2 >= 0) {
            int n6;
            if (n2 >= n) return true;
            int n3 = n - 2;
            if (n2 >= n3) {
                return false;
            }
            ++n2;
            try {
                int n4 = URLUtil.parseHex((byte)string2.charAt(n2));
                int n5 = URLUtil.parseHex((byte)string2.charAt(++n2));
                n6 = n2 + 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            int n7 = string2.indexOf(37, n6);
        }
        return true;
    }
}

