/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import java.util.ArrayList;
import java.util.Iterator;

class ViewManager {
    private static final int MAX_SURFACE_DIMENSION = 2048;
    private final int MAX_SURFACE_AREA;
    private final ArrayList<ChildView> mChildren;
    private boolean mHidden;
    private boolean mReadyToDraw;
    private final WebView mWebView;
    private boolean mZoomInProgress;

    ViewManager(WebView webView) {
        int n;
        ArrayList arrayList = new ArrayList();
        this.mChildren = arrayList;
        this.mZoomInProgress = false;
        this.mWebView = webView;
        int n2 = webView.getResources().getDisplayMetrics().widthPixels;
        int n3 = webView.getResources().getDisplayMetrics().heightPixels;
        this.MAX_SURFACE_AREA = n = (int)((double)(n2 * n3) * 2.75);
    }

    static /* synthetic */ boolean access$402(ViewManager viewManager, boolean bl) {
        viewManager.mReadyToDraw = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void requestLayout(ChildView childView) {
        int n;
        int n2;
        AbsoluteLayout.LayoutParams layoutParams;
        WebView webView = this.mWebView;
        int n3 = childView.width;
        int n4 = webView.contentToViewDimension(n3);
        WebView webView2 = this.mWebView;
        int n5 = childView.height;
        int n6 = webView2.contentToViewDimension(n5);
        WebView webView3 = this.mWebView;
        int n7 = childView.x;
        int n8 = webView3.contentToViewX(n7);
        WebView webView4 = this.mWebView;
        int n9 = childView.y;
        int n10 = webView4.contentToViewY(n9);
        ViewGroup.LayoutParams layoutParams2 = childView.mView.getLayoutParams();
        if (layoutParams2 instanceof AbsoluteLayout.LayoutParams) {
            layoutParams = (AbsoluteLayout.LayoutParams)layoutParams2;
            layoutParams.width = n4;
            layoutParams.height = n6;
            layoutParams.x = n8;
            layoutParams.y = n10;
        } else {
            layoutParams = new AbsoluteLayout.LayoutParams(n4, n6, n8, n10);
        }
        childView.mView.setLayoutParams(layoutParams);
        if (!(childView.mView instanceof SurfaceView)) {
            return;
        }
        final SurfaceView surfaceView = (SurfaceView)childView.mView;
        if (surfaceView.isFixedSize() && this.mZoomInProgress) {
            return;
        }
        int n11 = n4;
        int n12 = n6;
        if (n11 > 2048 || n12 > 2048) {
            int n13 = childView.width;
            int n14 = childView.height;
            if (n13 > n14) {
                n11 = 2048;
                int n15 = childView.height * 2048;
                int n16 = childView.width;
                n12 = n15 / n16;
            } else {
                n12 = 2048;
                int n17 = childView.width * 2048;
                int n18 = childView.height;
                n11 = n17 / n18;
            }
        }
        if ((n2 = n11 * n12) > (n = this.MAX_SURFACE_AREA)) {
            float f = this.MAX_SURFACE_AREA;
            int n19 = childView.width;
            int n20 = childView.height;
            if (n19 > n20) {
                float f2 = (float)childView.width * f;
                float f3 = childView.height;
                n11 = (int)Math.sqrt(f2 / f3);
                int n21 = childView.height * n11;
                int n22 = childView.width;
                n12 = n21 / n22;
            } else {
                float f4 = (float)childView.height * f;
                float f5 = childView.width;
                n12 = (int)Math.sqrt(f4 / f5);
                int n23 = childView.width * n12;
                int n24 = childView.height;
                n11 = n23 / n24;
            }
        }
        if (n11 == n4 || n12 != n6) {
            surfaceView.getHolder().setFixedSize(n11, n12);
            return;
        }
        if (!surfaceView.isFixedSize() && this.mZoomInProgress) {
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            int n25 = surfaceView.getWidth();
            int n26 = surfaceView.getHeight();
            surfaceHolder.setFixedSize(n25, n26);
            return;
        }
        if (!surfaceView.isFixedSize()) {
            return;
        }
        if (this.mZoomInProgress) {
            return;
        }
        if (surfaceView.getVisibility() == 0) {
            surfaceView.setVisibility(4);
            surfaceView.getHolder().setSizeFromLayout();
            Handler handler = this.mWebView.mPrivateHandler;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    surfaceView.setVisibility(0);
                }
            };
            boolean bl = handler.post(runnable);
            return;
        }
        surfaceView.getHolder().setSizeFromLayout();
    }

    ChildView createView() {
        return new ChildView();
    }

    void endZoom() {
        this.mZoomInProgress = false;
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            ChildView childView = iterator.next();
            this.requestLayout(childView);
        }
        return;
    }

    void hideAll() {
        if (this.mHidden) {
            return;
        }
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            iterator.next().mView.setVisibility(8);
        }
        this.mHidden = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ChildView hitTest(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        ChildView childView;
        if (this.mHidden) {
            return null;
        }
        Iterator<ChildView> iterator = this.mChildren.iterator();
        do {
            if (!iterator.hasNext()) return null;
            childView = iterator.next();
        } while (childView.mView.getVisibility() != 0 || n < (n10 = childView.x) || n >= (n9 = (n8 = childView.x) + (n7 = childView.width)) || n2 < (n6 = childView.y) || n2 >= (n5 = (n4 = childView.y) + (n3 = childView.height)));
        return childView;
    }

    void postReadyToDrawAll() {
        Handler handler = this.mWebView.mPrivateHandler;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = ViewManager.access$402(ViewManager.this, true);
                Iterator iterator = ViewManager.this.mChildren.iterator();
                while (iterator.hasNext()) {
                    ((ChildView)iterator.next()).mView.setVisibility(0);
                }
                return;
            }
        };
        boolean bl = handler.post(runnable);
    }

    void postResetStateAll() {
        Handler handler = this.mWebView.mPrivateHandler;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = ViewManager.access$402(ViewManager.this, false);
            }
        };
        boolean bl = handler.post(runnable);
    }

    void scaleAll() {
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            ChildView childView = iterator.next();
            this.requestLayout(childView);
        }
        return;
    }

    void showAll() {
        if (!this.mHidden) {
            return;
        }
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            iterator.next().mView.setVisibility(0);
        }
        this.mHidden = false;
    }

    void startZoom() {
        this.mZoomInProgress = true;
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            ChildView childView = iterator.next();
            this.requestLayout(childView);
        }
        return;
    }

    class ChildView {
        int height;
        View mView;
        int width;
        int x;
        int y;

        ChildView() {
        }

        private void attachViewOnUIThread() {
            WebView webView = ViewManager.this.mWebView;
            View view = this.mView;
            webView.addView(view);
            boolean bl = ViewManager.this.mChildren.add(this);
            if (ViewManager.this.mReadyToDraw) {
                return;
            }
            this.mView.setVisibility(8);
        }

        private void removeViewOnUIThread() {
            WebView webView = ViewManager.this.mWebView;
            View view = this.mView;
            webView.removeView(view);
            boolean bl = ViewManager.this.mChildren.remove(this);
        }

        void attachView(int n, int n2, int n3, int n4) {
            if (this.mView == null) {
                return;
            }
            this.setBounds(n, n2, n3, n4);
            Handler handler = ((ViewManager)ViewManager.this).mWebView.mPrivateHandler;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ViewManager viewManager = ViewManager.this;
                    ChildView childView = ChildView.this;
                    viewManager.requestLayout(childView);
                    if (ChildView.this.mView.getParent() != null) {
                        return;
                    }
                    ChildView.this.attachViewOnUIThread();
                }
            };
            boolean bl = handler.post(runnable);
        }

        void removeView() {
            if (this.mView == null) {
                return;
            }
            Handler handler = ((ViewManager)ViewManager.this).mWebView.mPrivateHandler;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ChildView.this.removeViewOnUIThread();
                }
            };
            boolean bl = handler.post(runnable);
        }

        void setBounds(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }
}

