/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.webkit.CallbackProxy;
import android.webkit.WebHistoryItem;
import java.io.Serializable;
import java.util.ArrayList;

public class WebBackForwardList
implements Cloneable,
Serializable {
    private ArrayList<WebHistoryItem> mArray;
    private final CallbackProxy mCallbackProxy;
    private boolean mClearPending;
    private int mCurrentIndex = -1;

    WebBackForwardList(CallbackProxy callbackProxy) {
        ArrayList arrayList = new ArrayList();
        this.mArray = arrayList;
        this.mCallbackProxy = callbackProxy;
    }

    private static native void nativeClose(int var0);

    private void removeHistoryItem(int n) {
        synchronized (this) {
            int n2;
            WebHistoryItem webHistoryItem = this.mArray.remove(n);
            this.mCurrentIndex = n2 = this.mCurrentIndex - 1;
            return;
        }
    }

    static synchronized native void restoreIndex(int var0, int var1);

    void addHistoryItem(WebHistoryItem webHistoryItem) {
        synchronized (this) {
            int n;
            this.mCurrentIndex = n = this.mCurrentIndex + 1;
            int n2 = this.mArray.size();
            int n3 = this.mCurrentIndex;
            if (n3 != n2) {
                for (int i = n2 - 1; i >= n3; i += -1) {
                    WebHistoryItem webHistoryItem2 = this.mArray.remove(i);
                }
            }
            boolean bl = this.mArray.add(webHistoryItem);
            if (this.mCallbackProxy != null) {
                this.mCallbackProxy.onNewHistoryItem(webHistoryItem);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WebBackForwardList clone() {
        synchronized (this) {
            WebBackForwardList webBackForwardList = new WebBackForwardList(null);
            if (this.mClearPending) {
                WebHistoryItem webHistoryItem = this.getCurrentItem();
                webBackForwardList.addHistoryItem(webHistoryItem);
            } else {
                int n;
                webBackForwardList.mCurrentIndex = n = this.mCurrentIndex;
                int n2 = this.getSize();
                ArrayList arrayList = new ArrayList(n2);
                webBackForwardList.mArray = arrayList;
                for (int i = 0; i < n2; ++i) {
                    ArrayList<WebHistoryItem> arrayList2 = webBackForwardList.mArray;
                    WebHistoryItem webHistoryItem = this.mArray.get(i).clone();
                    boolean bl = arrayList2.add(webHistoryItem);
                }
            }
            return webBackForwardList;
        }
    }

    void close(int n) {
        synchronized (this) {
            this.mArray.clear();
            this.mCurrentIndex = -1;
            WebBackForwardList.nativeClose(n);
            this.mClearPending = false;
            return;
        }
    }

    boolean getClearPending() {
        synchronized (this) {
            boolean bl = this.mClearPending;
            return bl;
        }
    }

    public int getCurrentIndex() {
        synchronized (this) {
            int n = this.mCurrentIndex;
            return n;
        }
    }

    public WebHistoryItem getCurrentItem() {
        synchronized (this) {
            WebHistoryItem webHistoryItem;
            int n = this.mCurrentIndex;
            WebHistoryItem webHistoryItem2 = webHistoryItem = this.getItemAtIndex(n);
            return webHistoryItem2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebHistoryItem getItemAtIndex(int n) {
        synchronized (this) {
            block6: {
                int n2;
                if (n < 0) return null;
                int n3 = n2 = this.getSize();
                if (n < n3) break block6;
                return null;
            }
            WebHistoryItem webHistoryItem = this.mArray.get(n);
            return webHistoryItem;
        }
    }

    public int getSize() {
        synchronized (this) {
            int n;
            int n2 = n = this.mArray.size();
            return n2;
        }
    }

    void setClearPending() {
        synchronized (this) {
            this.mClearPending = true;
            return;
        }
    }

    void setCurrentIndex(int n) {
        synchronized (this) {
            this.mCurrentIndex = n;
            if (this.mCallbackProxy != null) {
                CallbackProxy callbackProxy = this.mCallbackProxy;
                WebHistoryItem webHistoryItem = this.getItemAtIndex(n);
                callbackProxy.onIndexChanged(webHistoryItem, n);
            }
            return;
        }
    }
}

