/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

public final class WebIconDatabase {
    private static final String LOGTAG = "WebIconDatabase";
    private static WebIconDatabase sIconDatabase;
    private final EventHandler mEventHandler;

    private WebIconDatabase() {
        EventHandler eventHandler;
        this.mEventHandler = eventHandler = new EventHandler();
    }

    public static WebIconDatabase getInstance() {
        if (sIconDatabase == null) {
            sIconDatabase = new WebIconDatabase();
        }
        return sIconDatabase;
    }

    private static native void nativeClose();

    private static native Bitmap nativeIconForPageUrl(String var0);

    private static native void nativeOpen(String var0);

    private static native void nativeReleaseIconForPageUrl(String var0);

    private static native void nativeRemoveAllIcons();

    private static native void nativeRetainIconForPageUrl(String var0);

    public void bulkRequestIconForPageUrl(ContentResolver contentResolver, String string2, IconListener iconListener) {
        if (iconListener == null) {
            return;
        }
        if (!this.mEventHandler.hasHandler()) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ContentResolver contentResolver2 = hashMap.put("contentResolver", contentResolver);
        String string3 = hashMap.put("where", string2);
        IconListener iconListener2 = hashMap.put("listener", iconListener);
        Message message = Message.obtain(null, 6, hashMap);
        this.mEventHandler.postMessage(message);
    }

    public void close() {
        EventHandler eventHandler = this.mEventHandler;
        Message message = Message.obtain(null, 1);
        eventHandler.postMessage(message);
    }

    void createHandler() {
        this.mEventHandler.createHandler();
    }

    public void open(String string2) {
        if (string2 == null) {
            return;
        }
        File file = new File(string2);
        if (!file.exists()) {
            boolean bl = file.mkdirs();
        }
        EventHandler eventHandler = this.mEventHandler;
        String string3 = file.getAbsolutePath();
        Message message = Message.obtain(null, 0, string3);
        eventHandler.postMessage(message);
    }

    public void releaseIconForPageUrl(String string2) {
        if (string2 == null) {
            return;
        }
        EventHandler eventHandler = this.mEventHandler;
        Message message = Message.obtain(null, 5, string2);
        eventHandler.postMessage(message);
    }

    public void removeAllIcons() {
        EventHandler eventHandler = this.mEventHandler;
        Message message = Message.obtain(null, 2);
        eventHandler.postMessage(message);
    }

    public void requestIconForPageUrl(String string2, IconListener iconListener) {
        if (iconListener == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        Message message = Message.obtain(null, 3, iconListener);
        message.getData().putString("url", string2);
        this.mEventHandler.postMessage(message);
    }

    public void retainIconForPageUrl(String string2) {
        if (string2 == null) {
            return;
        }
        EventHandler eventHandler = this.mEventHandler;
        Message message = Message.obtain(null, 4, string2);
        eventHandler.postMessage(message);
    }

    public static interface IconListener {
        public void onReceivedIcon(String var1, Bitmap var2);
    }

    private static class EventHandler
    extends Handler {
        static final int BULK_REQUEST_ICON = 6;
        static final int CLOSE = 1;
        private static final int ICON_RESULT = 10;
        static final int OPEN = 0;
        static final int RELEASE_ICON = 5;
        static final int REMOVE_ALL = 2;
        static final int REQUEST_ICON = 3;
        static final int RETAIN_ICON = 4;
        private Handler mHandler;
        private Vector<Message> mMessages;

        private EventHandler() {
            Vector vector = new Vector();
            this.mMessages = vector;
        }

        /*
         * Exception decompiling
         */
        private void bulkRequestIcons(Message var1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void createHandler() {
            synchronized (this) {
                if (this.mHandler == null) {
                    Handler handler;
                    this.mHandler = handler = new Handler(){

                        @Override
                        public void handleMessage(Message message) {
                            switch (message.what) {
                                default: {
                                    return;
                                }
                                case 0: {
                                    WebIconDatabase.nativeOpen((String)message.obj);
                                    return;
                                }
                                case 1: {
                                    WebIconDatabase.nativeClose();
                                    return;
                                }
                                case 2: {
                                    WebIconDatabase.nativeRemoveAllIcons();
                                    return;
                                }
                                case 3: {
                                    IconListener iconListener = (IconListener)message.obj;
                                    String string2 = message.getData().getString("url");
                                    EventHandler.this.requestIconAndSendResult(string2, iconListener);
                                    return;
                                }
                                case 6: {
                                    EventHandler.this.bulkRequestIcons(message);
                                    return;
                                }
                                case 4: {
                                    WebIconDatabase.nativeRetainIconForPageUrl((String)message.obj);
                                    return;
                                }
                                case 5: 
                            }
                            WebIconDatabase.nativeReleaseIconForPageUrl((String)message.obj);
                        }
                    };
                    for (int i = this.mMessages.size(); i > 0; i += -1) {
                        Handler handler2 = this.mHandler;
                        Message message = this.mMessages.remove(0);
                        boolean bl = handler2.sendMessage(message);
                    }
                    this.mMessages = null;
                }
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean hasHandler() {
            synchronized (this) {
                Handler handler = this.mHandler;
                if (handler == null) return false;
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void postMessage(Message message) {
            synchronized (this) {
                if (this.mMessages != null) {
                    boolean bl = this.mMessages.add(message);
                } else {
                    boolean bl = this.mHandler.sendMessage(message);
                }
                return;
            }
        }

        private void requestIconAndSendResult(String string2, IconListener iconListener) {
            Bitmap bitmap = WebIconDatabase.nativeIconForPageUrl(string2);
            if (bitmap == null) {
                return;
            }
            IconResult iconResult = new IconResult(string2, bitmap, iconListener);
            Message message = this.obtainMessage(10, iconResult);
            boolean bl = this.sendMessage(message);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 10: 
            }
            ((IconResult)message.obj).dispatch();
        }

        private class IconResult {
            private final Bitmap mIcon;
            private final IconListener mListener;
            private final String mUrl;

            IconResult(String string2, Bitmap bitmap, IconListener iconListener) {
                this.mUrl = string2;
                this.mIcon = bitmap;
                this.mListener = iconListener;
            }

            void dispatch() {
                IconListener iconListener = this.mListener;
                String string2 = this.mUrl;
                Bitmap bitmap = this.mIcon;
                iconListener.onReceivedIcon(string2, bitmap);
            }
        }
    }
}

