/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.EventLog;
import android.webkit.BrowserFrame;
import android.webkit.WebView;
import java.util.Locale;

public class WebSettings {
    private static final String DESKTOP_USERAGENT = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_7; en-us) AppleWebKit/530.17 (KHTML, like Gecko) Version/4.0 Safari/530.17";
    private static final String DOUBLE_TAP_TOAST_COUNT = "double_tap_toast_count";
    private static final String IPHONE_USERAGENT = "Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_0 like Mac OS X; en-us) AppleWebKit/528.18 (KHTML, like Gecko) Version/4.0 Mobile/7A341 Safari/528.16";
    public static final int LOAD_CACHE_ELSE_NETWORK = 1;
    public static final int LOAD_CACHE_ONLY = 3;
    public static final int LOAD_DEFAULT = 255;
    public static final int LOAD_NORMAL = 0;
    public static final int LOAD_NO_CACHE = 2;
    private static final String PREF_FILE = "WebViewSettings";
    private static int mDoubleTapToastCount = 3;
    private static Locale sLocale;
    private static Object sLockForLocaleSettings;
    private String mAcceptLanguage;
    private boolean mAllowFileAccess;
    private boolean mAppCacheEnabled;
    private long mAppCacheMaxSize;
    private String mAppCachePath;
    private boolean mBlockNetworkImage;
    private boolean mBlockNetworkLoads;
    private BrowserFrame mBrowserFrame;
    private boolean mBuiltInZoomControls;
    private Context mContext;
    private String mCursiveFontFamily;
    private boolean mDatabaseEnabled;
    private String mDatabasePath;
    private boolean mDatabasePathHasBeenSet;
    private int mDefaultFixedFontSize;
    private int mDefaultFontSize;
    private String mDefaultTextEncoding;
    private ZoomDensity mDefaultZoom;
    private boolean mDomStorageEnabled;
    private final EventHandler mEventHandler;
    private String mFantasyFontFamily;
    private String mFixedFontFamily;
    private String mGeolocationDatabasePath;
    private boolean mGeolocationEnabled;
    private boolean mJavaScriptCanOpenWindowsAutomatically;
    private boolean mJavaScriptEnabled;
    private LayoutAlgorithm mLayoutAlgorithm;
    private boolean mLightTouchEnabled;
    private boolean mLoadWithOverviewMode;
    private boolean mLoadsImagesAutomatically;
    private int mMinimumFontSize;
    private int mMinimumLogicalFontSize;
    private boolean mNavDump;
    private boolean mNeedInitialFocus;
    private int mOverrideCacheMode;
    private int mPageCacheCapacity;
    private PluginState mPluginState;
    private RenderPriority mRenderPriority;
    private String mSansSerifFontFamily;
    private boolean mSaveFormData;
    private boolean mSavePassword;
    private String mSerifFontFamily;
    private boolean mShrinksStandaloneImagesToFit;
    private String mStandardFontFamily;
    private boolean mSupportMultipleWindows;
    private boolean mSupportZoom;
    private boolean mSyncPending = false;
    private TextSize mTextSize;
    private boolean mUseDefaultUserAgent;
    private boolean mUseDoubleTree;
    private boolean mUseWebViewBackgroundOverscrollBackground;
    private boolean mUseWideViewport;
    private String mUserAgent;
    private WebView mWebView;
    private boolean mWorkersEnabled;

    /*
     * Enabled aggressive block sorting
     */
    WebSettings(Context context, WebView webView) {
        int n;
        String string2;
        String string3;
        String string4;
        EventHandler eventHandler;
        RenderPriority renderPriority;
        ZoomDensity zoomDensity;
        PluginState pluginState;
        TextSize textSize;
        LayoutAlgorithm layoutAlgorithm;
        this.mLayoutAlgorithm = layoutAlgorithm = LayoutAlgorithm.NARROW_COLUMNS;
        this.mTextSize = textSize = TextSize.NORMAL;
        this.mStandardFontFamily = "sans-serif";
        this.mFixedFontFamily = "monospace";
        this.mSansSerifFontFamily = "sans-serif";
        this.mSerifFontFamily = "serif";
        this.mCursiveFontFamily = "cursive";
        this.mFantasyFontFamily = "fantasy";
        this.mMinimumFontSize = 8;
        this.mMinimumLogicalFontSize = 8;
        this.mDefaultFontSize = 16;
        this.mDefaultFixedFontSize = 13;
        this.mPageCacheCapacity = 0;
        this.mLoadsImagesAutomatically = true;
        this.mBlockNetworkImage = false;
        this.mJavaScriptEnabled = false;
        this.mPluginState = pluginState = PluginState.OFF;
        this.mJavaScriptCanOpenWindowsAutomatically = false;
        this.mUseDoubleTree = false;
        this.mUseWideViewport = false;
        this.mSupportMultipleWindows = false;
        this.mShrinksStandaloneImagesToFit = false;
        this.mAppCacheEnabled = false;
        this.mDatabaseEnabled = false;
        this.mDomStorageEnabled = false;
        this.mWorkersEnabled = false;
        this.mGeolocationEnabled = true;
        this.mAppCacheMaxSize = Long.MAX_VALUE;
        this.mAppCachePath = "";
        this.mDatabasePath = "";
        this.mDatabasePathHasBeenSet = false;
        this.mGeolocationDatabasePath = "";
        this.mDefaultZoom = zoomDensity = ZoomDensity.MEDIUM;
        this.mRenderPriority = renderPriority = RenderPriority.NORMAL;
        this.mOverrideCacheMode = -1;
        this.mSaveFormData = true;
        this.mSavePassword = true;
        this.mLightTouchEnabled = false;
        this.mNeedInitialFocus = true;
        this.mNavDump = false;
        this.mSupportZoom = true;
        this.mBuiltInZoomControls = false;
        this.mAllowFileAccess = true;
        this.mLoadWithOverviewMode = false;
        this.mUseWebViewBackgroundOverscrollBackground = true;
        this.mEventHandler = eventHandler = new EventHandler();
        this.mContext = context;
        this.mWebView = webView;
        this.mDefaultTextEncoding = string4 = context.getString(17039528);
        if (sLockForLocaleSettings == null) {
            sLockForLocaleSettings = new Object();
            sLocale = Locale.getDefault();
        }
        this.mAcceptLanguage = string3 = this.getCurrentAcceptLanguage();
        this.mUserAgent = string2 = this.getCurrentUserAgent();
        this.mUseDefaultUserAgent = true;
        Context context2 = this.mContext;
        int n2 = Process.myPid();
        boolean bl = context2.checkPermission("android.permission.INTERNET", n2, n = Process.myUid()) != 0;
        this.mBlockNetworkLoads = bl;
    }

    static /* synthetic */ boolean access$202(WebSettings webSettings, boolean bl) {
        webSettings.mSyncPending = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCurrentAcceptLanguage() {
        Locale locale;
        String string2;
        Locale locale2;
        String string3 = "-";
        Object object = sLockForLocaleSettings;
        synchronized (object) {
            locale2 = sLocale;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = locale2.getLanguage();
        if (string4 != null) {
            StringBuffer stringBuffer2 = stringBuffer.append(string4);
            string2 = locale2.getCountry();
            if (string2 != null) {
                StringBuffer stringBuffer3 = stringBuffer.append("-");
                StringBuffer stringBuffer4 = stringBuffer.append(string2);
            }
        }
        if (!locale2.equals(locale = Locale.US)) {
            StringBuffer stringBuffer5 = stringBuffer.append(", ");
            Locale locale3 = Locale.US;
            if (locale3.getLanguage() != null) {
                String string5 = locale3.getLanguage();
                StringBuffer stringBuffer6 = stringBuffer.append(string5);
                string2 = locale3.getCountry();
                if (string2 != null) {
                    StringBuffer stringBuffer7 = stringBuffer.append("-");
                    StringBuffer stringBuffer8 = stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCurrentUserAgent() {
        synchronized (this) {
            String string2;
            String string3;
            String string4;
            Locale locale;
            Object object = sLockForLocaleSettings;
            synchronized (object) {
                locale = sLocale;
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string5 = Build.VERSION.RELEASE;
            if (string5.length() > 0) {
                StringBuffer stringBuffer2 = stringBuffer.append(string5);
            } else {
                StringBuffer stringBuffer3 = stringBuffer.append("1.0");
            }
            StringBuffer stringBuffer4 = stringBuffer.append("; ");
            String string6 = locale.getLanguage();
            if (string6 != null) {
                String string7 = string6.toLowerCase();
                StringBuffer stringBuffer5 = stringBuffer.append(string7);
                String string8 = locale.getCountry();
                if (string8 != null) {
                    StringBuffer stringBuffer6 = stringBuffer.append("-");
                    String string9 = string8.toLowerCase();
                    StringBuffer stringBuffer7 = stringBuffer.append(string9);
                }
            } else {
                StringBuffer stringBuffer8 = stringBuffer.append("en");
            }
            if ("REL".equals(string4 = Build.VERSION.CODENAME) && (string3 = Build.MODEL).length() > 0) {
                StringBuffer stringBuffer9 = stringBuffer.append("; ");
                StringBuffer stringBuffer10 = stringBuffer.append(string3);
            }
            if ((string2 = Build.ID).length() > 0) {
                StringBuffer stringBuffer11 = stringBuffer.append(" Build/");
                StringBuffer stringBuffer12 = stringBuffer.append(string2);
            }
            String string10 = ((Object)this.mContext.getResources().getText(17040046)).toString();
            Object[] objectArray = new Object[]{stringBuffer};
            String string11 = String.format(string10, objectArray);
            return string11;
        }
    }

    private native void nativeSync(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pin(int n) {
        int n2 = 1;
        if (n < n2) {
            return n2;
        }
        if (n <= 72) return n;
        return 72;
    }

    private void postSync() {
        synchronized (this) {
            if (!this.mSyncPending) {
                boolean bl;
                EventHandler eventHandler = this.mEventHandler;
                Message message = Message.obtain(null, 0);
                this.mSyncPending = bl = eventHandler.sendMessage(message);
            }
            return;
        }
    }

    private void verifyNetworkAccess() {
        int n;
        if (this.mBlockNetworkLoads) {
            return;
        }
        Context context = this.mContext;
        int n2 = Process.myPid();
        if (context.checkPermission("android.permission.INTERNET", n2, n = Process.myUid()) == 0) {
            return;
        }
        throw new SecurityException("Permission denied - application missing INTERNET permission");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getAcceptLanguage() {
        synchronized (this) {
            Object object = sLockForLocaleSettings;
            synchronized (object) {
                String string2;
                Locale locale = Locale.getDefault();
                if (sLocale.equals(locale)) return this.mAcceptLanguage;
                sLocale = locale;
                this.mAcceptLanguage = string2 = this.getCurrentAcceptLanguage();
                return this.mAcceptLanguage;
            }
        }
    }

    public boolean getAllowFileAccess() {
        return this.mAllowFileAccess;
    }

    public boolean getBlockNetworkImage() {
        synchronized (this) {
            boolean bl = this.mBlockNetworkImage;
            return bl;
        }
    }

    public boolean getBlockNetworkLoads() {
        synchronized (this) {
            boolean bl = this.mBlockNetworkLoads;
            return bl;
        }
    }

    public boolean getBuiltInZoomControls() {
        return this.mBuiltInZoomControls;
    }

    public int getCacheMode() {
        return this.mOverrideCacheMode;
    }

    public String getCursiveFontFamily() {
        synchronized (this) {
            String string2 = this.mCursiveFontFamily;
            return string2;
        }
    }

    public boolean getDatabaseEnabled() {
        synchronized (this) {
            boolean bl = this.mDatabaseEnabled;
            return bl;
        }
    }

    public String getDatabasePath() {
        synchronized (this) {
            String string2 = this.mDatabasePath;
            return string2;
        }
    }

    public int getDefaultFixedFontSize() {
        synchronized (this) {
            int n = this.mDefaultFixedFontSize;
            return n;
        }
    }

    public int getDefaultFontSize() {
        synchronized (this) {
            int n = this.mDefaultFontSize;
            return n;
        }
    }

    public String getDefaultTextEncodingName() {
        synchronized (this) {
            String string2 = this.mDefaultTextEncoding;
            return string2;
        }
    }

    public ZoomDensity getDefaultZoom() {
        return this.mDefaultZoom;
    }

    public boolean getDomStorageEnabled() {
        synchronized (this) {
            boolean bl = this.mDomStorageEnabled;
            return bl;
        }
    }

    int getDoubleTapToastCount() {
        return mDoubleTapToastCount;
    }

    public String getFantasyFontFamily() {
        synchronized (this) {
            String string2 = this.mFantasyFontFamily;
            return string2;
        }
    }

    public String getFixedFontFamily() {
        synchronized (this) {
            String string2 = this.mFixedFontFamily;
            return string2;
        }
    }

    public boolean getJavaScriptCanOpenWindowsAutomatically() {
        synchronized (this) {
            boolean bl = this.mJavaScriptCanOpenWindowsAutomatically;
            return bl;
        }
    }

    public boolean getJavaScriptEnabled() {
        synchronized (this) {
            boolean bl = this.mJavaScriptEnabled;
            return bl;
        }
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        synchronized (this) {
            LayoutAlgorithm layoutAlgorithm = this.mLayoutAlgorithm;
            return layoutAlgorithm;
        }
    }

    public boolean getLightTouchEnabled() {
        return this.mLightTouchEnabled;
    }

    public boolean getLoadWithOverviewMode() {
        return this.mLoadWithOverviewMode;
    }

    public boolean getLoadsImagesAutomatically() {
        synchronized (this) {
            boolean bl = this.mLoadsImagesAutomatically;
            return bl;
        }
    }

    public int getMinimumFontSize() {
        synchronized (this) {
            int n = this.mMinimumFontSize;
            return n;
        }
    }

    public int getMinimumLogicalFontSize() {
        synchronized (this) {
            int n = this.mMinimumLogicalFontSize;
            return n;
        }
    }

    public boolean getNavDump() {
        return this.mNavDump;
    }

    boolean getNeedInitialFocus() {
        return this.mNeedInitialFocus;
    }

    public PluginState getPluginState() {
        synchronized (this) {
            PluginState pluginState = this.mPluginState;
            return pluginState;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean getPluginsEnabled() {
        synchronized (this) {
            PluginState pluginState = this.mPluginState;
            PluginState pluginState2 = PluginState.ON;
            if (pluginState != pluginState2) return false;
            return true;
        }
    }

    @Deprecated
    public String getPluginsPath() {
        synchronized (this) {
            String string2 = "";
            return string2;
        }
    }

    public String getSansSerifFontFamily() {
        synchronized (this) {
            String string2 = this.mSansSerifFontFamily;
            return string2;
        }
    }

    public boolean getSaveFormData() {
        return this.mSaveFormData;
    }

    public boolean getSavePassword() {
        return this.mSavePassword;
    }

    public String getSerifFontFamily() {
        synchronized (this) {
            String string2 = this.mSerifFontFamily;
            return string2;
        }
    }

    public String getStandardFontFamily() {
        synchronized (this) {
            String string2 = this.mStandardFontFamily;
            return string2;
        }
    }

    public TextSize getTextSize() {
        synchronized (this) {
            TextSize textSize = this.mTextSize;
            return textSize;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean getUseDoubleTree() {
        // MONITORENTER : this
        // MONITOREXIT : this
        return false;
    }

    public boolean getUseWebViewBackgroundForOverscrollBackground() {
        return this.mUseWebViewBackgroundOverscrollBackground;
    }

    public boolean getUseWideViewPort() {
        synchronized (this) {
            boolean bl = this.mUseWideViewport;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public int getUserAgent() {
        synchronized (this) {
            block5: {
                String string2 = this.mUserAgent;
                boolean bl = DESKTOP_USERAGENT.equals(string2);
                if (!bl) break block5;
                return 1;
            }
            String string3 = this.mUserAgent;
            if (IPHONE_USERAGENT.equals(string3)) {
                return 2;
            }
            boolean bl = this.mUseDefaultUserAgent;
            if (!bl) return -1;
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserAgentString() {
        synchronized (this) {
            String string2 = this.mUserAgent;
            if (DESKTOP_USERAGENT.equals(string2)) return this.mUserAgent;
            String string3 = this.mUserAgent;
            if (IPHONE_USERAGENT.equals(string3)) return this.mUserAgent;
            if (!this.mUseDefaultUserAgent) {
                return this.mUserAgent;
            }
            boolean bl = false;
            Object object = sLockForLocaleSettings;
            synchronized (object) {
                Locale locale = Locale.getDefault();
                if (!sLocale.equals(locale)) {
                    String string4;
                    String string5;
                    sLocale = locale;
                    this.mUserAgent = string5 = this.getCurrentUserAgent();
                    this.mAcceptLanguage = string4 = this.getCurrentAcceptLanguage();
                    bl = true;
                }
            }
            if (!bl) return this.mUserAgent;
            this.postSync();
            return this.mUserAgent;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void onDestroyed() {
        // MONITORENTER : this
        // MONITOREXIT : this
    }

    public void setAllowFileAccess(boolean bl) {
        this.mAllowFileAccess = bl;
    }

    public void setAppCacheEnabled(boolean bl) {
        synchronized (this) {
            if (this.mAppCacheEnabled != bl) {
                this.mAppCacheEnabled = bl;
                this.postSync();
            }
            return;
        }
    }

    public void setAppCacheMaxSize(long l) {
        synchronized (this) {
            long l2 = this.mAppCacheMaxSize;
            if (l != l2) {
                this.mAppCacheMaxSize = l;
                this.postSync();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAppCachePath(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mAppCachePath)) {
                this.mAppCachePath = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setBlockNetworkImage(boolean bl) {
        synchronized (this) {
            if (this.mBlockNetworkImage != bl) {
                this.mBlockNetworkImage = bl;
                this.postSync();
            }
            return;
        }
    }

    public void setBlockNetworkLoads(boolean bl) {
        synchronized (this) {
            if (this.mBlockNetworkLoads != bl) {
                this.mBlockNetworkLoads = bl;
                this.verifyNetworkAccess();
            }
            return;
        }
    }

    public void setBuiltInZoomControls(boolean bl) {
        this.mBuiltInZoomControls = bl;
        WebView webView = this.mWebView;
        Context context = this.mContext;
        webView.updateMultiTouchSupport(context);
    }

    public void setCacheMode(int n) {
        int n2 = this.mOverrideCacheMode;
        if (n != n2) {
            return;
        }
        this.mOverrideCacheMode = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCursiveFontFamily(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mCursiveFontFamily)) {
                this.mCursiveFontFamily = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setDatabaseEnabled(boolean bl) {
        synchronized (this) {
            if (this.mDatabaseEnabled != bl) {
                this.mDatabaseEnabled = bl;
                this.postSync();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDatabasePath(String string2) {
        synchronized (this) {
            if (string2 != null && !this.mDatabasePathHasBeenSet) {
                this.mDatabasePath = string2;
                this.mDatabasePathHasBeenSet = true;
                this.postSync();
            }
            return;
        }
    }

    public void setDefaultFixedFontSize(int n) {
        synchronized (this) {
            n = this.pin(n);
            if (this.mDefaultFixedFontSize != n) {
                this.mDefaultFixedFontSize = n;
                this.postSync();
            }
            return;
        }
    }

    public void setDefaultFontSize(int n) {
        synchronized (this) {
            n = this.pin(n);
            if (this.mDefaultFontSize != n) {
                this.mDefaultFontSize = n;
                this.postSync();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDefaultTextEncodingName(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mDefaultTextEncoding)) {
                this.mDefaultTextEncoding = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setDefaultZoom(ZoomDensity zoomDensity) {
        if (this.mDefaultZoom == zoomDensity) {
            return;
        }
        this.mDefaultZoom = zoomDensity;
        WebView webView = this.mWebView;
        int n = zoomDensity.value;
        webView.updateDefaultZoomDensity(n);
    }

    public void setDomStorageEnabled(boolean bl) {
        synchronized (this) {
            if (this.mDomStorageEnabled != bl) {
                this.mDomStorageEnabled = bl;
                this.postSync();
            }
            return;
        }
    }

    void setDoubleTapToastCount(int n) {
        if (mDoubleTapToastCount != n) {
            return;
        }
        mDoubleTapToastCount = n;
        EventHandler eventHandler = this.mEventHandler;
        Message message = Message.obtain(null, 2);
        boolean bl = eventHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFantasyFontFamily(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mFantasyFontFamily)) {
                this.mFantasyFontFamily = string2;
                this.postSync();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFixedFontFamily(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mFixedFontFamily)) {
                this.mFixedFontFamily = string2;
                this.postSync();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setGeolocationDatabasePath(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mGeolocationDatabasePath)) {
                this.mGeolocationDatabasePath = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setGeolocationEnabled(boolean bl) {
        synchronized (this) {
            if (this.mGeolocationEnabled != bl) {
                this.mGeolocationEnabled = bl;
                this.postSync();
            }
            return;
        }
    }

    public void setJavaScriptCanOpenWindowsAutomatically(boolean bl) {
        synchronized (this) {
            if (this.mJavaScriptCanOpenWindowsAutomatically != bl) {
                this.mJavaScriptCanOpenWindowsAutomatically = bl;
                this.postSync();
            }
            return;
        }
    }

    public void setJavaScriptEnabled(boolean bl) {
        synchronized (this) {
            if (this.mJavaScriptEnabled != bl) {
                this.mJavaScriptEnabled = bl;
                this.postSync();
            }
            return;
        }
    }

    public void setLayoutAlgorithm(LayoutAlgorithm layoutAlgorithm) {
        synchronized (this) {
            if (this.mLayoutAlgorithm != layoutAlgorithm) {
                this.mLayoutAlgorithm = layoutAlgorithm;
                this.postSync();
            }
            return;
        }
    }

    public void setLightTouchEnabled(boolean bl) {
        this.mLightTouchEnabled = bl;
    }

    public void setLoadWithOverviewMode(boolean bl) {
        this.mLoadWithOverviewMode = bl;
    }

    public void setLoadsImagesAutomatically(boolean bl) {
        synchronized (this) {
            if (this.mLoadsImagesAutomatically != bl) {
                this.mLoadsImagesAutomatically = bl;
                this.postSync();
            }
            return;
        }
    }

    public void setMinimumFontSize(int n) {
        synchronized (this) {
            n = this.pin(n);
            if (this.mMinimumFontSize != n) {
                this.mMinimumFontSize = n;
                this.postSync();
            }
            return;
        }
    }

    public void setMinimumLogicalFontSize(int n) {
        synchronized (this) {
            n = this.pin(n);
            if (this.mMinimumLogicalFontSize != n) {
                this.mMinimumLogicalFontSize = n;
                this.postSync();
            }
            return;
        }
    }

    public void setNavDump(boolean bl) {
        this.mNavDump = bl;
    }

    public void setNeedInitialFocus(boolean bl) {
        if (this.mNeedInitialFocus != bl) {
            return;
        }
        this.mNeedInitialFocus = bl;
    }

    public void setPageCacheCapacity(int n) {
        synchronized (this) {
            if (n < 0) {
                n = 0;
            }
            if (n > 20) {
                n = 20;
            }
            if (this.mPageCacheCapacity != n) {
                this.mPageCacheCapacity = n;
                this.postSync();
            }
            return;
        }
    }

    public void setPluginState(PluginState pluginState) {
        synchronized (this) {
            if (this.mPluginState != pluginState) {
                this.mPluginState = pluginState;
                this.postSync();
            }
            return;
        }
    }

    @Deprecated
    public void setPluginsEnabled(boolean bl) {
        synchronized (this) {
            PluginState pluginState = PluginState.ON;
            this.setPluginState(pluginState);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public void setPluginsPath(String string2) {
        // MONITORENTER : this
        // MONITOREXIT : this
    }

    public void setRenderPriority(RenderPriority renderPriority) {
        synchronized (this) {
            if (this.mRenderPriority != renderPriority) {
                this.mRenderPriority = renderPriority;
                EventHandler eventHandler = this.mEventHandler;
                Message message = Message.obtain(null, 1);
                boolean bl = eventHandler.sendMessage(message);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSansSerifFontFamily(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mSansSerifFontFamily)) {
                this.mSansSerifFontFamily = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setSaveFormData(boolean bl) {
        this.mSaveFormData = bl;
    }

    public void setSavePassword(boolean bl) {
        this.mSavePassword = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSerifFontFamily(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mSerifFontFamily)) {
                this.mSerifFontFamily = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setShrinksStandaloneImagesToFit(boolean bl) {
        if (this.mShrinksStandaloneImagesToFit != bl) {
            return;
        }
        this.mShrinksStandaloneImagesToFit = bl;
        this.postSync();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStandardFontFamily(String string2) {
        synchronized (this) {
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mStandardFontFamily)) {
                this.mStandardFontFamily = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setSupportMultipleWindows(boolean bl) {
        synchronized (this) {
            if (this.mSupportMultipleWindows != bl) {
                this.mSupportMultipleWindows = bl;
                this.postSync();
            }
            return;
        }
    }

    public void setSupportZoom(boolean bl) {
        this.mSupportZoom = bl;
        WebView webView = this.mWebView;
        Context context = this.mContext;
        webView.updateMultiTouchSupport(context);
    }

    public void setTextSize(TextSize textSize) {
        synchronized (this) {
            if (WebView.mLogEvent && this.mTextSize != textSize) {
                Object[] objectArray = new Object[2];
                Integer n = this.mTextSize.value;
                objectArray[0] = n;
                Integer n2 = textSize.value;
                objectArray[1] = n2;
                int n3 = EventLog.writeEvent(70151, objectArray);
            }
            this.mTextSize = textSize;
            this.postSync();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public void setUseDoubleTree(boolean bl) {
        // MONITORENTER : this
        // MONITOREXIT : this
    }

    public void setUseWebViewBackgroundForOverscrollBackground(boolean bl) {
        this.mUseWebViewBackgroundOverscrollBackground = bl;
    }

    public void setUseWideViewPort(boolean bl) {
        synchronized (this) {
            if (this.mUseWideViewport != bl) {
                this.mUseWideViewport = bl;
                this.postSync();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void setUserAgent(int n) {
        synchronized (this) {
            block7: {
                String string2;
                block8: {
                    block9: {
                        block6: {
                            string2 = null;
                            if (n != 1) break block6;
                            String string3 = this.mUserAgent;
                            boolean bl = DESKTOP_USERAGENT.equals(string3);
                            if (bl) break block7;
                            string2 = DESKTOP_USERAGENT;
                            break block8;
                        }
                        if (n != 2) break block9;
                        String string4 = this.mUserAgent;
                        if (IPHONE_USERAGENT.equals(string4)) break block7;
                        string2 = IPHONE_USERAGENT;
                        break block8;
                    }
                    if (n != 0) break block7;
                }
                this.setUserAgentString(string2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUserAgentString(String string2) {
        synchronized (this) {
            String string3;
            if (string2 == null || string2.length() == 0) {
                Object object = sLockForLocaleSettings;
                synchronized (object) {
                    Locale locale = Locale.getDefault();
                    if (!sLocale.equals(locale)) {
                        String string4;
                        sLocale = locale;
                        this.mAcceptLanguage = string4 = this.getCurrentAcceptLanguage();
                    }
                }
                string2 = this.getCurrentUserAgent();
                this.mUseDefaultUserAgent = true;
            } else {
                Object var2_3 = null;
                this.mUseDefaultUserAgent = var2_3;
            }
            if (!string2.equals(string3 = this.mUserAgent)) {
                this.mUserAgent = string2;
                this.postSync();
            }
            return;
        }
    }

    public void setWorkersEnabled(boolean bl) {
        synchronized (this) {
            if (this.mWorkersEnabled != bl) {
                this.mWorkersEnabled = bl;
                this.postSync();
            }
            return;
        }
    }

    public boolean supportMultipleWindows() {
        synchronized (this) {
            boolean bl = this.mSupportMultipleWindows;
            return bl;
        }
    }

    public boolean supportZoom() {
        return this.mSupportZoom;
    }

    void syncSettingsAndCreateHandler(BrowserFrame browserFrame) {
        synchronized (this) {
            this.mBrowserFrame = browserFrame;
            SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREF_FILE, 0);
            if (mDoubleTapToastCount > 0) {
                int n = mDoubleTapToastCount;
                mDoubleTapToastCount = sharedPreferences.getInt(DOUBLE_TAP_TOAST_COUNT, n);
            }
            int n = browserFrame.mNativeFrame;
            this.nativeSync(n);
            this.mSyncPending = false;
            this.mEventHandler.createHandler();
            return;
        }
    }

    private class EventHandler {
        static final int PRIORITY = 1;
        static final int SET_DOUBLE_TAP_TOAST_COUNT = 2;
        static final int SYNC;
        private Handler mHandler;

        private EventHandler() {
        }

        private void createHandler() {
            synchronized (this) {
                Handler handler;
                this.setRenderPriority();
                this.mHandler = handler = new Handler(){

                    @Override
                    public void handleMessage(Message message) {
                        switch (message.what) {
                            default: {
                                return;
                            }
                            case 0: {
                                WebSettings webSettings = WebSettings.this;
                                synchronized (webSettings) {
                                    if (((WebSettings)WebSettings.this).mBrowserFrame.mNativeFrame != 0) {
                                        WebSettings webSettings2 = WebSettings.this;
                                        int n = ((WebSettings)WebSettings.this).mBrowserFrame.mNativeFrame;
                                        webSettings2.nativeSync(n);
                                    }
                                    boolean bl = WebSettings.access$202(WebSettings.this, false);
                                    return;
                                }
                            }
                            case 1: {
                                EventHandler.this.setRenderPriority();
                                return;
                            }
                            case 2: 
                        }
                        SharedPreferences.Editor editor = WebSettings.this.mContext.getSharedPreferences(WebSettings.PREF_FILE, 0).edit();
                        int n = mDoubleTapToastCount;
                        SharedPreferences.Editor editor2 = editor.putInt(WebSettings.DOUBLE_TAP_TOAST_COUNT, n);
                        boolean bl = editor.commit();
                    }
                };
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean sendMessage(Message message) {
            synchronized (this) {
                if (this.mHandler == null) return false;
                boolean bl = this.mHandler.sendMessage(message);
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setRenderPriority() {
            WebSettings webSettings = WebSettings.this;
            synchronized (webSettings) {
                RenderPriority renderPriority = WebSettings.this.mRenderPriority;
                RenderPriority renderPriority2 = RenderPriority.NORMAL;
                if (renderPriority == renderPriority2) {
                    Process.setThreadPriority(0);
                } else {
                    RenderPriority renderPriority3;
                    RenderPriority renderPriority4 = WebSettings.this.mRenderPriority;
                    if (renderPriority4 == (renderPriority3 = RenderPriority.HIGH)) {
                        Process.setThreadPriority(-1);
                    } else {
                        RenderPriority renderPriority5;
                        RenderPriority renderPriority6 = WebSettings.this.mRenderPriority;
                        if (renderPriority6 == (renderPriority5 = RenderPriority.LOW)) {
                            Process.setThreadPriority(10);
                        }
                    }
                }
                return;
            }
        }
    }

    public static final class PluginState
    extends Enum<PluginState> {
        private static final /* synthetic */ PluginState[] $VALUES;
        public static final /* enum */ PluginState OFF;
        public static final /* enum */ PluginState ON;
        public static final /* enum */ PluginState ON_DEMAND;

        static {
            ON = new PluginState();
            ON_DEMAND = new PluginState();
            OFF = new PluginState();
            PluginState pluginState = ON;
            PluginState pluginState2 = ON_DEMAND;
            PluginState pluginState3 = OFF;
            PluginState[] pluginStateArray = new PluginState[]{pluginState, pluginState2, pluginState3};
            $VALUES = pluginStateArray;
        }

        public static PluginState valueOf(String string2) {
            return Enum.valueOf(PluginState.class, string2);
        }

        public static PluginState[] values() {
            return (PluginState[])$VALUES.clone();
        }
    }

    public static final class RenderPriority
    extends Enum<RenderPriority> {
        private static final /* synthetic */ RenderPriority[] $VALUES;
        public static final /* enum */ RenderPriority HIGH;
        public static final /* enum */ RenderPriority LOW;
        public static final /* enum */ RenderPriority NORMAL;

        static {
            NORMAL = new RenderPriority();
            HIGH = new RenderPriority();
            LOW = new RenderPriority();
            RenderPriority renderPriority = NORMAL;
            RenderPriority renderPriority2 = HIGH;
            RenderPriority renderPriority3 = LOW;
            RenderPriority[] renderPriorityArray = new RenderPriority[]{renderPriority, renderPriority2, renderPriority3};
            $VALUES = renderPriorityArray;
        }

        public static RenderPriority valueOf(String string2) {
            return Enum.valueOf(RenderPriority.class, string2);
        }

        public static RenderPriority[] values() {
            return (RenderPriority[])$VALUES.clone();
        }
    }

    public static final class ZoomDensity
    extends Enum<ZoomDensity> {
        private static final /* synthetic */ ZoomDensity[] $VALUES;
        public static final /* enum */ ZoomDensity CLOSE;
        public static final /* enum */ ZoomDensity FAR;
        public static final /* enum */ ZoomDensity MEDIUM;
        int value;

        static {
            FAR = new ZoomDensity(150);
            MEDIUM = new ZoomDensity(100);
            CLOSE = new ZoomDensity(75);
            ZoomDensity zoomDensity = FAR;
            ZoomDensity zoomDensity2 = MEDIUM;
            ZoomDensity zoomDensity3 = CLOSE;
            ZoomDensity[] zoomDensityArray = new ZoomDensity[]{zoomDensity, zoomDensity2, zoomDensity3};
            $VALUES = zoomDensityArray;
        }

        private ZoomDensity(int n2) {
            this.value = n2;
        }

        public static ZoomDensity valueOf(String string2) {
            return Enum.valueOf(ZoomDensity.class, string2);
        }

        public static ZoomDensity[] values() {
            return (ZoomDensity[])$VALUES.clone();
        }
    }

    public static final class TextSize
    extends Enum<TextSize> {
        private static final /* synthetic */ TextSize[] $VALUES;
        public static final /* enum */ TextSize LARGER;
        public static final /* enum */ TextSize LARGEST;
        public static final /* enum */ TextSize NORMAL;
        public static final /* enum */ TextSize SMALLER;
        public static final /* enum */ TextSize SMALLEST;
        int value;

        static {
            SMALLEST = new TextSize(50);
            SMALLER = new TextSize(75);
            NORMAL = new TextSize(100);
            LARGER = new TextSize(150);
            LARGEST = new TextSize(200);
            TextSize textSize = SMALLEST;
            TextSize textSize2 = SMALLER;
            TextSize textSize3 = NORMAL;
            TextSize textSize4 = LARGER;
            TextSize textSize5 = LARGEST;
            TextSize[] textSizeArray = new TextSize[]{textSize, textSize2, textSize3, textSize4, textSize5};
            $VALUES = textSizeArray;
        }

        private TextSize(int n2) {
            this.value = n2;
        }

        public static TextSize valueOf(String string2) {
            return Enum.valueOf(TextSize.class, string2);
        }

        public static TextSize[] values() {
            return (TextSize[])$VALUES.clone();
        }
    }

    public static final class LayoutAlgorithm
    extends Enum<LayoutAlgorithm> {
        private static final /* synthetic */ LayoutAlgorithm[] $VALUES;
        public static final /* enum */ LayoutAlgorithm NARROW_COLUMNS;
        public static final /* enum */ LayoutAlgorithm NORMAL;
        public static final /* enum */ LayoutAlgorithm SINGLE_COLUMN;

        static {
            NORMAL = new LayoutAlgorithm();
            SINGLE_COLUMN = new LayoutAlgorithm();
            NARROW_COLUMNS = new LayoutAlgorithm();
            LayoutAlgorithm layoutAlgorithm = NORMAL;
            LayoutAlgorithm layoutAlgorithm2 = SINGLE_COLUMN;
            LayoutAlgorithm layoutAlgorithm3 = NARROW_COLUMNS;
            LayoutAlgorithm[] layoutAlgorithmArray = new LayoutAlgorithm[]{layoutAlgorithm, layoutAlgorithm2, layoutAlgorithm3};
            $VALUES = layoutAlgorithmArray;
        }

        public static LayoutAlgorithm valueOf(String string2) {
            return Enum.valueOf(LayoutAlgorithm.class, string2);
        }

        public static LayoutAlgorithm[] values() {
            return (LayoutAlgorithm[])$VALUES.clone();
        }
    }
}

