/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.webkit.ValueCallback;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class WebStorage {
    private static final String CALLBACK = "callback";
    static final int DELETE_ALL = 3;
    static final int DELETE_ORIGIN = 2;
    static final int GET_ORIGINS = 4;
    static final int GET_QUOTA_ORIGIN = 6;
    static final int GET_USAGE_ORIGIN = 5;
    private static final String ORIGIN = "origin";
    private static final String ORIGINS = "origins";
    private static final String QUOTA = "quota";
    static final int RETURN_ORIGINS = 0;
    static final int RETURN_QUOTA_ORIGIN = 2;
    static final int RETURN_USAGE_ORIGIN = 1;
    static final int SET_QUOTA_ORIGIN = 1;
    private static final String TAG = "webstorage";
    static final int UPDATE = 0;
    private static final String USAGE = "usage";
    private static WebStorage sWebStorage;
    private Handler mHandler = null;
    private Map<String, Origin> mOrigins;
    private Handler mUIHandler = null;

    public static WebStorage getInstance() {
        if (sWebStorage == null) {
            sWebStorage = new WebStorage();
        }
        return sWebStorage;
    }

    private static native void nativeDeleteAllData();

    private static native void nativeDeleteOrigin(String var0);

    private static native Set nativeGetOrigins();

    private static native long nativeGetQuotaForOrigin(String var0);

    private static native long nativeGetUsageForOrigin(String var0);

    private static native void nativeSetAppCacheMaximumSize(long var0);

    private static native void nativeSetQuotaForOrigin(String var0, long var1);

    private void postMessage(Message message) {
        synchronized (this) {
            if (this.mHandler != null) {
                boolean bl = this.mHandler.sendMessage(message);
            }
            return;
        }
    }

    private void postUIMessage(Message message) {
        if (this.mUIHandler == null) {
            return;
        }
        boolean bl = this.mUIHandler.sendMessage(message);
    }

    private void syncValues() {
        Set set = WebStorage.nativeGetOrigins();
        HashMap<String, Origin> hashMap = new HashMap<String, Origin>();
        this.mOrigins = hashMap;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            long l = WebStorage.nativeGetQuotaForOrigin(string2);
            long l2 = WebStorage.nativeGetUsageForOrigin(string2);
            Origin origin = new Origin(string2, l, l2);
            Origin origin2 = this.mOrigins.put(string2, origin);
        }
        return;
    }

    public void createHandler() {
        synchronized (this) {
            if (this.mHandler == null) {
                Handler handler;
                this.mHandler = handler = new Handler(){

                    @Override
                    public void handleMessage(Message message) {
                        switch (message.what) {
                            default: {
                                return;
                            }
                            case 1: {
                                Origin origin = (Origin)message.obj;
                                String string2 = origin.getOrigin();
                                long l = origin.getQuota();
                                WebStorage.nativeSetQuotaForOrigin(string2, l);
                                return;
                            }
                            case 2: {
                                WebStorage.nativeDeleteOrigin(((Origin)message.obj).getOrigin());
                                return;
                            }
                            case 3: {
                                WebStorage.nativeDeleteAllData();
                                return;
                            }
                            case 4: {
                                WebStorage.this.syncValues();
                                ValueCallback valueCallback = (ValueCallback)message.obj;
                                Map map = WebStorage.this.mOrigins;
                                HashMap hashMap = new HashMap(map);
                                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                                ValueCallback valueCallback2 = hashMap2.put(WebStorage.CALLBACK, valueCallback);
                                HashMap hashMap3 = hashMap2.put(WebStorage.ORIGINS, hashMap);
                                WebStorage webStorage = WebStorage.this;
                                Message message2 = Message.obtain(null, 0, hashMap2);
                                webStorage.postUIMessage(message2);
                                return;
                            }
                            case 5: {
                                WebStorage.this.syncValues();
                                Map map = (Map)message.obj;
                                String string3 = (String)map.get(WebStorage.ORIGIN);
                                ValueCallback valueCallback = (ValueCallback)map.get(WebStorage.CALLBACK);
                                Origin origin = (Origin)WebStorage.this.mOrigins.get(string3);
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                ValueCallback valueCallback3 = hashMap.put(WebStorage.CALLBACK, valueCallback);
                                if (origin != null) {
                                    long l = origin.getUsage();
                                    Long l2 = new Long(l);
                                    Long l3 = hashMap.put(WebStorage.USAGE, l2);
                                }
                                WebStorage webStorage = WebStorage.this;
                                Message message3 = Message.obtain(null, 1, hashMap);
                                webStorage.postUIMessage(message3);
                                return;
                            }
                            case 6: {
                                WebStorage.this.syncValues();
                                Map map = (Map)message.obj;
                                String string4 = (String)map.get(WebStorage.ORIGIN);
                                ValueCallback valueCallback = (ValueCallback)map.get(WebStorage.CALLBACK);
                                Origin origin = (Origin)WebStorage.this.mOrigins.get(string4);
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                ValueCallback valueCallback4 = hashMap.put(WebStorage.CALLBACK, valueCallback);
                                if (origin != null) {
                                    long l = origin.getQuota();
                                    Long l4 = new Long(l);
                                    Long l5 = hashMap.put(WebStorage.QUOTA, l4);
                                }
                                WebStorage webStorage = WebStorage.this;
                                Message message4 = Message.obtain(null, 2, hashMap);
                                webStorage.postUIMessage(message4);
                                return;
                            }
                            case 0: 
                        }
                        WebStorage.this.syncValues();
                    }
                };
            }
            return;
        }
    }

    public void createUIHandler() {
        Handler handler;
        if (this.mUIHandler != null) {
            return;
        }
        this.mUIHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 0: {
                        Map map = (Map)message.obj;
                        Map map2 = (Map)map.get(WebStorage.ORIGINS);
                        ((ValueCallback)map.get(WebStorage.CALLBACK)).onReceiveValue(map2);
                        return;
                    }
                    case 1: {
                        Map map = (Map)message.obj;
                        ValueCallback valueCallback = (ValueCallback)map.get(WebStorage.CALLBACK);
                        Long l = (Long)map.get(WebStorage.USAGE);
                        valueCallback.onReceiveValue(l);
                        return;
                    }
                    case 2: 
                }
                Map map = (Map)message.obj;
                ValueCallback valueCallback = (ValueCallback)map.get(WebStorage.CALLBACK);
                Long l = (Long)map.get(WebStorage.QUOTA);
                valueCallback.onReceiveValue(l);
            }
        };
    }

    public void deleteAllData() {
        String string2 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string2)) {
            WebStorage.nativeDeleteAllData();
            return;
        }
        Message message = Message.obtain(null, 3);
        this.postMessage(message);
    }

    public void deleteOrigin(String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string3)) {
            WebStorage.nativeDeleteOrigin(string2);
            return;
        }
        Origin origin = new Origin(string2);
        Message message = Message.obtain(null, 2, origin);
        this.postMessage(message);
    }

    public void getOrigins(ValueCallback<Map> valueCallback) {
        if (valueCallback == null) {
            return;
        }
        String string2 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string2)) {
            this.syncValues();
            Map<String, Origin> map = this.mOrigins;
            valueCallback.onReceiveValue(map);
            return;
        }
        Message message = Message.obtain(null, 4, valueCallback);
        this.postMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Collection<Origin> getOriginsSync() {
        String string2 = Thread.currentThread().getName();
        if (!"WebViewCoreThread".equals(string2)) return null;
        this.update();
        return this.mOrigins.values();
    }

    public void getQuotaForOrigin(String string2, ValueCallback<Long> valueCallback) {
        if (valueCallback == null) {
            return;
        }
        if (string2 == null) {
            valueCallback.onReceiveValue(null);
            return;
        }
        String string3 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string3)) {
            this.syncValues();
            long l = this.mOrigins.get(string2).getUsage();
            Long l2 = new Long(l);
            valueCallback.onReceiveValue(l2);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string4 = hashMap.put(ORIGIN, string2);
        ValueCallback<Long> valueCallback2 = hashMap.put(CALLBACK, valueCallback);
        Message message = Message.obtain(null, 6, hashMap);
        this.postMessage(message);
    }

    public void getUsageForOrigin(String string2, ValueCallback<Long> valueCallback) {
        if (valueCallback == null) {
            return;
        }
        if (string2 == null) {
            valueCallback.onReceiveValue(null);
            return;
        }
        String string3 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string3)) {
            this.syncValues();
            long l = this.mOrigins.get(string2).getUsage();
            Long l2 = new Long(l);
            valueCallback.onReceiveValue(l2);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string4 = hashMap.put(ORIGIN, string2);
        ValueCallback<Long> valueCallback2 = hashMap.put(CALLBACK, valueCallback);
        Message message = Message.obtain(null, 5, hashMap);
        this.postMessage(message);
    }

    public void setAppCacheMaximumSize(long l) {
        WebStorage.nativeSetAppCacheMaximumSize(l);
    }

    public void setQuotaForOrigin(String string2, long l) {
        if (string2 == null) {
            return;
        }
        String string3 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string3)) {
            WebStorage.nativeSetQuotaForOrigin(string2, l);
            return;
        }
        Origin origin = new Origin(string2, l);
        Message message = Message.obtain(null, 1, origin);
        this.postMessage(message);
    }

    public void update() {
        String string2 = Thread.currentThread().getName();
        if ("WebViewCoreThread".equals(string2)) {
            this.syncValues();
            return;
        }
        Message message = Message.obtain(null, 0);
        this.postMessage(message);
    }

    static class Origin {
        String mOrigin = null;
        long mQuota = 0L;
        long mUsage = 0L;

        public Origin(String string2) {
            this.mOrigin = string2;
        }

        public Origin(String string2, long l) {
            this.mOrigin = string2;
            this.mQuota = l;
        }

        public Origin(String string2, long l, long l2) {
            this.mOrigin = string2;
            this.mQuota = l;
            this.mUsage = l2;
        }

        public String getOrigin() {
            return this.mOrigin;
        }

        public long getQuota() {
            return this.mQuota;
        }

        public long getUsage() {
            return this.mUsage;
        }
    }

    public static interface QuotaUpdater {
        public void updateQuota(long var1);
    }
}

