/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.webkit.WebViewDatabase;

abstract class WebSyncManager
implements Runnable {
    protected static final String LOGTAG = "websync";
    private static int SYNC_LATER_INTERVAL = 0;
    private static final int SYNC_MESSAGE = 101;
    private static int SYNC_NOW_INTERVAL = 100;
    protected WebViewDatabase mDataBase;
    protected Handler mHandler;
    private int mStartSyncRefCount;
    private Thread mSyncThread;
    private String mThreadName;

    static {
        SYNC_LATER_INTERVAL = 300000;
    }

    protected WebSyncManager(Context context, String string2) {
        this.mThreadName = string2;
        if (context != null) {
            Thread thread;
            WebViewDatabase webViewDatabase;
            this.mDataBase = webViewDatabase = WebViewDatabase.getInstance(context);
            Thread thread2 = this.mSyncThread = (thread = new Thread(this));
            String string3 = this.mThreadName;
            thread2.setName(string3);
            this.mSyncThread.start();
            return;
        }
        throw new IllegalStateException("WebSyncManager can't be created without context");
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("doesn't implement Cloneable");
    }

    protected void onSyncInit() {
    }

    public void resetSync() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(101);
        Message message = this.mHandler.obtainMessage(101);
        Handler handler = this.mHandler;
        long l = SYNC_LATER_INTERVAL;
        boolean bl = handler.sendMessageDelayed(message, l);
    }

    @Override
    public void run() {
        Looper.prepare();
        SyncHandler syncHandler = new SyncHandler();
        this.mHandler = syncHandler;
        this.onSyncInit();
        Process.setThreadPriority(10);
        Message message = this.mHandler.obtainMessage(101);
        Handler handler = this.mHandler;
        long l = SYNC_LATER_INTERVAL;
        boolean bl = handler.sendMessageDelayed(message, l);
        Looper.loop();
    }

    public void startSync() {
        int n;
        if (this.mHandler == null) {
            return;
        }
        this.mStartSyncRefCount = n = this.mStartSyncRefCount + 1;
        if (n != 1) {
            return;
        }
        Message message = this.mHandler.obtainMessage(101);
        Handler handler = this.mHandler;
        long l = SYNC_LATER_INTERVAL;
        boolean bl = handler.sendMessageDelayed(message, l);
    }

    public void stopSync() {
        int n;
        if (this.mHandler == null) {
            return;
        }
        this.mStartSyncRefCount = n = this.mStartSyncRefCount - 1;
        if (n != 0) {
            return;
        }
        this.mHandler.removeMessages(101);
    }

    public void sync() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(101);
        Message message = this.mHandler.obtainMessage(101);
        Handler handler = this.mHandler;
        long l = SYNC_NOW_INTERVAL;
        boolean bl = handler.sendMessageDelayed(message, l);
    }

    abstract void syncFromRamToFlash();

    private class SyncHandler
    extends Handler {
        private SyncHandler() {
        }

        @Override
        public void handleMessage(Message message) {
            if (message.what != 101) {
                return;
            }
            WebSyncManager.this.syncFromRamToFlash();
            Message message2 = this.obtainMessage(101);
            long l = SYNC_LATER_INTERVAL;
            boolean bl = this.sendMessageDelayed(message2, l);
        }
    }
}

