/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.Selection;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import com.android.internal.widget.EditableInputConnection;
import java.util.ArrayList;

class WebTextView
extends AutoCompleteTextView {
    static final String LOGTAG = "webtextview";
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private Drawable mBackground;
    private char[] mCharacter;
    private boolean mDragSent;
    private long mDragStartTime;
    private float mDragStartX;
    private float mDragStartY;
    private boolean mFromFocusChange;
    private boolean mFromSetInputType;
    private boolean mFromWebKit;
    private boolean mGotEnterDown;
    private boolean mGotTouchDown;
    private boolean mHasPerformedLongClick;
    private int mHeightSpec;
    private boolean mInSetTextAndKeepSelection;
    private int mMaxLength;
    private int mNodePointer;
    private String mPreChange;
    private boolean mScrolled;
    private boolean mSingle;
    private WebView mWebView;
    private int mWidthSpec;

    WebTextView(Context context, WebView webView) {
        super(context, null, 16843449);
        char[] cArray = new char[1];
        this.mCharacter = cArray;
        this.mWebView = webView;
        this.mMaxLength = -1;
    }

    private void createBackground() {
        if (this.mBackground != null) {
            return;
        }
        OutlineDrawable outlineDrawable = new OutlineDrawable();
        this.mBackground = outlineDrawable;
        this.setGravity(16);
        TextPaint textPaint = this.getPaint();
        int n = textPaint.getFlags() | 0x80 | 1;
        textPaint.setFlags(n);
        this.setTextColor(-16777216);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void lineUpScroll() {
        Layout layout2 = this.getLayout();
        if (this.mWebView == null) {
            return;
        }
        if (layout2 == null) {
            return;
        }
        int n = this.mScrollY;
        float f = Touch.getMaxScrollX(this, layout2, n);
        WebView webView = this.mWebView;
        float f2 = f > 0.0f ? (float)this.mScrollX / f : 0.0f;
        int n2 = this.mScrollY;
        webView.scrollFocusedTextInput(f2, n2);
    }

    private void sendDomEvent(KeyEvent keyEvent) {
        WebView webView = this.mWebView;
        String string2 = this.getText().toString();
        webView.passToJavaScript(string2, keyEvent);
    }

    private void setMaxLength(int n) {
        this.mMaxLength = n;
        if (-1 != n) {
            InputFilter[] inputFilterArray = NO_FILTERS;
            this.setFilters(inputFilterArray);
            return;
        }
        InputFilter[] inputFilterArray = new InputFilter[1];
        InputFilter.LengthFilter lengthFilter = new InputFilter.LengthFilter(n);
        inputFilterArray[0] = lengthFilter;
        this.setFilters(inputFilterArray);
    }

    void bringIntoView() {
        if (this.getLayout() == null) {
            return;
        }
        int n = Selection.getSelectionEnd(this.getText());
        boolean bl = this.bringPointIntoView(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int n;
        if (keyEvent.isSystem()) {
            return super.dispatchKeyEvent(keyEvent);
        }
        boolean bl = keyEvent.getAction() != 1;
        int n2 = keyEvent.getKeyCode();
        boolean bl2 = false;
        switch (n2) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (!this.mWebView.nativeCursorMatchesFocus()) {
                    if (bl) {
                        WebView webView = this.mWebView;
                        int n3 = n2;
                        KeyEvent keyEvent2 = keyEvent;
                        return webView.onKeyDown(n3, keyEvent2);
                    }
                    WebView webView = this.mWebView;
                    int n4 = n2;
                    KeyEvent keyEvent3 = keyEvent;
                    return webView.onKeyUp(n4, keyEvent3);
                }
                bl2 = true;
            }
        }
        if (61 != n2) {
            if (!bl) return true;
            WebTextView webTextView = this;
            int n5 = 5;
            webTextView.onEditorAction(n5);
            return true;
        }
        Editable editable = this.getText();
        int n6 = editable.length();
        if (67 != n2 && n6 == 0) {
            this.sendDomEvent(keyEvent);
            return true;
        }
        if (this.mSingle && 66 != n2) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(keyEvent);
            }
            if (bl) return super.dispatchKeyEvent(keyEvent);
            InputMethodManager inputMethodManager = InputMethodManager.getInstance(this.mContext);
            IBinder iBinder = this.getWindowToken();
            boolean bl3 = inputMethodManager.hideSoftInputFromWindow(iBinder, 0);
            KeyEvent keyEvent4 = new KeyEvent(0, n2);
            WebTextView webTextView = this;
            KeyEvent keyEvent5 = keyEvent4;
            webTextView.sendDomEvent(keyEvent5);
            this.sendDomEvent(keyEvent);
            return super.dispatchKeyEvent(keyEvent);
        }
        if (23 != n2) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(keyEvent);
            }
            if (!this.mWebView.nativeCursorMatchesFocus()) {
                if (bl) {
                    WebView webView = this.mWebView;
                    int n7 = n2;
                    KeyEvent keyEvent6 = keyEvent;
                    return webView.onKeyDown(n7, keyEvent6);
                }
                WebView webView = this.mWebView;
                int n8 = n2;
                KeyEvent keyEvent7 = keyEvent;
                return webView.onKeyUp(n8, keyEvent7);
            }
            if (bl) return super.dispatchKeyEvent(keyEvent);
            this.mWebView.centerKeyPressOnTextField();
            return super.dispatchKeyEvent(keyEvent);
        }
        if (this.getLayout() == null) {
            int n9 = this.mWidthSpec;
            int n10 = this.mHeightSpec;
            WebTextView webTextView = this;
            int n11 = n9;
            int n12 = n10;
            webTextView.measure(n11, n12);
        }
        int n13 = Selection.getSelectionStart(editable);
        int n14 = Selection.getSelectionEnd(editable);
        boolean bl4 = this.mMaxLength != -1 && n6 != (n = this.mMaxLength);
        String string2 = bl4 && n14 != n13 ? editable.toString() : "";
        if (super.dispatchKeyEvent(keyEvent)) {
            if (66 != n2) {
                boolean bl5;
                this.mGotEnterDown = bl5 = true;
            }
            if (!bl4) return true;
            if (bl2) return true;
            if (n2 == 67) return true;
            if (n14 != n13) {
                return true;
            }
            String string3 = this.getText().toString();
            if (string2.equals(string3)) return true;
            Editable editable2 = this.getText();
            int n15 = Selection.getSelectionStart(editable2);
            int n16 = Selection.getSelectionEnd(editable2);
            WebView webView = this.mWebView;
            String string4 = editable2.toString();
            webView.replaceTextfieldText(0, n6, string4, n15, n16);
            return true;
        }
        if (this.mGotEnterDown && !bl) {
            return true;
        }
        if (!bl2) {
            return false;
        }
        this.mWebView.resetTrackballTime();
        if (bl) {
            WebView webView = this.mWebView;
            int n17 = n2;
            KeyEvent keyEvent8 = keyEvent;
            return webView.onKeyDown(n17, keyEvent8);
        }
        WebView webView = this.mWebView;
        int n18 = n2;
        KeyEvent keyEvent9 = keyEvent;
        return webView.onKeyUp(n18, keyEvent9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isSameTextField(int n) {
        int n2 = this.mNodePointer;
        if (n == n2) return false;
        return true;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection inputConnection = super.onCreateInputConnection(editorInfo);
        if (this.mWebView != null) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = this.mWebView.nativeFocusCandidateName();
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append("\\");
            String string4 = this.mWebView.getUrl();
            editorInfo.fieldName = string2 = stringBuilder2.append(string4).toString();
        }
        return inputConnection;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        int n;
        if (this.mWebView == null || !this.mWebView.nativeFocusCandidateIsPassword() || !this.isSameTextField(n = this.mWebView.nativeFocusCandidatePointer())) {
            this.setInPassword(false);
            return;
        }
        super.onDraw(canvas);
    }

    public void onDrawSubstitute() {
        this.updateCursorControllerPositions();
    }

    @Override
    public void onEditorAction(int n) {
        switch (n) {
            default: {
                return;
            }
            case 5: {
                if (!this.mWebView.nativeMoveCursorToNextTextInput()) {
                    return;
                }
                this.mWebView.setFocusControllerInactive();
                this.mWebView.rebuildWebTextView();
                this.setDefaultSelection();
                this.mWebView.invalidate();
                return;
            }
            case 6: {
                super.onEditorAction(n);
                return;
            }
            case 2: 
            case 3: 
        }
        InputMethodManager inputMethodManager = InputMethodManager.getInstance(this.mContext);
        IBinder iBinder = this.getWindowToken();
        boolean bl = inputMethodManager.hideSoftInputFromWindow(iBinder, 0);
        KeyEvent keyEvent = new KeyEvent(0, 66);
        this.sendDomEvent(keyEvent);
        KeyEvent keyEvent2 = new KeyEvent(1, 66);
        this.sendDomEvent(keyEvent2);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        this.mFromFocusChange = true;
        super.onFocusChanged(bl, n, rect);
        this.mFromFocusChange = false;
    }

    @Override
    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        super.onScrollChanged(n, n2, n3, n4);
        this.lineUpScroll();
    }

    @Override
    protected void onSelectionChanged(int n, int n2) {
        if (this.mInSetTextAndKeepSelection) {
            return;
        }
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null && inputMethodManager.isActive(this)) {
            Editable editable = this.getText();
            int n3 = EditableInputConnection.getComposingSpanStart(editable);
            int n4 = EditableInputConnection.getComposingSpanEnd(editable);
            WebTextView webTextView = this;
            int n5 = n;
            int n6 = n2;
            inputMethodManager.updateSelection(webTextView, n5, n6, n3, n4);
        }
        if (this.mFromWebKit) {
            return;
        }
        if (this.mFromFocusChange) {
            return;
        }
        if (this.mFromSetInputType) {
            return;
        }
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.setSelection(n, n2);
        this.lineUpScroll();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        String string2;
        String string3;
        int n4;
        String string4;
        String string5;
        int n5;
        int n6;
        super.onTextChanged(charSequence, n, n2, n3);
        String string6 = ((Object)charSequence).toString();
        if (this.mPreChange == null) {
            return;
        }
        String string7 = this.mPreChange;
        String string8 = string6;
        if (string7.equals(string8)) {
            return;
        }
        if (this.mMaxLength > -1 && (n6 = this.mPreChange.length()) > (n5 = this.mMaxLength) && (string5 = (string4 = this.mPreChange).substring(0, n4 = this.mMaxLength)).equals(string3 = string6)) {
            return;
        }
        this.mPreChange = string2 = string6;
        if (n3 == 0) {
            if (n2 <= 0) {
                return;
            }
            WebView webView = this.mWebView;
            int n7 = n + n2;
            WebView webView2 = webView;
            int n8 = n;
            int n9 = n7;
            webView2.deleteSelection(n8, n9);
            this.updateCachedTextfield();
            return;
        }
        int n10 = n + n3 - 1;
        int n11 = n + n3;
        char[] cArray = this.mCharacter;
        CharSequence charSequence2 = charSequence;
        int n12 = n10;
        int n13 = n11;
        char[] cArray2 = cArray;
        int n14 = 0;
        TextUtils.getChars(charSequence2, n12, n13, cArray2, n14);
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(0);
        char[] cArray3 = this.mCharacter;
        KeyEvent[] keyEventArray = keyCharacterMap.getEvents(cArray3);
        boolean bl = keyEventArray == null;
        int n15 = bl ? 0 : 1;
        int n16 = n3;
        int n17 = 1;
        if (n16 > n17 || bl) {
            int n18 = n + n3 - n15;
            CharSequence charSequence3 = charSequence;
            int n19 = n;
            int n20 = n18;
            String string9 = ((Object)charSequence3.subSequence(n19, n20)).toString();
            WebView webView = this.mWebView;
            int n21 = n + n2;
            int n22 = n + n3 - n15;
            int n23 = n + n3 - n15;
            int n24 = n;
            webView.replaceTextfieldText(n24, n21, string9, n22, n23);
        } else if (!this.mInSetTextAndKeepSelection) {
            WebView webView = this.mWebView;
            int n25 = n + n2;
            WebView webView3 = webView;
            int n26 = n;
            int n27 = n25;
            webView3.setSelection(n26, n27);
        }
        if (!bl) {
            int n28;
            int n29;
            int n30 = keyEventArray.length;
            int n31 = 0;
            while ((n29 = ++n31) < (n28 = n30)) {
                if (KeyEvent.isModifierKey(keyEventArray[n31].getKeyCode())) continue;
                KeyEvent keyEvent = keyEventArray[n31];
                WebTextView webTextView = this;
                KeyEvent keyEvent2 = keyEvent;
                webTextView.sendDomEvent(keyEvent2);
            }
        }
        this.updateCachedTextfield();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                long l;
                float f;
                float f2;
                boolean bl = super.onTouchEvent(motionEvent);
                this.mDragStartX = f2 = motionEvent.getX();
                this.mDragStartY = f = motionEvent.getY();
                this.mDragStartTime = l = motionEvent.getEventTime();
                this.mDragSent = false;
                this.mScrolled = false;
                this.mGotTouchDown = true;
                this.mHasPerformedLongClick = false;
            }
            default: {
                return true;
            }
            case 2: {
                float f;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                int n = ViewConfiguration.get(this.mContext).getScaledTouchSlop();
                Editable editable = this.getText();
                int n2 = Touch.getInitialScrollX(this, editable);
                int n3 = Touch.getInitialScrollY(this, editable);
                boolean bl = super.onTouchEvent(motionEvent);
                int n4 = Math.abs(this.mScrollX - n2);
                int n5 = Math.abs(this.mScrollY - n3);
                int n6 = n / 2;
                if (n4 > n6 || n5 > n6) {
                    this.mScrolled = true;
                    this.cancelLongPress();
                    return true;
                }
                float f8 = (int)motionEvent.getX();
                float f9 = Math.abs(f8 - (f7 = this.mDragStartX));
                if (f9 < (f6 = (float)n) && (f5 = Math.abs((f4 = (float)((int)motionEvent.getY())) - (f3 = this.mDragStartY))) < (f = (float)n)) {
                    return true;
                }
                if (this.mWebView == null) return false;
                if (!this.mDragSent) {
                    WebView webView = this.mWebView;
                    float f10 = this.mDragStartX;
                    float f11 = this.mDragStartY;
                    long l = this.mDragStartTime;
                    webView.initiateTextFieldDrag(f10, f11, l);
                    this.mDragSent = true;
                }
                if (!this.mWebView.textFieldDrag(motionEvent)) return false;
                this.mScrolled = true;
                this.cancelLongPress();
                return true;
            }
            case 1: 
            case 3: {
                boolean bl = super.onTouchEvent(motionEvent);
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                if (!this.mScrolled) {
                    this.cancelLongPress();
                    if (this.mGotTouchDown && this.mWebView != null) {
                        this.mWebView.touchUpOnTextField(motionEvent);
                    }
                }
                if (this.mWebView != null && this.mDragSent) {
                    boolean bl2 = this.mWebView.onTouchEvent(motionEvent);
                }
                this.mGotTouchDown = false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (this.isPopupShowing()) {
            return super.onTrackballEvent(motionEvent);
        }
        if (motionEvent.getAction() != 2) {
            return false;
        }
        if (!this.mWebView.nativeCursorMatchesFocus()) {
            return this.mWebView.onTrackballEvent(motionEvent);
        }
        Editable editable = this.getText();
        MovementMethod movementMethod = this.getMovementMethod();
        if (movementMethod == null) return false;
        if (this.getLayout() == null) return false;
        if (!movementMethod.onTrackballEvent(this, editable, motionEvent)) return false;
        return true;
    }

    @Override
    public boolean performLongClick() {
        this.mHasPerformedLongClick = true;
        return super.performLongClick();
    }

    void remove() {
        InputMethodManager inputMethodManager = InputMethodManager.getInstance(this.mContext);
        IBinder iBinder = this.getWindowToken();
        boolean bl = inputMethodManager.hideSoftInputFromWindow(iBinder, 0);
        this.mWebView.removeView(this);
        boolean bl2 = this.mWebView.requestFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requestRectangleOnScreen(Rect rect) {
        if (this.mWebView.inAnimateZoom()) return false;
        return super.requestRectangleOnScreen(rect);
    }

    public void setAdapterCustom(AutoCompleteAdapter autoCompleteAdapter) {
        if (autoCompleteAdapter != null) {
            int n = this.getInputType() | 0x10000;
            this.setInputType(n);
            autoCompleteAdapter.setTextView(this);
        }
        super.setAdapter(autoCompleteAdapter);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setDefaultSelection() {
        Editable editable = this.getText();
        int n = this.mSingle ? editable.length() : 0;
        if (Selection.getSelectionStart(editable) != n && Selection.getSelectionEnd(editable) != n) {
            if (this.mWebView == null) {
                return;
            }
            this.mWebView.setSelection(n, n);
            return;
        }
        Selection.setSelection(editable, n, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setInPassword(boolean bl) {
        if (bl) {
            this.setInputType(129);
            this.createBackground();
        }
        boolean bl2 = !bl;
        this.setWillNotDraw(bl2);
        Drawable drawable2 = bl ? this.mBackground : null;
        this.setBackgroundDrawable(drawable2);
    }

    @Override
    public void setInputType(int n) {
        this.mFromSetInputType = true;
        super.setInputType(n);
        this.mFromSetInputType = false;
    }

    void setNodePointer(int n) {
        this.mNodePointer = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setRect(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        AbsoluteLayout.LayoutParams layoutParams = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new AbsoluteLayout.LayoutParams(n3, n4, n, n2);
        } else {
            layoutParams.x = n;
            layoutParams.y = n2;
            layoutParams.width = n3;
            layoutParams.height = n4;
        }
        if (this.getParent() == null) {
            this.mWebView.addView((View)this, layoutParams);
        } else {
            this.setLayoutParams(layoutParams);
        }
        this.mWidthSpec = n6 = View.MeasureSpec.makeMeasureSpec(n3, 0x40000000);
        this.mHeightSpec = n5 = View.MeasureSpec.makeMeasureSpec(n4, 0x40000000);
    }

    void setSelectionFromWebKit(int n, int n2) {
        if (n < 0) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        Editable editable = this.getText();
        int n3 = editable.length();
        if (n > n3) {
            return;
        }
        if (n2 > n3) {
            return;
        }
        this.mFromWebKit = true;
        Selection.setSelection(editable, n, n2);
        this.mFromWebKit = false;
    }

    void setTextAndKeepSelection(String string2) {
        String string3;
        this.mPreChange = string3 = string2.toString();
        Editable editable = this.getText();
        int n = Selection.getSelectionStart(editable);
        int n2 = Selection.getSelectionEnd(editable);
        this.mInSetTextAndKeepSelection = true;
        int n3 = editable.length();
        Editable editable2 = editable.replace(0, n3, string2);
        int n4 = editable.length();
        if (n > n4) {
            n = n4;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        Selection.setSelection(editable, n, n2);
        this.mInSetTextAndKeepSelection = false;
        this.updateCachedTextfield();
    }

    /*
     * Enabled aggressive block sorting
     */
    void setType(int n) {
        int n2;
        if (this.mWebView == null) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = 1;
        if (this.mWebView.nativeFocusCandidateHasNextTextfield()) {
            n4 |= 0xA0;
        }
        int n5 = -1879048192;
        switch (n) {
            default: {
                n2 = n5 | 2;
                break;
            }
            case 0: {
                n2 = n5 | 2;
                break;
            }
            case 1: {
                bl = false;
                n4 = 180225;
                n2 = n5 | 1;
                break;
            }
            case 2: {
                bl2 = true;
                n2 = n5 | 2;
                break;
            }
            case 3: {
                n2 = n5 | 3;
                break;
            }
            case 4: {
                n2 = n5 | 2;
                break;
            }
            case 5: {
                n4 |= 2;
                n2 = n5 | 5;
                break;
            }
            case 6: {
                n4 |= 3;
                n2 = n5 | 5;
                break;
            }
            case 7: {
                n2 = n5 | 2;
            }
        }
        this.setHint(null);
        if (bl) {
            String string2;
            WebView webView = this.mWebView;
            int n6 = this.mWebView.nativeFocusCandidateFramePointer();
            int n7 = this.mNodePointer;
            webView.requestLabel(n6, n7);
            n3 = this.mWebView.nativeFocusCandidateMaxLength();
            if (n != 2 && (string2 = this.mWebView.nativeFocusCandidateName()) != null && string2.length() > 0) {
                WebView webView2 = this.mWebView;
                int n8 = this.mNodePointer;
                webView2.requestFormData(string2, n8);
            }
        }
        this.mSingle = bl;
        this.setMaxLength(n3);
        this.setHorizontallyScrolling(bl);
        this.setInputType(n4);
        this.setImeOptions(n2);
        this.setInPassword(bl2);
        this.setAdapterCustom(null);
    }

    void updateCachedTextfield() {
        WebView webView = this.mWebView;
        String string2 = this.getText().toString();
        webView.updateCachedTextfield(string2);
    }

    private static class OutlineDrawable
    extends Drawable {
        private OutlineDrawable() {
        }

        @Override
        public void draw(Canvas canvas) {
            Rect rect = this.getBounds();
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-1);
            canvas.drawRect(rect, paint);
            Paint.Style style2 = Paint.Style.STROKE;
            paint.setStyle(style2);
            paint.setColor(-16777216);
            canvas.drawRect(rect, paint);
        }

        @Override
        public int getOpacity() {
            return -1;
        }

        @Override
        public void setAlpha(int n) {
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
        }
    }

    public static class AutoCompleteAdapter
    extends ArrayAdapter<String> {
        private TextView mTextView;

        public AutoCompleteAdapter(Context context, ArrayList<String> arrayList) {
            super(context, 17367131, arrayList);
        }

        private void setTextView(TextView textView) {
            this.mTextView = textView;
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            TextView textView = (TextView)super.getView(n, view, viewGroup);
            if (textView != null && this.mTextView != null) {
                float f = this.mTextView.getTextSize();
                textView.setTextSize(f);
            }
            return textView;
        }
    }
}

