/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Interpolator;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.text.Editable;
import android.text.IClipboard;
import android.text.Selection;
import android.util.AttributeSet;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AlphaAnimation;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CallbackProxy;
import android.webkit.DownloadListener;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.Network;
import android.webkit.PluginFullScreenHolder;
import android.webkit.PluginList;
import android.webkit.URLUtil;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebTextView;
import android.webkit.WebViewClient;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import android.widget.AbsoluteLayout;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.EdgeGlow;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.OverScroller;
import android.widget.Toast;
import android.widget.ZoomButtonsController;
import android.widget.ZoomControls;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

public class WebView
extends AbsoluteLayout
implements ViewTreeObserver.OnGlobalFocusChangeListener,
ViewGroup.OnHierarchyChangeListener {
    private static final boolean AUTO_REDRAW_HACK = false;
    private static final int AWAKEN_SCROLL_BARS = 9;
    static final int CENTER_FIT_RECT = 127;
    static final int CLEAR_TEXT_ENTRY = 111;
    private static final boolean DEBUG_DRAG_TRACKER = false;
    private static float DEFAULT_MAX_ZOOM_SCALE = 0.0f;
    private static float DEFAULT_MIN_ZOOM_SCALE = 0.0f;
    static int DEFAULT_SCALE_PERCENT = 0;
    static final int DEFAULT_VIEWPORT_WIDTH = 800;
    static final int DOM_FOCUS_CHANGED = 122;
    static final int DO_MOTION_UP = 119;
    private static final int DRAG_HELD_MOTIONLESS = 8;
    private static final int DRAW_EXTRAS_CURSOR_RING = 3;
    private static final int DRAW_EXTRAS_FIND = 1;
    private static final int DRAW_EXTRAS_NONE = 0;
    private static final int DRAW_EXTRAS_SELECTION = 2;
    static final int FIND_AGAIN = 126;
    private static final int FIRST_PACKAGE_MSG_ID = 101;
    private static final int FIRST_PRIVATE_MSG_ID = 1;
    static final int HIDE_FULLSCREEN = 121;
    static final String[] HandlerPackageDebugString;
    static final String[] HandlerPrivateDebugString;
    static final int IMMEDIATE_REPAINT_MSG_ID = 123;
    static final int INVAL_RECT_MSG_ID = 117;
    private static final int LAST_PACKAGE_MSG_ID = 129;
    private static final int LAST_PRIVATE_MSG_ID = 10;
    static final String LOGTAG = "webview";
    static final int LONG_PRESS_CENTER = 114;
    private static final int LONG_PRESS_TIMEOUT = 1000;
    private static final int MAX_DURATION = 750;
    private static final float MAX_SLOPE_FOR_DIAG = 1.5f;
    private static float MINIMUM_SCALE_INCREMENT = 0.0f;
    private static final int MIN_BREAK_SNAP_CROSS_DISTANCE = 80;
    private static final int MIN_FLING_TIME = 250;
    private static final int MIN_SCROLL_AMOUNT_TO_DISABLE_DRAG_TRACKER = 4;
    private static final int MOTIONLESS_FALSE = 0;
    private static final int MOTIONLESS_IGNORE = 3;
    private static final int MOTIONLESS_PENDING = 1;
    private static final int MOTIONLESS_TIME = 100;
    private static final int MOTIONLESS_TRUE = 2;
    static final int MOVE_OUT_OF_PLUGIN = 110;
    private static final int NEVER_REMEMBER_PASSWORD = 2;
    static final int NEW_PICTURE_MSG_ID = 105;
    private static final int NO_LEFTEDGE = 255;
    private static final int PAGE_SCROLL_OVERLAP = 24;
    private static final int PREVENT_DEFAULT_IGNORE = 4;
    private static final int PREVENT_DEFAULT_MAYBE_YES = 1;
    private static final int PREVENT_DEFAULT_NO = 0;
    private static final int PREVENT_DEFAULT_NO_FROM_TOUCH_DOWN = 2;
    private static final int PREVENT_DEFAULT_TIMEOUT = 10;
    private static final int PREVENT_DEFAULT_YES = 3;
    static final int PREVENT_TOUCH_ID = 115;
    private static final int RELEASE_SINGLE_TAP = 5;
    private static final int REMEMBER_PASSWORD = 1;
    private static final int REQUEST_FORM_DATA = 6;
    static final int REQUEST_KEYBOARD = 118;
    static final int REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID = 128;
    private static final int RESUME_WEBCORE_PRIORITY = 7;
    static final int RETURN_LABEL = 125;
    public static final String SCHEME_GEO = "geo:0,0?q=";
    public static final String SCHEME_MAILTO = "mailto:";
    public static final String SCHEME_TEL = "tel:";
    private static final int SCROLLBAR_ALWAYSOFF = 1;
    private static final int SCROLLBAR_ALWAYSON = 2;
    private static final int SCROLLBAR_AUTO = 0;
    static final int SCROLL_BY_MSG_ID = 102;
    static final int SCROLL_TO_MSG_ID = 101;
    private static final int SELECT_CURSOR_OFFSET = 16;
    static final int SET_ROOT_LAYER_MSG_ID = 124;
    static final int SET_SCROLLBAR_MODES = 129;
    static final int SHOW_FULLSCREEN = 120;
    static final int SHOW_RECT_MSG_ID = 113;
    private static final int SLIDE_TITLE_DURATION = 500;
    private static final int SNAP_LOCK = 1;
    private static final int SNAP_NONE = 0;
    private static final int SNAP_X = 2;
    private static final int SNAP_Y = 4;
    static final int SPAWN_SCROLL_TO_MSG_ID = 103;
    private static final int STD_SPEED = 480;
    private static final int SWITCH_TO_LONGPRESS = 4;
    private static final int SWITCH_TO_SHORTPRESS = 3;
    static final int SYNC_SCROLL_TO_MSG_ID = 104;
    private static final int TAP_TIMEOUT = 200;
    private static final int TOUCH_DONE_MODE = 7;
    private static final int TOUCH_DOUBLE_TAP_MODE = 6;
    private static final int TOUCH_DRAG_MODE = 3;
    private static final int TOUCH_DRAG_START_MODE = 2;
    private static final int TOUCH_INIT_MODE = 1;
    private static final int TOUCH_PINCH_DRAG = 8;
    private static final int TOUCH_SENT_INTERVAL = 50;
    private static final int TOUCH_SHORTPRESS_MODE = 5;
    private static final int TOUCH_SHORTPRESS_START_MODE = 4;
    private static final int TRACKBALL_KEY_TIMEOUT = 1000;
    private static final int TRACKBALL_MOVE_COUNT = 10;
    private static final int TRACKBALL_MULTIPLIER = 3;
    private static final int TRACKBALL_SCALE = 400;
    private static final int TRACKBALL_SCROLL_COUNT = 5;
    private static final int TRACKBALL_TIMEOUT = 200;
    private static final int TRACKBALL_WAIT = 100;
    static final int UPDATE_TEXTFIELD_TEXT_MSG_ID = 108;
    static final int UPDATE_TEXT_ENTRY_MSG_ID = 106;
    static final int UPDATE_TEXT_SELECTION_MSG_ID = 112;
    static final int UPDATE_ZOOM_RANGE = 109;
    static final int WEBCORE_INITIALIZED_MSG_ID = 107;
    static final int WEBCORE_NEED_TOUCH_EVENTS = 116;
    private static final int ZOOM_ANIMATION_LENGTH = 500;
    private static final long ZOOM_CONTROLS_TIMEOUT;
    static boolean mLogEvent;
    private static Paint mOverScrollBackground;
    private static Paint mOverScrollBorder;
    static int sMaxViewportWidth;
    private float mActualScale;
    private boolean mAllowPanAndScale;
    private int mAnchorX;
    private int mAnchorY;
    private boolean mAutoRedraw;
    private int mBackgroundColor;
    private final CallbackProxy mCallbackProxy;
    private SslCertificate mCertificate;
    private boolean mConfirmMove;
    private int mContentHeight;
    private int mContentWidth;
    private int mCurrentTouchInterval;
    private final WebViewDatabase mDatabase;
    private float mDefaultScale;
    private int mDeferTouchMode;
    private boolean mDeferTouchProcess;
    private boolean mDelayedDeleteRootLayer;
    private int mDoubleTapSlopSquare;
    boolean mDragFromTextInput;
    private DragTracker mDragTracker;
    private DragTrackerHandler mDragTrackerHandler;
    private boolean mDrawCursorRing;
    private boolean mDrawHistory;
    private boolean mDrawSelectionPointer;
    private EdgeGlow mEdgeGlowBottom;
    private EdgeGlow mEdgeGlowLeft;
    private EdgeGlow mEdgeGlowRight;
    private EdgeGlow mEdgeGlowTop;
    private boolean mExtendSelection;
    private int mFindHeight;
    private boolean mFindIsUp;
    private boolean mFocusSizeChanged;
    private boolean mForwardTouchEvents;
    PluginFullScreenHolder mFullScreenHolder;
    private boolean mGotCenterDown;
    private boolean mGotKeyDown;
    boolean mHeightCanMeasure;
    private int mHeldMotionless;
    private int mHistoryHeight;
    private Picture mHistoryPicture;
    private int mHistoryWidth;
    private int mHorizontalScrollBarMode;
    private boolean mInOverScrollMode;
    boolean mInZoomOverview;
    private int mInitialScaleInPercent;
    private int mInitialScrollX;
    private int mInitialScrollY;
    private float mInvActualScale;
    private float mInvFinalZoomScale;
    private float mInvInitialZoomScale;
    private boolean mIsPaused;
    private Rect mLastCursorBounds;
    private long mLastCursorTime;
    private float mLastDeferTouchX;
    private float mLastDeferTouchY;
    private String mLastFind;
    private Rect mLastGlobalRect;
    int mLastHeightSent;
    private long mLastSentTouchTime;
    private long mLastTouchTime;
    private long mLastTouchUpTime;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mLastVelX;
    private float mLastVelY;
    private float mLastVelocity;
    private Rect mLastVisibleRectSent;
    int mLastWidthSent;
    private boolean mMapTrackballToArrowKeys;
    private float mMaxZoomScale;
    private int mMaximumFling;
    private int mMinLockSnapReverseDistance;
    private float mMinZoomScale;
    private boolean mMinZoomScaleFixed;
    private int mNativeClass;
    private int mNavSlop;
    private boolean mNeedToAdjustWebTextView;
    private int mOverflingDistance;
    private boolean mOverlayHorizontalScrollbar;
    private boolean mOverlayVerticalScrollbar;
    private int mOverscrollDeltaX;
    private int mOverscrollDeltaY;
    private int mOverscrollDistance;
    private String mPageThatNeedsToSlideTitleBarOffScreen;
    private PictureListener mPictureListener;
    private int mPreventDefault;
    private boolean mPreviewZoomOnly;
    final Handler mPrivateHandler;
    private ScaleGestureDetector mScaleDetector;
    private OverScroller mScroller;
    private int mSelectX;
    private int mSelectY;
    private boolean mSelectingText;
    private boolean mSelectionStarted;
    private boolean mShiftIsPressed;
    private boolean mSnapPositive;
    private int mSnapScrollMode;
    private boolean mSupportMultiTouch;
    private int mTextGeneration;
    float mTextWrapScale;
    private View mTitleBar;
    private Drawable mTitleShadow;
    private int mTouchMode;
    private int mTouchSlopSquare;
    private boolean mTrackballDown;
    private long mTrackballFirstTime;
    private long mTrackballLastTime;
    private float mTrackballRemainsX;
    private float mTrackballRemainsY;
    private long mTrackballUpTime;
    private int mTrackballXMove;
    private int mTrackballYMove;
    private boolean mUserScroll;
    VelocityTracker mVelocityTracker;
    private int mVerticalScrollBarMode;
    final ViewManager mViewManager;
    private WebTextView mWebTextView;
    private WebViewCore mWebViewCore;
    boolean mWidthCanMeasure;
    private boolean mWrapContent;
    private int mYDistanceToSlideTitleOffScreen;
    private ZoomButtonsController mZoomButtonsController;
    private float mZoomCenterX;
    private float mZoomCenterY;
    private Runnable mZoomControlRunnable;
    private ExtendedZoomControls mZoomControls;
    private ZoomButtonsController.OnZoomListener mZoomListener;
    int mZoomOverviewWidth;
    private float mZoomScale;
    private long mZoomStart;

    static {
        ZOOM_CONTROLS_TIMEOUT = ViewConfiguration.getZoomControlsTimeout();
        String[] stringArray = new String[]{"REMEMBER_PASSWORD", "NEVER_REMEMBER_PASSWORD", "SWITCH_TO_SHORTPRESS", "SWITCH_TO_LONGPRESS", "RELEASE_SINGLE_TAP", "REQUEST_FORM_DATA", "RESUME_WEBCORE_PRIORITY", "DRAG_HELD_MOTIONLESS", "AWAKEN_SCROLL_BARS", "PREVENT_DEFAULT_TIMEOUT"};
        HandlerPrivateDebugString = stringArray;
        String[] stringArray2 = new String[]{"SCROLL_TO_MSG_ID", "SCROLL_BY_MSG_ID", "SPAWN_SCROLL_TO_MSG_ID", "SYNC_SCROLL_TO_MSG_ID", "NEW_PICTURE_MSG_ID", "UPDATE_TEXT_ENTRY_MSG_ID", "WEBCORE_INITIALIZED_MSG_ID", "UPDATE_TEXTFIELD_TEXT_MSG_ID", "UPDATE_ZOOM_RANGE", "MOVE_OUT_OF_PLUGIN", "CLEAR_TEXT_ENTRY", "UPDATE_TEXT_SELECTION_MSG_ID", "SHOW_RECT_MSG_ID", "LONG_PRESS_CENTER", "PREVENT_TOUCH_ID", "WEBCORE_NEED_TOUCH_EVENTS", "INVAL_RECT_MSG_ID", "REQUEST_KEYBOARD", "DO_MOTION_UP", "SHOW_FULLSCREEN", "HIDE_FULLSCREEN", "DOM_FOCUS_CHANGED", "IMMEDIATE_REPAINT_MSG_ID", "SET_ROOT_LAYER_MSG_ID", "RETURN_LABEL", "FIND_AGAIN", "CENTER_FIT_RECT", "REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID", "SET_SCROLLBAR_MODES"};
        HandlerPackageDebugString = stringArray2;
        sMaxViewportWidth = 800;
        MINIMUM_SCALE_INCREMENT = 0.01f;
        mLogEvent = true;
    }

    public WebView(Context context) {
        this(context, null);
    }

    public WebView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842885);
    }

    public WebView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, null);
    }

    protected WebView(Context context, AttributeSet attributeSet, int n, Map<String, Object> map) {
        super(context, attributeSet, n);
        OverScroller overScroller;
        WebViewDatabase webViewDatabase;
        WebViewCore webViewCore;
        ViewManager viewManager;
        CallbackProxy callbackProxy;
        ZoomButtonsController.OnZoomListener onZoomListener;
        PrivateHandler privateHandler = new PrivateHandler();
        this.mPrivateHandler = privateHandler;
        this.mCurrentTouchInterval = 50;
        this.mTouchMode = 7;
        this.mForwardTouchEvents = false;
        this.mPreventDefault = 4;
        this.mDeferTouchMode = 7;
        this.mDrawCursorRing = true;
        this.mOverlayHorizontalScrollbar = true;
        this.mOverlayVerticalScrollbar = false;
        this.mInOverScrollMode = false;
        this.mMinZoomScaleFixed = true;
        this.mInitialScaleInPercent = 0;
        this.mInZoomOverview = false;
        this.mZoomOverviewWidth = 800;
        this.mPreviewZoomOnly = false;
        this.mUserScroll = false;
        this.mSnapScrollMode = 0;
        this.mHorizontalScrollBarMode = 0;
        this.mVerticalScrollBarMode = 0;
        this.mLastTouchUpTime = 0L;
        this.mBackgroundColor = -1;
        this.mZoomListener = onZoomListener = new ZoomButtonsController.OnZoomListener(){

            @Override
            public void onVisibilityChanged(boolean bl) {
                if (!bl) {
                    return;
                }
                WebView.this.switchOutDrawHistory();
                WebView.this.mZoomButtonsController.getZoomControls().setVisibility(0);
                WebView.this.updateZoomButtonsEnabled();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onZoom(boolean bl) {
                if (bl) {
                    boolean bl2 = WebView.this.zoomIn();
                } else {
                    boolean bl3 = WebView.this.zoomOut();
                }
                WebView.this.updateZoomButtonsEnabled();
            }
        };
        this.mDrawHistory = false;
        this.mHistoryPicture = null;
        this.mHistoryWidth = 0;
        this.mHistoryHeight = 0;
        this.mGotCenterDown = false;
        this.mTrackballFirstTime = 0L;
        this.mTrackballLastTime = 0L;
        this.mTrackballRemainsX = 0.0f;
        this.mTrackballRemainsY = 0.0f;
        this.mTrackballXMove = 0;
        this.mTrackballYMove = 0;
        this.mSelectingText = false;
        this.mSelectionStarted = false;
        this.mExtendSelection = false;
        this.mDrawSelectionPointer = false;
        this.mSelectX = 0;
        this.mSelectY = 0;
        this.mFocusSizeChanged = false;
        this.mShiftIsPressed = false;
        this.mTrackballDown = false;
        this.mTrackballUpTime = 0L;
        this.mLastCursorTime = 0L;
        this.mMapTrackballToArrowKeys = true;
        this.init();
        this.mCallbackProxy = callbackProxy = new CallbackProxy(context, this);
        this.mViewManager = viewManager = new ViewManager(this);
        CallbackProxy callbackProxy2 = this.mCallbackProxy;
        this.mWebViewCore = webViewCore = new WebViewCore(context, this, callbackProxy2, map);
        this.mDatabase = webViewDatabase = WebViewDatabase.getInstance(context);
        this.mScroller = overScroller = new OverScroller(context);
        this.updateMultiTouchSupport(context);
    }

    private void abortAnimation() {
        this.mScroller.abortAnimation();
        this.mLastVelocity = 0.0f;
    }

    static /* synthetic */ int access$10502(WebView webView, int n) {
        webView.mHorizontalScrollBarMode = n;
        return n;
    }

    static /* synthetic */ int access$10602(WebView webView, int n) {
        webView.mVerticalScrollBarMode = n;
        return n;
    }

    static /* synthetic */ boolean access$2002(WebView webView, boolean bl) {
        webView.mPreviewZoomOnly = bl;
        return bl;
    }

    static /* synthetic */ int access$2102(WebView webView, int n) {
        webView.mAnchorX = n;
        return n;
    }

    static /* synthetic */ float access$2202(WebView webView, float f) {
        webView.mZoomCenterX = f;
        return f;
    }

    static /* synthetic */ int access$2402(WebView webView, int n) {
        webView.mAnchorY = n;
        return n;
    }

    static /* synthetic */ float access$2502(WebView webView, float f) {
        webView.mZoomCenterY = f;
        return f;
    }

    static /* synthetic */ float access$2702(WebView webView, float f) {
        webView.mMinZoomScale = f;
        return f;
    }

    static /* synthetic */ int access$3002(WebView webView, int n) {
        webView.mTouchMode = n;
        return n;
    }

    static /* synthetic */ boolean access$3102(WebView webView, boolean bl) {
        webView.mConfirmMove = bl;
        return bl;
    }

    static /* synthetic */ int access$3702(WebView webView, int n) {
        webView.mPreventDefault = n;
        return n;
    }

    static /* synthetic */ float access$3802(WebView webView, float f) {
        webView.mLastTouchX = f;
        return f;
    }

    static /* synthetic */ float access$4002(WebView webView, float f) {
        webView.mLastTouchY = f;
        return f;
    }

    static /* synthetic */ boolean access$5002(WebView webView, boolean bl) {
        webView.mUserScroll = bl;
        return bl;
    }

    static /* synthetic */ boolean access$5402(WebView webView, boolean bl) {
        webView.mDelayedDeleteRootLayer = bl;
        return bl;
    }

    static /* synthetic */ boolean access$6702(WebView webView, boolean bl) {
        webView.mFocusSizeChanged = bl;
        return bl;
    }

    static /* synthetic */ boolean access$7502(WebView webView, boolean bl) {
        webView.mGotCenterDown = bl;
        return bl;
    }

    static /* synthetic */ boolean access$7602(WebView webView, boolean bl) {
        webView.mTrackballDown = bl;
        return bl;
    }

    static /* synthetic */ boolean access$7702(WebView webView, boolean bl) {
        webView.mForwardTouchEvents = bl;
        return bl;
    }

    static /* synthetic */ float access$7802(WebView webView, float f) {
        webView.mLastDeferTouchX = f;
        return f;
    }

    static /* synthetic */ float access$7902(WebView webView, float f) {
        webView.mLastDeferTouchY = f;
        return f;
    }

    static /* synthetic */ int access$8002(WebView webView, int n) {
        webView.mDeferTouchMode = n;
        return n;
    }

    static /* synthetic */ int access$9802(WebView webView, int n) {
        webView.mHeldMotionless = n;
        return n;
    }

    private void calcOurContentVisibleRect(Rect rect) {
        int n;
        int n2;
        int n3;
        int n4;
        this.calcOurVisibleRect(rect);
        int n5 = rect.left;
        rect.left = n4 = Math.max(this.viewToContentX(n5), 0);
        int n6 = rect.top;
        int n7 = this.getVisibleTitleHeight();
        int n8 = n6 + n7;
        rect.top = n3 = Math.max(this.viewToContentY(n8), 0);
        int n9 = rect.right;
        int n10 = this.viewToContentX(n9);
        int n11 = this.mContentWidth;
        rect.right = n2 = Math.min(n10, n11);
        int n12 = rect.bottom;
        int n13 = this.viewToContentY(n12);
        int n14 = this.mContentHeight;
        rect.bottom = n = Math.min(n13, n14);
    }

    private void calcOurContentVisibleRectF(RectF rectF) {
        float f;
        float f2;
        float f3;
        float f4;
        Rect rect = new Rect(0, 0, 0, 0);
        this.calcOurVisibleRect(rect);
        int n = rect.left;
        rectF.left = f4 = Math.max(this.viewToContentXf(n), 0.0f);
        int n2 = rect.top;
        int n3 = this.getVisibleTitleHeight();
        int n4 = n2 + n3;
        rectF.top = f3 = Math.max(this.viewToContentYf(n4), 0.0f);
        int n5 = rect.right;
        float f5 = this.viewToContentXf(n5);
        float f6 = this.mContentWidth;
        rectF.right = f2 = Math.min(f5, f6);
        int n6 = rect.bottom;
        float f7 = this.viewToContentYf(n6);
        float f8 = this.mContentHeight;
        rectF.bottom = f = Math.min(f7, f8);
    }

    private void calcOurVisibleRect(Rect rect) {
        int n;
        Point point = new Point();
        boolean bl = this.getGlobalVisibleRect(rect, point);
        int n2 = -point.x;
        int n3 = -point.y;
        rect.offset(n2, n3);
        if (!this.mFindIsUp) {
            return;
        }
        int n4 = rect.bottom;
        int n5 = this.mFindHeight;
        rect.bottom = n = n4 - n5;
    }

    private void cancelTouch() {
        if (this.mDragTrackerHandler != null) {
            this.mDragTrackerHandler.stopDrag();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
            this.mEdgeGlowLeft.onRelease();
            this.mEdgeGlowRight.onRelease();
        }
        if (this.mTouchMode == 3) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
        }
        this.mPrivateHandler.removeMessages(3);
        this.mPrivateHandler.removeMessages(4);
        this.mPrivateHandler.removeMessages(8);
        this.mPrivateHandler.removeMessages(9);
        this.mHeldMotionless = 2;
        this.mTouchMode = 7;
        this.nativeHideCursor();
    }

    private void cancelWebCoreTouchEvent(int n, int n2, boolean bl) {
        if (!this.shouldForwardTouchEvent()) {
            return;
        }
        if (bl) {
            this.mWebViewCore.removeMessages(141);
        }
        WebViewCore.TouchEventData touchEventData = new WebViewCore.TouchEventData();
        touchEventData.mX = n;
        touchEventData.mY = n2;
        touchEventData.mAction = 3;
        this.mWebViewCore.sendMessage(141, touchEventData);
        this.mPreventDefault = 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void centerFitRect(int n, int n2, int n3, int n4) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        int n5;
        float f8;
        float f9;
        float f10;
        int n6 = this.getViewWidth();
        float f11 = n6;
        float f12 = f11 / (f10 = (float)n3);
        float f13 = Math.min(f12, f9 = (f8 = (float)(n5 = this.getViewHeightWithTitle())) / (f7 = (float)n4));
        if (f13 < (f6 = this.mMinZoomScale)) {
            f13 = this.mMinZoomScale;
        } else {
            float f14 = this.mMaxZoomScale;
            if (f13 > f14) {
                f13 = this.mMaxZoomScale;
            }
        }
        if ((f5 = Math.abs(f13 - (f4 = this.mActualScale))) < (f3 = MINIMUM_SCALE_INCREMENT)) {
            int n7 = n3 / 2 + n;
            WebView webView = this;
            int n8 = n7;
            int n9 = webView.contentToViewX(n8);
            int n10 = n6 / 2;
            int n11 = n9 - n10;
            int n12 = n4 / 2 + n2;
            WebView webView2 = this;
            int n13 = n12;
            int n14 = webView2.contentToViewY(n13);
            int n15 = n5 / 2;
            int n16 = n14 - n15;
            WebView webView3 = this;
            int n17 = n11;
            int n18 = n16;
            boolean bl = true;
            int n19 = 0;
            boolean bl2 = webView3.pinScrollTo(n17, n18, bl, n19);
            return;
        }
        float f15 = n;
        float f16 = this.mActualScale;
        float f17 = f15 * f16;
        float f18 = this.mScrollX;
        float f19 = f17 - f18;
        float f20 = (float)n * f13;
        float f21 = (float)n3 * f13;
        float f22 = (float)this.mContentWidth * f13;
        float f23 = ((float)n6 - f21) / 2.0f;
        if (f23 > f20) {
            f23 = f20;
        } else {
            float f24 = f22 - f20 - f21;
            if (f23 > f24) {
                float f25 = n6;
                float f26 = f22 - f20;
                f23 = f25 - f26;
            }
        }
        float f27 = f19 * f13;
        float f28 = this.mActualScale * f23;
        float f29 = f27 - f28;
        float f30 = this.mActualScale;
        float f31 = f13 - f30;
        this.mZoomCenterX = f2 = f29 / f31;
        float f32 = n2;
        float f33 = this.mActualScale;
        float f34 = f32 * f33;
        float f35 = this.getTitleHeight();
        float f36 = f34 + f35;
        float f37 = this.mScrollY;
        float f38 = f36 - f37;
        float f39 = (float)n2 * f13;
        float f40 = this.getTitleHeight();
        float f41 = f39 + f40;
        float f42 = (float)n4 * f13;
        float f43 = (float)this.mContentHeight * f13;
        float f44 = this.getTitleHeight();
        float f45 = f43 + f44;
        float f46 = ((float)n5 - f42) / 2.0f;
        if (f46 > f41) {
            f46 = f41;
        } else {
            float f47 = f45 - f41 - f42;
            if (f46 > f47) {
                float f48 = n5;
                float f49 = f45 - f41;
                f46 = f48 - f49;
            }
        }
        float f50 = f38 * f13;
        float f51 = this.mActualScale * f46;
        float f52 = f50 - f51;
        float f53 = this.mActualScale;
        float f54 = f13 - f53;
        this.mZoomCenterY = f = f52 / f54;
        WebView webView = this;
        float f55 = f13;
        boolean bl = false;
        boolean bl3 = webView.zoomWithPreview(f55, bl);
    }

    private void clearHelpers() {
        this.clearTextEntry(false);
        this.selectionDone();
    }

    private void clearTextEntry(boolean bl) {
        if (!this.inEditingMode()) {
            return;
        }
        this.mWebTextView.remove();
        if (!bl) {
            return;
        }
        this.setFocusControllerInactive();
    }

    private static int computeDuration(int n, int n2) {
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        return Math.min(Math.max(n3, n4) * 1000 / 480, 750);
    }

    private int computeMaxScrollX() {
        int n = this.computeRealHorizontalScrollRange();
        int n2 = this.getViewWidth();
        return Math.max(n - n2, 0);
    }

    private int computeMaxScrollY() {
        int n = this.computeRealVerticalScrollRange();
        int n2 = this.getTitleHeight();
        int n3 = n + n2;
        int n4 = this.getViewHeightWithTitle();
        return Math.max(n3 - n4, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int computeRealHorizontalScrollRange() {
        float f;
        float f2;
        float f3;
        float f4;
        if (this.mDrawHistory) {
            return this.mHistoryWidth;
        }
        if (this.mHorizontalScrollBarMode == 1 && (f4 = (f3 = this.mActualScale) - (f2 = this.mMinZoomScale)) <= (f = MINIMUM_SCALE_INCREMENT)) {
            return this.computeHorizontalScrollExtent();
        }
        float f5 = this.mContentWidth;
        float f6 = this.mActualScale;
        return (int)Math.floor(f5 * f6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int computeRealVerticalScrollRange() {
        float f;
        float f2;
        float f3;
        float f4;
        if (this.mDrawHistory) {
            return this.mHistoryHeight;
        }
        if (this.mVerticalScrollBarMode == 1 && (f4 = (f3 = this.mActualScale) - (f2 = this.mMinZoomScale)) <= (f = MINIMUM_SCALE_INCREMENT)) {
            return this.computeVerticalScrollExtent();
        }
        float f5 = this.mContentHeight;
        float f6 = this.mActualScale;
        return (int)Math.floor(f5 * f6);
    }

    private void contentSizeChanged(boolean bl) {
        int n = this.mContentWidth;
        int n2 = this.mContentHeight;
        if ((n | n2) == 0) {
            return;
        }
        if (this.mHeightCanMeasure) {
            int n3;
            int n4;
            int n5 = this.getMeasuredHeight();
            if (n5 != (n4 = this.contentToViewDimension(n3 = this.mContentHeight)) && !bl) {
                return;
            }
            this.requestLayout();
            return;
        }
        if (this.mWidthCanMeasure) {
            int n6;
            int n7;
            int n8 = this.getMeasuredWidth();
            if (n8 != (n7 = this.contentToViewDimension(n6 = this.mContentWidth)) && !bl) {
                return;
            }
            this.requestLayout();
            return;
        }
        boolean bl2 = this.sendViewSizeZoom();
    }

    private Rect contentToViewRect(Rect rect) {
        int n = rect.left;
        int n2 = this.contentToViewX(n);
        int n3 = rect.top;
        int n4 = this.contentToViewY(n3);
        int n5 = rect.right;
        int n6 = this.contentToViewX(n5);
        int n7 = rect.bottom;
        int n8 = this.contentToViewY(n7);
        return new Rect(n2, n4, n6, n8);
    }

    private ExtendedZoomControls createZoomControls() {
        Context context = this.mContext;
        ExtendedZoomControls extendedZoomControls = new ExtendedZoomControls(context, null);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                Handler handler = WebView.this.mPrivateHandler;
                Runnable runnable = WebView.this.mZoomControlRunnable;
                handler.removeCallbacks(runnable);
                Handler handler2 = WebView.this.mPrivateHandler;
                Runnable runnable2 = WebView.this.mZoomControlRunnable;
                long l = ZOOM_CONTROLS_TIMEOUT;
                boolean bl = handler2.postDelayed(runnable2, l);
                boolean bl2 = WebView.this.zoomIn();
            }
        };
        extendedZoomControls.setOnZoomInClickListener(onClickListener);
        View.OnClickListener onClickListener2 = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                Handler handler = WebView.this.mPrivateHandler;
                Runnable runnable = WebView.this.mZoomControlRunnable;
                handler.removeCallbacks(runnable);
                Handler handler2 = WebView.this.mPrivateHandler;
                Runnable runnable2 = WebView.this.mZoomControlRunnable;
                long l = ZOOM_CONTROLS_TIMEOUT;
                boolean bl = handler2.postDelayed(runnable2, l);
                boolean bl2 = WebView.this.zoomOut();
            }
        };
        extendedZoomControls.setOnZoomOutClickListener(onClickListener2);
        return extendedZoomControls;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean didUpdateTextViewBounds(boolean bl) {
        Rect rect = this.nativeFocusCandidateNodeBounds();
        Rect rect2 = this.contentToViewRect(rect);
        Rect rect3 = new Rect();
        this.calcOurVisibleRect(rect3);
        if (bl ? Rect.intersects(rect3, rect2) : rect3.contains(rect2)) {
            WebTextView webTextView = this.mWebTextView;
            int n = rect2.left;
            int n2 = rect2.top;
            int n3 = rect2.width();
            int n4 = rect2.height();
            webTextView.setRect(n, n2, n3, n4);
            WebTextView webTextView2 = this.mWebTextView;
            int n5 = this.nativeFocusCandidateTextSize();
            float f = this.contentToViewDimension(n5);
            webTextView2.setTextSize(0, f);
            return true;
        }
        this.mWebTextView.remove();
        return false;
    }

    public static void disablePlatformNotifications() {
        Network.disablePlatformNotifications();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void displaySoftKeyboard(boolean bl) {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        float f = this.mActualScale;
        float f2 = this.mDefaultScale;
        boolean bl2 = f < f2;
        if (bl2) {
            float f3;
            float f4;
            this.mInZoomOverview = false;
            this.mZoomCenterX = f4 = this.mLastTouchX;
            this.mZoomCenterY = f3 = this.mLastTouchY;
            float f5 = this.mDefaultScale;
            this.setNewZoomScale(f5, false, false);
        }
        if (bl) {
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                WebTextView webTextView = this.mWebTextView;
                boolean bl3 = inputMethodManager.showSoftInput(webTextView, 0);
                if (!bl2) {
                    return;
                }
                boolean bl4 = this.didUpdateTextViewBounds(true);
                return;
            }
        }
        boolean bl5 = inputMethodManager.showSoftInput(this, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doDoubleTap() {
        boolean bl;
        block14: {
            block15: {
                float f;
                float f2;
                block13: {
                    float f3;
                    float f4;
                    float f5;
                    float f6;
                    WebSettings.LayoutAlgorithm layoutAlgorithm;
                    int n;
                    int n2;
                    float f7;
                    float f8;
                    if (!this.mWebViewCore.getSettings().getUseWideViewPort()) {
                        return;
                    }
                    this.mZoomCenterX = f8 = this.mLastTouchX;
                    this.mZoomCenterY = f7 = this.mLastTouchY;
                    int n3 = (int)this.mZoomCenterX;
                    int n4 = this.mScrollX;
                    int n5 = n3 + n4;
                    this.mAnchorX = n2 = this.viewToContentX(n5);
                    int n6 = (int)this.mZoomCenterY;
                    int n7 = this.mScrollY;
                    int n8 = n6 + n7;
                    this.mAnchorY = n = this.viewToContentY(n8);
                    WebSettings webSettings = this.getSettings();
                    webSettings.setDoubleTapToastCount(0);
                    this.dismissZoomControl();
                    ViewManager viewManager = this.mViewManager;
                    int n9 = this.mAnchorX;
                    int n10 = this.mAnchorY;
                    ViewManager.ChildView childView = viewManager.hitTest(n9, n10);
                    if (childView != null) {
                        if (!this.isPluginFitOnScreen(childView)) {
                            this.mInZoomOverview = false;
                            int n11 = childView.x;
                            int n12 = childView.y;
                            int n13 = childView.width;
                            int n14 = childView.height;
                            this.centerFitRect(n11, n12, n13, n14);
                            return;
                        }
                        this.mInZoomOverview = true;
                        int n15 = this.mScrollY;
                        int n16 = this.getTitleHeight();
                        if (n15 < n16) {
                            this.mScrollY = 0;
                        }
                        float f9 = this.getViewWidth();
                        float f10 = this.mZoomOverviewWidth;
                        float f11 = f9 / f10;
                        boolean bl2 = this.zoomWithPreview(f11, true);
                        return;
                    }
                    bl = false;
                    WebSettings.LayoutAlgorithm layoutAlgorithm2 = webSettings.getLayoutAlgorithm();
                    if (layoutAlgorithm2 != (layoutAlgorithm = WebSettings.LayoutAlgorithm.NARROW_COLUMNS) || !((f6 = Math.abs((f5 = this.mActualScale) - (f4 = this.mTextWrapScale))) >= (f3 = MINIMUM_SCALE_INCREMENT))) break block13;
                    float f12 = this.mActualScale;
                    this.setNewZoomScale(f12, true, true);
                    float f13 = this.getViewWidth();
                    float f14 = this.mZoomOverviewWidth;
                    float f15 = f13 / f14;
                    float f16 = Math.abs(this.mActualScale - f15);
                    float f17 = MINIMUM_SCALE_INCREMENT;
                    if (f16 < f17) {
                        this.mInZoomOverview = true;
                    }
                    break block14;
                }
                if (this.mInZoomOverview) break block15;
                float f18 = this.getViewWidth();
                float f19 = f18 / (f2 = (float)this.mZoomOverviewWidth);
                float f20 = Math.abs(this.mActualScale - f19);
                if (f20 >= (f = MINIMUM_SCALE_INCREMENT)) {
                    this.mInZoomOverview = true;
                    int n = this.mScrollY;
                    int n17 = this.getTitleHeight();
                    if (n < n17) {
                        this.mScrollY = 0;
                    }
                    boolean bl3 = this.zoomWithPreview(f19, true);
                    break block14;
                } else {
                    float f21;
                    float f22 = this.mActualScale;
                    float f23 = this.mDefaultScale;
                    float f24 = Math.abs(f22 - f23);
                    if (f24 >= (f21 = MINIMUM_SCALE_INCREMENT)) {
                        bl = true;
                    }
                }
                break block14;
            }
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.mInZoomOverview = false;
        int n = this.mAnchorX;
        int n18 = this.mAnchorY;
        float f = this.mActualScale;
        int n19 = this.nativeGetBlockLeftEdge(n, n18, f);
        if (n19 != -1) {
            int n20;
            int n21 = n19 < 5 ? 0 : n19 - 5;
            int n22 = this.contentToViewX(n21);
            int n23 = n22 - (n20 = this.mScrollX);
            if (n23 > 0) {
                float f25;
                float f26 = n23;
                float f27 = this.mDefaultScale;
                float f28 = f26 * f27;
                float f29 = this.mDefaultScale;
                float f30 = this.mActualScale;
                float f31 = f29 - f30;
                this.mZoomCenterX = f25 = f28 / f31;
            } else {
                this.scrollBy(n23, 0);
                this.mZoomCenterX = 0.0f;
            }
        }
        float f32 = this.mDefaultScale;
        boolean bl4 = this.zoomWithPreview(f32, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doDrag(int n, int n2) {
        if ((n | n2) != 0) {
            int n3 = this.mScrollX;
            int n4 = this.mScrollY;
            int n5 = this.computeMaxScrollX();
            int n6 = this.computeMaxScrollY();
            if (this.mEdgeGlowTop != null) {
                this.mOverscrollDeltaX = n;
                this.mOverscrollDeltaY = n2;
            }
            int n7 = this.mOverscrollDistance;
            int n8 = this.mOverscrollDistance;
            WebView webView = this;
            int n9 = n;
            int n10 = n2;
            boolean bl = webView.overScrollBy(n9, n10, n3, n4, n5, n6, n7, n8, true);
            if (!(this.mEdgeGlowTop == null || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished() && this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished())) {
                this.invalidate();
            }
        }
        if (this.getSettings().getBuiltInZoomControls()) {
            return;
        }
        float f = this.mMinZoomScale;
        float f2 = this.mMaxZoomScale;
        boolean bl = f < f2;
        if (this.mZoomControls == null) {
            return;
        }
        if (!bl) {
            return;
        }
        if (this.mZoomControls.getVisibility() == 0) {
            Handler handler = this.mPrivateHandler;
            Runnable runnable = this.mZoomControlRunnable;
            handler.removeCallbacks(runnable);
        } else {
            this.mZoomControls.show(bl, false);
        }
        Handler handler = this.mPrivateHandler;
        Runnable runnable = this.mZoomControlRunnable;
        long l = ZOOM_CONTROLS_TIMEOUT;
        boolean bl2 = handler.postDelayed(runnable, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doFling() {
        float f;
        float f2;
        float f3;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        float f4;
        if (this.mVelocityTracker == null) {
            return;
        }
        int n7 = this.computeMaxScrollX();
        int n8 = this.computeMaxScrollY();
        VelocityTracker velocityTracker = this.mVelocityTracker;
        float f5 = this.mMaximumFling;
        velocityTracker.computeCurrentVelocity(1000, f5);
        int n9 = (int)this.mVelocityTracker.getXVelocity();
        int n10 = (int)this.mVelocityTracker.getYVelocity();
        if (this.mSnapScrollMode != 0) {
            if ((this.mSnapScrollMode & 2) == 2) {
                n10 = 0;
            } else {
                n9 = 0;
            }
        }
        int n11 = n9 * 3 / 4;
        int n12 = n10 * 3 / 4;
        if (n7 == 0 && n12 == 0 || n8 == 0 && n11 == 0) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            OverScroller overScroller = this.mScroller;
            int n13 = this.mScrollX;
            int n14 = this.mScrollY;
            int n15 = this.computeMaxScrollX();
            int n16 = this.computeMaxScrollY();
            if (!overScroller.springBack(n13, n14, 0, n15, 0, n16)) {
                return;
            }
            this.invalidate();
            return;
        }
        float f6 = this.mScroller.getCurrVelocity();
        if (this.mLastVelocity > 0.0f && f6 > 0.0f && ((f4 = (float)Math.abs((d6 = Math.atan2(d5 = (double)this.mLastVelY, d4 = (double)this.mLastVelX)) - (d3 = Math.atan2(d2 = (double)n12, d = (double)n11)))) > 5.6548667f || f4 < 0.62831855f)) {
            float f7 = n11;
            float f8 = this.mLastVelX * f6;
            float f9 = this.mLastVelocity;
            float f10 = f8 / f9;
            n11 = (int)(f7 + f10);
            float f11 = n12;
            float f12 = this.mLastVelY * f6;
            float f13 = this.mLastVelocity;
            float f14 = f12 / f13;
            n12 = (int)(f11 + f14);
        }
        if ((this.mScrollX == 0 || this.mScrollX != n7) && (n6 = Math.abs(n11)) < (n5 = Math.abs(n12))) {
            n11 = 0;
        }
        if ((this.mScrollY == 0 || this.mScrollY != n8) && (n4 = Math.abs(n12)) < (n3 = Math.abs(n11))) {
            n12 = 0;
        }
        if ((n2 = this.mOverscrollDistance) < (n = this.mOverflingDistance)) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23 = this.mScrollX;
            int n24 = -this.mOverscrollDistance;
            if (n23 == n24 || (n22 = this.mScrollX) != (n21 = this.mOverscrollDistance + n7)) {
                n11 = 0;
            }
            if ((n20 = this.mScrollY) == (n19 = -this.mOverscrollDistance) || (n18 = this.mScrollY) != (n17 = this.mOverscrollDistance + n8)) {
                n12 = 0;
            }
        }
        this.mLastVelX = f3 = (float)n11;
        this.mLastVelY = f2 = (float)n12;
        double d7 = n11;
        double d8 = n12;
        this.mLastVelocity = f = (float)Math.hypot(d7, d8);
        OverScroller overScroller = this.mScroller;
        int n25 = this.mScrollX;
        int n26 = this.mScrollY;
        int n27 = -n11;
        int n28 = -n12;
        int n29 = 0;
        int n30 = 0;
        int n31 = n7 == 0 ? 0 : this.mOverflingDistance;
        int n32 = this.mOverflingDistance;
        overScroller.fling(n25, n26, n27, n28, n29, n7, n30, n8, n31, n32);
        int n33 = this.mScroller.getDuration();
        WebView webView = this;
        int n34 = n33;
        boolean bl = webView.awakenScrollBars(n34);
        this.invalidate();
    }

    private void doMotionUp(int n, int n2) {
        int n3;
        if (mLogEvent && this.nativeMotionUp(n, n2, n3 = this.mNavSlop)) {
            Object[] objectArray = new Object[]{};
            int n4 = EventLog.writeEvent(70150, objectArray);
        }
        if (!this.nativeHasCursorNode()) {
            return;
        }
        if (this.nativeCursorIsTextInput()) {
            return;
        }
        this.playSoundEffect(0);
    }

    private void doShortPress() {
        if (this.mNativeClass == 0) {
            return;
        }
        if (this.mPreventDefault == 3) {
            return;
        }
        this.mTouchMode = 7;
        this.switchOutDrawHistory();
        int n = (int)this.mLastTouchX;
        int n2 = this.mScrollX;
        int n3 = n + n2;
        int n4 = this.viewToContentX(n3);
        int n5 = (int)this.mLastTouchY;
        int n6 = this.mScrollY;
        int n7 = n5 + n6;
        int n8 = this.viewToContentY(n7);
        int n9 = this.mNavSlop;
        if (this.nativePointInNavCache(n4, n8, n9)) {
            Rect rect;
            int n10;
            int n11;
            WebViewCore.MotionUpData motionUpData = new WebViewCore.MotionUpData();
            motionUpData.mFrame = n11 = this.nativeCacheHitFramePointer();
            motionUpData.mNode = n10 = this.nativeCacheHitNodePointer();
            motionUpData.mBounds = rect = this.nativeCacheHitNodeBounds();
            motionUpData.mX = n4;
            motionUpData.mY = n8;
            this.mWebViewCore.sendMessageAtFrontOfQueue(146, motionUpData);
            return;
        }
        this.doMotionUp(n4, n8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doTrackball(long l) {
        boolean bl;
        int n;
        int n2;
        int n3;
        long l2 = this.mTrackballLastTime;
        long l3 = this.mTrackballFirstTime;
        int n4 = (int)(l2 - l3);
        if (n4 == 0) {
            n4 = 200;
        }
        float f = this.mTrackballRemainsX * 1000.0f;
        float f2 = n4;
        float f3 = f / f2;
        float f4 = this.mTrackballRemainsY * 1000.0f;
        float f5 = n4;
        float f6 = f4 / f5;
        int n5 = this.getViewWidth();
        int n6 = this.getViewHeight();
        if (this.mSelectingText) {
            float f7;
            float f8;
            if (!this.mDrawSelectionPointer) {
                boolean bl2;
                boolean bl3;
                int n7;
                int n8;
                int n9 = this.nativeSelectionX();
                WebView webView = this;
                int n10 = n9;
                this.mSelectX = n8 = webView.contentToViewX(n10);
                int n11 = this.nativeSelectionY();
                WebView webView2 = this;
                int n12 = n11;
                this.mSelectY = n7 = webView2.contentToViewY(n12);
                this.mExtendSelection = bl3 = true;
                this.mDrawSelectionPointer = bl2 = true;
                this.nativeSetExtendSelection();
            }
            WebView webView = this;
            float f9 = f3;
            int n13 = n5;
            float f10 = webView.scaleTrackballX(f9, n13);
            WebView webView3 = this;
            float f11 = f6;
            int n14 = n6;
            float f12 = webView3.scaleTrackballY(f11, n14);
            WebView webView4 = this;
            float f13 = f10;
            float f14 = f12;
            webView4.moveSelection(f13, f14);
            this.mTrackballRemainsY = f8 = 0.0f;
            this.mTrackballRemainsX = f7 = 0.0f;
            return;
        }
        float f15 = Math.abs(f3);
        float f16 = Math.abs(f6);
        float f17 = Math.max(f15, f16);
        int n15 = this.mContentWidth - n5;
        int n16 = this.mContentHeight - n6;
        if (n15 < 0) {
            n15 = 0;
        }
        if (n16 < 0) {
            n16 = 0;
        }
        float f18 = Math.abs(this.mTrackballRemainsX * 3.0f);
        float f19 = Math.abs(this.mTrackballRemainsY * 3.0f);
        int n17 = (int)Math.max(f18, f19);
        int n18 = Math.max(0, n17);
        int n19 = this.mScrollX;
        int n20 = this.mScrollY;
        if (n18 > 0) {
            float f20;
            float f21;
            int n21 = f18 < f19 ? (this.mTrackballRemainsY < 0.0f ? 19 : 20) : (this.mTrackballRemainsX < 0.0f ? 21 : 22);
            n18 = Math.min(n18, 10);
            if (this.mNativeClass != 0 && this.nativeFocusIsPlugin()) {
                for (int i = 0; i < n18; ++i) {
                    WebView webView = this;
                    int n22 = n21;
                    long l4 = l;
                    boolean bl4 = true;
                    webView.letPluginHandleNavKey(n22, l4, bl4);
                }
                WebView webView = this;
                int n23 = n21;
                long l5 = l;
                boolean bl5 = false;
                webView.letPluginHandleNavKey(n23, l5, bl5);
            } else {
                WebView webView = this;
                long l6 = l;
                if (webView.navHandledKey(n21, n18, false, l6)) {
                    WebView webView5 = this;
                    int n24 = n21;
                    int n25 = webView5.keyCodeToSoundsEffect(n24);
                    WebView webView6 = this;
                    int n26 = n25;
                    webView6.playSoundEffect(n26);
                }
            }
            this.mTrackballRemainsY = f21 = 0.0f;
            this.mTrackballRemainsX = f20 = 0.0f;
        }
        if (n18 < 5) {
            return;
        }
        WebView webView = this;
        float f22 = f3;
        int n27 = n15;
        int n28 = webView.scaleTrackballX(f22, n27);
        WebView webView7 = this;
        float f23 = f6;
        int n29 = n16;
        int n30 = webView7.scaleTrackballY(f23, n29);
        int n31 = Math.abs(this.mScrollX - n19);
        if (n31 > (n3 = Math.abs(n28))) {
            n28 = 0;
        }
        if ((n2 = Math.abs(this.mScrollY - n20)) > (n = Math.abs(n30))) {
            n30 = 0;
        }
        if (n28 != 0 || n30 != 0) {
            WebView webView8 = this;
            int n32 = n28;
            int n33 = n30;
            boolean bl6 = true;
            int n34 = 0;
            boolean bl7 = webView8.pinScrollBy(n32, n33, bl6, n34);
        }
        this.mUserScroll = bl = true;
    }

    private void domChangedFocus() {
        if (!this.inEditingMode()) {
            return;
        }
        this.mPrivateHandler.obtainMessage(122).sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawContent(Canvas canvas) {
        boolean bl = this.hasFocus() && this.hasWindowFocus();
        boolean bl2 = this.mTouchMode == 4 || this.mTrackballDown || this.mGotCenterDown;
        this.nativeRecordButtons(bl, bl2, false);
        int n = this.mBackgroundColor;
        boolean bl3 = this.mDrawCursorRing;
        this.drawCoreAndCursorRing(canvas, n, bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawCoreAndCursorRing(Canvas canvas, int n, boolean bl) {
        boolean bl2;
        int n2;
        int n3;
        boolean bl3;
        boolean bl4;
        block24: {
            block23: {
                int n4;
                float f;
                float f2;
                float f3;
                float f4;
                int n5;
                long l;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                if (this.mDrawHistory) {
                    float f5 = this.mActualScale;
                    float f6 = this.mActualScale;
                    Canvas canvas2 = canvas;
                    float f7 = f5;
                    float f8 = f6;
                    canvas2.scale(f7, f8);
                    Picture picture = this.mHistoryPicture;
                    Canvas canvas3 = canvas;
                    Picture picture2 = picture;
                    canvas3.drawPicture(picture2);
                    return;
                }
                bl4 = this.mZoomScale != 0.0f;
                bl3 = (!this.mScroller.isFinished() || this.mVelocityTracker != null) && ((n11 = this.mTouchMode) != (n10 = 3) || (n9 = this.mHeldMotionless) != (n8 = 2)) || (n7 = this.mDeferTouchMode) == (n6 = 3);
                int n12 = this.mTouchMode;
                int n13 = 3;
                if (n12 == n13) {
                    int n14 = this.mHeldMotionless;
                    int n15 = 1;
                    if (n14 == n15) {
                        int n16;
                        this.mPrivateHandler.removeMessages(8);
                        this.mPrivateHandler.removeMessages(9);
                        this.mHeldMotionless = n16 = 0;
                    }
                    if (this.mHeldMotionless == 0) {
                        int n17;
                        Handler handler = this.mPrivateHandler;
                        Message message = this.mPrivateHandler.obtainMessage(8);
                        boolean bl5 = handler.sendMessageDelayed(message, 100L);
                        this.mHeldMotionless = n17 = 1;
                    }
                }
                if (!bl4) break block23;
                long l2 = SystemClock.uptimeMillis();
                int n18 = (int)(l2 - (l = this.mZoomStart));
                int n19 = n18;
                if (n19 < (n5 = 500)) {
                    float f9 = (float)n18 / 500.0f;
                    float f10 = this.mInvInitialZoomScale;
                    float f11 = this.mInvFinalZoomScale;
                    float f12 = this.mInvInitialZoomScale;
                    float f13 = (f11 - f12) * f9;
                    float f14 = f10 + f13;
                    f4 = 1.0f / f14;
                    this.invalidate();
                } else {
                    float f15;
                    f4 = this.mZoomScale;
                    this.mZoomScale = f15 = 0.0f;
                    WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                    this.invalidate();
                    if (this.mNeedToAdjustWebTextView) {
                        boolean bl6;
                        this.mNeedToAdjustWebTextView = bl6 = false;
                        WebView webView = this;
                        boolean bl7 = false;
                        if (webView.didUpdateTextViewBounds(bl7) && this.nativeFocusCandidateIsPassword()) {
                            this.mWebTextView.setInPassword(true);
                        }
                    }
                }
                float f16 = this.mInvInitialZoomScale;
                float f17 = f4 * f16;
                float f18 = this.mInitialScrollX;
                float f19 = this.mZoomCenterX;
                float f20 = (f18 + f19) * f17;
                float f21 = this.mZoomCenterX;
                int n20 = Math.round(f20 - f21);
                int n21 = this.getViewWidth();
                int n22 = Math.round((float)this.mContentWidth * f4);
                int n23 = n20;
                int n24 = n21;
                int n25 = n22;
                int n26 = -WebView.pinLoc(n23, n24, n25);
                int n27 = this.mScrollX;
                int n28 = n26 + n27;
                float f22 = this.mInitialScrollY;
                float f23 = this.mZoomCenterY;
                float f24 = f22 + f23;
                int n29 = this.getTitleHeight();
                float f25 = n29;
                float f26 = (f24 - f25) * f17;
                int n30 = Math.round(f26 - (f3 = (f2 = this.mZoomCenterY) - (f = (float)n29)));
                if (n30 <= n29) {
                    int n31 = n30;
                    int n32 = 0;
                    n4 = Math.max(n31, n32);
                } else {
                    int n33 = n30 - n29;
                    int n34 = this.getViewHeight();
                    int n35 = Math.round((float)this.mContentHeight * f4);
                    n4 = WebView.pinLoc(n33, n34, n35) + n29;
                }
                int n36 = -n4;
                int n37 = this.mScrollY;
                int n38 = n36 + n37;
                float f27 = n28;
                float f28 = n38;
                Canvas canvas4 = canvas;
                float f29 = f27;
                float f30 = f28;
                canvas4.translate(f29, f30);
                Canvas canvas5 = canvas;
                float f31 = f4;
                float f32 = f4;
                canvas5.scale(f31, f32);
                if (this.inEditingMode() && !this.mNeedToAdjustWebTextView && this.mZoomScale != 0.0f) {
                    boolean bl8;
                    this.mNeedToAdjustWebTextView = bl8 = true;
                    if (this.nativeFocusCandidateIsPassword()) {
                        this.mWebTextView.setInPassword(false);
                    }
                }
                break block24;
            }
            float f = this.mActualScale;
            float f33 = this.mActualScale;
            Canvas canvas6 = canvas;
            float f34 = f;
            float f35 = f33;
            canvas6.scale(f34, f35);
        }
        char n39 = '\u0000';
        if (this.mNativeClass != 0 && this.nativeEvaluateLayersAnimations()) {
            n39 = '\u0001';
            this.invalidate();
        }
        WebViewCore webViewCore = this.mWebViewCore;
        boolean bl9 = bl4 || this.mPreviewZoomOnly || n39 != '\u0000';
        WebViewCore webViewCore2 = webViewCore;
        Canvas canvas7 = canvas;
        int n40 = n;
        boolean bl10 = bl9;
        boolean bl11 = bl3;
        webViewCore2.drawContentPicture(canvas7, n40, bl10, bl11);
        if (this.mNativeClass == 0) {
            return;
        }
        int n41 = 0;
        if (this.mFindIsUp) {
            n41 = 1;
        } else if (this.mSelectingText) {
            n41 = 2;
            boolean bl12 = this.mDrawSelectionPointer;
            float f = this.mInvActualScale;
            int n42 = this.mSelectX;
            int n43 = this.mSelectY;
            int n44 = this.getTitleHeight();
            int n45 = n43 - n44;
            WebView webView = this;
            boolean bl13 = bl12;
            float f36 = f;
            int n46 = n42;
            int n47 = n45;
            webView.nativeSetSelectionPointer(bl13, f36, n46, n47);
        } else if (bl) {
            n41 = 3;
        }
        WebView webView = this;
        Canvas canvas8 = canvas;
        int n48 = n41;
        char n49 = n39;
        webView.drawExtras(canvas8, n48, n49 != '\u0000');
        int n50 = n41;
        n49 = '\u0003';
        if (n50 == n49 && (n3 = this.mTouchMode) == (n2 = 4)) {
            int n51;
            this.mTouchMode = n51 = 5;
        }
        if (!this.mFocusSizeChanged) {
            return;
        }
        this.mFocusSizeChanged = bl2 = false;
        if (bl4) {
            return;
        }
        if (!this.inEditingMode()) {
            return;
        }
        WebView webView2 = this;
        boolean bl14 = true;
        boolean bl15 = webView2.didUpdateTextViewBounds(bl14);
    }

    private boolean drawEdgeGlows(Canvas canvas) {
        int n = this.mScrollX;
        int n2 = this.mScrollY;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        boolean bl = false;
        if (!this.mEdgeGlowTop.isFinished()) {
            int n5 = canvas.save();
            float f = -n3 / 2 + n;
            float f2 = Math.min(0, n2);
            canvas.translate(f, f2);
            EdgeGlow edgeGlow = this.mEdgeGlowTop;
            int n6 = n3 * 2;
            edgeGlow.setSize(n6, n4);
            boolean bl2 = this.mEdgeGlowTop.draw(canvas);
            bl = false | bl2;
            canvas.restoreToCount(n5);
        }
        if (!this.mEdgeGlowBottom.isFinished()) {
            int n7 = canvas.save();
            float f = -n3 / 2 + n;
            float f3 = Math.max(this.computeMaxScrollY(), n2) + n4;
            canvas.translate(f, f3);
            float f4 = n3;
            canvas.rotate(180.0f, f4, 0.0f);
            EdgeGlow edgeGlow = this.mEdgeGlowBottom;
            int n8 = n3 * 2;
            edgeGlow.setSize(n8, n4);
            boolean bl3 = this.mEdgeGlowBottom.draw(canvas);
            bl |= bl3;
            canvas.restoreToCount(n7);
        }
        if (!this.mEdgeGlowLeft.isFinished()) {
            int n9 = canvas.save();
            canvas.rotate(270.0f);
            float f = (float)(-n4) * 1.5f;
            float f5 = n2;
            float f6 = f - f5;
            float f7 = Math.min(0, n);
            canvas.translate(f6, f7);
            EdgeGlow edgeGlow = this.mEdgeGlowLeft;
            int n10 = n4 * 2;
            edgeGlow.setSize(n10, n3);
            boolean bl4 = this.mEdgeGlowLeft.draw(canvas);
            bl |= bl4;
            canvas.restoreToCount(n9);
        }
        if (!this.mEdgeGlowRight.isFinished()) {
            int n11 = canvas.save();
            canvas.rotate(90.0f);
            float f = -n4 / 2 + n2;
            float f8 = -(Math.max(this.computeMaxScrollX(), n) + n3);
            canvas.translate(f, f8);
            EdgeGlow edgeGlow = this.mEdgeGlowRight;
            int n12 = n4 * 2;
            edgeGlow.setSize(n12, n3);
            boolean bl5 = this.mEdgeGlowRight.draw(canvas);
            bl |= bl5;
            canvas.restoreToCount(n11);
        }
        return bl;
    }

    private void drawExtras(Canvas canvas, int n, boolean bl) {
        if (bl) {
            DrawFilter drawFilter = this.mWebViewCore.mZoomFilter;
            canvas.setDrawFilter(drawFilter);
        }
        this.nativeDrawExtras(canvas, n);
        canvas.setDrawFilter(null);
    }

    public static void enablePlatformNotifications() {
        Network.enablePlatformNotifications();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean extendScroll(int n) {
        int n2 = this.mScroller.getFinalY();
        int n3 = n2 + n;
        int n4 = this.pinLocY(n3);
        if (n4 != n2) {
            return false;
        }
        this.mScroller.setFinalY(n4);
        OverScroller overScroller = this.mScroller;
        int n5 = WebView.computeDuration(0, n);
        overScroller.extendDuration(n5);
        return true;
    }

    public static String findAddress(String string2) {
        return WebView.findAddress(string2, false);
    }

    public static String findAddress(String string2, boolean bl) {
        return WebViewCore.nativeFindAddress(string2, bl);
    }

    @Deprecated
    public static PluginList getPluginList() {
        synchronized (WebView.class) {
            PluginList pluginList = new PluginList();
            return pluginList;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getScaledMaxXScroll() {
        int n;
        if (!this.mHeightCanMeasure) {
            n = this.getViewWidth() / 4;
            return this.viewToContentX(n);
        }
        Rect rect = new Rect();
        this.calcOurVisibleRect(rect);
        n = rect.width() / 2;
        return this.viewToContentX(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getScaledMaxYScroll() {
        int n;
        if (!this.mHeightCanMeasure) {
            n = this.getViewHeight() / 4;
        } else {
            Rect rect = new Rect();
            this.calcOurVisibleRect(rect);
            n = rect.height() / 2;
        }
        float f = n;
        float f2 = this.mInvActualScale;
        return Math.round(f * f2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getTitleHeight() {
        if (this.mTitleBar == null) return 0;
        return this.mTitleBar.getHeight();
    }

    private int getViewHeightWithTitle() {
        int n = this.getHeight();
        if (this.isHorizontalScrollBarEnabled() && !this.mOverlayHorizontalScrollbar) {
            int n2 = this.getHorizontalScrollbarHeight();
            n -= n2;
        }
        return n;
    }

    private int getVisibleTitleHeight() {
        int n = this.getTitleHeight();
        int n2 = this.mScrollY;
        int n3 = Math.max(0, n2);
        return Math.max(n - n3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void goBackOrForward(int n, boolean bl) {
        if (n == 0) {
            return;
        }
        this.clearHelpers();
        WebViewCore webViewCore = this.mWebViewCore;
        int n2 = 106;
        int n3 = bl ? 1 : 0;
        webViewCore.sendMessage(n2, n, n3);
    }

    private void hideSoftKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        IBinder iBinder = this.getWindowToken();
        boolean bl = inputMethodManager.hideSoftInputFromWindow(iBinder, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hitFocusedPlugin(int n, int n2) {
        if (!this.nativeFocusIsPlugin()) return false;
        if (!this.nativeFocusNodeBounds().contains(n, n2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inEditingMode() {
        if (this.mWebTextView == null) return false;
        if (this.mWebTextView.getParent() == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inFullScreenMode() {
        if (this.mFullScreenHolder == null) return false;
        return true;
    }

    private void init() {
        int n;
        int n2;
        int n3;
        float f;
        float f2;
        float f3;
        int n4;
        int n5;
        int n6;
        this.setWillNotDraw(false);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setClickable(true);
        this.setLongClickable(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.getContext());
        int n7 = viewConfiguration.getScaledTouchSlop();
        this.mTouchSlopSquare = n6 = n7 * n7;
        this.mMinLockSnapReverseDistance = n7;
        int n8 = viewConfiguration.getScaledDoubleTapSlop();
        this.mDoubleTapSlopSquare = n5 = n8 * n8;
        float f4 = this.getContext().getResources().getDisplayMetrics().density;
        this.mNavSlop = n4 = (int)(16.0f * f4);
        DEFAULT_SCALE_PERCENT = (int)(100.0f * f4);
        this.mDefaultScale = f4;
        this.mActualScale = f4;
        this.mInvActualScale = f3 = 1.0f / f4;
        this.mTextWrapScale = f4;
        DEFAULT_MAX_ZOOM_SCALE = 4.0f * f4;
        DEFAULT_MIN_ZOOM_SCALE = 0.25f * f4;
        this.mMaxZoomScale = f2 = DEFAULT_MAX_ZOOM_SCALE;
        this.mMinZoomScale = f = DEFAULT_MIN_ZOOM_SCALE;
        this.mMaximumFling = n3 = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = n2 = viewConfiguration.getScaledOverscrollDistance();
        this.mOverflingDistance = n = viewConfiguration.getScaledOverflingDistance();
    }

    private void invalidateContentRect(Rect rect) {
        int n = rect.left;
        int n2 = rect.top;
        int n3 = rect.right;
        int n4 = rect.bottom;
        this.viewInvalidate(n, n2, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isPluginFitOnScreen(ViewManager.ChildView childView) {
        int n;
        int n2;
        int n3;
        int n4;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        int n5;
        float f6;
        float f7;
        float f8;
        int n6 = this.getViewWidth();
        float f9 = n6;
        float f10 = f9 / (f8 = (float)childView.width);
        float f11 = Math.min(f10, f7 = (f6 = (float)(n5 = this.getViewHeightWithTitle())) / (f5 = (float)childView.height));
        if (f11 < (f4 = this.mMinZoomScale)) {
            f11 = this.mMinZoomScale;
        } else {
            float f12 = this.mMaxZoomScale;
            if (f11 > f12) {
                f11 = this.mMaxZoomScale;
            }
        }
        if (!((f3 = Math.abs(f11 - (f2 = this.mActualScale))) < (f = MINIMUM_SCALE_INCREMENT))) return false;
        int n7 = childView.x;
        int n8 = this.contentToViewX(n7);
        if (n8 < (n4 = this.mScrollX)) return false;
        int n9 = childView.x;
        int n10 = childView.width;
        int n11 = n9 + n10;
        int n12 = this.contentToViewX(n11);
        if (n12 > (n3 = this.mScrollX + n6)) return false;
        int n13 = childView.y;
        int n14 = this.contentToViewY(n13);
        if (n14 < (n2 = this.mScrollY)) return false;
        int n15 = childView.y;
        int n16 = childView.height;
        int n17 = n15 + n16;
        int n18 = this.contentToViewY(n17);
        if (n18 > (n = this.mScrollY + n5)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int keyCodeToSoundsEffect(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("keyCode must be one of {KEYCODE_DPAD_UP, KEYCODE_DPAD_RIGHT, KEYCODE_DPAD_DOWN, KEYCODE_DPAD_LEFT}.");
            }
            case 19: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 20: {
                return 4;
            }
            case 21: 
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void letPluginHandleNavKey(int n, long l, boolean bl) {
        int n2;
        int n3;
        if (bl) {
            n3 = 0;
            n2 = 103;
            int n4 = this.keyCodeToSoundsEffect(n);
            this.playSoundEffect(n4);
        } else {
            n3 = 1;
            n2 = 104;
        }
        int n5 = 1;
        boolean bl2 = this.mShiftIsPressed;
        int n6 = bl2 | false | 0;
        long l2 = l;
        long l3 = l;
        int n7 = n;
        KeyEvent keyEvent = new KeyEvent(l2, l3, n3, n7, n5, n6, 0, 0, 0);
        this.mWebViewCore.sendMessage(n2, keyEvent);
    }

    private native int nativeCacheHitFramePointer();

    private native Rect nativeCacheHitNodeBounds();

    private native int nativeCacheHitNodePointer();

    private native void nativeCreate(int var1);

    private native int nativeCursorFramePointer();

    private native boolean nativeCursorIntersects(Rect var1);

    private native boolean nativeCursorIsAnchor();

    private native boolean nativeCursorIsTextInput();

    private native Rect nativeCursorNodeBounds();

    private native int nativeCursorNodePointer();

    private native Point nativeCursorPosition();

    private native String nativeCursorText();

    private native boolean nativeCursorWantsKeyEvents();

    private native void nativeDebugDump();

    private native void nativeDestroy();

    private native void nativeDrawExtras(Canvas var1, int var2);

    private native void nativeDumpDisplayTree(String var1);

    private native boolean nativeEvaluateLayersAnimations();

    private native void nativeExtendSelection(int var1, int var2);

    private native int nativeFindAll(String var1, String var2);

    private native int nativeFindIndex();

    private native void nativeFindNext(boolean var1);

    private native boolean nativeFocusCandidateIsRtlText();

    private native boolean nativeFocusCandidateIsTextInput();

    private native Rect nativeFocusCandidateNodeBounds();

    private native Rect nativeFocusCandidatePaddingRect();

    private native String nativeFocusCandidateText();

    private native int nativeFocusCandidateTextSize();

    private native int nativeFocusCandidateType();

    private native boolean nativeFocusIsPlugin();

    private native Rect nativeFocusNodeBounds();

    private native int nativeGetBlockLeftEdge(int var1, int var2, float var3);

    private native Rect nativeGetCursorRingBounds();

    private native String nativeGetSelection();

    private native boolean nativeHasCursorNode();

    private native boolean nativeHasFocusNode();

    private native void nativeHideCursor();

    private native boolean nativeHitSelection(int var1, int var2);

    private native String nativeImageURI(int var1, int var2);

    private native void nativeInstrumentReport();

    private native boolean nativeMotionUp(int var1, int var2, int var3);

    private native boolean nativeMoveCursor(int var1, int var2, boolean var3);

    private native int nativeMoveGeneration();

    private native void nativeMoveSelection(int var1, int var2);

    private native boolean nativePointInNavCache(int var1, int var2, int var3);

    private native void nativeRecordButtons(boolean var1, boolean var2, boolean var3);

    private native void nativeResetSelection();

    private native void nativeSelectAll();

    private native void nativeSelectBestAt(Rect var1);

    private native int nativeSelectionX();

    private native int nativeSelectionY();

    private native void nativeSetExtendSelection();

    private native void nativeSetFindIsEmpty();

    private native void nativeSetFindIsUp(boolean var1);

    private native void nativeSetFollowedLink(boolean var1);

    private native void nativeSetHeightCanMeasure(boolean var1);

    private native void nativeSetRootLayer(int var1);

    private native void nativeSetSelectionPointer(boolean var1, float var2, int var3, int var4);

    private native void nativeSetSelectionRegion(boolean var1);

    private native boolean nativeStartSelection(int var1, int var2);

    private native Rect nativeSubtractLayers(Rect var1);

    private native int nativeTextGeneration();

    private native void nativeUpdateCachedTextfield(String var1, int var2);

    private native boolean nativeWordSelection(int var1, int var2);

    /*
     * Enabled aggressive block sorting
     */
    private boolean navHandledKey(int n, int n2, boolean bl, long l) {
        Rect rect;
        if (this.mNativeClass == 0) {
            return false;
        }
        this.mLastCursorTime = l;
        this.mLastCursorBounds = rect = this.nativeGetCursorRingBounds();
        if (this.nativeMoveCursor(n, n2, bl)) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (!this.mHeightCanMeasure) {
            return bl2;
        }
        Rect rect2 = this.nativeGetCursorRingBounds();
        if (rect2.isEmpty()) {
            return bl2;
        }
        Rect rect3 = this.contentToViewRect(rect2);
        Rect rect4 = new Rect();
        this.calcOurVisibleRect(rect4);
        Rect rect5 = new Rect(rect4);
        int n3 = rect4.width() / 2;
        int n4 = rect4.height() / 2;
        int n5 = -n3;
        int n6 = -n4;
        rect5.inset(n5, n6);
        if (!Rect.intersects(rect5, rect3)) {
            return bl2;
        }
        int n7 = rect3.right;
        int n8 = rect4.right;
        int n9 = Math.min(n7 - n8, n3);
        if (n9 > 0) {
            boolean bl3 = this.pinScrollBy(n9, 0, true, 0);
        } else {
            int n10 = rect3.left;
            int n11 = rect4.left;
            int n12 = n10 - n11;
            int n13 = -n3;
            n9 = Math.max(n12, n13);
            if (n9 < 0) {
                boolean bl4 = this.pinScrollBy(n9, 0, true, 0);
            }
        }
        if (this.mLastCursorBounds.isEmpty()) {
            return bl2;
        }
        if (this.mLastCursorBounds.equals(rect2)) {
            return bl2;
        }
        boolean bl5 = this.requestRectangleOnScreen(rect3);
        this.mUserScroll = true;
        return bl2;
    }

    private void overrideLoading(String string2) {
        boolean bl = this.mCallbackProxy.uiOverrideUrlLoading(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int pinLoc(int n, int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        if (n < 0) {
            return n;
        }
        if (n + n2 <= n3) return n;
        return n3 - n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pinLocX(int n) {
        if (this.mInOverScrollMode) {
            return n;
        }
        int n2 = this.getViewWidth();
        int n3 = this.computeRealHorizontalScrollRange();
        return WebView.pinLoc(n, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pinLocY(int n) {
        if (this.mInOverScrollMode) {
            return n;
        }
        int n2 = this.getViewHeightWithTitle();
        int n3 = this.computeRealVerticalScrollRange();
        int n4 = this.getTitleHeight();
        int n5 = n3 + n4;
        return WebView.pinLoc(n, n2, n5);
    }

    private boolean pinScrollBy(int n, int n2, boolean bl, int n3) {
        int n4 = this.mScrollX + n;
        int n5 = this.mScrollY + n2;
        return this.pinScrollTo(n4, n5, bl, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean pinScrollTo(int n, int n2, boolean bl, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.pinLocX(n);
        int n9 = n8 - (n7 = this.mScrollX);
        if ((n9 | (n6 = (n5 = this.pinLocY(n2)) - (n4 = this.mScrollY))) == 0) {
            return false;
        }
        if (bl) {
            OverScroller overScroller = this.mScroller;
            int n10 = this.mScrollX;
            int n11 = this.mScrollY;
            int n12 = n3 > 0 ? n3 : WebView.computeDuration(n9, n6);
            overScroller.startScroll(n10, n11, n9, n6, n12);
            int n13 = this.mScroller.getDuration();
            boolean bl2 = this.awakenScrollBars(n13);
            this.invalidate();
            return true;
        } else {
            this.abortAnimation();
            this.scrollTo(n8, n5);
        }
        return true;
    }

    private void recordNewContentSize(int n, int n2, boolean bl) {
        if ((n | n2) == 0) {
            return;
        }
        if (this.mContentWidth == n || this.mContentHeight != n2) {
            this.mContentWidth = n;
            this.mContentHeight = n2;
            if (!this.mDrawHistory) {
                int n3;
                int n4;
                int n5;
                int n6 = this.mScrollX;
                int n7 = this.mScrollY;
                int n8 = this.mScrollX;
                this.mScrollX = n5 = this.pinLocX(n8);
                int n9 = this.mScrollY;
                this.mScrollY = n4 = this.pinLocY(n9);
                int n10 = this.mScrollX;
                if (n6 == n10 || n7 != (n3 = this.mScrollY)) {
                    int n11 = this.mScrollX;
                    int n12 = this.mScrollY;
                    this.onScrollChanged(n11, n12, n6, n7);
                }
                if (!this.mScroller.isFinished()) {
                    OverScroller overScroller = this.mScroller;
                    int n13 = this.mScroller.getFinalX();
                    int n14 = this.pinLocX(n13);
                    overScroller.setFinalX(n14);
                    OverScroller overScroller2 = this.mScroller;
                    int n15 = this.mScroller.getFinalY();
                    int n16 = this.pinLocY(n15);
                    overScroller2.setFinalY(n16);
                }
            }
        }
        this.contentSizeChanged(bl);
    }

    private void restoreHistoryPictureFields(Picture picture, Bundle bundle) {
        boolean bl;
        float f;
        float f2;
        int n;
        int n2;
        int n3 = bundle.getInt("scrollX", 0);
        int n4 = bundle.getInt("scrollY", 0);
        float f3 = bundle.getFloat("scale", 1.0f);
        this.mDrawHistory = true;
        this.mHistoryPicture = picture;
        this.mScrollX = n3;
        this.mScrollY = n4;
        this.mHistoryWidth = n2 = Math.round((float)picture.getWidth() * f3);
        this.mHistoryHeight = n = Math.round((float)picture.getHeight() * f3);
        this.mActualScale = f3;
        this.mInvActualScale = f2 = 1.0f / f3;
        this.mTextWrapScale = f = bundle.getFloat("textwrapScale", f3);
        this.mInZoomOverview = bl = bundle.getBoolean("overview");
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scaleTrackballX(float f, int n) {
        int n2;
        float f2 = f / 400.0f;
        float f3 = n;
        int n3 = n2 = (int)(f2 * f3);
        if (n2 > 0) {
            int n4 = this.mTrackballXMove;
            if (n2 > n4) {
                int n5 = this.mTrackballXMove;
                n2 -= n5;
            }
        } else {
            int n6 = this.mTrackballXMove;
            if (n2 < n6) {
                int n7 = this.mTrackballXMove;
                n2 -= n7;
            }
        }
        this.mTrackballXMove = n3;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scaleTrackballY(float f, int n) {
        int n2;
        float f2 = f / 400.0f;
        float f3 = n;
        int n3 = n2 = (int)(f2 * f3);
        if (n2 > 0) {
            int n4 = this.mTrackballYMove;
            if (n2 > n4) {
                int n5 = this.mTrackballYMove;
                n2 -= n5;
            }
        } else {
            int n6 = this.mTrackballYMove;
            if (n2 < n6) {
                int n7 = this.mTrackballYMove;
                n2 -= n7;
            }
        }
        this.mTrackballYMove = n3;
        return n2;
    }

    private void sendMotionUp(int n, int n2, int n3, int n4, int n5) {
        WebViewCore.TouchUpData touchUpData = new WebViewCore.TouchUpData();
        touchUpData.mMoveGeneration = n;
        touchUpData.mFrame = n2;
        touchUpData.mNode = n3;
        touchUpData.mX = n4;
        touchUpData.mY = n5;
        this.mWebViewCore.sendMessage(140, touchUpData);
    }

    private void sendMoveFocus(int n, int n2) {
        WebViewCore webViewCore = this.mWebViewCore;
        WebViewCore.CursorData cursorData = new WebViewCore.CursorData(n, n2, 0, 0);
        webViewCore.sendMessage(127, cursorData);
    }

    private void sendMoveMouse(int n, int n2, int n3, int n4) {
        WebViewCore webViewCore = this.mWebViewCore;
        WebViewCore.CursorData cursorData = new WebViewCore.CursorData(n, n2, n3, n4);
        webViewCore.sendMessage(135, cursorData);
    }

    private void sendMoveMouseIfLatest(boolean bl) {
        if (bl) {
            this.clearTextEntry(true);
        }
        WebViewCore webViewCore = this.mWebViewCore;
        WebViewCore.CursorData cursorData = this.cursorData();
        webViewCore.sendMessage(136, cursorData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Rect sendOurVisibleRect() {
        Rect rect;
        if (this.mPreviewZoomOnly) {
            return this.mLastVisibleRectSent;
        }
        Rect rect2 = new Rect();
        this.calcOurContentVisibleRect(rect2);
        Rect rect3 = this.mLastVisibleRectSent;
        if (!rect2.equals(rect3)) {
            int n = rect2.left;
            int n2 = rect2.top;
            Point point = new Point(n, n2);
            WebViewCore webViewCore = this.mWebViewCore;
            int n3 = this.nativeMoveGeneration();
            webViewCore.sendMessage(107, n3, 0, point);
            this.mLastVisibleRectSent = rect2;
        }
        if (!this.getGlobalVisibleRect(rect = new Rect())) return rect2;
        Rect rect4 = this.mLastGlobalRect;
        if (rect.equals(rect4)) return rect2;
        this.mWebViewCore.sendMessage(116, rect);
        this.mLastGlobalRect = rect;
        return rect2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean sendViewSizeZoom() {
        int n;
        int n2;
        float f;
        int n3;
        int n4;
        int n5;
        if (this.mPreviewZoomOnly) {
            return false;
        }
        int n6 = this.getViewWidth();
        float f2 = n6;
        float f3 = this.mInvActualScale;
        int n7 = Math.round(f2 * f3);
        float f4 = this.getViewHeight();
        float f5 = this.mInvActualScale;
        int n8 = Math.round(f4 * f5);
        int n9 = this.mLastWidthSent;
        if (n7 > n9 && this.mWrapContent) {
            n8 = 0;
        }
        if (n7 != (n5 = this.mLastWidthSent) && n8 == (n4 = this.mLastHeightSent)) {
            return false;
        }
        ViewSizeData viewSizeData = new ViewSizeData();
        viewSizeData.mWidth = n7;
        viewSizeData.mHeight = n8;
        float f6 = n6;
        float f7 = this.mTextWrapScale;
        viewSizeData.mTextWrapWidth = n3 = Math.round(f6 / f7);
        viewSizeData.mScale = f = this.mActualScale;
        boolean bl = this.mZoomScale != 0.0f && !this.mHeightCanMeasure;
        viewSizeData.mIgnoreHeight = bl;
        viewSizeData.mAnchorX = n2 = this.mAnchorX;
        viewSizeData.mAnchorY = n = this.mAnchorY;
        this.mWebViewCore.sendMessage(105, viewSizeData);
        this.mLastWidthSent = n7;
        this.mLastHeightSent = n8;
        this.mAnchorY = 0;
        this.mAnchorX = 0;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setActive(boolean bl) {
        block6: {
            block4: {
                block5: {
                    if (!bl) break block4;
                    if (!this.hasFocus()) break block5;
                    this.mDrawCursorRing = true;
                    if (this.mNativeClass != 0) {
                        this.nativeRecordButtons(true, false, true);
                        if (this.inEditingMode()) {
                            this.mWebViewCore.sendMessage(142, 1, 0);
                        }
                    }
                    break block6;
                }
                this.mDrawCursorRing = false;
                break block6;
            }
            if (this.mWebViewCore != null && this.getSettings().getBuiltInZoomControls() && (this.mZoomButtonsController == null || !this.mZoomButtonsController.isVisible())) {
                this.mDrawCursorRing = false;
            }
            this.mGotKeyDown = false;
            this.mShiftIsPressed = false;
            this.mPrivateHandler.removeMessages(4);
            this.mTouchMode = 7;
            if (this.mNativeClass != 0) {
                this.nativeRecordButtons(false, false, true);
            }
            this.setFocusControllerInactive();
        }
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setContentScrollBy(int n, int n2, boolean bl) {
        if (this.mDrawHistory) {
            return false;
        }
        n = this.contentToViewDimension(n);
        n2 = this.contentToViewDimension(n2);
        if (!this.mHeightCanMeasure) return this.pinScrollBy(n, n2, bl, 0);
        if (n2 != 0) {
            Rect rect = new Rect();
            this.calcOurVisibleRect(rect);
            rect.offset(n, n2);
            boolean bl2 = this.requestRectangleOnScreen(rect);
        }
        if (n2 != 0) return false;
        if (n == 0) return false;
        if (!this.pinScrollBy(n, 0, bl, 0)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setContentScrollTo(int n, int n2) {
        int n3;
        int n4;
        if (this.mDrawHistory) {
            return false;
        }
        if ((n | n2) == 0) {
            n4 = 0;
            n3 = 0;
        } else {
            n4 = this.contentToViewX(n);
            n3 = this.contentToViewY(n2);
        }
        if (n == 0 && n2 == 1 && this.mScrollX == 0 && this.mScrollY == 0 && this.mTitleBar != null) {
            if (this.getProgress() < 100) {
                String string2;
                this.mPageThatNeedsToSlideTitleBarOffScreen = string2 = this.getUrl();
                this.mYDistanceToSlideTitleOffScreen = n3;
                return false;
            } else {
                boolean bl = this.pinScrollTo(n4, n3, true, 500);
            }
            return false;
        }
        boolean bl = this.pinScrollTo(n4, n3, false, 0);
        if (this.mScrollX != n4) {
            if (n >= 0) return true;
        }
        if (this.mScrollY == n3) return false;
        if (n2 < 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setNewZoomScale(float f, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        float f2;
        float f3;
        float f4 = this.mMinZoomScale;
        if (f < f4) {
            f = this.mMinZoomScale;
            float f5 = this.mDefaultScale;
            if (f < f5) {
                this.mInZoomOverview = true;
            }
        } else {
            float f6 = this.mMaxZoomScale;
            if (f > f6) {
                f = this.mMaxZoomScale;
            }
        }
        if (bl) {
            this.mTextWrapScale = f;
            this.mLastHeightSent = 0;
        }
        if (f == (f3 = this.mActualScale) && !bl2) {
            return;
        }
        if (this.mDrawHistory) {
            float f7;
            float f8 = this.mActualScale;
            if (f != f8 && !this.mPreviewZoomOnly) {
                CallbackProxy callbackProxy = this.mCallbackProxy;
                float f9 = this.mActualScale;
                callbackProxy.onScaleChanged(f9, f);
            }
            this.mActualScale = f;
            this.mInvActualScale = f7 = 1.0f / f;
            boolean bl3 = this.sendViewSizeZoom();
            return;
        }
        int n4 = this.mScrollX;
        int n5 = this.mScrollY;
        float f10 = this.mInvActualScale;
        float f11 = f * f10;
        float f12 = (float)n4 * f11;
        float f13 = f11 - 1.0f;
        float f14 = this.mZoomCenterX;
        float f15 = f13 * f14;
        float f16 = f12 + f15;
        float f17 = (float)n5 * f11;
        float f18 = f11 - 1.0f;
        float f19 = this.mZoomCenterY;
        float f20 = this.getTitleHeight();
        float f21 = f19 - f20;
        float f22 = f18 * f21;
        float f23 = f17 + f22;
        float f24 = this.mActualScale;
        if (f != f24 && !this.mPreviewZoomOnly) {
            CallbackProxy callbackProxy = this.mCallbackProxy;
            float f25 = this.mActualScale;
            callbackProxy.onScaleChanged(f25, f);
        }
        this.mActualScale = f;
        this.mInvActualScale = f2 = 1.0f / f;
        this.mViewManager.scaleAll();
        int n6 = Math.round(f16);
        this.mScrollX = n3 = this.pinLocX(n6);
        int n7 = Math.round(f23);
        this.mScrollY = n2 = this.pinLocY(n7);
        int n8 = this.mScrollX;
        if (n4 == n8 || n5 != (n = this.mScrollY)) {
            int n9 = this.mScrollX;
            int n10 = this.mScrollY;
            this.onScrollChanged(n9, n10, n4, n5);
        } else {
            Rect rect = this.sendOurVisibleRect();
        }
        boolean bl4 = this.sendViewSizeZoom();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldForwardTouchEvent() {
        if (this.mFullScreenHolder != null) return true;
        if (!this.mForwardTouchEvents) return false;
        if (this.mSelectingText) return false;
        if (this.mPreventDefault == 4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int sign(float f) {
        if (f > 0.0f) {
            return 1;
        }
        if (!(f < 0.0f)) return 0;
        return -1;
    }

    private void spawnContentScrollTo(int n, int n2) {
        if (this.mDrawHistory) {
            return;
        }
        int n3 = this.contentToViewX(n);
        int n4 = this.contentToViewY(n2);
        boolean bl = this.pinScrollTo(n3, n4, true, 0);
    }

    private void startDrag() {
        WebSettings webSettings;
        WebViewCore.reducePriority();
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        if (!this.mDragFromTextInput) {
            this.nativeHideCursor();
        }
        if (!(webSettings = this.getSettings()).supportZoom()) {
            return;
        }
        if (!webSettings.getBuiltInZoomControls()) {
            return;
        }
        if (this.getZoomButtonsController().isVisible()) {
            return;
        }
        float f = this.mMinZoomScale;
        float f2 = this.mMaxZoomScale;
        if (!(f < f2)) {
            return;
        }
        if (this.mHorizontalScrollBarMode == 1 && this.mVerticalScrollBarMode == 1) {
            return;
        }
        this.mZoomButtonsController.setVisible(true);
        int n = webSettings.getDoubleTapToastCount();
        if (!this.mInZoomOverview) {
            return;
        }
        if (n <= 0) {
            return;
        }
        int n2 = n + -1;
        webSettings.setDoubleTapToastCount(n2);
        Toast.makeText(this.mContext, 17040051, 1).show();
    }

    private void startTouch(float f, float f2, long l) {
        DragTrackerHandler dragTrackerHandler;
        VelocityTracker velocityTracker;
        this.mLastTouchX = f;
        this.mLastTouchY = f2;
        this.mLastTouchTime = l;
        this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
        this.mSnapScrollMode = 0;
        if (this.mDragTracker == null) {
            return;
        }
        DragTracker dragTracker = this.mDragTracker;
        this.mDragTrackerHandler = dragTrackerHandler = new DragTrackerHandler(f, f2, dragTracker);
    }

    private void stopTouch() {
        if (this.mDragTrackerHandler != null) {
            this.mDragTrackerHandler.stopDrag();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mEdgeGlowTop == null) {
            return;
        }
        this.mEdgeGlowTop.onRelease();
        this.mEdgeGlowBottom.onRelease();
        this.mEdgeGlowLeft.onRelease();
        this.mEdgeGlowRight.onRelease();
    }

    private void updateSelection() {
        if (this.mNativeClass == 0) {
            return;
        }
        int n = (int)this.mLastTouchX;
        int n2 = this.mScrollX;
        int n3 = n + n2;
        int n4 = this.viewToContentX(n3);
        int n5 = (int)this.mLastTouchY;
        int n6 = this.mScrollY;
        int n7 = n5 + n6;
        int n8 = this.viewToContentY(n7);
        int n9 = this.mNavSlop;
        int n10 = n4 - n9;
        int n11 = this.mNavSlop;
        int n12 = n8 - n11;
        int n13 = this.mNavSlop + n4;
        int n14 = this.mNavSlop + n8;
        Rect rect = new Rect(n10, n12, n13, n14);
        this.nativeSelectBestAt(rect);
    }

    private void updateTextSelectionFromMessage(int n, int n2, WebViewCore.TextSelectionData textSelectionData) {
        if (!this.inEditingMode()) {
            return;
        }
        if (!this.mWebTextView.isSameTextField(n)) {
            return;
        }
        int n3 = this.mTextGeneration;
        if (n2 != n3) {
            return;
        }
        WebTextView webTextView = this.mWebTextView;
        int n4 = textSelectionData.mStart;
        int n5 = textSelectionData.mEnd;
        webTextView.setSelectionFromWebKit(n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateZoomButtonsEnabled() {
        if (this.mZoomButtonsController == null) {
            return;
        }
        float f = this.mActualScale;
        float f2 = this.mMaxZoomScale;
        boolean bl = f < f2;
        float f3 = this.mActualScale;
        float f4 = this.mMinZoomScale;
        boolean bl2 = f3 > f4 && !this.mInZoomOverview;
        if (!bl && !bl2) {
            this.mZoomButtonsController.getZoomControls().setVisibility(8);
            return;
        }
        this.mZoomButtonsController.setZoomInEnabled(bl);
        this.mZoomButtonsController.setZoomOutEnabled(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateZoomRange(WebViewCore.RestoreState restoreState, int n, int n2, boolean bl) {
        float f;
        block6: {
            float f2;
            block4: {
                float f3;
                block5: {
                    if (restoreState.mMinScale != 0.0f) break block4;
                    if (!restoreState.mMobileSite) break block5;
                    int n3 = Math.max(0, n);
                    if (n2 > n3) {
                        float f4;
                        float f5 = n;
                        float f6 = n2;
                        this.mMinZoomScale = f4 = f5 / f6;
                        this.mMinZoomScaleFixed = false;
                        if (bl) {
                            WebSettings webSettings = this.getSettings();
                            boolean bl2 = webSettings.getUseWideViewPort() && webSettings.getLoadWithOverviewMode();
                            this.mInZoomOverview = bl2;
                        }
                        break block6;
                    } else {
                        float f7;
                        this.mMinZoomScale = f7 = restoreState.mDefaultScale;
                        this.mMinZoomScaleFixed = true;
                    }
                    break block6;
                }
                this.mMinZoomScale = f3 = DEFAULT_MIN_ZOOM_SCALE;
                this.mMinZoomScaleFixed = false;
                break block6;
            }
            this.mMinZoomScale = f2 = restoreState.mMinScale;
            this.mMinZoomScaleFixed = true;
        }
        if (restoreState.mMaxScale == 0.0f) {
            float f8;
            this.mMaxZoomScale = f8 = DEFAULT_MAX_ZOOM_SCALE;
            return;
        }
        this.mMaxZoomScale = f = restoreState.mMaxScale;
    }

    private void viewInvalidate() {
        this.invalidate();
    }

    private void viewInvalidate(int n, int n2, int n3, int n4) {
        float f = this.mActualScale;
        int n5 = this.getTitleHeight();
        int n6 = (int)Math.floor((float)n * f);
        int n7 = (int)Math.floor((float)n2 * f) + n5;
        int n8 = (int)Math.ceil((float)n3 * f);
        int n9 = (int)Math.ceil((float)n4 * f) + n5;
        this.invalidate(n6, n7, n8, n9);
    }

    private void viewInvalidateDelayed(long l, int n, int n2, int n3, int n4) {
        float f = this.mActualScale;
        int n5 = this.getTitleHeight();
        int n6 = (int)Math.floor((float)n * f);
        int n7 = (int)Math.floor((float)n2 * f) + n5;
        int n8 = (int)Math.ceil((float)n3 * f);
        int n9 = (int)Math.ceil((float)n4 * f) + n5;
        WebView webView = this;
        long l2 = l;
        webView.postInvalidateDelayed(l2, n6, n7, n8, n9);
    }

    private int viewToContentDimension(int n) {
        float f = n;
        float f2 = this.mInvActualScale;
        return Math.round(f * f2);
    }

    private float viewToContentXf(int n) {
        float f = n;
        float f2 = this.mInvActualScale;
        return f * f2;
    }

    private float viewToContentYf(int n) {
        int n2 = this.getTitleHeight();
        float f = n - n2;
        float f2 = this.mInvActualScale;
        return f * f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean zoomWithPreview(float f, boolean bl) {
        float f2;
        float f3;
        float f4;
        long l;
        float f5;
        int n;
        int n2;
        float f6 = this.mActualScale;
        this.mInitialScrollX = n2 = this.mScrollX;
        this.mInitialScrollY = n = this.mScrollY;
        float f7 = this.mDefaultScale;
        float f8 = Math.abs(f - f7);
        if (f8 < (f5 = MINIMUM_SCALE_INCREMENT)) {
            f = this.mDefaultScale;
        }
        this.setNewZoomScale(f, bl, false);
        float f9 = this.mActualScale;
        if (f6 == f9) return false;
        this.mZoomStart = l = SystemClock.uptimeMillis();
        this.mInvInitialZoomScale = f4 = 1.0f / f6;
        float f10 = this.mActualScale;
        this.mInvFinalZoomScale = f3 = 1.0f / f10;
        this.mZoomScale = f2 = this.mActualScale;
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        this.invalidate();
        return true;
    }

    public void addJavascriptInterface(Object object, String string2) {
        WebViewCore.JSInterfaceData jSInterfaceData = new WebViewCore.JSInterfaceData();
        jSInterfaceData.mObject = object;
        jSInterfaceData.mInterfaceName = string2;
        this.mWebViewCore.sendMessage(138, jSInterfaceData);
    }

    public void addPackageName(String string2) {
        this.mWebViewCore.sendMessage(185, string2);
    }

    public void addPackageNames(Set<String> set) {
        this.mWebViewCore.sendMessage(184, set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGoBack() {
        WebBackForwardList webBackForwardList = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (webBackForwardList.getClearPending()) {
                return false;
            }
            if (webBackForwardList.getCurrentIndex() <= 0) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGoBackOrForward(int n) {
        WebBackForwardList webBackForwardList = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (webBackForwardList.getClearPending()) {
                return false;
            }
            int n2 = webBackForwardList.getCurrentIndex() + n;
            if (n2 < 0) return false;
            int n3 = webBackForwardList.getSize();
            if (n2 >= n3) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGoForward() {
        WebBackForwardList webBackForwardList = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            int n;
            if (webBackForwardList.getClearPending()) {
                return false;
            }
            int n2 = webBackForwardList.getCurrentIndex();
            if (n2 >= (n = webBackForwardList.getSize() - 1)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Picture capturePicture() {
        if (this.mWebViewCore != null) return this.mWebViewCore.copyContentPicture();
        return null;
    }

    void centerKeyPressOnTextField() {
        WebViewCore webViewCore = this.mWebViewCore;
        int n = this.nativeCursorFramePointer();
        int n2 = this.nativeCursorNodePointer();
        webViewCore.sendMessage(118, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void clearCache(boolean bl) {
        WebViewCore webViewCore = this.mWebViewCore;
        int n = bl ? 1 : 0;
        webViewCore.sendMessage(111, n, 0);
    }

    public void clearFormData() {
        if (!this.inEditingMode()) {
            return;
        }
        this.mWebTextView.setAdapterCustom(null);
    }

    public void clearHistory() {
        this.mCallbackProxy.getBackForwardList().setClearPending();
        this.mWebViewCore.sendMessage(112);
    }

    public void clearMatches() {
        this.mLastFind = "";
        if (this.mNativeClass == 0) {
            return;
        }
        this.nativeSetFindIsEmpty();
        this.invalidate();
    }

    public void clearSslPreferences() {
        this.mWebViewCore.sendMessage(150);
    }

    public void clearView() {
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        this.mWebViewCore.sendMessage(134);
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return Math.max(this.mScrollX, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int computeHorizontalScrollRange() {
        int n = this.computeRealHorizontalScrollRange();
        int n2 = this.mScrollX;
        int n3 = this.computeMaxScrollX();
        if (n2 < 0) {
            n -= n2;
            return n;
        }
        if (n2 <= n3) return n;
        int n4 = n2 - n3;
        return n += n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void computeScroll() {
        if (!this.mScroller.computeScrollOffset()) {
            super.computeScroll();
            return;
        }
        int n = this.mScrollX;
        int n2 = this.mScrollY;
        int n3 = this.mScroller.getCurrX();
        int n4 = this.mScroller.getCurrY();
        this.invalidate();
        if (n == n3 || n2 != n4) {
            int n5 = this.computeMaxScrollX();
            int n6 = this.computeMaxScrollY();
            int n7 = n3 - n;
            int n8 = n4 - n2;
            int n9 = this.mOverflingDistance;
            int n10 = this.mOverflingDistance;
            boolean bl = this.overScrollBy(n7, n8, n, n2, n5, n6, n9, n10, false);
            if (this.mEdgeGlowTop != null) {
                if (n6 > 0 || this.getOverScrollMode() == 0) {
                    if (n4 < 0 && n2 >= 0) {
                        EdgeGlow edgeGlow = this.mEdgeGlowTop;
                        int n11 = (int)this.mScroller.getCurrVelocity();
                        edgeGlow.onAbsorb(n11);
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                    } else if (n4 > n6 && n2 <= n6) {
                        EdgeGlow edgeGlow = this.mEdgeGlowBottom;
                        int n12 = (int)this.mScroller.getCurrVelocity();
                        edgeGlow.onAbsorb(n12);
                        if (!this.mEdgeGlowTop.isFinished()) {
                            this.mEdgeGlowTop.onRelease();
                        }
                    }
                }
                if (n5 > 0) {
                    if (n3 < 0 && n >= 0) {
                        EdgeGlow edgeGlow = this.mEdgeGlowLeft;
                        int n13 = (int)this.mScroller.getCurrVelocity();
                        edgeGlow.onAbsorb(n13);
                        if (!this.mEdgeGlowRight.isFinished()) {
                            this.mEdgeGlowRight.onRelease();
                        }
                    } else if (n3 > n5 && n <= n5) {
                        EdgeGlow edgeGlow = this.mEdgeGlowRight;
                        int n14 = (int)this.mScroller.getCurrVelocity();
                        edgeGlow.onAbsorb(n14);
                        if (!this.mEdgeGlowLeft.isFinished()) {
                            this.mEdgeGlowLeft.onRelease();
                        }
                    }
                }
            }
        }
        if (!this.mScroller.isFinished()) {
            return;
        }
        boolean bl = this.mPrivateHandler.sendEmptyMessage(7);
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return this.getViewHeight();
    }

    @Override
    protected int computeVerticalScrollOffset() {
        int n = this.mScrollY;
        int n2 = this.getTitleHeight();
        return Math.max(n - n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int computeVerticalScrollRange() {
        int n = this.computeRealVerticalScrollRange();
        int n2 = this.mScrollY;
        int n3 = this.computeMaxScrollY();
        if (n2 < 0) {
            n -= n2;
            return n;
        }
        if (n2 <= n3) return n;
        int n4 = n2 - n3;
        return n += n4;
    }

    int contentToViewDimension(int n) {
        float f = n;
        float f2 = this.mActualScale;
        return Math.round(f * f2);
    }

    int contentToViewX(int n) {
        return this.contentToViewDimension(n);
    }

    int contentToViewY(int n) {
        int n2 = this.contentToViewDimension(n);
        int n3 = this.getTitleHeight();
        return n2 + n3;
    }

    public WebBackForwardList copyBackForwardList() {
        return this.mCallbackProxy.getBackForwardList().clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copySelection() {
        boolean bl = false;
        String string2 = this.getSelection();
        if (string2 != "") {
            Toast.makeText(this.mContext, 17040065, 0).show();
            bl = true;
            try {
                IClipboard.Stub.asInterface(ServiceManager.getService("clipboard")).setClipboardText(string2);
            }
            catch (RemoteException remoteException) {
                int n = Log.e(LOGTAG, "Clipboard failed", remoteException);
            }
        }
        this.invalidate();
        return bl;
    }

    WebViewCore.CursorData cursorData() {
        int n;
        int n2;
        int n3;
        int n4;
        WebViewCore.CursorData cursorData = new WebViewCore.CursorData();
        cursorData.mMoveGeneration = n4 = this.nativeMoveGeneration();
        cursorData.mFrame = n3 = this.nativeCursorFramePointer();
        Point point = this.nativeCursorPosition();
        cursorData.mX = n2 = point.x;
        cursorData.mY = n = point.y;
        return cursorData;
    }

    public void debugDump() {
        this.nativeDebugDump();
        this.mWebViewCore.sendMessage(172);
    }

    void deleteSelection(int n, int n2) {
        int n3;
        this.mTextGeneration = n3 = this.mTextGeneration + 1;
        WebViewCore.TextSelectionData textSelectionData = new WebViewCore.TextSelectionData(n, n2);
        WebViewCore webViewCore = this.mWebViewCore;
        int n4 = this.mTextGeneration;
        webViewCore.sendMessage(122, n4, 0, textSelectionData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        Object var1_1 = null;
        this.clearHelpers();
        if (this.mWebViewCore != null) {
            this.mCallbackProxy.setWebViewClient(null);
            this.mCallbackProxy.setWebChromeClient(null);
            synchronized (this) {
                WebViewCore webViewCore = this.mWebViewCore;
                this.mWebViewCore = null;
                webViewCore.destroy();
            }
            this.mPrivateHandler.removeCallbacksAndMessages(null);
            this.mCallbackProxy.removeCallbacksAndMessages(null);
            CallbackProxy callbackProxy = this.mCallbackProxy;
            synchronized (callbackProxy) {
                this.mCallbackProxy.notify();
            }
        }
        if (this.mNativeClass == 0) {
            return;
        }
        this.nativeDestroy();
        this.mNativeClass = 0;
    }

    void dismissZoomControl() {
        if (this.mWebViewCore == null) {
            if (this.mZoomButtonsController != null) {
                this.mZoomButtonsController.setVisible(false);
            }
            if (this.mZoomControls == null) {
                return;
            }
            this.mZoomControls.hide();
            return;
        }
        if (this.getSettings().getBuiltInZoomControls()) {
            if (this.mZoomButtonsController == null) {
                return;
            }
            this.mZoomButtonsController.setVisible(false);
            return;
        }
        if (this.mZoomControlRunnable != null) {
            Handler handler = this.mPrivateHandler;
            Runnable runnable = this.mZoomControlRunnable;
            handler.removeCallbacks(runnable);
        }
        if (this.mZoomControls == null) {
            return;
        }
        this.mZoomControls.hide();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = true;
        if (!(this.inEditingMode() || this.mNativeClass != 0 && this.nativeFocusIsPlugin())) {
            if (keyEvent.getAction() == 0) {
                this.mGotKeyDown = true;
            } else {
                if (!this.mGotKeyDown) {
                    bl = false;
                }
                this.mGotKeyDown = false;
            }
        }
        if (!bl) return false;
        return super.dispatchKeyEvent(keyEvent);
    }

    public void documentAsText(Message message) {
        this.mWebViewCore.sendMessage(161, message);
    }

    public void documentHasImages(Message message) {
        if (message == null) {
            return;
        }
        this.mWebViewCore.sendMessage(120, message);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop == null) {
            return;
        }
        if (!this.drawEdgeGlows(canvas)) {
            return;
        }
        this.invalidate();
    }

    @Override
    protected boolean drawChild(Canvas canvas, View view, long l) {
        View view2 = this.mTitleBar;
        if (view == view2) {
            View view3 = this.mTitleBar;
            int n = this.mScrollX;
            int n2 = this.mTitleBar.getLeft();
            int n3 = n - n2;
            view3.offsetLeftAndRight(n3);
        }
        return super.drawChild(canvas, view, l);
    }

    boolean drawHistory() {
        return this.mDrawHistory;
    }

    public void drawPage(Canvas canvas) {
        this.mWebViewCore.drawContentPicture(canvas, 0, false, false);
    }

    public void dumpDisplayTree() {
        String string2 = this.getUrl();
        this.nativeDumpDisplayTree(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dumpDomTree(boolean bl) {
        WebViewCore webViewCore = this.mWebViewCore;
        int n = bl ? 1 : 0;
        webViewCore.sendMessage(170, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dumpRenderTree(boolean bl) {
        WebViewCore webViewCore = this.mWebViewCore;
        int n = bl ? 1 : 0;
        webViewCore.sendMessage(171, n, 0);
    }

    public void dumpV8Counters() {
        this.mWebViewCore.sendMessage(173);
    }

    public void emulateShiftHeld() {
        this.setUpSelect();
    }

    public void externalRepresentation(Message message) {
        this.mWebViewCore.sendMessage(160, message);
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int findAll(String string2) {
        int n;
        if (this.mNativeClass == 0) {
            return 0;
        }
        if (string2 != null) {
            String string3 = string2.toLowerCase();
            String string4 = string2.toUpperCase();
            n = this.nativeFindAll(string3, string4);
        } else {
            n = 0;
        }
        this.invalidate();
        this.mLastFind = string2;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findIndex() {
        if (this.mNativeClass != 0) return this.nativeFindIndex();
        return -1;
    }

    public void findNext(boolean bl) {
        if (this.mNativeClass == 0) {
            return;
        }
        this.nativeFindNext(bl);
    }

    public void flingScroll(int n, int n2) {
        OverScroller overScroller = this.mScroller;
        int n3 = this.mScrollX;
        int n4 = this.mScrollY;
        int n5 = this.computeMaxScrollX();
        int n6 = this.computeMaxScrollY();
        int n7 = this.mOverflingDistance;
        int n8 = this.mOverflingDistance;
        int n9 = n;
        int n10 = n2;
        int n11 = 0;
        overScroller.fling(n3, n4, n9, n10, 0, n5, n11, n6, n7, n8);
        this.invalidate();
    }

    public void freeMemory() {
        this.mWebViewCore.sendMessage(145);
    }

    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    public int getContentWidth() {
        return this.mContentWidth;
    }

    public DragTracker getDragTracker() {
        return this.mDragTracker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap getFavicon() {
        WebHistoryItem webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        if (webHistoryItem == null) return null;
        return webHistoryItem.getFavicon();
    }

    /*
     * Enabled aggressive block sorting
     */
    public HitTestResult getHitTestResult() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        String string2;
        int n9;
        if (this.mNativeClass == 0) {
            return null;
        }
        HitTestResult hitTestResult = new HitTestResult();
        if (this.nativeHasCursorNode()) {
            if (this.nativeCursorIsTextInput()) {
                hitTestResult.setType(9);
            } else {
                String string3 = this.nativeCursorText();
                if (string3 != null) {
                    if (string3.startsWith(SCHEME_TEL)) {
                        hitTestResult.setType(2);
                        int n10 = SCHEME_TEL.length();
                        String string4 = string3.substring(n10);
                        hitTestResult.setExtra(string4);
                    } else if (string3.startsWith(SCHEME_MAILTO)) {
                        hitTestResult.setType(4);
                        int n11 = SCHEME_MAILTO.length();
                        String string5 = string3.substring(n11);
                        hitTestResult.setExtra(string5);
                    } else if (string3.startsWith(SCHEME_GEO)) {
                        hitTestResult.setType(3);
                        int n12 = SCHEME_GEO.length();
                        String string6 = URLDecoder.decode(string3.substring(n12));
                        hitTestResult.setExtra(string6);
                    } else if (this.nativeCursorIsAnchor()) {
                        hitTestResult.setType(7);
                        hitTestResult.setExtra(string3);
                    }
                }
            }
        }
        if ((n9 = hitTestResult.getType()) != 0) {
            if (n9 != 7) return hitTestResult;
        }
        if ((string2 = this.nativeImageURI(n8 = this.viewToContentX(n7 = (n6 = (int)this.mLastTouchX) + (n5 = this.mScrollX)), n4 = this.viewToContentY(n3 = (n2 = (int)this.mLastTouchY) + (n = this.mScrollY)))) == null) return hitTestResult;
        int n13 = n9 == 0 ? 5 : 8;
        hitTestResult.setType(n13);
        hitTestResult.setExtra(string2);
        return hitTestResult;
    }

    public String[] getHttpAuthUsernamePassword(String string2, String string3) {
        return this.mDatabase.getHttpAuthUsernamePassword(string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOriginalUrl() {
        WebHistoryItem webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        if (webHistoryItem == null) return null;
        return webHistoryItem.getOriginalUrl();
    }

    public int getProgress() {
        return this.mCallbackProxy.getProgress();
    }

    public float getScale() {
        return this.mActualScale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSelection() {
        if (this.mNativeClass != 0) return this.nativeGetSelection();
        return "";
    }

    public WebSettings getSettings() {
        return this.mWebViewCore.getSettings();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTitle() {
        WebHistoryItem webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        if (webHistoryItem == null) return null;
        return webHistoryItem.getTitle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTouchIconUrl() {
        WebHistoryItem webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        if (webHistoryItem == null) return null;
        return webHistoryItem.getTouchIconUrl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getUrl() {
        WebHistoryItem webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        if (webHistoryItem == null) return null;
        return webHistoryItem.getUrl();
    }

    int getViewHeight() {
        int n = this.getViewHeightWithTitle();
        int n2 = this.getVisibleTitleHeight();
        return n - n2;
    }

    ViewManager getViewManager() {
        return this.mViewManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getViewWidth() {
        if (!this.isVerticalScrollBarEnabled()) return this.getWidth();
        if (this.mOverlayVerticalScrollbar) {
            return this.getWidth();
        }
        int n = this.getWidth();
        int n2 = this.getVerticalScrollbarWidth();
        return n - n2;
    }

    public WebBackForwardListClient getWebBackForwardListClient() {
        return this.mCallbackProxy.getWebBackForwardListClient();
    }

    public WebChromeClient getWebChromeClient() {
        return this.mCallbackProxy.getWebChromeClient();
    }

    public WebViewClient getWebViewClient() {
        return this.mCallbackProxy.getWebViewClient();
    }

    WebViewCore getWebViewCore() {
        synchronized (this) {
            WebViewCore webViewCore = this.mWebViewCore;
            return webViewCore;
        }
    }

    public ZoomButtonsController getZoomButtonsController() {
        if (this.mZoomButtonsController == null) {
            ZoomButtonsController zoomButtonsController;
            ZoomButtonsController zoomButtonsController2 = this.mZoomButtonsController = (zoomButtonsController = new ZoomButtonsController(this));
            ZoomButtonsController.OnZoomListener onZoomListener = this.mZoomListener;
            zoomButtonsController2.setOnZoomListener(onZoomListener);
            ViewGroup.LayoutParams layoutParams = this.mZoomButtonsController.getZoomControls().getLayoutParams();
            if (layoutParams instanceof FrameLayout.LayoutParams) {
                ((FrameLayout.LayoutParams)layoutParams).gravity = 5;
            }
        }
        return this.mZoomButtonsController;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public View getZoomControls() {
        Runnable runnable;
        ExtendedZoomControls extendedZoomControls;
        if (!this.getSettings().supportZoom()) {
            int n = Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return null;
        }
        if (this.mZoomControls != null) return this.mZoomControls;
        this.mZoomControls = extendedZoomControls = this.createZoomControls();
        this.mZoomControls.setVisibility(0);
        this.mZoomControlRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                if (!WebView.this.mZoomControls.hasFocus()) {
                    WebView.this.mZoomControls.hide();
                    return;
                }
                Handler handler = WebView.this.mPrivateHandler;
                Runnable runnable = WebView.this.mZoomControlRunnable;
                handler.removeCallbacks(runnable);
                Handler handler2 = WebView.this.mPrivateHandler;
                Runnable runnable2 = WebView.this.mZoomControlRunnable;
                long l = ZOOM_CONTROLS_TIMEOUT;
                boolean bl = handler2.postDelayed(runnable2, l);
            }
        };
        return this.mZoomControls;
    }

    public void goBack() {
        this.goBackOrForward(-1);
    }

    public void goBackOrForward(int n) {
        this.goBackOrForward(n, false);
    }

    public void goForward() {
        this.goBackOrForward(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean inAnimateZoom() {
        if (this.mZoomScale == 0.0f) return false;
        return true;
    }

    void initiateTextFieldDrag(float f, float f2, long l) {
        VelocityTracker velocityTracker;
        float f3;
        float f4;
        if (!this.inEditingMode()) {
            return;
        }
        int n = this.mWebTextView.getLeft();
        int n2 = this.mScrollX;
        this.mLastTouchX = f4 = (float)(n - n2) + f;
        int n3 = this.mWebTextView.getTop();
        int n4 = this.mScrollY;
        this.mLastTouchY = f3 = (float)(n3 - n4) + f2;
        this.mLastTouchTime = l;
        if (!this.mScroller.isFinished()) {
            this.abortAnimation();
            this.mPrivateHandler.removeMessages(7);
        }
        this.mSnapScrollMode = 0;
        this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
        this.mTouchMode = 2;
    }

    public void invokeZoomPicker() {
        if (!this.getSettings().supportZoom()) {
            int n = Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return;
        }
        this.clearTextEntry(false);
        if (this.getSettings().getBuiltInZoomControls()) {
            this.getZoomButtonsController().setVisible(true);
            return;
        }
        Handler handler = this.mPrivateHandler;
        Runnable runnable = this.mZoomControlRunnable;
        handler.removeCallbacks(runnable);
        Handler handler2 = this.mPrivateHandler;
        Runnable runnable2 = this.mZoomControlRunnable;
        long l = ZOOM_CONTROLS_TIMEOUT;
        boolean bl = handler2.postDelayed(runnable2, l);
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void loadData(String string2, String string3, String string4) {
        String string5 = "data:" + string3 + ";" + string4 + "," + string2;
        this.loadUrl(string5);
    }

    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (string2 != null && string2.toLowerCase().startsWith("data:")) {
            this.loadData(string3, string4, string5);
            return;
        }
        this.switchOutDrawHistory();
        WebViewCore.BaseUrlData baseUrlData = new WebViewCore.BaseUrlData();
        baseUrlData.mBaseUrl = string2;
        baseUrlData.mData = string3;
        baseUrlData.mMimeType = string4;
        baseUrlData.mEncoding = string5;
        baseUrlData.mHistoryUrl = string6;
        this.mWebViewCore.sendMessage(139, baseUrlData);
        this.clearHelpers();
    }

    public void loadUrl(String string2) {
        if (string2 == null) {
            return;
        }
        this.loadUrl(string2, null);
    }

    public void loadUrl(String string2, Map<String, String> map) {
        this.switchOutDrawHistory();
        WebViewCore.GetUrlData getUrlData = new WebViewCore.GetUrlData();
        getUrlData.mUrl = string2;
        getUrlData.mExtraHeaders = map;
        this.mWebViewCore.sendMessage(100, getUrlData);
        this.clearHelpers();
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveSelection(float f, float f2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.mNativeClass == 0) {
            return;
        }
        int n9 = this.getViewWidth();
        int n10 = this.getViewHeight();
        this.mSelectX = n8 = (int)((float)this.mSelectX + f);
        this.mSelectY = n7 = (int)((float)this.mSelectY + f2);
        int n11 = this.mScrollX;
        int n12 = n9 + n11;
        int n13 = this.mScrollY;
        int n14 = n10 + n13;
        int n15 = this.mScrollX - 16;
        int n16 = this.mSelectX;
        int n17 = Math.max(n15, n16);
        this.mSelectX = n6 = Math.min(n12, n17);
        int n18 = this.mScrollY - 16;
        int n19 = this.mSelectY;
        int n20 = Math.max(n18, n19);
        this.mSelectY = n5 = Math.min(n14, n20);
        int n21 = this.mSelectX;
        int n22 = this.viewToContentX(n21);
        int n23 = this.mSelectY;
        int n24 = this.viewToContentY(n23);
        this.nativeMoveSelection(n22, n24);
        int n25 = this.mSelectX;
        int n26 = this.mScrollX;
        int n27 = n25 < n26 ? 65520 : ((n4 = this.mSelectX) > (n3 = n12 - 16) ? 16 : 0);
        int n28 = this.mSelectY;
        int n29 = this.mScrollY;
        int n30 = n28 < n29 ? 65520 : ((n2 = this.mSelectY) > (n = n14 - 16) ? 16 : 0);
        boolean bl = this.pinScrollBy(n27, n30, true, 0);
        int n31 = this.mSelectX;
        int n32 = this.mSelectY;
        int n33 = this.mSelectX + 1;
        int n34 = this.mSelectY + 1;
        Rect rect = new Rect(n31, n32, n33, n34);
        boolean bl2 = this.requestRectangleOnScreen(rect);
        this.invalidate();
    }

    native void nativeClearCursor();

    native boolean nativeCursorMatchesFocus();

    native int nativeFocusCandidateFramePointer();

    native boolean nativeFocusCandidateHasNextTextfield();

    native boolean nativeFocusCandidateIsPassword();

    native int nativeFocusCandidateMaxLength();

    native String nativeFocusCandidateName();

    native int nativeFocusCandidatePointer();

    native int nativeFocusNodePointer();

    native boolean nativeMoveCursorToNextTextInput();

    public void notifyFindDialogDismissed() {
        if (this.mWebViewCore == null) {
            return;
        }
        this.clearMatches();
        this.setFindIsUp(false);
        int n = this.mContentWidth;
        int n2 = this.mContentHeight;
        int n3 = this.mFindHeight;
        int n4 = n2 - n3;
        this.recordNewContentSize(n, n4, false);
        int n5 = this.mScrollX;
        int n6 = this.mScrollY;
        boolean bl = this.pinScrollTo(n5, n6, false, 0);
        this.invalidate();
    }

    public void notifySelectDialogDismissed() {
        this.mSelectingText = false;
        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.hasWindowFocus()) {
            return;
        }
        this.setActive(true);
    }

    @Override
    @Deprecated
    public void onChildViewAdded(View view, View view2) {
    }

    @Override
    @Deprecated
    public void onChildViewRemoved(View view, View view2) {
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        int n;
        InputConnection inputConnection = super.onCreateInputConnection(editorInfo);
        editorInfo.imeOptions = n = editorInfo.imeOptions | Integer.MIN_VALUE;
        return inputConnection;
    }

    @Override
    protected void onDetachedFromWindow() {
        this.clearHelpers();
        this.dismissZoomControl();
        if (this.hasWindowFocus()) {
            this.setActive(false);
        }
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mNativeClass == 0) {
            return;
        }
        int n = this.mContentWidth;
        int n2 = this.mContentHeight;
        if ((n | n2) == 0 && this.mHistoryPicture == null) {
            int n3 = this.mBackgroundColor;
            canvas.drawColor(n3);
            return;
        }
        int n4 = canvas.save();
        if (this.mInOverScrollMode && !this.getSettings().getUseWebViewBackgroundForOverscrollBackground()) {
            if (mOverScrollBackground == null) {
                mOverScrollBackground = new Paint();
                Bitmap bitmap = BitmapFactory.decodeResource(this.mContext.getResources(), 17302236);
                Paint paint = mOverScrollBackground;
                Shader.TileMode tileMode = Shader.TileMode.REPEAT;
                Shader.TileMode tileMode2 = Shader.TileMode.REPEAT;
                BitmapShader bitmapShader = new BitmapShader(bitmap, tileMode, tileMode2);
                Shader shader = paint.setShader(bitmapShader);
                Paint paint2 = mOverScrollBorder = new Paint();
                Paint.Style style2 = Paint.Style.STROKE;
                paint2.setStyle(style2);
                mOverScrollBorder.setStrokeWidth(0.0f);
                mOverScrollBorder.setColor(-4473925);
            }
            int n5 = this.computeRealHorizontalScrollRange();
            int n6 = this.computeRealVerticalScrollRange();
            int n7 = 0 + n6;
            int n8 = canvas.save();
            float f = this.mScrollX;
            float f2 = this.mScrollY;
            canvas.translate(f, f2);
            float f3 = -this.mScrollX;
            int n9 = this.mScrollY;
            float f4 = 0 - n9;
            int n10 = this.mScrollX;
            float f5 = n5 - n10;
            int n11 = this.mScrollY;
            float f6 = n7 - n11;
            Region.Op op = Region.Op.DIFFERENCE;
            boolean bl = canvas.clipRect(f3, f4, f5, f6, op);
            Paint paint = mOverScrollBackground;
            canvas.drawPaint(paint);
            canvas.restore();
            float f7 = 0 - 1;
            float f8 = n5;
            float f9 = n7;
            Paint paint3 = mOverScrollBorder;
            canvas.drawRect(-1.0f, f7, f8, f9, paint3);
            boolean bl2 = canvas.clipRect(0, 0, n5, n7);
        }
        if (this.mTitleBar != null) {
            float f = this.mTitleBar.getHeight();
            canvas.translate(0.0f, f);
        }
        if (this.mDragTrackerHandler == null) {
            this.drawContent(canvas);
        } else {
            if (!this.mDragTrackerHandler.draw(canvas)) {
                this.drawContent(canvas);
            }
            if (this.mDragTrackerHandler.isFinished()) {
                this.mDragTrackerHandler = null;
            }
        }
        canvas.restoreToCount(n4);
        int n12 = this.getVisibleTitleHeight();
        if (this.mTitleBar != null && n12 == 0) {
            float f = this.getContext().getResources().getDisplayMetrics().density;
            int n13 = (int)(5.0f * f);
            Drawable drawable2 = this.mTitleShadow;
            int n14 = this.mScrollX;
            int n15 = this.mScrollY;
            int n16 = this.mScrollX;
            int n17 = this.getWidth();
            int n18 = n16 + n17;
            int n19 = this.mScrollY + n13;
            drawable2.setBounds(n14, n15, n18, n19);
            this.mTitleShadow.draw(canvas);
        }
        if (this.inEditingMode()) {
            this.mWebTextView.onDrawSubstitute();
        }
        this.mWebViewCore.signalRepaintDone();
    }

    @Override
    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable drawable2, int n, int n2, int n3, int n4) {
        if (this.mScrollY < 0) {
            int n5 = this.mScrollY;
            n2 -= n5;
        }
        int n6 = this.getVisibleTitleHeight() + n2;
        drawable2.setBounds(n, n6, n3, n4);
        drawable2.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        block5: {
            block4: {
                if (!bl) break block4;
                if (this.hasWindowFocus()) {
                    this.mDrawCursorRing = true;
                    if (this.mNativeClass != 0) {
                        this.nativeRecordButtons(true, false, true);
                    }
                }
                break block5;
            }
            if (!this.inEditingMode()) {
                this.mDrawCursorRing = false;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(false, false, true);
                }
                this.setFocusControllerInactive();
            }
            this.mGotKeyDown = false;
        }
        super.onFocusChanged(bl, n, rect);
    }

    @Override
    @Deprecated
    public void onGlobalFocusChanged(View view, View view2) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onKeyDown(int var1_1, KeyEvent var2_2) {
        block32: {
            block28: {
                block29: {
                    block31: {
                        block30: {
                            block21: {
                                block27: {
                                    block22: {
                                        block26: {
                                            block24: {
                                                block25: {
                                                    block23: {
                                                        block17: {
                                                            block20: {
                                                                block19: {
                                                                    block18: {
                                                                        if (this.mNativeClass == 0) {
                                                                            var3_3 = false;
lbl3:
                                                                            // 13 sources

                                                                            return var3_3;
                                                                        }
                                                                        if (!var2_2.isSystem() && !this.mCallbackProxy.uiOverrideKeyEvent(var2_2)) break block18;
                                                                        var3_3 = false;
                                                                        ** GOTO lbl3
                                                                    }
                                                                    if (var1_1 != 59 && var1_1 != 60) break block19;
                                                                    if (!this.nativeFocusIsPlugin()) break block20;
                                                                    this.mShiftIsPressed = true;
                                                                }
lbl13:
                                                                // 3 sources

                                                                while (var1_1 >= 19 && var1_1 <= 22) {
                                                                    this.switchOutDrawHistory();
                                                                    if (!this.nativeFocusIsPlugin()) break block17;
                                                                    var4_4 = var2_2.getEventTime();
                                                                    this.letPluginHandleNavKey(var1_1, var4_4, true);
                                                                    var3_3 = true;
                                                                    ** GOTO lbl3
                                                                }
                                                                break block21;
                                                            }
                                                            if (this.nativeCursorWantsKeyEvents() || this.mSelectingText) ** GOTO lbl13
                                                            this.setUpSelect();
                                                            ** GOTO lbl13
                                                        }
                                                        if (!this.mSelectingText) break block22;
                                                        if (var1_1 != 21) break block23;
                                                        var6_5 = -1;
lbl29:
                                                        // 3 sources

                                                        while (var1_1 == 19) {
                                                            var7_6 = -1;
lbl31:
                                                            // 3 sources

                                                            while (true) {
                                                                var8_7 = var2_2.getRepeatCount() + 1;
                                                                var9_8 = var6_5 * var8_7;
                                                                var10_9 = var7_6 * var8_7;
                                                                this.moveSelection(var9_8, var10_9);
                                                                var3_3 = true;
                                                                ** GOTO lbl3
                                                                break;
                                                            }
                                                        }
                                                        break block24;
                                                    }
                                                    if (var1_1 != 22) break block25;
                                                    var6_5 = 1;
                                                    ** GOTO lbl29
                                                }
                                                var6_5 = 0;
                                                ** GOTO lbl29
                                            }
                                            if (var1_1 != 20) break block26;
                                            var7_6 = 1;
                                            ** GOTO lbl31
                                        }
                                        var7_6 = 0;
                                        ** while (true)
                                    }
                                    var13_11 = this;
                                    var14_12 = var1_1;
                                    var11_10 = var2_2.getEventTime();
                                    if (!var13_11.navHandledKey(var14_12, 1, false, var11_10)) break block27;
                                    var15_13 = this.keyCodeToSoundsEffect(var1_1);
                                    this.playSoundEffect(var15_13);
                                    var3_3 = true;
                                    ** GOTO lbl3
                                }
                                var3_3 = false;
                                ** GOTO lbl3
                            }
                            if (var1_1 != 23) break block28;
                            this.switchOutDrawHistory();
                            if (var2_2.getRepeatCount() != 0) break block29;
                            if (!this.mSelectingText) break block30;
                            var3_3 = true;
                            ** GOTO lbl3
                        }
                        this.mGotCenterDown = true;
                        var16_14 = this.mPrivateHandler;
                        var17_15 = this.mPrivateHandler.obtainMessage(114);
                        var18_16 = var16_14.sendMessageDelayed(var17_15, 1000L);
                        if (!this.hasFocus() || !this.hasWindowFocus()) break block31;
                        var19_17 = true;
lbl79:
                        // 2 sources

                        while (true) {
                            this.nativeRecordButtons(var19_17, true, true);
                            var3_3 = true;
                            ** GOTO lbl3
                            break;
                        }
                    }
                    var19_17 = false;
                    ** while (true)
                }
                var3_3 = false;
                ** GOTO lbl3
            }
            if (var1_1 != 59 && var1_1 != 60) {
                this.selectionDone();
                this.mShiftIsPressed = false;
            }
            if (!this.getSettings().getNavDump()) ** GOTO lbl-1000
            switch (var1_1) lbl-1000:
            // 4 sources

            {
                default: lbl-1000:
                // 2 sources

                {
                    if (!this.nativeCursorIsTextInput()) break;
                    var20_18 = this.mWebViewCore;
                    var21_19 = this.nativeCursorFramePointer();
                    var22_20 = this.nativeCursorNodePointer();
                    var20_18.sendMessage(118, var21_19, var22_20);
                    this.rebuildWebTextView();
                    if (!this.inEditingMode()) break block32;
                    this.mWebTextView.setDefaultSelection();
                    var3_3 = this.mWebTextView.dispatchKeyEvent(var2_2);
                    ** GOTO lbl3
                }
                case 11: {
                    this.dumpDisplayTree();
                    ** GOTO lbl-1000
                }
                case 12: 
                case 13: {
                    if (var1_1 != 12) ** GOTO lbl115
                    var23_21 = true;
lbl112:
                    // 2 sources

                    while (true) {
                        this.dumpDomTree(var23_21);
                        ** GOTO lbl-1000
                        break;
                    }
lbl115:
                    // 1 sources

                    var23_21 = false;
                    ** continue;
                }
                case 14: 
                case 15: {
                    if (var1_1 != 14) ** GOTO lbl123
                    var23_22 = true;
lbl120:
                    // 2 sources

                    while (true) {
                        this.dumpRenderTree(var23_22);
                        ** GOTO lbl-1000
                        break;
                    }
lbl123:
                    // 1 sources

                    var23_22 = false;
                    ** continue;
                }
                case 16: {
                    this.nativeInstrumentReport();
                    var3_3 = true;
                    ** GOTO lbl3
                }
            }
            if (!this.nativeHasFocusNode()) break block32;
            this.rebuildWebTextView();
            if (!this.inEditingMode()) break block32;
            this.mWebTextView.setDefaultSelection();
            var3_3 = this.mWebTextView.dispatchKeyEvent(var2_2);
            ** GOTO lbl3
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(103, var2_2);
        var3_3 = true;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        if (n != 0) return false;
        if (keyEvent.getCharacters() == null) return false;
        this.mWebViewCore.sendMessage(103, keyEvent);
        this.mWebViewCore.sendMessage(104, keyEvent);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (n == 5 && this.nativeHasCursorNode()) {
            String string2 = this.nativeCursorText();
            if (!this.nativeCursorIsTextInput() && string2 != null && string2.startsWith(SCHEME_TEL)) {
                Uri uri = Uri.parse(string2);
                Intent intent = new Intent("android.intent.action.DIAL", uri);
                this.getContext().startActivity(intent);
                return true;
            }
        }
        if (keyEvent.isSystem()) return false;
        if (this.mCallbackProxy.uiOverrideKeyEvent(keyEvent)) {
            return false;
        }
        if (n == 59 || n == 60) {
            if (this.nativeFocusIsPlugin()) {
                this.mShiftIsPressed = false;
            } else if (this.copySelection()) {
                this.selectionDone();
                return true;
            }
        }
        if (n >= 19 && n <= 22) {
            if (!this.nativeFocusIsPlugin()) return false;
            long l = keyEvent.getEventTime();
            this.letPluginHandleNavKey(n, l, false);
            return true;
        }
        if (n == 23) {
            this.mPrivateHandler.removeMessages(114);
            this.mGotCenterDown = false;
            if (this.mSelectingText) {
                if (this.mExtendSelection) {
                    boolean bl = this.copySelection();
                    this.selectionDone();
                    return true;
                } else {
                    this.mExtendSelection = true;
                    this.nativeSetExtendSelection();
                    this.invalidate();
                }
                return true;
            }
            Rect rect = this.sendOurVisibleRect();
            if (!this.nativeCursorIntersects(rect)) {
                return false;
            }
            WebViewCore.CursorData cursorData = this.cursorData();
            this.mWebViewCore.sendMessage(135, cursorData);
            this.playSoundEffect(0);
            if (this.nativeCursorIsTextInput()) {
                this.rebuildWebTextView();
                this.centerKeyPressOnTextField();
                if (!this.inEditingMode()) return true;
                this.mWebTextView.setDefaultSelection();
                return true;
            }
            this.clearTextEntry(true);
            this.nativeSetFollowedLink(true);
            CallbackProxy callbackProxy = this.mCallbackProxy;
            String string3 = this.nativeCursorText();
            if (callbackProxy.uiOverrideUrlLoading(string3)) return true;
            WebViewCore webViewCore = this.mWebViewCore;
            int n2 = cursorData.mFrame;
            int n3 = this.nativeCursorNodePointer();
            webViewCore.sendMessage(118, n2, n3);
            return true;
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(104, keyEvent);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getMode(n2);
        int n4 = View.MeasureSpec.getSize(n2);
        int n5 = View.MeasureSpec.getMode(n);
        int n6 = View.MeasureSpec.getSize(n);
        int n7 = n4;
        int n8 = n6;
        int n9 = this.mContentHeight;
        int n10 = this.contentToViewDimension(n9);
        int n11 = this.mContentWidth;
        int n12 = this.contentToViewDimension(n11);
        if (n3 != 0x40000000) {
            this.mHeightCanMeasure = true;
            n7 = n10;
            if (n3 == Integer.MIN_VALUE && n7 > n4) {
                n7 = n4;
                this.mHeightCanMeasure = false;
            }
        } else {
            this.mHeightCanMeasure = false;
        }
        if (this.mNativeClass != 0) {
            boolean bl = this.mHeightCanMeasure;
            this.nativeSetHeightCanMeasure(bl);
        }
        if (n5 == 0) {
            this.mWidthCanMeasure = true;
            n8 = n12;
        } else {
            this.mWidthCanMeasure = false;
        }
        synchronized (this) {
            this.setMeasuredDimension(n8, n7);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        this.mInOverScrollMode = false;
        int n3 = this.computeMaxScrollX();
        int n4 = this.computeMaxScrollY();
        if (n3 == 0) {
            n = this.pinLocX(n);
        } else if (n < 0 || n > n3) {
            this.mInOverScrollMode = true;
        }
        if (n2 < 0 || n2 > n4) {
            this.mInOverScrollMode = true;
        }
        int n5 = this.mScrollX;
        int n6 = this.mScrollY;
        super.scrollTo(n, n2);
        if (this.mEdgeGlowTop == null) {
            return;
        }
        int n7 = this.mScrollY;
        if (n6 != n7) {
            return;
        }
        int n8 = this.mScrollX;
        if (n5 != n8) {
            return;
        }
        if (n3 > 0) {
            int n9 = this.mOverscrollDeltaX;
            int n10 = n5 + n9;
            if (n10 < 0) {
                EdgeGlow edgeGlow = this.mEdgeGlowLeft;
                float f = this.mOverscrollDeltaX;
                float f2 = this.getWidth();
                float f3 = f / f2;
                edgeGlow.onPull(f3);
                if (!this.mEdgeGlowRight.isFinished()) {
                    this.mEdgeGlowRight.onRelease();
                }
            } else if (n10 > n3) {
                EdgeGlow edgeGlow = this.mEdgeGlowRight;
                float f = this.mOverscrollDeltaX;
                float f4 = this.getWidth();
                float f5 = f / f4;
                edgeGlow.onPull(f5);
                if (!this.mEdgeGlowLeft.isFinished()) {
                    this.mEdgeGlowLeft.onRelease();
                }
            }
            this.mOverscrollDeltaX = 0;
        }
        if (n4 <= 0 && this.getOverScrollMode() != 0) {
            return;
        }
        int n11 = this.mOverscrollDeltaY;
        int n12 = n6 + n11;
        if (n12 < 0) {
            EdgeGlow edgeGlow = this.mEdgeGlowTop;
            float f = this.mOverscrollDeltaY;
            float f6 = this.getHeight();
            float f7 = f / f6;
            edgeGlow.onPull(f7);
            if (!this.mEdgeGlowBottom.isFinished()) {
                this.mEdgeGlowBottom.onRelease();
            }
        } else if (n12 > n4) {
            EdgeGlow edgeGlow = this.mEdgeGlowBottom;
            float f = this.mOverscrollDeltaY;
            float f8 = this.getHeight();
            float f9 = f / f8;
            edgeGlow.onPull(f9);
            if (!this.mEdgeGlowTop.isFinished()) {
                this.mEdgeGlowTop.onRelease();
            }
        }
        this.mOverscrollDeltaY = 0;
    }

    void onPageFinished(String string2) {
        if (this.mPageThatNeedsToSlideTitleBarOffScreen == null) {
            return;
        }
        if (this.mPageThatNeedsToSlideTitleBarOffScreen.equals(string2) && this.mScrollX == 0 && this.mScrollY == 0) {
            int n = this.mYDistanceToSlideTitleOffScreen;
            boolean bl = this.pinScrollTo(0, n, true, 500);
        }
        this.mPageThatNeedsToSlideTitleBarOffScreen = null;
    }

    public void onPause() {
        if (this.mIsPaused) {
            return;
        }
        this.mIsPaused = true;
        this.mWebViewCore.sendMessage(143);
    }

    public void onResume() {
        if (!this.mIsPaused) {
            return;
        }
        this.mIsPaused = false;
        this.mWebViewCore.sendMessage(144);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean onSavePassword(String string2, String string3, String string4, final Message message) {
        boolean bl = false;
        if (message == null) {
            this.mDatabase.setUsernamePassword(string2, string3, string4);
            return bl;
        }
        final Message message2 = this.mPrivateHandler.obtainMessage(1);
        message2.getData().putString("host", string2);
        message2.getData().putString("username", string3);
        message2.getData().putString("password", string4);
        message2.obj = message;
        final Message message3 = this.mPrivateHandler.obtainMessage(2);
        message3.getData().putString("host", string2);
        message3.getData().putString("username", string3);
        message3.getData().putString("password", string4);
        message3.obj = message;
        Context context = this.getContext();
        AlertDialog.Builder builder = new AlertDialog.Builder(context).setTitle(17040050).setMessage(17040060);
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                message.sendToTarget();
            }
        };
        AlertDialog.Builder builder2 = builder.setPositiveButton(17040061, onClickListener);
        DialogInterface.OnClickListener onClickListener2 = new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                message2.sendToTarget();
            }
        };
        AlertDialog.Builder builder3 = builder2.setNeutralButton(17040062, onClickListener2);
        DialogInterface.OnClickListener onClickListener3 = new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                message3.sendToTarget();
            }
        };
        AlertDialog.Builder builder4 = builder3.setNegativeButton(17040063, onClickListener3);
        DialogInterface.OnCancelListener onCancelListener = new DialogInterface.OnCancelListener(){

            @Override
            public void onCancel(DialogInterface dialogInterface) {
                message.sendToTarget();
            }
        };
        AlertDialog alertDialog = builder4.setOnCancelListener(onCancelListener).show();
        return true;
    }

    @Override
    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        int n5;
        super.onScrollChanged(n, n2, n3, n4);
        if (this.mInOverScrollMode) {
            return;
        }
        Rect rect = this.sendOurVisibleRect();
        int n6 = this.getTitleHeight();
        int n7 = Math.max(n6 - n2, 0);
        if (n7 != (n5 = Math.max(n6 - n4, 0))) {
            return;
        }
        boolean bl = this.sendViewSizeZoom();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        int n5;
        float f;
        float f2;
        int n6;
        super.onSizeChanged(n, n2, n3, n4);
        if (this.mZoomScale == 0.0f) {
            int n7;
            int n8;
            float f3;
            this.mZoomCenterX = 0.0f;
            this.mZoomCenterY = f3 = (float)this.getVisibleTitleHeight();
            int n9 = (int)this.mZoomCenterX;
            int n10 = this.mScrollX;
            int n11 = n9 + n10;
            this.mAnchorX = n8 = this.viewToContentX(n11);
            int n12 = (int)this.mZoomCenterY;
            int n13 = this.mScrollY;
            int n14 = n12 + n13;
            this.mAnchorY = n7 = this.viewToContentY(n14);
        }
        if ((n6 = (int)((f2 = (float)Math.max(n, n2)) / (f = DEFAULT_MIN_ZOOM_SCALE))) > (n5 = sMaxViewportWidth)) {
            sMaxViewportWidth = n6;
        }
        if (!this.mMinZoomScaleFixed) {
            float f4;
            float f5;
            float f6 = 1.0f;
            float f7 = this.getViewWidth();
            int n15 = this.mDrawHistory ? this.mHistoryPicture.getWidth() : this.mZoomOverviewWidth;
            float f8 = n15;
            float f9 = f7 / f8;
            this.mMinZoomScale = f5 = Math.min(f6, f9);
            if (this.mInitialScaleInPercent > 0 && this.mMinZoomScale > (f4 = (float)this.mInitialScaleInPercent / 100.0f)) {
                this.mMinZoomScale = f4;
            }
        }
        this.dismissZoomControl();
        boolean bl = n != n3;
        PostScale postScale = new PostScale(this, bl);
        boolean bl2 = this.post(postScale);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent var1_1) {
        block56: {
            block57: {
                if (this.mNativeClass == 0 || !this.isClickable() && !this.isLongClickable()) {
                    var2_2 = false;
lbl3:
                    // 7 sources

                    return var2_2;
                }
                var3_3 = var1_1.getEventTime();
                if (!this.mSupportMultiTouch || var1_1.getPointerCount() <= 1) ** GOTO lbl61
                if (!this.mAllowPanAndScale && !((var5_4 = this.mMinZoomScale) < (var6_5 = this.mMaxZoomScale))) ** GOTO lbl59
                var7_6 = this.mScaleDetector;
                var8_7 = var1_1;
                var9_8 = var7_6.onTouchEvent(var8_7);
                if (!this.mScaleDetector.isInProgress()) break block56;
                this.mLastTouchTime = var10_9 = var3_3;
                if (this.mAllowPanAndScale) break block57;
                var2_2 = true;
                ** GOTO lbl3
            }
            this.mPrivateHandler.removeMessages(3);
            this.mPrivateHandler.removeMessages(4);
        }
        var12_10 = this.mScaleDetector.getFocusX();
        var13_11 = this.mScaleDetector.getFocusY();
        var14_12 = var1_1.getAction() & 255;
        if (var14_12 != 5) ** GOTO lbl52
        this.cancelTouch();
        var14_12 = 0;
        block13: while (true) {
            if (var12_10 > (var15_13 = (float)(this.getViewWidth() - 1))) {
                var12_10 = this.getViewWidth() - 1;
            }
            if (var13_11 > (var16_14 = (float)(this.getViewHeightWithTitle() - 1))) {
                var13_11 = this.getViewHeightWithTitle() - 1;
            }
            var17_15 = this.mLastTouchX - var12_10;
            var18_16 = this.mLastTouchY - var13_11;
            var19_17 = (int)var17_15;
            var20_18 = (int)var18_16;
            var21_19 = (int)var12_10;
            var22_20 = this.mScrollX;
            var23_21 = var21_19 + var22_20;
            var24_22 = this;
            var25_23 = var23_21;
            var26_24 = var24_22.viewToContentX(var25_23);
            var27_25 = (int)var13_11;
            var28_26 = this.mScrollY;
            var29_27 = var27_25 + var28_26;
            var30_28 = this;
            var31_29 = var29_27;
            var32_30 = var30_28.viewToContentY(var31_29);
            switch (var14_12) lbl-1000:
            // 10 sources

            {
                default: lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var2_2 = true;
                        ** GOTO lbl3
                        break;
                    }
                }
lbl52:
                // 1 sources

                if (var14_12 == 6) {
                    this.mLastTouchX = var33_31 = var12_10;
                    this.mLastTouchY = var34_32 = var13_11;
                    continue block13;
                }
                if (var14_12 != 2 || !(var12_10 < 0.0f) && !(var13_11 < 0.0f)) continue block13;
                var2_2 = true;
                ** GOTO lbl3
lbl59:
                // 1 sources

                var2_2 = true;
                ** GOTO lbl3
lbl61:
                // 1 sources

                var14_12 = var1_1.getAction();
                var12_10 = var1_1.getX();
                var13_11 = var1_1.getY();
                continue block13;
                case 0: {
                    this.mPreventDefault = var35_33 = 0;
                    this.mConfirmMove = var36_34 = false;
                    if (this.mScroller.isFinished()) ** GOTO lbl97
                    this.mScroller.abortAnimation();
                    this.mTouchMode = var37_35 = 2;
                    this.mConfirmMove = var38_36 = true;
                    this.mPrivateHandler.removeMessages(7);
lbl73:
                    // 4 sources

                    while (this.mTouchMode == 1 || this.mTouchMode == 6) {
                        var39_37 = this.mPrivateHandler.sendEmptyMessageDelayed(3, 200L);
                        var40_38 = this.mPrivateHandler.sendEmptyMessageDelayed(4, 1000L);
                        if (!this.inFullScreenMode() && !this.mDeferTouchProcess) ** GOTO lbl146
                        this.mPreventDefault = var41_39 = 3;
lbl78:
                        // 3 sources

                        while (this.shouldForwardTouchEvent()) {
                            var42_40 = new WebViewCore.TouchEventData();
                            var42_40.mAction = var43_43 = var14_12;
                            var42_40.mX = var44_44 = var26_24;
                            var42_40.mY = var45_45 = var32_30;
                            var42_40.mMetaState = var46_46 = var1_1.getMetaState();
                            var42_40.mReprocess = var47_47 = this.mDeferTouchProcess;
                            if (!this.mDeferTouchProcess) ** GOTO lbl151
                            this.mLastTouchX = var48_48 = var12_10;
                            this.mLastTouchY = var49_49 = var13_11;
                            var42_40.mViewX = var50_50 = var12_10;
                            var42_40.mViewY = var51_51 = var13_11;
                            var52_52 = this.mWebViewCore;
                            var53_53 = 141;
                            var54_54 = var42_40;
                            var52_52.sendMessage(var53_53, var54_54);
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl159
                    }
                    ** GOTO lbl159
lbl97:
                    // 1 sources

                    if (!this.mPrivateHandler.hasMessages(5)) ** GOTO lbl118
                    this.mPrivateHandler.removeMessages(5);
                    var55_55 = var19_17 * var19_17;
                    var56_56 = var20_18 * var20_18;
                    var57_57 = var55_55 + var56_56;
                    var58_58 = this.mDoubleTapSlopSquare;
                    if (var57_57 >= var58_58) ** GOTO lbl106
                    this.mTouchMode = var59_59 = 6;
                    ** GOTO lbl73
lbl106:
                    // 1 sources

                    this.doShortPress();
                    this.mTouchMode = var60_60 = 1;
                    if (this.inFullScreenMode() || !this.mForwardTouchEvents) ** GOTO lbl116
                    var61_61 = this;
                    var62_62 = var26_24;
                    var63_63 = var32_30;
                    var64_64 = var61_61.hitFocusedPlugin(var62_62, var63_63);
lbl113:
                    // 2 sources

                    while (true) {
                        this.mDeferTouchProcess = var65_65 = var64_64;
                        ** GOTO lbl73
                        break;
                    }
lbl116:
                    // 1 sources

                    var64_64 = false;
                    ** continue;
lbl118:
                    // 1 sources

                    this.mPreviewZoomOnly = var66_66 = false;
                    this.mTouchMode = var67_67 = 1;
                    if (this.inFullScreenMode() || !this.mForwardTouchEvents) ** GOTO lbl144
                    var68_68 = this;
                    var69_69 = var26_24;
                    var70_70 = var32_30;
                    var71_71 = var68_68.hitFocusedPlugin(var69_69, var70_70);
lbl125:
                    // 2 sources

                    while (true) {
                        this.mDeferTouchProcess = var72_72 = var71_71;
                        this.mWebViewCore.sendMessage(98);
                        if (WebView.mLogEvent && var3_3 - (var73_73 = this.mLastTouchUpTime) < 1000L) {
                            var75_74 = new Object[2];
                            var76_75 = this.mLastTouchUpTime;
                            var78_76 = var3_3 - var76_75;
                            var75_74[0] = var78_76;
                            var79_77 = var3_3;
                            var75_74[1] = var79_77;
                            var80_78 = EventLog.writeEvent(70102, var75_74);
                        }
                        if (this.mSelectingText) {
                            this.mDrawSelectionPointer = var81_79 = false;
                            var82_80 = this;
                            var83_81 = var26_24;
                            var84_82 = var32_30;
                            this.mSelectionStarted = var85_83 = var82_80.nativeStartSelection(var83_81, var84_82);
                            this.invalidate();
                        }
                        ** GOTO lbl73
                        break;
                    }
lbl144:
                    // 1 sources

                    var71_71 = false;
                    ** continue;
lbl146:
                    // 1 sources

                    if (!this.mForwardTouchEvents) ** GOTO lbl149
                    this.mPreventDefault = var86_84 = 1;
                    ** GOTO lbl78
lbl149:
                    // 1 sources

                    this.mPreventDefault = var87_85 = 0;
                    ** GOTO lbl78
lbl151:
                    // 1 sources

                    var88_86 = this.mWebViewCore;
                    var89_87 = 141;
                    var90_88 = var42_40;
                    var88_86.sendMessage(var89_87, var90_88);
                    if (!this.inFullScreenMode()) {
                        var91_89 = this.mPrivateHandler;
                        var92_90 = this.mPrivateHandler.obtainMessage(10, var14_12, 0);
                        var93_91 = var91_89.sendMessageDelayed(var92_90, 200L);
                    }
lbl159:
                    // 5 sources

                    var94_92 = this;
                    var95_94 = var12_10;
                    var96_95 = var13_11;
                    var97_96 = var3_3;
                    var94_92.startTouch(var95_94, var96_95, var97_96);
                    ** GOTO lbl-1000
                }
                case 2: {
                    var94_93 = false;
                    if (!this.mConfirmMove && (var102_99 = (var100_97 = var19_17 * var19_17) + (var101_98 = var20_18 * var20_18)) >= (var103_100 = this.mTouchSlopSquare)) {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        this.mConfirmMove = var104_101 = true;
                        var94_93 = true;
                        if (this.mTouchMode == 6) {
                            this.mTouchMode = var105_102 = 1;
                        }
                    }
                    if (!this.shouldForwardTouchEvent() || !this.mConfirmMove || !var94_93 && (var108_104 = var3_3 - (var106_103 = this.mLastSentTouchTime)) <= (var110_105 = (long)this.mCurrentTouchInterval)) ** GOTO lbl198
                    this.mLastSentTouchTime = var112_106 = var3_3;
                    var42_41 = new WebViewCore.TouchEventData();
                    var42_41.mAction = var114_107 = var14_12;
                    var42_41.mX = var115_108 = var26_24;
                    var42_41.mY = var116_109 = var32_30;
                    var42_41.mMetaState = var117_110 = var1_1.getMetaState();
                    var42_41.mReprocess = var118_111 = this.mDeferTouchProcess;
                    if (!this.mDeferTouchProcess) ** GOTO lbl190
                    var42_41.mViewX = var119_112 = var12_10;
                    var42_41.mViewY = var120_113 = var13_11;
                    var121_114 = this.mWebViewCore;
                    var122_115 = 141;
                    var123_116 = var42_41;
                    var121_114.sendMessage(var122_115, var123_116);
                    ** GOTO lbl-1000
lbl190:
                    // 1 sources

                    var124_117 = this.mWebViewCore;
                    var125_118 = 141;
                    var126_119 = var42_41;
                    var124_117.sendMessage(var125_118, var126_119);
                    if (var94_93 && !this.inFullScreenMode()) {
                        var127_120 = this.mPrivateHandler;
                        var128_121 = this.mPrivateHandler.obtainMessage(10, var14_12, 0);
                        var129_122 = var127_120.sendMessageDelayed(var128_121, 200L);
                    }
lbl198:
                    // 4 sources

                    if (this.mTouchMode == 7 || this.mPreventDefault == 3) ** GOTO lbl-1000
                    if (this.mVelocityTracker == null) {
                        var130_123 = new StringBuilder().append("Got null mVelocityTracker when mPreventDefault = ");
                        var131_124 = this.mPreventDefault;
                        var132_125 = var130_123.append(var131_124).append(" mDeferTouchProcess = ");
                        var133_126 = this.mDeferTouchProcess;
                        var134_127 = var132_125.append(var133_126).append(" mTouchMode = ");
                        var135_128 = this.mTouchMode;
                        var136_129 = var134_127.append(var135_128).toString();
                        var137_130 = Log.e("webview", var136_129);
                    }
                    var138_131 = this.mVelocityTracker;
                    var139_132 = var1_1;
                    var138_131.addMovement(var139_132);
                    if (!this.mSelectingText || !this.mSelectionStarted) ** GOTO lbl218
                    var140_133 = this;
                    var141_134 = var26_24;
                    var142_135 = var32_30;
                    var140_133.nativeExtendSelection(var141_134, var142_135);
                    this.invalidate();
                    ** GOTO lbl-1000
lbl218:
                    // 1 sources

                    if (this.mTouchMode == 3) ** GOTO lbl241
                    if (!this.mConfirmMove) ** GOTO lbl-1000
                    if (this.mPreventDefault != 1 && this.mPreventDefault != 2) ** GOTO lbl223
                    this.mLastTouchTime = var143_136 = var3_3;
                    ** GOTO lbl-1000
lbl223:
                    // 1 sources

                    if (this.mScaleDetector == null || this.mScaleDetector.isInProgress()) ** GOTO lbl232
                    var145_137 = Math.abs(var19_17);
                    var147_139 = var145_137;
                    if (!(var147_139 > (var149_141 = 1.5f * (var148_140 = (float)(var146_138 = Math.abs(var20_18)))))) ** GOTO lbl271
                    this.mSnapScrollMode = var150_143 = 2;
                    if (var19_17 <= 0) ** GOTO lbl269
                    var151_144 = true;
lbl230:
                    // 2 sources

                    while (true) {
                        this.mSnapPositive = var152_146 = var151_144;
lbl232:
                        // 4 sources

                        while (true) {
                            this.mTouchMode = var153_147 = 3;
                            this.mLastTouchX = var154_148 = var12_10;
                            this.mLastTouchY = var155_149 = var13_11;
                            var17_15 = 0.0f;
                            var18_16 = 0.0f;
                            var19_17 = 0;
                            var20_18 = 0;
                            this.startDrag();
lbl241:
                            // 2 sources

                            if (this.mDragTrackerHandler != null) {
                                var156_150 = this.mDragTrackerHandler;
                                var157_151 = var12_10;
                                var158_152 = var13_11;
                                var156_150.dragTo(var157_151, var158_152);
                            }
                            var149_142 = 0;
                            var150_143 = 0;
                            if (!(Math.abs(var17_15) < 1.0f) || !(Math.abs(var18_16) < 1.0f)) ** GOTO lbl283
                            this.mLastTouchX = var161_153 = var12_10;
                            this.mLastTouchY = var162_154 = var13_11;
                            var150_143 = var149_142 = 1;
lbl252:
                            // 2 sources

                            while (true) {
                                var163_155 = this;
                                var164_156 = var19_17;
                                var165_157 = var20_18;
                                var163_155.doDrag(var164_156, var165_157);
                                if (var150_143 == 0) ** GOTO lbl-1000
                                if (this.mHeldMotionless != 2) {
                                    this.mHeldMotionless = var166_158 = 2;
                                    this.invalidate();
                                }
                                var167_159 = ViewConfiguration.getScrollDefaultDelay();
                                var168_160 = this;
                                var169_161 = var167_159;
                                var170_162 = false;
                                var171_163 = var168_160.awakenScrollBars(var169_161, var170_162);
                                if (var149_142 != 0) ** GOTO lbl347
                                var2_2 = true;
                                ** GOTO lbl3
                                break;
                            }
                            break;
                        }
                        break;
                    }
lbl269:
                    // 1 sources

                    var151_144 = false;
                    ** continue;
lbl271:
                    // 1 sources

                    var172_164 = var146_138;
                    var173_165 = var145_137;
                    var174_166 = 1.5f * var173_165;
                    if (!(var172_164 > var174_166)) ** GOTO lbl232
                    this.mSnapScrollMode = var175_167 = 4;
                    if (var20_18 > 0) {
                        var151_145 = true;
lbl278:
                        // 2 sources

                        while (true) {
                            this.mSnapPositive = var176_168 = var151_145;
                            ** continue;
                            break;
                        }
                    }
                    var151_145 = false;
                    ** continue;
lbl283:
                    // 1 sources

                    if (this.mSnapScrollMode != 2 && this.mSnapScrollMode != 4) ** GOTO lbl300
                    var145_137 = Math.abs(var19_17);
                    var146_138 = Math.abs(var20_18);
                    if (this.mSnapScrollMode != 2) ** GOTO lbl321
                    var177_169 = var146_138;
                    var178_170 = var145_137;
                    var179_171 = 1.5f * var178_170;
                    if (var177_169 > var179_171 && var146_138 > 80) {
                        this.mSnapScrollMode = var180_172 = 0;
                    }
                    if (!((var181_173 = (float)var145_137) > (var183_175 = 1.5f * (var182_174 = (float)var146_138)))) ** GOTO lbl300
                    if (!this.mSnapPositive) ** GOTO lbl316
                    var185_177 = var19_17;
                    var184_176 = -this.mMinLockSnapReverseDistance;
                    var186_178 = var184_176;
                    if (var185_177 >= var186_178) ** GOTO lbl300
lbl298:
                    // 2 sources

                    while (true) {
                        this.mSnapScrollMode = var187_179 = this.mSnapScrollMode | 1;
lbl300:
                        // 9 sources

                        while (true) {
                            if (this.mSnapScrollMode == 0) ** GOTO lbl304
                            if ((this.mSnapScrollMode & 2) != 2) ** GOTO lbl341
                            var20_18 = 0;
lbl304:
                            // 3 sources

                            while ((var19_17 | var20_18) != 0) {
                                if (var19_17 != 0) {
                                    this.mLastTouchX = var188_180 = var12_10;
                                }
                                if (var20_18 != 0) {
                                    this.mLastTouchY = var189_181 = var13_11;
                                }
                                this.mHeldMotionless = var190_182 = 0;
lbl310:
                                // 2 sources

                                while (true) {
                                    this.mLastTouchTime = var191_183 = var3_3;
                                    this.mUserScroll = var193_184 = true;
                                    ** continue;
                                    break;
                                }
lbl314:
                                // 1 sources

                                ** GOTO lbl252
                            }
                            ** GOTO lbl343
                            break;
                        }
                        break;
                    }
lbl316:
                    // 1 sources

                    var195_186 = var19_17;
                    var194_185 = this.mMinLockSnapReverseDistance;
                    var196_187 = var194_185;
                    if (var195_186 <= var196_187) ** GOTO lbl300
                    ** continue;
lbl321:
                    // 1 sources

                    var197_188 = var145_137;
                    var198_189 = var146_138;
                    var199_190 = 1.5f * var198_189;
                    if (var197_188 > var199_190 && var145_137 > 80) {
                        this.mSnapScrollMode = var200_191 = 0;
                    }
                    if (!((var201_192 = (float)var146_138) > (var203_194 = 1.5f * (var202_193 = (float)var145_137)))) ** GOTO lbl300
                    if (!this.mSnapPositive) ** GOTO lbl335
                    var205_196 = var20_18;
                    var204_195 = -this.mMinLockSnapReverseDistance;
                    var206_197 = var204_195;
                    if (var205_196 >= var206_197) ** GOTO lbl300
lbl332:
                    // 2 sources

                    while (true) {
                        this.mSnapScrollMode = var207_198 = this.mSnapScrollMode | 1;
                        ** GOTO lbl300
                        break;
                    }
lbl335:
                    // 1 sources

                    var209_200 = var20_18;
                    var208_199 = this.mMinLockSnapReverseDistance;
                    var210_201 = var208_199;
                    if (var209_200 > var210_201) ** break;
                    ** continue;
                    ** continue;
lbl341:
                    // 1 sources

                    var19_17 = 0;
                    ** GOTO lbl304
lbl343:
                    // 1 sources

                    this.mLastTouchX = var211_202 = var12_10;
                    this.mLastTouchY = var212_203 = var13_11;
                    var150_143 = 1;
                    ** continue;
lbl347:
                    // 1 sources

                    var2_2 = false;
                    ** continue;
                }
                case 1: {
                    if (this.shouldForwardTouchEvent()) {
                        var42_42 = new WebViewCore.TouchEventData();
                        var42_42.mAction = var213_204 = var14_12;
                        var42_42.mX = var214_205 = var26_24;
                        var42_42.mY = var215_206 = var32_30;
                        var42_42.mMetaState = var216_207 = var1_1.getMetaState();
                        var42_42.mReprocess = var217_208 = this.mDeferTouchProcess;
                        if (this.mDeferTouchProcess) {
                            var42_42.mViewX = var218_209 = var12_10;
                            var42_42.mViewY = var219_210 = var13_11;
                        }
                        var220_211 = this.mWebViewCore;
                        var221_212 = 141;
                        var222_213 = var42_42;
                        var220_211.sendMessage(var221_212, var222_213);
                    }
                    this.mLastTouchUpTime = var223_214 = var3_3;
                    switch (this.mTouchMode) lbl-1000:
                    // 5 sources

                    {
                        default: lbl-1000:
                        // 6 sources

                        {
                            while (true) {
                                this.stopTouch();
                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        case 6: {
                            this.mPrivateHandler.removeMessages(3);
                            this.mPrivateHandler.removeMessages(4);
                            if (!this.inFullScreenMode() && !this.mDeferTouchProcess) ** GOTO lbl388
                            var42_42 = new WebViewCore.TouchEventData();
                            var42_42.mAction = var225_215 = 512;
                            var42_42.mX = var226_216 = var26_24;
                            var42_42.mY = var227_217 = var32_30;
                            var42_42.mMetaState = var228_218 = var1_1.getMetaState();
                            var42_42.mReprocess = var229_219 = this.mDeferTouchProcess;
                            if (this.mDeferTouchProcess) {
                                var42_42.mViewX = var230_220 = var12_10;
                                var42_42.mViewY = var231_221 = var13_11;
                            }
                            var232_222 = this.mWebViewCore;
                            var233_223 = 141;
                            var234_224 = var42_42;
                            var232_222.sendMessage(var233_223, var234_224);
                            ** GOTO lbl-1000
lbl388:
                            // 1 sources

                            if (this.mPreventDefault == 3) ** GOTO lbl-1000
                            this.doDoubleTap();
                            this.mTouchMode = var235_225 = 7;
                            ** GOTO lbl-1000
                        }
                        case 1: 
                        case 4: 
                        case 5: {
                            this.mPrivateHandler.removeMessages(3);
                            this.mPrivateHandler.removeMessages(4);
                            if (!this.mConfirmMove) ** GOTO lbl425
                            var236_226 = Log.w("webview", "Miss a drag as we are waiting for WebCore's response for touch down.");
                            if (this.mPreventDefault == 3 || this.computeMaxScrollX() <= 0 && this.computeMaxScrollY() <= 0) break;
                            var237_227 = this;
                            var238_228 = var26_24;
                            var239_229 = var32_30;
                            var240_230 = true;
                            var237_227.cancelWebCoreTouchEvent(var238_228, var239_229, var240_230);
                            WebViewCore.reducePriority();
                            WebViewCore.pauseUpdatePicture(this.mWebViewCore);
                        }
                        case 3: {
                            this.mPrivateHandler.removeMessages(8);
                            this.mPrivateHandler.removeMessages(9);
                            var241_231 = this.mLastTouchTime;
                            if (var3_3 - var241_231 > 250L) ** GOTO lbl440
                            if (this.mVelocityTracker == null) {
                                var243_232 = new StringBuilder().append("Got null mVelocityTracker when mPreventDefault = ");
                                var244_233 = this.mPreventDefault;
                                var245_234 = var243_232.append(var244_233).append(" mDeferTouchProcess = ");
                                var246_235 = this.mDeferTouchProcess;
                                var247_236 = var245_234.append(var246_235).toString();
                                var248_237 = Log.e("webview", var247_236);
                            }
                            var249_238 = this.mVelocityTracker;
                            var250_239 = var1_1;
                            var249_238.addMovement(var250_239);
                            this.mHeldMotionless = var251_240 = 3;
                            this.doFling();
                            ** GOTO lbl-1000
                        }
                    }
                    this.invalidate();
                    ** GOTO lbl-1000
lbl425:
                    // 1 sources

                    if (!this.mSelectingText) ** GOTO lbl433
                    var252_241 = this;
                    var253_242 = var26_24;
                    var254_243 = var32_30;
                    if (var252_241.nativeHitSelection(var253_242, var254_243)) {
                        var255_244 = this.copySelection();
                    }
                    this.selectionDone();
                    ** GOTO lbl-1000
lbl433:
                    // 1 sources

                    if (this.mTouchMode != 1) ** GOTO lbl438
                    var256_245 = this.mPrivateHandler;
                    var257_246 = ViewConfiguration.getDoubleTapTimeout();
                    var259_247 = var256_245.sendEmptyMessageDelayed(5, var257_246);
                    ** GOTO lbl-1000
lbl438:
                    // 1 sources

                    this.doShortPress();
                    ** GOTO lbl-1000
lbl440:
                    // 1 sources

                    var260_248 = this.mScroller;
                    var261_249 = this.mScrollX;
                    var262_250 = this.mScrollY;
                    var263_251 = this.computeMaxScrollX();
                    if (var260_248.springBack(var261_249, var262_250, 0, var263_251, 0, var264_252 = this.computeMaxScrollY())) {
                        this.invalidate();
                    }
                    this.mHeldMotionless = var265_253 = 2;
                    this.invalidate();
                    {
                        ** case 2:
                    }
lbl449:
                    // 2 sources

                    this.mLastVelocity = var266_254 = 0.0f;
                    WebViewCore.resumePriority();
                    WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                    ** continue;
                }
                case 3: 
            }
            break;
        }
        if (this.mTouchMode == 3) {
            var267_255 = this.mScroller;
            var268_256 = this.mScrollX;
            var269_257 = this.mScrollY;
            var270_258 = this.computeMaxScrollX();
            var271_259 = this.computeMaxScrollY();
            var272_260 = var267_255.springBack(var268_256, var269_257, 0, var270_258, 0, var271_259);
            this.invalidate();
        }
        var273_261 = this;
        var274_262 = var26_24;
        var275_263 = var32_30;
        var276_264 = false;
        var273_261.cancelWebCoreTouchEvent(var274_262, var275_263, var276_264);
        this.cancelTouch();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        float f;
        float f2;
        long l = motionEvent.getEventTime();
        if ((motionEvent.getMetaState() & 2) != 0) {
            if (motionEvent.getY() > 0.0f) {
                boolean bl = this.pageDown(true);
            }
            if (!(motionEvent.getY() < 0.0f)) return true;
            boolean bl = this.pageUp(true);
            return true;
        }
        if (motionEvent.getAction() == 0) {
            Rect rect;
            Rect rect2;
            if (this.mSelectingText) {
                return true;
            }
            this.mTrackballDown = true;
            if (this.mNativeClass == 0) {
                return false;
            }
            boolean bl = this.hasFocus() && this.hasWindowFocus();
            this.nativeRecordButtons(bl, true, true);
            long l2 = this.mLastCursorTime;
            if (l - l2 <= 200L && !(rect2 = this.mLastCursorBounds).equals(rect = this.nativeGetCursorRingBounds())) {
                Rect rect3 = this.mLastCursorBounds;
                this.nativeSelectBestAt(rect3);
            }
            if (!this.isInTouchMode()) return false;
            boolean bl2 = this.requestFocusFromTouch();
            return false;
        }
        if (motionEvent.getAction() == 1) {
            this.mPrivateHandler.removeMessages(114);
            this.mTrackballDown = false;
            this.mTrackballUpTime = l;
            if (!this.mSelectingText) {
                return false;
            }
            if (this.mExtendSelection) {
                boolean bl = this.copySelection();
                this.selectionDone();
                return true;
            } else {
                this.mExtendSelection = true;
                this.nativeSetExtendSelection();
                this.invalidate();
            }
            return true;
        }
        if (this.mMapTrackballToArrowKeys && !this.mShiftIsPressed) {
            return false;
        }
        if (this.mTrackballDown) {
            return true;
        }
        long l3 = this.mTrackballUpTime;
        if (l - l3 < 200L) {
            return true;
        }
        this.switchOutDrawHistory();
        long l4 = this.mTrackballLastTime;
        if (l - l4 > 200L) {
            this.mTrackballFirstTime = l;
            this.mTrackballYMove = 0;
            this.mTrackballXMove = 0;
        }
        this.mTrackballLastTime = l;
        float f3 = this.mTrackballRemainsX;
        float f4 = motionEvent.getX();
        this.mTrackballRemainsX = f2 = f3 + f4;
        float f5 = this.mTrackballRemainsY;
        float f6 = motionEvent.getY();
        this.mTrackballRemainsY = f = f5 + f6;
        this.doTrackball(l);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onWindowFocusChanged(boolean bl) {
        this.setActive(bl);
        if (bl) {
            JWebCoreJavaBridge.setActiveWebView(this);
        } else {
            JWebCoreJavaBridge.removeActiveWebView(this);
        }
        super.onWindowFocusChanged(bl);
    }

    public boolean overlayHorizontalScrollbar() {
        return this.mOverlayHorizontalScrollbar;
    }

    public boolean overlayVerticalScrollbar() {
        return this.mOverlayVerticalScrollbar;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean pageDown(boolean bl) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (bl) {
            int n = this.mScrollX;
            int n2 = this.computeRealVerticalScrollRange();
            return this.pinScrollTo(n, n2, true, 0);
        }
        int n = this.getHeight();
        int n3 = n > 48 ? n - 24 : n / 2;
        this.mUserScroll = true;
        if (!this.mScroller.isFinished()) return this.extendScroll(n3);
        return this.pinScrollBy(0, n3, true, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean pageUp(boolean bl) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (bl) {
            int n = this.mScrollX;
            return this.pinScrollTo(n, 0, true, 0);
        }
        int n = this.getHeight();
        int n2 = n > 48 ? -n + 24 : -n / 2;
        this.mUserScroll = true;
        if (!this.mScroller.isFinished()) return this.extendScroll(n2);
        return this.pinScrollBy(0, n2, true, 0);
    }

    void passToJavaScript(String string2, KeyEvent keyEvent) {
        int n;
        WebViewCore.JSKeyData jSKeyData = new WebViewCore.JSKeyData();
        jSKeyData.mEvent = keyEvent;
        jSKeyData.mCurrentText = string2;
        this.mTextGeneration = n = this.mTextGeneration + 1;
        WebViewCore webViewCore = this.mWebViewCore;
        int n2 = this.mTextGeneration;
        webViewCore.sendMessage(115, n2, 0, jSKeyData);
        this.mWebViewCore.removeMessages(128);
        WebViewCore webViewCore2 = this.mWebViewCore;
        WebViewCore.CursorData cursorData = this.cursorData();
        webViewCore2.sendMessageDelayed(128, cursorData, 1000L);
    }

    public void pauseTimers() {
        this.mWebViewCore.sendMessage(109);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean performLongClick() {
        if (this.getParent() == null) {
            return false;
        }
        if (this.mNativeClass != 0 && this.nativeCursorIsTextInput()) {
            this.centerKeyPressOnTextField();
            this.rebuildWebTextView();
        } else {
            this.clearTextEntry(true);
        }
        if (this.inEditingMode()) {
            return this.mWebTextView.performLongClick();
        }
        if (super.performLongClick()) {
            return true;
        }
        if (this.mSelectingText) {
            return false;
        }
        int n = (int)this.mLastTouchX;
        int n2 = this.mScrollX;
        int n3 = n + n2;
        int n4 = this.viewToContentX(n3);
        int n5 = (int)this.mLastTouchY;
        int n6 = this.mScrollY;
        int n7 = n5 + n6;
        int n8 = this.viewToContentY(n7);
        this.setUpSelect();
        if (this.mNativeClass != 0 && this.nativeWordSelection(n4, n8)) {
            this.nativeSetExtendSelection();
            WebChromeClient webChromeClient = this.getWebChromeClient();
            if (webChromeClient == null) return true;
            webChromeClient.onSelectionStart(this);
            return true;
        }
        this.notifySelectDialogDismissed();
        return false;
    }

    public void postUrl(String string2, byte[] byArray) {
        if (URLUtil.isNetworkUrl(string2)) {
            this.switchOutDrawHistory();
            WebViewCore.PostUrlData postUrlData = new WebViewCore.PostUrlData();
            postUrlData.mUrl = string2;
            postUrlData.mPostData = byArray;
            this.mWebViewCore.sendMessage(132, postUrlData);
            this.clearHelpers();
            return;
        }
        this.loadUrl(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    void rebuildWebTextView() {
        if (!this.hasFocus()) {
            if (this.mWebTextView == null) {
                return;
            }
            if (!this.mWebTextView.hasFocus()) {
                return;
            }
        }
        boolean bl = this.inEditingMode();
        if (this.mNativeClass == 0 || !this.nativeFocusCandidateIsTextInput()) {
            if (!bl) {
                return;
            }
            this.mWebTextView.remove();
            return;
        }
        if (this.mWebTextView == null) {
            WebTextView webTextView;
            Context context = this.mContext;
            this.mWebTextView = webTextView = new WebTextView(context, this);
            this.mTextGeneration = 0;
        }
        WebTextView webTextView = this.mWebTextView;
        int n = this.nativeFocusCandidateTextSize();
        float f = this.contentToViewDimension(n);
        webTextView.setTextSize(0, f);
        Rect rect = new Rect();
        this.calcOurContentVisibleRect(rect);
        Rect rect2 = this.nativeFocusCandidateNodeBounds();
        Rect rect3 = this.contentToViewRect(rect2);
        WebTextView webTextView2 = this.mWebTextView;
        int n2 = rect3.left;
        int n3 = rect3.top;
        int n4 = rect3.width();
        int n5 = rect3.height();
        webTextView2.setRect(n2, n3, n4, n5);
        if (!Rect.intersects(rect2, rect)) {
            this.mWebTextView.bringIntoView();
        }
        String string2 = this.nativeFocusCandidateText();
        int n6 = this.nativeFocusCandidatePointer();
        if (bl && this.mWebTextView.isSameTextField(n6)) {
            int n7;
            int n8;
            String string3;
            if (string2 != null && !string2.equals(string3 = this.mWebTextView.getText().toString()) && (n8 = this.nativeTextGeneration()) != (n7 = this.mTextGeneration)) {
                this.mWebTextView.setTextAndKeepSelection(string2);
            }
        } else {
            WebTextView webTextView3;
            WebTextView webTextView4 = this.mWebTextView;
            int n9 = this.nativeFocusCandidateIsRtlText() ? 5 : 0;
            webTextView4.setGravity(n9);
            this.mWebTextView.setNodePointer(n6);
            WebTextView webTextView5 = this.mWebTextView;
            int n10 = this.nativeFocusCandidateType();
            webTextView5.setType(n10);
            Rect rect4 = this.nativeFocusCandidatePaddingRect();
            if (rect4 != null) {
                WebTextView webTextView6 = this.mWebTextView;
                int n11 = rect4.left;
                int n12 = this.contentToViewDimension(n11);
                int n13 = rect4.top;
                int n14 = this.contentToViewDimension(n13);
                int n15 = rect4.right;
                int n16 = this.contentToViewDimension(n15);
                int n17 = rect4.bottom;
                int n18 = this.contentToViewDimension(n17);
                webTextView6.setPadding(n12, n14, n16, n18);
            }
            if (string2 == null) {
                string2 = "";
            }
            this.mWebTextView.setTextAndKeepSelection(string2);
            InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
            if (inputMethodManager != null && inputMethodManager.isActive(webTextView3 = this.mWebTextView)) {
                WebTextView webTextView7 = this.mWebTextView;
                inputMethodManager.restartInput(webTextView7);
            }
        }
        boolean bl2 = this.mWebTextView.requestFocus();
    }

    @Deprecated
    public void refreshPlugins(boolean bl) {
    }

    public void reload() {
        this.clearHelpers();
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(102);
    }

    public void removePackageName(String string2) {
        this.mWebViewCore.sendMessage(186, string2);
    }

    void replaceTextfieldText(int n, int n2, String string2, int n3, int n4) {
        int n5;
        int n6;
        WebViewCore.ReplaceTextData replaceTextData = new WebViewCore.ReplaceTextData();
        replaceTextData.mReplace = string2;
        replaceTextData.mNewStart = n3;
        replaceTextData.mNewEnd = n4;
        replaceTextData.mTextGeneration = n6 = (this.mTextGeneration = (n5 = this.mTextGeneration + 1));
        this.mWebViewCore.sendMessage(114, n, n2, replaceTextData);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        Rect rect2;
        int n = view.getLeft();
        int n2 = view.getScrollX();
        int n3 = n - n2;
        int n4 = view.getTop();
        int n5 = view.getScrollY();
        int n6 = n4 - n5;
        Rect rect3 = rect;
        int n7 = n3;
        int n8 = n6;
        rect3.offset(n7, n8);
        int n9 = this.mScrollX;
        WebView webView = this;
        int n10 = n9;
        int n11 = webView.viewToContentX(n10);
        int n12 = this.mScrollY;
        WebView webView2 = this;
        int n13 = n12;
        int n14 = webView2.viewToContentY(n13);
        int n15 = this.mScrollX;
        int n16 = this.getWidth();
        int n17 = n15 + n16;
        int n18 = this.getVerticalScrollbarWidth();
        int n19 = n17 - n18;
        WebView webView3 = this;
        int n20 = n19;
        int n21 = webView3.viewToContentX(n20);
        int n22 = this.mScrollY;
        int n23 = this.getViewHeightWithTitle();
        int n24 = n22 + n23;
        WebView webView4 = this;
        int n25 = n24;
        int n26 = webView4.viewToContentY(n25);
        Rect rect4 = rect2;
        int n27 = n11;
        int n28 = n14;
        int n29 = n21;
        int n30 = n26;
        rect4(n27, n28, n29, n30);
        WebView webView5 = this;
        Rect rect5 = rect2;
        Rect rect6 = webView5.nativeSubtractLayers(rect5);
        int n31 = rect6.top;
        WebView webView6 = this;
        int n32 = n31;
        int n33 = webView6.contentToViewY(n32);
        int n34 = rect6.bottom;
        WebView webView7 = this;
        int n35 = n34;
        int n36 = webView7.contentToViewY(n35);
        int n37 = n36 - n33;
        int n38 = 0;
        if (rect.bottom > n36) {
            int n39;
            int n40;
            int n41 = n37 / 3;
            int n42 = rect.height();
            int n43 = n42;
            if (n43 > (n40 = (n39 = n41 * 2))) {
                n38 = rect.top - n33;
            } else {
                int n44 = rect.top;
                int n45 = n33 + n41;
                n38 = n44 - n45;
            }
        } else if (rect.top < n33) {
            n38 = rect.top - n33;
        }
        int n46 = rect6.left;
        WebView webView8 = this;
        int n47 = n46;
        int n48 = webView8.contentToViewX(n47);
        int n49 = rect6.right;
        WebView webView9 = this;
        int n50 = n49;
        int n51 = webView9.contentToViewX(n50);
        int n52 = n51 - n48;
        int n53 = 0;
        if (rect.right > n51 && rect.left > n48) {
            if (rect.width() > n52) {
                int n54 = rect.left - n48;
                n53 += n54;
            } else {
                int n55 = rect.right - n51;
                n53 += n55;
            }
        } else if (rect.left < n48) {
            int n56 = rect.left;
            int n57 = n48 - n56;
            n53 -= n57;
        }
        if ((n38 | n53) == 0) {
            return false;
        }
        boolean bl2 = !bl;
        WebView webView10 = this;
        int n58 = n53;
        int n59 = n38;
        boolean bl3 = bl2;
        int n60 = 0;
        return webView10.pinScrollBy(n58, n59, bl3, n60);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requestFocus(int n, Rect rect) {
        boolean bl;
        if (this.inEditingMode()) {
            bl = this.mWebTextView.requestFocus(n, rect);
            return bl;
        } else {
            int n2;
            bl = super.requestFocus(n, rect);
            if (!this.mWebViewCore.getSettings().getNeedInitialFocus()) return bl;
            switch (n) {
                default: {
                    return bl;
                }
                case 33: {
                    n2 = 19;
                    break;
                }
                case 130: {
                    n2 = 20;
                    break;
                }
                case 17: {
                    n2 = 21;
                    break;
                }
                case 66: {
                    n2 = 22;
                }
            }
            if (this.mNativeClass == 0) return bl;
            if (this.nativeHasCursorNode()) return bl;
            WebView webView = this;
            boolean bl2 = true;
            boolean bl3 = webView.navHandledKey(n2, 1, bl2, 0L);
        }
        return bl;
    }

    public void requestFocusNodeHref(Message message) {
        if (message == null) {
            return;
        }
        if (this.mNativeClass == 0) {
            return;
        }
        if (!this.nativeCursorIsAnchor()) {
            return;
        }
        WebViewCore webViewCore = this.mWebViewCore;
        int n = this.nativeCursorFramePointer();
        int n2 = this.nativeCursorNodePointer();
        webViewCore.sendMessage(137, n, n2, message);
    }

    void requestFormData(String string2, int n) {
        if (!this.mWebViewCore.getSettings().getSaveFormData()) {
            return;
        }
        Message message = this.mPrivateHandler.obtainMessage(6);
        message.arg1 = n;
        String string3 = this.getUrl();
        RequestFormData requestFormData = new RequestFormData(string2, string3, message);
        new Thread(requestFormData).start();
    }

    public void requestImageRef(Message message) {
        if (this.mNativeClass == 0) {
            return;
        }
        int n = (int)this.mLastTouchX;
        int n2 = this.mScrollX;
        int n3 = n + n2;
        int n4 = this.viewToContentX(n3);
        int n5 = (int)this.mLastTouchY;
        int n6 = this.mScrollY;
        int n7 = n5 + n6;
        int n8 = this.viewToContentY(n7);
        String string2 = this.nativeImageURI(n4, n8);
        Bundle bundle = message.getData();
        bundle.putString("url", string2);
        message.setData(bundle);
        message.sendToTarget();
    }

    void requestLabel(int n, int n2) {
        this.mWebViewCore.sendMessage(97, n, n2);
    }

    void requestListBox(String[] stringArray, int[] nArray, int n) {
        Handler handler = this.mPrivateHandler;
        WebView webView = this;
        String[] stringArray2 = stringArray;
        int[] nArray2 = nArray;
        int n2 = n;
        InvokeListBox invokeListBox = webView.new InvokeListBox(stringArray2, nArray2, n2);
        boolean bl = handler.post(invokeListBox);
    }

    void requestListBox(String[] stringArray, int[] nArray, int[] nArray2) {
        Handler handler = this.mPrivateHandler;
        WebView webView = this;
        String[] stringArray2 = stringArray;
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        InvokeListBox invokeListBox = webView.new InvokeListBox(stringArray2, nArray3, nArray4);
        boolean bl = handler.post(invokeListBox);
    }

    void resetTrackballTime() {
        this.mTrackballLastTime = 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean restorePicture(Bundle bundle, File file) {
        if (file == null) return false;
        if (bundle == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        try {
            final FileInputStream fileInputStream = new FileInputStream(file);
            final Bundle bundle2 = new Bundle(bundle);
            Runnable runnable = new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        final Picture picture = Picture.createFromStream(fileInputStream);
                        if (picture == null) return;
                        Handler handler = WebView.this.mPrivateHandler;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                WebView webView = WebView.this;
                                Picture picture2 = picture;
                                Bundle bundle = bundle2;
                                webView.restoreHistoryPictureFields(picture2, bundle);
                            }
                        };
                        boolean bl = handler.post(runnable);
                        return;
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
            };
            new Thread(runnable).start();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebBackForwardList restoreState(Bundle bundle) {
        SslCertificate sslCertificate;
        WebBackForwardList webBackForwardList = null;
        if (bundle == null) {
            return null;
        }
        if (!bundle.containsKey("index")) return webBackForwardList;
        if (!bundle.containsKey("history")) return webBackForwardList;
        this.mCertificate = sslCertificate = SslCertificate.restoreState(bundle.getBundle("certificate"));
        WebBackForwardList webBackForwardList2 = this.mCallbackProxy.getBackForwardList();
        int n = bundle.getInt("index");
        synchronized (webBackForwardList2) {
            List list = (List)((Object)bundle.getSerializable("history"));
            int n2 = list.size();
            if (n < 0) return null;
            if (n >= n2) {
                return null;
            }
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = (byte[])list.remove(0);
                if (byArray == null) {
                    return null;
                }
                WebHistoryItem webHistoryItem = new WebHistoryItem(byArray);
                webBackForwardList2.addHistoryItem(webHistoryItem);
            }
            webBackForwardList = this.copyBackForwardList();
            webBackForwardList.setCurrentIndex(n);
        }
        this.mWebViewCore.removeMessages();
        this.mWebViewCore.sendMessage(108, n);
        return webBackForwardList;
    }

    public void resumeTimers() {
        this.mWebViewCore.sendMessage(110);
    }

    public void savePassword(String string2, String string3, String string4) {
        this.mDatabase.setUsernamePassword(string2, string3, string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean savePicture(Bundle bundle, final File file) {
        if (file == null) return false;
        if (bundle == null) {
            return false;
        }
        final Picture picture = this.capturePicture();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = file.getPath();
        String string3 = stringBuilder.append(string2).append(".writing").toString();
        final File file2 = new File(string3);
        Runnable runnable = new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block19: {
                    var1_1 = null;
                    var2_2 = file2;
                    var3_3 = new FileOutputStream(var2_2);
                    picture.writeToStream(var3_3);
                    var4_4 = file2;
                    var5_5 = file;
                    var6_6 = var4_4.renameTo(var5_5);
                    if (var3_3 == null) break block19;
                    try {
                        var3_3.close();
                    }
                    catch (Exception var16_18) {
                        ** continue;
                    }
                }
lbl14:
                // 2 sources

                while (true) {
                    var7_7 = file2.delete();
                    var8_8 = var3_3;
                    return;
                }
                catch (Throwable var9_9) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var1_1 != null) {
                            var1_1.close();
                        }
lbl23:
                        // 4 sources

                        while (true) {
                            var10_12 = file2.delete();
                            throw var9_10;
                        }
                        break;
                    }
                }
                catch (Exception var11_13) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var12_14 != null) {
                            var12_14.close();
                        }
lbl31:
                        // 4 sources

                        while (true) {
                            var13_15 = file2.delete();
                            return;
                        }
                        catch (Exception var14_16) {
                            ** continue;
                        }
                        break;
                    }
                }
                {
                    catch (Exception var15_17) {
                        ** continue;
                    }
                }
                catch (Throwable var9_11) {
                    var1_1 = var3_3;
                    ** continue;
                }
                catch (Exception var17_19) {
                    var12_14 = var3_3;
                    ** continue;
                }
            }
        };
        new Thread(runnable).start();
        int n = this.mScrollX;
        bundle.putInt("scrollX", n);
        int n2 = this.mScrollY;
        bundle.putInt("scrollY", n2);
        float f = this.mActualScale;
        bundle.putFloat("scale", f);
        float f2 = this.mTextWrapScale;
        bundle.putFloat("textwrapScale", f2);
        boolean bl = this.mInZoomOverview;
        bundle.putBoolean("overview", bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebBackForwardList saveState(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        WebBackForwardList webBackForwardList = this.copyBackForwardList();
        int n = webBackForwardList.getCurrentIndex();
        int n2 = webBackForwardList.getSize();
        if (n < 0) return null;
        if (n >= n2) return null;
        if (n2 == 0) {
            return null;
        }
        bundle.putInt("index", n);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            WebHistoryItem webHistoryItem = webBackForwardList.getItemAtIndex(i);
            if (webHistoryItem == null) {
                int n3 = Log.w(LOGTAG, "saveState: Unexpected null history item.");
                return null;
            }
            byte[] byArray = webHistoryItem.getFlattenedData();
            if (byArray == null) {
                return null;
            }
            boolean bl = arrayList.add(byArray);
        }
        bundle.putSerializable("history", arrayList);
        if (this.mCertificate == null) return webBackForwardList;
        Bundle bundle2 = SslCertificate.saveState(this.mCertificate);
        bundle.putBundle("certificate", bundle2);
        return webBackForwardList;
    }

    void scrollFocusedTextInput(float f, int n) {
        if (!this.inEditingMode()) {
            return;
        }
        if (this.mWebViewCore == null) {
            return;
        }
        WebViewCore webViewCore = this.mWebViewCore;
        int n2 = this.viewToContentDimension(n);
        Float f2 = new Float(f);
        webViewCore.sendMessage(99, n2, f2);
    }

    public void selectAll() {
        if (this.mNativeClass == 0) {
            return;
        }
        if (this.inFullScreenMode()) {
            return;
        }
        if (!this.mSelectingText) {
            this.setUpSelect();
        }
        this.nativeSelectAll();
        this.mDrawSelectionPointer = false;
        this.mExtendSelection = true;
        this.invalidate();
    }

    public boolean selectDialogIsUp() {
        return this.mSelectingText;
    }

    public void selectionDone() {
        if (!this.mSelectingText) {
            return;
        }
        WebChromeClient webChromeClient = this.getWebChromeClient();
        if (webChromeClient != null) {
            webChromeClient.onSelectionDone(this);
        }
        this.invalidate();
        this.notifySelectDialogDismissed();
    }

    @Override
    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
        this.mWebViewCore.sendMessage(126, n);
    }

    public void setCertificate(SslCertificate sslCertificate) {
        this.mCertificate = sslCertificate;
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.mCallbackProxy.setDownloadListener(downloadListener);
    }

    public void setDragTracker(DragTracker dragTracker) {
        this.mDragTracker = dragTracker;
    }

    public void setEmbeddedTitleBar(View view) {
        if (this.mTitleBar == view) {
            return;
        }
        if (this.mTitleBar != null) {
            View view2 = this.mTitleBar;
            this.removeView(view2);
        }
        if (view != null) {
            AbsoluteLayout.LayoutParams layoutParams = new AbsoluteLayout.LayoutParams(-1, -1, 0, 0);
            this.addView(view, layoutParams);
            if (this.mTitleShadow == null) {
                Drawable drawable2;
                this.mTitleShadow = drawable2 = this.mContext.getResources().getDrawable(17302325);
            }
        }
        this.mTitleBar = view;
    }

    public void setFindDialogHeight(int n) {
        this.mFindHeight = n;
    }

    public void setFindIsUp(boolean bl) {
        this.mFindIsUp = bl;
        if (bl) {
            int n = this.mContentWidth;
            int n2 = this.mContentHeight;
            int n3 = this.mFindHeight;
            int n4 = n2 + n3;
            this.recordNewContentSize(n, n4, false);
        }
        if (this.mNativeClass == 0) {
            return;
        }
        this.nativeSetFindIsUp(bl);
    }

    void setFocusControllerInactive() {
        if (this.mNativeClass == 0) {
            return;
        }
        this.mWebViewCore.sendMessage(142, 0, 0);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        if (!bl && this.mHeightCanMeasure) {
            boolean bl2 = this.sendViewSizeZoom();
        }
        return bl;
    }

    public void setHorizontalScrollbarOverlay(boolean bl) {
        this.mOverlayHorizontalScrollbar = bl;
    }

    public void setHttpAuthUsernamePassword(String string2, String string3, String string4, String string5) {
        this.mDatabase.setHttpAuthUsernamePassword(string2, string3, string4, string5);
    }

    public void setInitialScale(int n) {
        this.mInitialScaleInPercent = n;
    }

    public void setJsFlags(String string2) {
        this.mWebViewCore.sendMessage(174, string2);
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams.height == -1) {
            this.mWrapContent = true;
        }
        super.setLayoutParams(layoutParams);
    }

    public void setMapTrackballToArrowKeys(boolean bl) {
        this.mMapTrackballToArrowKeys = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNetworkAvailable(boolean bl) {
        WebViewCore webViewCore = this.mWebViewCore;
        int n = bl ? 1 : 0;
        webViewCore.sendMessage(119, n, 0);
    }

    public void setNetworkType(String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string4 = hashMap.put("type", string2);
        String string5 = hashMap.put("subtype", string3);
        this.mWebViewCore.sendMessage(183, hashMap);
    }

    @Override
    public void setOverScrollMode(int n) {
        super.setOverScrollMode(n);
        if (n != 2) {
            EdgeGlow edgeGlow;
            EdgeGlow edgeGlow2;
            EdgeGlow edgeGlow3;
            EdgeGlow edgeGlow4;
            if (this.mEdgeGlowTop != null) {
                return;
            }
            Resources resources = this.getContext().getResources();
            Drawable drawable2 = resources.getDrawable(17302072);
            Drawable drawable3 = resources.getDrawable(17302073);
            this.mEdgeGlowTop = edgeGlow4 = new EdgeGlow(drawable2, drawable3);
            this.mEdgeGlowBottom = edgeGlow3 = new EdgeGlow(drawable2, drawable3);
            this.mEdgeGlowLeft = edgeGlow2 = new EdgeGlow(drawable2, drawable3);
            this.mEdgeGlowRight = edgeGlow = new EdgeGlow(drawable2, drawable3);
            return;
        }
        this.mEdgeGlowTop = null;
        this.mEdgeGlowBottom = null;
        this.mEdgeGlowLeft = null;
        this.mEdgeGlowRight = null;
    }

    public void setPictureListener(PictureListener pictureListener) {
        this.mPictureListener = pictureListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setScrollBarStyle(int n) {
        if (n == 0x1000000 || n == 0x3000000) {
            this.mOverlayVerticalScrollbar = false;
            this.mOverlayHorizontalScrollbar = false;
        } else {
            this.mOverlayVerticalScrollbar = true;
            this.mOverlayHorizontalScrollbar = true;
        }
        super.setScrollBarStyle(n);
    }

    void setSelection(int n, int n2) {
        this.mWebViewCore.sendMessage(113, n, n2);
    }

    public void setTouchInterval(int n) {
        this.mCurrentTouchInterval = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setUpSelect() {
        if (this.mNativeClass == 0) {
            return;
        }
        if (this.inFullScreenMode()) {
            return;
        }
        if (this.mSelectingText) {
            return;
        }
        this.mExtendSelection = false;
        this.mDrawSelectionPointer = true;
        this.mSelectingText = true;
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        this.nativeResetSelection();
        if (this.nativeHasCursorNode()) {
            int n;
            int n2;
            Rect rect = this.nativeCursorNodeBounds();
            int n3 = rect.left;
            this.mSelectX = n2 = this.contentToViewX(n3);
            int n4 = rect.top;
            this.mSelectY = n = this.contentToViewY(n4);
        } else {
            float f = this.mLastTouchY;
            float f2 = this.getVisibleTitleHeight();
            if (f > f2) {
                int n;
                int n5;
                int n6 = this.mScrollX;
                int n7 = (int)this.mLastTouchX;
                this.mSelectX = n5 = n6 + n7;
                int n8 = this.mScrollY;
                int n9 = (int)this.mLastTouchY;
                this.mSelectY = n = n8 + n9;
            } else {
                int n;
                int n10;
                int n11 = this.mScrollX;
                int n12 = this.getViewWidth() / 2;
                this.mSelectX = n10 = n11 + n12;
                int n13 = this.mScrollY;
                int n14 = this.getViewHeightWithTitle() / 2;
                this.mSelectY = n = n13 + n14;
            }
        }
        this.nativeHideCursor();
    }

    public void setVerticalScrollbarOverlay(boolean bl) {
        this.mOverlayVerticalScrollbar = bl;
    }

    public void setWebBackForwardListClient(WebBackForwardListClient webBackForwardListClient) {
        this.mCallbackProxy.setWebBackForwardListClient(webBackForwardListClient);
    }

    public void setWebChromeClient(WebChromeClient webChromeClient) {
        this.mCallbackProxy.setWebChromeClient(webChromeClient);
    }

    public void setWebViewClient(WebViewClient webViewClient) {
        this.mCallbackProxy.setWebViewClient(webViewClient);
    }

    public void stopLoading() {
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(101);
    }

    void switchOutDrawHistory() {
        int n;
        int n2;
        int n3;
        if (this.mWebViewCore == null) {
            return;
        }
        if (!this.mDrawHistory) {
            return;
        }
        if (!this.mWebViewCore.pictureReady()) {
            return;
        }
        this.mDrawHistory = false;
        this.mHistoryPicture = null;
        this.invalidate();
        int n4 = this.mScrollX;
        int n5 = this.mScrollY;
        int n6 = this.mScrollX;
        this.mScrollX = n3 = this.pinLocX(n6);
        int n7 = this.mScrollY;
        this.mScrollY = n2 = this.pinLocY(n7);
        int n8 = this.mScrollX;
        if (n4 == n8 || n5 != (n = this.mScrollY)) {
            this.mUserScroll = false;
            this.mWebViewCore.sendMessage(131, n4, n5);
            int n9 = this.mScrollX;
            int n10 = this.mScrollY;
            this.onScrollChanged(n9, n10, n4, n5);
            return;
        }
        Rect rect = this.sendOurVisibleRect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean textFieldDrag(MotionEvent motionEvent) {
        if (!this.inEditingMode()) {
            return false;
        }
        this.mDragFromTextInput = true;
        int n = this.mWebTextView.getLeft();
        int n2 = this.mScrollX;
        float f = n - n2;
        int n3 = this.mWebTextView.getTop();
        int n4 = this.mScrollY;
        float f2 = n3 - n4;
        motionEvent.offsetLocation(f, f2);
        boolean bl = this.onTouchEvent(motionEvent);
        this.mDragFromTextInput = false;
        return bl;
    }

    void touchUpOnTextField(MotionEvent motionEvent) {
        if (!this.inEditingMode()) {
            return;
        }
        int n = (int)motionEvent.getX();
        int n2 = this.mWebTextView.getLeft();
        int n3 = n + n2;
        int n4 = this.viewToContentX(n3);
        int n5 = (int)motionEvent.getY();
        int n6 = this.mWebTextView.getTop();
        int n7 = n5 + n6;
        int n8 = this.viewToContentY(n7);
        int n9 = this.mNavSlop;
        boolean bl = this.nativeMotionUp(n4, n8, n9);
    }

    void updateCachedTextfield(String string2) {
        int n = this.mTextGeneration;
        this.nativeUpdateCachedTextfield(string2, n);
    }

    void updateDefaultZoomDensity(int n) {
        float f;
        float f2;
        int n2;
        float f3 = this.getContext().getResources().getDisplayMetrics().density * 100.0f;
        float f4 = n;
        float f5 = f3 / f4;
        float f6 = this.mDefaultScale;
        if (!((double)Math.abs(f5 - f6) > 0.01)) {
            return;
        }
        float f7 = this.mDefaultScale;
        float f8 = f5 / f7;
        this.mNavSlop = n2 = (int)(16.0f * f5);
        DEFAULT_SCALE_PERCENT = (int)(100.0f * f5);
        DEFAULT_MAX_ZOOM_SCALE = 4.0f * f5;
        DEFAULT_MIN_ZOOM_SCALE = 0.25f * f5;
        this.mDefaultScale = f5;
        this.mMaxZoomScale = f2 = this.mMaxZoomScale * f8;
        this.mMinZoomScale = f = this.mMinZoomScale * f8;
        float f9 = this.mActualScale * f8;
        this.setNewZoomScale(f9, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateMultiTouchSupport(Context context) {
        boolean bl;
        WebSettings webSettings = this.getSettings();
        PackageManager packageManager = context.getPackageManager();
        boolean bl2 = packageManager.hasSystemFeature("android.hardware.touchscreen.multitouch") && webSettings.supportZoom() && webSettings.getBuiltInZoomControls();
        this.mSupportMultiTouch = bl2;
        this.mAllowPanAndScale = bl = packageManager.hasSystemFeature("android.hardware.touchscreen.multitouch.distinct");
        if (this.mSupportMultiTouch && this.mScaleDetector == null) {
            ScaleGestureDetector scaleGestureDetector;
            ScaleDetectorListener scaleDetectorListener = new ScaleDetectorListener();
            this.mScaleDetector = scaleGestureDetector = new ScaleGestureDetector(context, scaleDetectorListener);
            return;
        }
        if (this.mSupportMultiTouch) {
            return;
        }
        if (this.mScaleDetector == null) {
            return;
        }
        this.mScaleDetector = null;
    }

    int viewToContentX(int n) {
        return this.viewToContentDimension(n);
    }

    int viewToContentY(int n) {
        int n2 = this.getTitleHeight();
        int n3 = n - n2;
        return this.viewToContentDimension(n3);
    }

    public boolean zoomIn() {
        int n;
        int n2;
        float f;
        float f2;
        this.switchOutDrawHistory();
        this.mInZoomOverview = false;
        this.mZoomCenterX = f2 = (float)this.getViewWidth() * 0.5f;
        this.mZoomCenterY = f = (float)this.getViewHeight() * 0.5f;
        int n3 = (int)this.mZoomCenterX;
        int n4 = this.mScrollX;
        int n5 = n3 + n4;
        this.mAnchorX = n2 = this.viewToContentX(n5);
        int n6 = (int)this.mZoomCenterY;
        int n7 = this.mScrollY;
        int n8 = n6 + n7;
        this.mAnchorY = n = this.viewToContentY(n8);
        float f3 = this.mActualScale * 1.25f;
        return this.zoomWithPreview(f3, true);
    }

    public boolean zoomOut() {
        int n;
        int n2;
        float f;
        float f2;
        this.switchOutDrawHistory();
        this.mZoomCenterX = f2 = (float)this.getViewWidth() * 0.5f;
        this.mZoomCenterY = f = (float)this.getViewHeight() * 0.5f;
        int n3 = (int)this.mZoomCenterX;
        int n4 = this.mScrollX;
        int n5 = n3 + n4;
        this.mAnchorX = n2 = this.viewToContentX(n5);
        int n6 = (int)this.mZoomCenterY;
        int n7 = this.mScrollY;
        int n8 = n6 + n7;
        this.mAnchorY = n = this.viewToContentY(n8);
        float f3 = this.mActualScale * 0.8f;
        return this.zoomWithPreview(f3, true);
    }

    private class InvokeListBox
    implements Runnable {
        private Container[] mContainers;
        private boolean mMultiple;
        private int[] mSelectedArray;
        private int mSelection;

        private InvokeListBox(String[] stringArray, int[] nArray, int n) {
            this.mSelection = n;
            this.mMultiple = false;
            int n2 = stringArray.length;
            Container[] containerArray = new Container[n2];
            this.mContainers = containerArray;
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                String string2;
                Container container;
                Container[] containerArray2 = this.mContainers;
                containerArray2[n3] = container = new Container();
                Container container2 = this.mContainers[n3];
                container2.mString = string2 = stringArray[n3];
                Container container3 = this.mContainers[n3];
                container3.mEnabled = n4 = nArray[n3];
                this.mContainers[n3].mId = n3;
                ++n3;
            }
            return;
        }

        private InvokeListBox(String[] stringArray, int[] nArray, int[] nArray2) {
            this.mMultiple = true;
            this.mSelectedArray = nArray2;
            int n = stringArray.length;
            Container[] containerArray = new Container[n];
            this.mContainers = containerArray;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String string2;
                Container container;
                Container[] containerArray2 = this.mContainers;
                containerArray2[n2] = container = new Container();
                Container container2 = this.mContainers[n2];
                container2.mString = string2 = stringArray[n2];
                Container container3 = this.mContainers[n2];
                container3.mEnabled = n3 = nArray[n2];
                this.mContainers[n2].mId = n2;
                ++n2;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            final ListView listView = (ListView)LayoutInflater.from(WebView.this.mContext).inflate(17367134, null);
            Context context = WebView.this.mContext;
            Container[] containerArray = this.mContainers;
            boolean bl = this.mMultiple;
            final MyArrayListAdapter myArrayListAdapter = new MyArrayListAdapter(context, containerArray, bl);
            Context context2 = WebView.this.mContext;
            AlertDialog.Builder builder = new AlertDialog.Builder(context2).setView(listView).setCancelable(true).setInverseBackgroundForced(true);
            if (this.mMultiple) {
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                    @Override
                    public void onClick(DialogInterface dialogInterface, int n) {
                        WebViewCore webViewCore = WebView.this.mWebViewCore;
                        int n2 = myArrayListAdapter.getCount();
                        SparseBooleanArray sparseBooleanArray = listView.getCheckedItemPositions();
                        webViewCore.sendMessage(123, n2, 0, sparseBooleanArray);
                    }
                };
                AlertDialog.Builder builder2 = builder.setPositiveButton(17039370, onClickListener);
                DialogInterface.OnClickListener onClickListener2 = new DialogInterface.OnClickListener(){

                    @Override
                    public void onClick(DialogInterface dialogInterface, int n) {
                        WebView.this.mWebViewCore.sendMessage(124, -1, 0);
                    }
                };
                AlertDialog.Builder builder3 = builder.setNegativeButton(0x1040000, onClickListener2);
            }
            final AlertDialog alertDialog = builder.create();
            listView.setAdapter(myArrayListAdapter);
            listView.setFocusableInTouchMode(true);
            boolean bl2 = !this.mMultiple;
            listView.setTextFilterEnabled(bl2);
            if (this.mMultiple) {
                listView.setChoiceMode(2);
                for (int n : this.mSelectedArray) {
                    listView.setItemChecked(n, true);
                }
            } else {
                AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                        WebViewCore webViewCore = WebView.this.mWebViewCore;
                        int n2 = (int)l;
                        webViewCore.sendMessage(124, n2, 0);
                        alertDialog.dismiss();
                    }
                };
                listView.setOnItemClickListener(onItemClickListener);
                if (this.mSelection != -1) {
                    int n = this.mSelection;
                    listView.setSelection(n);
                    listView.setChoiceMode(1);
                    int n2 = this.mSelection;
                    listView.setItemChecked(n2, true);
                    int n3 = this.mSelection;
                    long l = myArrayListAdapter.getItemId(n3);
                    InvokeListBox invokeListBox = this;
                    SingleDataSetObserver singleDataSetObserver = invokeListBox.new SingleDataSetObserver(l, listView, myArrayListAdapter);
                    myArrayListAdapter.registerDataSetObserver(singleDataSetObserver);
                }
            }
            DialogInterface.OnCancelListener onCancelListener = new DialogInterface.OnCancelListener(){

                @Override
                public void onCancel(DialogInterface dialogInterface) {
                    WebView.this.mWebViewCore.sendMessage(124, -1, 0);
                }
            };
            alertDialog.setOnCancelListener(onCancelListener);
            alertDialog.show();
        }

        private class SingleDataSetObserver
        extends DataSetObserver {
            private Adapter mAdapter;
            private long mCheckedId;
            private ListView mListView;

            public SingleDataSetObserver(long l, ListView listView, Adapter adapter) {
                this.mCheckedId = l;
                this.mListView = listView;
                this.mAdapter = adapter;
            }

            @Override
            public void onChanged() {
                int n = this.mListView.getCheckedItemPosition();
                long l = this.mAdapter.getItemId(n);
                if (this.mCheckedId == l) {
                    return;
                }
                this.mListView.clearChoices();
                int n2 = this.mAdapter.getCount();
                int n3 = 0;
                while (n3 < n2) {
                    long l2;
                    long l3 = this.mAdapter.getItemId(n3);
                    if (l3 == (l2 = this.mCheckedId)) {
                        this.mListView.setItemChecked(n3, true);
                        return;
                    }
                    ++n3;
                }
                return;
            }

            public void onInvalidate() {
            }
        }

        private class MyArrayListAdapter
        extends ArrayAdapter<Container> {
            /*
             * Enabled aggressive block sorting
             */
            public MyArrayListAdapter(Context context, Container[] containerArray, boolean bl) {
                int n = bl ? 17367059 : 17367058;
                super(context, n, containerArray);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private Container item(int n) {
                if (n < 0) return null;
                int n2 = this.getCount();
                if (n < n2) return (Container)this.getItem(n);
                return null;
            }

            @Override
            public boolean areAllItemsEnabled() {
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getItemId(int n) {
                Container container = this.item(n);
                if (container != null) return container.mId;
                return 65535L;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public View getView(int n, View view, ViewGroup viewGroup) {
                int n2;
                View view2 = super.getView(n, null, viewGroup);
                Container container = this.item(n);
                if (container == null) return view2;
                int n3 = container.mEnabled;
                if (1 == n3) return view2;
                Context context = WebView.this.mContext;
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(1);
                if (n > 0) {
                    Context context2 = WebView.this.mContext;
                    View view3 = new View(context2);
                    view3.setBackgroundResource(17301522);
                    linearLayout.addView(view3);
                }
                if (-1 != (n2 = container.mEnabled)) {
                    Assert.assertTrue(view2 instanceof CheckedTextView);
                    ((CheckedTextView)view2).setCheckMarkDrawable(null);
                } else {
                    view2.setEnabled(false);
                }
                linearLayout.addView(view2);
                int n4 = this.getCount() - 1;
                if (n >= n4) return linearLayout;
                Context context3 = WebView.this.mContext;
                View view4 = new View(context3);
                view4.setBackgroundResource(17301522);
                linearLayout.addView(view4);
                return linearLayout;
            }

            @Override
            public boolean hasStableIds() {
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isEnabled(int n) {
                Container container = this.item(n);
                if (container == null) {
                    return false;
                }
                int n2 = container.mEnabled;
                if (1 == n2) return false;
                return true;
            }
        }

        private class Container {
            static final int OPTGROUP = 255;
            static final int OPTION_DISABLED = 0;
            static final int OPTION_ENABLED = 1;
            int mEnabled;
            int mId;
            String mString;

            private Container() {
            }

            public String toString() {
                return this.mString;
            }
        }
    }

    class PrivateHandler
    extends Handler {
        PrivateHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            if (WebView.this.mWebViewCore == null) {
                return;
            }
            switch (message.what) {
                default: {
                    super.handleMessage(message);
                    return;
                }
                case 1: {
                    WebViewDatabase webViewDatabase = WebView.this.mDatabase;
                    String string2 = message.getData().getString("host");
                    String string3 = message.getData().getString("username");
                    String string4 = message.getData().getString("password");
                    webViewDatabase.setUsernamePassword(string2, string3, string4);
                    ((Message)message.obj).sendToTarget();
                    return;
                }
                case 2: {
                    WebViewDatabase webViewDatabase = WebView.this.mDatabase;
                    String string5 = message.getData().getString("host");
                    webViewDatabase.setUsernamePassword(string5, null, null);
                    ((Message)message.obj).sendToTarget();
                    return;
                }
                case 10: {
                    if (message.arg1 != 0 || WebView.this.mPreventDefault != 1) {
                        if (message.arg1 != 2) {
                            return;
                        }
                        if (WebView.this.mPreventDefault != 2) {
                            return;
                        }
                    }
                    WebView webView = WebView.this;
                    WebView webView2 = WebView.this;
                    int n = (int)WebView.this.mLastTouchX;
                    int n2 = WebView.this.mScrollX;
                    int n3 = n + n2;
                    int n4 = webView2.viewToContentX(n3);
                    WebView webView3 = WebView.this;
                    int n5 = (int)WebView.this.mLastTouchY;
                    int n6 = WebView.this.mScrollY;
                    int n7 = n5 + n6;
                    int n8 = webView3.viewToContentY(n7);
                    webView.cancelWebCoreTouchEvent(n4, n8, true);
                    return;
                }
                case 3: {
                    if (WebView.this.mTouchMode == 1) {
                        if (WebView.this.mPreventDefault != 3) {
                            int n = WebView.access$3002(WebView.this, 4);
                            WebView.this.updateSelection();
                            return;
                        }
                        int n = WebView.access$3002(WebView.this, 5);
                        return;
                    }
                    if (WebView.this.mTouchMode != 6) {
                        return;
                    }
                    int n = WebView.access$3002(WebView.this, 7);
                    return;
                }
                case 4: {
                    if (WebView.this.inFullScreenMode() || WebView.this.mDeferTouchProcess) {
                        boolean bl;
                        int n;
                        int n9;
                        int n10;
                        int n11;
                        WebViewCore.TouchEventData touchEventData = new WebViewCore.TouchEventData();
                        touchEventData.mAction = n11 = 256;
                        WebView webView = WebView.this;
                        int n12 = (int)WebView.this.mLastTouchX;
                        int n13 = WebView.this.mScrollX;
                        int n14 = n12 + n13;
                        touchEventData.mX = n10 = webView.viewToContentX(n14);
                        WebView webView4 = WebView.this;
                        int n15 = (int)WebView.this.mLastTouchY;
                        int n16 = WebView.this.mScrollY;
                        int n17 = n15 + n16;
                        touchEventData.mY = n9 = webView4.viewToContentY(n17);
                        touchEventData.mMetaState = n = 0;
                        touchEventData.mReprocess = bl = WebView.this.mDeferTouchProcess;
                        if (WebView.this.mDeferTouchProcess) {
                            float f;
                            float f2;
                            touchEventData.mViewX = f2 = WebView.this.mLastTouchX;
                            touchEventData.mViewY = f = WebView.this.mLastTouchY;
                        }
                        WebViewCore webViewCore = WebView.this.mWebViewCore;
                        int n18 = 141;
                        WebViewCore.TouchEventData touchEventData2 = touchEventData;
                        webViewCore.sendMessage(n18, touchEventData2);
                        return;
                    }
                    if (WebView.this.mPreventDefault == 3) {
                        return;
                    }
                    int n = WebView.access$3002(WebView.this, 7);
                    boolean bl = WebView.this.performLongClick();
                    WebView.this.rebuildWebTextView();
                    return;
                }
                case 5: {
                    WebView.this.doShortPress();
                    return;
                }
                case 102: {
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    int n19 = message.arg2;
                    boolean bl = (Boolean)message.obj;
                    boolean bl2 = webView.setContentScrollBy(n, n19, bl);
                    return;
                }
                case 104: {
                    if (WebView.this.mUserScroll) {
                        boolean bl = WebView.access$5002(WebView.this, false);
                        return;
                    }
                }
                case 101: {
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    int n20 = message.arg2;
                    if (!webView.setContentScrollTo(n, n20)) {
                        return;
                    }
                    boolean bl = WebView.access$5002(WebView.this, false);
                    WebViewCore webViewCore = WebView.this.mWebViewCore;
                    int n21 = message.arg1;
                    int n22 = message.arg2;
                    webViewCore.sendMessage(131, n21, n22);
                    return;
                }
                case 103: {
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    int n23 = message.arg2;
                    webView.spawnContentScrollTo(n, n23);
                    return;
                }
                case 109: {
                    WebViewCore.RestoreState restoreState = (WebViewCore.RestoreState)message.obj;
                    WebView webView = WebView.this;
                    int n = WebView.this.getViewWidth();
                    int n24 = restoreState.mScrollX;
                    WebView webView5 = webView;
                    WebViewCore.RestoreState restoreState2 = restoreState;
                    int n25 = n;
                    int n26 = n24;
                    boolean bl = false;
                    webView5.updateZoomRange(restoreState2, n25, n26, bl);
                    return;
                }
                case 105: {
                    float f;
                    float f3;
                    float f4;
                    float f5;
                    int n;
                    int n27;
                    int n28;
                    int n29;
                    if (WebView.this.mDelayedDeleteRootLayer) {
                        boolean bl = WebView.access$5402(WebView.this, false);
                        WebView.this.nativeSetRootLayer(0);
                    }
                    WebSettings webSettings = WebView.this.mWebViewCore.getSettings();
                    int n30 = WebView.this.getViewWidth();
                    WebViewCore.DrawData drawData = (WebViewCore.DrawData)message.obj;
                    Point point = drawData.mViewPoint;
                    boolean bl = webSettings.getUseWideViewPort();
                    WebViewCore.RestoreState restoreState = drawData.mRestoreState;
                    boolean bl3 = restoreState != null;
                    if (bl3) {
                        WebView webView = WebView.this;
                        int n31 = point.x;
                        int n32 = drawData.mMinPrefWidth;
                        WebView webView6 = webView;
                        WebViewCore.RestoreState restoreState3 = restoreState;
                        int n33 = n31;
                        int n34 = n32;
                        boolean bl4 = true;
                        webView6.updateZoomRange(restoreState3, n33, n34, bl4);
                        if (!WebView.this.mDrawHistory) {
                            WebView.this.mInZoomOverview = false;
                            if (WebView.this.mInitialScaleInPercent > 0) {
                                float f6;
                                WebView webView7 = WebView.this;
                                float f7 = (float)WebView.this.mInitialScaleInPercent / 100.0f;
                                float f8 = WebView.this.mInitialScaleInPercent;
                                boolean bl5 = f8 != (f6 = WebView.this.mTextWrapScale * 100.0f);
                                webView7.setNewZoomScale(f7, bl5, false);
                            } else if (restoreState.mViewScale > 0.0f) {
                                float f9;
                                WebView webView8 = WebView.this;
                                webView8.mTextWrapScale = f9 = restoreState.mTextWrapScale;
                                WebView webView9 = WebView.this;
                                float f10 = restoreState.mViewScale;
                                webView9.setNewZoomScale(f10, false, false);
                            } else {
                                float f11;
                                WebView webView10 = WebView.this;
                                boolean bl6 = bl && webSettings.getLoadWithOverviewMode();
                                webView10.mInZoomOverview = bl6;
                                float f12 = WebView.this.mInZoomOverview ? (float)n30 / 800.0f : restoreState.mTextWrapScale;
                                WebView webView11 = WebView.this;
                                float f13 = WebView.this.mTextWrapScale;
                                float f14 = Math.abs(f12 - f13);
                                float f15 = f14 >= (f11 = MINIMUM_SCALE_INCREMENT) ? Float.MIN_VALUE : 0.0f;
                                WebView webView12 = webView11;
                                float f16 = f12;
                                float f17 = f15;
                                boolean bl7 = false;
                                webView12.setNewZoomScale(f16, (boolean)f17, bl7);
                            }
                            WebView webView13 = WebView.this;
                            int n35 = restoreState.mScrollX;
                            int n36 = restoreState.mScrollY;
                            boolean bl8 = webView13.setContentScrollTo(n35, n36);
                            WebView.this.clearTextEntry(false);
                            if (WebView.this.getSettings().getBuiltInZoomControls()) {
                                WebView.this.updateZoomButtonsEnabled();
                            }
                        }
                    }
                    boolean bl9 = (n29 = point.x) != (n28 = WebView.this.mLastWidthSent) && (n27 = point.y) != (n = WebView.this.mLastHeightSent);
                    WebView webView = WebView.this;
                    int n37 = drawData.mWidthHeight.x;
                    int n38 = drawData.mWidthHeight.y;
                    int n39 = WebView.this.mFindIsUp ? WebView.this.mFindHeight : 0;
                    int n40 = n38 + n39;
                    WebView webView14 = webView;
                    int n41 = n37;
                    int n42 = n40;
                    boolean bl10 = bl9;
                    webView14.recordNewContentSize(n41, n42, bl10);
                    WebView webView15 = WebView.this;
                    Rect rect = drawData.mInvalRegion.getBounds();
                    webView15.invalidateContentRect(rect);
                    if (WebView.this.mPictureListener != null) {
                        PictureListener pictureListener = WebView.this.mPictureListener;
                        WebView webView16 = WebView.this;
                        Picture picture = WebView.this.capturePicture();
                        pictureListener.onNewPicture(webView16, picture);
                    }
                    if (bl) {
                        int n43;
                        WebView webView17 = WebView.this;
                        int n44 = sMaxViewportWidth;
                        float f18 = n30;
                        float f19 = WebView.this.mDefaultScale;
                        int n45 = (int)(f18 / f19);
                        int n46 = drawData.mMinPrefWidth;
                        int n47 = drawData.mViewPoint.x;
                        int n48 = Math.max(n46, n47);
                        int n49 = Math.max(n45, n48);
                        webView17.mZoomOverviewWidth = n43 = Math.min(n44, n49);
                    }
                    if (!WebView.this.mMinZoomScaleFixed) {
                        WebView webView18 = WebView.this;
                        float f20 = n30;
                        float f21 = WebView.this.mZoomOverviewWidth;
                        float f22 = f20 / f21;
                        float f23 = WebView.access$2702(webView18, f22);
                    }
                    if (!WebView.this.mDrawHistory && WebView.this.mInZoomOverview && Math.abs((f5 = (f4 = (float)n30) * (f3 = WebView.this.mInvActualScale)) - (f = (float)WebView.this.mZoomOverviewWidth)) > 1.0f) {
                        float f24;
                        float f25;
                        WebView webView19 = WebView.this;
                        float f26 = n30;
                        float f27 = WebView.this.mZoomOverviewWidth;
                        float f28 = f26 / f27;
                        float f29 = WebView.this.mActualScale;
                        float f30 = Math.abs(f29 - (f25 = WebView.this.mTextWrapScale));
                        boolean bl11 = f30 < (f24 = MINIMUM_SCALE_INCREMENT);
                        webView19.setNewZoomScale(f28, bl11, false);
                    }
                    if (drawData.mFocusSizeChanged && WebView.this.inEditingMode()) {
                        boolean bl12 = WebView.access$6702(WebView.this, true);
                    }
                    if (!bl3) {
                        return;
                    }
                    WebView.this.mViewManager.postReadyToDrawAll();
                    return;
                }
                case 107: {
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    webView.nativeCreate(n);
                    return;
                }
                case 108: {
                    int n;
                    if (!WebView.this.inEditingMode()) {
                        return;
                    }
                    WebTextView webTextView = WebView.this.mWebTextView;
                    if (!webTextView.isSameTextField(n = message.arg1)) {
                        return;
                    }
                    if (message.getData().getBoolean("password")) {
                        Editable editable = WebView.this.mWebTextView.getText();
                        int n50 = Selection.getSelectionStart(editable);
                        int n51 = Selection.getSelectionEnd(editable);
                        WebView.this.mWebTextView.setInPassword(true);
                        Editable editable2 = WebView.this.mWebTextView.getText();
                        int n52 = n50;
                        int n53 = n51;
                        Selection.setSelection(editable2, n52, n53);
                        return;
                    }
                    int n54 = message.arg2;
                    int n55 = WebView.this.mTextGeneration;
                    if (n54 != n55) {
                        return;
                    }
                    WebTextView webTextView2 = WebView.this.mWebTextView;
                    String string6 = (String)message.obj;
                    WebTextView webTextView3 = webTextView2;
                    String string7 = string6;
                    webTextView3.setTextAndKeepSelection(string7);
                    return;
                }
                case 128: {
                    WebView.this.displaySoftKeyboard(true);
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    int n56 = message.arg2;
                    WebViewCore.TextSelectionData textSelectionData = (WebViewCore.TextSelectionData)message.obj;
                    WebView webView20 = webView;
                    int n57 = n;
                    int n58 = n56;
                    WebViewCore.TextSelectionData textSelectionData2 = textSelectionData;
                    webView20.updateTextSelectionFromMessage(n57, n58, textSelectionData2);
                    return;
                }
                case 112: {
                    WebView.this.rebuildWebTextView();
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    int n59 = message.arg2;
                    WebViewCore.TextSelectionData textSelectionData = (WebViewCore.TextSelectionData)message.obj;
                    WebView webView21 = webView;
                    int n60 = n;
                    int n61 = n59;
                    WebViewCore.TextSelectionData textSelectionData3 = textSelectionData;
                    webView21.updateTextSelectionFromMessage(n60, n61, textSelectionData3);
                    return;
                }
                case 125: {
                    int n;
                    if (!WebView.this.inEditingMode()) {
                        return;
                    }
                    WebTextView webTextView = WebView.this.mWebTextView;
                    if (!webTextView.isSameTextField(n = message.arg1)) {
                        return;
                    }
                    WebTextView webTextView4 = WebView.this.mWebTextView;
                    String string8 = (String)message.obj;
                    WebTextView webTextView5 = webTextView4;
                    String string9 = string8;
                    webTextView5.setHint(string9);
                    InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                    if (inputMethodManager == null) {
                        return;
                    }
                    InputMethodManager inputMethodManager2 = inputMethodManager;
                    WebTextView webTextView6 = WebView.this.mWebTextView;
                    WebTextView webTextView7 = webTextView6;
                    if (!inputMethodManager2.isActive(webTextView7)) {
                        return;
                    }
                    WebTextView webTextView8 = WebView.this.mWebTextView;
                    InputMethodManager inputMethodManager3 = inputMethodManager;
                    WebTextView webTextView9 = webTextView8;
                    inputMethodManager3.restartInput(webTextView9);
                    return;
                }
                case 110: {
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    boolean bl = webView.navHandledKey(n, 1, false, 0L);
                    return;
                }
                case 106: {
                    WebView.this.selectionDone();
                    if (!WebView.this.inEditingMode()) {
                        return;
                    }
                    if (!WebView.this.nativeCursorIsTextInput()) {
                        return;
                    }
                    WebView.this.mWebTextView.bringIntoView();
                    WebView.this.rebuildWebTextView();
                    return;
                }
                case 111: {
                    WebView.this.clearTextEntry(false);
                    return;
                }
                case 117: {
                    Rect rect = (Rect)message.obj;
                    if (rect == null) {
                        WebView.this.invalidate();
                        return;
                    }
                    WebView webView = WebView.this;
                    int n = rect.left;
                    int n62 = rect.top;
                    int n63 = rect.right;
                    int n64 = rect.bottom;
                    webView.viewInvalidate(n, n62, n63, n64);
                    return;
                }
                case 123: {
                    WebView.this.invalidate();
                    return;
                }
                case 124: {
                    if (message.arg1 == 0) {
                        boolean bl = WebView.access$5402(WebView.this, true);
                        return;
                    }
                    boolean bl = WebView.access$5402(WebView.this, false);
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    webView.nativeSetRootLayer(n);
                    WebView.this.invalidate();
                    return;
                }
                case 6: {
                    WebTextView.AutoCompleteAdapter autoCompleteAdapter = (WebTextView.AutoCompleteAdapter)message.obj;
                    WebTextView webTextView = WebView.this.mWebTextView;
                    int n = message.arg1;
                    if (!webTextView.isSameTextField(n)) {
                        return;
                    }
                    WebView.this.mWebTextView.setAdapterCustom(autoCompleteAdapter);
                    return;
                }
                case 7: {
                    WebViewCore.resumePriority();
                    WebViewCore.resumeUpdatePicture(WebView.this.mWebViewCore);
                    return;
                }
                case 114: {
                    boolean bl = WebView.access$7502(WebView.this, false);
                    boolean bl13 = WebView.access$7602(WebView.this, false);
                    boolean bl14 = WebView.this.performLongClick();
                    return;
                }
                case 116: {
                    WebView webView = WebView.this;
                    boolean bl = message.arg1 != 0;
                    boolean bl15 = WebView.access$7702(webView, bl);
                    return;
                }
                case 115: {
                    if (WebView.this.inFullScreenMode()) {
                        return;
                    }
                    if (message.obj == null) {
                        if (message.arg1 == 0 && WebView.this.mPreventDefault == 1) {
                            WebView webView = WebView.this;
                            int n = message.arg2 == 1 ? 3 : 2;
                            int n65 = WebView.access$3702(webView, n);
                            return;
                        }
                        if (message.arg1 != 2) {
                            return;
                        }
                        if (WebView.this.mPreventDefault != 2) {
                            return;
                        }
                        WebView webView = WebView.this;
                        int n = message.arg2 == 1 ? 3 : 0;
                        int n66 = WebView.access$3702(webView, n);
                        return;
                    }
                    if (message.arg2 != 0) {
                        return;
                    }
                    WebViewCore.TouchEventData touchEventData = (WebViewCore.TouchEventData)message.obj;
                    switch (touchEventData.mAction) {
                        default: {
                            return;
                        }
                        case 0: {
                            WebView webView = WebView.this;
                            float f = touchEventData.mViewX;
                            float f31 = WebView.access$7802(webView, f);
                            WebView webView22 = WebView.this;
                            float f32 = touchEventData.mViewY;
                            float f33 = WebView.access$7902(webView22, f32);
                            int n = WebView.access$8002(WebView.this, 1);
                            return;
                        }
                        case 2: {
                            if (WebView.this.mDeferTouchMode != 3) {
                                int n = WebView.access$8002(WebView.this, 3);
                                WebView webView = WebView.this;
                                float f = touchEventData.mViewX;
                                float f34 = WebView.access$7802(webView, f);
                                WebView webView23 = WebView.this;
                                float f35 = touchEventData.mViewY;
                                float f36 = WebView.access$7902(webView23, f35);
                                WebView.this.startDrag();
                            }
                            WebView webView = WebView.this;
                            float f = WebView.this.mScrollX;
                            float f37 = WebView.this.mLastDeferTouchX;
                            float f38 = f + f37;
                            float f39 = touchEventData.mViewX;
                            int n = (int)(f38 - f39);
                            int n67 = webView.pinLocX(n);
                            int n68 = WebView.this.mScrollX;
                            int n69 = n67 - n68;
                            WebView webView24 = WebView.this;
                            float f40 = WebView.this.mScrollY;
                            float f41 = WebView.this.mLastDeferTouchY;
                            float f42 = f40 + f41;
                            float f43 = touchEventData.mViewY;
                            int n70 = (int)(f42 - f43);
                            int n71 = webView24.pinLocY(n70);
                            int n72 = WebView.this.mScrollY;
                            int n73 = n71 - n72;
                            WebView.this.doDrag(n69, n73);
                            if (n69 != 0) {
                                WebView webView25 = WebView.this;
                                float f44 = touchEventData.mViewX;
                                float f45 = WebView.access$7802(webView25, f44);
                            }
                            if (n73 == 0) {
                                return;
                            }
                            WebView webView26 = WebView.this;
                            float f46 = touchEventData.mViewY;
                            float f47 = WebView.access$7902(webView26, f46);
                            return;
                        }
                        case 1: 
                        case 3: {
                            if (WebView.this.mDeferTouchMode == 3) {
                                OverScroller overScroller = WebView.this.mScroller;
                                int n = WebView.this.mScrollX;
                                int n74 = WebView.this.mScrollY;
                                int n75 = WebView.this.computeMaxScrollX();
                                int n76 = WebView.this.computeMaxScrollY();
                                boolean bl = overScroller.springBack(n, n74, 0, n75, 0, n76);
                                WebView.this.invalidate();
                                WebViewCore.resumePriority();
                                WebViewCore.resumeUpdatePicture(WebView.this.mWebViewCore);
                            }
                            int n = WebView.access$8002(WebView.this, 7);
                            return;
                        }
                        case 512: {
                            WebView webView = WebView.this;
                            float f = touchEventData.mViewX;
                            float f48 = WebView.access$3802(webView, f);
                            WebView webView27 = WebView.this;
                            float f49 = touchEventData.mViewY;
                            float f50 = WebView.access$4002(webView27, f49);
                            WebView.this.doDoubleTap();
                            int n = WebView.access$8002(WebView.this, 7);
                            return;
                        }
                        case 256: 
                    }
                    HitTestResult hitTestResult = WebView.this.getHitTestResult();
                    if (hitTestResult != null && hitTestResult.mType != 0) {
                        boolean bl = WebView.this.performLongClick();
                        WebView.this.rebuildWebTextView();
                    }
                    int n = WebView.access$8002(WebView.this, 7);
                    return;
                }
                case 118: {
                    if (message.arg1 == 0) {
                        WebView.this.hideSoftKeyboard();
                        return;
                    }
                    WebView.this.displaySoftKeyboard(false);
                    return;
                }
                case 126: {
                    if (!WebView.this.mFindIsUp) {
                        return;
                    }
                    WebView webView = WebView.this;
                    String string10 = WebView.this.mLastFind;
                    int n = webView.findAll(string10);
                    return;
                }
                case 8: {
                    int n = WebView.access$9802(WebView.this, 2);
                    WebView.this.invalidate();
                }
                case 9: {
                    if (WebView.this.mTouchMode != 3) {
                        return;
                    }
                    if (WebView.this.mHeldMotionless != 2) {
                        return;
                    }
                    WebView webView = WebView.this;
                    int n = ViewConfiguration.getScrollDefaultDelay();
                    boolean bl = webView.awakenScrollBars(n, false);
                    Handler handler = WebView.this.mPrivateHandler;
                    Message message2 = WebView.this.mPrivateHandler.obtainMessage(9);
                    long l = ViewConfiguration.getScrollDefaultDelay();
                    boolean bl16 = handler.sendMessageDelayed(message2, l);
                    return;
                }
                case 119: {
                    WebView webView = WebView.this;
                    int n = message.arg1;
                    int n77 = message.arg2;
                    webView.doMotionUp(n, n77);
                    return;
                }
                case 120: {
                    PluginFullScreenHolder pluginFullScreenHolder;
                    View view = (View)message.obj;
                    int n = message.arg1;
                    if (WebView.this.mFullScreenHolder != null) {
                        int n78 = Log.w(WebView.LOGTAG, "Should not have another full screen.");
                        WebView.this.mFullScreenHolder.dismiss();
                    }
                    WebView webView = WebView.this;
                    WebView webView28 = WebView.this;
                    PluginFullScreenHolder pluginFullScreenHolder2 = pluginFullScreenHolder;
                    WebView webView29 = webView28;
                    int n79 = n;
                    pluginFullScreenHolder2(webView29, n79);
                    webView.mFullScreenHolder = pluginFullScreenHolder;
                    PluginFullScreenHolder pluginFullScreenHolder3 = WebView.this.mFullScreenHolder;
                    View view2 = view;
                    pluginFullScreenHolder3.setContentView(view2);
                    WebView.this.mFullScreenHolder.setCancelable(false);
                    WebView.this.mFullScreenHolder.setCanceledOnTouchOutside(false);
                    WebView.this.mFullScreenHolder.show();
                    return;
                }
                case 121: {
                    if (!WebView.this.inFullScreenMode()) {
                        return;
                    }
                    WebView.this.mFullScreenHolder.dismiss();
                    WebView.this.mFullScreenHolder = null;
                    return;
                }
                case 122: {
                    if (!WebView.this.inEditingMode()) {
                        return;
                    }
                    WebView.this.nativeClearCursor();
                    WebView.this.rebuildWebTextView();
                    return;
                }
                case 113: {
                    int n;
                    WebViewCore.ShowRectData showRectData = (WebViewCore.ShowRectData)message.obj;
                    int n80 = WebView.this.mScrollX;
                    WebView webView = WebView.this;
                    int n81 = showRectData.mLeft;
                    int n82 = webView.contentToViewX(n81);
                    WebView webView30 = WebView.this;
                    int n83 = showRectData.mWidth;
                    int n84 = webView30.contentToViewDimension(n83);
                    WebView webView31 = WebView.this;
                    int n85 = showRectData.mContentWidth;
                    int n86 = webView31.contentToViewDimension(n85);
                    int n87 = WebView.this.getViewWidth();
                    int n88 = n84;
                    int n89 = n87;
                    if (n88 < n89) {
                        int n90 = n84 / 2 + n82;
                        int n91 = WebView.this.mScrollX;
                        int n92 = n90 - n91;
                        int n93 = n87 / 2;
                        int n94 = n92 - n93;
                        n = n80 + n94;
                    } else {
                        float f = n82;
                        float f51 = showRectData.mXPercentInDoc;
                        float f52 = n84;
                        float f53 = f51 * f52;
                        float f54 = f + f53;
                        float f55 = WebView.this.mScrollX;
                        float f56 = f54 - f55;
                        float f57 = showRectData.mXPercentInView;
                        float f58 = n87;
                        float f59 = f57 * f58;
                        int n95 = (int)(f56 - f59);
                        n = n80 + n95;
                    }
                    int n96 = n + n87;
                    int n97 = n86;
                    int n98 = n96;
                    int n99 = Math.min(n97, n98) - n87;
                    int n100 = Math.max(0, n99);
                    WebView webView32 = WebView.this;
                    int n101 = showRectData.mTop;
                    int n102 = webView32.contentToViewY(n101);
                    WebView webView33 = WebView.this;
                    int n103 = showRectData.mHeight;
                    int n104 = webView33.contentToViewDimension(n103);
                    WebView webView34 = WebView.this;
                    int n105 = showRectData.mContentHeight;
                    int n106 = webView34.contentToViewDimension(n105);
                    int n107 = WebView.this.getViewHeight();
                    float f = n102;
                    float f60 = showRectData.mYPercentInDoc;
                    float f61 = n104;
                    float f62 = f60 * f61;
                    float f63 = f + f62;
                    float f64 = showRectData.mYPercentInView;
                    float f65 = n107;
                    float f66 = f64 * f65;
                    int n108 = (int)(f63 - f66) + n107;
                    int n109 = n106;
                    int n110 = n108;
                    int n111 = Math.min(n109, n110) - n107;
                    int n112 = Math.max(0, n111);
                    int n113 = WebView.this.getVisibleTitleHeight();
                    int n114 = n112 - n113;
                    int n115 = Math.max(0, n114);
                    WebView webView35 = WebView.this;
                    int n116 = n100;
                    int n117 = n115;
                    webView35.scrollTo(n116, n117);
                    return;
                }
                case 127: {
                    Rect rect = (Rect)message.obj;
                    WebView.this.mInZoomOverview = false;
                    WebView webView = WebView.this;
                    int n = rect.left;
                    int n118 = rect.top;
                    int n119 = rect.width();
                    int n120 = rect.height();
                    webView.centerFitRect(n, n118, n119, n120);
                    return;
                }
                case 129: 
            }
            WebView webView = WebView.this;
            int n = message.arg1;
            int n121 = WebView.access$10502(webView, n);
            WebView webView36 = WebView.this;
            int n122 = message.arg2;
            int n123 = WebView.access$10602(webView36, n122);
        }
    }

    private class ScaleDetectorListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private ScaleDetectorListener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            float f;
            float f2;
            float f3;
            float f4 = scaleGestureDetector.getScaleFactor();
            float f5 = (float)((double)Math.round(f4 * (f3 = WebView.this.mActualScale) * 100.0f) / 100.0);
            float f6 = Math.abs(f5 - (f2 = WebView.this.mActualScale));
            if (!(f6 >= (f = MINIMUM_SCALE_INCREMENT))) {
                return false;
            }
            boolean bl = WebView.access$2002(WebView.this, true);
            float f7 = WebView.this.mActualScale;
            if (f5 > f7) {
                float f8 = WebView.this.mActualScale * 1.25f;
                f5 = Math.min(f5, f8);
            } else {
                float f9 = WebView.this.mActualScale * 0.8f;
                f5 = Math.max(f5, f9);
            }
            WebView webView = WebView.this;
            float f10 = scaleGestureDetector.getFocusX();
            float f11 = WebView.access$2202(webView, f10);
            WebView webView2 = WebView.this;
            float f12 = scaleGestureDetector.getFocusY();
            float f13 = WebView.access$2502(webView2, f12);
            WebView.this.setNewZoomScale(f5, false, false);
            WebView.this.invalidate();
            return true;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            WebView.this.cancelTouch();
            WebView.this.dismissZoomControl();
            WebView.this.mInZoomOverview = false;
            if (WebView.this.inEditingMode() && WebView.this.nativeFocusCandidateIsPassword()) {
                WebView.this.mWebTextView.setInPassword(false);
            }
            WebView.this.mViewManager.startZoom();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            if (WebView.this.mPreviewZoomOnly) {
                double d;
                double d2;
                double d3;
                float f;
                float f2;
                boolean bl = WebView.access$2002(WebView.this, false);
                WebView webView = WebView.this;
                WebView webView2 = WebView.this;
                int n = (int)WebView.this.mZoomCenterX;
                int n2 = WebView.this.mScrollX;
                int n3 = n + n2;
                int n4 = webView2.viewToContentX(n3);
                int n5 = WebView.access$2102(webView, n4);
                WebView webView3 = WebView.this;
                WebView webView4 = WebView.this;
                int n6 = (int)WebView.this.mZoomCenterY;
                int n7 = WebView.this.mScrollY;
                int n8 = n6 + n7;
                int n9 = webView4.viewToContentY(n8);
                int n10 = WebView.access$2402(webView3, n9);
                float f3 = WebView.this.mActualScale;
                float f4 = f3 - (f2 = WebView.this.mMinZoomScale);
                boolean bl2 = f4 <= (f = MINIMUM_SCALE_INCREMENT) || (d3 = (double)WebView.this.mActualScale) <= (d2 = 0.8 * (d = (double)WebView.this.mTextWrapScale));
                WebView webView5 = WebView.this;
                float f5 = WebView.this.mActualScale;
                webView5.setNewZoomScale(f5, bl2, true);
                WebView.this.invalidate();
            }
            if (WebView.this.inEditingMode() && WebView.this.didUpdateTextViewBounds(false) && WebView.this.nativeFocusCandidateIsPassword()) {
                WebView.this.mWebTextView.setInPassword(true);
            }
            int n = WebView.access$3002(WebView.this, 8);
            boolean bl = WebView.access$3102(WebView.this, true);
            WebView webView = WebView.this;
            float f = scaleGestureDetector.getFocusX();
            float f6 = scaleGestureDetector.getFocusY();
            long l = WebView.this.mLastTouchTime;
            webView.startTouch(f, f6, l);
            WebView.this.mViewManager.endZoom();
        }
    }

    public static class DragTracker {
        public void onBitmapChange(Bitmap bitmap) {
        }

        public void onDraw(Canvas canvas) {
        }

        public void onStartDrag(float f, float f2) {
        }

        public void onStopDrag() {
        }

        public boolean onStretchChange(float f, float f2) {
            return false;
        }
    }

    private class DragTrackerHandler {
        private static final int ANIMATING_STATE = 1;
        private static final int DRAGGING_STATE = 0;
        private static final int FINISHED_STATE = 2;
        private float mCurrStretchX;
        private float mCurrStretchY;
        private Interpolator mInterp;
        private final float mMaxDX;
        private final float mMaxDY;
        private final float mMinDX;
        private final float mMinDY;
        private final DragTracker mProxy;
        private int mSX;
        private int mSY;
        private final float mStartX;
        private final float mStartY;
        private int mState;
        private float[] mXY;

        public DragTrackerHandler(float f, float f2, DragTracker dragTracker) {
            float f3;
            float f4;
            float f5;
            float f6;
            float[] fArray = new float[2];
            this.mXY = fArray;
            this.mProxy = dragTracker;
            int n = WebView.this.computeRealVerticalScrollRange();
            int n2 = WebView.this.getTitleHeight();
            int n3 = n + n2;
            int n4 = WebView.this.getScrollY();
            int n5 = WebView.this.getHeight();
            int n6 = n4 + n5;
            this.mStartY = f2;
            this.mMinDY = f6 = (float)(-n4);
            this.mMaxDY = f5 = (float)(n3 - n6);
            int n7 = WebView.this.computeRealHorizontalScrollRange();
            int n8 = WebView.this.getScrollX();
            int n9 = WebView.this.getWidth();
            int n10 = n8 + n9;
            this.mStartX = f;
            this.mMinDX = f4 = (float)(-n8);
            this.mMaxDX = f3 = (float)(n7 - n10);
            this.mState = 0;
            this.mProxy.onStartDrag(f, f2);
            this.mSX = -99999;
        }

        private void buildBitmap(int n, int n2) {
            int n3 = WebView.this.getWidth();
            int n4 = WebView.this.getViewHeight();
            Bitmap.Config config = this.offscreenBitmapConfig();
            Bitmap bitmap = Bitmap.createBitmap(n3, n4, config);
            Canvas canvas = new Canvas(bitmap);
            float f = -n;
            float f2 = -n2;
            canvas.translate(f, f2);
            WebView.this.drawContent(canvas);
            this.mProxy.onBitmapChange(bitmap);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private float computeStretch(float f, float f2, float f3) {
            float f4 = 0.0f;
            if (!(f3 - f2 > 4.0f)) return f4;
            if (f < f2) {
                return f - f2;
            }
            if (!(f > f3)) return f4;
            return f - f3;
        }

        private int hiddenHeightOfTitleBar() {
            int n = WebView.this.getTitleHeight();
            int n2 = WebView.this.getVisibleTitleHeight();
            return n - n2;
        }

        private Bitmap.Config offscreenBitmapConfig() {
            return Bitmap.Config.RGB_565;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void dragTo(float f, float f2) {
            float f3 = this.mStartY - f2;
            float f4 = this.mMinDY;
            float f5 = this.mMaxDY;
            float f6 = this.computeStretch(f3, f4, f5);
            float f7 = this.mStartX - f;
            float f8 = this.mMinDX;
            float f9 = this.mMaxDX;
            float f10 = this.computeStretch(f7, f8, f9);
            if ((WebView.this.mSnapScrollMode & 2) != 0) {
                f6 = 0.0f;
            } else if ((WebView.this.mSnapScrollMode & 4) != 0) {
                f10 = 0.0f;
            }
            if (this.mCurrStretchX == f10 && this.mCurrStretchY == f6) {
                return;
            }
            this.mCurrStretchX = f10;
            this.mCurrStretchY = f6;
            if (!this.mProxy.onStretchChange(f10, f6)) {
                return;
            }
            WebView.this.invalidate();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean draw(Canvas canvas) {
            if (this.mCurrStretchX == 0.0f) {
                if (this.mCurrStretchY == 0.0f) return false;
            }
            int n = WebView.this.getScrollX();
            int n2 = WebView.this.getScrollY();
            int n3 = this.hiddenHeightOfTitleBar();
            int n4 = n2 - n3;
            if (this.mSX == n || this.mSY != n4) {
                this.buildBitmap(n, n4);
                this.mSX = n;
                this.mSY = n4;
            }
            if (this.mState == 1) {
                Interpolator.Result result;
                Interpolator interpolator = this.mInterp;
                float[] fArray = this.mXY;
                Interpolator.Result result2 = interpolator.timeToValues(fArray);
                if (result2 == (result = Interpolator.Result.FREEZE_END)) {
                    this.mState = 2;
                    return false;
                }
                DragTracker dragTracker = this.mProxy;
                float f = this.mXY[0];
                float f2 = this.mXY[1];
                boolean bl = dragTracker.onStretchChange(f, f2);
                WebView.this.invalidate();
            }
            int n5 = canvas.save(1);
            float f = n;
            float f3 = n4;
            canvas.translate(f, f3);
            this.mProxy.onDraw(canvas);
            canvas.restoreToCount(n5);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isFinished() {
            if (this.mState != 2) return false;
            return true;
        }

        public void stopDrag() {
            float f;
            float f2;
            Interpolator interpolator;
            int n = (int)SystemClock.uptimeMillis();
            this.mInterp = interpolator = new Interpolator(2);
            float[] fArray = this.mXY;
            fArray[0] = f2 = this.mCurrStretchX;
            float[] fArray2 = this.mXY;
            fArray2[1] = f = this.mCurrStretchY;
            float[] fArray3 = new float[]{0.0f, 0x3F000000, 1061158912, 1065353216};
            Interpolator interpolator2 = this.mInterp;
            float[] fArray4 = this.mXY;
            interpolator2.setKeyFrame(0, n, fArray4, fArray3);
            float[] fArray5 = new float[]{0.0f, 0.0f};
            Interpolator interpolator3 = this.mInterp;
            int n2 = n + 200;
            interpolator3.setKeyFrame(1, n2, fArray5, null);
            this.mState = 1;
        }
    }

    private static class PostScale
    implements Runnable {
        final boolean mUpdateTextWrap;
        final WebView mWebView;

        public PostScale(WebView webView, boolean bl) {
            this.mWebView = webView;
            this.mUpdateTextWrap = bl;
        }

        @Override
        public void run() {
            if (this.mWebView.mWebViewCore == null) {
                return;
            }
            WebView webView = this.mWebView;
            float f = this.mWebView.mActualScale;
            boolean bl = this.mUpdateTextWrap;
            webView.setNewZoomScale(f, bl, true);
            if (!this.mWebView.getSettings().getBuiltInZoomControls()) {
                return;
            }
            this.mWebView.updateZoomButtonsEnabled();
        }
    }

    private class RequestFormData
    implements Runnable {
        private String mName;
        private Message mUpdateMessage;
        private String mUrl;

        public RequestFormData(String string2, String string3, Message message) {
            this.mName = string2;
            this.mUrl = string3;
            this.mUpdateMessage = message;
        }

        @Override
        public void run() {
            String string2;
            String string3;
            WebViewDatabase webViewDatabase = WebView.this.mDatabase;
            ArrayList<String> arrayList = webViewDatabase.getFormData(string3 = this.mUrl, string2 = this.mName);
            if (arrayList.size() <= 0) {
                return;
            }
            Context context = WebView.this.mContext;
            WebTextView.AutoCompleteAdapter autoCompleteAdapter = new WebTextView.AutoCompleteAdapter(context, arrayList);
            this.mUpdateMessage.obj = autoCompleteAdapter;
            this.mUpdateMessage.sendToTarget();
        }
    }

    static class ViewSizeData {
        int mAnchorX;
        int mAnchorY;
        int mHeight;
        boolean mIgnoreHeight;
        float mScale;
        int mTextWrapWidth;
        int mWidth;

        ViewSizeData() {
        }
    }

    public class HitTestResult {
        public static final int ANCHOR_TYPE = 1;
        public static final int EDIT_TEXT_TYPE = 9;
        public static final int EMAIL_TYPE = 4;
        public static final int GEO_TYPE = 3;
        public static final int IMAGE_ANCHOR_TYPE = 6;
        public static final int IMAGE_TYPE = 5;
        public static final int PHONE_TYPE = 2;
        public static final int SRC_ANCHOR_TYPE = 7;
        public static final int SRC_IMAGE_ANCHOR_TYPE = 8;
        public static final int UNKNOWN_TYPE;
        private String mExtra;
        private int mType = 0;

        HitTestResult() {
        }

        private void setExtra(String string2) {
            this.mExtra = string2;
        }

        private void setType(int n) {
            this.mType = n;
        }

        public String getExtra() {
            return this.mExtra;
        }

        public int getType() {
            return this.mType;
        }
    }

    public static interface PictureListener {
        public void onNewPicture(WebView var1, Picture var2);
    }

    public class WebViewTransport {
        private WebView mWebview;

        public WebView getWebView() {
            synchronized (this) {
                WebView webView = this.mWebview;
                return webView;
            }
        }

        public void setWebView(WebView webView) {
            synchronized (this) {
                this.mWebview = webView;
                return;
            }
        }
    }

    private static class ExtendedZoomControls
    extends FrameLayout {
        ZoomControls mPlusMinusZoomControls;

        public ExtendedZoomControls(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            ZoomControls zoomControls;
            View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367151, (ViewGroup)this, true);
            this.mPlusMinusZoomControls = zoomControls = (ZoomControls)this.findViewById(16908847);
            this.findViewById(16908850).setVisibility(8);
        }

        private void fade(int n, float f, float f2) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(f, f2);
            alphaAnimation.setDuration(500L);
            this.startAnimation(alphaAnimation);
            this.setVisibility(n);
        }

        @Override
        public boolean hasFocus() {
            return this.mPlusMinusZoomControls.hasFocus();
        }

        public void hide() {
            this.fade(8, 1.0f, 0.0f);
        }

        public void setOnZoomInClickListener(View.OnClickListener onClickListener) {
            this.mPlusMinusZoomControls.setOnZoomInClickListener(onClickListener);
        }

        public void setOnZoomOutClickListener(View.OnClickListener onClickListener) {
            this.mPlusMinusZoomControls.setOnZoomOutClickListener(onClickListener);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void show(boolean bl, boolean bl2) {
            ZoomControls zoomControls = this.mPlusMinusZoomControls;
            int n = bl ? 0 : 8;
            zoomControls.setVisibility(n);
            this.fade(0, 0.0f, 1.0f);
        }
    }
}

