/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.MediaFile;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.BrowserFrame;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.GeolocationPermissions;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.Network;
import android.webkit.PluginManager;
import android.webkit.ValueCallback;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebIconDatabase;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

final class WebViewCore {
    static final int ACTION_DOUBLETAP = 512;
    static final int ACTION_LONGPRESS = 256;
    static final String[] HandlerDebugString;
    private static final String LOGTAG = "webcore";
    static final int SCROLL_BITS = 6;
    static final String THREAD_NAME = "WebViewCoreThread";
    static final int ZOOM_BITS = 134;
    private static boolean mRepaintScheduled;
    private static Handler sWebCoreHandler;
    private BrowserFrame mBrowserFrame;
    private final CallbackProxy mCallbackProxy;
    private final Context mContext;
    private int mCurrentViewHeight = 0;
    private float mCurrentViewScale = 1.0f;
    private int mCurrentViewWidth = 0;
    private boolean mDrawIsPaused;
    private boolean mDrawIsScheduled;
    private final EventHub mEventHub;
    private Map<String, Object> mJavascriptInterfaces;
    private int mNativeClass;
    private RestoreState mRestoreState = null;
    private int mRestoredScale = 0;
    private int mRestoredScreenWidthScale = 0;
    private int mRestoredX = 0;
    private int mRestoredY = 0;
    final DrawFilter mScrollFilter;
    private final WebSettings mSettings;
    private boolean mSplitPictureIsScheduled;
    private int mViewportDensityDpi = -1;
    private int mViewportHeight = -1;
    private int mViewportInitialScale = 0;
    private int mViewportMaximumScale = 0;
    private int mViewportMinimumScale = 0;
    private boolean mViewportUserScalable = true;
    private int mViewportWidth = -1;
    private WebView mWebView;
    private int mWebkitScrollX = 0;
    private int mWebkitScrollY = 0;
    final DrawFilter mZoomFilter;

    static {
        System.loadLibrary(LOGTAG);
        String[] stringArray = new String[]{"REQUEST_LABEL", "UPDATE_FRAME_CACHE_IF_LOADING", "SCROLL_TEXT_INPUT", "LOAD_URL", "STOP_LOADING", "RELOAD", "KEY_DOWN", "KEY_UP", "VIEW_SIZE_CHANGED", "GO_BACK_FORWARD", "SET_SCROLL_OFFSET", "RESTORE_STATE", "PAUSE_TIMERS", "RESUME_TIMERS", "CLEAR_CACHE", "CLEAR_HISTORY", "SET_SELECTION", "REPLACE_TEXT", "PASS_TO_JS", "SET_GLOBAL_BOUNDS", "UPDATE_CACHE_AND_TEXT_ENTRY", "CLICK", "SET_NETWORK_STATE", "DOC_HAS_IMAGES", "121", "DELETE_SELECTION", "LISTBOX_CHOICES", "SINGLE_LISTBOX_CHOICE", "MESSAGE_RELAY", "SET_BACKGROUND_COLOR", "SET_MOVE_FOCUS", "SAVE_DOCUMENT_STATE", "129", "WEBKIT_DRAW", "SYNC_SCROLL", "POST_URL", "SPLIT_PICTURE_SET", "CLEAR_CONTENT", "SET_MOVE_MOUSE", "SET_MOVE_MOUSE_IF_LATEST", "REQUEST_CURSOR_HREF", "ADD_JS_INTERFACE", "LOAD_DATA", "TOUCH_UP", "TOUCH_EVENT", "SET_ACTIVE", "ON_PAUSE", "ON_RESUME", "FREE_MEMORY", "VALID_NODE_BOUNDS"};
        HandlerDebugString = stringArray;
        mRepaintScheduled = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebViewCore(Context context, WebView webView, CallbackProxy callbackProxy, Map<String, Object> map) {
        WebSettings webSettings;
        EventHub eventHub;
        PaintFlagsDrawFilter paintFlagsDrawFilter = new PaintFlagsDrawFilter(134, 64);
        this.mZoomFilter = paintFlagsDrawFilter;
        PaintFlagsDrawFilter paintFlagsDrawFilter2 = new PaintFlagsDrawFilter(6, 0);
        this.mScrollFilter = paintFlagsDrawFilter2;
        this.mCallbackProxy = callbackProxy;
        this.mWebView = webView;
        this.mJavascriptInterfaces = map;
        this.mContext = context;
        synchronized (WebViewCore.class) {
            if (sWebCoreHandler == null) {
                WebCoreThread webCoreThread = new WebCoreThread();
                Thread thread = new Thread(webCoreThread);
                thread.setName(THREAD_NAME);
                thread.start();
                try {
                    WebViewCore.class.wait();
                }
                catch (InterruptedException interruptedException) {
                    int n = Log.e(LOGTAG, "Caught exception while waiting for thread creation.");
                    String string2 = Log.getStackTraceString(interruptedException);
                    int n2 = Log.e(LOGTAG, string2);
                }
            }
        }
        this.mEventHub = eventHub = new EventHub();
        Context context2 = this.mContext;
        WebView webView2 = this.mWebView;
        this.mSettings = webSettings = new WebSettings(context2, webView2);
        WebIconDatabase webIconDatabase = WebIconDatabase.getInstance();
        WebStorage.getInstance().createUIHandler();
        GeolocationPermissions.getInstance().createUIHandler();
        Message message = sWebCoreHandler.obtainMessage(0, this);
        boolean bl = sWebCoreHandler.sendMessage(message);
    }

    static /* synthetic */ WebView access$1002(WebViewCore webViewCore, WebView webView) {
        webViewCore.mWebView = webView;
        return webView;
    }

    static /* synthetic */ Handler access$402(Handler handler) {
        sWebCoreHandler = handler;
        return handler;
    }

    static /* synthetic */ int access$5402(WebViewCore webViewCore, int n) {
        webViewCore.mWebkitScrollX = n;
        return n;
    }

    static /* synthetic */ int access$5502(WebViewCore webViewCore, int n) {
        webViewCore.mWebkitScrollY = n;
        return n;
    }

    static /* synthetic */ boolean access$5702(WebViewCore webViewCore, boolean bl) {
        webViewCore.mSplitPictureIsScheduled = bl;
        return bl;
    }

    static /* synthetic */ boolean access$6202(WebViewCore webViewCore, boolean bl) {
        webViewCore.mDrawIsScheduled = bl;
        return bl;
    }

    static /* synthetic */ BrowserFrame access$702(WebViewCore webViewCore, BrowserFrame browserFrame) {
        webViewCore.mBrowserFrame = browserFrame;
        return browserFrame;
    }

    static /* synthetic */ int access$902(WebViewCore webViewCore, int n) {
        webViewCore.mNativeClass = n;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ViewManager.ChildView addSurface(View view, int n, int n2, int n3, int n4) {
        if (this.mWebView == null) {
            return null;
        }
        if (view == null) {
            int n5 = Log.e(LOGTAG, "Attempted to add an empty plugin view to the view hierarchy");
            return null;
        }
        view.setWillNotDraw(false);
        if (view instanceof SurfaceView) {
            ((SurfaceView)view).setZOrderOnTop(true);
        }
        ViewManager.ChildView childView = this.mWebView.mViewManager.createView();
        childView.mView = view;
        childView.attachView(n, n2, n3, n4);
        return childView;
    }

    private void centerFitRect(int n, int n2, int n3, int n4) {
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        int n5 = n + n3;
        int n6 = n2 + n4;
        Rect rect = new Rect(n, n2, n5, n6);
        handler.obtainMessage(127, rect).sendToTarget();
    }

    private void clearCache(boolean bl) {
        this.mBrowserFrame.clearCache();
        if (!bl) {
            return;
        }
        boolean bl2 = CacheManager.removeAllCacheFiles();
    }

    private void clearTextEntry() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 111).sendToTarget();
    }

    private void contentScrollBy(int n, int n2, boolean bl) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        Boolean bl2 = new Boolean(bl);
        Message message = Message.obtain(handler, 102, n, n2, bl2);
        if (this.mDrawIsScheduled) {
            EventHub eventHub = this.mEventHub;
            Message message2 = Message.obtain(null, 125, message);
            eventHub.sendMessage(message2);
            return;
        }
        message.sendToTarget();
    }

    private void contentScrollTo(int n, int n2) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredX = n;
            this.mRestoredY = n2;
            return;
        }
        if (this.mWebView == null) {
            return;
        }
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 101, n, n2);
        if (this.mDrawIsScheduled) {
            EventHub eventHub = this.mEventHub;
            Message message2 = Message.obtain(null, 125, message);
            eventHub.sendMessage(message2);
            return;
        }
        message.sendToTarget();
    }

    private void contentSpawnScrollTo(int n, int n2) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredX = n;
            this.mRestoredY = n2;
            return;
        }
        if (this.mWebView == null) {
            return;
        }
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 103, n, n2);
        if (this.mDrawIsScheduled) {
            EventHub eventHub = this.mEventHub;
            Message message2 = Message.obtain(null, 125, message);
            eventHub.sendMessage(message2);
            return;
        }
        message.sendToTarget();
    }

    private void destroySurface(ViewManager.ChildView childView) {
        childView.removeView();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void didFirstLayout(boolean bl) {
        this.mBrowserFrame.didFirstLayout();
        if (this.mWebView == null) {
            return;
        }
        boolean bl2 = bl || this.mRestoredScale > 0;
        this.setupViewport(bl2);
        if (!bl2) {
            this.mWebView.mViewManager.postReadyToDrawAll();
        }
        this.mRestoredScreenWidthScale = 0;
        this.mRestoredScale = 0;
        this.mRestoredY = 0;
        this.mRestoredX = 0;
        this.mWebkitScrollY = 0;
        this.mWebkitScrollX = 0;
    }

    private Context getContext() {
        return this.mContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<?> getPluginClass(String string2, String string3) {
        if (this.mWebView == null) {
            return null;
        }
        PluginManager pluginManager = PluginManager.getInstance(null);
        String string4 = pluginManager.getPluginsAPKName(string2);
        if (string4 == null) {
            String string5 = "Unable to resolve " + string2 + " to a plugin APK";
            int n = Log.w(LOGTAG, string5);
            return null;
        }
        try {
            Class<?> clazz = pluginManager.getPluginClass(string4, string3);
            return clazz;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string6 = "Unable to find plugin classloader for the apk (" + string4 + ")";
            int n = Log.e(LOGTAG, string6);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string7 = "Unable to find plugin class (" + string3 + ") in the apk (" + string4 + ")";
            int n = Log.e(LOGTAG, string7);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getUsedQuota() {
        Collection<WebStorage.Origin> collection = WebStorage.getInstance().getOriginsSync();
        if (collection == null) {
            return 0L;
        }
        long l = 0L;
        Iterator<WebStorage.Origin> iterator = collection.iterator();
        while (iterator.hasNext()) {
            long l2 = iterator.next().getQuota();
            l += l2;
        }
        return l;
    }

    private void hideFullScreenPlugin() {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    private void initialize() {
        BrowserFrame browserFrame;
        Context context = this.mContext;
        CallbackProxy callbackProxy = this.mCallbackProxy;
        WebSettings webSettings = this.mSettings;
        Map<String, Object> map = this.mJavascriptInterfaces;
        WebViewCore webViewCore = this;
        this.mBrowserFrame = browserFrame = new BrowserFrame(context, webViewCore, callbackProxy, webSettings, map);
        this.mJavascriptInterfaces = null;
        WebSettings webSettings2 = this.mSettings;
        BrowserFrame browserFrame2 = this.mBrowserFrame;
        webSettings2.syncSettingsAndCreateHandler(browserFrame2);
        WebIconDatabase.getInstance().createHandler();
        WebStorage.getInstance().createHandler();
        GeolocationPermissions.getInstance().createHandler();
        this.mEventHub.transferMessages();
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        int n = this.mNativeClass;
        Message.obtain(handler, 107, n, 0).sendToTarget();
    }

    private void key(KeyEvent keyEvent, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n;
        WebViewCore webViewCore;
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getUnicodeChar();
        if (n2 == 0 && keyEvent.getCharacters() != null && keyEvent.getCharacters().length() > 0) {
            n3 = keyEvent.getCharacters().codePointAt(0);
        }
        if ((webViewCore = this).nativeKey(n2, n3, n = keyEvent.getRepeatCount(), bl5 = keyEvent.isShiftPressed(), bl4 = keyEvent.isAltPressed(), bl3 = keyEvent.isSymPressed(), bl2 = bl)) {
            return;
        }
        if (n2 == 66) {
            return;
        }
        if (n2 >= 19 && n2 <= 22) {
            if (this.mWebView == null) {
                return;
            }
            if (!keyEvent.isDown()) {
                return;
            }
            Handler handler = this.mWebView.mPrivateHandler;
            Integer n4 = n2;
            Message.obtain(handler, 110, n4).sendToTarget();
            return;
        }
        this.mCallbackProxy.onUnhandledKeyEvent(keyEvent);
    }

    private void loadUrl(String string2, Map<String, String> map) {
        this.mBrowserFrame.loadUrl(string2, map);
    }

    private native void nativeClearContent();

    private native void nativeClick(int var1, int var2);

    private native void nativeCopyContentToPicture(Picture var1);

    private native void nativeDeleteSelection(int var1, int var2, int var3);

    private native boolean nativeDrawContent(Canvas var1, int var2);

    private native void nativeDumpDomTree(boolean var1);

    private native void nativeDumpNavTree();

    private native void nativeDumpRenderTree(boolean var1);

    private native void nativeDumpV8Counters();

    static native String nativeFindAddress(String var0, boolean var1);

    private native boolean nativeFocusBoundsChanged();

    private native void nativeFreeMemory();

    private native void nativeFullScreenPluginHidden(int var1);

    private native void nativeGeolocationPermissionsProvide(String var1, boolean var2, boolean var3);

    private native int nativeGetContentMinPrefWidth();

    private native boolean nativeHandleTouchEvent(int var1, int var2, int var3, int var4);

    private native boolean nativeKey(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7);

    private native void nativeMoveFocus(int var1, int var2);

    private native void nativeMoveMouse(int var1, int var2, int var3);

    private native void nativeMoveMouseIfLatest(int var1, int var2, int var3, int var4);

    private native void nativePause();

    private native boolean nativePictureReady();

    private native void nativeProvideVisitedHistory(String[] var1);

    private native boolean nativeRecordContent(Region var1, Point var2);

    private native void nativeRegisterURLSchemeAsLocal(String var1);

    private native void nativeReplaceTextfieldText(int var1, int var2, String var3, int var4, int var5, int var6);

    private native String nativeRequestLabel(int var1, int var2);

    private native void nativeResume();

    private native String nativeRetrieveAnchorText(int var1, int var2);

    private native String nativeRetrieveHref(int var1, int var2);

    private native void nativeSaveDocumentState(int var1);

    private native void nativeScrollFocusedTextInput(float var1, int var2);

    private native void nativeSendListBoxChoice(int var1);

    private native void nativeSendListBoxChoices(boolean[] var1, int var2);

    private native void nativeSetBackgroundColor(int var1);

    private native void nativeSetFocusControllerActive(boolean var1);

    private native void nativeSetGlobalBounds(int var1, int var2, int var3, int var4);

    private native void nativeSetJsFlags(String var1);

    private native void nativeSetNewStorageLimit(long var1);

    private native void nativeSetScrollOffset(int var1, int var2, int var3);

    private native void nativeSetSelection(int var1, int var2);

    private native void nativeSetSize(int var1, int var2, int var3, float var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void nativeSplitContent();

    private native void nativeTouchUp(int var1, int var2, int var3, int var4, int var5);

    private native void nativeUpdateFrameCache();

    private native void nativeUpdateFrameCacheIfLoading();

    private native boolean nativeValidNodeAndBounds(int var1, int var2, Rect var3);

    /*
     * Enabled aggressive block sorting
     */
    private void needTouchEvents(boolean bl) {
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        int n = 116;
        int n2 = bl ? 1 : 0;
        Message.obtain(handler, n, n2, 0).sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String openFileChooser() {
        Uri uri = this.mCallbackProxy.openFileChooser();
        if (uri == null) {
            return "";
        }
        ContentResolver contentResolver = this.mContext.getContentResolver();
        String[] stringArray = new String[]{"_display_name"};
        String[] stringArray2 = null;
        String string2 = null;
        Cursor cursor = contentResolver.query(uri, stringArray, null, stringArray2, string2);
        String string3 = "";
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    String string4;
                    string3 = string4 = cursor.getString(0);
                }
                cursor.close();
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = uri.toString();
        return stringBuilder.append(string5).append("/").append(string3).toString();
    }

    private native void passToJs(int var1, String var2, int var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8);

    public static void pauseTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.pause();
    }

    static void pauseUpdatePicture(WebViewCore webViewCore) {
        if (webViewCore == null) {
            return;
        }
        synchronized (webViewCore) {
            boolean bl = true;
            webViewCore.mDrawIsPaused = bl;
            if (webViewCore.mDrawIsScheduled) {
                webViewCore.mEventHub.removeMessages(130);
            }
            return;
        }
    }

    static void reducePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        Handler handler = sWebCoreHandler;
        Message message = sWebCoreHandler.obtainMessage(1);
        boolean bl = handler.sendMessageAtFrontOfQueue(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void requestKeyboard(boolean bl) {
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        int n = 118;
        int n2 = bl ? 1 : 0;
        Message.obtain(handler, n, n2, 0).sendToTarget();
    }

    private void requestKeyboardWithSelection(int n, int n2, int n3, int n4) {
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        TextSelectionData textSelectionData = new TextSelectionData(n2, n3);
        Message.obtain(handler, 128, n, n4, textSelectionData).sendToTarget();
    }

    private void requestListBox(String[] stringArray, int[] nArray, int n) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.requestListBox(stringArray, nArray, n);
    }

    private void requestListBox(String[] stringArray, int[] nArray, int[] nArray2) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.requestListBox(stringArray, nArray, nArray2);
    }

    private void restoreScale(int n) {
        if (this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        this.mRestoredScale = n;
    }

    private void restoreScreenWidthScale(int n) {
        if (!this.mSettings.getUseWideViewPort()) {
            return;
        }
        if (this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        this.mRestoredScreenWidthScale = n;
    }

    private void restoreState(int n) {
        WebBackForwardList webBackForwardList = this.mCallbackProxy.getBackForwardList();
        int n2 = webBackForwardList.getSize();
        for (int i = 0; i < n2; ++i) {
            WebHistoryItem webHistoryItem = webBackForwardList.getItemAtIndex(i);
            int n3 = this.mBrowserFrame.mNativeFrame;
            webHistoryItem.inflate(n3);
        }
        this.mBrowserFrame.mLoadInitFromJava = true;
        WebBackForwardList.restoreIndex(this.mBrowserFrame.mNativeFrame, n);
        this.mBrowserFrame.mLoadInitFromJava = false;
    }

    static void resumePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        Handler handler = sWebCoreHandler;
        Message message = sWebCoreHandler.obtainMessage(2);
        boolean bl = handler.sendMessageAtFrontOfQueue(message);
    }

    public static void resumeTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.resume();
    }

    static void resumeUpdatePicture(WebViewCore webViewCore) {
        if (webViewCore == null) {
            return;
        }
        synchronized (webViewCore) {
            boolean bl = false;
            webViewCore.mDrawIsPaused = bl;
            if (webViewCore.mDrawIsScheduled) {
                webViewCore.mDrawIsScheduled = false;
                webViewCore.contentDraw();
            }
            return;
        }
    }

    private void sendFindAgain() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 126).sendToTarget();
    }

    private void sendImmediateRepaint() {
        if (this.mWebView == null) {
            return;
        }
        if (mRepaintScheduled) {
            return;
        }
        mRepaintScheduled = true;
        Message.obtain(this.mWebView.mPrivateHandler, 123).sendToTarget();
    }

    private void sendNotifyProgressFinished() {
        this.sendUpdateTextEntry();
        WebViewWorker.getHandler().removeMessages(110);
        boolean bl = WebViewWorker.getHandler().sendEmptyMessage(110);
        this.contentDraw();
    }

    private void sendUpdateTextEntry() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 106).sendToTarget();
    }

    private void sendViewInvalidate(int n, int n2, int n3, int n4) {
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        Rect rect = new Rect(n, n2, n3, n4);
        Message.obtain(handler, 117, rect).sendToTarget();
    }

    private void setRootLayer(int n) {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 124, n, 0).sendToTarget();
    }

    private void setScrollbarModes(int n, int n2) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(129, n, n2).sendToTarget();
    }

    private native void setViewportSettingsFromNative();

    /*
     * Enabled aggressive block sorting
     */
    private void setupViewport(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        float f;
        float f2;
        RestoreState restoreState;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        this.setViewportSettingsFromNative();
        float f3 = 1.0f;
        if (this.mViewportDensityDpi == -1) {
            if (WebView.DEFAULT_SCALE_PERCENT != 100) {
                f3 = (float)WebView.DEFAULT_SCALE_PERCENT / 100.0f;
            }
        } else if (this.mViewportDensityDpi > 0) {
            float f4 = this.mContext.getResources().getDisplayMetrics().densityDpi;
            float f5 = this.mViewportDensityDpi;
            f3 = f4 / f5;
        }
        int n11 = (int)(100.0f * f3);
        if (this.mViewportInitialScale > 0) {
            int n12;
            this.mViewportInitialScale = n12 = (int)((float)this.mViewportInitialScale * f3);
        }
        if (this.mViewportMinimumScale > 0) {
            int n13;
            this.mViewportMinimumScale = n13 = (int)((float)this.mViewportMinimumScale * f3);
        }
        if (this.mViewportMaximumScale > 0) {
            int n14;
            this.mViewportMaximumScale = n14 = (int)((float)this.mViewportMaximumScale * f3);
        }
        if (this.mViewportWidth == 0 && this.mViewportInitialScale == 0) {
            this.mViewportInitialScale = n11;
        }
        if (!this.mViewportUserScalable) {
            this.mViewportInitialScale = n11;
            this.mViewportMinimumScale = n11;
            this.mViewportMaximumScale = n11;
        }
        if ((n10 = this.mViewportMinimumScale) > (n9 = this.mViewportInitialScale) && this.mViewportInitialScale != 0) {
            int n15;
            this.mViewportMinimumScale = n15 = this.mViewportInitialScale;
        }
        if (this.mViewportMaximumScale > 0 && (n8 = this.mViewportMaximumScale) < (n7 = this.mViewportInitialScale)) {
            int n16;
            this.mViewportMaximumScale = n16 = this.mViewportInitialScale;
        }
        if (this.mViewportWidth < 0 && this.mViewportInitialScale != n11) {
            this.mViewportWidth = 0;
        }
        if (this.mViewportWidth != 0 && !bl) {
            float f6;
            float f7;
            RestoreState restoreState2 = new RestoreState();
            restoreState2.mMinScale = f7 = (float)this.mViewportMinimumScale / 100.0f;
            restoreState2.mMaxScale = f6 = (float)this.mViewportMaximumScale / 100.0f;
            restoreState2.mDefaultScale = f3;
            restoreState2.mMobileSite = false;
            restoreState2.mScrollX = 0;
            Message.obtain(this.mWebView.mPrivateHandler, 109, restoreState2).sendToTarget();
            return;
        }
        int n17 = this.mCurrentViewWidth;
        if (n17 == 0) {
            n6 = this.mWebView.getViewWidth();
            n17 = (int)((float)n6 / f3);
            if (n17 == 0) {
                int n18 = Log.w(LOGTAG, "Can't get the viewWidth after the first layout");
            }
        } else {
            float f8 = n17;
            float f9 = this.mCurrentViewScale;
            n6 = Math.round(f8 * f9);
        }
        RestoreState restoreState3 = this.mRestoreState = (restoreState = new RestoreState());
        restoreState3.mMinScale = f2 = (float)this.mViewportMinimumScale / 100.0f;
        RestoreState restoreState4 = this.mRestoreState;
        restoreState4.mMaxScale = f = (float)this.mViewportMaximumScale / 100.0f;
        this.mRestoreState.mDefaultScale = f3;
        RestoreState restoreState5 = this.mRestoreState;
        restoreState5.mScrollX = n5 = this.mRestoredX;
        RestoreState restoreState6 = this.mRestoreState;
        restoreState6.mScrollY = n4 = this.mRestoredY;
        RestoreState restoreState7 = this.mRestoreState;
        boolean bl2 = this.mViewportWidth == 0;
        restoreState7.mMobileSite = bl2;
        if (this.mRestoredScale > 0) {
            float f10;
            RestoreState restoreState8 = this.mRestoreState;
            restoreState8.mViewScale = f10 = (float)this.mRestoredScale / 100.0f;
            if (this.mRestoredScreenWidthScale > 0) {
                float f11;
                RestoreState restoreState9 = this.mRestoreState;
                restoreState9.mTextWrapScale = f11 = (float)this.mRestoredScreenWidthScale / 100.0f;
            } else {
                float f12;
                RestoreState restoreState10 = this.mRestoreState;
                restoreState10.mTextWrapScale = f12 = this.mRestoreState.mViewScale;
            }
        } else if (this.mViewportInitialScale > 0) {
            float f13;
            RestoreState restoreState11 = this.mRestoreState;
            RestoreState restoreState12 = this.mRestoreState;
            restoreState12.mTextWrapScale = f13 = (float)this.mViewportInitialScale / 100.0f;
            restoreState11.mViewScale = f13;
        } else if (this.mViewportWidth > 0 && this.mViewportWidth < n6) {
            float f14;
            RestoreState restoreState13 = this.mRestoreState;
            RestoreState restoreState14 = this.mRestoreState;
            float f15 = n6;
            float f16 = this.mViewportWidth;
            restoreState14.mTextWrapScale = f14 = f15 / f16;
            restoreState13.mViewScale = f14;
        } else {
            this.mRestoreState.mTextWrapScale = f3;
            this.mRestoreState.mViewScale = 0.0f;
        }
        if (this.mWebView.mHeightCanMeasure) {
            int n19;
            int n20;
            this.mWebView.mLastHeightSent = 0;
            WebView.ViewSizeData viewSizeData = new WebView.ViewSizeData();
            viewSizeData.mWidth = n20 = this.mWebView.mLastWidthSent;
            viewSizeData.mHeight = 0;
            viewSizeData.mTextWrapWidth = n19 = viewSizeData.mWidth;
            viewSizeData.mScale = -1.0f;
            viewSizeData.mIgnoreHeight = false;
            viewSizeData.mAnchorY = 0;
            viewSizeData.mAnchorX = 0;
            this.mEventHub.removeMessages(105);
            EventHub eventHub = this.mEventHub;
            Message message = Message.obtain(null, 105, viewSizeData);
            eventHub.sendMessageAtFrontOfQueue(message);
            return;
        }
        if (!this.mSettings.getUseWideViewPort()) {
            return;
        }
        if (n17 == 0) {
            this.mWebView.mLastWidthSent = 0;
            return;
        }
        WebView.ViewSizeData viewSizeData = new WebView.ViewSizeData();
        float f17 = this.mRestoreState.mViewScale == 0.0f ? (this.mRestoredScale > 0 ? (float)this.mRestoredScale / 100.0f : this.mRestoreState.mTextWrapScale) : this.mRestoreState.mViewScale;
        viewSizeData.mScale = f17;
        float f18 = n6;
        float f19 = viewSizeData.mScale;
        viewSizeData.mWidth = n3 = Math.round(f18 / f19);
        if (this.mCurrentViewHeight == 0) {
            float f20 = this.mWebView.getViewHeight();
            float f21 = viewSizeData.mScale;
            n2 = Math.round(f20 / f21);
        } else {
            int n21 = this.mCurrentViewHeight;
            int n22 = viewSizeData.mWidth;
            n2 = n21 * n22 / n17;
        }
        viewSizeData.mHeight = n2;
        float f22 = n6;
        float f23 = this.mRestoreState.mTextWrapScale;
        viewSizeData.mTextWrapWidth = n = Math.round(f22 / f23);
        viewSizeData.mIgnoreHeight = false;
        viewSizeData.mAnchorY = 0;
        viewSizeData.mAnchorX = 0;
        this.mEventHub.removeMessages(105);
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, 105, viewSizeData);
        eventHub.sendMessageAtFrontOfQueue(message);
    }

    private void showFullScreenPlugin(ViewManager.ChildView childView, int n) {
        if (this.mWebView == null) {
            return;
        }
        Message message = this.mWebView.mPrivateHandler.obtainMessage(120);
        View view = childView.mView;
        message.obj = view;
        message.arg1 = n;
        message.sendToTarget();
    }

    private void showRect(int n, int n2, int n3, int n4, int n5, int n6, float f, float f2, float f3, float f4) {
        if (this.mWebView == null) {
            return;
        }
        ShowRectData showRectData = new ShowRectData();
        showRectData.mLeft = n;
        showRectData.mTop = n2;
        showRectData.mWidth = n3;
        showRectData.mHeight = n4;
        showRectData.mContentWidth = n5;
        showRectData.mContentHeight = n6;
        showRectData.mXPercentInDoc = f;
        showRectData.mXPercentInView = f2;
        showRectData.mYPercentInDoc = f3;
        showRectData.mYPercentInView = f4;
        Message.obtain(this.mWebView.mPrivateHandler, 113, showRectData).sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean supportsMimeType(String string2) {
        if (MediaFile.getFileTypeForMimeType(string2) <= 0) return false;
        return true;
    }

    private void updateSurface(ViewManager.ChildView childView, int n, int n2, int n3, int n4) {
        childView.attachView(n, n2, n3, n4);
    }

    private void updateTextSelection(int n, int n2, int n3, int n4) {
        if (this.mWebView == null) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        TextSelectionData textSelectionData = new TextSelectionData(n2, n3);
        Message.obtain(handler, 112, n, n4, textSelectionData).sendToTarget();
    }

    private void updateTextfield(int n, boolean bl, String string2, int n2) {
        if (this.mWebView == null) {
            return;
        }
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 108, n, n2, string2);
        message.getData().putBoolean("password", bl);
        message.sendToTarget();
    }

    private void updateViewport() {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        this.setupViewport(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void viewSizeChanged(int n, int n2, int n3, float f, int n4, int n5, boolean bl) {
        int n6;
        if (n == 0) {
            int n7 = Log.w(LOGTAG, "skip viewSizeChanged as w is 0");
            return;
        }
        int n8 = n;
        if (this.mSettings.getUseWideViewPort()) {
            if (this.mViewportWidth == -1) {
                WebSettings.LayoutAlgorithm layoutAlgorithm;
                WebSettings.LayoutAlgorithm layoutAlgorithm2 = this.mSettings.getLayoutAlgorithm();
                if (layoutAlgorithm2 == (layoutAlgorithm = WebSettings.LayoutAlgorithm.NORMAL)) {
                    n8 = 800;
                } else {
                    int n9 = WebView.sMaxViewportWidth;
                    int n10 = this.nativeGetContentMinPrefWidth();
                    int n11 = Math.max(800, n10);
                    int n12 = Math.max(n, n11);
                    n8 = Math.min(n9, n12);
                }
            } else if (this.mViewportWidth > 0) {
                int n13 = this.mViewportWidth;
                n8 = Math.max(n, n13);
            } else {
                n8 = n3;
            }
        }
        if (n8 != n) {
            n6 = n2;
        } else {
            float f2 = n8;
            float f3 = n2;
            float f4 = f2 * f3;
            float f5 = n;
            n6 = Math.round(f4 / f5);
        }
        WebViewCore webViewCore = this;
        int n14 = n3;
        float f6 = f;
        int n15 = n;
        int n16 = n2;
        int n17 = n4;
        int n18 = n5;
        boolean bl2 = bl;
        webViewCore.nativeSetSize(n8, n6, n14, f6, n15, n16, n17, n18, bl2);
        boolean bl3 = this.mCurrentViewWidth == 0;
        this.mCurrentViewWidth = n;
        this.mCurrentViewHeight = n2;
        this.mCurrentViewScale = f;
        if (bl3) {
            this.contentDraw();
        }
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, 117);
        eventHub.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void webkitDraw() {
        Point point;
        boolean bl;
        this.mDrawIsScheduled = false;
        DrawData drawData = new DrawData();
        Region region = drawData.mInvalRegion;
        Point point2 = drawData.mWidthHeight;
        if (!this.nativeRecordContent(region, point2)) {
            return;
        }
        if (this.mWebView == null) {
            return;
        }
        drawData.mFocusSizeChanged = bl = this.nativeFocusBoundsChanged();
        int n = this.mCurrentViewWidth;
        int n2 = this.mCurrentViewHeight;
        drawData.mViewPoint = point = new Point(n, n2);
        if (this.mSettings.getUseWideViewPort()) {
            int n3;
            int n4 = this.mViewportWidth == -1 ? 800 : (this.mViewportWidth == 0 ? this.mCurrentViewWidth : this.mViewportWidth);
            int n5 = this.nativeGetContentMinPrefWidth();
            drawData.mMinPrefWidth = n3 = Math.max(n4, n5);
        }
        if (this.mRestoreState != null) {
            RestoreState restoreState;
            drawData.mRestoreState = restoreState = this.mRestoreState;
            this.mRestoreState = null;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 105, drawData).sendToTarget();
        if (this.mWebkitScrollX == 0 && this.mWebkitScrollY == 0) {
            return;
        }
        Handler handler = this.mWebView.mPrivateHandler;
        int n6 = this.mWebkitScrollX;
        int n7 = this.mWebkitScrollY;
        Message.obtain(handler, 104, n6, n7).sendToTarget();
        this.mWebkitScrollY = 0;
        this.mWebkitScrollX = 0;
    }

    protected void addMessageToConsole(String string2, int n, String string3, int n2) {
        this.mCallbackProxy.addMessageToConsole(string2, n, string3, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void contentDraw() {
        if (this.mCurrentViewWidth == 0) {
            return;
        }
        if (!this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        synchronized (this) {
            boolean bl;
            if (this.mDrawIsScheduled) {
                return;
            }
            this.mDrawIsScheduled = bl = true;
            if (this.mDrawIsPaused) {
                return;
            }
            EventHub eventHub = this.mEventHub;
            Message message = Message.obtain(null, 130);
            eventHub.sendMessage(message);
            return;
        }
    }

    Picture copyContentPicture() {
        synchronized (this) {
            Picture picture = new Picture();
            if (this.mNativeClass != 0) {
                this.nativeCopyContentToPicture(picture);
            }
            return picture;
        }
    }

    void destroy() {
        EventHub eventHub = this.mEventHub;
        synchronized (eventHub) {
            boolean bl = this.mEventHub.hasMessages(110);
            boolean bl2 = this.mEventHub.hasMessages(109);
            this.mEventHub.removeMessages();
            EventHub eventHub2 = this.mEventHub;
            Message message = Message.obtain(null, 200);
            eventHub2.sendMessageAtFrontOfQueue(message);
            if (bl2) {
                EventHub eventHub3 = this.mEventHub;
                Message message2 = Message.obtain(null, 109);
                eventHub3.sendMessageAtFrontOfQueue(message2);
            }
            if (bl) {
                EventHub eventHub4 = this.mEventHub;
                Message message3 = Message.obtain(null, 110);
                eventHub4.sendMessageAtFrontOfQueue(message3);
            }
            this.mEventHub.blockMessages();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawContentPicture(Canvas canvas, int n, boolean bl, boolean bl2) {
        DrawFilter drawFilter = null;
        if (bl) {
            drawFilter = this.mZoomFilter;
        } else if (bl2) {
            drawFilter = this.mScrollFilter;
        }
        canvas.setDrawFilter(drawFilter);
        boolean bl3 = this.nativeDrawContent(canvas, n);
        canvas.setDrawFilter(null);
        if (!bl3) {
            return;
        }
        if (this.mSplitPictureIsScheduled) {
            return;
        }
        this.mSplitPictureIsScheduled = true;
        this.sendMessage(133);
    }

    protected void exceededDatabaseQuota(String string2, String string3, long l, long l2) {
        CallbackProxy callbackProxy = this.mCallbackProxy;
        long l3 = this.getUsedQuota();
        WebStorage.QuotaUpdater quotaUpdater = new WebStorage.QuotaUpdater(){

            @Override
            public void updateQuota(long l) {
                WebViewCore.this.nativeSetNewStorageLimit(l);
            }
        };
        String string4 = string2;
        String string5 = string3;
        long l4 = l;
        long l5 = l2;
        callbackProxy.onExceededDatabaseQuota(string4, string5, l4, l5, l3, quotaUpdater);
    }

    protected void geolocationPermissionsHidePrompt() {
        this.mCallbackProxy.onGeolocationPermissionsHidePrompt();
    }

    protected void geolocationPermissionsShowPrompt(String string2) {
        CallbackProxy callbackProxy = this.mCallbackProxy;
        GeolocationPermissions.Callback callback = new GeolocationPermissions.Callback(){

            @Override
            public void invoke(String string2, boolean bl, boolean bl2) {
                GeolocationPermissionsData geolocationPermissionsData = new GeolocationPermissionsData();
                geolocationPermissionsData.mOrigin = string2;
                geolocationPermissionsData.mAllow = bl;
                geolocationPermissionsData.mRemember = bl2;
                WebViewCore.this.sendMessage(180, geolocationPermissionsData);
            }
        };
        callbackProxy.onGeolocationPermissionsShowPrompt(string2, callback);
    }

    BrowserFrame getBrowserFrame() {
        return this.mBrowserFrame;
    }

    public WebSettings getSettings() {
        return this.mSettings;
    }

    WebView getWebView() {
        return this.mWebView;
    }

    void initializeSubwindow() {
        this.initialize();
        sWebCoreHandler.removeMessages(0, this);
    }

    protected void jsAlert(String string2, String string3) {
        this.mCallbackProxy.onJsAlert(string2, string3);
    }

    protected boolean jsConfirm(String string2, String string3) {
        return this.mCallbackProxy.onJsConfirm(string2, string3);
    }

    protected boolean jsInterrupt() {
        return this.mCallbackProxy.onJsTimeout();
    }

    protected String jsPrompt(String string2, String string3, String string4) {
        return this.mCallbackProxy.onJsPrompt(string2, string3, string4);
    }

    protected boolean jsUnload(String string2, String string3) {
        return this.mCallbackProxy.onJsBeforeUnload(string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean pictureReady() {
        synchronized (this) {
            if (this.mNativeClass == 0) return false;
            boolean bl = this.nativePictureReady();
            return bl;
        }
    }

    protected void populateVisitedLinks() {
        ValueCallback<String[]> valueCallback = new ValueCallback<String[]>(){

            @Override
            public void onReceiveValue(String[] stringArray) {
                WebViewCore.this.sendMessage(181, stringArray);
            }
        };
        this.mCallbackProxy.getVisitedHistory(valueCallback);
    }

    protected void reachedMaxAppCacheSize(long l) {
        CallbackProxy callbackProxy = this.mCallbackProxy;
        long l2 = this.getUsedQuota();
        WebStorage.QuotaUpdater quotaUpdater = new WebStorage.QuotaUpdater(){

            @Override
            public void updateQuota(long l) {
                WebViewCore.this.nativeSetNewStorageLimit(l);
            }
        };
        long l3 = l;
        callbackProxy.onReachedMaxAppCacheSize(l3, l2, quotaUpdater);
    }

    void removeMessages() {
        this.mEventHub.removeMessages();
    }

    void removeMessages(int n) {
        this.mEventHub.removeMessages(n);
    }

    void sendMessage(int n) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n);
        eventHub.sendMessage(message);
    }

    void sendMessage(int n, int n2) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n, n2, 0);
        eventHub.sendMessage(message);
    }

    void sendMessage(int n, int n2, int n3) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n, n2, n3);
        eventHub.sendMessage(message);
    }

    void sendMessage(int n, int n2, int n3, Object object) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n, n2, n3, object);
        eventHub.sendMessage(message);
    }

    void sendMessage(int n, int n2, Object object) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n, n2, 0, object);
        eventHub.sendMessage(message);
    }

    void sendMessage(int n, Object object) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n, object);
        eventHub.sendMessage(message);
    }

    void sendMessage(Message message) {
        this.mEventHub.sendMessage(message);
    }

    void sendMessageAtFrontOfQueue(int n, Object object) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n, object);
        eventHub.sendMessageAtFrontOfQueue(message);
    }

    void sendMessageDelayed(int n, Object object, long l) {
        EventHub eventHub = this.mEventHub;
        Message message = Message.obtain(null, n, object);
        eventHub.sendMessageDelayed(message, l);
    }

    void signalRepaintDone() {
        mRepaintScheduled = false;
    }

    void stopLoading() {
        if (this.mBrowserFrame == null) {
            return;
        }
        this.mBrowserFrame.stopLoading();
    }

    static class ShowRectData {
        int mContentHeight;
        int mContentWidth;
        int mHeight;
        int mLeft;
        int mTop;
        int mWidth;
        float mXPercentInDoc;
        float mXPercentInView;
        float mYPercentInDoc;
        float mYPercentInView;

        ShowRectData() {
        }
    }

    static class DrawData {
        boolean mFocusSizeChanged;
        Region mInvalRegion;
        int mMinPrefWidth;
        RestoreState mRestoreState;
        Point mViewPoint;
        Point mWidthHeight;

        DrawData() {
            Point point;
            Region region;
            this.mInvalRegion = region = new Region();
            this.mWidthHeight = point = new Point();
        }
    }

    static class RestoreState {
        float mDefaultScale;
        float mMaxScale;
        float mMinScale;
        boolean mMobileSite;
        int mScrollX;
        int mScrollY;
        float mTextWrapScale;
        float mViewScale;

        RestoreState() {
        }
    }

    class EventHub {
        static final int ADD_JS_INTERFACE = 138;
        static final int ADD_PACKAGE_NAME = 185;
        static final int ADD_PACKAGE_NAMES = 184;
        static final int CLEAR_CACHE = 111;
        static final int CLEAR_CONTENT = 134;
        static final int CLEAR_HISTORY = 112;
        static final int CLEAR_SSL_PREF_TABLE = 150;
        static final int CLICK = 118;
        static final int DELETE_SELECTION = 122;
        private static final int DESTROY = 200;
        static final int DOC_HAS_IMAGES = 120;
        static final int DUMP_DOMTREE = 170;
        static final int DUMP_NAVTREE = 172;
        static final int DUMP_RENDERTREE = 171;
        static final int DUMP_V8COUNTERS = 173;
        static final int FREE_MEMORY = 145;
        static final int GEOLOCATION_PERMISSIONS_PROVIDE = 180;
        static final int GO_BACK_FORWARD = 106;
        static final int HIDE_FULLSCREEN = 182;
        static final int KEY_DOWN = 103;
        static final int KEY_UP = 104;
        static final int LISTBOX_CHOICES = 123;
        static final int LOAD_DATA = 139;
        static final int LOAD_URL = 100;
        static final int MESSAGE_RELAY = 125;
        static final int ON_PAUSE = 143;
        static final int ON_RESUME = 144;
        static final int PASS_TO_JS = 115;
        static final int PAUSE_TIMERS = 109;
        static final int POPULATE_VISITED_LINKS = 181;
        static final int POST_URL = 132;
        static final int RELOAD = 102;
        static final int REMOVE_PACKAGE_NAME = 186;
        static final int REPLACE_TEXT = 114;
        static final int REQUEST_CURSOR_HREF = 137;
        static final int REQUEST_DOC_AS_TEXT = 161;
        static final int REQUEST_EXT_REPRESENTATION = 160;
        static final int REQUEST_LABEL = 97;
        static final int RESTORE_STATE = 108;
        static final int RESUME_TIMERS = 110;
        static final int SAVE_DOCUMENT_STATE = 128;
        static final int SCROLL_TEXT_INPUT = 99;
        static final int SET_ACTIVE = 142;
        static final int SET_BACKGROUND_COLOR = 126;
        static final int SET_GLOBAL_BOUNDS = 116;
        static final int SET_JS_FLAGS = 174;
        static final int SET_MOVE_FOCUS = 127;
        static final int SET_MOVE_MOUSE = 135;
        static final int SET_MOVE_MOUSE_IF_LATEST = 136;
        static final int SET_NETWORK_STATE = 119;
        static final int SET_NETWORK_TYPE = 183;
        static final int SET_SCROLL_OFFSET = 107;
        static final int SET_SELECTION = 113;
        static final int SINGLE_LISTBOX_CHOICE = 124;
        static final int SPLIT_PICTURE_SET = 133;
        static final int STOP_LOADING = 101;
        static final int SYNC_SCROLL = 131;
        static final int TOUCH_EVENT = 141;
        static final int TOUCH_UP = 140;
        static final int UPDATE_CACHE_AND_TEXT_ENTRY = 117;
        static final int UPDATE_FRAME_CACHE_IF_LOADING = 98;
        static final int VALID_NODE_BOUNDS = 146;
        static final int VIEW_SIZE_CHANGED = 105;
        static final int WEBKIT_DRAW = 130;
        private boolean mBlockMessages;
        private Handler mHandler;
        private ArrayList<Message> mMessages;
        private int mSavedPriority;
        private int mTid;

        private EventHub() {
            ArrayList arrayList = new ArrayList();
            this.mMessages = arrayList;
        }

        static /* synthetic */ int access$2202(EventHub eventHub, int n) {
            eventHub.mSavedPriority = n;
            return n;
        }

        private void blockMessages() {
            synchronized (this) {
                this.mBlockMessages = true;
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean hasMessages(int n) {
            synchronized (this) {
                block4: {
                    boolean bl = this.mBlockMessages;
                    if (!bl) break block4;
                    return false;
                }
                boolean bl = this.mHandler.hasMessages(n);
                if (this.mMessages == null) return bl;
                int n2 = Log.w(WebViewCore.LOGTAG, "hasMessages() is not supported in this case.");
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeMessages() {
            synchronized (this) {
                boolean bl = WebViewCore.access$6202(WebViewCore.this, false);
                boolean bl2 = WebViewCore.access$5702(WebViewCore.this, false);
                if (this.mMessages != null) {
                    this.mMessages.clear();
                } else {
                    this.mHandler.removeCallbacksAndMessages(null);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeMessages(int n) {
            synchronized (this) {
                boolean bl = this.mBlockMessages;
                if (!bl) {
                    if (n == 130) {
                        boolean bl2 = WebViewCore.access$6202(WebViewCore.this, false);
                    }
                    if (this.mMessages != null) {
                        int n2 = Log.w(WebViewCore.LOGTAG, "Not supported in this case.");
                    } else {
                        this.mHandler.removeMessages(n);
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendMessage(Message message) {
            synchronized (this) {
                boolean bl = this.mBlockMessages;
                if (!bl) {
                    if (this.mMessages != null) {
                        boolean bl2 = this.mMessages.add(message);
                    } else {
                        boolean bl3 = this.mHandler.sendMessage(message);
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendMessageAtFrontOfQueue(Message message) {
            synchronized (this) {
                boolean bl = this.mBlockMessages;
                if (!bl) {
                    if (this.mMessages != null) {
                        this.mMessages.add(0, message);
                    } else {
                        boolean bl2 = this.mHandler.sendMessageAtFrontOfQueue(message);
                    }
                }
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendMessageDelayed(Message message, long l) {
            synchronized (this) {
                block6: {
                    boolean bl = this.mBlockMessages;
                    if (!bl) break block6;
                    return;
                }
                boolean bl = this.mHandler.sendMessageDelayed(message, l);
                return;
            }
        }

        private void transferMessages() {
            Handler handler;
            int n;
            int n2;
            this.mTid = n2 = Process.myTid();
            this.mSavedPriority = n = Process.getThreadPriority(this.mTid);
            this.mHandler = handler = new Handler(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void handleMessage(Message message) {
                    switch (message.what) {
                        default: {
                            return;
                        }
                        case 130: {
                            WebViewCore.this.webkitDraw();
                            return;
                        }
                        case 200: {
                            WebViewCore webViewCore = WebViewCore.this;
                            synchronized (webViewCore) {
                                WebViewCore.this.mBrowserFrame.destroy();
                                BrowserFrame browserFrame = WebViewCore.access$702(WebViewCore.this, null);
                                WebViewCore.this.mSettings.onDestroyed();
                                int n = WebViewCore.access$902(WebViewCore.this, 0);
                                WebView webView = WebViewCore.access$1002(WebViewCore.this, null);
                                return;
                            }
                        }
                        case 97: {
                            if (WebViewCore.this.mWebView == null) {
                                return;
                            }
                            WebViewCore webViewCore = WebViewCore.this;
                            WebViewCore webViewCore2 = webViewCore;
                            int n = message.arg1;
                            int n2 = n;
                            int n3 = message.arg2;
                            int n4 = n3;
                            String string2 = webViewCore2.nativeRequestLabel(n2, n4);
                            if (string2 == null) {
                                return;
                            }
                            if (string2.length() <= 0) {
                                return;
                            }
                            Handler handler = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler;
                            int n5 = 125;
                            int n6 = n3;
                            int n7 = 0;
                            String string3 = string2;
                            Message.obtain(handler, n5, n6, n7, string3).sendToTarget();
                            return;
                        }
                        case 98: {
                            WebViewCore.this.nativeUpdateFrameCacheIfLoading();
                            return;
                        }
                        case 99: {
                            WebViewCore webViewCore = WebViewCore.this;
                            float f = ((Float)message.obj).floatValue();
                            int n = message.arg1;
                            webViewCore.nativeScrollFocusedTextInput(f, n);
                            return;
                        }
                        case 100: {
                            GetUrlData getUrlData = (GetUrlData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            String string4 = getUrlData.mUrl;
                            Map<String, String> map = getUrlData.mExtraHeaders;
                            webViewCore.loadUrl(string4, map);
                            return;
                        }
                        case 132: {
                            PostUrlData postUrlData = (PostUrlData)message.obj;
                            BrowserFrame browserFrame = WebViewCore.this.mBrowserFrame;
                            String string5 = postUrlData.mUrl;
                            byte[] byArray = postUrlData.mPostData;
                            browserFrame.postUrl(string5, byArray);
                            return;
                        }
                        case 139: {
                            String string6;
                            String string7;
                            String string8;
                            String string9;
                            String string10;
                            String string11;
                            String string12;
                            int n;
                            int n8;
                            String string13;
                            String string14;
                            String string15;
                            int n9;
                            BaseUrlData baseUrlData = (BaseUrlData)message.obj;
                            String string16 = baseUrlData.mBaseUrl;
                            if (!(string16 == null || (n9 = string16.indexOf(58)) <= 0 || (string15 = (string14 = (string13 = string16).substring(n8 = 0, n = n9))).startsWith(string12 = "http") || (string11 = string14).startsWith(string10 = "ftp") || (string9 = string14).startsWith(string8 = "about") || (string7 = string14).startsWith(string6 = "javascript"))) {
                                WebViewCore webViewCore = WebViewCore.this;
                                String string17 = string14;
                                webViewCore.nativeRegisterURLSchemeAsLocal(string17);
                            }
                            BrowserFrame browserFrame = WebViewCore.this.mBrowserFrame;
                            String string18 = baseUrlData.mData;
                            String string19 = baseUrlData.mMimeType;
                            String string20 = baseUrlData.mEncoding;
                            String string21 = baseUrlData.mHistoryUrl;
                            browserFrame.loadData(string16, string18, string19, string20, string21);
                            return;
                        }
                        case 101: {
                            if (WebViewCore.this.mBrowserFrame.committed() && !WebViewCore.this.mBrowserFrame.firstLayoutDone()) {
                                WebViewCore.this.mBrowserFrame.didFirstLayout();
                            }
                            WebViewCore.this.stopLoading();
                            return;
                        }
                        case 102: {
                            WebViewCore.this.mBrowserFrame.reload(false);
                            return;
                        }
                        case 103: {
                            WebViewCore webViewCore = WebViewCore.this;
                            KeyEvent keyEvent = (KeyEvent)message.obj;
                            WebViewCore webViewCore3 = webViewCore;
                            KeyEvent keyEvent2 = keyEvent;
                            boolean bl = true;
                            webViewCore3.key(keyEvent2, bl);
                            return;
                        }
                        case 104: {
                            WebViewCore webViewCore = WebViewCore.this;
                            KeyEvent keyEvent = (KeyEvent)message.obj;
                            WebViewCore webViewCore4 = webViewCore;
                            KeyEvent keyEvent3 = keyEvent;
                            boolean bl = false;
                            webViewCore4.key(keyEvent3, bl);
                            return;
                        }
                        case 118: {
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            int n10 = message.arg2;
                            webViewCore.nativeClick(n, n10);
                            return;
                        }
                        case 105: {
                            WebView.ViewSizeData viewSizeData = (WebView.ViewSizeData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = viewSizeData.mWidth;
                            int n11 = viewSizeData.mHeight;
                            int n12 = viewSizeData.mTextWrapWidth;
                            float f = viewSizeData.mScale;
                            int n13 = viewSizeData.mAnchorX;
                            int n14 = viewSizeData.mAnchorY;
                            boolean bl = viewSizeData.mIgnoreHeight;
                            webViewCore.viewSizeChanged(n, n11, n12, f, n13, n14, bl);
                            return;
                        }
                        case 107: {
                            Point point = (Point)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            int n15 = point.x;
                            int n16 = point.y;
                            webViewCore.nativeSetScrollOffset(n, n15, n16);
                            return;
                        }
                        case 116: {
                            Rect rect = (Rect)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = rect.left;
                            int n17 = rect.top;
                            int n18 = rect.width();
                            int n19 = rect.height();
                            webViewCore.nativeSetGlobalBounds(n, n17, n18, n19);
                            return;
                        }
                        case 106: {
                            if (!WebViewCore.this.mBrowserFrame.committed() && message.arg1 == -1 && WebViewCore.this.mBrowserFrame.loadType() == 0) {
                                WebViewCore.this.mBrowserFrame.reload(true);
                                return;
                            }
                            BrowserFrame browserFrame = WebViewCore.this.mBrowserFrame;
                            int n = message.arg1;
                            browserFrame.goBackOrForward(n);
                            return;
                        }
                        case 108: {
                            WebViewCore.this.stopLoading();
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            webViewCore.restoreState(n);
                            return;
                        }
                        case 109: {
                            EventHub eventHub = EventHub.this;
                            int n = Process.getThreadPriority(EventHub.this.mTid);
                            int n20 = EventHub.access$2202(eventHub, n);
                            Process.setThreadPriority(EventHub.this.mTid, 10);
                            WebViewCore.pauseTimers();
                            boolean bl = WebViewWorker.getHandler().sendEmptyMessage(111);
                            return;
                        }
                        case 110: {
                            int n = EventHub.this.mTid;
                            int n21 = EventHub.this.mSavedPriority;
                            Process.setThreadPriority(n, n21);
                            WebViewCore.resumeTimers();
                            boolean bl = WebViewWorker.getHandler().sendEmptyMessage(112);
                            return;
                        }
                        case 143: {
                            WebViewCore.this.nativePause();
                            return;
                        }
                        case 144: {
                            WebViewCore.this.nativeResume();
                            return;
                        }
                        case 145: {
                            WebViewCore.this.clearCache(false);
                            WebViewCore.this.nativeFreeMemory();
                            return;
                        }
                        case 119: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            JWebCoreJavaBridge jWebCoreJavaBridge = BrowserFrame.sJavaBridge;
                            boolean bl = message.arg1 == 1;
                            jWebCoreJavaBridge.setNetworkOnLine(bl);
                            return;
                        }
                        case 183: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            Map map = (Map)message.obj;
                            JWebCoreJavaBridge jWebCoreJavaBridge = BrowserFrame.sJavaBridge;
                            Map map2 = map;
                            String string22 = "type";
                            String string23 = (String)map2.get(string22);
                            Map map3 = map;
                            String string24 = "subtype";
                            String string25 = (String)map3.get(string24);
                            JWebCoreJavaBridge jWebCoreJavaBridge2 = jWebCoreJavaBridge;
                            String string26 = string23;
                            String string27 = string25;
                            jWebCoreJavaBridge2.setNetworkType(string26, string27);
                            return;
                        }
                        case 111: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.clearCache(bl);
                            return;
                        }
                        case 112: {
                            WebBackForwardList webBackForwardList = WebViewCore.this.mCallbackProxy.getBackForwardList();
                            int n = ((WebViewCore)WebViewCore.this).mBrowserFrame.mNativeFrame;
                            webBackForwardList.close(n);
                            return;
                        }
                        case 114: {
                            ReplaceTextData replaceTextData = (ReplaceTextData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            int n22 = message.arg2;
                            String string28 = replaceTextData.mReplace;
                            int n23 = replaceTextData.mNewStart;
                            int n24 = replaceTextData.mNewEnd;
                            int n25 = replaceTextData.mTextGeneration;
                            webViewCore.nativeReplaceTextfieldText(n, n22, string28, n23, n24, n25);
                            return;
                        }
                        case 115: {
                            JSKeyData jSKeyData = (JSKeyData)message.obj;
                            KeyEvent keyEvent = jSKeyData.mEvent;
                            int n = keyEvent.getKeyCode();
                            int n26 = keyEvent.getUnicodeChar();
                            int n27 = message.arg1;
                            WebViewCore webViewCore = WebViewCore.this;
                            String string29 = jSKeyData.mCurrentText;
                            boolean bl = keyEvent.isDown();
                            boolean bl2 = keyEvent.isShiftPressed();
                            boolean bl3 = keyEvent.isAltPressed();
                            boolean bl4 = keyEvent.isSymPressed();
                            webViewCore.passToJs(n27, string29, n, n26, bl, bl2, bl3, bl4);
                            return;
                        }
                        case 128: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = cursorData.mFrame;
                            webViewCore.nativeSaveDocumentState(n);
                            return;
                        }
                        case 150: {
                            Network.getInstance(WebViewCore.this.mContext).clearUserSslPrefTable();
                            return;
                        }
                        case 140: {
                            TouchUpData touchUpData = (TouchUpData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = touchUpData.mMoveGeneration;
                            int n28 = touchUpData.mFrame;
                            int n29 = touchUpData.mNode;
                            int n30 = touchUpData.mX;
                            int n31 = touchUpData.mY;
                            webViewCore.nativeTouchUp(n, n28, n29, n30, n31);
                            return;
                        }
                        case 141: {
                            TouchEventData touchEventData = (TouchEventData)message.obj;
                            Handler handler = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler;
                            int n = 115;
                            int n32 = touchEventData.mAction;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n33 = touchEventData.mAction;
                            int n34 = touchEventData.mX;
                            int n35 = touchEventData.mY;
                            int n36 = touchEventData.mMetaState;
                            int n37 = webViewCore.nativeHandleTouchEvent(n33, n34, n35, n36) ? 1 : 0;
                            TouchEventData touchEventData2 = touchEventData.mReprocess ? touchEventData : null;
                            Message.obtain(handler, n, n32, n37, touchEventData2).sendToTarget();
                            return;
                        }
                        case 142: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.nativeSetFocusControllerActive(bl);
                            return;
                        }
                        case 138: {
                            JSInterfaceData jSInterfaceData = (JSInterfaceData)message.obj;
                            BrowserFrame browserFrame = WebViewCore.this.mBrowserFrame;
                            Object object = jSInterfaceData.mObject;
                            String string30 = jSInterfaceData.mInterfaceName;
                            browserFrame.addJavascriptInterface(object, string30);
                            return;
                        }
                        case 160: {
                            BrowserFrame browserFrame = WebViewCore.this.mBrowserFrame;
                            Message message2 = (Message)message.obj;
                            BrowserFrame browserFrame2 = browserFrame;
                            Message message3 = message2;
                            browserFrame2.externalRepresentation(message3);
                            return;
                        }
                        case 161: {
                            BrowserFrame browserFrame = WebViewCore.this.mBrowserFrame;
                            Message message4 = (Message)message.obj;
                            BrowserFrame browserFrame3 = browserFrame;
                            Message message5 = message4;
                            browserFrame3.documentAsText(message5);
                            return;
                        }
                        case 127: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = cursorData.mFrame;
                            int n38 = cursorData.mNode;
                            webViewCore.nativeMoveFocus(n, n38);
                            return;
                        }
                        case 135: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = cursorData.mFrame;
                            int n39 = cursorData.mX;
                            int n40 = cursorData.mY;
                            webViewCore.nativeMoveMouse(n, n39, n40);
                            return;
                        }
                        case 136: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = cursorData.mMoveGeneration;
                            int n41 = cursorData.mFrame;
                            int n42 = cursorData.mX;
                            int n43 = cursorData.mY;
                            webViewCore.nativeMoveMouseIfLatest(n, n41, n42, n43);
                            return;
                        }
                        case 137: {
                            Message message6 = (Message)message.obj;
                            Bundle bundle = message6.getData();
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            int n44 = message.arg2;
                            String string31 = webViewCore.nativeRetrieveHref(n, n44);
                            bundle.putString("url", string31);
                            Bundle bundle2 = message6.getData();
                            WebViewCore webViewCore5 = WebViewCore.this;
                            int n45 = message.arg1;
                            int n46 = message.arg2;
                            String string32 = webViewCore5.nativeRetrieveAnchorText(n45, n46);
                            bundle2.putString("title", string32);
                            message6.sendToTarget();
                            return;
                        }
                        case 117: {
                            WebViewCore.this.nativeUpdateFrameCache();
                            if (WebViewCore.this.mWebView != null) {
                                WebViewCore.this.mWebView.postInvalidate();
                            }
                            WebViewCore.this.sendUpdateTextEntry();
                            return;
                        }
                        case 120: {
                            int n;
                            Message message7 = (Message)message.obj;
                            int n47 = WebViewCore.this.mBrowserFrame.documentHasImages() ? 1 : 0;
                            message7.arg1 = n = n47;
                            message7.sendToTarget();
                            return;
                        }
                        case 122: {
                            TextSelectionData textSelectionData = (TextSelectionData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = textSelectionData.mStart;
                            int n48 = textSelectionData.mEnd;
                            int n49 = message.arg1;
                            webViewCore.nativeDeleteSelection(n, n48, n49);
                            return;
                        }
                        case 113: {
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            int n50 = message.arg2;
                            webViewCore.nativeSetSelection(n, n50);
                            return;
                        }
                        case 123: {
                            SparseBooleanArray sparseBooleanArray = (SparseBooleanArray)message.obj;
                            int n = message.arg1;
                            boolean[] blArray = new boolean[n];
                            int n51 = 0;
                            while (true) {
                                boolean bl;
                                int n52;
                                int n53;
                                if ((n53 = ++n51) >= (n52 = n)) {
                                    WebViewCore webViewCore = WebViewCore.this;
                                    boolean[] blArray2 = blArray;
                                    int n54 = n;
                                    webViewCore.nativeSendListBoxChoices(blArray2, n54);
                                    return;
                                }
                                SparseBooleanArray sparseBooleanArray2 = sparseBooleanArray;
                                int n55 = n51;
                                blArray[n51] = bl = sparseBooleanArray2.get(n55);
                            }
                        }
                        case 124: {
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            webViewCore.nativeSendListBoxChoice(n);
                            return;
                        }
                        case 126: {
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            webViewCore.nativeSetBackgroundColor(n);
                            return;
                        }
                        case 170: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.nativeDumpDomTree(bl);
                            return;
                        }
                        case 171: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.nativeDumpRenderTree(bl);
                            return;
                        }
                        case 172: {
                            WebViewCore.this.nativeDumpNavTree();
                            return;
                        }
                        case 173: {
                            WebViewCore.this.nativeDumpV8Counters();
                            return;
                        }
                        case 174: {
                            WebViewCore webViewCore = WebViewCore.this;
                            String string33 = (String)message.obj;
                            WebViewCore webViewCore6 = webViewCore;
                            String string34 = string33;
                            webViewCore6.nativeSetJsFlags(string34);
                            return;
                        }
                        case 180: {
                            GeolocationPermissionsData geolocationPermissionsData = (GeolocationPermissionsData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            String string35 = geolocationPermissionsData.mOrigin;
                            boolean bl = geolocationPermissionsData.mAllow;
                            boolean bl5 = geolocationPermissionsData.mRemember;
                            webViewCore.nativeGeolocationPermissionsProvide(string35, bl, bl5);
                            return;
                        }
                        case 131: {
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            int n56 = WebViewCore.access$5402(webViewCore, n);
                            WebViewCore webViewCore7 = WebViewCore.this;
                            int n57 = message.arg2;
                            int n58 = WebViewCore.access$5502(webViewCore7, n57);
                            return;
                        }
                        case 133: {
                            WebViewCore.this.nativeSplitContent();
                            boolean bl = WebViewCore.access$5702(WebViewCore.this, false);
                            return;
                        }
                        case 134: {
                            WebViewCore.this.nativeClearContent();
                            return;
                        }
                        case 125: {
                            if (!(message.obj instanceof Message)) {
                                return;
                            }
                            ((Message)message.obj).sendToTarget();
                            return;
                        }
                        case 181: {
                            WebViewCore webViewCore = WebViewCore.this;
                            String[] stringArray = (String[])message.obj;
                            WebViewCore webViewCore8 = webViewCore;
                            String[] stringArray2 = stringArray;
                            webViewCore8.nativeProvideVisitedHistory(stringArray2);
                            return;
                        }
                        case 146: {
                            MotionUpData motionUpData = (MotionUpData)message.obj;
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = motionUpData.mFrame;
                            int n59 = motionUpData.mNode;
                            Rect rect = motionUpData.mBounds;
                            if (!webViewCore.nativeValidNodeAndBounds(n, n59, rect)) {
                                WebViewCore.this.nativeUpdateFrameCache();
                            }
                            Handler handler = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler;
                            int n60 = motionUpData.mX;
                            int n61 = motionUpData.mY;
                            Message message8 = handler.obtainMessage(119, n60, n61);
                            Handler handler2 = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler;
                            Message message9 = message8;
                            boolean bl = handler2.sendMessageAtFrontOfQueue(message9);
                            return;
                        }
                        case 182: {
                            WebViewCore webViewCore = WebViewCore.this;
                            int n = message.arg1;
                            webViewCore.nativeFullScreenPluginHidden(n);
                            return;
                        }
                        case 184: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            JWebCoreJavaBridge jWebCoreJavaBridge = BrowserFrame.sJavaBridge;
                            Set set = (Set)message.obj;
                            JWebCoreJavaBridge jWebCoreJavaBridge3 = jWebCoreJavaBridge;
                            Set set2 = set;
                            jWebCoreJavaBridge3.addPackageNames(set2);
                            return;
                        }
                        case 185: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            JWebCoreJavaBridge jWebCoreJavaBridge = BrowserFrame.sJavaBridge;
                            String string36 = (String)message.obj;
                            JWebCoreJavaBridge jWebCoreJavaBridge4 = jWebCoreJavaBridge;
                            String string37 = string36;
                            jWebCoreJavaBridge4.addPackageName(string37);
                            return;
                        }
                        case 186: 
                    }
                    if (BrowserFrame.sJavaBridge == null) {
                        throw new IllegalStateException("No WebView has been created in this process!");
                    }
                    JWebCoreJavaBridge jWebCoreJavaBridge = BrowserFrame.sJavaBridge;
                    String string38 = (String)message.obj;
                    JWebCoreJavaBridge jWebCoreJavaBridge5 = jWebCoreJavaBridge;
                    String string39 = string38;
                    jWebCoreJavaBridge5.removePackageName(string39);
                }
            };
            synchronized (this) {
                int n3 = this.mMessages.size();
                for (int i = 0; i < n3; ++i) {
                    Handler handler2 = this.mHandler;
                    Message message = this.mMessages.get(i);
                    boolean bl = handler2.sendMessage(message);
                }
                this.mMessages = null;
                return;
            }
        }
    }

    static class GeolocationPermissionsData {
        boolean mAllow;
        String mOrigin;
        boolean mRemember;

        GeolocationPermissionsData() {
        }
    }

    static class TouchEventData {
        int mAction;
        int mMetaState;
        boolean mReprocess;
        float mViewX;
        float mViewY;
        int mX;
        int mY;

        TouchEventData() {
        }
    }

    static class TouchUpData {
        int mFrame;
        int mMoveGeneration;
        int mNode;
        int mX;
        int mY;

        TouchUpData() {
        }
    }

    static class TextSelectionData {
        int mEnd;
        int mStart;

        public TextSelectionData(int n, int n2) {
            this.mStart = n;
            this.mEnd = n2;
        }
    }

    static class ReplaceTextData {
        int mNewEnd;
        int mNewStart;
        String mReplace;
        int mTextGeneration;

        ReplaceTextData() {
        }
    }

    static class PostUrlData {
        byte[] mPostData;
        String mUrl;

        PostUrlData() {
        }
    }

    static class GetUrlData {
        Map<String, String> mExtraHeaders;
        String mUrl;

        GetUrlData() {
        }
    }

    static class MotionUpData {
        Rect mBounds;
        int mFrame;
        int mNode;
        int mX;
        int mY;

        MotionUpData() {
        }
    }

    static class JSKeyData {
        String mCurrentText;
        KeyEvent mEvent;

        JSKeyData() {
        }
    }

    static class JSInterfaceData {
        String mInterfaceName;
        Object mObject;

        JSInterfaceData() {
        }
    }

    static class CursorData {
        int mFrame;
        int mMoveGeneration;
        int mNode;
        int mX;
        int mY;

        CursorData() {
        }

        CursorData(int n, int n2, int n3, int n4) {
            this.mFrame = n;
            this.mNode = n2;
            this.mX = n3;
            this.mY = n4;
        }
    }

    static class BaseUrlData {
        String mBaseUrl;
        String mData;
        String mEncoding;
        String mHistoryUrl;
        String mMimeType;

        BaseUrlData() {
        }
    }

    private static class WebCoreThread
    implements Runnable {
        private static final int INITIALIZE = 0;
        private static final int REDUCE_PRIORITY = 1;
        private static final int RESUME_PRIORITY = 2;

        private WebCoreThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Looper.prepare();
            Assert.assertNull(sWebCoreHandler);
            synchronized (WebViewCore.class) {
                Handler handler = WebViewCore.access$402(new Handler(){

                    @Override
                    public void handleMessage(Message message) {
                        switch (message.what) {
                            default: {
                                return;
                            }
                            case 0: {
                                ((WebViewCore)message.obj).initialize();
                                return;
                            }
                            case 1: {
                                Process.setThreadPriority(3);
                                return;
                            }
                            case 2: 
                        }
                        Process.setThreadPriority(0);
                    }
                });
                WebViewCore.class.notify();
            }
            Looper.loop();
        }
    }
}

