/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import android.webkit.CacheManager;
import android.webkit.CookieManager;
import android.webkit.WebViewWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WebViewDatabase {
    private static final String CACHE_CONTENTDISPOSITION_COL = "contentdisposition";
    private static final String CACHE_CONTENTLENGTH_COL = "contentlength";
    private static final String CACHE_CROSSDOMAIN_COL = "crossdomain";
    private static final String CACHE_DATABASE_FILE = "webviewCache.db";
    private static final int CACHE_DATABASE_VERSION = 4;
    private static final String CACHE_ENCODING_COL = "encoding";
    private static final String CACHE_ETAG_COL = "etag";
    private static final String CACHE_EXPIRES_COL = "expires";
    private static final String CACHE_EXPIRES_STRING_COL = "expiresstring";
    private static final String CACHE_FILE_PATH_COL = "filepath";
    private static final String CACHE_HTTP_STATUS_COL = "httpstatus";
    private static final String CACHE_LAST_MODIFY_COL = "lastmodify";
    private static final String CACHE_LOCATION_COL = "location";
    private static final String CACHE_MIMETYPE_COL = "mimetype";
    private static final String CACHE_URL_COL = "url";
    private static final String COOKIES_DOMAIN_COL = "domain";
    private static final String COOKIES_EXPIRES_COL = "expires";
    private static final String COOKIES_NAME_COL = "name";
    private static final String COOKIES_PATH_COL = "path";
    private static final String COOKIES_SECURE_COL = "secure";
    private static final String COOKIES_VALUE_COL = "value";
    private static final String DATABASE_FILE = "webview.db";
    private static final int DATABASE_VERSION = 10;
    private static final String FORMDATA_NAME_COL = "name";
    private static final String FORMDATA_URLID_COL = "urlid";
    private static final String FORMDATA_VALUE_COL = "value";
    private static final String FORMURL_URL_COL = "url";
    private static final String HTTPAUTH_HOST_COL = "host";
    private static final String HTTPAUTH_PASSWORD_COL = "password";
    private static final String HTTPAUTH_REALM_COL = "realm";
    private static final String HTTPAUTH_USERNAME_COL = "username";
    private static final String ID_COL = "_id";
    private static final String[] ID_PROJECTION;
    protected static final String LOGTAG = "webviewdatabase";
    private static final String PASSWORD_HOST_COL = "host";
    private static final String PASSWORD_PASSWORD_COL = "password";
    private static final String PASSWORD_USERNAME_COL = "username";
    private static final int TABLE_COOKIES_ID = 0;
    private static final int TABLE_FORMDATA_ID = 3;
    private static final int TABLE_FORMURL_ID = 2;
    private static final int TABLE_HTTPAUTH_ID = 4;
    private static final int TABLE_PASSWORD_ID = 1;
    private static int mCacheContentDispositionColIndex;
    private static int mCacheContentLengthColIndex;
    private static int mCacheCrossDomainColIndex;
    private static SQLiteDatabase mCacheDatabase;
    private static int mCacheETagColIndex;
    private static int mCacheEncodingColIndex;
    private static int mCacheExpiresColIndex;
    private static int mCacheExpiresStringColIndex;
    private static int mCacheFilePathColIndex;
    private static int mCacheHttpStatusColIndex;
    private static DatabaseUtils.InsertHelper mCacheInserter;
    private static int mCacheLastModifyColIndex;
    private static int mCacheLocationColIndex;
    private static int mCacheMimeTypeColIndex;
    private static int mCacheTransactionRefcount;
    private static int mCacheUrlColIndex;
    private static SQLiteDatabase mDatabase;
    private static WebViewDatabase mInstance;
    private static final String[] mTableNames;
    private final Object mCookieLock;
    private final Object mFormLock;
    private final Object mHttpAuthLock;
    private final Object mPasswordLock;

    static {
        mInstance = null;
        mDatabase = null;
        mCacheDatabase = null;
        String[] stringArray = new String[]{"cookies", "password", "formurl", "formdata", "httpauth"};
        mTableNames = stringArray;
        String[] stringArray2 = new String[]{ID_COL};
        ID_PROJECTION = stringArray2;
    }

    private WebViewDatabase() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.mCookieLock = object4 = new Object();
        this.mPasswordLock = object3 = new Object();
        this.mFormLock = object2 = new Object();
        this.mHttpAuthLock = object = new Object();
    }

    private static void bootstrapCacheDatabase() {
        if (mCacheDatabase == null) {
            return;
        }
        mCacheDatabase.execSQL("CREATE TABLE cache (_id INTEGER PRIMARY KEY, url TEXT, filepath TEXT, lastmodify TEXT, etag TEXT, expires INTEGER, expiresstring TEXT, mimetype TEXT, encoding TEXT,httpstatus INTEGER, location TEXT, contentlength INTEGER, contentdisposition TEXT, crossdomain TEXT, UNIQUE (url) ON CONFLICT REPLACE);");
        mCacheDatabase.execSQL("CREATE INDEX cacheUrlIndex ON cache (url)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebViewDatabase getInstance(Context context) {
        synchronized (WebViewDatabase.class) {
            block20: {
                block19: {
                    if (mInstance != null) return mInstance;
                    mInstance = new WebViewDatabase();
                    try {
                        mDatabase = context.openOrCreateDatabase(DATABASE_FILE, 0, null);
                    }
                    catch (SQLiteException sQLiteException) {
                        if (!context.deleteDatabase(DATABASE_FILE)) break block19;
                        mDatabase = context.openOrCreateDatabase(DATABASE_FILE, 0, null);
                    }
                }
                if (mDatabase != null && mDatabase.getVersion() != 10) {
                    mDatabase.beginTransaction();
                    WebViewDatabase.upgradeDatabase();
                    mDatabase.setTransactionSuccessful();
                }
                if (mDatabase != null) {
                    mDatabase.setLockingEnabled(false);
                }
                try {
                    mCacheDatabase = context.openOrCreateDatabase(CACHE_DATABASE_FILE, 0, null);
                }
                catch (SQLiteException sQLiteException) {
                    if (!context.deleteDatabase(CACHE_DATABASE_FILE)) break block20;
                    mCacheDatabase = context.openOrCreateDatabase(CACHE_DATABASE_FILE, 0, null);
                }
                finally {
                    mDatabase.endTransaction();
                }
            }
            if (mCacheDatabase != null && mCacheDatabase.getVersion() != 4) {
                mCacheDatabase.beginTransaction();
                WebViewDatabase.upgradeCacheDatabase();
                WebViewDatabase.bootstrapCacheDatabase();
                mCacheDatabase.setTransactionSuccessful();
                boolean bl = CacheManager.removeAllCacheFiles();
            }
            if (mCacheDatabase == null) return mInstance;
            mCacheDatabase.execSQL("PRAGMA read_uncommitted = true;");
            mCacheDatabase.setLockingEnabled(false);
            SQLiteDatabase sQLiteDatabase = mCacheDatabase;
            mCacheInserter = new DatabaseUtils.InsertHelper(sQLiteDatabase, "cache");
            mCacheUrlColIndex = mCacheInserter.getColumnIndex("url");
            mCacheFilePathColIndex = mCacheInserter.getColumnIndex(CACHE_FILE_PATH_COL);
            mCacheLastModifyColIndex = mCacheInserter.getColumnIndex(CACHE_LAST_MODIFY_COL);
            mCacheETagColIndex = mCacheInserter.getColumnIndex(CACHE_ETAG_COL);
            mCacheExpiresColIndex = mCacheInserter.getColumnIndex("expires");
            mCacheExpiresStringColIndex = mCacheInserter.getColumnIndex(CACHE_EXPIRES_STRING_COL);
            mCacheMimeTypeColIndex = mCacheInserter.getColumnIndex(CACHE_MIMETYPE_COL);
            mCacheEncodingColIndex = mCacheInserter.getColumnIndex(CACHE_ENCODING_COL);
            mCacheHttpStatusColIndex = mCacheInserter.getColumnIndex(CACHE_HTTP_STATUS_COL);
            mCacheLocationColIndex = mCacheInserter.getColumnIndex(CACHE_LOCATION_COL);
            mCacheContentLengthColIndex = mCacheInserter.getColumnIndex(CACHE_CONTENTLENGTH_COL);
            mCacheContentDispositionColIndex = mCacheInserter.getColumnIndex(CACHE_CONTENTDISPOSITION_COL);
            mCacheCrossDomainColIndex = mCacheInserter.getColumnIndex(CACHE_CROSSDOMAIN_COL);
            return mInstance;
            finally {
                mCacheDatabase.endTransaction();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean hasEntries(int var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void upgradeCacheDatabase() {
        int n = mCacheDatabase.getVersion();
        if (n != 0) {
            String string2 = "Upgrading cache database from version " + n + " to " + 10 + ", which will destroy all old data";
            int n2 = Log.i(LOGTAG, string2);
        }
        mCacheDatabase.execSQL("DROP TABLE IF EXISTS cache");
        mCacheDatabase.setVersion(4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void upgradeDatabase() {
        int n = mDatabase.getVersion();
        if (n != 0) {
            String string2 = "Upgrading database from version " + n + " to " + 10 + ", which will destroy old data";
            int n2 = Log.i(LOGTAG, string2);
        }
        if (8 != n) {
            // empty if block
        }
        boolean bl = false;
        boolean bl2 = 9 != n;
        if (bl2) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            StringBuilder stringBuilder = new StringBuilder().append("DROP TABLE IF EXISTS ");
            String string3 = mTableNames[4];
            String string4 = stringBuilder.append(string3).toString();
            sQLiteDatabase.execSQL(string4);
            SQLiteDatabase sQLiteDatabase2 = mDatabase;
            StringBuilder stringBuilder2 = new StringBuilder().append("CREATE TABLE ");
            String string5 = mTableNames[4];
            String string6 = stringBuilder2.append(string5).append(" (").append(ID_COL).append(" INTEGER PRIMARY KEY, ").append("host").append(" TEXT, ").append(HTTPAUTH_REALM_COL).append(" TEXT, ").append("username").append(" TEXT, ").append("password").append(" TEXT,").append(" UNIQUE (").append("host").append(", ").append(HTTPAUTH_REALM_COL).append(") ON CONFLICT REPLACE);").toString();
            sQLiteDatabase2.execSQL(string6);
            return;
        }
        if (!bl) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            StringBuilder stringBuilder = new StringBuilder().append("DROP TABLE IF EXISTS ");
            String string7 = mTableNames[0];
            String string8 = stringBuilder.append(string7).toString();
            sQLiteDatabase.execSQL(string8);
            mDatabase.execSQL("DROP TABLE IF EXISTS cache");
            SQLiteDatabase sQLiteDatabase3 = mDatabase;
            StringBuilder stringBuilder3 = new StringBuilder().append("DROP TABLE IF EXISTS ");
            String string9 = mTableNames[2];
            String string10 = stringBuilder3.append(string9).toString();
            sQLiteDatabase3.execSQL(string10);
            SQLiteDatabase sQLiteDatabase4 = mDatabase;
            StringBuilder stringBuilder4 = new StringBuilder().append("DROP TABLE IF EXISTS ");
            String string11 = mTableNames[3];
            String string12 = stringBuilder4.append(string11).toString();
            sQLiteDatabase4.execSQL(string12);
            SQLiteDatabase sQLiteDatabase5 = mDatabase;
            StringBuilder stringBuilder5 = new StringBuilder().append("DROP TABLE IF EXISTS ");
            String string13 = mTableNames[4];
            String string14 = stringBuilder5.append(string13).toString();
            sQLiteDatabase5.execSQL(string14);
        }
        SQLiteDatabase sQLiteDatabase = mDatabase;
        StringBuilder stringBuilder = new StringBuilder().append("DROP TABLE IF EXISTS ");
        String string15 = mTableNames[1];
        String string16 = stringBuilder.append(string15).toString();
        sQLiteDatabase.execSQL(string16);
        mDatabase.setVersion(10);
        if (!bl) {
            SQLiteDatabase sQLiteDatabase6 = mDatabase;
            StringBuilder stringBuilder6 = new StringBuilder().append("CREATE TABLE ");
            String string17 = mTableNames[0];
            String string18 = stringBuilder6.append(string17).append(" (").append(ID_COL).append(" INTEGER PRIMARY KEY, ").append("name").append(" TEXT, ").append("value").append(" TEXT, ").append(COOKIES_DOMAIN_COL).append(" TEXT, ").append(COOKIES_PATH_COL).append(" TEXT, ").append("expires").append(" INTEGER, ").append(COOKIES_SECURE_COL).append(" INTEGER").append(");").toString();
            sQLiteDatabase6.execSQL(string18);
            SQLiteDatabase sQLiteDatabase7 = mDatabase;
            StringBuilder stringBuilder7 = new StringBuilder().append("CREATE INDEX cookiesIndex ON ");
            String string19 = mTableNames[0];
            String string20 = stringBuilder7.append(string19).append(" (path)").toString();
            sQLiteDatabase7.execSQL(string20);
            SQLiteDatabase sQLiteDatabase8 = mDatabase;
            StringBuilder stringBuilder8 = new StringBuilder().append("CREATE TABLE ");
            String string21 = mTableNames[2];
            String string22 = stringBuilder8.append(string21).append(" (").append(ID_COL).append(" INTEGER PRIMARY KEY, ").append("url").append(" TEXT").append(");").toString();
            sQLiteDatabase8.execSQL(string22);
            SQLiteDatabase sQLiteDatabase9 = mDatabase;
            StringBuilder stringBuilder9 = new StringBuilder().append("CREATE TABLE ");
            String string23 = mTableNames[3];
            String string24 = stringBuilder9.append(string23).append(" (").append(ID_COL).append(" INTEGER PRIMARY KEY, ").append(FORMDATA_URLID_COL).append(" INTEGER, ").append("name").append(" TEXT, ").append("value").append(" TEXT,").append(" UNIQUE (").append(FORMDATA_URLID_COL).append(", ").append("name").append(", ").append("value").append(") ON CONFLICT IGNORE);").toString();
            sQLiteDatabase9.execSQL(string24);
            SQLiteDatabase sQLiteDatabase10 = mDatabase;
            StringBuilder stringBuilder10 = new StringBuilder().append("CREATE TABLE ");
            String string25 = mTableNames[4];
            String string26 = stringBuilder10.append(string25).append(" (").append(ID_COL).append(" INTEGER PRIMARY KEY, ").append("host").append(" TEXT, ").append(HTTPAUTH_REALM_COL).append(" TEXT, ").append("username").append(" TEXT, ").append("password").append(" TEXT,").append(" UNIQUE (").append("host").append(", ").append(HTTPAUTH_REALM_COL).append(") ON CONFLICT REPLACE);").toString();
            sQLiteDatabase10.execSQL(string26);
        }
        SQLiteDatabase sQLiteDatabase11 = mDatabase;
        StringBuilder stringBuilder11 = new StringBuilder().append("CREATE TABLE ");
        String string27 = mTableNames[1];
        String string28 = stringBuilder11.append(string27).append(" (").append(ID_COL).append(" INTEGER PRIMARY KEY, ").append("host").append(" TEXT, ").append("username").append(" TEXT, ").append("password").append(" TEXT,").append(" UNIQUE (").append("host").append(", ").append("username").append(") ON CONFLICT REPLACE);").toString();
        sQLiteDatabase11.execSQL(string28);
    }

    void addCache(String string2, CacheManager.CacheResult cacheResult) {
        if (string2 == null) {
            return;
        }
        if (mCacheDatabase == null) {
            return;
        }
        mCacheInserter.prepareForInsert();
        DatabaseUtils.InsertHelper insertHelper = mCacheInserter;
        int n = mCacheUrlColIndex;
        insertHelper.bind(n, string2);
        DatabaseUtils.InsertHelper insertHelper2 = mCacheInserter;
        int n2 = mCacheFilePathColIndex;
        String string3 = cacheResult.localPath;
        insertHelper2.bind(n2, string3);
        DatabaseUtils.InsertHelper insertHelper3 = mCacheInserter;
        int n3 = mCacheLastModifyColIndex;
        String string4 = cacheResult.lastModified;
        insertHelper3.bind(n3, string4);
        DatabaseUtils.InsertHelper insertHelper4 = mCacheInserter;
        int n4 = mCacheETagColIndex;
        String string5 = cacheResult.etag;
        insertHelper4.bind(n4, string5);
        DatabaseUtils.InsertHelper insertHelper5 = mCacheInserter;
        int n5 = mCacheExpiresColIndex;
        long l = cacheResult.expires;
        insertHelper5.bind(n5, l);
        DatabaseUtils.InsertHelper insertHelper6 = mCacheInserter;
        int n6 = mCacheExpiresStringColIndex;
        String string6 = cacheResult.expiresString;
        insertHelper6.bind(n6, string6);
        DatabaseUtils.InsertHelper insertHelper7 = mCacheInserter;
        int n7 = mCacheMimeTypeColIndex;
        String string7 = cacheResult.mimeType;
        insertHelper7.bind(n7, string7);
        DatabaseUtils.InsertHelper insertHelper8 = mCacheInserter;
        int n8 = mCacheEncodingColIndex;
        String string8 = cacheResult.encoding;
        insertHelper8.bind(n8, string8);
        DatabaseUtils.InsertHelper insertHelper9 = mCacheInserter;
        int n9 = mCacheHttpStatusColIndex;
        int n10 = cacheResult.httpStatusCode;
        insertHelper9.bind(n9, n10);
        DatabaseUtils.InsertHelper insertHelper10 = mCacheInserter;
        int n11 = mCacheLocationColIndex;
        String string9 = cacheResult.location;
        insertHelper10.bind(n11, string9);
        DatabaseUtils.InsertHelper insertHelper11 = mCacheInserter;
        int n12 = mCacheContentLengthColIndex;
        long l2 = cacheResult.contentLength;
        insertHelper11.bind(n12, l2);
        DatabaseUtils.InsertHelper insertHelper12 = mCacheInserter;
        int n13 = mCacheContentDispositionColIndex;
        String string10 = cacheResult.contentdisposition;
        insertHelper12.bind(n13, string10);
        DatabaseUtils.InsertHelper insertHelper13 = mCacheInserter;
        int n14 = mCacheCrossDomainColIndex;
        String string11 = cacheResult.crossDomain;
        insertHelper13.bind(n14, string11);
        long l3 = mCacheInserter.execute();
    }

    void addCookie(CookieManager.Cookie cookie) {
        if (cookie.domain == null) {
            return;
        }
        if (cookie.path == null) {
            return;
        }
        if (cookie.name == null) {
            return;
        }
        if (mDatabase == null) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            ContentValues contentValues = new ContentValues();
            String string2 = cookie.domain;
            contentValues.put(COOKIES_DOMAIN_COL, string2);
            String string3 = cookie.path;
            contentValues.put(COOKIES_PATH_COL, string3);
            String string4 = cookie.name;
            contentValues.put("name", string4);
            String string5 = cookie.value;
            contentValues.put("value", string5);
            if (cookie.expires != 65535L) {
                Long l = cookie.expires;
                contentValues.put("expires", l);
            }
            Boolean bl = cookie.secure;
            contentValues.put(COOKIES_SECURE_COL, bl);
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string6 = mTableNames[0];
            long l = sQLiteDatabase.insert(string6, null, contentValues);
            return;
        }
    }

    void clearCache() {
        if (mCacheDatabase == null) {
            return;
        }
        int n = mCacheDatabase.delete("cache", null, null);
    }

    void clearCookies() {
        if (mDatabase == null) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string2 = mTableNames[0];
            int n = sQLiteDatabase.delete(string2, null, null);
            return;
        }
    }

    void clearExpiredCookies(long l) {
        if (mDatabase == null) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string2 = mTableNames[0];
            String string3 = Long.toString(l);
            String[] stringArray = new String[]{string3};
            int n = sQLiteDatabase.delete(string2, "expires <= ?", stringArray);
            return;
        }
    }

    public void clearFormData() {
        if (mDatabase == null) {
            return;
        }
        Object object = this.mFormLock;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string2 = mTableNames[2];
            int n = sQLiteDatabase.delete(string2, null, null);
            SQLiteDatabase sQLiteDatabase2 = mDatabase;
            String string3 = mTableNames[3];
            int n2 = sQLiteDatabase2.delete(string3, null, null);
            return;
        }
    }

    public void clearHttpAuthUsernamePassword() {
        if (mDatabase == null) {
            return;
        }
        Object object = this.mHttpAuthLock;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string2 = mTableNames[4];
            int n = sQLiteDatabase.delete(string2, null, null);
            return;
        }
    }

    void clearSessionCookies() {
        if (mDatabase == null) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string2 = mTableNames[0];
            int n = sQLiteDatabase.delete(string2, "expires ISNULL", null);
            return;
        }
    }

    public void clearUsernamePassword() {
        if (mDatabase == null) {
            return;
        }
        Object object = this.mPasswordLock;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string2 = mTableNames[1];
            int n = sQLiteDatabase.delete(string2, null, null);
            return;
        }
    }

    void deleteCookies(String string2, String string3, String string4) {
        if (string2 == null) {
            return;
        }
        if (mDatabase == null) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string5 = mTableNames[0];
            String[] stringArray = new String[]{string2, string3, string4};
            int n = sQLiteDatabase.delete(string5, "(domain == ?) AND (path == ?) AND (name == ?)", stringArray);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean endCacheTransaction() {
        Thread thread;
        int n;
        mCacheTransactionRefcount = n = mCacheTransactionRefcount - 1;
        if (n != 0) return false;
        Thread thread2 = Thread.currentThread();
        if (!thread2.equals(thread = WebViewWorker.getHandler().getLooper().getThread())) {
            StringBuilder stringBuilder = new StringBuilder().append("endCacheTransaction should be called from WebViewWorkerThread instead of from ");
            String string2 = Thread.currentThread().getName();
            String string3 = stringBuilder.append(string2).toString();
            int n2 = Log.w(LOGTAG, string3);
        }
        mCacheDatabase.setTransactionSuccessful();
        boolean bl = true;
        return bl;
        finally {
            mCacheDatabase.endTransaction();
        }
    }

    /*
     * Exception decompiling
     */
    List<String> getAllCacheFileNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    CacheManager.CacheResult getCache(String var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    long getCacheTotalSize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ArrayList<CookieManager.Cookie> getCookiesForDomain(String string2) {
        ArrayList<CookieManager.Cookie> arrayList = new ArrayList<CookieManager.Cookie>();
        if (string2 == null) return arrayList;
        if (mDatabase == null) {
            return arrayList;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            Cursor cursor;
            Object var4_4 = null;
            String[] stringArray = new String[var4_4];
            stringArray[0] = ID_COL;
            stringArray[1] = COOKIES_DOMAIN_COL;
            stringArray[2] = COOKIES_PATH_COL;
            stringArray[3] = "name";
            stringArray[4] = "value";
            stringArray[5] = "expires";
            stringArray[6] = COOKIES_SECURE_COL;
            try {
                SQLiteDatabase sQLiteDatabase = mDatabase;
                String string3 = mTableNames[0];
                String[] stringArray2 = new String[]{string2};
                cursor = sQLiteDatabase.query(string3, stringArray, "(domain GLOB '*' || ?)", stringArray2, null, null, null);
                if (cursor.moveToFirst()) {
                    boolean bl;
                    int n = cursor.getColumnIndex(COOKIES_DOMAIN_COL);
                    int n2 = cursor.getColumnIndex(COOKIES_PATH_COL);
                    int n3 = cursor.getColumnIndex("name");
                    int n4 = cursor.getColumnIndex("value");
                    int n5 = cursor.getColumnIndex("expires");
                    int n6 = cursor.getColumnIndex(COOKIES_SECURE_COL);
                    do {
                        int n7;
                        Cursor cursor2;
                        String string4;
                        String string5;
                        String string6;
                        String string7;
                        CookieManager.Cookie cookie = new CookieManager.Cookie();
                        cookie.domain = string7 = cursor.getString(n);
                        Cursor cursor3 = cursor;
                        int n8 = n2;
                        cookie.path = string6 = cursor3.getString(n8);
                        Cursor cursor4 = cursor;
                        int n9 = n3;
                        cookie.name = string5 = cursor4.getString(n9);
                        Cursor cursor5 = cursor;
                        int n10 = n4;
                        cookie.value = string4 = cursor5.getString(n10);
                        if (cursor.isNull(n5)) {
                            cookie.expires = 65535L;
                        } else {
                            long l;
                            cookie.expires = l = cursor.getLong(n5);
                        }
                        var4_4 = (cursor2 = cursor).getShort(n7 = n6) != null ? null : null;
                        cookie.secure = var4_4;
                        cookie.mode = 1;
                        boolean bl2 = arrayList.add(cookie);
                    } while (bl = cursor.moveToNext());
                }
                if (cursor == null) return arrayList;
            }
            catch (IllegalStateException illegalStateException) {
                int n = Log.e(LOGTAG, "getCookiesForDomain", illegalStateException);
                if (cursor == null) return arrayList;
                cursor.close();
            }
            cursor.close();
            return arrayList;
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    ArrayList<String> getFormData(String var1, String var2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [11 : 345->355)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    String[] getHttpAuthUsernamePassword(String var1, String var2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 232->242)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    String[] getUsernamePassword(String var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 219->229)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    boolean hasCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean hasCookies() {
        Object object = this.mCookieLock;
        synchronized (object) {
            boolean bl = this.hasEntries(0);
            return bl;
        }
    }

    public boolean hasFormData() {
        Object object = this.mFormLock;
        synchronized (object) {
            boolean bl = this.hasEntries(2);
            return bl;
        }
    }

    public boolean hasHttpAuthUsernamePassword() {
        Object object = this.mHttpAuthLock;
        synchronized (object) {
            boolean bl = this.hasEntries(4);
            return bl;
        }
    }

    public boolean hasUsernamePassword() {
        Object object = this.mPasswordLock;
        synchronized (object) {
            boolean bl = this.hasEntries(1);
            return bl;
        }
    }

    void removeCache(String string2) {
        if (string2 == null) {
            return;
        }
        if (mCacheDatabase == null) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = mCacheDatabase;
        Object[] objectArray = new String[]{string2};
        sQLiteDatabase.execSQL("DELETE FROM cache WHERE url = ?", objectArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setFormData(String var1_1, HashMap<String, String> var2_2) {
        if (var1_1 == null) {
            return;
        }
        if (var2_2 == null) {
            return;
        }
        if (WebViewDatabase.mDatabase == null) {
            return;
        }
        var3_3 = this.mFormLock;
        synchronized (var3_3) {
            block18: {
                var4_4 = 65535L;
                try {
                    var6_5 = WebViewDatabase.mDatabase;
                    var7_6 = WebViewDatabase.mTableNames[2];
                    var8_7 = WebViewDatabase.ID_PROJECTION;
                    var9_8 = new String[]{var1_1};
                    var10_9 = var6_5.query(var7_6, var8_7, "(url == ?)", var9_8, null, null, null);
                    if (var10_9.moveToFirst()) {
                        var11_10 = var10_9.getColumnIndex("_id");
                        var4_4 = var12_11 = var10_9.getLong(var11_10);
                    }
                    ** GOTO lbl-1000
                }
                catch (IllegalStateException var44_18) {
                    var45_19 = Log.e("webviewdatabase", "setFormData", var44_18);
                    if (var10_9 != null) {
                        var10_9.close();
                    }
                    ** GOTO lbl33
                }
                catch (Throwable var46_42) {
                    if (var10_9 != null) {
                        var10_9.close();
                    }
                    throw var46_42;
                }
lbl30:
                // 2 sources

                while (true) {
                    if (var10_9 != null) {
                        var10_9.close();
                    }
lbl33:
                    // 4 sources

                    if (var4_4 >= 0L) {
                        var14_20 = var2_2.entrySet().iterator();
                        var15_21 = new ContentValues();
                        var16_22 = var4_4;
                        var17_23 = var15_21;
                        var18_24 = "urlid";
                        var19_25 = var16_22;
                        var17_23.put(var18_24, var19_25);
                        while (var14_20.hasNext()) {
                            var20_26 = var14_20.next();
                            var21_27 = var20_26.getKey();
                            var22_28 = var15_21;
                            var23_29 = "name";
                            var24_30 = var21_27;
                            var22_28.put(var23_29, var24_30);
                            var25_31 = var20_26.getValue();
                            var26_32 = var15_21;
                            var27_33 = "value";
                            var28_34 = var25_31;
                            var26_32.put(var27_33, var28_34);
                            var29_35 = WebViewDatabase.mDatabase;
                            var30_36 = WebViewDatabase.mTableNames[3];
                            var31_37 = var29_35;
                            var32_38 = var30_36;
                            var33_39 = null;
                            var34_40 = var15_21;
                            var35_41 = var31_37.insert(var32_38, var33_39, var34_40);
                        }
                    }
                    break block18;
                    break;
                }
lbl-1000:
                // 1 sources

                {
                    var39_13 = var38_12 = new ContentValues();
                    var40_14 = "url";
                    var41_15 = var1_1;
                    var39_13.put(var40_14, var41_15);
                    var42_16 = WebViewDatabase.mDatabase;
                    var43_17 = WebViewDatabase.mTableNames[2];
                    var4_4 = var12_11 = var42_16.insert(var43_17, null, var38_12);
                    ** continue;
                }
            }
            return;
        }
    }

    void setHttpAuthUsernamePassword(String string2, String string3, String string4, String string5) {
        if (string2 == null) {
            return;
        }
        if (string3 == null) {
            return;
        }
        if (mDatabase == null) {
            return;
        }
        Object object = this.mHttpAuthLock;
        synchronized (object) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("host", string2);
            contentValues.put(HTTPAUTH_REALM_COL, string3);
            contentValues.put("username", string4);
            contentValues.put("password", string5);
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string6 = mTableNames[4];
            long l = sQLiteDatabase.insert(string6, "host", contentValues);
            return;
        }
    }

    void setUsernamePassword(String string2, String string3, String string4) {
        if (string2 == null) {
            return;
        }
        if (mDatabase == null) {
            return;
        }
        Object object = this.mPasswordLock;
        synchronized (object) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("host", string2);
            contentValues.put("username", string3);
            contentValues.put("password", string4);
            SQLiteDatabase sQLiteDatabase = mDatabase;
            String string5 = mTableNames[1];
            long l = sQLiteDatabase.insert(string5, "host", contentValues);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean startCacheTransaction() {
        Thread thread;
        int n;
        mCacheTransactionRefcount = n = mCacheTransactionRefcount + 1;
        if (n != 1) return false;
        Thread thread2 = Thread.currentThread();
        if (!thread2.equals(thread = WebViewWorker.getHandler().getLooper().getThread())) {
            StringBuilder stringBuilder = new StringBuilder().append("startCacheTransaction should be called from WebViewWorkerThread instead of from ");
            String string2 = Thread.currentThread().getName();
            String string3 = stringBuilder.append(string2).toString();
            int n2 = Log.w(LOGTAG, string3);
        }
        mCacheDatabase.beginTransaction();
        return true;
    }

    /*
     * Exception decompiling
     */
    List<String> trimCache(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [12, 13 : 339->347)] java.lang.IllegalStateException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

