/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.Headers;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.webkit.ByteArrayBuilder;
import android.webkit.CacheManager;
import android.webkit.FrameLoader;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

final class WebViewWorker
extends Handler {
    private static final int CACHE_TRANSACTION_TICKER_INTERVAL = 60000;
    static final int MSG_ADD_HTTPLOADER = 102;
    static final int MSG_ADD_STREAMLOADER = 101;
    static final int MSG_APPEND_CACHE = 105;
    static final int MSG_CACHE_TRANSACTION_TICKER = 110;
    static final int MSG_CLEAR_CACHE = 109;
    static final int MSG_CREATE_CACHE = 103;
    static final int MSG_PAUSE_CACHE_TRANSACTION = 111;
    static final int MSG_REMOVE_CACHE = 107;
    static final int MSG_RESUME_CACHE_TRANSACTION = 112;
    static final int MSG_SAVE_CACHE = 106;
    static final int MSG_TRIM_CACHE = 108;
    static final int MSG_UPDATE_CACHE_ENCODING = 104;
    private static final String THREAD_NAME = "WebViewWorkerThread";
    private static Map<LoadListener, CacheManager.CacheResult> mCacheResultMap = new HashMap<LoadListener, CacheManager.CacheResult>();
    private static boolean mCacheTickersBlocked = true;
    private static WebViewWorker sWorkerHandler;

    private WebViewWorker(Looper looper) {
        super(looper);
    }

    static WebViewWorker getHandler() {
        synchronized (WebViewWorker.class) {
            if (sWorkerHandler == null) {
                HandlerThread handlerThread = new HandlerThread(THREAD_NAME, 1);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                sWorkerHandler = new WebViewWorker(looper);
            }
            WebViewWorker webViewWorker = sWorkerHandler;
            return webViewWorker;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 101: {
                ((StreamLoader)message.obj).load();
                return;
            }
            case 102: {
                boolean bl = ((FrameLoader)message.obj).handleHTTPLoad();
                return;
            }
            case 103: {
                CacheCreateData cacheCreateData = (CacheCreateData)message.obj;
                String string2 = cacheCreateData.mUrl;
                int n = cacheCreateData.mStatusCode;
                Headers headers = cacheCreateData.mHeaders;
                String string3 = cacheCreateData.mMimeType;
                long l = cacheCreateData.mPostId;
                CacheManager.CacheResult cacheResult = CacheManager.createCacheFile(string2, n, headers, string3, l, false);
                if (cacheResult != null) {
                    Map<LoadListener, CacheManager.CacheResult> map = mCacheResultMap;
                    LoadListener loadListener = cacheCreateData.mListener;
                    CacheManager.CacheResult cacheResult2 = map.put(loadListener, cacheResult);
                    return;
                }
                Map<LoadListener, CacheManager.CacheResult> map = mCacheResultMap;
                LoadListener loadListener = cacheCreateData.mListener;
                CacheManager.CacheResult cacheResult3 = map.remove(loadListener);
                return;
            }
            case 104: {
                String string4;
                CacheEncoding cacheEncoding = (CacheEncoding)message.obj;
                Map<LoadListener, CacheManager.CacheResult> map = mCacheResultMap;
                LoadListener loadListener = cacheEncoding.mListener;
                CacheManager.CacheResult cacheResult = map.get(loadListener);
                if (cacheResult == null) {
                    return;
                }
                cacheResult.encoding = string4 = cacheEncoding.mEncoding;
                return;
            }
            case 105: {
                CacheData cacheData = (CacheData)message.obj;
                Map<LoadListener, CacheManager.CacheResult> map = mCacheResultMap;
                LoadListener loadListener = cacheData.mListener;
                CacheManager.CacheResult cacheResult = map.get(loadListener);
                if (cacheResult != null) {
                    long l = cacheResult.contentLength;
                    long l2 = cacheData.mChunk.mLength;
                    long l3 = l + l2;
                    cacheResult.contentLength = l3;
                    long l4 = cacheResult.contentLength;
                    long l5 = CacheManager.CACHE_MAX_SIZE;
                    if (l4 > l5) {
                        boolean bl = CacheManager.cleanupCacheFile(cacheResult);
                        Map<LoadListener, CacheManager.CacheResult> map2 = mCacheResultMap;
                        LoadListener loadListener2 = cacheData.mListener;
                        CacheManager.CacheResult cacheResult4 = map2.remove(loadListener2);
                    } else {
                        try {
                            OutputStream outputStream = cacheResult.outStream;
                            byte[] byArray = cacheData.mChunk.mArray;
                            int n = cacheData.mChunk.mLength;
                            outputStream.write(byArray, 0, n);
                        }
                        catch (IOException iOException) {
                            boolean bl = CacheManager.cleanupCacheFile(cacheResult);
                            Map<LoadListener, CacheManager.CacheResult> map3 = mCacheResultMap;
                            LoadListener loadListener3 = cacheData.mListener;
                            CacheManager.CacheResult cacheResult5 = map3.remove(loadListener3);
                        }
                    }
                }
                cacheData.mChunk.release();
                return;
            }
            case 106: {
                CacheSaveData cacheSaveData = (CacheSaveData)message.obj;
                Map<LoadListener, CacheManager.CacheResult> map = mCacheResultMap;
                LoadListener loadListener = cacheSaveData.mListener;
                CacheManager.CacheResult cacheResult = map.get(loadListener);
                if (cacheResult == null) {
                    return;
                }
                String string5 = cacheSaveData.mUrl;
                long l = cacheSaveData.mPostId;
                CacheManager.saveCacheFile(string5, l, cacheResult);
                Map<LoadListener, CacheManager.CacheResult> map4 = mCacheResultMap;
                LoadListener loadListener4 = cacheSaveData.mListener;
                CacheManager.CacheResult cacheResult6 = map4.remove(loadListener4);
                return;
            }
            case 107: {
                LoadListener loadListener = (LoadListener)message.obj;
                CacheManager.CacheResult cacheResult = mCacheResultMap.get(loadListener);
                if (cacheResult == null) {
                    return;
                }
                boolean bl = CacheManager.cleanupCacheFile(cacheResult);
                CacheManager.CacheResult cacheResult7 = mCacheResultMap.remove(loadListener);
                return;
            }
            case 108: {
                CacheManager.trimCacheIfNeeded();
                return;
            }
            case 109: {
                CacheManager.clearCache();
                return;
            }
            case 110: {
                if (mCacheTickersBlocked) {
                    return;
                }
                boolean bl = CacheManager.endTransaction();
                boolean bl2 = CacheManager.startTransaction();
                boolean bl3 = this.sendEmptyMessageDelayed(110, 60000L);
                return;
            }
            case 111: {
                if (!CacheManager.disableTransaction()) {
                    return;
                }
                mCacheTickersBlocked = true;
                this.removeMessages(110);
                return;
            }
            case 112: 
        }
        if (!CacheManager.enableTransaction()) {
            return;
        }
        mCacheTickersBlocked = false;
        boolean bl = this.sendEmptyMessageDelayed(110, 60000L);
    }

    static class CacheData {
        ByteArrayBuilder.Chunk mChunk;
        LoadListener mListener;

        CacheData() {
        }
    }

    static class CacheEncoding {
        String mEncoding;
        LoadListener mListener;

        CacheEncoding() {
        }
    }

    static class CacheSaveData {
        LoadListener mListener;
        long mPostId;
        String mUrl;

        CacheSaveData() {
        }
    }

    static class CacheCreateData {
        Headers mHeaders;
        LoadListener mListener;
        String mMimeType;
        long mPostId;
        int mStatusCode;
        String mUrl;

        CacheCreateData() {
        }
    }
}

