/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.ProgressBar;
import com.android.internal.R;

public abstract class AbsSeekBar
extends ProgressBar {
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha;
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private Drawable mThumb;
    private int mThumbOffset;
    float mTouchProgressOffset;

    public AbsSeekBar(Context context) {
        super(context);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        float f;
        int[] nArray = R.styleable.SeekBar;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        Drawable drawable2 = typedArray.getDrawable(0);
        this.setThumb(drawable2);
        int n2 = this.getThumbOffset();
        int n3 = typedArray.getDimensionPixelOffset(1, n2);
        this.setThumbOffset(n3);
        typedArray.recycle();
        int[] nArray2 = R.styleable.Theme;
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, nArray2, 0, 0);
        this.mDisabledAlpha = f = typedArray2.getFloat(3, 0.5f);
        typedArray2.recycle();
    }

    private void attemptClaimDrag() {
        if (this.mParent == null) {
            return;
        }
        this.mParent.requestDisallowInterceptTouchEvent(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setThumbPos(int n, Drawable drawable2, float f, int n2) {
        int n3;
        int n4;
        int n5 = this.mPaddingLeft;
        int n6 = n - n5;
        int n7 = this.mPaddingRight;
        int n8 = n6 - n7;
        int n9 = drawable2.getIntrinsicWidth();
        int n10 = drawable2.getIntrinsicHeight();
        int n11 = n8 - n9;
        int n12 = this.mThumbOffset * 2;
        int n13 = (int)((float)(n11 + n12) * f);
        if (n2 == Integer.MIN_VALUE) {
            Rect rect = drawable2.getBounds();
            n4 = rect.top;
            n3 = rect.bottom;
        } else {
            n4 = n2;
            n3 = n2 + n10;
        }
        int n14 = n13 + n9;
        drawable2.setBounds(n13, n4, n14, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void trackTouchEvent(MotionEvent motionEvent) {
        float f;
        int n = this.getWidth();
        int n2 = this.mPaddingLeft;
        int n3 = n - n2;
        int n4 = this.mPaddingRight;
        int n5 = n3 - n4;
        int n6 = (int)motionEvent.getX();
        float f2 = 0.0f;
        int n7 = this.mPaddingLeft;
        if (n6 < n7) {
            f = 0.0f;
        } else {
            int n8 = this.mPaddingRight;
            int n9 = n - n8;
            if (n6 > n9) {
                f = 1.0f;
            } else {
                int n10 = this.mPaddingLeft;
                float f3 = n6 - n10;
                float f4 = n5;
                f = f3 / f4;
                f2 = this.mTouchProgressOffset;
            }
        }
        float f5 = (float)this.getMax() * f;
        int n11 = (int)(f2 + f5);
        this.setProgress(n11, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.getProgressDrawable();
        if (drawable2 != null) {
            int n;
            if (this.isEnabled()) {
                n = 255;
            } else {
                float f = this.mDisabledAlpha;
                n = (int)(255.0f * f);
            }
            drawable2.setAlpha(n);
        }
        if (this.mThumb == null) {
            return;
        }
        if (!this.mThumb.isStateful()) {
            return;
        }
        int[] nArray = this.getDrawableState();
        boolean bl = this.mThumb.setState(nArray);
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    public int getThumbOffset() {
        return this.mThumbOffset;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        synchronized (this) {
            super.onDraw(canvas);
            if (this.mThumb != null) {
                int n = canvas.save();
                int n2 = this.mPaddingLeft;
                int n3 = this.mThumbOffset;
                float f = n2 - n3;
                float f2 = this.mPaddingTop;
                canvas.translate(f, f2);
                this.mThumb.draw(canvas);
                canvas.restore();
            }
            return;
        }
    }

    void onKeyChange() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.isEnabled()) return super.onKeyDown(n, keyEvent);
        int n2 = this.getProgress();
        switch (n) {
            default: {
                return super.onKeyDown(n, keyEvent);
            }
            case 21: {
                if (n2 <= 0) return super.onKeyDown(n, keyEvent);
                int n3 = this.mKeyProgressIncrement;
                int n4 = n2 - n3;
                this.setProgress(n4, true);
                this.onKeyChange();
                return true;
            }
            case 22: 
        }
        int n5 = this.getMax();
        if (n2 >= n5) return super.onKeyDown(n, keyEvent);
        int n6 = this.mKeyProgressIncrement + n2;
        this.setProgress(n6, true);
        this.onKeyChange();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onMeasure(int n, int n2) {
        synchronized (this) {
            int n3;
            Drawable drawable2 = this.getCurrentDrawable();
            int n4 = this.mThumb == null ? 0 : (n3 = this.mThumb.getIntrinsicHeight());
            int n5 = 0;
            int n6 = 0;
            if (drawable2 != null) {
                int n7 = this.mMinWidth;
                int n8 = this.mMaxWidth;
                int n9 = drawable2.getIntrinsicWidth();
                int n10 = Math.min(n8, n9);
                n5 = Math.max(n7, n10);
                int n11 = this.mMinHeight;
                int n12 = this.mMaxHeight;
                int n13 = drawable2.getIntrinsicHeight();
                int n14 = Math.min(n12, n13);
                int n15 = Math.max(n11, n14);
                n6 = Math.max(n4, n15);
            }
            int n16 = this.mPaddingLeft;
            int n17 = this.mPaddingRight;
            int n18 = n16 + n17;
            int n19 = n5 + n18;
            int n20 = this.mPaddingTop;
            int n21 = this.mPaddingBottom;
            int n22 = n20 + n21;
            int n23 = n6 + n22;
            int n24 = AbsSeekBar.resolveSize(n19, n);
            int n25 = AbsSeekBar.resolveSize(n23, n2);
            this.setMeasuredDimension(n24, n25);
            return;
        }
    }

    @Override
    void onProgressRefresh(float f, boolean bl) {
        Drawable drawable2 = this.mThumb;
        if (drawable2 == null) {
            return;
        }
        int n = this.getWidth();
        this.setThumbPos(n, drawable2, f, Integer.MIN_VALUE);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        float f;
        Drawable drawable2 = this.getCurrentDrawable();
        Drawable drawable3 = this.mThumb;
        int n5 = drawable3 == null ? 0 : drawable3.getIntrinsicHeight();
        int n6 = this.mMaxHeight;
        int n7 = this.mPaddingTop;
        int n8 = n2 - n7;
        int n9 = this.mPaddingBottom;
        int n10 = n8 - n9;
        int n11 = Math.min(n6, n10);
        int n12 = this.getMax();
        if (n12 > 0) {
            float f2 = this.getProgress();
            float f3 = n12;
            f = f2 / f3;
        } else {
            f = 0.0f;
        }
        if (n5 > n11) {
            if (drawable3 != null) {
                this.setThumbPos(n, drawable3, f, 0);
            }
            int n13 = (n5 - n11) / 2;
            if (drawable2 == null) {
                return;
            }
            int n14 = this.mPaddingRight;
            int n15 = n - n14;
            int n16 = this.mPaddingLeft;
            int n17 = n15 - n16;
            int n18 = this.mPaddingBottom;
            int n19 = n2 - n18 - n13;
            int n20 = this.mPaddingTop;
            int n21 = n19 - n20;
            drawable2.setBounds(0, n13, n17, n21);
            return;
        }
        if (drawable2 != null) {
            int n22 = this.mPaddingRight;
            int n23 = n - n22;
            int n24 = this.mPaddingLeft;
            int n25 = n23 - n24;
            int n26 = this.mPaddingBottom;
            int n27 = n2 - n26;
            int n28 = this.mPaddingTop;
            int n29 = n27 - n28;
            drawable2.setBounds(0, 0, n25, n29);
        }
        int n30 = (n11 - n5) / 2;
        if (drawable3 == null) {
            return;
        }
        this.setThumbPos(n, drawable3, f, n30);
    }

    void onStartTrackingTouch() {
    }

    void onStopTrackingTouch() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mIsUserSeekable) return false;
        if (!this.isEnabled()) {
            return false;
        }
        switch (motionEvent.getAction()) {
            case 0: {
                this.setPressed(true);
                this.onStartTrackingTouch();
                this.trackTouchEvent(motionEvent);
                return true;
            }
            case 2: {
                this.trackTouchEvent(motionEvent);
                this.attemptClaimDrag();
                return true;
            }
            case 1: {
                this.trackTouchEvent(motionEvent);
                this.onStopTrackingTouch();
                this.setPressed(false);
                this.invalidate();
                return true;
            }
            case 3: {
                this.onStopTrackingTouch();
                this.setPressed(false);
                this.invalidate();
                return true;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setKeyProgressIncrement(int n) {
        int n2 = n < 0 ? -n : n;
        this.mKeyProgressIncrement = n2;
    }

    @Override
    public void setMax(int n) {
        synchronized (this) {
            int n2;
            int n3;
            super.setMax(n);
            if (this.mKeyProgressIncrement == 0 || (n3 = this.getMax()) / (n2 = this.mKeyProgressIncrement) > 20) {
                int n4 = Math.round((float)this.getMax() / 20.0f);
                int n5 = Math.max(1, n4);
                this.setKeyProgressIncrement(n5);
            }
            return;
        }
    }

    public void setThumb(Drawable drawable2) {
        if (drawable2 != null) {
            int n;
            drawable2.setCallback(this);
            this.mThumbOffset = n = drawable2.getIntrinsicWidth() / 2;
        }
        this.mThumb = drawable2;
        this.invalidate();
    }

    public void setThumbOffset(int n) {
        this.mThumbOffset = n;
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        Drawable drawable3 = this.mThumb;
        if (drawable2 == drawable3) return true;
        if (!super.verifyDrawable(drawable2)) return false;
        return true;
    }
}

