/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import com.android.internal.R;

public abstract class AbsSpinner
extends AdapterView<SpinnerAdapter> {
    SpinnerAdapter mAdapter;
    boolean mBlockLayoutRequests;
    private DataSetObserver mDataSetObserver;
    int mHeightMeasureSpec;
    final RecycleBin mRecycler;
    int mSelectionBottomPadding = 0;
    int mSelectionLeftPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionTopPadding = 0;
    final Rect mSpinnerPadding;
    private Rect mTouchFrame;
    int mWidthMeasureSpec;

    public AbsSpinner(Context context) {
        super(context);
        RecycleBin recycleBin;
        Rect rect;
        this.mSpinnerPadding = rect = new Rect();
        this.mRecycler = recycleBin = new RecycleBin();
        this.initAbsSpinner();
    }

    public AbsSpinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AbsSpinner(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        RecycleBin recycleBin;
        Rect rect;
        this.mSpinnerPadding = rect = new Rect();
        this.mRecycler = recycleBin = new RecycleBin();
        this.initAbsSpinner();
        int[] nArray = R.styleable.AbsSpinner;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        CharSequence[] charSequenceArray = typedArray.getTextArray(0);
        if (charSequenceArray != null) {
            ArrayAdapter<CharSequence> arrayAdapter = new ArrayAdapter<CharSequence>(context, 17367048, charSequenceArray);
            arrayAdapter.setDropDownViewResource(0x1090009);
            this.setAdapter(arrayAdapter);
        }
        typedArray.recycle();
    }

    private void initAbsSpinner() {
        this.setFocusable(true);
        this.setWillNotDraw(false);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -1);
    }

    @Override
    public SpinnerAdapter getAdapter() {
        return this.mAdapter;
    }

    int getChildHeight(View view) {
        return view.getMeasuredHeight();
    }

    int getChildWidth(View view) {
        return view.getMeasuredWidth();
    }

    @Override
    public int getCount() {
        return this.mItemCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getSelectedView() {
        if (this.mItemCount <= 0) return null;
        if (this.mSelectedPosition < 0) return null;
        int n = this.mSelectedPosition;
        int n2 = this.mFirstPosition;
        int n3 = n - n2;
        return this.getChildAt(n3);
    }

    abstract void layout(int var1, boolean var2);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4 = View.MeasureSpec.getMode(n);
        Rect rect = this.mSpinnerPadding;
        int n5 = this.mPaddingLeft;
        int n6 = this.mSelectionLeftPadding;
        int n7 = n5 > n6 ? this.mPaddingLeft : this.mSelectionLeftPadding;
        rect.left = n7;
        Rect rect2 = this.mSpinnerPadding;
        int n8 = this.mPaddingTop;
        int n9 = this.mSelectionTopPadding;
        int n10 = n8 > n9 ? this.mPaddingTop : this.mSelectionTopPadding;
        rect2.top = n10;
        Rect rect3 = this.mSpinnerPadding;
        int n11 = this.mPaddingRight;
        int n12 = this.mSelectionRightPadding;
        int n13 = n11 > n12 ? this.mPaddingRight : this.mSelectionRightPadding;
        rect3.right = n13;
        Rect rect4 = this.mSpinnerPadding;
        int n14 = this.mPaddingBottom;
        int n15 = this.mSelectionBottomPadding;
        int n16 = n14 > n15 ? this.mPaddingBottom : this.mSelectionBottomPadding;
        rect4.bottom = n16;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        int n17 = 0;
        int n18 = 0;
        boolean bl = true;
        int n19 = this.getSelectedItemPosition();
        if (n19 >= 0 && this.mAdapter != null && n19 < (n3 = this.mAdapter.getCount())) {
            View view = this.mRecycler.get(n19);
            if (view == null) {
                view = this.mAdapter.getView(n19, null, this);
            }
            if (view != null) {
                this.mRecycler.put(n19, view);
            }
            if (view != null) {
                if (view.getLayoutParams() == null) {
                    this.mBlockLayoutRequests = true;
                    ViewGroup.LayoutParams layoutParams = this.generateDefaultLayoutParams();
                    view.setLayoutParams(layoutParams);
                    this.mBlockLayoutRequests = false;
                }
                this.measureChild(view, n, n2);
                int n20 = this.getChildHeight(view);
                int n21 = this.mSpinnerPadding.top;
                int n22 = n20 + n21;
                int n23 = this.mSpinnerPadding.bottom;
                n17 = n22 + n23;
                int n24 = this.getChildWidth(view);
                int n25 = this.mSpinnerPadding.left;
                int n26 = n24 + n25;
                int n27 = this.mSpinnerPadding.right;
                n18 = n26 + n27;
                bl = false;
            }
        }
        if (bl) {
            int n28 = this.mSpinnerPadding.top;
            int n29 = this.mSpinnerPadding.bottom;
            n17 = n28 + n29;
            if (n4 == 0) {
                int n30 = this.mSpinnerPadding.left;
                int n31 = this.mSpinnerPadding.right;
                n18 = n30 + n31;
            }
        }
        int n32 = this.getSuggestedMinimumHeight();
        int n33 = Math.max(n17, n32);
        int n34 = this.getSuggestedMinimumWidth();
        int n35 = Math.max(n18, n34);
        int n36 = AbsSpinner.resolveSize(n33, n2);
        int n37 = AbsSpinner.resolveSize(n35, n);
        this.setMeasuredDimension(n37, n36);
        this.mHeightMeasureSpec = n2;
        this.mWidthMeasureSpec = n;
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        int n;
        long l;
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        if (savedState.selectedId < 0L) {
            return;
        }
        this.mDataChanged = true;
        this.mNeedSync = true;
        this.mSyncRowId = l = savedState.selectedId;
        this.mSyncPosition = n = savedState.position;
        this.mSyncMode = 0;
        this.requestLayout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Parcelable onSaveInstanceState() {
        long l;
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        savedState.selectedId = l = this.getSelectedItemId();
        if (savedState.selectedId >= 0L) {
            int n;
            savedState.position = n = this.getSelectedItemPosition();
            return savedState;
        }
        savedState.position = -1;
        return savedState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int pointToPosition(int n, int n2) {
        Rect rect = this.mTouchFrame;
        if (rect == null) {
            Rect rect2;
            rect = this.mTouchFrame = (rect2 = new Rect());
        }
        int n3 = this.getChildCount() - 1;
        while (n3 >= 0) {
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0) {
                view.getHitRect(rect);
                if (rect.contains(n, n2)) {
                    return this.mFirstPosition + n3;
                }
            }
            n3 += -1;
        }
        return -1;
    }

    void recycleAllViews() {
        int n = this.getChildCount();
        RecycleBin recycleBin = this.mRecycler;
        int n2 = this.mFirstPosition;
        int n3 = 0;
        while (n3 < n) {
            View view = this.getChildAt(n3);
            int n4 = n2 + n3;
            recycleBin.put(n4, view);
            ++n3;
        }
        return;
    }

    @Override
    public void requestLayout() {
        if (this.mBlockLayoutRequests) {
            return;
        }
        super.requestLayout();
    }

    void resetList() {
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.removeAllViewsInLayout();
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        if (this.mAdapter != null) {
            SpinnerAdapter spinnerAdapter2 = this.mAdapter;
            DataSetObserver dataSetObserver = this.mDataSetObserver;
            spinnerAdapter2.unregisterDataSetObserver(dataSetObserver);
            this.resetList();
        }
        this.mAdapter = spinnerAdapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            int n;
            int n2;
            this.mOldItemCount = n2 = this.mItemCount;
            this.mItemCount = n = this.mAdapter.getCount();
            this.checkFocus();
            AdapterView.AdapterDataSetObserver adapterDataSetObserver = new AdapterView.AdapterDataSetObserver(this);
            this.mDataSetObserver = adapterDataSetObserver;
            SpinnerAdapter spinnerAdapter3 = this.mAdapter;
            DataSetObserver dataSetObserver = this.mDataSetObserver;
            spinnerAdapter3.registerDataSetObserver(dataSetObserver);
            int n3 = this.mItemCount > 0 ? 0 : -1;
            this.setSelectedPositionInt(n3);
            this.setNextSelectedPositionInt(n3);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.checkFocus();
            this.resetList();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    @Override
    public void setSelection(int n) {
        this.setNextSelectedPositionInt(n);
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSelection(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        boolean bl2 = bl && this.mFirstPosition <= n && n <= (n4 = (n3 = this.mFirstPosition) + (n2 = this.getChildCount()) - 1);
        this.setSelectionInt(n, bl2);
    }

    void setSelectionInt(int n, boolean bl) {
        int n2 = this.mOldSelectedPosition;
        if (n != n2) {
            return;
        }
        this.mBlockLayoutRequests = true;
        int n3 = this.mSelectedPosition;
        int n4 = n - n3;
        this.setNextSelectedPositionInt(n);
        this.layout(n4, bl);
        this.mBlockLayoutRequests = false;
    }

    class RecycleBin {
        private final SparseArray<View> mScrapHeap;

        RecycleBin() {
            SparseArray sparseArray = new SparseArray();
            this.mScrapHeap = sparseArray;
        }

        void clear() {
            SparseArray<View> sparseArray = this.mScrapHeap;
            int n = sparseArray.size();
            for (int i = 0; i < n; ++i) {
                View view = sparseArray.valueAt(i);
                if (view == null) continue;
                AbsSpinner.this.removeDetachedView(view, true);
            }
            sparseArray.clear();
        }

        View get(int n) {
            View view = this.mScrapHeap.get(n);
            if (view != null) {
                this.mScrapHeap.delete(n);
            }
            return view;
        }

        public void put(int n, View view) {
            this.mScrapHeap.put(n, view);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int position;
        long selectedId;

        private SavedState(Parcel parcel) {
            super(parcel);
            int n;
            long l;
            this.selectedId = l = parcel.readLong();
            this.position = n = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("AbsSpinner.SavedState{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" selectedId=");
            long l = this.selectedId;
            StringBuilder stringBuilder3 = stringBuilder2.append(l).append(" position=");
            int n = this.position;
            return stringBuilder3.append(n).append("}").toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            long l = this.selectedId;
            parcel.writeLong(l);
            int n2 = this.position;
            parcel.writeInt(n2);
        }
    }
}

