/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Adapter;

public abstract class AdapterView<T extends Adapter>
extends ViewGroup {
    public static final int INVALID_POSITION = 255;
    public static final long INVALID_ROW_ID = Long.MIN_VALUE;
    public static final int ITEM_VIEW_TYPE_HEADER_OR_FOOTER = 254;
    public static final int ITEM_VIEW_TYPE_IGNORE = 255;
    static final int SYNC_FIRST_POSITION = 1;
    static final int SYNC_MAX_DURATION_MILLIS = 100;
    static final int SYNC_SELECTED_POSITION;
    boolean mBlockLayoutRequests = false;
    boolean mDataChanged;
    private boolean mDesiredFocusableInTouchModeState;
    private boolean mDesiredFocusableState;
    private View mEmptyView;
    @ViewDebug.ExportedProperty(category="scrolling")
    int mFirstPosition = 0;
    boolean mInLayout = false;
    @ViewDebug.ExportedProperty(category="list")
    int mItemCount;
    private int mLayoutHeight;
    boolean mNeedSync = false;
    @ViewDebug.ExportedProperty(category="list")
    int mNextSelectedPosition = -1;
    long mNextSelectedRowId;
    int mOldItemCount;
    int mOldSelectedPosition = -1;
    long mOldSelectedRowId;
    OnItemClickListener mOnItemClickListener;
    OnItemLongClickListener mOnItemLongClickListener;
    OnItemSelectedListener mOnItemSelectedListener;
    @ViewDebug.ExportedProperty(category="list")
    int mSelectedPosition = -1;
    long mSelectedRowId;
    private SelectionNotifier mSelectionNotifier;
    int mSpecificTop;
    long mSyncHeight;
    int mSyncMode;
    int mSyncPosition;
    long mSyncRowId = Long.MIN_VALUE;

    public AdapterView(Context context) {
        super(context);
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedRowId = Long.MIN_VALUE;
    }

    public AdapterView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedRowId = Long.MIN_VALUE;
    }

    public AdapterView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedRowId = Long.MIN_VALUE;
    }

    private void fireOnSelected() {
        if (this.mOnItemSelectedListener == null) {
            return;
        }
        int n = this.getSelectedItemPosition();
        if (n >= 0) {
            View view = this.getSelectedView();
            OnItemSelectedListener onItemSelectedListener = this.mOnItemSelectedListener;
            long l = this.getAdapter().getItemId(n);
            AdapterView adapterView = this;
            onItemSelectedListener.onItemSelected(adapterView, view, n, l);
            return;
        }
        this.mOnItemSelectedListener.onNothingSelected(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateEmptyStatus(boolean bl) {
        if (this.isInFilterMode()) {
            bl = false;
        }
        if (bl) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
            if (!this.mDataChanged) {
                return;
            }
            int n = this.mLeft;
            int n2 = this.mTop;
            int n3 = this.mRight;
            int n4 = this.mBottom;
            this.onLayout(false, n, n2, n3, n4);
            return;
        }
        if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(8);
        }
        this.setVisibility(0);
    }

    @Override
    public void addView(View view) {
        throw new UnsupportedOperationException("addView(View) is not supported in AdapterView");
    }

    @Override
    public void addView(View view, int n) {
        throw new UnsupportedOperationException("addView(View, int) is not supported in AdapterView");
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        throw new UnsupportedOperationException("addView(View, int, LayoutParams) is not supported in AdapterView");
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        throw new UnsupportedOperationException("addView(View, LayoutParams) is not supported in AdapterView");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canAnimate() {
        if (!super.canAnimate()) return false;
        if (this.mItemCount <= 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkFocus() {
        T t = this.getAdapter();
        boolean bl = t == null || t.getCount() == 0;
        boolean bl2 = !bl || this.isInFilterMode();
        boolean bl3 = bl2 && this.mDesiredFocusableInTouchModeState;
        super.setFocusableInTouchMode(bl3);
        boolean bl4 = bl2 && this.mDesiredFocusableState;
        super.setFocusable(bl4);
        if (this.mEmptyView == null) {
            return;
        }
        boolean bl5 = t == null || t.isEmpty();
        this.updateEmptyStatus(bl5);
    }

    void checkSelectionChanged() {
        long l;
        int n;
        long l2;
        long l3;
        int n2 = this.mSelectedPosition;
        int n3 = this.mOldSelectedPosition;
        if (n2 != n3 && (l3 = this.mSelectedRowId) == (l2 = this.mOldSelectedRowId)) {
            return;
        }
        this.selectionChanged();
        this.mOldSelectedPosition = n = this.mSelectedPosition;
        this.mOldSelectedRowId = l = this.mSelectedRowId;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        View view;
        boolean bl = false;
        if (accessibilityEvent.getEventType() == 8) {
            accessibilityEvent.setEventType(4);
        }
        if ((view = this.getSelectedView()) != null) {
            bl = view.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        if (!bl) {
            if (view != null) {
                boolean bl2 = view.isEnabled();
                accessibilityEvent.setEnabled(bl2);
            }
            int n = this.getCount();
            accessibilityEvent.setItemCount(n);
            int n2 = this.getSelectedItemPosition();
            accessibilityEvent.setCurrentItemIndex(n2);
        }
        return bl;
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchFreezeSelfOnly(sparseArray);
    }

    /*
     * Unable to fully structure code
     */
    int findSyncPosition() {
        block6: {
            var1_1 = this.mItemCount;
            if (var1_1 == 0) {
                var2_2 = 65535;
lbl4:
                // 5 sources

                return var2_2;
            }
            var3_3 = this.mSyncRowId;
            var5_4 = this.mSyncPosition;
            if (var3_3 != -9223372036854775808L) break block6;
            var2_2 = 65535;
            ** GOTO lbl4
        }
        var6_5 = 0;
        var7_6 = var5_4;
        var8_7 = Math.max(var6_5, var7_6);
        var9_8 = var1_1 - 1;
        var10_9 = var8_7;
        var5_4 = Math.min(var9_8, var10_9);
        var11_10 = SystemClock.uptimeMillis() + 100L;
        var13_11 = var5_4;
        var14_12 = var5_4;
        var13_11 = 0;
        var16_13 = this.getAdapter();
        if (var16_13 != null) ** GOTO lbl29
        var2_2 = 65535;
        ** GOTO lbl4
        block1: while (var15_15 || var13_11 != 0 && !var16_14) {
            var5_4 = ++var14_12;
            var13_11 = 0;
lbl29:
            // 4 sources

            while (true) {
                block9: {
                    block8: {
                        block7: {
                            if (SystemClock.uptimeMillis() > var11_10) ** GOTO lbl-1000
                            if (var16_13.getItemId(var5_4) != var3_3) break block7;
                            var2_2 = var5_4;
                            ** GOTO lbl4
                        }
                        var20_17 = var14_12;
                        var19_16 = var1_1 - 1;
                        var21_18 = var19_16;
                        if (var20_17 == var21_18) break block8;
                        var16_14 = true;
lbl40:
                        // 2 sources

                        while (var13_11 == 0) {
                            var15_15 = true;
lbl42:
                            // 2 sources

                            while (var16_14 && var15_15) lbl-1000:
                            // 2 sources

                            {
                                var2_2 = 65535;
                                ** continue;
lbl45:
                                // 1 sources

                                ** GOTO lbl4
                            }
                            continue block1;
                        }
                        break block9;
                    }
                    var16_14 = false;
                    ** GOTO lbl40
                }
                var15_15 = false;
                ** GOTO lbl42
                break;
            }
        }
        if (!var16_14 && (var13_11 != 0 || var15_15)) ** GOTO lbl29
        var5_4 = var13_11 += -1;
        var13_11 = 1;
        ** while (true)
    }

    public abstract T getAdapter();

    @ViewDebug.CapturedViewProperty
    public int getCount() {
        return this.mItemCount;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public int getFirstVisiblePosition() {
        return this.mFirstPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getItemAtPosition(int n) {
        T t = this.getAdapter();
        if (t == null) return null;
        if (n >= 0) return t.getItem(n);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getItemIdAtPosition(int n) {
        T t = this.getAdapter();
        if (t == null) return Long.MIN_VALUE;
        if (n >= 0) return t.getItemId(n);
        return Long.MIN_VALUE;
    }

    public int getLastVisiblePosition() {
        int n = this.mFirstPosition;
        int n2 = this.getChildCount();
        return n + n2 - 1;
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public final OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public final OnItemSelectedListener getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPositionForView(View view) {
        View view2 = view;
        while (true) {
            try {
                View view3 = (View)((Object)view2.getParent());
                boolean bl = view3.equals(this);
                if (bl) break;
                view2 = view3;
            }
            catch (ClassCastException classCastException) {
                return -1;
            }
        }
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getChildAt(n2).equals(view2)) {
                return this.mFirstPosition + n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getSelectedItem() {
        T t = this.getAdapter();
        int n = this.getSelectedItemPosition();
        if (t == null) return null;
        if (t.getCount() <= 0) return null;
        if (n < 0) return null;
        return t.getItem(n);
    }

    @ViewDebug.CapturedViewProperty
    public long getSelectedItemId() {
        return this.mNextSelectedRowId;
    }

    @ViewDebug.CapturedViewProperty
    public int getSelectedItemPosition() {
        return this.mNextSelectedPosition;
    }

    public abstract View getSelectedView();

    void handleDataChanged() {
        int n = this.mItemCount;
        boolean bl = false;
        if (n > 0) {
            int n2;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                n2 = this.findSyncPosition();
                if (n2 >= 0 && this.lookForSelectablePosition(n2, true) != n2) {
                    this.setNextSelectedPositionInt(n2);
                    bl = true;
                }
            }
            if (!bl) {
                int n3;
                n2 = this.getSelectedItemPosition();
                if (n2 >= n) {
                    int n4 = n - 1;
                }
                if (n2 < 0) {
                    // empty if block
                }
                if ((n3 = this.lookForSelectablePosition(n2, true)) < 0) {
                    int n5 = this.lookForSelectablePosition(n2, false);
                }
                if (n3 >= 0) {
                    this.setNextSelectedPositionInt(n3);
                    this.checkSelectionChanged();
                    bl = true;
                }
            }
        }
        if (bl) {
            return;
        }
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.checkSelectionChanged();
    }

    boolean isInFilterMode() {
        return false;
    }

    int lookForSelectablePosition(int n, boolean bl) {
        return n;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        SelectionNotifier selectionNotifier = this.mSelectionNotifier;
        boolean bl = this.removeCallbacks(selectionNotifier);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        this.mLayoutHeight = n5 = this.getHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performItemClick(View view, int n, long l) {
        if (this.mOnItemClickListener == null) return false;
        this.playSoundEffect(0);
        OnItemClickListener onItemClickListener = this.mOnItemClickListener;
        AdapterView adapterView = this;
        View view2 = view;
        int n2 = n;
        long l2 = l;
        onItemClickListener.onItemClick(adapterView, view2, n2, l2);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void rememberSyncState() {
        int n;
        int n2;
        int n3;
        long l;
        if (this.getChildCount() <= 0) {
            return;
        }
        this.mNeedSync = true;
        this.mSyncHeight = l = (long)this.mLayoutHeight;
        if (this.mSelectedPosition >= 0) {
            int n4;
            long l2;
            int n5 = this.mSelectedPosition;
            int n6 = this.mFirstPosition;
            int n7 = n5 - n6;
            View view = this.getChildAt(n7);
            this.mSyncRowId = l2 = this.mNextSelectedRowId;
            this.mSyncPosition = n4 = this.mNextSelectedPosition;
            if (view != null) {
                int n8;
                this.mSpecificTop = n8 = view.getTop();
            }
            this.mSyncMode = 0;
            return;
        }
        View view = this.getChildAt(0);
        T t = this.getAdapter();
        if (this.mFirstPosition >= 0 && (n3 = this.mFirstPosition) < (n2 = t.getCount())) {
            long l3;
            int n9 = this.mFirstPosition;
            this.mSyncRowId = l3 = t.getItemId(n9);
        } else {
            this.mSyncRowId = 65535L;
        }
        this.mSyncPosition = n = this.mFirstPosition;
        if (view != null) {
            int n10;
            this.mSpecificTop = n10 = view.getTop();
        }
        this.mSyncMode = 1;
    }

    @Override
    public void removeAllViews() {
        throw new UnsupportedOperationException("removeAllViews() is not supported in AdapterView");
    }

    @Override
    public void removeView(View view) {
        throw new UnsupportedOperationException("removeView(View) is not supported in AdapterView");
    }

    @Override
    public void removeViewAt(int n) {
        throw new UnsupportedOperationException("removeViewAt(int) is not supported in AdapterView");
    }

    /*
     * Enabled aggressive block sorting
     */
    void selectionChanged() {
        if (this.mOnItemSelectedListener != null) {
            if (this.mInLayout || this.mBlockLayoutRequests) {
                if (this.mSelectionNotifier == null) {
                    SelectionNotifier selectionNotifier;
                    this.mSelectionNotifier = selectionNotifier = new SelectionNotifier();
                }
                SelectionNotifier selectionNotifier = this.mSelectionNotifier;
                boolean bl = this.post(selectionNotifier);
            } else {
                this.fireOnSelected();
            }
        }
        if (this.mSelectedPosition == -1) {
            return;
        }
        if (!this.isShown()) {
            return;
        }
        if (this.isInTouchMode()) {
            return;
        }
        this.sendAccessibilityEvent(4);
    }

    public abstract void setAdapter(T var1);

    /*
     * Enabled aggressive block sorting
     */
    public void setEmptyView(View view) {
        this.mEmptyView = view;
        T t = this.getAdapter();
        boolean bl = t == null || t.isEmpty();
        this.updateEmptyStatus(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setFocusable(boolean bl) {
        T t = this.getAdapter();
        boolean bl2 = t == null || t.getCount() == 0;
        this.mDesiredFocusableState = bl;
        if (!bl) {
            this.mDesiredFocusableInTouchModeState = false;
        }
        boolean bl3 = bl && (!bl2 || this.isInFilterMode());
        super.setFocusable(bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setFocusableInTouchMode(boolean bl) {
        T t = this.getAdapter();
        boolean bl2 = t == null || t.getCount() == 0;
        this.mDesiredFocusableInTouchModeState = bl;
        if (bl) {
            this.mDesiredFocusableState = true;
        }
        boolean bl3 = bl && (!bl2 || this.isInFilterMode());
        super.setFocusableInTouchMode(bl3);
    }

    void setNextSelectedPositionInt(int n) {
        long l;
        long l2;
        this.mNextSelectedPosition = n;
        this.mNextSelectedRowId = l2 = this.getItemIdAtPosition(n);
        if (!this.mNeedSync) {
            return;
        }
        if (this.mSyncMode != 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        this.mSyncPosition = n;
        this.mSyncRowId = l = this.mNextSelectedRowId;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        throw new RuntimeException("Don't call setOnClickListener for an AdapterView. You probably want setOnItemClickListener instead");
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    void setSelectedPositionInt(int n) {
        long l;
        this.mSelectedPosition = n;
        this.mSelectedRowId = l = this.getItemIdAtPosition(n);
    }

    public abstract void setSelection(int var1);

    private class SelectionNotifier
    implements Runnable {
        private SelectionNotifier() {
        }

        @Override
        public void run() {
            if (AdapterView.this.mDataChanged) {
                if (AdapterView.this.getAdapter() == null) {
                    return;
                }
                boolean bl = AdapterView.this.post(this);
                return;
            }
            AdapterView.this.fireOnSelected();
        }
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        private Parcelable mInstanceState = null;

        AdapterDataSetObserver() {
        }

        public void clearSavedState() {
            this.mInstanceState = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onChanged() {
            int n;
            int n2;
            AdapterView.this.mDataChanged = true;
            AdapterView adapterView = AdapterView.this;
            adapterView.mOldItemCount = n2 = AdapterView.this.mItemCount;
            AdapterView adapterView2 = AdapterView.this;
            adapterView2.mItemCount = n = AdapterView.this.getAdapter().getCount();
            if (AdapterView.this.getAdapter().hasStableIds() && this.mInstanceState != null && AdapterView.this.mOldItemCount == 0 && AdapterView.this.mItemCount > 0) {
                AdapterView adapterView3 = AdapterView.this;
                Parcelable parcelable = this.mInstanceState;
                adapterView3.onRestoreInstanceState(parcelable);
                this.mInstanceState = null;
            } else {
                AdapterView.this.rememberSyncState();
            }
            AdapterView.this.checkFocus();
            AdapterView.this.requestLayout();
        }

        @Override
        public void onInvalidated() {
            int n;
            AdapterView.this.mDataChanged = true;
            if (AdapterView.this.getAdapter().hasStableIds()) {
                Parcelable parcelable;
                this.mInstanceState = parcelable = AdapterView.this.onSaveInstanceState();
            }
            AdapterView adapterView = AdapterView.this;
            adapterView.mOldItemCount = n = AdapterView.this.mItemCount;
            AdapterView.this.mItemCount = 0;
            AdapterView.this.mSelectedPosition = -1;
            AdapterView.this.mSelectedRowId = Long.MIN_VALUE;
            AdapterView.this.mNextSelectedPosition = -1;
            AdapterView.this.mNextSelectedRowId = Long.MIN_VALUE;
            AdapterView.this.mNeedSync = false;
            AdapterView.this.checkFocus();
            AdapterView.this.requestLayout();
        }
    }

    public static class AdapterContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public long id;
        public int position;
        public View targetView;

        public AdapterContextMenuInfo(View view, int n, long l) {
            this.targetView = view;
            this.position = n;
            this.id = l;
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4);

        public void onNothingSelected(AdapterView<?> var1);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }
}

