/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.SparseIntArray;
import android.widget.SectionIndexer;
import java.text.Collator;

public class AlphabetIndexer
extends DataSetObserver
implements SectionIndexer {
    private SparseIntArray mAlphaMap;
    protected CharSequence mAlphabet;
    private String[] mAlphabetArray;
    private int mAlphabetLength;
    private Collator mCollator;
    protected int mColumnIndex;
    protected Cursor mDataCursor;

    public AlphabetIndexer(Cursor cursor, int n, CharSequence charSequence) {
        Collator collator;
        SparseIntArray sparseIntArray;
        int n2;
        int n3;
        this.mDataCursor = cursor;
        this.mColumnIndex = n;
        this.mAlphabet = charSequence;
        this.mAlphabetLength = n3 = charSequence.length();
        String[] stringArray = new String[this.mAlphabetLength];
        this.mAlphabetArray = stringArray;
        for (int i = 0; i < (n2 = this.mAlphabetLength); ++i) {
            String string2;
            String[] stringArray2 = this.mAlphabetArray;
            stringArray2[i] = string2 = Character.toString(this.mAlphabet.charAt(i));
        }
        int n4 = this.mAlphabetLength;
        this.mAlphaMap = sparseIntArray = new SparseIntArray(n4);
        if (cursor != null) {
            cursor.registerDataSetObserver(this);
        }
        this.mCollator = collator = Collator.getInstance();
        this.mCollator.setStrength(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int compare(String string2, String string3) {
        String string4;
        if (string2.length() == 0) {
            string4 = " ";
            return this.mCollator.compare(string4, string3);
        }
        string4 = string2.substring(0, 1);
        return this.mCollator.compare(string4, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getPositionForSection(int n) {
        int n2;
        int n3;
        int n4;
        CharSequence charSequence;
        char c;
        char c2;
        SparseIntArray sparseIntArray;
        int n5;
        int n6;
        SparseIntArray sparseIntArray2 = this.mAlphaMap;
        Cursor cursor = this.mDataCursor;
        if (cursor == null) return 0;
        if (this.mAlphabet == null) {
            return 0;
        }
        if (n <= 0) {
            return 0;
        }
        int n7 = n;
        int n8 = this.mAlphabetLength;
        int n9 = n8;
        if (n7 >= n9) {
            n = this.mAlphabetLength - 1;
        }
        int n10 = cursor.getPosition();
        int n11 = cursor.getCount();
        int n12 = 0;
        int n13 = n11;
        CharSequence charSequence2 = this.mAlphabet;
        int n14 = n;
        char c3 = charSequence2.charAt(n14);
        String string2 = Character.toString(c3);
        int n15 = Integer.MIN_VALUE;
        SparseIntArray sparseIntArray3 = sparseIntArray2;
        char c4 = c3;
        char c5 = c4;
        int n16 = Integer.MIN_VALUE;
        int n17 = sparseIntArray3.get(c5, n16);
        int n18 = n17;
        if (n15 != n18) {
            if (n17 >= 0) {
                return n17;
            }
            n13 = -n17;
        }
        if (n > 0 && (n6 = (n5 = (sparseIntArray = sparseIntArray2).get(c2 = (c = (charSequence = this.mAlphabet).charAt(n4 = n - 1)), n3 = Integer.MIN_VALUE))) != (n2 = Integer.MIN_VALUE)) {
            n12 = Math.abs(n5);
        }
        n17 = (n13 + n12) / 2;
        while (n17 < n13) {
            boolean bl = cursor.moveToPosition(n17);
            Cursor cursor2 = cursor;
            int n19 = this.mColumnIndex;
            int n20 = n19;
            String string3 = cursor2.getString(n20);
            if (string3 == null) {
                if (n17 == 0) break;
                n17 += -1;
                continue;
            }
            AlphabetIndexer alphabetIndexer = this;
            String string4 = string3;
            String string5 = string2;
            int n21 = alphabetIndexer.compare(string4, string5);
            if (n21 != 0) {
                if (n21 < 0) {
                    n12 = n17 + 1;
                    if (n12 >= n11) {
                        n17 = n11;
                        break;
                    }
                } else {
                    n13 = n17;
                }
            } else {
                if (n12 == n17) break;
                n13 = n17;
            }
            n17 = (n12 + n13) / 2;
        }
        sparseIntArray2.put(c4, n17);
        boolean bl = cursor.moveToPosition(n10);
        return n17;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSectionForPosition(int n) {
        int n2;
        int n3 = this.mDataCursor.getPosition();
        boolean bl = this.mDataCursor.moveToPosition(n);
        Cursor cursor = this.mDataCursor;
        int n4 = this.mColumnIndex;
        String string2 = cursor.getString(n4);
        boolean bl2 = this.mDataCursor.moveToPosition(n3);
        int n5 = 0;
        while (n5 < (n2 = this.mAlphabetLength)) {
            String string3 = Character.toString(this.mAlphabet.charAt(n5));
            if (this.compare(string2, string3) == 0) {
                return n5;
            }
            ++n5;
        }
        return 0;
    }

    @Override
    public Object[] getSections() {
        return this.mAlphabetArray;
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.mAlphaMap.clear();
    }

    @Override
    public void onInvalidated() {
        super.onInvalidated();
        this.mAlphaMap.clear();
    }

    public void setCursor(Cursor cursor) {
        if (this.mDataCursor != null) {
            this.mDataCursor.unregisterDataSetObserver(this);
        }
        this.mDataCursor = cursor;
        if (cursor != null) {
            this.mDataCursor.registerDataSetObserver(this);
        }
        this.mAlphaMap.clear();
    }
}

