/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.TimeZone;

@RemoteViews.RemoteView
public class AnalogClock
extends View {
    private boolean mAttached;
    private Time mCalendar;
    private boolean mChanged;
    private Drawable mDial;
    private int mDialHeight;
    private int mDialWidth;
    private final Handler mHandler;
    private float mHour;
    private Drawable mHourHand;
    private final BroadcastReceiver mIntentReceiver;
    private Drawable mMinuteHand;
    private float mMinutes;

    public AnalogClock(Context context) {
        this(context, null);
    }

    public AnalogClock(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AnalogClock(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        int n3;
        Time time;
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        BroadcastReceiver broadcastReceiver;
        Handler handler;
        this.mHandler = handler = new Handler();
        this.mIntentReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                    String string2 = intent.getStringExtra("time-zone");
                    AnalogClock analogClock = AnalogClock.this;
                    String string3 = TimeZone.getTimeZone(string2).getID();
                    Time time = new Time(string3);
                    Time time2 = AnalogClock.access$002(analogClock, time);
                }
                AnalogClock.this.onTimeChanged();
                AnalogClock.this.invalidate();
            }
        };
        Resources resources = this.mContext.getResources();
        int[] nArray = R.styleable.AnalogClock;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mDial = drawable4 = typedArray.getDrawable(0);
        if (this.mDial == null) {
            Drawable drawable5;
            this.mDial = drawable5 = resources.getDrawable(17301831);
        }
        this.mHourHand = drawable3 = typedArray.getDrawable(1);
        if (this.mHourHand == null) {
            Drawable drawable6;
            this.mHourHand = drawable6 = resources.getDrawable(17301832);
        }
        this.mMinuteHand = drawable2 = typedArray.getDrawable(2);
        if (this.mMinuteHand == null) {
            Drawable drawable7;
            this.mMinuteHand = drawable7 = resources.getDrawable(17301833);
        }
        this.mCalendar = time = new Time();
        this.mDialWidth = n3 = this.mDial.getIntrinsicWidth();
        this.mDialHeight = n2 = this.mDial.getIntrinsicHeight();
    }

    static /* synthetic */ Time access$002(AnalogClock analogClock, Time time) {
        analogClock.mCalendar = time;
        return time;
    }

    private void onTimeChanged() {
        float f;
        float f2;
        this.mCalendar.setToNow();
        int n = this.mCalendar.hour;
        int n2 = this.mCalendar.minute;
        int n3 = this.mCalendar.second;
        float f3 = n2;
        float f4 = (float)n3 / 60.0f;
        this.mMinutes = f2 = f3 + f4;
        float f5 = n;
        float f6 = this.mMinutes / 60.0f;
        this.mHour = f = f5 + f6;
        this.mChanged = true;
    }

    @Override
    protected void onAttachedToWindow() {
        Time time;
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_TICK");
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            Context context = this.getContext();
            BroadcastReceiver broadcastReceiver = this.mIntentReceiver;
            Handler handler = this.mHandler;
            Intent intent = context.registerReceiver(broadcastReceiver, intentFilter, null, handler);
        }
        this.mCalendar = time = new Time();
        this.onTimeChanged();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mAttached) {
            return;
        }
        Context context = this.getContext();
        BroadcastReceiver broadcastReceiver = this.mIntentReceiver;
        context.unregisterReceiver(broadcastReceiver);
        this.mAttached = false;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean bl = this.mChanged;
        if (bl) {
            boolean bl2;
            this.mChanged = bl2 = false;
        }
        int n = this.mRight;
        int n2 = this.mLeft;
        int n3 = n - n2;
        int n4 = this.mBottom;
        int n5 = this.mTop;
        int n6 = n4 - n5;
        int n7 = n3 / 2;
        int n8 = n6 / 2;
        Drawable drawable2 = this.mDial;
        int n9 = drawable2.getIntrinsicWidth();
        int n10 = drawable2.getIntrinsicHeight();
        boolean bl3 = false;
        if (n3 < n9 || n6 < n10) {
            bl3 = true;
            float f = n3;
            float f2 = n9;
            float f3 = f / f2;
            float f4 = n6;
            float f5 = n10;
            float f6 = f4 / f5;
            float f7 = Math.min(f3, f6);
            int n11 = canvas.save();
            float f8 = n7;
            float f9 = n8;
            Canvas canvas2 = canvas;
            float f10 = f7;
            float f11 = f7;
            float f12 = f8;
            float f13 = f9;
            canvas2.scale(f10, f11, f12, f13);
        }
        if (bl) {
            int n12 = n9 / 2;
            int n13 = n7 - n12;
            int n14 = n10 / 2;
            int n15 = n8 - n14;
            int n16 = n9 / 2 + n7;
            int n17 = n10 / 2 + n8;
            Drawable drawable3 = drawable2;
            int n18 = n13;
            int n19 = n15;
            int n20 = n16;
            int n21 = n17;
            drawable3.setBounds(n18, n19, n20, n21);
        }
        Drawable drawable4 = drawable2;
        Canvas canvas3 = canvas;
        drawable4.draw(canvas3);
        int n22 = canvas.save();
        float f = this.mHour / 12.0f * 360.0f;
        float f14 = n7;
        float f15 = n8;
        Canvas canvas4 = canvas;
        float f16 = f;
        float f17 = f14;
        float f18 = f15;
        canvas4.rotate(f16, f17, f18);
        Drawable drawable5 = this.mHourHand;
        if (bl) {
            int n23 = drawable5.getIntrinsicWidth();
            int n24 = drawable5.getIntrinsicHeight();
            int n25 = n23 / 2;
            int n26 = n7 - n25;
            int n27 = n24 / 2;
            int n28 = n8 - n27;
            int n29 = n23 / 2 + n7;
            int n30 = n24 / 2 + n8;
            Drawable drawable6 = drawable5;
            int n31 = n26;
            int n32 = n28;
            int n33 = n29;
            int n34 = n30;
            drawable6.setBounds(n31, n32, n33, n34);
        }
        Drawable drawable7 = drawable5;
        Canvas canvas5 = canvas;
        drawable7.draw(canvas5);
        canvas.restore();
        int n35 = canvas.save();
        float f19 = this.mMinutes / 60.0f * 360.0f;
        float f20 = n7;
        float f21 = n8;
        Canvas canvas6 = canvas;
        float f22 = f19;
        float f23 = f20;
        float f24 = f21;
        canvas6.rotate(f22, f23, f24);
        Drawable drawable8 = this.mMinuteHand;
        if (bl) {
            int n36 = drawable8.getIntrinsicWidth();
            int n37 = drawable8.getIntrinsicHeight();
            int n38 = n36 / 2;
            int n39 = n7 - n38;
            int n40 = n37 / 2;
            int n41 = n8 - n40;
            int n42 = n36 / 2 + n7;
            int n43 = n37 / 2 + n8;
            Drawable drawable9 = drawable8;
            int n44 = n39;
            int n45 = n41;
            int n46 = n42;
            int n47 = n43;
            drawable9.setBounds(n44, n45, n46, n47);
        }
        Drawable drawable10 = drawable8;
        Canvas canvas7 = canvas;
        drawable10.draw(canvas7);
        canvas.restore();
        if (!bl3) {
            return;
        }
        canvas.restore();
    }

    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5 = View.MeasureSpec.getMode(n);
        int n6 = View.MeasureSpec.getSize(n);
        int n7 = View.MeasureSpec.getMode(n2);
        int n8 = View.MeasureSpec.getSize(n2);
        float f = 1.0f;
        float f2 = 1.0f;
        if (n5 != 0 && n6 < (n4 = this.mDialWidth)) {
            float f3 = n6;
            float f4 = this.mDialWidth;
            f = f3 / f4;
        }
        if (n7 != 0 && n8 < (n3 = this.mDialHeight)) {
            float f5 = n8;
            float f6 = this.mDialHeight;
            f2 = f5 / f6;
        }
        float f7 = Math.min(f, f2);
        int n9 = AnalogClock.resolveSize((int)((float)this.mDialWidth * f7), n);
        int n10 = AnalogClock.resolveSize((int)((float)this.mDialHeight * f7), n2);
        this.setMeasuredDimension(n9, n10);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mChanged = true;
    }
}

