/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppSecurityPermissions
implements View.OnClickListener {
    private static final String TAG = "AppSecurityPermissions";
    private boolean localLOGV = false;
    private Context mContext;
    private State mCurrentState;
    private Drawable mDangerousIcon;
    private LinearLayout mDangerousList;
    private Map<String, String> mDangerousMap;
    private String mDefaultGrpLabel;
    private String mDefaultGrpName = "DefaultGrp";
    private boolean mExpanded;
    private HashMap<String, CharSequence> mGroupLabelCache;
    private LayoutInflater mInflater;
    private View mNoPermsView;
    private LinearLayout mNonDangerousList;
    private Drawable mNormalIcon;
    private Map<String, String> mNormalMap;
    private String mPermFormat;
    private List<PermissionInfo> mPermsList;
    private LinearLayout mPermsView;
    private PackageManager mPm;
    private Drawable mShowMaxIcon;
    private Drawable mShowMinIcon;
    private View mShowMore;
    private ImageView mShowMoreIcon;
    private TextView mShowMoreText;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AppSecurityPermissions(Context context, PackageParser.Package package_) {
        ArrayList<String> arrayList;
        int n;
        PackageManager packageManager;
        this.mContext = context;
        this.mPm = packageManager = this.mContext.getPackageManager();
        ArrayList<PermissionInfo> arrayList2 = new ArrayList<PermissionInfo>();
        this.mPermsList = arrayList2;
        HashSet<PermissionInfo> hashSet = new HashSet<PermissionInfo>();
        if (package_ == null) {
            return;
        }
        if (package_.requestedPermissions != null && (n = (arrayList = package_.requestedPermissions).size()) > 0) {
            String[] stringArray = new String[n];
            String[] stringArray2 = arrayList.toArray(stringArray);
            this.extractPerms(stringArray2, hashSet);
        }
        if (package_.mSharedUserId != null) {
            try {
                PackageManager packageManager2 = this.mPm;
                String string2 = package_.mSharedUserId;
                int n2 = packageManager2.getUidForSharedUser(string2);
                this.getAllUsedPermissions(n2, hashSet);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Could'nt retrieve shared user id for:");
                String string3 = package_.packageName;
                String string4 = stringBuilder.append(string3).toString();
                int n3 = Log.w(TAG, string4);
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            PermissionInfo permissionInfo = (PermissionInfo)iterator.next();
            boolean bl = this.mPermsList.add(permissionInfo);
        }
        return;
    }

    public AppSecurityPermissions(Context context, String string2) {
        Iterator iterator;
        PackageManager packageManager;
        this.mContext = context;
        this.mPm = packageManager = this.mContext.getPackageManager();
        ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
        this.mPermsList = arrayList;
        HashSet<PermissionInfo> hashSet = new HashSet<PermissionInfo>();
        try {
            PackageInfo packageInfo;
            PackageInfo packageInfo2 = packageInfo = this.mPm.getPackageInfo(string2, 4096);
            if (packageInfo2.applicationInfo != null && packageInfo2.applicationInfo.uid != -1) {
                int n = packageInfo2.applicationInfo.uid;
                this.getAllUsedPermissions(n, hashSet);
            }
            iterator = hashSet.iterator();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = "Could'nt retrieve permissions for package:" + string2;
            int n = Log.w(TAG, string3);
            return;
        }
        while (true) {
            if (!iterator.hasNext()) {
                return;
            }
            PermissionInfo permissionInfo = (PermissionInfo)iterator.next();
            boolean bl = this.mPermsList.add(permissionInfo);
        }
    }

    public AppSecurityPermissions(Context context, List<PermissionInfo> list) {
        PackageManager packageManager;
        this.mContext = context;
        this.mPm = packageManager = this.mContext.getPackageManager();
        this.mPermsList = list;
    }

    private void aggregateGroupDescs(Map<String, List<PermissionInfo>> map, Map<String, String> map2) {
        if (map == null) {
            return;
        }
        if (map2 == null) {
            return;
        }
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = null;
            String string3 = iterator.next();
            List<PermissionInfo> list = map.get(string3);
            if (list == null) continue;
            for (PermissionInfo permissionInfo : list) {
                PackageManager packageManager = this.mPm;
                CharSequence charSequence = permissionInfo.loadLabel(packageManager);
                string2 = this.formatPermissions(string2, charSequence);
            }
            if (string2 == null) continue;
            if (this.localLOGV) {
                StringBuilder stringBuilder = new StringBuilder().append("Group:").append(string3).append(" description:");
                String string4 = string2.toString();
                String string5 = stringBuilder.append(string4).toString();
                int n = Log.i(TAG, string5);
            }
            String string6 = string2.toString();
            String string7 = map2.put(string3, string6);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String canonicalizeGroupDesc(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) {
            return null;
        }
        int n = string2.length();
        int n2 = n - 1;
        if (string2.charAt(n2) != '.') return string2;
        int n3 = n - 1;
        string2 = string2.substring(0, n3);
        return string2;
    }

    private void displayNoPermissions() {
        this.mNoPermsView.setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void displayPermissions(boolean bl) {
        Map<String, String> map = bl ? this.mDangerousMap : this.mNormalMap;
        LinearLayout linearLayout = bl ? this.mDangerousList : this.mNonDangerousList;
        linearLayout.removeAllViews();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            CharSequence charSequence = this.getGroupLabel(string2);
            if (this.localLOGV) {
                StringBuilder stringBuilder = new StringBuilder().append("Adding view group:").append((Object)charSequence).append(", desc:");
                String string3 = map.get(string2);
                String string4 = stringBuilder.append(string3).toString();
                int n = Log.i(TAG, string4);
            }
            CharSequence charSequence2 = map.get(string2);
            View view = this.getPermissionItemView(charSequence, charSequence2, bl);
            linearLayout.addView(view);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractPerms(String[] stringArray, Set<PermissionInfo> set) {
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            try {
                PermissionInfo permissionInfo = this.mPm.getPermissionInfo(string2, 0);
                if (permissionInfo != null) {
                    boolean bl = set.add(permissionInfo);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string3 = "Ignoring unknown permission:" + string2;
                int n3 = Log.i(TAG, string3);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String formatPermissions(String string2, CharSequence charSequence) {
        if (string2 == null) {
            if (charSequence != null) return ((Object)charSequence).toString();
            return null;
        }
        string2 = this.canonicalizeGroupDesc(string2);
        if (charSequence == null) {
            return string2;
        }
        String string3 = this.mPermFormat;
        Object[] objectArray = new Object[2];
        objectArray[0] = string2;
        String string4 = ((Object)charSequence).toString();
        objectArray[1] = string4;
        return String.format(string3, objectArray);
    }

    private void getAllUsedPermissions(int n, Set<PermissionInfo> set) {
        String[] stringArray = this.mPm.getPackagesForUid(n);
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            this.getPermissionsForPackage(string2, set);
            ++n3;
        }
        return;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CharSequence getGroupLabel(String string2) {
        void var2_3;
        if (string2 == null) {
            String string3 = this.mDefaultGrpLabel;
            return var2_3;
        }
        CharSequence charSequence = this.mGroupLabelCache.get(string2);
        if (charSequence != null) {
            CharSequence charSequence2 = charSequence;
            return var2_3;
        }
        try {
            PermissionGroupInfo permissionGroupInfo;
            PermissionGroupInfo permissionGroupInfo2 = permissionGroupInfo = this.mPm.getPermissionGroupInfo(string2, 0);
            PackageManager packageManager = this.mPm;
            String string4 = ((Object)permissionGroupInfo2.loadLabel(packageManager)).toString();
            CharSequence charSequence3 = this.mGroupLabelCache.put(string2, string4);
            String string5 = string4;
            return var2_3;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string6 = "Invalid group name:" + string2;
            int n = Log.i(TAG, string6);
            return var2_3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static View getPermissionItemView(Context context, LayoutInflater layoutInflater, CharSequence charSequence, CharSequence charSequence2, boolean bl, Drawable drawable2) {
        View view = layoutInflater.inflate(0x1090019, null);
        TextView textView = (TextView)view.findViewById(16908682);
        TextView textView2 = (TextView)view.findViewById(16908683);
        ((ImageView)view.findViewById(16908681)).setImageDrawable(drawable2);
        if (charSequence != null) {
            textView.setText(charSequence);
            textView2.setText(charSequence2);
            return view;
        }
        textView.setText(charSequence2);
        textView2.setVisibility(8);
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static View getPermissionItemView(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        Resources resources = context.getResources();
        int n = bl ? 17301904 : 17301962;
        Drawable drawable2 = resources.getDrawable(n);
        Context context2 = context;
        CharSequence charSequence3 = charSequence;
        CharSequence charSequence4 = charSequence2;
        boolean bl2 = bl;
        return AppSecurityPermissions.getPermissionItemView(context2, layoutInflater, charSequence3, charSequence4, bl2, drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View getPermissionItemView(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        Context context = this.mContext;
        LayoutInflater layoutInflater = this.mInflater;
        Drawable drawable2 = bl ? this.mDangerousIcon : this.mNormalIcon;
        CharSequence charSequence3 = charSequence;
        CharSequence charSequence4 = charSequence2;
        boolean bl2 = bl;
        return AppSecurityPermissions.getPermissionItemView(context, layoutInflater, charSequence3, charSequence4, bl2, drawable2);
    }

    private void getPermissionsForPackage(String string2, Set<PermissionInfo> set) {
        try {
            PackageInfo packageInfo;
            PackageInfo packageInfo2 = packageInfo = this.mPm.getPackageInfo(string2, 4096);
            if (packageInfo2 == null) {
                return;
            }
            if (packageInfo2.requestedPermissions == null) {
                return;
            }
            String[] stringArray = packageInfo2.requestedPermissions;
            this.extractPerms(stringArray, set);
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = "Could'nt retrieve permissions for package:" + string2;
            int n = Log.w(TAG, string3);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDisplayablePermission(PermissionInfo permissionInfo) {
        if (permissionInfo.protectionLevel == 1) return true;
        if (permissionInfo.protectionLevel != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setPermissions(List<PermissionInfo> list) {
        State state;
        HashMap hashMap = new HashMap();
        HashMap<String, CharSequence> hashMap2 = this.mGroupLabelCache = hashMap;
        String string2 = this.mDefaultGrpName;
        String string3 = this.mDefaultGrpLabel;
        CharSequence charSequence = hashMap2.put(string2, string3);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        this.mDangerousMap = hashMap3;
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        this.mNormalMap = hashMap4;
        HashMap<String, List<PermissionInfo>> hashMap5 = new HashMap<String, List<PermissionInfo>>();
        HashMap<String, List<PermissionInfo>> hashMap6 = new HashMap<String, List<PermissionInfo>>();
        PackageManager packageManager = this.mPm;
        PermissionInfoComparator permissionInfoComparator = new PermissionInfoComparator(packageManager);
        if (list != null) {
            for (PermissionInfo permissionInfo : list) {
                List list2;
                if (this.localLOGV) {
                    StringBuilder stringBuilder = new StringBuilder().append("Processing permission:");
                    String string4 = permissionInfo.name;
                    String string5 = stringBuilder.append(string4).toString();
                    int n = Log.i(TAG, string5);
                }
                if (!this.isDisplayablePermission(permissionInfo)) {
                    if (!this.localLOGV) continue;
                    StringBuilder stringBuilder = new StringBuilder().append("Permission:");
                    String string6 = permissionInfo.name;
                    String string7 = stringBuilder.append(string6).append(" is not displayable").toString();
                    int n = Log.i(TAG, string7);
                    continue;
                }
                HashMap<String, List<PermissionInfo>> hashMap7 = permissionInfo.protectionLevel == 1 ? hashMap5 : hashMap6;
                String string8 = permissionInfo.group == null ? this.mDefaultGrpName : permissionInfo.group;
                if (this.localLOGV) {
                    StringBuilder stringBuilder = new StringBuilder().append("Permission:");
                    String string9 = permissionInfo.name;
                    String string10 = stringBuilder.append(string9).append(" belongs to group:").append(string8).toString();
                    int n = Log.i(TAG, string10);
                }
                if ((list2 = (List)hashMap7.get(string8)) == null) {
                    ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
                    ArrayList arrayList2 = hashMap7.put(string8, arrayList);
                    boolean bl = arrayList.add(permissionInfo);
                    continue;
                }
                int n = Collections.binarySearch(list2, permissionInfo, permissionInfoComparator);
                if (this.localLOGV) {
                    StringBuilder stringBuilder = new StringBuilder().append("idx=").append(n).append(", list.size=");
                    int n2 = list2.size();
                    String string11 = stringBuilder.append(n2).toString();
                    int n3 = Log.i(TAG, string11);
                }
                if (n >= 0) continue;
                int n4 = -n - 1;
                list2.add(n4, permissionInfo);
            }
            Map<String, String> map = this.mDangerousMap;
            this.aggregateGroupDescs(hashMap5, map);
            Map<String, String> map2 = this.mNormalMap;
            this.aggregateGroupDescs(hashMap6, map2);
        }
        this.mCurrentState = state = State.NO_PERMS;
        if (this.mDangerousMap.size() > 0) {
            State state2 = this.mNormalMap.size() > 0 ? State.BOTH : State.DANGEROUS_ONLY;
            this.mCurrentState = state2;
        } else if (this.mNormalMap.size() > 0) {
            State state3;
            this.mCurrentState = state3 = State.NORMAL_ONLY;
        }
        if (this.localLOGV) {
            StringBuilder stringBuilder = new StringBuilder().append("mCurrentState=");
            State state4 = this.mCurrentState;
            String string12 = stringBuilder.append((Object)state4).toString();
            int n = Log.i(TAG, string12);
        }
        this.showPermissions();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showPermissions() {
        int[] nArray = 1.$SwitchMap$android$widget$AppSecurityPermissions$State;
        int n = this.mCurrentState.ordinal();
        switch (nArray[n]) {
            default: {
                return;
            }
            case 1: {
                this.displayNoPermissions();
                return;
            }
            case 2: {
                this.displayPermissions(true);
                return;
            }
            case 3: {
                this.displayPermissions(false);
                return;
            }
            case 4: 
        }
        this.displayPermissions(true);
        if (this.mExpanded) {
            this.displayPermissions(false);
            ImageView imageView = this.mShowMoreIcon;
            Drawable drawable2 = this.mShowMaxIcon;
            imageView.setImageDrawable(drawable2);
            this.mShowMoreText.setText(17040160);
            this.mNonDangerousList.setVisibility(0);
        } else {
            ImageView imageView = this.mShowMoreIcon;
            Drawable drawable3 = this.mShowMinIcon;
            imageView.setImageDrawable(drawable3);
            this.mShowMoreText.setText(17040161);
            this.mNonDangerousList.setVisibility(8);
        }
        this.mShowMore.setVisibility(0);
    }

    public int getPermissionCount() {
        return this.mPermsList.size();
    }

    public View getPermissionsView() {
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        Drawable drawable5;
        String string2;
        String string3;
        View view;
        LinearLayout linearLayout;
        LinearLayout linearLayout2;
        TextView textView;
        ImageView imageView;
        View view2;
        LinearLayout linearLayout3;
        LayoutInflater layoutInflater;
        this.mInflater = layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mPermsView = linearLayout3 = (LinearLayout)this.mInflater.inflate(17367066, null);
        this.mShowMore = view2 = this.mPermsView.findViewById(16908686);
        this.mShowMoreIcon = imageView = (ImageView)this.mShowMore.findViewById(16908688);
        this.mShowMoreText = textView = (TextView)this.mShowMore.findViewById(16908687);
        this.mDangerousList = linearLayout2 = (LinearLayout)this.mPermsView.findViewById(16908685);
        this.mNonDangerousList = linearLayout = (LinearLayout)this.mPermsView.findViewById(16908689);
        this.mNoPermsView = view = this.mPermsView.findViewById(16908684);
        this.mShowMore.setClickable(true);
        this.mShowMore.setOnClickListener(this);
        this.mShowMore.setFocusable(true);
        this.mShowMore.setBackgroundResource(17301602);
        this.mDefaultGrpLabel = string3 = this.mContext.getString(17040157);
        this.mPermFormat = string2 = this.mContext.getString(17040158);
        this.mNormalIcon = drawable5 = this.mContext.getResources().getDrawable(17301962);
        this.mDangerousIcon = drawable4 = this.mContext.getResources().getDrawable(17301904);
        this.mShowMaxIcon = drawable3 = this.mContext.getResources().getDrawable(17301873);
        this.mShowMinIcon = drawable2 = this.mContext.getResources().getDrawable(17301874);
        List<PermissionInfo> list = this.mPermsList;
        this.setPermissions(list);
        return this.mPermsView;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        if (this.localLOGV) {
            StringBuilder stringBuilder = new StringBuilder().append("mExpanded=");
            boolean bl = this.mExpanded;
            String string2 = stringBuilder.append(bl).toString();
            int n = Log.i(TAG, string2);
        }
        boolean bl = !this.mExpanded;
        this.mExpanded = bl;
        this.showPermissions();
    }

    private static class PermissionInfoComparator
    implements Comparator<PermissionInfo> {
        private PackageManager mPm;
        private final Collator sCollator;

        PermissionInfoComparator(PackageManager packageManager) {
            Collator collator;
            this.sCollator = collator = Collator.getInstance();
            this.mPm = packageManager;
        }

        @Override
        public final int compare(PermissionInfo permissionInfo, PermissionInfo permissionInfo2) {
            PackageManager packageManager = this.mPm;
            CharSequence charSequence = permissionInfo.loadLabel(packageManager);
            PackageManager packageManager2 = this.mPm;
            CharSequence charSequence2 = permissionInfo2.loadLabel(packageManager2);
            return this.sCollator.compare(charSequence, charSequence2);
        }
    }

    private static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State BOTH;
        public static final /* enum */ State DANGEROUS_ONLY;
        public static final /* enum */ State NORMAL_ONLY;
        public static final /* enum */ State NO_PERMS;

        static {
            NO_PERMS = new State();
            DANGEROUS_ONLY = new State();
            NORMAL_ONLY = new State();
            BOTH = new State();
            State state = NO_PERMS;
            State state2 = DANGEROUS_ONLY;
            State state3 = NORMAL_ONLY;
            State state4 = BOTH;
            State[] stateArray = new State[]{state, state2, state3, state4};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

