/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;

public class AutoCompleteTextView
extends EditText
implements Filter.FilterListener {
    static final boolean DEBUG = false;
    private static final int EXPAND_LIST_TIMEOUT = 250;
    private static final int HINT_VIEW_ID = 23;
    static final String TAG = "AutoCompleteTextView";
    private ListAdapter mAdapter;
    private boolean mBlockCompletion;
    private boolean mDropDownAlwaysVisible;
    private int mDropDownAnchorId;
    private View mDropDownAnchorView;
    private boolean mDropDownDismissedOnCompletion;
    private int mDropDownHeight;
    private int mDropDownHorizontalOffset;
    private final DropDownItemClickListener mDropDownItemClickListener;
    private DropDownListView mDropDownList;
    private Drawable mDropDownListHighlight;
    private int mDropDownVerticalOffset;
    private int mDropDownWidth;
    private Filter mFilter;
    private boolean mForceIgnoreOutsideTouch;
    private ListSelectorHider mHideSelector;
    private int mHintResource;
    private CharSequence mHintText;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private int mLastKeyCode;
    private PopupDataSetObserver mObserver;
    private boolean mOpenBefore;
    private PassThroughClickListener mPassThroughClickListener;
    private PopupWindow mPopup;
    private Runnable mResizePopupRunnable;
    private Runnable mShowDropDownRunnable;
    private final Rect mTempRect;
    private int mThreshold;
    private Validator mValidator;

    public AutoCompleteTextView(Context context) {
        this(context, null);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842859);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        PassThroughClickListener passThroughClickListener;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Drawable drawable2;
        CharSequence charSequence;
        int n8;
        PopupWindow popupWindow;
        DropDownItemClickListener dropDownItemClickListener;
        Rect rect;
        this.mTempRect = rect = new Rect();
        this.mDropDownItemClickListener = dropDownItemClickListener = new DropDownItemClickListener();
        this.mDropDownAlwaysVisible = false;
        this.mDropDownDismissedOnCompletion = true;
        this.mForceIgnoreOutsideTouch = false;
        this.mLastKeyCode = 0;
        this.mValidator = null;
        ResizePopupRunnable resizePopupRunnable = new ResizePopupRunnable();
        this.mResizePopupRunnable = resizePopupRunnable;
        this.mPopup = popupWindow = new PopupWindow(context, attributeSet, 16842859);
        this.mPopup.setSoftInputMode(16);
        int[] nArray = R.styleable.AutoCompleteTextView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mThreshold = n8 = typedArray.getInt(2, 2);
        this.mHintText = charSequence = typedArray.getText(0);
        this.mDropDownListHighlight = drawable2 = typedArray.getDrawable(3);
        this.mDropDownVerticalOffset = n7 = (int)typedArray.getDimension(9, 0.0f);
        this.mDropDownHorizontalOffset = n6 = (int)typedArray.getDimension(8, 0.0f);
        this.mDropDownAnchorId = n5 = typedArray.getResourceId(6, -1);
        this.mDropDownWidth = n4 = typedArray.getLayoutDimension(5, -1);
        this.mDropDownHeight = n3 = typedArray.getLayoutDimension(7, -1);
        this.mHintResource = n2 = typedArray.getResourceId(1, 17367135);
        int n9 = this.getInputType();
        if ((n9 & 0xF) == 1) {
            int n10 = n9 | 0x10000;
            this.setRawInputType(n10);
        }
        typedArray.recycle();
        this.setFocusable(true);
        MyWatcher myWatcher = new MyWatcher();
        this.addTextChangedListener(myWatcher);
        PassThroughClickListener passThroughClickListener2 = this.mPassThroughClickListener = (passThroughClickListener = new PassThroughClickListener());
        super.setOnClickListener(passThroughClickListener2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private int buildDropDown() {
        InputMethodManager inputMethodManager;
        int n = 0;
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter != null && (inputMethodManager = InputMethodManager.peekInstance()) != null) {
            int n2;
            int n3;
            int n4 = Math.min(listAdapter.getCount(), 20);
            CompletionInfo[] completionInfoArray = new CompletionInfo[n4];
            int n5 = 0;
            int n6 = 0;
            while ((n3 = ++n6) < (n2 = n4)) {
                CompletionInfo completionInfo;
                ListAdapter listAdapter2 = listAdapter;
                int n7 = n6;
                if (!listAdapter2.isEnabled(n7)) continue;
                ++n5;
                ListAdapter listAdapter3 = listAdapter;
                int n8 = n6;
                Object object = listAdapter3.getItem(n8);
                ListAdapter listAdapter4 = listAdapter;
                int n9 = n6;
                long l = listAdapter4.getItemId(n9);
                AutoCompleteTextView autoCompleteTextView = this;
                Object object2 = object;
                CharSequence charSequence = autoCompleteTextView.convertSelectionToString(object2);
                CompletionInfo completionInfo2 = completionInfo;
                long l2 = l;
                int n10 = n6;
                CharSequence charSequence2 = charSequence;
                completionInfo2(l2, n10, charSequence2);
                completionInfoArray[n6] = completionInfo;
            }
            int n11 = n5;
            int n12 = n4;
            if (n11 != n12) {
                CompletionInfo[] completionInfoArray2 = new CompletionInfo[n5];
                CompletionInfo[] completionInfoArray3 = completionInfoArray;
                int n13 = 0;
                CompletionInfo[] completionInfoArray4 = completionInfoArray2;
                int n14 = 0;
                int n15 = n5;
                System.arraycopy(completionInfoArray3, n13, completionInfoArray4, n14, n15);
                completionInfoArray = completionInfoArray2;
            }
            InputMethodManager inputMethodManager2 = inputMethodManager;
            AutoCompleteTextView autoCompleteTextView = this;
            CompletionInfo[] completionInfoArray5 = completionInfoArray;
            inputMethodManager2.displayCompletions(autoCompleteTextView, completionInfoArray5);
        }
        if (this.mDropDownList == null) {
            void var65_65;
            PopupScrollListener popupScrollListener;
            2 var55_53;
            DropDownListView dropDownListView;
            1 var45_43;
            ListSelectorHider listSelectorHider;
            ListSelectorHider listSelectorHider2;
            Context context = this.getContext();
            ListSelectorHider listSelectorHider3 = listSelectorHider2;
            AutoCompleteTextView autoCompleteTextView = this;
            1 var43_41 = null;
            listSelectorHider3();
            this.mHideSelector = listSelectorHider = listSelectorHider2;
            1 var46_44 = var45_43;
            AutoCompleteTextView autoCompleteTextView2 = this;
            var46_44();
            1 var48_46 = var45_43;
            this.mShowDropDownRunnable = var48_46;
            DropDownListView dropDownListView2 = this.mDropDownList = (dropDownListView = new DropDownListView(context));
            Drawable drawable2 = this.mDropDownListHighlight;
            dropDownListView2.setSelector(drawable2);
            this.mDropDownList.setAdapter(listAdapter);
            this.mDropDownList.setVerticalFadingEdgeEnabled(true);
            DropDownListView dropDownListView3 = this.mDropDownList;
            DropDownItemClickListener dropDownItemClickListener = this.mDropDownItemClickListener;
            dropDownListView3.setOnItemClickListener(dropDownItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            DropDownListView dropDownListView4 = this.mDropDownList;
            2 var56_54 = var55_53;
            AutoCompleteTextView autoCompleteTextView3 = this;
            var56_54();
            dropDownListView4.setOnItemSelectedListener(var55_53);
            DropDownListView dropDownListView5 = this.mDropDownList;
            PopupScrollListener popupScrollListener2 = popupScrollListener;
            AutoCompleteTextView autoCompleteTextView4 = this;
            1 var62_60 = null;
            popupScrollListener2();
            dropDownListView5.setOnScrollListener(popupScrollListener);
            if (this.mItemSelectedListener != null) {
                DropDownListView dropDownListView6 = this.mDropDownList;
                AdapterView.OnItemSelectedListener onItemSelectedListener = this.mItemSelectedListener;
                dropDownListView6.setOnItemSelectedListener(onItemSelectedListener);
            }
            DropDownListView dropDownListView7 = this.mDropDownList;
            AutoCompleteTextView autoCompleteTextView5 = this;
            Context context2 = context;
            View view = autoCompleteTextView5.getHintView(context2);
            if (view != null) {
                LinearLayout.LayoutParams layoutParams;
                LinearLayout linearLayout;
                LinearLayout linearLayout2 = linearLayout;
                Context context3 = context;
                linearLayout2(context3);
                LinearLayout linearLayout3 = linearLayout;
                int n16 = 1;
                linearLayout3.setOrientation(n16);
                LinearLayout.LayoutParams layoutParams2 = layoutParams;
                int n17 = -1;
                int n18 = 0;
                float f = 1.0f;
                layoutParams2(n17, n18, f);
                LinearLayout linearLayout4 = linearLayout;
                DropDownListView dropDownListView8 = dropDownListView7;
                LinearLayout.LayoutParams layoutParams3 = layoutParams;
                linearLayout4.addView((View)dropDownListView8, layoutParams3);
                LinearLayout linearLayout5 = linearLayout;
                View view2 = view;
                linearLayout5.addView(view2);
                int n19 = View.MeasureSpec.makeMeasureSpec(this.getWidth(), Integer.MIN_VALUE);
                View view3 = view;
                int n20 = n19;
                int n21 = 0;
                view3.measure(n20, n21);
                LinearLayout.LayoutParams layoutParams4 = (LinearLayout.LayoutParams)view.getLayoutParams();
                int n22 = view.getMeasuredHeight();
                int n23 = layoutParams4.topMargin;
                int n24 = n22 + n23;
                int n25 = layoutParams4.bottomMargin;
                n = n24 + n25;
                LinearLayout linearLayout6 = linearLayout;
            }
            PopupWindow popupWindow = this.mPopup;
            void var94_94 = var65_65;
            popupWindow.setContentView((View)var94_94);
        } else {
            int n26;
            ViewGroup viewGroup = (ViewGroup)this.mPopup.getContentView();
            View view = viewGroup.findViewById(n26 = 23);
            if (view != null) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                int n27 = view.getMeasuredHeight();
                int n28 = layoutParams.topMargin;
                int n29 = n27 + n28;
                int n30 = layoutParams.bottomMargin;
                n = n29 + n30;
            }
        }
        boolean bl = this.mPopup.getInputMethodMode() == 2;
        PopupWindow popupWindow = this.mPopup;
        View view = this.getDropDownAnchorView();
        int n31 = this.mDropDownVerticalOffset;
        PopupWindow popupWindow2 = popupWindow;
        View view4 = view;
        int n32 = n31;
        boolean bl2 = bl;
        int n33 = popupWindow2.getMaxAvailableHeight(view4, n32, bl2);
        int n34 = 0;
        Drawable drawable3 = this.mPopup.getBackground();
        if (drawable3 != null) {
            Rect rect = this.mTempRect;
            boolean bl3 = drawable3.getPadding(rect);
            int n35 = this.mTempRect.top;
            int n36 = this.mTempRect.bottom;
            n34 = n35 + n36;
        }
        if (this.mDropDownAlwaysVisible) return n33 + n34;
        if (this.mDropDownHeight == -1) {
            return n33 + n34;
        }
        DropDownListView dropDownListView = this.mDropDownList;
        int n37 = n33 - n;
        int n38 = dropDownListView.measureHeightOfChildren(0, 0, -1, n37, 2);
        if (n38 <= 0) return n38 + n;
        n += n34;
        return n38 + n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View getDropDownAnchorView() {
        void var4_5;
        if (this.mDropDownAnchorView == null && this.mDropDownAnchorId != -1) {
            View view;
            View view2 = this.getRootView();
            int n = this.mDropDownAnchorId;
            this.mDropDownAnchorView = view = view2.findViewById(n);
        }
        if (this.mDropDownAnchorView == null) {
            AutoCompleteTextView autoCompleteTextView = this;
            return var4_5;
        }
        View view = this.mDropDownAnchorView;
        return var4_5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View getHintView(Context context) {
        if (this.mHintText == null) return null;
        if (this.mHintText.length() <= 0) return null;
        LayoutInflater layoutInflater = LayoutInflater.from(context);
        int n = this.mHintResource;
        TextView textView = (TextView)layoutInflater.inflate(n, null).findViewById(16908308);
        CharSequence charSequence = this.mHintText;
        textView.setText(charSequence);
        textView.setId(23);
        return textView;
    }

    private void onClickImpl() {
        if (!this.mPopup.isShowing()) {
            return;
        }
        this.ensureImeVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performCompletion(View view, int n, long l) {
        if (this.isPopupShowing()) {
            Object object = n < 0 ? this.mDropDownList.getSelectedItem() : this.mAdapter.getItem(n);
            if (object == null) {
                int n2 = Log.w(TAG, "performCompletion: no selected item");
                return;
            }
            this.mBlockCompletion = true;
            CharSequence charSequence = this.convertSelectionToString(object);
            this.replaceText(charSequence);
            this.mBlockCompletion = false;
            if (this.mItemClickListener != null) {
                DropDownListView dropDownListView = this.mDropDownList;
                if (view == null || n < 0) {
                    view = dropDownListView.getSelectedView();
                    n = dropDownListView.getSelectedItemPosition();
                    l = dropDownListView.getSelectedItemId();
                }
                AdapterView.OnItemClickListener onItemClickListener = this.mItemClickListener;
                View view2 = view;
                int n3 = n;
                long l2 = l;
                onItemClickListener.onItemClick(dropDownListView, view2, n3, l2);
            }
        }
        if (!this.mDropDownDismissedOnCompletion) {
            return;
        }
        if (this.mDropDownAlwaysVisible) {
            return;
        }
        this.dismissDropDown();
    }

    private void updateDropDownForFilter(int n) {
        if (this.getWindowVisibility() == 8) {
            return;
        }
        if ((n > 0 || this.mDropDownAlwaysVisible) && this.enoughToFilter()) {
            if (!this.hasFocus()) {
                return;
            }
            if (!this.hasWindowFocus()) {
                return;
            }
            this.showDropDown();
            return;
        }
        if (this.mDropDownAlwaysVisible) {
            return;
        }
        this.dismissDropDown();
    }

    public void clearListSelection() {
        DropDownListView dropDownListView = this.mDropDownList;
        if (dropDownListView == null) {
            return;
        }
        boolean bl = DropDownListView.access$602(dropDownListView, true);
        dropDownListView.hideSelector();
        dropDownListView.requestLayout();
    }

    protected CharSequence convertSelectionToString(Object object) {
        return this.mFilter.convertResultToString(object);
    }

    public void dismissDropDown() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            inputMethodManager.displayCompletions(this, null);
        }
        this.mPopup.dismiss();
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
    }

    void doAfterTextChanged() {
        if (this.mBlockCompletion) {
            return;
        }
        if (this.mOpenBefore && !this.isPopupShowing()) {
            return;
        }
        if (this.enoughToFilter()) {
            if (this.mFilter == null) {
                return;
            }
            Editable editable = this.getText();
            int n = this.mLastKeyCode;
            this.performFiltering(editable, n);
            return;
        }
        if (!this.mDropDownAlwaysVisible) {
            this.dismissDropDown();
        }
        if (this.mFilter == null) {
            return;
        }
        this.mFilter.filter(null);
    }

    void doBeforeTextChanged() {
        boolean bl;
        if (this.mBlockCompletion) {
            return;
        }
        this.mOpenBefore = bl = this.isPopupShowing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enoughToFilter() {
        int n;
        int n2 = this.getText().length();
        if (n2 < (n = this.mThreshold)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void ensureImeVisible(boolean bl) {
        PopupWindow popupWindow = this.mPopup;
        int n = bl ? 1 : 2;
        popupWindow.setInputMethodMode(n);
        this.showDropDown();
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getDropDownAnchor() {
        return this.mDropDownAnchorId;
    }

    public int getDropDownAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    public Drawable getDropDownBackground() {
        return this.mPopup.getBackground();
    }

    public int getDropDownHeight() {
        return this.mDropDownHeight;
    }

    public int getDropDownHorizontalOffset() {
        return this.mDropDownHorizontalOffset;
    }

    public int getDropDownVerticalOffset() {
        return this.mDropDownVerticalOffset;
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    protected Filter getFilter() {
        return this.mFilter;
    }

    @Deprecated
    public AdapterView.OnItemClickListener getItemClickListener() {
        return this.mItemClickListener;
    }

    @Deprecated
    public AdapterView.OnItemSelectedListener getItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getListSelection() {
        if (!this.mPopup.isShowing()) return -1;
        if (this.mDropDownList == null) return -1;
        return this.mDropDownList.getSelectedItemPosition();
    }

    public AdapterView.OnItemClickListener getOnItemClickListener() {
        return this.mItemClickListener;
    }

    public AdapterView.OnItemSelectedListener getOnItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    public int getThreshold() {
        return this.mThreshold;
    }

    public Validator getValidator() {
        return this.mValidator;
    }

    public boolean isDropDownAlwaysVisible() {
        return this.mDropDownAlwaysVisible;
    }

    public boolean isDropDownDismissedOnCompletion() {
        return this.mDropDownDismissedOnCompletion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInputMethodNotNeeded() {
        if (this.mPopup.getInputMethodMode() != 2) return false;
        return true;
    }

    public boolean isPerformingCompletion() {
        return this.mBlockCompletion;
    }

    public boolean isPopupShowing() {
        return this.mPopup.isShowing();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    public void onCommitCompletion(CompletionInfo completionInfo) {
        if (!this.isPopupShowing()) {
            return;
        }
        this.mBlockCompletion = true;
        CharSequence charSequence = completionInfo.getText();
        this.replaceText(charSequence);
        this.mBlockCompletion = false;
        if (this.mItemClickListener == null) {
            return;
        }
        DropDownListView dropDownListView = this.mDropDownList;
        AdapterView.OnItemClickListener onItemClickListener = this.mItemClickListener;
        int n = completionInfo.getPosition();
        long l = completionInfo.getId();
        onItemClickListener.onItemClick(dropDownListView, null, n, l);
    }

    @Override
    protected void onDetachedFromWindow() {
        this.dismissDropDown();
        super.onDetachedFromWindow();
    }

    @Override
    protected void onDisplayHint(int n) {
        super.onDisplayHint(n);
        switch (n) {
            default: {
                return;
            }
            case 4: 
        }
        if (this.mDropDownAlwaysVisible) {
            return;
        }
        this.dismissDropDown();
    }

    @Override
    public void onFilterComplete(int n) {
        this.updateDropDownForFilter(n);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (!bl) {
            this.performValidation();
        }
        if (bl) {
            return;
        }
        if (this.mDropDownAlwaysVisible) {
            return;
        }
        this.dismissDropDown();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        block12: {
            block11: {
                int n2;
                int n3;
                boolean bl;
                int n4;
                block13: {
                    if (!this.isPopupShowing()) break block11;
                    if (n == 62 || this.mDropDownList.getSelectedItemPosition() < 0 && (n == 66 || n == 23)) break block12;
                    n4 = this.mDropDownList.getSelectedItemPosition();
                    bl = !this.mPopup.isAboveAnchor();
                    ListAdapter listAdapter = this.mAdapter;
                    n3 = Integer.MAX_VALUE;
                    n2 = Integer.MIN_VALUE;
                    if (listAdapter != null) {
                        boolean bl2 = listAdapter.areAllItemsEnabled();
                        n3 = bl2 ? 0 : this.mDropDownList.lookForSelectablePosition(0, true);
                        if (bl2) {
                            n2 = listAdapter.getCount() - 1;
                        } else {
                            DropDownListView dropDownListView = this.mDropDownList;
                            int n5 = listAdapter.getCount() - 1;
                            n2 = dropDownListView.lookForSelectablePosition(n5, false);
                        }
                    }
                    if (bl && n == 19 && n4 <= n3 || !bl && n == 20 && n4 >= n2) {
                        this.clearListSelection();
                        this.mPopup.setInputMethodMode(1);
                        this.showDropDown();
                        return true;
                    }
                    boolean bl3 = DropDownListView.access$602(this.mDropDownList, false);
                    if (!this.mDropDownList.onKeyDown(n, keyEvent)) break block13;
                    this.mPopup.setInputMethodMode(2);
                    boolean bl4 = this.mDropDownList.requestFocusFromTouch();
                    this.showDropDown();
                    switch (n) {
                        default: {
                            break block12;
                        }
                        case 19: 
                        case 20: 
                        case 23: 
                        case 66: {
                            return true;
                        }
                    }
                }
                if (bl && n == 20 ? n4 != n2 : !bl && n == 19 && n4 != n3) {
                    return true;
                }
                break block12;
            }
            switch (n) {
                default: {
                    break;
                }
                case 20: {
                    this.performValidation();
                }
            }
        }
        this.mLastKeyCode = n;
        boolean bl = super.onKeyDown(n, keyEvent);
        this.mLastKeyCode = 0;
        if (!bl) return bl;
        if (!this.isPopupShowing()) return bl;
        if (this.mDropDownList == null) return bl;
        this.clearListSelection();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        if (n != 4) return super.onKeyPreIme(n, keyEvent);
        if (!this.isPopupShowing()) return super.onKeyPreIme(n, keyEvent);
        if (this.mDropDownAlwaysVisible) return super.onKeyPreIme(n, keyEvent);
        if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
            this.getKeyDispatcherState().startTracking(keyEvent, this);
            return true;
        }
        if (keyEvent.getAction() != 1) return super.onKeyPreIme(n, keyEvent);
        this.getKeyDispatcherState().handleUpEvent(keyEvent);
        if (!keyEvent.isTracking()) return super.onKeyPreIme(n, keyEvent);
        if (keyEvent.isCanceled()) return super.onKeyPreIme(n, keyEvent);
        this.dismissDropDown();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (!this.isPopupShowing()) return super.onKeyUp(n, keyEvent);
        if (this.mDropDownList.getSelectedItemPosition() < 0) return super.onKeyUp(n, keyEvent);
        if (!this.mDropDownList.onKeyUp(n, keyEvent)) return super.onKeyUp(n, keyEvent);
        switch (n) {
            default: {
                return super.onKeyUp(n, keyEvent);
            }
            case 23: 
            case 66: 
        }
        this.performCompletion();
        return true;
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            return;
        }
        if (this.mDropDownAlwaysVisible) {
            return;
        }
        this.dismissDropDown();
    }

    public void performCompletion() {
        this.performCompletion(null, -1, 65535L);
    }

    protected void performFiltering(CharSequence charSequence, int n) {
        this.mFilter.filter(charSequence, this);
    }

    public void performValidation() {
        if (this.mValidator == null) {
            return;
        }
        Editable editable = this.getText();
        if (TextUtils.isEmpty(editable)) {
            return;
        }
        if (this.mValidator.isValid(editable)) {
            return;
        }
        CharSequence charSequence = this.mValidator.fixText(editable);
        this.setText(charSequence);
    }

    protected void replaceText(CharSequence charSequence) {
        this.clearComposingText();
        this.setText(charSequence);
        Editable editable = this.getText();
        int n = editable.length();
        Selection.setSelection(editable, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T extends ListAdapter & Filterable> void setAdapter(T t) {
        if (this.mObserver == null) {
            PopupDataSetObserver popupDataSetObserver;
            this.mObserver = popupDataSetObserver = new PopupDataSetObserver();
        } else if (this.mAdapter != null) {
            ListAdapter listAdapter = this.mAdapter;
            PopupDataSetObserver popupDataSetObserver = this.mObserver;
            listAdapter.unregisterDataSetObserver(popupDataSetObserver);
        }
        this.mAdapter = t;
        if (this.mAdapter != null) {
            Filter filter;
            this.mFilter = filter = ((Filterable)((Object)this.mAdapter)).getFilter();
            PopupDataSetObserver popupDataSetObserver = this.mObserver;
            t.registerDataSetObserver(popupDataSetObserver);
        } else {
            this.mFilter = null;
        }
        if (this.mDropDownList == null) {
            return;
        }
        DropDownListView dropDownListView = this.mDropDownList;
        ListAdapter listAdapter = this.mAdapter;
        dropDownListView.setAdapter(listAdapter);
    }

    public void setCompletionHint(CharSequence charSequence) {
        this.mHintText = charSequence;
    }

    public void setDropDownAlwaysVisible(boolean bl) {
        this.mDropDownAlwaysVisible = bl;
    }

    public void setDropDownAnchor(int n) {
        this.mDropDownAnchorId = n;
        this.mDropDownAnchorView = null;
    }

    public void setDropDownAnimationStyle(int n) {
        this.mPopup.setAnimationStyle(n);
    }

    public void setDropDownBackgroundDrawable(Drawable drawable2) {
        this.mPopup.setBackgroundDrawable(drawable2);
    }

    public void setDropDownBackgroundResource(int n) {
        PopupWindow popupWindow = this.mPopup;
        Drawable drawable2 = this.getResources().getDrawable(n);
        popupWindow.setBackgroundDrawable(drawable2);
    }

    public void setDropDownDismissedOnCompletion(boolean bl) {
        this.mDropDownDismissedOnCompletion = bl;
    }

    public void setDropDownHeight(int n) {
        this.mDropDownHeight = n;
    }

    public void setDropDownHorizontalOffset(int n) {
        this.mDropDownHorizontalOffset = n;
    }

    public void setDropDownVerticalOffset(int n) {
        this.mDropDownVerticalOffset = n;
    }

    public void setDropDownWidth(int n) {
        this.mDropDownWidth = n;
    }

    public void setForceIgnoreOutsideTouch(boolean bl) {
        this.mForceIgnoreOutsideTouch = bl;
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        if (this.mPopup.isShowing()) {
            this.showDropDown();
        }
        return bl;
    }

    public void setListSelection(int n) {
        if (!this.mPopup.isShowing()) {
            return;
        }
        if (this.mDropDownList == null) {
            return;
        }
        boolean bl = DropDownListView.access$602(this.mDropDownList, false);
        this.mDropDownList.setSelection(n);
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        View.OnClickListener onClickListener2 = PassThroughClickListener.access$402(this.mPassThroughClickListener, onClickListener);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.mItemSelectedListener = onItemSelectedListener;
    }

    public void setText(CharSequence charSequence, boolean bl) {
        if (bl) {
            this.setText(charSequence);
            return;
        }
        this.mBlockCompletion = true;
        this.setText(charSequence);
        this.mBlockCompletion = false;
    }

    public void setThreshold(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.mThreshold = n;
    }

    public void setValidator(Validator validator) {
        this.mValidator = validator;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showDropDown() {
        int n = this.buildDropDown();
        int n2 = 0;
        int n3 = 0;
        boolean bl = this.isInputMethodNotNeeded();
        if (this.mPopup.isShowing()) {
            n2 = this.mDropDownWidth == -1 ? -1 : (this.mDropDownWidth == -1 ? this.getDropDownAnchorView().getWidth() : this.mDropDownWidth);
            if (this.mDropDownHeight == -1) {
                n3 = bl ? n : -1;
                if (bl) {
                    PopupWindow popupWindow = this.mPopup;
                    int n4 = this.mDropDownWidth == -1 ? -1 : 0;
                    popupWindow.setWindowLayoutMode(n4, 0);
                } else {
                    PopupWindow popupWindow = this.mPopup;
                    int n5 = this.mDropDownWidth == -1 ? -1 : 0;
                    popupWindow.setWindowLayoutMode(n5, -1);
                }
            } else {
                n3 = this.mDropDownHeight == -1 ? n : this.mDropDownHeight;
            }
            PopupWindow popupWindow = this.mPopup;
            boolean bl2 = !this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible;
            popupWindow.setOutsideTouchable(bl2);
            PopupWindow popupWindow2 = this.mPopup;
            View view = this.getDropDownAnchorView();
            int n6 = this.mDropDownHorizontalOffset;
            int n7 = this.mDropDownVerticalOffset;
            popupWindow2.update(view, n6, n7, n2, n3);
            return;
        }
        if (this.mDropDownWidth == -1) {
            n2 = -1;
        } else if (this.mDropDownWidth == -1) {
            PopupWindow popupWindow = this.mPopup;
            int n8 = this.getDropDownAnchorView().getWidth();
            popupWindow.setWidth(n8);
        } else {
            PopupWindow popupWindow = this.mPopup;
            int n9 = this.mDropDownWidth;
            popupWindow.setWidth(n9);
        }
        if (this.mDropDownHeight == -1) {
            n3 = -1;
        } else if (this.mDropDownHeight == -1) {
            this.mPopup.setHeight(n);
        } else {
            PopupWindow popupWindow = this.mPopup;
            int n10 = this.mDropDownHeight;
            popupWindow.setHeight(n10);
        }
        this.mPopup.setWindowLayoutMode(n2, n3);
        this.mPopup.setInputMethodMode(1);
        PopupWindow popupWindow = this.mPopup;
        boolean bl3 = !this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible;
        popupWindow.setOutsideTouchable(bl3);
        PopupWindow popupWindow3 = this.mPopup;
        PopupTouchInterceptor popupTouchInterceptor = new PopupTouchInterceptor();
        popupWindow3.setTouchInterceptor(popupTouchInterceptor);
        PopupWindow popupWindow4 = this.mPopup;
        View view = this.getDropDownAnchorView();
        int n11 = this.mDropDownHorizontalOffset;
        int n12 = this.mDropDownVerticalOffset;
        popupWindow4.showAsDropDown(view, n11, n12);
        this.mDropDownList.setSelection(-1);
        this.clearListSelection();
        ListSelectorHider listSelectorHider = this.mHideSelector;
        boolean bl4 = this.post(listSelectorHider);
    }

    public void showDropDownAfterLayout() {
        Runnable runnable = this.mShowDropDownRunnable;
        boolean bl = this.post(runnable);
    }

    private class PopupDataSetObserver
    extends DataSetObserver {
        private PopupDataSetObserver() {
        }

        @Override
        public void onChanged() {
            if (AutoCompleteTextView.this.isPopupShowing()) {
                AutoCompleteTextView.this.showDropDown();
                return;
            }
            if (AutoCompleteTextView.this.mAdapter == null) {
                return;
            }
            AutoCompleteTextView autoCompleteTextView = AutoCompleteTextView.this;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ListAdapter listAdapter = AutoCompleteTextView.this.mAdapter;
                    if (listAdapter == null) {
                        return;
                    }
                    AutoCompleteTextView autoCompleteTextView = AutoCompleteTextView.this;
                    int n = listAdapter.getCount();
                    autoCompleteTextView.updateDropDownForFilter(n);
                }
            };
            boolean bl = autoCompleteTextView.post(runnable);
        }

        @Override
        public void onInvalidated() {
            if (AutoCompleteTextView.this.mDropDownAlwaysVisible) {
                return;
            }
            AutoCompleteTextView.this.dismissDropDown();
        }
    }

    private class PassThroughClickListener
    implements View.OnClickListener {
        private View.OnClickListener mWrapped;

        private PassThroughClickListener() {
        }

        static /* synthetic */ View.OnClickListener access$402(PassThroughClickListener passThroughClickListener, View.OnClickListener onClickListener) {
            passThroughClickListener.mWrapped = onClickListener;
            return onClickListener;
        }

        @Override
        public void onClick(View view) {
            AutoCompleteTextView.this.onClickImpl();
            if (this.mWrapped == null) {
                return;
            }
            this.mWrapped.onClick(view);
        }
    }

    public static interface Validator {
        public CharSequence fixText(CharSequence var1);

        public boolean isValid(CharSequence var1);
    }

    private static class DropDownListView
    extends ListView {
        private boolean mListSelectionHidden;

        public DropDownListView(Context context) {
            super(context, null, 16842861);
        }

        static /* synthetic */ boolean access$602(DropDownListView dropDownListView, boolean bl) {
            dropDownListView.mListSelectionHidden = bl;
            return bl;
        }

        @Override
        public boolean hasFocus() {
            return true;
        }

        @Override
        public boolean hasWindowFocus() {
            return true;
        }

        @Override
        public boolean isFocused() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isInTouchMode() {
            if (this.mListSelectionHidden) return true;
            if (!super.isInTouchMode()) return false;
            return true;
        }

        @Override
        View obtainView(int n, boolean[] blArray) {
            View view = super.obtainView(n, blArray);
            if (view instanceof TextView) {
                ((TextView)view).setHorizontallyScrolling(true);
            }
            return view;
        }

        @Override
        protected int[] onCreateDrawableState(int n) {
            return super.onCreateDrawableState(n);
        }
    }

    private class DropDownItemClickListener
    implements AdapterView.OnItemClickListener {
        private DropDownItemClickListener() {
        }

        public void onItemClick(AdapterView adapterView, View view, int n, long l) {
            AutoCompleteTextView.this.performCompletion(view, n, l);
        }
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener {
        private PopupScrollListener() {
        }

        @Override
        public void onScroll(AbsListView absListView, int n, int n2, int n3) {
        }

        @Override
        public void onScrollStateChanged(AbsListView absListView, int n) {
            if (n != 1) {
                return;
            }
            if (AutoCompleteTextView.this.isInputMethodNotNeeded()) {
                return;
            }
            if (AutoCompleteTextView.this.mPopup.getContentView() == null) {
                return;
            }
            AutoCompleteTextView autoCompleteTextView = AutoCompleteTextView.this;
            Runnable runnable = AutoCompleteTextView.this.mResizePopupRunnable;
            boolean bl = autoCompleteTextView.removeCallbacks(runnable);
            AutoCompleteTextView.this.mResizePopupRunnable.run();
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener {
        private PopupTouchInterceptor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            int n = motionEvent.getAction();
            if (n == 0 && AutoCompleteTextView.this.mPopup != null && AutoCompleteTextView.this.mPopup.isShowing()) {
                AutoCompleteTextView autoCompleteTextView = AutoCompleteTextView.this;
                Runnable runnable = AutoCompleteTextView.this.mResizePopupRunnable;
                boolean bl = autoCompleteTextView.postDelayed(runnable, 250L);
                return false;
            }
            if (n != 1) return false;
            AutoCompleteTextView autoCompleteTextView = AutoCompleteTextView.this;
            Runnable runnable = AutoCompleteTextView.this.mResizePopupRunnable;
            boolean bl = autoCompleteTextView.removeCallbacks(runnable);
            return false;
        }
    }

    private class ResizePopupRunnable
    implements Runnable {
        private ResizePopupRunnable() {
        }

        @Override
        public void run() {
            AutoCompleteTextView.this.mPopup.setInputMethodMode(2);
            AutoCompleteTextView.this.showDropDown();
        }
    }

    private class ListSelectorHider
    implements Runnable {
        private ListSelectorHider() {
        }

        @Override
        public void run() {
            AutoCompleteTextView.this.clearListSelection();
        }
    }

    private class MyWatcher
    implements TextWatcher {
        private MyWatcher() {
        }

        @Override
        public void afterTextChanged(Editable editable) {
            AutoCompleteTextView.this.doAfterTextChanged();
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            AutoCompleteTextView.this.doBeforeTextChanged();
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }
}

