/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Checkable;
import android.widget.TextView;
import com.android.internal.R;

public class CheckedTextView
extends TextView
implements Checkable {
    private static final int[] CHECKED_STATE_SET;
    private int mBasePaddingRight;
    private Drawable mCheckMarkDrawable;
    private int mCheckMarkResource;
    private int mCheckMarkWidth;
    private boolean mChecked;

    static {
        int[] nArray = new int[]{0x10100A0};
        CHECKED_STATE_SET = nArray;
    }

    public CheckedTextView(Context context) {
        this(context, null);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int[] nArray = R.styleable.CheckedTextView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        Drawable drawable2 = typedArray.getDrawable(1);
        if (drawable2 != null) {
            this.setCheckMarkDrawable(drawable2);
        }
        boolean bl = typedArray.getBoolean(0, false);
        this.setChecked(bl);
        typedArray.recycle();
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        boolean bl = super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        if (!bl) {
            boolean bl2 = this.mChecked;
            accessibilityEvent.setChecked(bl2);
        }
        return bl;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mCheckMarkDrawable == null) {
            return;
        }
        int[] nArray = this.getDrawableState();
        boolean bl = this.mCheckMarkDrawable.setState(nArray);
        this.invalidate();
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return this.mChecked;
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        int n2 = n + 1;
        int[] nArray = super.onCreateDrawableState(n2);
        if (this.isChecked()) {
            int[] nArray2 = CHECKED_STATE_SET;
            int[] nArray3 = CheckedTextView.mergeDrawableStates(nArray, nArray2);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable drawable2 = this.mCheckMarkDrawable;
        if (drawable2 == null) {
            return;
        }
        int n = this.getGravity() & 0x70;
        int n2 = drawable2.getIntrinsicHeight();
        int n3 = 0;
        switch (n) {
            case 80: {
                n3 = this.getHeight() - n2;
            }
            default: {
                break;
            }
            case 16: {
                n3 = (this.getHeight() - n2) / 2;
            }
        }
        int n4 = this.getWidth();
        int n5 = this.mCheckMarkWidth;
        int n6 = n4 - n5;
        int n7 = this.mBasePaddingRight;
        int n8 = n6 - n7;
        int n9 = this.mBasePaddingRight;
        int n10 = n4 - n9;
        int n11 = n3 + n2;
        drawable2.setBounds(n8, n3, n10, n11);
        drawable2.draw(canvas);
    }

    public void setCheckMarkDrawable(int n) {
        int n2;
        if (n != 0 && n != (n2 = this.mCheckMarkResource)) {
            return;
        }
        this.mCheckMarkResource = n;
        Drawable drawable2 = null;
        if (this.mCheckMarkResource != 0) {
            Resources resources = this.getResources();
            int n3 = this.mCheckMarkResource;
            drawable2 = resources.getDrawable(n3);
        }
        this.setCheckMarkDrawable(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCheckMarkDrawable(Drawable drawable2) {
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setCallback(null);
            Drawable drawable3 = this.mCheckMarkDrawable;
            this.unscheduleDrawable(drawable3);
        }
        if (drawable2 != null) {
            int n;
            int n2;
            drawable2.setCallback(this);
            boolean bl = this.getVisibility() == 0;
            boolean bl2 = drawable2.setVisible(bl, false);
            int[] nArray = CHECKED_STATE_SET;
            boolean bl3 = drawable2.setState(nArray);
            int n3 = drawable2.getIntrinsicHeight();
            this.setMinHeight(n3);
            int n4 = this.mCheckMarkWidth = (n2 = drawable2.getIntrinsicWidth());
            int n5 = this.mBasePaddingRight;
            this.mPaddingRight = n = n4 + n5;
            int[] nArray2 = this.getDrawableState();
            boolean bl4 = drawable2.setState(nArray2);
        } else {
            int n;
            this.mPaddingRight = n = this.mBasePaddingRight;
        }
        this.mCheckMarkDrawable = drawable2;
        this.requestLayout();
    }

    @Override
    public void setChecked(boolean bl) {
        if (this.mChecked != bl) {
            return;
        }
        this.mChecked = bl;
        this.refreshDrawableState();
    }

    @Override
    public void setPadding(int n, int n2, int n3, int n4) {
        int n5;
        super.setPadding(n, n2, n3, n4);
        this.mBasePaddingRight = n5 = this.mPaddingRight;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void toggle() {
        boolean bl = !this.mChecked;
        this.setChecked(bl);
    }
}

