/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;

@RemoteViews.RemoteView
public class Chronometer
extends TextView {
    private static final String TAG = "Chronometer";
    private static final int TICK_WHAT = 2;
    private long mBase;
    private String mFormat;
    private StringBuilder mFormatBuilder;
    private Formatter mFormatter;
    private Object[] mFormatterArgs;
    private Locale mFormatterLocale;
    private Handler mHandler;
    private boolean mLogged;
    private OnChronometerTickListener mOnChronometerTickListener;
    private StringBuilder mRecycle;
    private boolean mRunning;
    private boolean mStarted;
    private boolean mVisible;

    public Chronometer(Context context) {
        this(context, null, 0);
    }

    public Chronometer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public Chronometer(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Handler handler;
        StringBuilder stringBuilder;
        Object[] objectArray = new Object[1];
        this.mFormatterArgs = objectArray;
        this.mRecycle = stringBuilder = new StringBuilder(8);
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                if (!Chronometer.this.mRunning) {
                    return;
                }
                Chronometer chronometer = Chronometer.this;
                long l = SystemClock.elapsedRealtime();
                chronometer.updateText(l);
                Chronometer.this.dispatchChronometerTick();
                Message message2 = Message.obtain((Handler)this, 2);
                boolean bl = this.sendMessageDelayed(message2, 1000L);
            }
        };
        int[] nArray = R.styleable.Chronometer;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        String string2 = typedArray.getString(0);
        this.setFormat(string2);
        typedArray.recycle();
        this.init();
    }

    private void init() {
        long l;
        long l2 = this.mBase = (l = SystemClock.elapsedRealtime());
        this.updateText(l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateRunning() {
        boolean bl;
        boolean bl2 = this.mVisible && this.mStarted;
        if (bl2 != (bl = this.mRunning)) {
            return;
        }
        if (bl2) {
            long l = SystemClock.elapsedRealtime();
            this.updateText(l);
            this.dispatchChronometerTick();
            Handler handler = this.mHandler;
            Message message = Message.obtain(this.mHandler, 2);
            boolean bl3 = handler.sendMessageDelayed(message, 1000L);
        } else {
            this.mHandler.removeMessages(2);
        }
        this.mRunning = bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateText(long l) {
        synchronized (this) {
            String string2;
            block6: {
                long l2 = this.mBase;
                long l3 = (l - l2) / 1000L;
                string2 = DateUtils.formatElapsedTime(this.mRecycle, l3);
                if (this.mFormat != null) {
                    Locale locale;
                    Locale locale2 = Locale.getDefault();
                    if (this.mFormatter == null || !locale2.equals(locale = this.mFormatterLocale)) {
                        Formatter formatter;
                        this.mFormatterLocale = locale2;
                        StringBuilder stringBuilder = this.mFormatBuilder;
                        this.mFormatter = formatter = new Formatter(stringBuilder, locale2);
                    }
                    this.mFormatBuilder.setLength(0);
                    this.mFormatterArgs[0] = string2;
                    try {
                        String string3;
                        Formatter formatter = this.mFormatter;
                        String string4 = this.mFormat;
                        Object[] objectArray = this.mFormatterArgs;
                        Formatter formatter2 = formatter.format(string4, objectArray);
                        string2 = string3 = this.mFormatBuilder.toString();
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        if (this.mLogged) break block6;
                        StringBuilder stringBuilder = new StringBuilder().append("Illegal format string: ");
                        String string5 = this.mFormat;
                        String string6 = stringBuilder.append(string5).toString();
                        int n = Log.w(TAG, string6);
                        this.mLogged = true;
                    }
                }
            }
            this.setText(string2);
            return;
        }
    }

    void dispatchChronometerTick() {
        if (this.mOnChronometerTickListener == null) {
            return;
        }
        this.mOnChronometerTickListener.onChronometerTick(this);
    }

    public long getBase() {
        return this.mBase;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public OnChronometerTickListener getOnChronometerTickListener() {
        return this.mOnChronometerTickListener;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.updateRunning();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        boolean bl = n == 0;
        this.mVisible = bl;
        this.updateRunning();
    }

    @RemotableViewMethod
    public void setBase(long l) {
        this.mBase = l;
        this.dispatchChronometerTick();
        long l2 = SystemClock.elapsedRealtime();
        this.updateText(l2);
    }

    @RemotableViewMethod
    public void setFormat(String string2) {
        StringBuilder stringBuilder;
        this.mFormat = string2;
        if (string2 == null) {
            return;
        }
        if (this.mFormatBuilder != null) {
            return;
        }
        int n = string2.length() * 2;
        this.mFormatBuilder = stringBuilder = new StringBuilder(n);
    }

    public void setOnChronometerTickListener(OnChronometerTickListener onChronometerTickListener) {
        this.mOnChronometerTickListener = onChronometerTickListener;
    }

    @RemotableViewMethod
    public void setStarted(boolean bl) {
        this.mStarted = bl;
        this.updateRunning();
    }

    public void start() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stop() {
        this.mStarted = false;
        this.updateRunning();
    }

    public static interface OnChronometerTickListener {
        public void onChronometerTick(Chronometer var1);
    }
}

