/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Button;
import android.widget.Checkable;
import com.android.internal.R;

public abstract class CompoundButton
extends Button
implements Checkable {
    private static final int[] CHECKED_STATE_SET;
    private boolean mBroadcasting;
    private Drawable mButtonDrawable;
    private int mButtonResource;
    private boolean mChecked;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeWidgetListener;

    static {
        int[] nArray = new int[]{0x10100A0};
        CHECKED_STATE_SET = nArray;
    }

    public CompoundButton(Context context) {
        this(context, null);
    }

    public CompoundButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CompoundButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int[] nArray = R.styleable.CompoundButton;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        Drawable drawable2 = typedArray.getDrawable(1);
        if (drawable2 != null) {
            this.setButtonDrawable(drawable2);
        }
        boolean bl = typedArray.getBoolean(0, false);
        this.setChecked(bl);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        boolean bl = super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        if (!bl) {
            int n = this.mChecked ? 17040216 : 17040217;
            String string2 = this.getResources().getString(n);
            boolean bl2 = accessibilityEvent.getText().add(string2);
            boolean bl3 = this.mChecked;
            accessibilityEvent.setChecked(bl3);
        }
        return bl;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mButtonDrawable == null) {
            return;
        }
        int[] nArray = this.getDrawableState();
        boolean bl = this.mButtonDrawable.setState(nArray);
        this.invalidate();
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return this.mChecked;
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        int n2 = n + 1;
        int[] nArray = super.onCreateDrawableState(n2);
        if (this.isChecked()) {
            int[] nArray2 = CHECKED_STATE_SET;
            int[] nArray3 = CompoundButton.mergeDrawableStates(nArray, nArray2);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable drawable2 = this.mButtonDrawable;
        if (drawable2 == null) {
            return;
        }
        int n = this.getGravity() & 0x70;
        int n2 = drawable2.getIntrinsicHeight();
        int n3 = 0;
        switch (n) {
            case 80: {
                n3 = this.getHeight() - n2;
            }
            default: {
                break;
            }
            case 16: {
                n3 = (this.getHeight() - n2) / 2;
            }
        }
        int n4 = drawable2.getIntrinsicWidth();
        int n5 = n3 + n2;
        drawable2.setBounds(0, n3, n4, n5);
        drawable2.draw(canvas);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        boolean bl = savedState.checked;
        this.setChecked(bl);
        this.requestLayout();
    }

    @Override
    public Parcelable onSaveInstanceState() {
        boolean bl;
        this.setFreezesText(true);
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        savedState.checked = bl = this.isChecked();
        return savedState;
    }

    @Override
    public boolean performClick() {
        this.toggle();
        return super.performClick();
    }

    public void setButtonDrawable(int n) {
        int n2;
        if (n != 0 && n != (n2 = this.mButtonResource)) {
            return;
        }
        this.mButtonResource = n;
        Drawable drawable2 = null;
        if (this.mButtonResource != 0) {
            Resources resources = this.getResources();
            int n3 = this.mButtonResource;
            drawable2 = resources.getDrawable(n3);
        }
        this.setButtonDrawable(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setButtonDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            if (this.mButtonDrawable != null) {
                this.mButtonDrawable.setCallback(null);
                Drawable drawable3 = this.mButtonDrawable;
                this.unscheduleDrawable(drawable3);
            }
            drawable2.setCallback(this);
            int[] nArray = this.getDrawableState();
            boolean bl = drawable2.setState(nArray);
            boolean bl2 = this.getVisibility() == 0;
            boolean bl3 = drawable2.setVisible(bl2, false);
            this.mButtonDrawable = drawable2;
            boolean bl4 = this.mButtonDrawable.setState(null);
            int n = this.mButtonDrawable.getIntrinsicHeight();
            this.setMinHeight(n);
        }
        this.refreshDrawableState();
    }

    @Override
    public void setChecked(boolean bl) {
        if (this.mChecked != bl) {
            return;
        }
        this.mChecked = bl;
        this.refreshDrawableState();
        if (this.mBroadcasting) {
            return;
        }
        this.mBroadcasting = true;
        if (this.mOnCheckedChangeListener != null) {
            OnCheckedChangeListener onCheckedChangeListener = this.mOnCheckedChangeListener;
            boolean bl2 = this.mChecked;
            onCheckedChangeListener.onCheckedChanged(this, bl2);
        }
        if (this.mOnCheckedChangeWidgetListener != null) {
            OnCheckedChangeListener onCheckedChangeListener = this.mOnCheckedChangeWidgetListener;
            boolean bl3 = this.mChecked;
            onCheckedChangeListener.onCheckedChanged(this, bl3);
        }
        this.mBroadcasting = false;
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    void setOnCheckedChangeWidgetListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeWidgetListener = onCheckedChangeListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void toggle() {
        boolean bl = !this.mChecked;
        this.setChecked(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        Drawable drawable3 = this.mButtonDrawable;
        if (drawable2 != drawable3) return false;
        return true;
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean checked;

        private SavedState(Parcel parcel) {
            super(parcel);
            boolean bl;
            this.checked = bl = ((Boolean)parcel.readValue(null)).booleanValue();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("CompoundButton.SavedState{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" checked=");
            boolean bl = this.checked;
            return stringBuilder2.append(bl).append("}").toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            Boolean bl = this.checked;
            parcel.writeValue(bl);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }
}

