/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;

public abstract class CursorAdapter
extends BaseAdapter
implements Filterable,
CursorFilter.CursorFilterClient {
    protected boolean mAutoRequery;
    protected ChangeObserver mChangeObserver;
    protected Context mContext;
    protected Cursor mCursor;
    protected CursorFilter mCursorFilter;
    protected DataSetObserver mDataSetObserver;
    protected boolean mDataValid;
    protected FilterQueryProvider mFilterQueryProvider;
    protected int mRowIDColumn;

    public CursorAdapter(Context context, Cursor cursor) {
        MyDataSetObserver myDataSetObserver = new MyDataSetObserver();
        this.mDataSetObserver = myDataSetObserver;
        this.init(context, cursor, true);
    }

    public CursorAdapter(Context context, Cursor cursor, boolean bl) {
        MyDataSetObserver myDataSetObserver = new MyDataSetObserver();
        this.mDataSetObserver = myDataSetObserver;
        this.init(context, cursor, bl);
    }

    public abstract void bindView(View var1, Context var2, Cursor var3);

    @Override
    public void changeCursor(Cursor cursor) {
        Cursor cursor2 = this.mCursor;
        if (cursor == cursor2) {
            return;
        }
        if (this.mCursor != null) {
            Cursor cursor3 = this.mCursor;
            ChangeObserver changeObserver = this.mChangeObserver;
            cursor3.unregisterContentObserver(changeObserver);
            Cursor cursor4 = this.mCursor;
            DataSetObserver dataSetObserver = this.mDataSetObserver;
            cursor4.unregisterDataSetObserver(dataSetObserver);
            this.mCursor.close();
        }
        this.mCursor = cursor;
        if (cursor != null) {
            int n;
            ChangeObserver changeObserver = this.mChangeObserver;
            cursor.registerContentObserver(changeObserver);
            DataSetObserver dataSetObserver = this.mDataSetObserver;
            cursor.registerDataSetObserver(dataSetObserver);
            this.mRowIDColumn = n = cursor.getColumnIndexOrThrow("_id");
            this.mDataValid = true;
            this.notifyDataSetChanged();
            return;
        }
        this.mRowIDColumn = -1;
        this.mDataValid = false;
        this.notifyDataSetInvalidated();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence convertToString(Cursor cursor) {
        if (cursor != null) return cursor.toString();
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getCount() {
        if (!this.mDataValid) return 0;
        if (this.mCursor == null) return 0;
        return this.mCursor.getCount();
    }

    @Override
    public Cursor getCursor() {
        return this.mCursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getDropDownView(int n, View view, ViewGroup viewGroup) {
        View view2;
        if (!this.mDataValid) {
            return null;
        }
        boolean bl = this.mCursor.moveToPosition(n);
        if (view == null) {
            Context context = this.mContext;
            Cursor cursor = this.mCursor;
            view2 = this.newDropDownView(context, cursor, viewGroup);
        } else {
            view2 = view;
        }
        Context context = this.mContext;
        Cursor cursor = this.mCursor;
        this.bindView(view2, context, cursor);
        return view2;
    }

    @Override
    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            CursorFilter cursorFilter;
            this.mCursorFilter = cursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getItem(int n) {
        if (!this.mDataValid) return null;
        if (this.mCursor == null) return null;
        boolean bl = this.mCursor.moveToPosition(n);
        return this.mCursor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getItemId(int n) {
        if (!this.mDataValid) return 0L;
        if (this.mCursor == null) return 0L;
        if (!this.mCursor.moveToPosition(n)) return 0L;
        Cursor cursor = this.mCursor;
        int n2 = this.mRowIDColumn;
        return cursor.getLong(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        View view2;
        if (!this.mDataValid) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (!this.mCursor.moveToPosition(n)) {
            String string2 = "couldn't move cursor to position " + n;
            throw new IllegalStateException(string2);
        }
        if (view == null) {
            Context context = this.mContext;
            Cursor cursor = this.mCursor;
            view2 = this.newView(context, cursor, viewGroup);
        } else {
            view2 = view;
        }
        Context context = this.mContext;
        Cursor cursor = this.mCursor;
        this.bindView(view2, context, cursor);
        return view2;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void init(Context context, Cursor cursor, boolean bl) {
        ChangeObserver changeObserver;
        boolean bl2 = cursor != null;
        this.mAutoRequery = bl;
        this.mCursor = cursor;
        this.mDataValid = bl2;
        this.mContext = context;
        int n = bl2 ? cursor.getColumnIndexOrThrow("_id") : -1;
        this.mRowIDColumn = n;
        this.mChangeObserver = changeObserver = new ChangeObserver();
        if (!bl2) {
            return;
        }
        ChangeObserver changeObserver2 = this.mChangeObserver;
        cursor.registerContentObserver(changeObserver2);
        DataSetObserver dataSetObserver = this.mDataSetObserver;
        cursor.registerDataSetObserver(dataSetObserver);
    }

    public View newDropDownView(Context context, Cursor cursor, ViewGroup viewGroup) {
        return this.newView(context, cursor, viewGroup);
    }

    public abstract View newView(Context var1, Cursor var2, ViewGroup var3);

    protected void onContentChanged() {
        boolean bl;
        if (!this.mAutoRequery) {
            return;
        }
        if (this.mCursor == null) {
            return;
        }
        if (this.mCursor.isClosed()) {
            return;
        }
        this.mDataValid = bl = this.mCursor.requery();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        if (this.mFilterQueryProvider == null) return this.mCursor;
        return this.mFilterQueryProvider.runQuery(charSequence);
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    private class MyDataSetObserver
    extends DataSetObserver {
        private MyDataSetObserver() {
        }

        @Override
        public void onChanged() {
            CursorAdapter.this.mDataValid = true;
            CursorAdapter.this.notifyDataSetChanged();
        }

        @Override
        public void onInvalidated() {
            CursorAdapter.this.mDataValid = false;
            CursorAdapter.this.notifyDataSetInvalidated();
        }
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            Handler handler = new Handler();
            super(handler);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return true;
        }

        @Override
        public void onChange(boolean bl) {
            CursorAdapter.this.onContentChanged();
        }
    }
}

