/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.Cursor;
import android.widget.Filter;

class CursorFilter
extends Filter {
    CursorFilterClient mClient;

    CursorFilter(CursorFilterClient cursorFilterClient) {
        this.mClient = cursorFilterClient;
    }

    @Override
    public CharSequence convertResultToString(Object object) {
        CursorFilterClient cursorFilterClient = this.mClient;
        Cursor cursor = (Cursor)object;
        return cursorFilterClient.convertToString(cursor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Filter.FilterResults performFiltering(CharSequence charSequence) {
        Cursor cursor = this.mClient.runQueryOnBackgroundThread(charSequence);
        Filter.FilterResults filterResults = new Filter.FilterResults();
        if (cursor != null) {
            int n;
            filterResults.count = n = cursor.getCount();
            filterResults.values = cursor;
            return filterResults;
        }
        filterResults.count = 0;
        filterResults.values = null;
        return filterResults;
    }

    @Override
    protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
        Cursor cursor = this.mClient.getCursor();
        if (filterResults.values == null) {
            return;
        }
        if (filterResults.values == cursor) {
            return;
        }
        CursorFilterClient cursorFilterClient = this.mClient;
        Cursor cursor2 = (Cursor)filterResults.values;
        cursorFilterClient.changeCursor(cursor2);
    }

    static interface CursorFilterClient {
        public void changeCursor(Cursor var1);

        public CharSequence convertToString(Cursor var1);

        public Cursor getCursor();

        public Cursor runQueryOnBackgroundThread(CharSequence var1);
    }
}

