/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;

public abstract class CursorTreeAdapter
extends BaseExpandableListAdapter
implements Filterable,
CursorFilter.CursorFilterClient {
    private boolean mAutoRequery;
    SparseArray<MyCursorHelper> mChildrenCursorHelpers;
    private Context mContext;
    CursorFilter mCursorFilter;
    FilterQueryProvider mFilterQueryProvider;
    MyCursorHelper mGroupCursorHelper;
    private Handler mHandler;

    public CursorTreeAdapter(Cursor cursor, Context context) {
        this.init(cursor, context, true);
    }

    public CursorTreeAdapter(Cursor cursor, Context context, boolean bl) {
        this.init(cursor, context, bl);
    }

    private void init(Cursor cursor, Context context, boolean bl) {
        MyCursorHelper myCursorHelper;
        Handler handler;
        this.mContext = context;
        this.mHandler = handler = new Handler();
        this.mAutoRequery = bl;
        this.mGroupCursorHelper = myCursorHelper = new MyCursorHelper(cursor);
        SparseArray sparseArray = new SparseArray();
        this.mChildrenCursorHelpers = sparseArray;
    }

    private void releaseCursorHelpers() {
        synchronized (this) {
            for (int i = this.mChildrenCursorHelpers.size() - 1; i >= 0; i += -1) {
                this.mChildrenCursorHelpers.valueAt(i).deactivate();
            }
            this.mChildrenCursorHelpers.clear();
            return;
        }
    }

    protected abstract void bindChildView(View var1, Context var2, Cursor var3, boolean var4);

    protected abstract void bindGroupView(View var1, Context var2, Cursor var3, boolean var4);

    @Override
    public void changeCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String convertToString(Cursor cursor) {
        if (cursor != null) return cursor.toString();
        return "";
    }

    void deactivateChildrenCursorHelper(int n) {
        synchronized (this) {
            MyCursorHelper myCursorHelper = this.getChildrenCursorHelper(n, true);
            this.mChildrenCursorHelpers.remove(n);
            myCursorHelper.deactivate();
            return;
        }
    }

    @Override
    public Cursor getChild(int n, int n2) {
        return this.getChildrenCursorHelper(n, true).moveTo(n2);
    }

    @Override
    public long getChildId(int n, int n2) {
        return this.getChildrenCursorHelper(n, true).getId(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
        View view2;
        Cursor cursor = this.getChildrenCursorHelper(n, true).moveTo(n2);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (view == null) {
            Context context = this.mContext;
            view2 = this.newChildView(context, cursor, bl, viewGroup);
        } else {
            view2 = view;
        }
        Context context = this.mContext;
        this.bindChildView(view2, context, cursor, bl);
        return view2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getChildrenCount(int n) {
        MyCursorHelper myCursorHelper = this.getChildrenCursorHelper(n, true);
        if (!this.mGroupCursorHelper.isValid()) return 0;
        if (myCursorHelper == null) return 0;
        return myCursorHelper.getCount();
    }

    protected abstract Cursor getChildrenCursor(Cursor var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MyCursorHelper getChildrenCursorHelper(int n, boolean bl) {
        synchronized (this) {
            MyCursorHelper myCursorHelper;
            block4: {
                myCursorHelper = this.mChildrenCursorHelpers.get(n);
                if (myCursorHelper != null) return myCursorHelper;
                Cursor cursor = this.mGroupCursorHelper.moveTo(n);
                if (cursor != null) break block4;
                return null;
            }
            Cursor cursor = this.mGroupCursorHelper.getCursor();
            Cursor cursor2 = this.getChildrenCursor(cursor);
            myCursorHelper = new MyCursorHelper(cursor2);
            this.mChildrenCursorHelpers.put(n, myCursorHelper);
            return myCursorHelper;
        }
    }

    @Override
    public Cursor getCursor() {
        return this.mGroupCursorHelper.getCursor();
    }

    @Override
    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            CursorFilter cursorFilter;
            this.mCursorFilter = cursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    @Override
    public Cursor getGroup(int n) {
        return this.mGroupCursorHelper.moveTo(n);
    }

    @Override
    public int getGroupCount() {
        return this.mGroupCursorHelper.getCount();
    }

    @Override
    public long getGroupId(int n) {
        return this.mGroupCursorHelper.getId(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
        View view2;
        Cursor cursor = this.mGroupCursorHelper.moveTo(n);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (view == null) {
            Context context = this.mContext;
            view2 = this.newGroupView(context, cursor, bl, viewGroup);
        } else {
            view2 = view;
        }
        Context context = this.mContext;
        this.bindGroupView(view2, context, cursor, bl);
        return view2;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public boolean isChildSelectable(int n, int n2) {
        return true;
    }

    protected abstract View newChildView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    protected abstract View newGroupView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    @Override
    public void notifyDataSetChanged() {
        this.notifyDataSetChanged(true);
    }

    public void notifyDataSetChanged(boolean bl) {
        if (bl) {
            this.releaseCursorHelpers();
        }
        super.notifyDataSetChanged();
    }

    @Override
    public void notifyDataSetInvalidated() {
        this.releaseCursorHelpers();
        super.notifyDataSetInvalidated();
    }

    @Override
    public void onGroupCollapsed(int n) {
        this.deactivateChildrenCursorHelper(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        if (this.mFilterQueryProvider == null) return this.mGroupCursorHelper.getCursor();
        return this.mFilterQueryProvider.runQuery(charSequence);
    }

    public void setChildrenCursor(int n, Cursor cursor) {
        this.getChildrenCursorHelper(n, false).changeCursor(cursor, false);
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    public void setGroupCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, false);
    }

    class MyCursorHelper {
        private MyContentObserver mContentObserver;
        private Cursor mCursor;
        private MyDataSetObserver mDataSetObserver;
        private boolean mDataValid;
        private int mRowIDColumn;

        /*
         * Enabled aggressive block sorting
         */
        MyCursorHelper(Cursor cursor) {
            MyDataSetObserver myDataSetObserver;
            MyContentObserver myContentObserver;
            boolean bl = cursor != null;
            this.mCursor = cursor;
            this.mDataValid = bl;
            int n = bl ? cursor.getColumnIndex("_id") : -1;
            this.mRowIDColumn = n;
            this.mContentObserver = myContentObserver = new MyContentObserver();
            this.mDataSetObserver = myDataSetObserver = new MyDataSetObserver();
            if (!bl) {
                return;
            }
            MyContentObserver myContentObserver2 = this.mContentObserver;
            cursor.registerContentObserver(myContentObserver2);
            MyDataSetObserver myDataSetObserver2 = this.mDataSetObserver;
            cursor.registerDataSetObserver(myDataSetObserver2);
        }

        static /* synthetic */ boolean access$402(MyCursorHelper myCursorHelper, boolean bl) {
            myCursorHelper.mDataValid = bl;
            return bl;
        }

        void changeCursor(Cursor cursor, boolean bl) {
            Cursor cursor2 = this.mCursor;
            if (cursor == cursor2) {
                return;
            }
            this.deactivate();
            this.mCursor = cursor;
            if (cursor != null) {
                int n;
                MyContentObserver myContentObserver = this.mContentObserver;
                cursor.registerContentObserver(myContentObserver);
                MyDataSetObserver myDataSetObserver = this.mDataSetObserver;
                cursor.registerDataSetObserver(myDataSetObserver);
                this.mRowIDColumn = n = cursor.getColumnIndex("_id");
                this.mDataValid = true;
                CursorTreeAdapter.this.notifyDataSetChanged(bl);
                return;
            }
            this.mRowIDColumn = -1;
            this.mDataValid = false;
            CursorTreeAdapter.this.notifyDataSetInvalidated();
        }

        void deactivate() {
            if (this.mCursor == null) {
                return;
            }
            Cursor cursor = this.mCursor;
            MyContentObserver myContentObserver = this.mContentObserver;
            cursor.unregisterContentObserver(myContentObserver);
            Cursor cursor2 = this.mCursor;
            MyDataSetObserver myDataSetObserver = this.mDataSetObserver;
            cursor2.unregisterDataSetObserver(myDataSetObserver);
            this.mCursor.close();
            this.mCursor = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getCount() {
            if (!this.mDataValid) return 0;
            if (this.mCursor == null) return 0;
            return this.mCursor.getCount();
        }

        Cursor getCursor() {
            return this.mCursor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        long getId(int n) {
            if (!this.mDataValid) return 0L;
            if (this.mCursor == null) return 0L;
            if (!this.mCursor.moveToPosition(n)) return 0L;
            Cursor cursor = this.mCursor;
            int n2 = this.mRowIDColumn;
            return cursor.getLong(n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isValid() {
            if (!this.mDataValid) return false;
            if (this.mCursor == null) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Cursor moveTo(int n) {
            if (!this.mDataValid) return null;
            if (this.mCursor == null) return null;
            if (!this.mCursor.moveToPosition(n)) return null;
            return this.mCursor;
        }

        private class MyDataSetObserver
        extends DataSetObserver {
            private MyDataSetObserver() {
            }

            @Override
            public void onChanged() {
                boolean bl = MyCursorHelper.access$402(MyCursorHelper.this, true);
                CursorTreeAdapter.this.notifyDataSetChanged();
            }

            @Override
            public void onInvalidated() {
                boolean bl = MyCursorHelper.access$402(MyCursorHelper.this, false);
                CursorTreeAdapter.this.notifyDataSetInvalidated();
            }
        }

        private class MyContentObserver
        extends ContentObserver {
            public MyContentObserver() {
                Handler handler = CursorTreeAdapter.this.mHandler;
                super(handler);
            }

            @Override
            public boolean deliverSelfNotifications() {
                return true;
            }

            @Override
            public void onChange(boolean bl) {
                if (!CursorTreeAdapter.this.mAutoRequery) {
                    return;
                }
                if (MyCursorHelper.this.mCursor == null) {
                    return;
                }
                MyCursorHelper myCursorHelper = MyCursorHelper.this;
                boolean bl2 = MyCursorHelper.this.mCursor.requery();
                boolean bl3 = MyCursorHelper.access$402(myCursorHelper, bl2);
            }
        }
    }
}

