/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import com.android.internal.R;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class DatePicker
extends FrameLayout {
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int DEFAULT_START_YEAR = 1900;
    private int mDay;
    private final NumberPicker mDayPicker;
    private int mMonth;
    private final NumberPicker mMonthPicker;
    private OnDateChangedListener mOnDateChangedListener;
    private int mYear;
    private final NumberPicker mYearPicker;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DatePicker(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        NumberPicker numberPicker;
        NumberPicker numberPicker2;
        NumberPicker numberPicker3;
        View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367071, (ViewGroup)this, true);
        NumberPicker numberPicker4 = this.mDayPicker = (numberPicker3 = (NumberPicker)this.findViewById(16908703));
        NumberPicker.Formatter formatter = NumberPicker.TWO_DIGIT_FORMATTER;
        numberPicker4.setFormatter(formatter);
        this.mDayPicker.setSpeed(100L);
        NumberPicker numberPicker5 = this.mDayPicker;
        NumberPicker.OnChangedListener onChangedListener = new NumberPicker.OnChangedListener(){

            @Override
            public void onChanged(NumberPicker numberPicker, int n, int n2) {
                int n3 = DatePicker.access$002(DatePicker.this, n2);
                DatePicker.this.notifyDateChanged();
            }
        };
        numberPicker5.setOnChangeListener(onChangedListener);
        NumberPicker numberPicker6 = this.mMonthPicker = (numberPicker2 = (NumberPicker)this.findViewById(16908702));
        NumberPicker.Formatter formatter2 = NumberPicker.TWO_DIGIT_FORMATTER;
        numberPicker6.setFormatter(formatter2);
        String[] stringArray = new DateFormatSymbols().getShortMonths();
        if (stringArray[0].startsWith("1")) {
            int n2;
            for (int i = 0; i < (n2 = stringArray.length); ++i) {
                String string2;
                stringArray[i] = string2 = String.valueOf(i + 1);
            }
            this.mMonthPicker.setRange(1, 12);
        } else {
            this.mMonthPicker.setRange(1, 12, stringArray);
        }
        this.mMonthPicker.setSpeed(200L);
        NumberPicker numberPicker7 = this.mMonthPicker;
        NumberPicker.OnChangedListener onChangedListener2 = new NumberPicker.OnChangedListener(){

            @Override
            public void onChanged(NumberPicker numberPicker, int n, int n2) {
                DatePicker datePicker = DatePicker.this;
                int n3 = n2 - 1;
                int n4 = DatePicker.access$202(datePicker, n3);
                DatePicker.this.adjustMaxDay();
                DatePicker.this.notifyDateChanged();
                DatePicker.this.updateDaySpinner();
            }
        };
        numberPicker7.setOnChangeListener(onChangedListener2);
        this.mYearPicker = numberPicker = (NumberPicker)this.findViewById(16908704);
        this.mYearPicker.setSpeed(100L);
        NumberPicker numberPicker8 = this.mYearPicker;
        NumberPicker.OnChangedListener onChangedListener3 = new NumberPicker.OnChangedListener(){

            @Override
            public void onChanged(NumberPicker numberPicker, int n, int n2) {
                int n3 = DatePicker.access$502(DatePicker.this, n2);
                DatePicker.this.adjustMaxDay();
                DatePicker.this.notifyDateChanged();
                DatePicker.this.updateDaySpinner();
            }
        };
        numberPicker8.setOnChangeListener(onChangedListener3);
        int[] nArray = R.styleable.DatePicker;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        int n3 = typedArray.getInt(0, 1900);
        int n4 = typedArray.getInt(1, 2100);
        this.mYearPicker.setRange(n3, n4);
        typedArray.recycle();
        Calendar calendar = Calendar.getInstance();
        int n5 = calendar.get(1);
        int n6 = calendar.get(2);
        int n7 = calendar.get(5);
        this.init(n5, n6, n7, null);
        this.reorderPickers(stringArray);
        if (this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
    }

    static /* synthetic */ int access$002(DatePicker datePicker, int n) {
        datePicker.mDay = n;
        return n;
    }

    static /* synthetic */ int access$202(DatePicker datePicker, int n) {
        datePicker.mMonth = n;
        return n;
    }

    static /* synthetic */ int access$502(DatePicker datePicker, int n) {
        datePicker.mYear = n;
        return n;
    }

    private void adjustMaxDay() {
        Calendar calendar = Calendar.getInstance();
        int n = this.mYear;
        calendar.set(1, n);
        int n2 = this.mMonth;
        calendar.set(2, n2);
        int n3 = calendar.getActualMaximum(5);
        if (this.mDay <= n3) {
            return;
        }
        this.mDay = n3;
    }

    private void notifyDateChanged() {
        if (this.mOnDateChangedListener == null) {
            return;
        }
        OnDateChangedListener onDateChangedListener = this.mOnDateChangedListener;
        int n = this.mYear;
        int n2 = this.mMonth;
        int n3 = this.mDay;
        onDateChangedListener.onDateChanged(this, n, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void reorderPickers(String[] stringArray) {
        int n;
        String string2;
        java.text.DateFormat dateFormat = stringArray[0].startsWith("1") ? DateFormat.getDateFormat(this.getContext()) : DateFormat.getMediumDateFormat(this.getContext());
        if (dateFormat instanceof SimpleDateFormat) {
            string2 = ((SimpleDateFormat)dateFormat).toPattern();
        } else {
            char[] cArray = DateFormat.getDateFormatOrder(this.getContext());
            string2 = new String(cArray);
        }
        LinearLayout linearLayout = (LinearLayout)this.findViewById(16908701);
        linearLayout.removeAllViews();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < (n = string2.length()); ++i) {
            char c = string2.charAt(i);
            if (c == '\'') {
                bl = !bl;
            }
            if (bl) continue;
            if (c == 'd' && !bl2) {
                NumberPicker numberPicker = this.mDayPicker;
                linearLayout.addView(numberPicker);
                bl2 = true;
                continue;
            }
            if (!(c != 'M' && c != 'L' || bl3)) {
                NumberPicker numberPicker = this.mMonthPicker;
                linearLayout.addView(numberPicker);
                bl3 = true;
                continue;
            }
            if (c != 'y' || bl4) continue;
            NumberPicker numberPicker = this.mYearPicker;
            linearLayout.addView(numberPicker);
            bl4 = true;
        }
        if (!bl3) {
            NumberPicker numberPicker = this.mMonthPicker;
            linearLayout.addView(numberPicker);
        }
        if (!bl2) {
            NumberPicker numberPicker = this.mDayPicker;
            linearLayout.addView(numberPicker);
        }
        if (bl4) {
            return;
        }
        NumberPicker numberPicker = this.mYearPicker;
        linearLayout.addView(numberPicker);
    }

    private void updateDaySpinner() {
        Calendar calendar = Calendar.getInstance();
        int n = this.mYear;
        int n2 = this.mMonth;
        int n3 = this.mDay;
        calendar.set(n, n2, n3);
        int n4 = calendar.getActualMaximum(5);
        this.mDayPicker.setRange(1, n4);
        NumberPicker numberPicker = this.mDayPicker;
        int n5 = this.mDay;
        numberPicker.setCurrent(n5);
    }

    private void updateSpinners() {
        this.updateDaySpinner();
        NumberPicker numberPicker = this.mYearPicker;
        int n = this.mYear;
        numberPicker.setCurrent(n);
        NumberPicker numberPicker2 = this.mMonthPicker;
        int n2 = this.mMonth + 1;
        numberPicker2.setCurrent(n2);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    public int getDayOfMonth() {
        return this.mDay;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getYear() {
        return this.mYear;
    }

    public void init(int n, int n2, int n3, OnDateChangedListener onDateChangedListener) {
        this.mYear = n;
        this.mMonth = n2;
        this.mDay = n3;
        this.mOnDateChangedListener = onDateChangedListener;
        this.updateSpinners();
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        int n;
        int n2;
        int n3;
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        this.mYear = n3 = savedState.getYear();
        this.mMonth = n2 = savedState.getMonth();
        this.mDay = n = savedState.getDay();
        this.updateSpinners();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        int n = this.mYear;
        int n2 = this.mMonth;
        int n3 = this.mDay;
        return new SavedState(parcelable, n, n2, n3);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mDayPicker.setEnabled(bl);
        this.mMonthPicker.setEnabled(bl);
        this.mYearPicker.setEnabled(bl);
    }

    public void updateDate(int n, int n2, int n3) {
        if (this.mYear != n && this.mMonth != n2 && this.mDay != n3) {
            return;
        }
        this.mYear = n;
        this.mMonth = n2;
        this.mDay = n3;
        this.updateSpinners();
        String[] stringArray = new DateFormatSymbols().getShortMonths();
        this.reorderPickers(stringArray);
        this.notifyDateChanged();
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mDay;
        private final int mMonth;
        private final int mYear;

        private SavedState(Parcel parcel) {
            super(parcel);
            int n;
            int n2;
            int n3;
            this.mYear = n3 = parcel.readInt();
            this.mMonth = n2 = parcel.readInt();
            this.mDay = n = parcel.readInt();
        }

        private SavedState(Parcelable parcelable, int n, int n2, int n3) {
            super(parcelable);
            this.mYear = n;
            this.mMonth = n2;
            this.mDay = n3;
        }

        public int getDay() {
            return this.mDay;
        }

        public int getMonth() {
            return this.mMonth;
        }

        public int getYear() {
            return this.mYear;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.mYear;
            parcel.writeInt(n2);
            int n3 = this.mMonth;
            parcel.writeInt(n3);
            int n4 = this.mDay;
            parcel.writeInt(n4);
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }
}

