/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.Date;

@RemoteViews.RemoteView
public class DateTimeView
extends TextView {
    private static final int SHOW_MONTH_DAY_YEAR = 1;
    private static final int SHOW_TIME = 0;
    private static final String TAG = "DateTimeView";
    private static final long TWELVE_HOURS_IN_MINUTES = 720L;
    private static final long TWENTY_FOUR_HOURS_IN_MILLIS = 86400000L;
    private boolean mAttachedToWindow;
    private BroadcastReceiver mBroadcastReceiver;
    private ContentObserver mContentObserver;
    int mLastDisplay = -1;
    java.text.DateFormat mLastFormat;
    Date mTime;
    long mTimeMillis;
    private long mUpdateTimeMillis;

    public DateTimeView(Context context) {
        super(context);
        ContentObserver contentObserver;
        BroadcastReceiver broadcastReceiver;
        this.mBroadcastReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                long l;
                long l2;
                String string2 = intent.getAction();
                if ("android.intent.action.TIME_TICK".equals(string2) && (l2 = System.currentTimeMillis()) < (l = DateTimeView.this.mUpdateTimeMillis)) {
                    return;
                }
                DateTimeView.this.mLastFormat = null;
                DateTimeView.this.update();
            }
        };
        Handler handler = new Handler();
        this.mContentObserver = contentObserver = new ContentObserver(handler){

            @Override
            public void onChange(boolean bl) {
                DateTimeView.this.mLastFormat = null;
                DateTimeView.this.update();
            }
        };
    }

    public DateTimeView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        ContentObserver contentObserver;
        BroadcastReceiver broadcastReceiver;
        this.mBroadcastReceiver = broadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        Handler handler = new Handler();
        this.mContentObserver = contentObserver = new /* invalid duplicate definition of identical inner class */;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private java.text.DateFormat getDateFormat() {
        String string2 = Settings.System.getString(this.getContext().getContentResolver(), "date_format");
        if (string2 == null) return java.text.DateFormat.getDateInstance(3);
        if ("".equals(string2)) {
            return java.text.DateFormat.getDateInstance(3);
        }
        try {
            return new SimpleDateFormat(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return java.text.DateFormat.getDateInstance(3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private java.text.DateFormat getTimeFormat() {
        Context context = this.getContext();
        int n = DateFormat.is24HourFormat(context) ? 17039473 : 17039472;
        String string2 = context.getString(n);
        return new SimpleDateFormat(string2);
    }

    private void registerReceivers() {
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.TIME_TICK");
        intentFilter.addAction("android.intent.action.TIME_SET");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
        BroadcastReceiver broadcastReceiver = this.mBroadcastReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver, intentFilter);
        Uri uri = Settings.System.getUriFor("date_format");
        ContentResolver contentResolver = context.getContentResolver();
        ContentObserver contentObserver = this.mContentObserver;
        contentResolver.registerContentObserver(uri, true, contentObserver);
    }

    private void unregisterReceivers() {
        Context context = this.getContext();
        BroadcastReceiver broadcastReceiver = this.mBroadcastReceiver;
        context.unregisterReceiver(broadcastReceiver);
        ContentResolver contentResolver = context.getContentResolver();
        ContentObserver contentObserver = this.mContentObserver;
        contentResolver.unregisterContentObserver(contentObserver);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onDetachedFromWindow();
        this.registerReceivers();
        this.mAttachedToWindow = true;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unregisterReceivers();
        this.mAttachedToWindow = false;
    }

    @RemotableViewMethod
    public void setTime(long l) {
        Date date;
        long l2;
        Time time = new Time();
        time.set(l);
        time.second = 0;
        this.mTimeMillis = l2 = time.toMillis(false);
        int n = time.year - 1900;
        int n2 = time.month;
        int n3 = time.monthDay;
        int n4 = time.hour;
        int n5 = time.minute;
        this.mTime = date = new Date(n, n2, n3, n4, n5, 0);
        this.update();
    }

    /*
     * Enabled aggressive block sorting
     */
    void update() {
        java.text.DateFormat dateFormat;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.mTime == null) {
            return;
        }
        long l = System.nanoTime();
        Date date = this.mTime;
        Time time = new Time();
        long l2 = this.mTimeMillis;
        Time time2 = time;
        long l3 = l2;
        time2.set(l3);
        time.second = n7 = 0;
        time.hour = n6 = time.hour - 12;
        Time time3 = time;
        boolean bl = false;
        long l4 = time3.toMillis(bl);
        time.hour = n5 = time.hour + 12;
        Time time4 = time;
        boolean bl2 = false;
        long l5 = time4.toMillis(bl2);
        time.hour = n4 = 0;
        time.minute = n3 = 0;
        Time time5 = time;
        boolean bl3 = false;
        long l6 = time5.toMillis(bl3);
        time.monthDay = n2 = time.monthDay + 1;
        Time time6 = time;
        boolean bl4 = false;
        long l7 = time6.toMillis(bl4);
        long l8 = System.currentTimeMillis();
        time.set(l8);
        time.second = n = 0;
        Time time7 = time;
        boolean bl5 = false;
        long l9 = time7.normalize(bl5);
        int n8 = l9 >= l6 && l9 < l7 || l9 >= l4 && l9 < l5 ? 0 : 1;
        int n9 = n8;
        int n10 = this.mLastDisplay;
        int n11 = n10;
        if (n9 != n11 && this.mLastFormat != null) {
            dateFormat = this.mLastFormat;
        } else {
            java.text.DateFormat dateFormat2;
            switch (n8) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("unknown display value: ");
                    int n12 = n8;
                    String string2 = stringBuilder.append(n12).toString();
                    throw new RuntimeException(string2);
                }
                case 0: {
                    dateFormat = this.getTimeFormat();
                    break;
                }
                case 1: {
                    dateFormat = this.getDateFormat();
                }
            }
            this.mLastFormat = dateFormat2 = dateFormat;
        }
        Date date2 = this.mTime;
        java.text.DateFormat dateFormat3 = dateFormat;
        Date date3 = date2;
        String string3 = dateFormat3.format(date3);
        DateTimeView dateTimeView = this;
        String string4 = string3;
        dateTimeView.setText(string4);
        if (n8 == 0) {
            long l10;
            long l11 = l5 > l7 ? l5 : l7;
            this.mUpdateTimeMillis = l10 = l11;
        } else if (this.mTimeMillis < l9) {
            long l12;
            this.mUpdateTimeMillis = l12 = 0L;
        } else {
            long l13;
            long l14 = l4 < l6 ? l4 : l6;
            this.mUpdateTimeMillis = l13 = l14;
        }
        long l15 = System.nanoTime();
    }
}

