/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DialerKeyListener;
import android.text.method.KeyListener;
import android.text.method.TextKeyListener;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;

public class DialerFilter
extends RelativeLayout {
    public static final int DIGITS_AND_LETTERS = 1;
    public static final int DIGITS_AND_LETTERS_NO_DIGITS = 2;
    public static final int DIGITS_AND_LETTERS_NO_LETTERS = 3;
    public static final int DIGITS_ONLY = 4;
    public static final int LETTERS_ONLY = 5;
    EditText mDigits;
    EditText mHint;
    ImageView mIcon;
    InputFilter[] mInputFilters;
    private boolean mIsQwerty;
    EditText mLetters;
    int mMode;
    EditText mPrimary;

    public DialerFilter(Context context) {
        super(context);
    }

    public DialerFilter(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private void makeDigitsPrimary() {
        EditText editText = this.mPrimary;
        EditText editText2 = this.mLetters;
        if (editText != editText2) {
            return;
        }
        this.swapPrimaryAndHint(false);
    }

    private void makeLettersPrimary() {
        EditText editText = this.mPrimary;
        EditText editText2 = this.mDigits;
        if (editText != editText2) {
            return;
        }
        this.swapPrimaryAndHint(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void swapPrimaryAndHint(boolean bl) {
        Editable editable = this.mLetters.getText();
        Editable editable2 = this.mDigits.getText();
        KeyListener keyListener = this.mLetters.getKeyListener();
        KeyListener keyListener2 = this.mDigits.getKeyListener();
        if (bl) {
            EditText editText;
            EditText editText2;
            this.mLetters = editText2 = this.mPrimary;
            this.mDigits = editText = this.mHint;
        } else {
            EditText editText;
            EditText editText3;
            this.mLetters = editText3 = this.mHint;
            this.mDigits = editText = this.mPrimary;
        }
        this.mLetters.setKeyListener(keyListener);
        this.mLetters.setText(editable);
        Editable editable3 = this.mLetters.getText();
        int n = editable3.length();
        Selection.setSelection(editable3, n);
        this.mDigits.setKeyListener(keyListener2);
        this.mDigits.setText(editable2);
        Editable editable4 = this.mDigits.getText();
        int n2 = editable4.length();
        Selection.setSelection(editable4, n2);
        EditText editText = this.mPrimary;
        InputFilter[] inputFilterArray = this.mInputFilters;
        editText.setFilters(inputFilterArray);
        EditText editText4 = this.mHint;
        InputFilter[] inputFilterArray2 = this.mInputFilters;
        editText4.setFilters(inputFilterArray2);
    }

    public void append(String string2) {
        switch (this.mMode) {
            default: {
                return;
            }
            case 1: {
                Editable editable = this.mDigits.getText().append(string2);
                Editable editable2 = this.mLetters.getText().append(string2);
                return;
            }
            case 3: 
            case 4: {
                Editable editable = this.mDigits.getText().append(string2);
                return;
            }
            case 2: 
            case 5: 
        }
        Editable editable = this.mLetters.getText().append(string2);
    }

    public void clearText() {
        this.mLetters.getText().clear();
        this.mDigits.getText().clear();
        if (this.mIsQwerty) {
            this.setMode(1);
            return;
        }
        this.setMode(4);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getDigits() {
        void var1_2;
        if (this.mDigits.getVisibility() != 0) return var1_2;
        Editable editable = this.mDigits.getText();
        return var1_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getFilterText() {
        if (this.mMode == 4) return this.getDigits();
        return this.getLetters();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getLetters() {
        void var1_2;
        if (this.mLetters.getVisibility() != 0) return var1_2;
        Editable editable = this.mLetters.getText();
        return var1_2;
    }

    public int getMode() {
        return this.mMode;
    }

    public boolean isQwertyKeyboard() {
        return this.mIsQwerty;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFinishInflate() {
        ImageView imageView;
        EditText editText;
        EditText editText2;
        EditText editText3;
        EditText editText4;
        super.onFinishInflate();
        InputFilter[] inputFilterArray = new InputFilter[1];
        InputFilter.AllCaps allCaps = new InputFilter.AllCaps();
        inputFilterArray[0] = allCaps;
        this.mInputFilters = inputFilterArray;
        this.mHint = editText4 = (EditText)this.findViewById(16908293);
        if (this.mHint == null) {
            throw new IllegalStateException("DialerFilter must have a child EditText named hint");
        }
        EditText editText5 = this.mHint;
        InputFilter[] inputFilterArray2 = this.mInputFilters;
        editText5.setFilters(inputFilterArray2);
        EditText editText6 = this.mLetters = (editText3 = this.mHint);
        TextKeyListener textKeyListener = TextKeyListener.getInstance();
        editText6.setKeyListener(textKeyListener);
        this.mLetters.setMovementMethod(null);
        this.mLetters.setFocusable(false);
        this.mPrimary = editText2 = (EditText)this.findViewById(16908300);
        if (this.mPrimary == null) {
            throw new IllegalStateException("DialerFilter must have a child EditText named primary");
        }
        EditText editText7 = this.mPrimary;
        InputFilter[] inputFilterArray3 = this.mInputFilters;
        editText7.setFilters(inputFilterArray3);
        EditText editText8 = this.mDigits = (editText = this.mPrimary);
        DialerKeyListener dialerKeyListener = DialerKeyListener.getInstance();
        editText8.setKeyListener(dialerKeyListener);
        this.mDigits.setMovementMethod(null);
        this.mDigits.setFocusable(false);
        this.mIcon = imageView = (ImageView)this.findViewById(16908294);
        this.setFocusable(true);
        boolean bl = KeyCharacterMap.load(0).getKeyboardType() != 1;
        this.mIsQwerty = bl;
        if (this.mIsQwerty) {
            int n = Log.i("DialerFilter", "This device looks to be QWERTY");
        } else {
            int n = Log.i("DialerFilter", "This device looks to be 12-KEY");
        }
        this.mIsQwerty = true;
        this.setMode(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (this.mIcon == null) {
            return;
        }
        ImageView imageView = this.mIcon;
        int n2 = bl ? 0 : 8;
        imageView.setVisibility(n2);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean onKeyDown(int var1_1, KeyEvent var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        boolean bl = this.mLetters.onKeyUp(n, keyEvent);
        boolean bl2 = this.mDigits.onKeyUp(n, keyEvent);
        if (bl) return true;
        if (!bl2) return false;
        return true;
    }

    protected void onModeChange(int n, int n2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFilterWatcher(TextWatcher textWatcher) {
        Editable editable = this.mMode != 4 ? this.mLetters.getText() : this.mDigits.getText();
        editable.removeSpan(textWatcher);
    }

    public void setDigitsWatcher(TextWatcher textWatcher) {
        Editable editable = this.mDigits.getText();
        Spannable spannable = editable;
        int n = editable.length();
        spannable.setSpan(textWatcher, 0, n, 18);
    }

    public void setFilterWatcher(TextWatcher textWatcher) {
        if (this.mMode != 4) {
            this.setLettersWatcher(textWatcher);
            return;
        }
        this.setDigitsWatcher(textWatcher);
    }

    public void setLettersWatcher(TextWatcher textWatcher) {
        Editable editable = this.mLetters.getText();
        Spannable spannable = editable;
        int n = editable.length();
        spannable.setSpan(textWatcher, 0, n, 18);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMode(int n) {
        switch (n) {
            case 1: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(0);
                break;
            }
            case 4: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(8);
                this.mDigits.setVisibility(0);
                break;
            }
            case 5: {
                this.makeLettersPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(8);
                break;
            }
            case 3: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(4);
                this.mDigits.setVisibility(0);
                break;
            }
            case 2: {
                this.makeLettersPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(4);
                break;
            }
        }
        int n2 = this.mMode;
        this.mMode = n;
        this.onModeChange(n2, n);
    }
}

