/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.widget.TextView;
import java.util.Calendar;

public class DigitalClock
extends TextView {
    private static final String m12 = "h:mm:ss aa";
    private static final String m24 = "k:mm:ss";
    Calendar mCalendar;
    String mFormat;
    private FormatChangeObserver mFormatChangeObserver;
    private Handler mHandler;
    private Runnable mTicker;
    private boolean mTickerStopped = false;

    public DigitalClock(Context context) {
        super(context);
        this.initClock(context);
    }

    public DigitalClock(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initClock(context);
    }

    private boolean get24HourMode() {
        return DateFormat.is24HourFormat(this.getContext());
    }

    private void initClock(Context context) {
        FormatChangeObserver formatChangeObserver;
        Resources resources = this.mContext.getResources();
        if (this.mCalendar == null) {
            Calendar calendar;
            this.mCalendar = calendar = Calendar.getInstance();
        }
        this.mFormatChangeObserver = formatChangeObserver = new FormatChangeObserver();
        ContentResolver contentResolver = this.getContext().getContentResolver();
        Uri uri = Settings.System.CONTENT_URI;
        FormatChangeObserver formatChangeObserver2 = this.mFormatChangeObserver;
        contentResolver.registerContentObserver(uri, true, formatChangeObserver2);
        this.setFormat();
    }

    private void setFormat() {
        if (this.get24HourMode()) {
            this.mFormat = m24;
            return;
        }
        this.mFormat = m12;
    }

    @Override
    protected void onAttachedToWindow() {
        Runnable runnable;
        Handler handler;
        this.mTickerStopped = false;
        super.onAttachedToWindow();
        this.mHandler = handler = new Handler();
        this.mTicker = runnable = new Runnable(){

            @Override
            public void run() {
                if (DigitalClock.this.mTickerStopped) {
                    return;
                }
                Calendar calendar = DigitalClock.this.mCalendar;
                long l = System.currentTimeMillis();
                calendar.setTimeInMillis(l);
                DigitalClock digitalClock = DigitalClock.this;
                String string2 = DigitalClock.this.mFormat;
                Calendar calendar2 = DigitalClock.this.mCalendar;
                CharSequence charSequence = DateFormat.format((CharSequence)string2, calendar2);
                digitalClock.setText(charSequence);
                DigitalClock.this.invalidate();
                long l2 = SystemClock.uptimeMillis();
                long l3 = l2 % 1000L;
                long l4 = 1000L - l3;
                long l5 = l2 + l4;
                Handler handler = DigitalClock.this.mHandler;
                Runnable runnable = DigitalClock.this.mTicker;
                boolean bl = handler.postAtTime(runnable, l5);
            }
        };
        this.mTicker.run();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mTickerStopped = true;
    }

    private class FormatChangeObserver
    extends ContentObserver {
        public FormatChangeObserver() {
            Handler handler = new Handler();
            super(handler);
        }

        @Override
        public void onChange(boolean bl) {
            DigitalClock.this.setFormat();
        }
    }
}

