/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class EdgeGlow {
    private static final float EPSILON = 0.001f;
    private static final float HELD_EDGE_ALPHA = 0.7f;
    private static final float HELD_EDGE_SCALE_Y = 0.5f;
    private static final float HELD_GLOW_ALPHA = 0.5f;
    private static final float HELD_GLOW_SCALE_Y = 0.5f;
    private static final float MAX_ALPHA = 0.8f;
    private static final float MAX_GLOW_HEIGHT = 3.0f;
    private static final int MIN_VELOCITY = 100;
    private static final int PULL_DECAY_TIME = 1000;
    private static final float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 0.8f;
    private static final int PULL_DISTANCE_EDGE_FACTOR = 5;
    private static final int PULL_DISTANCE_GLOW_FACTOR = 5;
    private static final float PULL_EDGE_BEGIN = 0.6f;
    private static final float PULL_GLOW_BEGIN = 1.0f;
    private static final int PULL_TIME = 167;
    private static final int RECEDE_TIME = 1000;
    private static final int STATE_ABSORB = 2;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULL = 1;
    private static final int STATE_PULL_DECAY = 4;
    private static final int STATE_RECEDE = 3;
    private static final String TAG = "EdgeGlow";
    private static final int VELOCITY_EDGE_FACTOR = 8;
    private static final int VELOCITY_GLOW_FACTOR = 16;
    private float mDuration;
    private final Drawable mEdge;
    private float mEdgeAlpha;
    private float mEdgeAlphaFinish;
    private float mEdgeAlphaStart;
    private float mEdgeScaleY;
    private float mEdgeScaleYFinish;
    private float mEdgeScaleYStart;
    private final Drawable mGlow;
    private float mGlowAlpha;
    private float mGlowAlphaFinish;
    private float mGlowAlphaStart;
    private float mGlowScaleY;
    private float mGlowScaleYFinish;
    private float mGlowScaleYStart;
    private int mHeight;
    private final Interpolator mInterpolator;
    private float mPullDistance;
    private long mStartTime;
    private int mState = 0;
    private int mWidth;

    public EdgeGlow(Drawable drawable2, Drawable drawable3) {
        this.mEdge = drawable2;
        this.mGlow = drawable3;
        DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
        this.mInterpolator = decelerateInterpolator;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void update() {
        float f;
        float f2;
        float f3;
        float f4;
        long l = AnimationUtils.currentAnimationTimeMillis();
        long l2 = this.mStartTime;
        float f5 = l - l2;
        float f6 = this.mDuration;
        float f7 = Math.min(f5 / f6, 1.0f);
        float f8 = this.mInterpolator.getInterpolation(f7);
        float f9 = this.mEdgeAlphaStart;
        float f10 = this.mEdgeAlphaFinish;
        float f11 = this.mEdgeAlphaStart;
        float f12 = (f10 - f11) * f8;
        this.mEdgeAlpha = f4 = f9 + f12;
        float f13 = this.mEdgeScaleYStart;
        float f14 = this.mEdgeScaleYFinish;
        float f15 = this.mEdgeScaleYStart;
        float f16 = (f14 - f15) * f8;
        this.mEdgeScaleY = f3 = f13 + f16;
        float f17 = this.mGlowAlphaStart;
        float f18 = this.mGlowAlphaFinish;
        float f19 = this.mGlowAlphaStart;
        float f20 = (f18 - f19) * f8;
        this.mGlowAlpha = f2 = f17 + f20;
        float f21 = this.mGlowScaleYStart;
        float f22 = this.mGlowScaleYFinish;
        float f23 = this.mGlowScaleYStart;
        float f24 = (f22 - f23) * f8;
        this.mGlowScaleY = f = f21 + f24;
        if (!(f7 >= 0.999f)) {
            return;
        }
        switch (this.mState) {
            default: {
                return;
            }
            case 2: {
                float f25;
                float f26;
                float f27;
                float f28;
                long l3;
                this.mState = 3;
                this.mStartTime = l3 = AnimationUtils.currentAnimationTimeMillis();
                this.mDuration = 1000.0f;
                this.mEdgeAlphaStart = f28 = this.mEdgeAlpha;
                this.mEdgeScaleYStart = f27 = this.mEdgeScaleY;
                this.mGlowAlphaStart = f26 = this.mGlowAlpha;
                this.mGlowScaleYStart = f25 = this.mGlowScaleY;
                this.mEdgeAlphaFinish = 0.0f;
                this.mEdgeScaleYFinish = 0.0f;
                this.mGlowAlphaFinish = 0.0f;
                this.mGlowScaleYFinish = 0.0f;
                return;
            }
            case 1: {
                float f29;
                float f30;
                float f31;
                float f32;
                long l4;
                this.mState = 4;
                this.mStartTime = l4 = AnimationUtils.currentAnimationTimeMillis();
                this.mDuration = 1000.0f;
                this.mEdgeAlphaStart = f32 = this.mEdgeAlpha;
                this.mEdgeScaleYStart = f31 = this.mEdgeScaleY;
                this.mGlowAlphaStart = f30 = this.mGlowAlpha;
                this.mGlowScaleYStart = f29 = this.mGlowScaleY;
                this.mEdgeAlphaFinish = 0.0f;
                this.mEdgeScaleYFinish = 0.0f;
                this.mGlowAlphaFinish = 0.0f;
                this.mGlowScaleYFinish = 0.0f;
                return;
            }
            case 4: {
                float f33;
                float f34;
                if (this.mGlowScaleYFinish != 0.0f) {
                    float f35 = this.mGlowScaleYFinish;
                    float f36 = this.mGlowScaleYFinish;
                    float f37 = f35 * f36;
                    f34 = 1.0f / f37;
                } else {
                    f34 = Float.MAX_VALUE;
                }
                float f38 = this.mEdgeScaleYStart;
                float f39 = this.mEdgeScaleYFinish;
                float f40 = this.mEdgeScaleYStart;
                float f41 = (f39 - f40) * f8 * f34;
                this.mEdgeScaleY = f33 = f38 + f41;
                return;
            }
            case 3: 
        }
        this.mState = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean draw(Canvas canvas) {
        this.update();
        int n = this.mEdge.getIntrinsicHeight();
        int n2 = this.mGlow.getIntrinsicHeight();
        float f = this.mHeight;
        float f2 = this.mWidth;
        float f3 = f / f2;
        Drawable drawable2 = this.mGlow;
        float f4 = Math.min(this.mGlowAlpha, 1.0f);
        int n3 = (int)(Math.max(0.0f, f4) * 255.0f);
        drawable2.setAlpha(n3);
        Drawable drawable3 = this.mGlow;
        int n4 = -this.mWidth;
        int n5 = this.mWidth * 2;
        float f5 = n2;
        float f6 = this.mGlowScaleY;
        float f7 = f5 * f6 * f3 * 0.6f;
        float f8 = (float)this.mHeight * 3.0f;
        int n6 = (int)Math.min(f7, f8);
        drawable3.setBounds(n4, 0, n5, n6);
        this.mGlow.draw(canvas);
        Drawable drawable4 = this.mEdge;
        float f9 = Math.min(this.mEdgeAlpha, 1.0f);
        int n7 = (int)(Math.max(0.0f, f9) * 255.0f);
        drawable4.setAlpha(n7);
        Drawable drawable5 = this.mEdge;
        int n8 = this.mWidth;
        float f10 = n;
        float f11 = this.mEdgeScaleY;
        int n9 = (int)(f10 * f11);
        drawable5.setBounds(0, 0, n8, n9);
        this.mEdge.draw(canvas);
        if (this.mState == 0) return false;
        return true;
    }

    public void finish() {
        this.mState = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFinished() {
        if (this.mState != 0) return false;
        return true;
    }

    public void onAbsorb(int n) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        long l;
        this.mState = 2;
        int n2 = Math.abs(n);
        int n3 = Math.max(100, n2);
        this.mStartTime = l = AnimationUtils.currentAnimationTimeMillis();
        float f6 = (float)n3 * 0.03f;
        this.mDuration = f5 = 0.1f + f6;
        this.mEdgeAlphaStart = 0.0f;
        this.mEdgeScaleYStart = 0.0f;
        this.mEdgeScaleY = 0.0f;
        this.mGlowAlphaStart = 0.5f;
        this.mGlowScaleYStart = 0.0f;
        int n4 = Math.min(n3 * 8, 1);
        this.mEdgeAlphaFinish = f4 = (float)Math.max(0, n4);
        float f7 = Math.min((float)(n3 * 8), 1.0f);
        this.mEdgeScaleYFinish = f3 = Math.max(0.5f, f7);
        float f8 = (float)(n3 / 100 * n3) * 1.5E-4f;
        this.mGlowScaleYFinish = f2 = Math.min(0.025f + f8, 1.75f);
        float f9 = this.mGlowAlphaStart;
        float f10 = Math.min((float)(n3 * 16) * 1.0E-5f, 0.8f);
        this.mGlowAlphaFinish = f = Math.max(f9, f10);
    }

    public void onPull(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        long l;
        float f12;
        long l2 = AnimationUtils.currentAnimationTimeMillis();
        if (this.mState == 4 && (f12 = (float)(l2 - (l = this.mStartTime))) < (f11 = this.mDuration)) {
            return;
        }
        if (this.mState != 1) {
            this.mGlowScaleY = 1.0f;
        }
        this.mState = 1;
        this.mStartTime = l2;
        this.mDuration = 167.0f;
        this.mPullDistance = f10 = this.mPullDistance + f;
        float f13 = Math.abs(this.mPullDistance);
        float f14 = Math.min(f13, 0.8f);
        this.mEdgeAlphaStart = f9 = Math.max(0.6f, f14);
        this.mEdgeAlpha = f9;
        float f15 = Math.min(f13 * 5.0f, 1.0f);
        this.mEdgeScaleYStart = f8 = Math.max(0.5f, f15);
        this.mEdgeScaleY = f8;
        float f16 = this.mGlowAlpha;
        float f17 = Math.abs(f) * 0.8f;
        float f18 = f16 + f17;
        this.mGlowAlphaStart = f7 = Math.min(0.8f, f18);
        this.mGlowAlpha = f7;
        float f19 = Math.abs(f);
        if (f > 0.0f && this.mPullDistance < 0.0f) {
            f19 = -f19;
        }
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleY = 0.0f;
        }
        float f20 = this.mGlowScaleY;
        float f21 = f19 * 5.0f;
        float f22 = f20 + f21;
        float f23 = Math.max(0.0f, f22);
        this.mGlowScaleYStart = f6 = Math.min(3.0f, f23);
        this.mGlowScaleY = f6;
        this.mEdgeAlphaFinish = f5 = this.mEdgeAlpha;
        this.mEdgeScaleYFinish = f4 = this.mEdgeScaleY;
        this.mGlowAlphaFinish = f3 = this.mGlowAlpha;
        this.mGlowScaleYFinish = f2 = this.mGlowScaleY;
    }

    public void onRelease() {
        long l;
        float f;
        float f2;
        float f3;
        float f4;
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mEdgeAlphaStart = f4 = this.mEdgeAlpha;
        this.mEdgeScaleYStart = f3 = this.mEdgeScaleY;
        this.mGlowAlphaStart = f2 = this.mGlowAlpha;
        this.mGlowScaleYStart = f = this.mGlowScaleY;
        this.mEdgeAlphaFinish = 0.0f;
        this.mEdgeScaleYFinish = 0.0f;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mStartTime = l = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 1000.0f;
    }

    public void setSize(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
    }
}

