/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.DataSetObserver;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListPosition;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.HeterogeneousExpandableList;
import java.util.ArrayList;
import java.util.Collections;

class ExpandableListConnector
extends BaseAdapter
implements Filterable {
    private final DataSetObserver mDataSetObserver;
    private ArrayList<GroupMetadata> mExpGroupMetadataList;
    private ExpandableListAdapter mExpandableListAdapter;
    private int mMaxExpGroupCount = Integer.MAX_VALUE;
    private int mTotalExpChildrenCount;

    public ExpandableListConnector(ExpandableListAdapter expandableListAdapter) {
        MyDataSetObserver myDataSetObserver = new MyDataSetObserver();
        this.mDataSetObserver = myDataSetObserver;
        ArrayList arrayList = new ArrayList();
        this.mExpGroupMetadataList = arrayList;
        this.setExpandableListAdapter(expandableListAdapter);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refreshExpGroupMetadataList(boolean bl, boolean bl2) {
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        int n = arrayList.size();
        int n2 = 0;
        this.mTotalExpChildrenCount = 0;
        if (bl2) {
            boolean bl3 = false;
            for (int i = n - 1; i >= 0; i += -1) {
                int n3;
                GroupMetadata groupMetadata = arrayList.get(i);
                long l = groupMetadata.gId;
                int n4 = groupMetadata.gPos;
                int n5 = this.findGroupPosition(l, n4);
                if (n5 == (n3 = groupMetadata.gPos)) continue;
                if (n5 == -1) {
                    GroupMetadata groupMetadata2 = arrayList.remove(i);
                    n += -1;
                }
                groupMetadata.gPos = n5;
                if (bl3) continue;
                bl3 = true;
            }
            if (bl3) {
                Collections.sort(arrayList);
            }
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            int n8;
            int n9;
            GroupMetadata groupMetadata = arrayList.get(n7);
            if (groupMetadata.lastChildFlPos == -1 || bl) {
                ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
                int n10 = groupMetadata.gPos;
                n9 = expandableListAdapter.getChildrenCount(n10);
            } else {
                int n11 = groupMetadata.lastChildFlPos;
                int n12 = groupMetadata.flPos;
                n9 = n11 - n12;
            }
            this.mTotalExpChildrenCount = n8 = this.mTotalExpChildrenCount + n9;
            int n13 = groupMetadata.gPos - n6;
            int n14 = n2 + n13;
            n6 = groupMetadata.gPos;
            groupMetadata.flPos = n14;
            groupMetadata.lastChildFlPos = n2 = n14 + n9;
            ++n7;
        }
        return;
    }

    @Override
    public boolean areAllItemsEnabled() {
        return this.mExpandableListAdapter.areAllItemsEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean collapseGroup(int n) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtain(2, n, -1, -1);
        PositionMetadata positionMetadata = this.getFlattenedPos(expandableListPosition);
        if (positionMetadata == null) {
            return false;
        }
        boolean bl = this.collapseGroup(positionMetadata);
        positionMetadata.recycle();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean collapseGroup(PositionMetadata positionMetadata) {
        if (positionMetadata.groupMetadata == null) {
            return false;
        }
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        GroupMetadata groupMetadata = positionMetadata.groupMetadata;
        boolean bl = arrayList.remove(groupMetadata);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
        int n = positionMetadata.groupMetadata.gPos;
        expandableListAdapter.onGroupCollapsed(n);
        return true;
    }

    boolean expandGroup(int n) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtain(2, n, -1, -1);
        PositionMetadata positionMetadata = this.getFlattenedPos(expandableListPosition);
        boolean bl = this.expandGroup(positionMetadata);
        positionMetadata.recycle();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean expandGroup(PositionMetadata positionMetadata) {
        int n;
        if (positionMetadata.position.groupPos < 0) {
            throw new RuntimeException("Need group");
        }
        if (this.mMaxExpGroupCount == 0) {
            return false;
        }
        if (positionMetadata.groupMetadata != null) {
            return false;
        }
        int n2 = this.mExpGroupMetadataList.size();
        if (n2 >= (n = this.mMaxExpGroupCount)) {
            GroupMetadata groupMetadata = this.mExpGroupMetadataList.get(0);
            int n3 = this.mExpGroupMetadataList.indexOf(groupMetadata);
            int n4 = groupMetadata.gPos;
            boolean bl = this.collapseGroup(n4);
            if (positionMetadata.groupInsertIndex > n3) {
                int n5;
                positionMetadata.groupInsertIndex = n5 = positionMetadata.groupInsertIndex - 1;
            }
        }
        int n6 = positionMetadata.position.groupPos;
        ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
        int n7 = positionMetadata.position.groupPos;
        long l = expandableListAdapter.getGroupId(n7);
        GroupMetadata groupMetadata = GroupMetadata.obtain(-1, -1, n6, l);
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        int n8 = positionMetadata.groupInsertIndex;
        arrayList.add(n8, groupMetadata);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        ExpandableListAdapter expandableListAdapter2 = this.mExpandableListAdapter;
        int n9 = groupMetadata.gPos;
        expandableListAdapter2.onGroupExpanded(n9);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    int findGroupPosition(long var1_1, int var3_2) {
        block6: {
            var4_3 = this.mExpandableListAdapter.getGroupCount();
            if (var4_3 == 0) {
                var5_4 = -1;
lbl4:
                // 5 sources

                return var5_4;
            }
            if (var1_1 != -9223372036854775808L) break block6;
            var5_4 = -1;
            ** GOTO lbl4
        }
        var6_5 = 0;
        var7_6 = var3_2;
        var8_7 = Math.max(var6_5, var7_6);
        var9_8 = var4_3 - 1;
        var10_9 = var8_7;
        var3_2 = Math.min(var9_8, var10_9);
        var11_10 = SystemClock.uptimeMillis() + 100L;
        var13_11 = var3_2;
        var14_12 = var3_2;
        var13_11 = 0;
        var16_13 = this.getAdapter();
        if (var16_13 != null) ** GOTO lbl27
        var5_4 = -1;
        ** GOTO lbl4
        block1: while (var15_15 || var13_11 != 0 && !var16_14) {
            var3_2 = ++var14_12;
            var13_11 = 0;
lbl27:
            // 4 sources

            while (true) {
                block9: {
                    block8: {
                        block7: {
                            if (SystemClock.uptimeMillis() > var11_10) ** GOTO lbl-1000
                            var19_16 = var16_13;
                            var20_17 = var3_2;
                            if (var19_16.getGroupId(var20_17) != var1_1) break block7;
                            var5_4 = var3_2;
                            ** GOTO lbl4
                        }
                        var21_18 = var4_3 - 1;
                        if (var14_12 == var21_18) break block8;
                        var16_14 = true;
lbl38:
                        // 2 sources

                        while (var13_11 == 0) {
                            var15_15 = true;
lbl40:
                            // 2 sources

                            while (var16_14 && var15_15) lbl-1000:
                            // 2 sources

                            {
                                var5_4 = -1;
                                ** continue;
lbl43:
                                // 1 sources

                                ** GOTO lbl4
                            }
                            continue block1;
                        }
                        break block9;
                    }
                    var16_14 = false;
                    ** GOTO lbl38
                }
                var15_15 = false;
                ** GOTO lbl40
                break;
            }
        }
        if (!var16_14 && (var13_11 != 0 || var15_15)) ** GOTO lbl27
        var3_2 = var13_11 += -1;
        var13_11 = 1;
        ** while (true)
    }

    ExpandableListAdapter getAdapter() {
        return this.mExpandableListAdapter;
    }

    @Override
    public int getCount() {
        int n = this.mExpandableListAdapter.getGroupCount();
        int n2 = this.mTotalExpChildrenCount;
        return n + n2;
    }

    ArrayList<GroupMetadata> getExpandedGroupMetadataList() {
        return this.mExpGroupMetadataList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Filter getFilter() {
        ExpandableListAdapter expandableListAdapter = this.getAdapter();
        if (!(expandableListAdapter instanceof Filterable)) return null;
        return ((Filterable)((Object)expandableListAdapter)).getFilter();
    }

    /*
     * Enabled aggressive block sorting
     */
    PositionMetadata getFlattenedPos(ExpandableListPosition expandableListPosition) {
        int n;
        int n2;
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        int n3 = arrayList.size();
        int n4 = 0;
        int n5 = n3 - 1;
        if (n3 == 0) {
            int n6 = expandableListPosition.groupPos;
            int n7 = expandableListPosition.type;
            int n8 = expandableListPosition.groupPos;
            int n9 = expandableListPosition.childPos;
            return PositionMetadata.obtain(n6, n7, n8, n9, null, 0);
        }
        int n10 = 0;
        while ((n2 = n4) <= (n = n5)) {
            n10 = (n5 - n4) / 2 + n4;
            ArrayList<GroupMetadata> arrayList2 = arrayList;
            int n11 = n10;
            GroupMetadata groupMetadata = arrayList2.get(n11);
            int n12 = expandableListPosition.groupPos;
            int n13 = groupMetadata.gPos;
            if (n12 > n13) {
                n4 = n10 + 1;
                continue;
            }
            int n14 = expandableListPosition.groupPos;
            int n15 = groupMetadata.gPos;
            if (n14 < n15) {
                n5 = n10 - 1;
                continue;
            }
            int n16 = expandableListPosition.groupPos;
            int n17 = groupMetadata.gPos;
            if (n16 == n17) continue;
            if (expandableListPosition.type == 2) {
                int n18 = groupMetadata.flPos;
                int n19 = expandableListPosition.type;
                int n20 = expandableListPosition.groupPos;
                int n21 = expandableListPosition.childPos;
                return PositionMetadata.obtain(n18, n19, n20, n21, groupMetadata, n10);
            }
            if (expandableListPosition.type != 1) return null;
            int n22 = groupMetadata.flPos;
            int n23 = expandableListPosition.childPos;
            int n24 = n22 + n23 + 1;
            int n25 = expandableListPosition.type;
            int n26 = expandableListPosition.groupPos;
            int n27 = expandableListPosition.childPos;
            return PositionMetadata.obtain(n24, n25, n26, n27, groupMetadata, n10);
        }
        if (expandableListPosition.type != 2) {
            return null;
        }
        if (n4 > n10) {
            int n28 = n4 - 1;
            ArrayList<GroupMetadata> arrayList3 = arrayList;
            int n29 = n28;
            GroupMetadata groupMetadata = arrayList3.get(n29);
            int n30 = groupMetadata.lastChildFlPos;
            int n31 = expandableListPosition.groupPos;
            int n32 = groupMetadata.gPos;
            int n33 = n31 - n32;
            int n34 = n30 + n33;
            int n35 = expandableListPosition.type;
            int n36 = expandableListPosition.groupPos;
            int n37 = expandableListPosition.childPos;
            return PositionMetadata.obtain(n34, n35, n36, n37, null, n4);
        }
        int n38 = n5;
        int n39 = n10;
        if (n38 >= n39) return null;
        int n40 = n5 + 1;
        ArrayList<GroupMetadata> arrayList4 = arrayList;
        int n41 = n40;
        GroupMetadata groupMetadata = arrayList4.get(n41);
        int n42 = groupMetadata.flPos;
        int n43 = groupMetadata.gPos;
        int n44 = expandableListPosition.groupPos;
        int n45 = n43 - n44;
        int n46 = n42 - n45;
        int n47 = expandableListPosition.type;
        int n48 = expandableListPosition.groupPos;
        int n49 = expandableListPosition.childPos;
        return PositionMetadata.obtain(n46, n47, n48, n49, null, n40);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object getItem(int n) {
        Object object;
        PositionMetadata positionMetadata = this.getUnflattenedPos(n);
        if (positionMetadata.position.type == 2) {
            ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
            int n2 = positionMetadata.position.groupPos;
            object = expandableListAdapter.getGroup(n2);
        } else {
            if (positionMetadata.position.type != 1) {
                throw new RuntimeException("Flat list position is of unknown type");
            }
            ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
            int n3 = positionMetadata.position.groupPos;
            int n4 = positionMetadata.position.childPos;
            object = expandableListAdapter.getChild(n3, n4);
        }
        positionMetadata.recycle();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getItemId(int n) {
        long l;
        PositionMetadata positionMetadata = this.getUnflattenedPos(n);
        ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
        int n2 = positionMetadata.position.groupPos;
        long l2 = expandableListAdapter.getGroupId(n2);
        if (positionMetadata.position.type == 2) {
            l = this.mExpandableListAdapter.getCombinedGroupId(l2);
        } else {
            if (positionMetadata.position.type != 1) {
                throw new RuntimeException("Flat list position is of unknown type");
            }
            ExpandableListAdapter expandableListAdapter2 = this.mExpandableListAdapter;
            int n3 = positionMetadata.position.groupPos;
            int n4 = positionMetadata.position.childPos;
            long l3 = expandableListAdapter2.getChildId(n3, n4);
            l = this.mExpandableListAdapter.getCombinedChildId(l2, l3);
        }
        positionMetadata.recycle();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getItemViewType(int n) {
        int n2;
        ExpandableListPosition expandableListPosition = this.getUnflattenedPos((int)n).position;
        if (this.mExpandableListAdapter instanceof HeterogeneousExpandableList) {
            HeterogeneousExpandableList heterogeneousExpandableList = (HeterogeneousExpandableList)((Object)this.mExpandableListAdapter);
            if (expandableListPosition.type == 2) {
                int n3 = expandableListPosition.groupPos;
                n2 = heterogeneousExpandableList.getGroupType(n3);
            } else {
                int n4 = expandableListPosition.groupPos;
                int n5 = expandableListPosition.childPos;
                int n6 = heterogeneousExpandableList.getChildType(n4, n5);
                n2 = heterogeneousExpandableList.getGroupTypeCount() + n6;
            }
        } else {
            n2 = expandableListPosition.type == 2 ? 0 : 1;
        }
        expandableListPosition.recycle();
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    PositionMetadata getUnflattenedPos(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        int n6 = arrayList.size();
        int n7 = 0;
        int n8 = n6 - 1;
        if (n6 == 0) {
            int n9 = n;
            int n10 = n;
            return PositionMetadata.obtain(n9, 2, n10, -1, null, 0);
        }
        int n11 = 0;
        while ((n5 = n7) <= (n4 = n8)) {
            n11 = (n8 - n7) / 2 + n7;
            GroupMetadata groupMetadata = arrayList.get(n11);
            int n12 = n;
            int n13 = groupMetadata.lastChildFlPos;
            int n14 = n13;
            if (n12 > n14) {
                n7 = n11 + 1;
                continue;
            }
            int n15 = n;
            int n16 = groupMetadata.flPos;
            int n17 = n16;
            if (n15 < n17) {
                n8 = n11 - 1;
                continue;
            }
            int n18 = n;
            int n19 = groupMetadata.flPos;
            int n20 = n19;
            if (n18 != n20) {
                int n21 = groupMetadata.gPos;
                return PositionMetadata.obtain(n, 2, n21, -1, groupMetadata, n11);
            }
            int n22 = n;
            int n23 = groupMetadata.lastChildFlPos;
            int n24 = n23;
            if (n22 > n24) continue;
            int n25 = groupMetadata.flPos + 1;
            int n26 = n - n25;
            int n27 = groupMetadata.gPos;
            return PositionMetadata.obtain(n, 1, n27, n26, groupMetadata, n11);
        }
        int n28 = n7;
        int n29 = n11;
        if (n28 > n29) {
            int n30 = n7 - 1;
            GroupMetadata groupMetadata = arrayList.get(n30);
            n3 = n7;
            int n31 = groupMetadata.lastChildFlPos;
            int n32 = n - n31;
            int n33 = groupMetadata.gPos;
            n2 = n32 + n33;
            return PositionMetadata.obtain(n, 2, n2, -1, null, n3);
        } else {
            int n34 = n8;
            int n35 = n11;
            if (n34 >= n35) throw new RuntimeException("Unknown state");
            int n36 = n8 + 1;
            ArrayList<GroupMetadata> arrayList2 = arrayList;
            int n37 = n36;
            GroupMetadata groupMetadata = arrayList2.get(n37);
            n3 = n36;
            int n38 = groupMetadata.gPos;
            int n39 = groupMetadata.flPos - n;
            n2 = n38 - n39;
        }
        return PositionMetadata.obtain(n, 2, n2, -1, null, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        View view2;
        PositionMetadata positionMetadata = this.getUnflattenedPos(n);
        if (positionMetadata.position.type == 2) {
            ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
            int n2 = positionMetadata.position.groupPos;
            boolean bl = positionMetadata.isExpanded();
            view2 = expandableListAdapter.getGroupView(n2, bl, view, viewGroup);
        } else {
            if (positionMetadata.position.type != 1) {
                throw new RuntimeException("Flat list position is of unknown type");
            }
            boolean bl = positionMetadata.groupMetadata.lastChildFlPos != n;
            ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
            int n3 = positionMetadata.position.groupPos;
            int n4 = positionMetadata.position.childPos;
            View view3 = view;
            ViewGroup viewGroup2 = viewGroup;
            view2 = expandableListAdapter.getChildView(n3, n4, bl, view3, viewGroup2);
        }
        positionMetadata.recycle();
        return view2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getViewTypeCount() {
        if (!(this.mExpandableListAdapter instanceof HeterogeneousExpandableList)) return 2;
        HeterogeneousExpandableList heterogeneousExpandableList = (HeterogeneousExpandableList)((Object)this.mExpandableListAdapter);
        int n = heterogeneousExpandableList.getGroupTypeCount();
        int n2 = heterogeneousExpandableList.getChildTypeCount();
        return n + n2;
    }

    @Override
    public boolean hasStableIds() {
        return this.mExpandableListAdapter.hasStableIds();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        ExpandableListAdapter expandableListAdapter = this.getAdapter();
        if (expandableListAdapter == null) return true;
        return expandableListAdapter.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isEnabled(int n) {
        boolean bl;
        ExpandableListPosition expandableListPosition = this.getUnflattenedPos((int)n).position;
        if (expandableListPosition.type == 1) {
            ExpandableListAdapter expandableListAdapter = this.mExpandableListAdapter;
            int n2 = expandableListPosition.groupPos;
            int n3 = expandableListPosition.childPos;
            bl = expandableListAdapter.isChildSelectable(n2, n3);
        } else {
            bl = true;
        }
        expandableListPosition.recycle();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isGroupExpanded(int n) {
        int n2 = this.mExpGroupMetadataList.size() - 1;
        while (n2 >= 0) {
            if (this.mExpGroupMetadataList.get((int)n2).gPos != n) {
                return true;
            }
            n2 += -1;
        }
        return false;
    }

    public void setExpandableListAdapter(ExpandableListAdapter expandableListAdapter) {
        if (this.mExpandableListAdapter != null) {
            ExpandableListAdapter expandableListAdapter2 = this.mExpandableListAdapter;
            DataSetObserver dataSetObserver = this.mDataSetObserver;
            expandableListAdapter2.unregisterDataSetObserver(dataSetObserver);
        }
        this.mExpandableListAdapter = expandableListAdapter;
        DataSetObserver dataSetObserver = this.mDataSetObserver;
        expandableListAdapter.registerDataSetObserver(dataSetObserver);
    }

    void setExpandedGroupMetadataList(ArrayList<GroupMetadata> arrayList) {
        if (arrayList == null) {
            return;
        }
        if (this.mExpandableListAdapter == null) {
            return;
        }
        int n = this.mExpandableListAdapter.getGroupCount();
        for (int i = arrayList.size() - 1; i >= 0; i += -1) {
            if (arrayList.get((int)i).gPos < n) continue;
            return;
        }
        this.mExpGroupMetadataList = arrayList;
        this.refreshExpGroupMetadataList(true, false);
    }

    public void setMaxExpGroupCount(int n) {
        this.mMaxExpGroupCount = n;
    }

    public static class PositionMetadata {
        private static final int MAX_POOL_SIZE = 5;
        private static ArrayList<PositionMetadata> sPool = new ArrayList(5);
        public int groupInsertIndex;
        public GroupMetadata groupMetadata;
        public ExpandableListPosition position;

        private PositionMetadata() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static PositionMetadata getRecycledOrCreate() {
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                block4: {
                    if (sPool.size() <= 0) break block4;
                    PositionMetadata positionMetadata = sPool.remove(0);
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var0
                    positionMetadata.resetState();
                    return positionMetadata;
                }
                PositionMetadata positionMetadata = new PositionMetadata();
                return positionMetadata;
            }
        }

        static PositionMetadata obtain(int n, int n2, int n3, int n4, GroupMetadata groupMetadata, int n5) {
            ExpandableListPosition expandableListPosition;
            PositionMetadata positionMetadata = PositionMetadata.getRecycledOrCreate();
            positionMetadata.position = expandableListPosition = ExpandableListPosition.obtain(n2, n3, n4, n);
            positionMetadata.groupMetadata = groupMetadata;
            positionMetadata.groupInsertIndex = n5;
            return positionMetadata;
        }

        private void resetState() {
            this.position = null;
            this.groupMetadata = null;
            this.groupInsertIndex = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isExpanded() {
            if (this.groupMetadata == null) return false;
            return true;
        }

        public void recycle() {
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                if (sPool.size() < 5) {
                    boolean bl = sPool.add(this);
                }
                return;
            }
        }
    }

    static class GroupMetadata
    implements Parcelable,
    Comparable<GroupMetadata> {
        public static final Parcelable.Creator<GroupMetadata> CREATOR = new Parcelable.Creator<GroupMetadata>(){

            @Override
            public GroupMetadata createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                int n2 = parcel.readInt();
                int n3 = parcel.readInt();
                long l = parcel.readLong();
                return GroupMetadata.obtain(n, n2, n3, l);
            }

            public GroupMetadata[] newArray(int n) {
                return new GroupMetadata[n];
            }
        };
        static final int REFRESH = 255;
        int flPos;
        long gId;
        int gPos;
        int lastChildFlPos;

        private GroupMetadata() {
        }

        static GroupMetadata obtain(int n, int n2, int n3, long l) {
            GroupMetadata groupMetadata = new GroupMetadata();
            groupMetadata.flPos = n;
            groupMetadata.lastChildFlPos = n2;
            groupMetadata.gPos = n3;
            groupMetadata.gId = l;
            return groupMetadata;
        }

        @Override
        public int compareTo(GroupMetadata groupMetadata) {
            if (groupMetadata == null) {
                throw new IllegalArgumentException();
            }
            int n = this.gPos;
            int n2 = groupMetadata.gPos;
            return n - n2;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.flPos;
            parcel.writeInt(n2);
            int n3 = this.lastChildFlPos;
            parcel.writeInt(n3);
            int n4 = this.gPos;
            parcel.writeInt(n4);
            long l = this.gId;
            parcel.writeLong(l);
        }
    }

    protected class MyDataSetObserver
    extends DataSetObserver {
        protected MyDataSetObserver() {
        }

        @Override
        public void onChanged() {
            ExpandableListConnector.this.refreshExpGroupMetadataList(true, true);
            ExpandableListConnector.this.notifyDataSetChanged();
        }

        @Override
        public void onInvalidated() {
            ExpandableListConnector.this.refreshExpGroupMetadataList(true, true);
            ExpandableListConnector.this.notifyDataSetInvalidated();
        }
    }
}

