/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListPosition;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.R;
import java.util.ArrayList;

public class ExpandableListView
extends ListView {
    public static final int CHILD_INDICATOR_INHERIT = 255;
    private static final int[] CHILD_LAST_STATE_SET;
    private static final int[] EMPTY_STATE_SET;
    private static final int[] GROUP_EMPTY_STATE_SET;
    private static final int[] GROUP_EXPANDED_EMPTY_STATE_SET;
    private static final int[] GROUP_EXPANDED_STATE_SET;
    private static final int[][] GROUP_STATE_SETS;
    private static final long PACKED_POSITION_INT_MASK_CHILD = 255L;
    private static final long PACKED_POSITION_INT_MASK_GROUP = Integer.MAX_VALUE;
    private static final long PACKED_POSITION_MASK_CHILD = 0xFFFFFFFFL;
    private static final long PACKED_POSITION_MASK_GROUP = 0x7FFFFFFF00000000L;
    private static final long PACKED_POSITION_MASK_TYPE = Long.MIN_VALUE;
    private static final long PACKED_POSITION_SHIFT_GROUP = 32L;
    private static final long PACKED_POSITION_SHIFT_TYPE = 63L;
    public static final int PACKED_POSITION_TYPE_CHILD = 1;
    public static final int PACKED_POSITION_TYPE_GROUP = 0;
    public static final int PACKED_POSITION_TYPE_NULL = 2;
    public static final long PACKED_POSITION_VALUE_NULL = 0xFFFFFFFFL;
    private ExpandableListAdapter mAdapter;
    private Drawable mChildDivider;
    private Drawable mChildIndicator;
    private int mChildIndicatorLeft;
    private int mChildIndicatorRight;
    private boolean mClipChildDivider;
    private ExpandableListConnector mConnector;
    private Drawable mGroupIndicator;
    private int mIndicatorLeft;
    private final Rect mIndicatorRect;
    private int mIndicatorRight;
    private OnChildClickListener mOnChildClickListener;
    private OnGroupClickListener mOnGroupClickListener;
    private OnGroupCollapseListener mOnGroupCollapseListener;
    private OnGroupExpandListener mOnGroupExpandListener;

    static {
        EMPTY_STATE_SET = new int[0];
        int[] nArray = new int[]{16842920};
        GROUP_EXPANDED_STATE_SET = nArray;
        int[] nArray2 = new int[]{16842921};
        GROUP_EMPTY_STATE_SET = nArray2;
        GROUP_EXPANDED_EMPTY_STATE_SET = new int[]{16842920, 16842921};
        int[] nArray3 = new int[4];
        int[] nArray4 = EMPTY_STATE_SET;
        nArray3[0] = (int)nArray4;
        int[] nArray5 = GROUP_EXPANDED_STATE_SET;
        nArray3[1] = (int)nArray5;
        int[] nArray6 = GROUP_EMPTY_STATE_SET;
        nArray3[2] = (int)nArray6;
        int[] nArray7 = GROUP_EXPANDED_EMPTY_STATE_SET;
        nArray3[3] = (int)nArray7;
        GROUP_STATE_SETS = (int[][])nArray3;
        int[] nArray8 = new int[]{16842918};
        CHILD_LAST_STATE_SET = nArray8;
    }

    public ExpandableListView(Context context) {
        this(context, null);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842863);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Drawable drawable2;
        int n2;
        int n3;
        int n4;
        int n5;
        Drawable drawable3;
        Drawable drawable4;
        Rect rect;
        this.mIndicatorRect = rect = new Rect();
        int[] nArray = R.styleable.ExpandableListView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mGroupIndicator = drawable4 = typedArray.getDrawable(0);
        this.mChildIndicator = drawable3 = typedArray.getDrawable(1);
        this.mIndicatorLeft = n5 = typedArray.getDimensionPixelSize(2, 0);
        this.mIndicatorRight = n4 = typedArray.getDimensionPixelSize(3, 0);
        this.mChildIndicatorLeft = n3 = typedArray.getDimensionPixelSize(4, -1);
        this.mChildIndicatorRight = n2 = typedArray.getDimensionPixelSize(5, -1);
        this.mChildDivider = drawable2 = typedArray.getDrawable(6);
        typedArray.recycle();
    }

    private int getAbsoluteFlatPosition(int n) {
        return this.getHeaderViewsCount() + n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getChildOrGroupId(ExpandableListPosition expandableListPosition) {
        if (expandableListPosition.type == 1) {
            ExpandableListAdapter expandableListAdapter = this.mAdapter;
            int n = expandableListPosition.groupPos;
            int n2 = expandableListPosition.childPos;
            return expandableListAdapter.getChildId(n, n2);
        }
        ExpandableListAdapter expandableListAdapter = this.mAdapter;
        int n = expandableListPosition.groupPos;
        return expandableListAdapter.getGroupId(n);
    }

    private int getFlatPositionForConnector(int n) {
        int n2 = this.getHeaderViewsCount();
        return n - n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getIndicator(ExpandableListConnector.PositionMetadata positionMetadata) {
        Drawable drawable2;
        if (positionMetadata.position.type == 2) {
            int n;
            int n2;
            drawable2 = this.mGroupIndicator;
            if (drawable2 == null) return drawable2;
            if (!drawable2.isStateful()) return drawable2;
            boolean bl = positionMetadata.groupMetadata == null || (n2 = positionMetadata.groupMetadata.lastChildFlPos) != (n = positionMetadata.groupMetadata.flPos);
            int n3 = positionMetadata.isExpanded() ? 1 : 0;
            int n4 = bl ? 2 : 0;
            int n5 = n3 | n4;
            int[] nArray = GROUP_STATE_SETS[n5];
            boolean bl2 = drawable2.setState(nArray);
            return drawable2;
        }
        drawable2 = this.mChildIndicator;
        if (drawable2 == null) return drawable2;
        if (!drawable2.isStateful()) return drawable2;
        int n = positionMetadata.position.flatListPos;
        int n6 = positionMetadata.groupMetadata.lastChildFlPos;
        int[] nArray = n != n6 ? CHILD_LAST_STATE_SET : EMPTY_STATE_SET;
        boolean bl = drawable2.setState(nArray);
        return drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPackedPositionChild(long l) {
        if (l == 0xFFFFFFFFL) {
            return -1;
        }
        if ((l & Long.MIN_VALUE) == Long.MIN_VALUE) return (int)(l & 0xFFFFFFFFL);
        return -1;
    }

    public static long getPackedPositionForChild(int n, int n2) {
        long l = ((long)n & Integer.MAX_VALUE) << 32;
        long l2 = Long.MIN_VALUE | l;
        long l3 = (long)n2 & 0xFFFFL;
        return l2 | l3;
    }

    public static long getPackedPositionForGroup(int n) {
        return ((long)n & Integer.MAX_VALUE) << 32;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPackedPositionGroup(long l) {
        if (l != 0xFFFFFFFFL) return (int)((0x7FFFFFFF00000000L & l) >> 32);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPackedPositionType(long l) {
        if (l == 0xFFFFFFFFL) {
            return 2;
        }
        if ((l & Long.MIN_VALUE) != Long.MIN_VALUE) return 0;
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHeaderOrFooterPosition(int n) {
        int n2 = this.mItemCount;
        int n3 = this.getFooterViewsCount();
        int n4 = n2 - n3;
        int n5 = this.getHeaderViewsCount();
        if (n < n5) return true;
        if (n < n4) return false;
        return true;
    }

    public boolean collapseGroup(int n) {
        boolean bl = this.mConnector.collapseGroup(n);
        if (this.mOnGroupCollapseListener != null) {
            this.mOnGroupCollapseListener.onGroupCollapse(n);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int n, long l) {
        void var5_5;
        if (this.isHeaderOrFooterPosition(n)) {
            AdapterView.AdapterContextMenuInfo adapterContextMenuInfo = new AdapterView.AdapterContextMenuInfo(view, n, l);
            return var5_5;
        }
        int n2 = this.getFlatPositionForConnector(n);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n2);
        ExpandableListPosition expandableListPosition = positionMetadata.position;
        positionMetadata.recycle();
        long l2 = this.getChildOrGroupId(expandableListPosition);
        long l3 = expandableListPosition.getPackedPosition();
        expandableListPosition.recycle();
        View view2 = view;
        long l4 = l2;
        ExpandableListContextMenuInfo expandableListContextMenuInfo = new ExpandableListContextMenuInfo(view2, l3, l4);
        return var5_5;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mChildIndicator == null && this.mGroupIndicator == null) {
            return;
        }
        int n = 0;
        int n2 = this.mGroupFlags & 0x22;
        int n3 = 34;
        boolean bl = n2 == n3;
        if (bl) {
            n = canvas.save();
            int n4 = this.mScrollX;
            int n5 = this.mScrollY;
            int n6 = this.mPaddingLeft + n4;
            int n7 = this.mPaddingTop + n5;
            int n8 = this.mRight + n4;
            int n9 = this.mLeft;
            int n10 = n8 - n9;
            int n11 = this.mPaddingRight;
            int n12 = n10 - n11;
            int n13 = this.mBottom + n5;
            int n14 = this.mTop;
            int n15 = n13 - n14;
            int n16 = this.mPaddingBottom;
            int n17 = n15 - n16;
            Canvas canvas2 = canvas;
            int n18 = n6;
            int n19 = n7;
            int n20 = n12;
            int n21 = n17;
            boolean bl2 = canvas2.clipRect(n18, n19, n20, n21);
        }
        int n22 = this.getHeaderViewsCount();
        int n23 = this.mItemCount;
        int n24 = this.getFooterViewsCount();
        int n25 = n23 - n24 - n22 - 1;
        int n26 = this.mBottom;
        int n27 = -1;
        Rect rect = this.mIndicatorRect;
        int n28 = this.getChildCount();
        int n29 = this.mFirstPosition - n22;
        for (int i = 0; i < n28; ++i, ++n29) {
            int n30;
            int n31;
            int n32;
            int n33;
            int n34;
            int n35;
            if (n29 < 0) continue;
            if (n29 > n25) break;
            ExpandableListView expandableListView = this;
            int n36 = i;
            View view = expandableListView.getChildAt(n36);
            int n37 = view.getTop();
            int n38 = view.getBottom();
            if (n38 < 0 || (n35 = n37) > (n34 = n26)) continue;
            ExpandableListConnector expandableListConnector = this.mConnector;
            int n39 = n29;
            ExpandableListConnector.PositionMetadata positionMetadata = expandableListConnector.getUnflattenedPos(n39);
            int n40 = positionMetadata.position.type;
            int n41 = n27;
            if (n40 != n41) {
                int n42 = positionMetadata.position.type;
                int n43 = 1;
                if (n42 == n43) {
                    int n44;
                    int n45;
                    int n46 = this.mChildIndicatorLeft;
                    int n47 = 65535;
                    int n48 = n46 == n47 ? this.mIndicatorLeft : this.mChildIndicatorLeft;
                    rect.left = n45 = n48;
                    int n49 = this.mChildIndicatorRight;
                    int n50 = 65535;
                    int n51 = n49 == n50 ? this.mIndicatorRight : this.mChildIndicatorRight;
                    rect.right = n44 = n51;
                } else {
                    int n52;
                    int n53;
                    rect.left = n53 = this.mIndicatorLeft;
                    rect.right = n52 = this.mIndicatorRight;
                }
                int n54 = positionMetadata.position.type;
            }
            if ((n33 = (n32 = rect.left)) != (n31 = (n30 = rect.right))) {
                ExpandableListConnector.PositionMetadata positionMetadata2;
                ExpandableListView expandableListView2;
                Drawable drawable2;
                if (this.mStackFromBottom) {
                    int n55;
                    rect.top = n55 = n37;
                    rect.bottom = n38;
                } else {
                    int n56;
                    rect.top = n56 = n37;
                    rect.bottom = n38;
                }
                if ((drawable2 = (expandableListView2 = this).getIndicator(positionMetadata2 = positionMetadata)) != null) {
                    drawable2.setBounds(rect);
                    Drawable drawable3 = drawable2;
                    Canvas canvas3 = canvas;
                    drawable3.draw(canvas3);
                }
            }
            positionMetadata.recycle();
        }
        if (!bl) {
            return;
        }
        Canvas canvas4 = canvas;
        int n57 = n;
        canvas4.restoreToCount(n57);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void drawDivider(Canvas canvas, Rect rect, int n) {
        int n2 = this.mFirstPosition;
        int n3 = n + n2;
        if (n3 >= 0) {
            int n4;
            int n5;
            int n6 = this.getFlatPositionForConnector(n3);
            ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n6);
            if (positionMetadata.position.type == 1 || positionMetadata.isExpanded() && (n5 = positionMetadata.groupMetadata.lastChildFlPos) != (n4 = positionMetadata.groupMetadata.flPos)) {
                Drawable drawable2 = this.mChildDivider;
                boolean bl = this.mClipChildDivider;
                if (!bl) {
                    drawable2.setBounds(rect);
                } else {
                    int n7 = canvas.save();
                    boolean bl2 = canvas.clipRect(rect);
                }
                drawable2.draw(canvas);
                if (bl) {
                    canvas.restore();
                }
                positionMetadata.recycle();
                return;
            }
            positionMetadata.recycle();
        }
        super.drawDivider(canvas, rect, n3);
    }

    public boolean expandGroup(int n) {
        boolean bl = this.mConnector.expandGroup(n);
        if (this.mOnGroupExpandListener != null) {
            this.mOnGroupExpandListener.onGroupExpand(n);
        }
        return bl;
    }

    @Override
    public ListAdapter getAdapter() {
        return super.getAdapter();
    }

    public ExpandableListAdapter getExpandableListAdapter() {
        return this.mAdapter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getExpandableListPosition(int n) {
        if (this.isHeaderOrFooterPosition(n)) {
            return 0xFFFFFFFFL;
        }
        int n2 = this.getFlatPositionForConnector(n);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n2);
        long l = positionMetadata.position.getPackedPosition();
        positionMetadata.recycle();
        return l;
    }

    public int getFlatListPosition(long l) {
        ExpandableListConnector expandableListConnector = this.mConnector;
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtainPosition(l);
        ExpandableListConnector.PositionMetadata positionMetadata = expandableListConnector.getFlattenedPos(expandableListPosition);
        int n = positionMetadata.position.flatListPos;
        positionMetadata.recycle();
        return this.getAbsoluteFlatPosition(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getSelectedId() {
        long l = this.getSelectedPosition();
        if (l == 0xFFFFFFFFL) {
            return 65535L;
        }
        int n = ExpandableListView.getPackedPositionGroup(l);
        if (ExpandableListView.getPackedPositionType(l) == 0) {
            return this.mAdapter.getGroupId(n);
        }
        ExpandableListAdapter expandableListAdapter = this.mAdapter;
        int n2 = ExpandableListView.getPackedPositionChild(l);
        return expandableListAdapter.getChildId(n, n2);
    }

    public long getSelectedPosition() {
        int n = this.getSelectedItemPosition();
        return this.getExpandableListPosition(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean handleItemClick(View view, int n, long l) {
        boolean bl;
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n);
        ExpandableListPosition expandableListPosition = positionMetadata.position;
        long l2 = this.getChildOrGroupId(expandableListPosition);
        if (positionMetadata.position.type == 2) {
            long l3;
            int n2;
            View view2;
            ExpandableListView expandableListView;
            OnGroupClickListener onGroupClickListener;
            if (this.mOnGroupClickListener != null && (onGroupClickListener = this.mOnGroupClickListener).onGroupClick(expandableListView = this, view2 = view, n2 = positionMetadata.position.groupPos, l3 = l2)) {
                positionMetadata.recycle();
                return true;
            }
            if (positionMetadata.isExpanded()) {
                boolean bl2 = this.mConnector.collapseGroup(positionMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupCollapseListener != null) {
                    OnGroupCollapseListener onGroupCollapseListener = this.mOnGroupCollapseListener;
                    int n3 = positionMetadata.position.groupPos;
                    onGroupCollapseListener.onGroupCollapse(n3);
                }
            } else {
                boolean bl3 = this.mConnector.expandGroup(positionMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupExpandListener != null) {
                    OnGroupExpandListener onGroupExpandListener = this.mOnGroupExpandListener;
                    int n4 = positionMetadata.position.groupPos;
                    onGroupExpandListener.onGroupExpand(n4);
                }
                int n5 = positionMetadata.position.groupPos;
                int n6 = positionMetadata.position.flatListPos;
                int n7 = this.getHeaderViewsCount();
                int n8 = n6 + n7;
                int n9 = this.mAdapter.getChildrenCount(n5) + n8;
                this.smoothScrollToPosition(n9, n8);
            }
            bl = true;
        } else {
            if (this.mOnChildClickListener != null) {
                this.playSoundEffect(0);
                OnChildClickListener onChildClickListener = this.mOnChildClickListener;
                int n10 = positionMetadata.position.groupPos;
                int n11 = positionMetadata.position.childPos;
                ExpandableListView expandableListView = this;
                View view3 = view;
                long l4 = l2;
                return onChildClickListener.onChildClick(expandableListView, view3, n10, n11, l4);
            }
            bl = false;
        }
        positionMetadata.recycle();
        return bl;
    }

    public boolean isGroupExpanded(int n) {
        return this.mConnector.isGroupExpanded(n);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        if (this.mConnector == null) {
            return;
        }
        if (savedState.expandedGroupMetadataList == null) {
            return;
        }
        ExpandableListConnector expandableListConnector = this.mConnector;
        ArrayList<ExpandableListConnector.GroupMetadata> arrayList = savedState.expandedGroupMetadataList;
        expandableListConnector.setExpandedGroupMetadataList(arrayList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Parcelable onSaveInstanceState() {
        ArrayList<ExpandableListConnector.GroupMetadata> arrayList;
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.mConnector != null) {
            arrayList = this.mConnector.getExpandedGroupMetadataList();
            return new SavedState(parcelable, arrayList);
        }
        arrayList = null;
        return new SavedState(parcelable, arrayList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean performItemClick(View view, int n, long l) {
        if (this.isHeaderOrFooterPosition(n)) {
            return super.performItemClick(view, n, l);
        }
        int n2 = this.getFlatPositionForConnector(n);
        return this.handleItemClick(view, n2, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(ExpandableListAdapter expandableListAdapter) {
        ExpandableListConnector expandableListConnector;
        this.mAdapter = expandableListAdapter;
        this.mConnector = expandableListAdapter != null ? (expandableListConnector = new ExpandableListConnector(expandableListAdapter)) : null;
        ExpandableListConnector expandableListConnector2 = this.mConnector;
        super.setAdapter(expandableListConnector2);
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        throw new RuntimeException("For ExpandableListView, use setAdapter(ExpandableListAdapter) instead of setAdapter(ListAdapter)");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setChildDivider(Drawable drawable2) {
        this.mChildDivider = drawable2;
        boolean bl = drawable2 != null && drawable2 instanceof ColorDrawable;
        this.mClipChildDivider = bl;
    }

    public void setChildIndicator(Drawable drawable2) {
        this.mChildIndicator = drawable2;
    }

    public void setChildIndicatorBounds(int n, int n2) {
        this.mChildIndicatorLeft = n;
        this.mChildIndicatorRight = n2;
    }

    public void setGroupIndicator(Drawable drawable2) {
        this.mGroupIndicator = drawable2;
    }

    public void setIndicatorBounds(int n, int n2) {
        this.mIndicatorLeft = n;
        this.mIndicatorRight = n2;
    }

    public void setOnChildClickListener(OnChildClickListener onChildClickListener) {
        this.mOnChildClickListener = onChildClickListener;
    }

    public void setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        this.mOnGroupClickListener = onGroupClickListener;
    }

    public void setOnGroupCollapseListener(OnGroupCollapseListener onGroupCollapseListener) {
        this.mOnGroupCollapseListener = onGroupCollapseListener;
    }

    public void setOnGroupExpandListener(OnGroupExpandListener onGroupExpandListener) {
        this.mOnGroupExpandListener = onGroupExpandListener;
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        super.setOnItemClickListener(onItemClickListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setSelectedChild(int n, int n2, boolean bl) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtainChildPosition(n, n2);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
        if (positionMetadata == null) {
            if (!bl) {
                return false;
            }
            boolean bl2 = this.expandGroup(n);
            positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
            if (positionMetadata == null) {
                throw new IllegalStateException("Could not find child");
            }
        }
        int n3 = positionMetadata.position.flatListPos;
        int n4 = this.getAbsoluteFlatPosition(n3);
        super.setSelection(n4);
        expandableListPosition.recycle();
        positionMetadata.recycle();
        return true;
    }

    public void setSelectedGroup(int n) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtainGroupPosition(n);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
        expandableListPosition.recycle();
        int n2 = positionMetadata.position.flatListPos;
        int n3 = this.getAbsoluteFlatPosition(n2);
        super.setSelection(n3);
        positionMetadata.recycle();
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList;

        private SavedState(Parcel parcel) {
            super(parcel);
            ArrayList arrayList = new ArrayList();
            ArrayList<ExpandableListConnector.GroupMetadata> arrayList2 = this.expandedGroupMetadataList = arrayList;
            ClassLoader classLoader = ExpandableListConnector.class.getClassLoader();
            parcel.readList(arrayList2, classLoader);
        }

        SavedState(Parcelable parcelable, ArrayList<ExpandableListConnector.GroupMetadata> arrayList) {
            super(parcelable);
            this.expandedGroupMetadataList = arrayList;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            ArrayList<ExpandableListConnector.GroupMetadata> arrayList = this.expandedGroupMetadataList;
            parcel.writeList(arrayList);
        }
    }

    public static class ExpandableListContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public long id;
        public long packedPosition;
        public View targetView;

        public ExpandableListContextMenuInfo(View view, long l, long l2) {
            this.targetView = view;
            this.packedPosition = l;
            this.id = l2;
        }
    }

    public static interface OnChildClickListener {
        public boolean onChildClick(ExpandableListView var1, View var2, int var3, int var4, long var5);
    }

    public static interface OnGroupClickListener {
        public boolean onGroupClick(ExpandableListView var1, View var2, int var3, long var4);
    }

    public static interface OnGroupExpandListener {
        public void onGroupExpand(int var1);
    }

    public static interface OnGroupCollapseListener {
        public void onGroupCollapse(int var1);
    }
}

