/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;

class FastScroller {
    private static int MIN_PAGES = 0;
    private static final int STATE_DRAGGING = 3;
    private static final int STATE_ENTER = 1;
    private static final int STATE_EXIT = 4;
    private static final int STATE_NONE = 0;
    private static final int STATE_VISIBLE = 2;
    private boolean mChangedBounds;
    private boolean mDrawOverlay;
    private Handler mHandler;
    private int mItemCount = -1;
    private AbsListView mList;
    private BaseAdapter mListAdapter;
    private int mListOffset;
    private boolean mLongList;
    private Drawable mOverlayDrawable;
    private RectF mOverlayPos;
    private int mOverlaySize;
    private Paint mPaint;
    private boolean mScrollCompleted;
    private ScrollFade mScrollFade;
    private SectionIndexer mSectionIndexer;
    private String mSectionText;
    private Object[] mSections;
    private int mState;
    private Drawable mThumbDrawable;
    private int mThumbH;
    private int mThumbW;
    private int mThumbY;
    private int mVisibleItem;

    static {
        MIN_PAGES = 4;
    }

    public FastScroller(Context context, AbsListView absListView) {
        Handler handler;
        this.mHandler = handler = new Handler();
        this.mList = absListView;
        this.init(context);
    }

    private void cancelFling() {
        long l = 0L;
        float f = 0.0f;
        MotionEvent motionEvent = MotionEvent.obtain(0L, l, 3, 0.0f, f, 0);
        boolean bl = this.mList.onTouchEvent(motionEvent);
        motionEvent.recycle();
    }

    private void getSectionsFromIndexer() {
        BaseAdapter baseAdapter;
        Object object = this.mList.getAdapter();
        this.mSectionIndexer = null;
        if (object instanceof HeaderViewListAdapter) {
            int n;
            this.mListOffset = n = ((HeaderViewListAdapter)object).getHeadersCount();
            object = ((HeaderViewListAdapter)object).getWrappedAdapter();
        }
        if (object instanceof ExpandableListConnector) {
            BaseAdapter baseAdapter2;
            SectionIndexer sectionIndexer;
            ExpandableListAdapter expandableListAdapter = ((ExpandableListConnector)object).getAdapter();
            if (!(expandableListAdapter instanceof SectionIndexer)) {
                return;
            }
            this.mSectionIndexer = sectionIndexer = (SectionIndexer)((Object)expandableListAdapter);
            this.mListAdapter = baseAdapter2 = (BaseAdapter)object;
            Object[] objectArray = this.mSectionIndexer.getSections();
            this.mSections = objectArray;
            return;
        }
        if (object instanceof SectionIndexer) {
            SectionIndexer sectionIndexer;
            BaseAdapter baseAdapter3;
            this.mListAdapter = baseAdapter3 = (BaseAdapter)object;
            this.mSectionIndexer = sectionIndexer = (SectionIndexer)object;
            Object[] objectArray = this.mSectionIndexer.getSections();
            this.mSections = objectArray;
            return;
        }
        this.mListAdapter = baseAdapter = (BaseAdapter)object;
        String[] stringArray = new String[]{" "};
        this.mSections = stringArray;
    }

    private void init(Context context) {
        Paint paint;
        ScrollFade scrollFade;
        RectF rectF;
        int n;
        Drawable drawable2;
        Resources resources = context.getResources();
        Drawable drawable3 = resources.getDrawable(17302131);
        this.useThumbDrawable(context, drawable3);
        this.mOverlayDrawable = drawable2 = resources.getDrawable(17302062);
        this.mScrollCompleted = true;
        this.getSectionsFromIndexer();
        this.mOverlaySize = n = context.getResources().getDimensionPixelSize(17104903);
        this.mOverlayPos = rectF = new RectF();
        this.mScrollFade = scrollFade = new ScrollFade();
        this.mPaint = paint = new Paint();
        this.mPaint.setAntiAlias(true);
        Paint paint2 = this.mPaint;
        Paint.Align align = Paint.Align.CENTER;
        paint2.setTextAlign(align);
        Paint paint3 = this.mPaint;
        float f = this.mOverlaySize / 2;
        paint3.setTextSize(f);
        Resources.Theme theme = context.getTheme();
        int[] nArray = new int[]{16842806};
        TypedArray typedArray = theme.obtainStyledAttributes(nArray);
        int n2 = typedArray.getIndex(0);
        int n3 = typedArray.getColorStateList(n2).getDefaultColor();
        this.mPaint.setColor(n3);
        Paint paint4 = this.mPaint;
        Paint.Style style2 = Paint.Style.FILL_AND_STROKE;
        paint4.setStyle(style2);
        this.mState = 0;
    }

    private void resetThumbPos() {
        int n = this.mList.getWidth();
        Drawable drawable2 = this.mThumbDrawable;
        int n2 = this.mThumbW;
        int n3 = n - n2;
        int n4 = this.mThumbH;
        drawable2.setBounds(n3, 0, n, n4);
        this.mThumbDrawable.setAlpha(208);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollTo(float f) {
        boolean bl;
        int n;
        int n2;
        int n3;
        char c;
        char c2;
        int n4;
        String string2;
        String string3;
        int n5;
        Object[] objectArray;
        block20: {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            SectionIndexer sectionIndexer;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            float f2;
            int n19;
            block18: {
                int n20;
                int n21;
                block19: {
                    block17: {
                        int n22;
                        int n23;
                        boolean bl2;
                        n19 = this.mList.getCount();
                        this.mScrollCompleted = bl2 = false;
                        float f3 = n19;
                        f2 = 1.0f / f3 / 8.0f;
                        objectArray = this.mSections;
                        if (objectArray == null || (n23 = objectArray.length) <= (n22 = 1)) break block17;
                        n18 = objectArray.length;
                        n21 = (int)((float)n18 * f);
                        int n24 = n21;
                        int n25 = n18;
                        if (n24 >= n25) {
                            n21 = n18 - 1;
                        }
                        n17 = n21;
                        n5 = n21;
                        SectionIndexer sectionIndexer2 = this.mSectionIndexer;
                        int n26 = n21;
                        n20 = sectionIndexer2.getPositionForSection(n26);
                        n16 = n19;
                        n15 = n20;
                        n14 = n21;
                        n13 = n21 + 1;
                        int n27 = n21;
                        int n28 = n18 - 1;
                        int n29 = n28;
                        if (n27 < n29) {
                            SectionIndexer sectionIndexer3 = this.mSectionIndexer;
                            int n30 = n21 + 1;
                            n16 = sectionIndexer3.getPositionForSection(n30);
                        }
                        if (n16 == n20) break block18;
                        break block19;
                    }
                    int n31 = (int)((float)n19 * f);
                    if (this.mList instanceof ExpandableListView) {
                        ExpandableListView expandableListView = (ExpandableListView)this.mList;
                        long l = ExpandableListView.getPackedPositionForGroup(this.mListOffset + n31);
                        ExpandableListView expandableListView2 = expandableListView;
                        long l2 = l;
                        int n32 = expandableListView2.getFlatListPosition(l2);
                        ExpandableListView expandableListView3 = expandableListView;
                        int n33 = n32;
                        int n34 = 0;
                        expandableListView3.setSelectionFromTop(n33, n34);
                    } else if (this.mList instanceof ListView) {
                        ListView listView = (ListView)this.mList;
                        int n35 = this.mListOffset + n31;
                        ListView listView2 = listView;
                        int n36 = n35;
                        int n37 = 0;
                        listView2.setSelectionFromTop(n36, n37);
                    } else {
                        AbsListView absListView = this.mList;
                        int n38 = this.mListOffset + n31;
                        absListView.setSelection(n38);
                    }
                    n5 = 65535;
                    break block20;
                }
                while (n21 > 0) {
                    SectionIndexer sectionIndexer4 = this.mSectionIndexer;
                    int n39 = n21 += -1;
                    n15 = sectionIndexer4.getPositionForSection(n39);
                    if (n15 != n20) {
                        n14 = n21;
                        n5 = n21;
                        break;
                    }
                    if (n21 != 0) continue;
                    n5 = 0;
                    break;
                }
            }
            int n40 = n13 + 1;
            while (n40 < n18 && (n12 = (sectionIndexer = this.mSectionIndexer).getPositionForSection(n11 = n40++)) != (n10 = n16)) {
                ++n13;
            }
            float f4 = n14;
            float f5 = n18;
            float f6 = f4 / f5;
            float f7 = n13;
            float f8 = n18;
            float f9 = f7 / f8;
            if (n14 != n17 && f - f6 < f2) {
                n9 = n15;
            } else {
                float f10 = n16 - n15;
                float f11 = f - f6;
                float f12 = f10 * f11;
                float f13 = f9 - f6;
                int n41 = (int)(f12 / f13);
                n9 = n15 + n41;
            }
            if ((n8 = n9) > (n7 = (n6 = n19 - 1))) {
                n9 = n19 - 1;
            }
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expandableListView = (ExpandableListView)this.mList;
                long l = ExpandableListView.getPackedPositionForGroup(this.mListOffset + n9);
                ExpandableListView expandableListView4 = expandableListView;
                long l3 = l;
                int n42 = expandableListView4.getFlatListPosition(l3);
                ExpandableListView expandableListView5 = expandableListView;
                int n43 = n42;
                int n44 = 0;
                expandableListView5.setSelectionFromTop(n43, n44);
            } else if (this.mList instanceof ListView) {
                ListView listView = (ListView)this.mList;
                int n45 = this.mListOffset + n9;
                ListView listView3 = listView;
                int n46 = n45;
                int n47 = 0;
                listView3.setSelectionFromTop(n46, n47);
            } else {
                AbsListView absListView = this.mList;
                int n48 = this.mListOffset + n9;
                absListView.setSelection(n48);
            }
        }
        if (n5 < 0) {
            boolean bl3;
            this.mDrawOverlay = bl3 = false;
            return;
        }
        this.mSectionText = string3 = (string2 = objectArray[n5].toString());
        int n49 = string2.length();
        boolean bl4 = (n49 != (n4 = 1) || (c2 = string2.charAt(0)) != (c = ' ')) && (n3 = n5) < (n2 = (n = objectArray.length));
        this.mDrawOverlay = bl = bl4;
    }

    private void useThumbDrawable(Context context, Drawable drawable2) {
        int n;
        int n2;
        this.mThumbDrawable = drawable2;
        this.mThumbW = n2 = context.getResources().getDimensionPixelSize(17104904);
        this.mThumbH = n = context.getResources().getDimensionPixelSize(17104905);
        this.mChangedBounds = true;
    }

    public void draw(Canvas canvas) {
        if (this.mState == 0) {
            return;
        }
        int n = this.mThumbY;
        int n2 = this.mList.getWidth();
        ScrollFade scrollFade = this.mScrollFade;
        int n3 = -1;
        if (this.mState == 4) {
            n3 = scrollFade.getAlpha();
            if (n3 < 104) {
                Drawable drawable2 = this.mThumbDrawable;
                int n4 = n3 * 2;
                drawable2.setAlpha(n4);
            }
            int n5 = this.mThumbW * n3 / 208;
            int n6 = n2 - n5;
            Drawable drawable3 = this.mThumbDrawable;
            int n7 = this.mThumbH;
            drawable3.setBounds(n6, 0, n2, n7);
            this.mChangedBounds = true;
        }
        float f = n;
        canvas.translate(0.0f, f);
        this.mThumbDrawable.draw(canvas);
        float f2 = -n;
        canvas.translate(0.0f, f2);
        if (this.mState == 3 && this.mDrawOverlay) {
            this.mOverlayDrawable.draw(canvas);
            Paint paint = this.mPaint;
            float f3 = paint.descent();
            RectF rectF = this.mOverlayPos;
            String string2 = this.mSectionText;
            float f4 = rectF.left;
            float f5 = rectF.right;
            float f6 = (int)(f4 + f5) / 2;
            float f7 = rectF.bottom;
            float f8 = rectF.top;
            int n8 = (int)(f7 + f8) / 2;
            int n9 = this.mOverlaySize / 4;
            float f9 = (float)(n8 + n9) - f3;
            canvas.drawText(string2, f6, f9, paint);
            return;
        }
        if (this.mState != 4) {
            return;
        }
        if (n3 == 0) {
            this.setState(0);
            return;
        }
        AbsListView absListView = this.mList;
        int n10 = this.mThumbW;
        int n11 = n2 - n10;
        int n12 = this.mThumbH + n;
        absListView.invalidate(n11, n, n2, n12);
    }

    SectionIndexer getSectionIndexer() {
        return this.mSectionIndexer;
    }

    Object[] getSections() {
        if (this.mListAdapter == null && this.mList != null) {
            this.getSectionsFromIndexer();
        }
        return this.mSections;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isPointInside(float f, float f2) {
        int n;
        int n2 = this.mList.getWidth();
        float f3 = n2 - (n = this.mThumbW);
        if (!(f > f3)) return false;
        float f4 = this.mThumbY;
        if (!(f2 >= f4)) return false;
        int n3 = this.mThumbY;
        int n4 = this.mThumbH;
        float f5 = n3 + n4;
        if (!(f2 <= f5)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isVisible() {
        if (this.mState == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        float f;
        if (this.mState <= 0) return false;
        if (motionEvent.getAction() != 0) return false;
        float f2 = motionEvent.getX();
        if (!this.isPointInside(f2, f = motionEvent.getY())) return false;
        this.setState(3);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void onScroll(AbsListView absListView, int n, int n2, int n3) {
        if (this.mItemCount != n3 && n2 > 0) {
            this.mItemCount = n3;
            int n4 = this.mItemCount / n2;
            int n5 = MIN_PAGES;
            boolean bl = n4 >= n5;
            this.mLongList = bl;
        }
        if (!this.mLongList) {
            if (this.mState == 0) {
                return;
            }
            this.setState(0);
            return;
        }
        if (n3 - n2 > 0 && this.mState != 3) {
            int n6;
            int n7 = this.mList.getHeight();
            int n8 = this.mThumbH;
            int n9 = (n7 - n8) * n;
            int n10 = n3 - n2;
            this.mThumbY = n6 = n9 / n10;
            if (this.mChangedBounds) {
                this.resetThumbPos();
                this.mChangedBounds = false;
            }
        }
        this.mScrollCompleted = true;
        int n11 = this.mVisibleItem;
        if (n != n11) {
            return;
        }
        this.mVisibleItem = n;
        if (this.mState == 3) {
            return;
        }
        this.setState(2);
        Handler handler = this.mHandler;
        ScrollFade scrollFade = this.mScrollFade;
        boolean bl = handler.postDelayed(scrollFade, 1500L);
    }

    void onSizeChanged(int n, int n2, int n3, int n4) {
        float f;
        float f2;
        float f3;
        float f4;
        if (this.mThumbDrawable != null) {
            Drawable drawable2 = this.mThumbDrawable;
            int n5 = this.mThumbW;
            int n6 = n - n5;
            int n7 = this.mThumbH;
            drawable2.setBounds(n6, 0, n, n7);
        }
        RectF rectF = this.mOverlayPos;
        int n8 = this.mOverlaySize;
        float f5 = rectF.left = (f4 = (float)((n - n8) / 2));
        float f6 = this.mOverlaySize;
        rectF.right = f3 = f5 + f6;
        float f7 = rectF.top = (f2 = (float)(n2 / 10));
        float f8 = this.mOverlaySize;
        rectF.bottom = f = f7 + f8;
        if (this.mOverlayDrawable == null) {
            return;
        }
        Drawable drawable3 = this.mOverlayDrawable;
        int n9 = (int)rectF.left;
        int n10 = (int)rectF.top;
        int n11 = (int)rectF.right;
        int n12 = (int)rectF.bottom;
        drawable3.setBounds(n9, n10, n11, n12);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean onTouchEvent(MotionEvent motionEvent) {
        int n;
        if (this.mState == 0) {
            return false;
        }
        int n2 = motionEvent.getAction();
        if (n2 == 0) {
            float f;
            float f2 = motionEvent.getX();
            if (!this.isPointInside(f2, f = motionEvent.getY())) return false;
            this.setState(3);
            if (this.mListAdapter == null && this.mList != null) {
                this.getSectionsFromIndexer();
            }
            if (this.mList != null) {
                this.mList.requestDisallowInterceptTouchEvent(true);
                this.mList.reportScrollStateChange(1);
            }
            this.cancelFling();
            return true;
        }
        if (n2 == 1) {
            if (this.mState != 3) return false;
            if (this.mList != null) {
                this.mList.requestDisallowInterceptTouchEvent(false);
                this.mList.reportScrollStateChange(0);
            }
            this.setState(2);
            Handler handler = this.mHandler;
            ScrollFade scrollFade = this.mScrollFade;
            handler.removeCallbacks(scrollFade);
            ScrollFade scrollFade2 = this.mScrollFade;
            boolean bl = handler.postDelayed(scrollFade2, 1000L);
            return true;
        }
        if (n2 != 2) return false;
        if (this.mState != 3) return false;
        int n3 = this.mList.getHeight();
        int n4 = (int)motionEvent.getY();
        int n5 = n4 - (n = this.mThumbH) + 10;
        if (n5 < 0) {
            n5 = 0;
        } else if (this.mThumbH + n5 > n3) {
            int n6 = this.mThumbH;
            n5 = n3 - n6;
        }
        if (Math.abs(this.mThumbY - n5) < 2) {
            return true;
        }
        this.mThumbY = n5;
        if (!this.mScrollCompleted) return true;
        float f = this.mThumbY;
        int n7 = this.mThumbH;
        float f3 = n3 - n7;
        float f4 = f / f3;
        this.scrollTo(f4);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void setState(int var1_1) {
        switch (var1_1) lbl-1000:
        // 3 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    this.mState = var1_1;
                    return;
                }
            }
            case 0: {
                var2_2 = this.mHandler;
                var3_3 = this.mScrollFade;
                var2_2.removeCallbacks(var3_3);
                this.mList.invalidate();
                ** GOTO lbl-1000
            }
            case 2: {
                if (this.mState != 2) {
                    this.resetThumbPos();
                }
            }
            case 3: {
                var4_4 = this.mHandler;
                var5_5 = this.mScrollFade;
                var4_4.removeCallbacks(var5_5);
                ** GOTO lbl-1000
            }
            case 4: 
        }
        var6_6 = this.mList.getWidth();
        var7_7 = this.mList;
        var8_8 = this.mThumbW;
        var9_9 = var6_6 - var8_8;
        var10_10 = this.mThumbY;
        var11_11 = this.mThumbY;
        var12_12 = this.mThumbH;
        var13_13 = var11_11 + var12_12;
        var7_7.invalidate(var9_9, var10_10, var6_6, var13_13);
        ** while (true)
    }

    void stop() {
        this.setState(0);
    }

    public class ScrollFade
    implements Runnable {
        static final int ALPHA_MAX = 208;
        static final long FADE_DURATION = 200L;
        long mFadeDuration;
        long mStartTime;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getAlpha() {
            long l;
            long l2;
            long l3;
            if (FastScroller.this.getState() != 4) {
                return 208;
            }
            long l4 = SystemClock.uptimeMillis();
            if (l4 > (l3 = (l2 = this.mStartTime) + (l = this.mFadeDuration))) {
                return 0;
            }
            long l5 = this.mStartTime;
            long l6 = (l4 - l5) * 208L;
            long l7 = this.mFadeDuration;
            long l8 = l6 / l7;
            return (int)(208L - l8);
        }

        @Override
        public void run() {
            if (FastScroller.this.getState() != 4) {
                this.startFade();
                return;
            }
            if (this.getAlpha() > 0) {
                FastScroller.this.mList.invalidate();
                return;
            }
            FastScroller.this.setState(0);
        }

        void startFade() {
            long l;
            this.mFadeDuration = 200L;
            this.mStartTime = l = SystemClock.uptimeMillis();
            FastScroller.this.setState(4);
        }
    }
}

