/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

public abstract class Filter {
    private static final int FILTER_TOKEN = -791613427;
    private static final int FINISH_TOKEN = -559038737;
    private static final String LOG_TAG = "Filter";
    private static final String THREAD_NAME = "Filter";
    private Delayer mDelayer;
    private final Object mLock;
    private Handler mResultHandler;
    private Handler mThreadHandler;

    public Filter() {
        Object object;
        this.mLock = object = new Object();
        ResultsHandler resultsHandler = new ResultsHandler();
        this.mResultHandler = resultsHandler;
    }

    static /* synthetic */ Handler access$402(Filter filter, Handler handler) {
        filter.mThreadHandler = handler;
        return handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence convertResultToString(Object object) {
        if (object != null) return object.toString();
        return "";
    }

    public final void filter(CharSequence charSequence) {
        this.filter(charSequence, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void filter(CharSequence charSequence, FilterListener filterListener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mThreadHandler == null) {
                HandlerThread handlerThread = new HandlerThread("Filter", 10);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                RequestHandler requestHandler = new RequestHandler(looper);
                this.mThreadHandler = requestHandler;
            }
            long l = this.mDelayer == null ? 0L : this.mDelayer.getPostingDelay(charSequence);
            Message message = this.mThreadHandler.obtainMessage(-791613427);
            RequestArguments requestArguments = new RequestArguments();
            String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
            requestArguments.constraint = string2;
            requestArguments.listener = filterListener;
            message.obj = requestArguments;
            this.mThreadHandler.removeMessages(-791613427);
            this.mThreadHandler.removeMessages(-559038737);
            boolean bl = this.mThreadHandler.sendMessageDelayed(message, l);
            return;
        }
    }

    protected abstract FilterResults performFiltering(CharSequence var1);

    protected abstract void publishResults(CharSequence var1, FilterResults var2);

    public void setDelayer(Delayer delayer) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDelayer = delayer;
            return;
        }
    }

    public static interface Delayer {
        public long getPostingDelay(CharSequence var1);
    }

    private static class RequestArguments {
        CharSequence constraint;
        FilterListener listener;
        FilterResults results;

        private RequestArguments() {
        }
    }

    private class ResultsHandler
    extends Handler {
        private ResultsHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            RequestArguments requestArguments = (RequestArguments)message.obj;
            Filter filter = Filter.this;
            CharSequence charSequence = requestArguments.constraint;
            FilterResults filterResults = requestArguments.results;
            filter.publishResults(charSequence, filterResults);
            if (requestArguments.listener == null) {
                return;
            }
            int n = requestArguments.results != null ? requestArguments.results.count : -1;
            requestArguments.listener.onFilterComplete(n);
        }
    }

    private class RequestHandler
    extends Handler {
        public RequestHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            int n = message.what;
            switch (n) {
                default: {
                    return;
                }
                case -791613427: {
                    Message message2;
                    RequestArguments requestArguments = (RequestArguments)message.obj;
                    try {
                        FilterResults filterResults;
                        Filter filter = Filter.this;
                        CharSequence charSequence = requestArguments.constraint;
                        requestArguments.results = filterResults = filter.performFiltering(charSequence);
                        message2 = Filter.this.mResultHandler.obtainMessage(n);
                        message2.obj = requestArguments;
                    }
                    catch (Exception exception) {
                        try {
                            FilterResults filterResults;
                            requestArguments.results = filterResults = new FilterResults();
                            int n2 = Log.w("Filter", "An exception occured during performFiltering()!", exception);
                            message2 = Filter.this.mResultHandler.obtainMessage(n);
                            message2.obj = requestArguments;
                        }
                        catch (Throwable throwable) {
                            Message message3 = Filter.this.mResultHandler.obtainMessage(n);
                            message3.obj = requestArguments;
                            message3.sendToTarget();
                            throw throwable;
                        }
                    }
                    message2.sendToTarget();
                    Object object = Filter.this.mLock;
                    synchronized (object) {
                        if (Filter.this.mThreadHandler != null) {
                            Message message4 = Filter.this.mThreadHandler.obtainMessage(-559038737);
                            boolean bl = Filter.this.mThreadHandler.sendMessageDelayed(message4, 3000L);
                        }
                        return;
                    }
                }
                case -559038737: 
            }
            Object object = Filter.this.mLock;
            synchronized (object) {
                if (Filter.this.mThreadHandler != null) {
                    Filter.this.mThreadHandler.getLooper().quit();
                    Handler handler = Filter.access$402(Filter.this, null);
                }
                return;
            }
        }
    }

    public static interface FilterListener {
        public void onFilterComplete(int var1);
    }

    protected static class FilterResults {
        public int count;
        public Object values;
    }
}

