/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class FrameLayout
extends ViewGroup {
    @ViewDebug.ExportedProperty(category="drawing")
    private Drawable mForeground;
    boolean mForegroundBoundsChanged;
    @ViewDebug.ExportedProperty(category="drawing")
    private int mForegroundGravity;
    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean mForegroundInPadding;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingBottom = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingLeft = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingRight = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingTop = 0;
    @ViewDebug.ExportedProperty(category="measurement")
    boolean mMeasureAllChildren = false;
    private final Rect mOverlayBounds;
    private final Rect mSelfBounds;

    public FrameLayout(Context context) {
        super(context);
        Rect rect;
        Rect rect2;
        this.mSelfBounds = rect2 = new Rect();
        this.mOverlayBounds = rect = new Rect();
        this.mForegroundGravity = 119;
        this.mForegroundInPadding = true;
        this.mForegroundBoundsChanged = false;
    }

    public FrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public FrameLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        int n2;
        Rect rect;
        Rect rect2;
        this.mSelfBounds = rect2 = new Rect();
        this.mOverlayBounds = rect = new Rect();
        this.mForegroundGravity = 119;
        this.mForegroundInPadding = true;
        this.mForegroundBoundsChanged = false;
        int[] nArray = R.styleable.FrameLayout;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        int n3 = this.mForegroundGravity;
        this.mForegroundGravity = n2 = typedArray.getInt(2, n3);
        Drawable drawable2 = typedArray.getDrawable(0);
        if (drawable2 != null) {
            this.setForeground(drawable2);
        }
        if (typedArray.getBoolean(1, false)) {
            this.setMeasureAllChildren(true);
        }
        this.mForegroundInPadding = bl = typedArray.getBoolean(3, true);
        typedArray.recycle();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground == null) {
            return;
        }
        Drawable drawable2 = this.mForeground;
        if (this.mForegroundBoundsChanged) {
            this.mForegroundBoundsChanged = false;
            Rect rect = this.mSelfBounds;
            Rect rect2 = this.mOverlayBounds;
            int n = this.mRight;
            int n2 = this.mLeft;
            int n3 = n - n2;
            int n4 = this.mBottom;
            int n5 = this.mTop;
            int n6 = n4 - n5;
            if (this.mForegroundInPadding) {
                rect.set(0, 0, n3, n6);
            } else {
                int n7 = this.mPaddingLeft;
                int n8 = this.mPaddingTop;
                int n9 = this.mPaddingRight;
                int n10 = n3 - n9;
                int n11 = this.mPaddingBottom;
                int n12 = n6 - n11;
                rect.set(n7, n8, n10, n12);
            }
            int n13 = this.mForegroundGravity;
            int n14 = drawable2.getIntrinsicWidth();
            int n15 = drawable2.getIntrinsicHeight();
            Gravity.apply(n13, n14, n15, rect, rect2);
            drawable2.setBounds(rect2);
        }
        drawable2.draw(canvas);
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForeground == null) {
            return;
        }
        if (!this.mForeground.isStateful()) {
            return;
        }
        Drawable drawable2 = this.mForeground;
        int[] nArray = this.getDrawableState();
        boolean bl = drawable2.setState(nArray);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        boolean bl = super.gatherTransparentRegion(region);
        if (region != null && this.mForeground != null) {
            Drawable drawable2 = this.mForeground;
            this.applyDrawableToTransparentRegion(drawable2, region);
        }
        return bl;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    public boolean getConsiderGoneChildrenWhenMeasuring() {
        return this.mMeasureAllChildren;
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        boolean bl2;
        int n5 = this.getChildCount();
        int n6 = this.mPaddingLeft;
        int n7 = this.mForegroundPaddingLeft;
        int n8 = n6 + n7;
        int n9 = n3 - n;
        int n10 = this.mPaddingRight;
        int n11 = n9 - n10;
        int n12 = this.mForegroundPaddingRight;
        int n13 = n11 - n12;
        int n14 = this.mPaddingTop;
        int n15 = this.mForegroundPaddingTop;
        int n16 = n14 + n15;
        int n17 = n4 - n2;
        int n18 = this.mPaddingBottom;
        int n19 = n17 - n18;
        int n20 = this.mForegroundPaddingBottom;
        int n21 = n19 - n20;
        this.mForegroundBoundsChanged = bl2 = true;
        int n22 = 0;
        while (n22 < n5) {
            int n23;
            FrameLayout frameLayout = this;
            int n24 = n22;
            View view = frameLayout.getChildAt(n24);
            int n25 = view.getVisibility();
            if (n25 != (n23 = 8)) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n26 = view.getMeasuredWidth();
                int n27 = view.getMeasuredHeight();
                int n28 = n8;
                int n29 = n16;
                int n30 = layoutParams.gravity;
                int n31 = n30;
                int n32 = 65535;
                if (n31 != n32) {
                    int n33 = n30 & 7;
                    int n34 = n30 & 0x70;
                    switch (n33) {
                        default: {
                            int n35 = layoutParams.leftMargin;
                            n28 = n8 + n35;
                            break;
                        }
                        case 3: {
                            int n36 = layoutParams.leftMargin;
                            n28 = n8 + n36;
                            break;
                        }
                        case 1: {
                            int n37 = (n13 - n8 - n26) / 2 + n8;
                            int n38 = layoutParams.leftMargin;
                            int n39 = n37 + n38;
                            int n40 = layoutParams.rightMargin;
                            n28 = n39 - n40;
                            break;
                        }
                        case 5: {
                            int n41 = n13 - n26;
                            int n42 = layoutParams.rightMargin;
                            n28 = n41 - n42;
                        }
                    }
                    switch (n34) {
                        default: {
                            int n43 = layoutParams.topMargin;
                            n29 = n16 + n43;
                            break;
                        }
                        case 48: {
                            int n44 = layoutParams.topMargin;
                            n29 = n16 + n44;
                            break;
                        }
                        case 16: {
                            int n45 = (n21 - n16 - n27) / 2 + n16;
                            int n46 = layoutParams.topMargin;
                            int n47 = n45 + n46;
                            int n48 = layoutParams.bottomMargin;
                            n29 = n47 - n48;
                            break;
                        }
                        case 80: {
                            int n49 = n21 - n27;
                            int n50 = layoutParams.bottomMargin;
                            n29 = n49 - n50;
                        }
                    }
                }
                int n51 = n28 + n26;
                int n52 = n29 + n27;
                View view2 = view;
                int n53 = n28;
                int n54 = n29;
                int n55 = n51;
                int n56 = n52;
                view2.layout(n53, n54, n55, n56);
            }
            ++n22;
        }
        return;
    }

    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.getChildCount();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            View view = this.getChildAt(i);
            if (!this.mMeasureAllChildren && view.getVisibility() == 8) continue;
            FrameLayout frameLayout = this;
            int n6 = n;
            int n7 = n2;
            int n8 = 0;
            frameLayout.measureChildWithMargins(view, n6, 0, n7, n8);
            int n9 = view.getMeasuredWidth();
            n5 = Math.max(n5, n9);
            int n10 = view.getMeasuredHeight();
            n4 = Math.max(n4, n10);
        }
        int n11 = this.mPaddingLeft;
        int n12 = this.mPaddingRight;
        int n13 = n11 + n12;
        int n14 = this.mForegroundPaddingLeft;
        int n15 = n13 + n14;
        int n16 = this.mForegroundPaddingRight;
        int n17 = n15 + n16;
        int n18 = n5 + n17;
        int n19 = this.mPaddingTop;
        int n20 = this.mPaddingBottom;
        int n21 = n19 + n20;
        int n22 = this.mForegroundPaddingTop;
        int n23 = n21 + n22;
        int n24 = this.mForegroundPaddingBottom;
        int n25 = n23 + n24;
        int n26 = n4 + n25;
        int n27 = this.getSuggestedMinimumHeight();
        int n28 = Math.max(n26, n27);
        int n29 = this.getSuggestedMinimumWidth();
        int n30 = Math.max(n18, n29);
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            int n31 = drawable2.getMinimumHeight();
            n28 = Math.max(n28, n31);
            int n32 = drawable2.getMinimumWidth();
            n30 = Math.max(n30, n32);
        }
        int n33 = FrameLayout.resolveSize(n30, n);
        int n34 = FrameLayout.resolveSize(n28, n2);
        this.setMeasuredDimension(n33, n34);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mForegroundBoundsChanged = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setForeground(Drawable drawable2) {
        if (this.mForeground == drawable2) {
            return;
        }
        if (this.mForeground != null) {
            this.mForeground.setCallback(null);
            Drawable drawable3 = this.mForeground;
            this.unscheduleDrawable(drawable3);
        }
        this.mForeground = drawable2;
        this.mForegroundPaddingLeft = 0;
        this.mForegroundPaddingTop = 0;
        this.mForegroundPaddingRight = 0;
        this.mForegroundPaddingBottom = 0;
        if (drawable2 != null) {
            Rect rect;
            this.setWillNotDraw(false);
            drawable2.setCallback(this);
            if (drawable2.isStateful()) {
                int[] nArray = this.getDrawableState();
                boolean bl = drawable2.setState(nArray);
            }
            if (this.mForegroundGravity == 119 && drawable2.getPadding(rect = new Rect())) {
                int n;
                int n2;
                int n3;
                int n4;
                this.mForegroundPaddingLeft = n4 = rect.left;
                this.mForegroundPaddingTop = n3 = rect.top;
                this.mForegroundPaddingRight = n2 = rect.right;
                this.mForegroundPaddingBottom = n = rect.bottom;
            }
        } else {
            this.setWillNotDraw(true);
        }
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @RemotableViewMethod
    public void setForegroundGravity(int n) {
        if (this.mForegroundGravity != n) {
            return;
        }
        if ((n & 7) == 0) {
            n |= 3;
        }
        if ((n & 0x70) == 0) {
            n |= 0x30;
        }
        this.mForegroundGravity = n;
        if (this.mForegroundGravity == 119 && this.mForeground != null) {
            Rect rect = new Rect();
            if (this.mForeground.getPadding(rect)) {
                int n2;
                int n3;
                int n4;
                int n5;
                this.mForegroundPaddingLeft = n5 = rect.left;
                this.mForegroundPaddingTop = n4 = rect.top;
                this.mForegroundPaddingRight = n3 = rect.right;
                this.mForegroundPaddingBottom = n2 = rect.bottom;
            }
        } else {
            this.mForegroundPaddingLeft = 0;
            this.mForegroundPaddingTop = 0;
            this.mForegroundPaddingRight = 0;
            this.mForegroundPaddingBottom = 0;
        }
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setMeasureAllChildren(boolean bl) {
        this.mMeasureAllChildren = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        Drawable drawable3 = this.mForeground;
        if (drawable2 != drawable3) return false;
        return true;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.gravity = n3;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            int n;
            int[] nArray = R.styleable.FrameLayout_Layout;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
            this.gravity = n = typedArray.getInt(0, -1);
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }
}

