/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Transformation;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.Scroller;
import android.widget.SpinnerAdapter;
import com.android.internal.R;

public class Gallery
extends AbsSpinner
implements GestureDetector.OnGestureListener {
    private static final int SCROLL_TO_FLING_UNCERTAINTY_TIMEOUT = 250;
    private static final String TAG = "Gallery";
    private static final boolean localLOGV;
    private int mAnimationDuration = 400;
    private AdapterView.AdapterContextMenuInfo mContextMenuInfo;
    private Runnable mDisableSuppressSelectionChangedRunnable;
    private int mDownTouchPosition;
    private View mDownTouchView;
    private FlingRunnable mFlingRunnable;
    private GestureDetector mGestureDetector;
    private int mGravity;
    private boolean mIsFirstScroll;
    private int mLeftMost;
    private boolean mReceivedInvokeKeyDown;
    private int mRightMost;
    private View mSelectedChild;
    private boolean mShouldCallbackDuringFling;
    private boolean mShouldCallbackOnUnselectedItemClick;
    private boolean mShouldStopFling;
    private int mSpacing = 0;
    private boolean mSuppressSelectionChanged;
    private float mUnselectedAlpha;

    public Gallery(Context context) {
        this(context, null);
    }

    public Gallery(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010070);
    }

    public Gallery(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        int n3;
        int n4;
        GestureDetector gestureDetector;
        Runnable runnable;
        FlingRunnable flingRunnable;
        this.mFlingRunnable = flingRunnable = new FlingRunnable();
        this.mDisableSuppressSelectionChangedRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = Gallery.access$002(Gallery.this, false);
                Gallery.this.selectionChanged();
            }
        };
        this.mShouldCallbackDuringFling = true;
        this.mShouldCallbackOnUnselectedItemClick = true;
        this.mGestureDetector = gestureDetector = new GestureDetector(context, this);
        this.mGestureDetector.setIsLongpressEnabled(true);
        int[] nArray = R.styleable.Gallery;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        int n5 = typedArray.getInt(0, -1);
        if (n5 >= 0) {
            this.setGravity(n5);
        }
        if ((n4 = typedArray.getInt(1, -1)) > 0) {
            this.setAnimationDuration(n4);
        }
        int n6 = typedArray.getDimensionPixelOffset(2, 0);
        this.setSpacing(n6);
        float f = typedArray.getFloat(3, 0.5f);
        this.setUnselectedAlpha(f);
        typedArray.recycle();
        this.mGroupFlags = n3 = this.mGroupFlags | 0x400;
        this.mGroupFlags = n2 = this.mGroupFlags | 0x800;
    }

    static /* synthetic */ boolean access$002(Gallery gallery, boolean bl) {
        gallery.mSuppressSelectionChanged = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(Gallery gallery, boolean bl) {
        gallery.mShouldStopFling = bl;
        return bl;
    }

    static /* synthetic */ int access$702(Gallery gallery, int n) {
        gallery.mDownTouchPosition = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int calculateTop(View view, boolean bl) {
        int n = bl ? this.mMeasuredHeight : this.getHeight();
        int n2 = bl ? view.getMeasuredHeight() : view.getHeight();
        int n3 = 0;
        switch (this.mGravity) {
            case 48: {
                return this.mSpinnerPadding.top;
            }
            case 16: {
                int n4 = this.mSpinnerPadding.bottom;
                int n5 = n - n4;
                int n6 = this.mSpinnerPadding.top;
                int n7 = n5 - n6 - n2;
                int n8 = this.mSpinnerPadding.top;
                int n9 = n7 / 2;
                return n8 + n9;
            }
            case 80: {
                int n10 = this.mSpinnerPadding.bottom;
                return n - n10 - n2;
            }
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private void detachOffScreenChildren(boolean var1_1) {
        var2_2 = this.getChildCount();
        var3_3 = this.mFirstPosition;
        var4_4 = 0;
        var5_5 = 0;
        if (var1_1) {
            var6_6 = this.mPaddingLeft;
            var7_7 = 0;
            while (true) {
                if (var7_7 >= var2_2 || (var8_9 = this.getChildAt(var7_7)).getRight() >= var6_6) {
                    while (true) {
                        this.detachViewsFromParent(var4_4, var5_5);
                        if (!var1_1) {
                            return;
                        }
                        this.mFirstPosition = var9_13 = this.mFirstPosition + var5_5;
                        return;
                    }
                }
                ++var5_5;
                var10_11 = this.mRecycler;
                var11_12 = var3_3 + var7_7;
                var10_11.put(var11_12, var8_9);
                ++var7_7;
            }
        }
        var12_14 = this.getWidth();
        var13_15 = this.mPaddingRight;
        var14_16 = var12_14 - var13_15;
        var7_8 = var2_2 - 1;
        while (true) {
            if (var7_8 < 0 || (var8_10 = this.getChildAt(var7_8)).getLeft() <= var14_16) ** continue;
            var4_4 = var7_8;
            ++var5_5;
            var15_17 = this.mRecycler;
            var16_18 = var3_3 + var7_8;
            var15_17.put(var16_18, var8_10);
            var7_8 += -1;
        }
    }

    private boolean dispatchLongPress(View view, int n, long l) {
        boolean bl = false;
        if (this.mOnItemLongClickListener != null) {
            AdapterView.OnItemLongClickListener onItemLongClickListener = this.mOnItemLongClickListener;
            View view2 = this.mDownTouchView;
            int n2 = this.mDownTouchPosition;
            Gallery gallery = this;
            long l2 = l;
            bl = onItemLongClickListener.onItemLongClick(gallery, view2, n2, l2);
        }
        if (!bl) {
            AdapterView.AdapterContextMenuInfo adapterContextMenuInfo;
            this.mContextMenuInfo = adapterContextMenuInfo = new AdapterView.AdapterContextMenuInfo(view, n, l);
            bl = super.showContextMenuForChild(this);
        }
        if (bl) {
            boolean bl2 = this.performHapticFeedback(0);
        }
        return bl;
    }

    private void dispatchPress(View view) {
        if (view != null) {
            view.setPressed(true);
        }
        this.setPressed(true);
    }

    private void dispatchUnpress() {
        for (int i = this.getChildCount() - 1; i >= 0; i += -1) {
            this.getChildAt(i).setPressed(false);
        }
        this.setPressed(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fillToGalleryLeft() {
        int n;
        int n2;
        int n3 = this.mSpacing;
        int n4 = this.mPaddingLeft;
        View view = this.getChildAt(0);
        if (view != null) {
            n2 = this.mFirstPosition - 1;
            n = view.getLeft() - n3;
        } else {
            n2 = 0;
            int n5 = this.mRight;
            int n6 = this.mLeft;
            int n7 = n5 - n6;
            int n8 = this.mPaddingRight;
            n = n7 - n8;
            this.mShouldStopFling = true;
        }
        while (n > n4) {
            if (n2 < 0) {
                return;
            }
            int n9 = this.mSelectedPosition;
            int n10 = n2 - n9;
            View view2 = this.makeAndAddView(n2, n10, n, false);
            this.mFirstPosition = n2;
            n = view2.getLeft() - n3;
            n2 += -1;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fillToGalleryRight() {
        int n;
        int n2;
        int n3 = this.mSpacing;
        int n4 = this.mRight;
        int n5 = this.mLeft;
        int n6 = n4 - n5;
        int n7 = this.mPaddingRight;
        int n8 = n6 - n7;
        int n9 = this.getChildCount();
        int n10 = this.mItemCount;
        int n11 = n9 - 1;
        View view = this.getChildAt(n11);
        if (view != null) {
            n2 = this.mFirstPosition + n9;
            n = view.getRight() + n3;
        } else {
            this.mFirstPosition = n2 = this.mItemCount - 1;
            n = this.mPaddingLeft;
            this.mShouldStopFling = true;
        }
        while (n < n8) {
            if (n2 >= n10) {
                return;
            }
            int n12 = this.mSelectedPosition;
            int n13 = n2 - n12;
            n = this.makeAndAddView(n2, n13, n, true).getRight() + n3;
            ++n2;
        }
        return;
    }

    private int getCenterOfGallery() {
        int n = this.getWidth();
        int n2 = this.mPaddingLeft;
        int n3 = n - n2;
        int n4 = this.mPaddingRight;
        int n5 = (n3 - n4) / 2;
        int n6 = this.mPaddingLeft;
        return n5 + n6;
    }

    private static int getCenterOfView(View view) {
        int n = view.getLeft();
        int n2 = view.getWidth() / 2;
        return n + n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View makeAndAddView(int n, int n2, int n3, boolean bl) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.get(n)) != null) {
            int n4;
            int n5;
            int n6 = view.getLeft();
            int n7 = this.mRightMost;
            int n8 = view.getMeasuredWidth() + n6;
            this.mRightMost = n5 = Math.max(n7, n8);
            this.mLeftMost = n4 = Math.min(this.mLeftMost, n6);
            this.setUpChild(view, n2, n3, bl);
            return view;
        }
        View view2 = this.mAdapter.getView(n, null, this);
        this.setUpChild(view2, n2, n3, bl);
        return view2;
    }

    private void offsetChildrenLeftAndRight(int n) {
        int n2 = this.getChildCount() - 1;
        while (n2 >= 0) {
            this.getChildAt(n2).offsetLeftAndRight(n);
            n2 += -1;
        }
        return;
    }

    private void onFinishedMovement() {
        if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
            super.selectionChanged();
        }
        this.invalidate();
    }

    private void scrollIntoSlots() {
        if (this.getChildCount() == 0) {
            return;
        }
        if (this.mSelectedChild == null) {
            return;
        }
        int n = Gallery.getCenterOfView(this.mSelectedChild);
        int n2 = this.getCenterOfGallery() - n;
        if (n2 != 0) {
            this.mFlingRunnable.startUsingDistance(n2);
            return;
        }
        this.onFinishedMovement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scrollToChild(int n) {
        View view = this.getChildAt(n);
        if (view == null) return false;
        int n2 = this.getCenterOfGallery();
        int n3 = Gallery.getCenterOfView(view);
        int n4 = n2 - n3;
        this.mFlingRunnable.startUsingDistance(n4);
        return true;
    }

    private void setSelectionToCenterChild() {
        View view = this.mSelectedChild;
        if (this.mSelectedChild == null) {
            return;
        }
        int n = this.getCenterOfGallery();
        if (view.getLeft() <= n && view.getRight() >= n) {
            return;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = this.getChildCount() - 1;
        while (true) {
            int n5;
            View view2;
            block9: {
                int n6;
                int n7;
                block8: {
                    if (n4 < 0) break block8;
                    view2 = this.getChildAt(n4);
                    if (view2.getLeft() > n || view2.getRight() < n) break block9;
                    n3 = n4;
                }
                if ((n7 = this.mFirstPosition + n3) != (n6 = this.mSelectedPosition)) {
                    return;
                }
                this.setSelectedPositionInt(n7);
                this.setNextSelectedPositionInt(n7);
                this.checkSelectionChanged();
                return;
            }
            int n8 = Math.abs(view2.getLeft() - n);
            int n9 = Math.min(n8, n5 = Math.abs(view2.getRight() - n));
            if (n9 < n2) {
                n2 = n9;
                n3 = n4;
            }
            n4 += -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setUpChild(View view, int n, int n2, boolean bl) {
        int n3;
        int n4;
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = (LayoutParams)this.generateDefaultLayoutParams();
        }
        int n5 = bl ? -1 : 0;
        boolean bl2 = this.addViewInLayout(view, n5, layoutParams);
        boolean bl3 = n == 0;
        view.setSelected(bl3);
        int n6 = this.mHeightMeasureSpec;
        int n7 = this.mSpinnerPadding.top;
        int n8 = this.mSpinnerPadding.bottom;
        int n9 = n7 + n8;
        int n10 = layoutParams.height;
        int n11 = ViewGroup.getChildMeasureSpec(n6, n9, n10);
        int n12 = this.mWidthMeasureSpec;
        int n13 = this.mSpinnerPadding.left;
        int n14 = this.mSpinnerPadding.right;
        int n15 = n13 + n14;
        int n16 = layoutParams.width;
        int n17 = ViewGroup.getChildMeasureSpec(n12, n15, n16);
        view.measure(n17, n11);
        int n18 = this.calculateTop(view, true);
        int n19 = view.getMeasuredHeight();
        int n20 = n18 + n19;
        int n21 = view.getMeasuredWidth();
        if (bl) {
            n4 = n2;
            n3 = n4 + n21;
        } else {
            n4 = n2 - n21;
            n3 = n2;
        }
        view.layout(n4, n18, n3, n20);
    }

    private void updateSelectedItemMetadata() {
        View view;
        View view2 = this.mSelectedChild;
        int n = this.mSelectedPosition;
        int n2 = this.mFirstPosition;
        int n3 = n - n2;
        this.mSelectedChild = view = this.getChildAt(n3);
        if (view == null) {
            return;
        }
        view.setSelected(true);
        view.setFocusable(true);
        if (this.hasFocus()) {
            boolean bl = view.requestFocus();
        }
        if (view2 == null) {
            return;
        }
        view2.setSelected(false);
        view2.setFocusable(false);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    protected int computeHorizontalScrollExtent() {
        return 1;
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return this.mSelectedPosition;
    }

    @Override
    protected int computeHorizontalScrollRange() {
        return this.mItemCount;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return keyEvent.dispatch(this, null, null);
    }

    @Override
    protected void dispatchSetPressed(boolean bl) {
        if (this.mSelectedChild == null) {
            return;
        }
        this.mSelectedChild.setPressed(bl);
    }

    @Override
    public void dispatchSetSelected(boolean bl) {
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getChildDrawingOrder(int n, int n2) {
        int n3 = this.mSelectedPosition;
        int n4 = this.mFirstPosition;
        int n5 = n3 - n4;
        if (n5 < 0) {
            return n2;
        }
        int n6 = n - 1;
        if (n2 != n6) {
            return n5;
        }
        if (n2 < n5) return n2;
        return n2 + 1;
    }

    @Override
    int getChildHeight(View view) {
        return view.getMeasuredHeight();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean getChildStaticTransformation(View view, Transformation transformation) {
        transformation.clear();
        View view2 = this.mSelectedChild;
        float f = view == view2 ? 1.0f : this.mUnselectedAlpha;
        transformation.setAlpha(f);
        return true;
    }

    @Override
    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    int getLimitedMotionScrollAmount(boolean bl, int n) {
        int n2;
        int n3 = bl ? this.mItemCount - 1 : 0;
        int n4 = n3 - (n2 = this.mFirstPosition);
        View view = this.getChildAt(n4);
        if (view == null) {
            return n;
        }
        int n5 = Gallery.getCenterOfView(view);
        int n6 = this.getCenterOfGallery();
        if (bl ? n5 <= n6 : n5 >= n6) {
            return 0;
        }
        int n7 = n6 - n5;
        if (!bl) return Math.min(n7, n);
        return Math.max(n7, n);
    }

    @Override
    void layout(int n, boolean bl) {
        int n2;
        int n3 = this.mSpinnerPadding.left;
        int n4 = this.mRight;
        int n5 = this.mLeft;
        int n6 = n4 - n5;
        int n7 = this.mSpinnerPadding.left;
        int n8 = n6 - n7;
        int n9 = this.mSpinnerPadding.right;
        int n10 = n8 - n9;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            int n11 = this.mNextSelectedPosition;
            this.setSelectedPositionInt(n11);
        }
        this.recycleAllViews();
        this.detachAllViewsFromParent();
        this.mRightMost = 0;
        this.mLeftMost = 0;
        this.mFirstPosition = n2 = this.mSelectedPosition;
        int n12 = this.mSelectedPosition;
        View view = this.makeAndAddView(n12, 0, 0, true);
        int n13 = n10 / 2 + n3;
        int n14 = view.getWidth() / 2;
        int n15 = n13 - n14;
        view.offsetLeftAndRight(n15);
        this.fillToGalleryRight();
        this.fillToGalleryLeft();
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        int n16 = this.mSelectedPosition;
        this.setNextSelectedPositionInt(n16);
        this.updateSelectedItemMetadata();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean moveNext() {
        if (this.mItemCount <= 0) return false;
        int n = this.mSelectedPosition;
        int n2 = this.mItemCount - 1;
        if (n >= n2) return false;
        int n3 = this.mSelectedPosition;
        int n4 = this.mFirstPosition;
        int n5 = n3 - n4 + 1;
        boolean bl = this.scrollToChild(n5);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean movePrevious() {
        if (this.mItemCount <= 0) return false;
        if (this.mSelectedPosition <= 0) return false;
        int n = this.mSelectedPosition;
        int n2 = this.mFirstPosition;
        int n3 = n - n2 - 1;
        boolean bl = this.scrollToChild(n3);
        return true;
    }

    void onCancel() {
        this.onUp();
    }

    @Override
    public boolean onDown(MotionEvent motionEvent) {
        int n;
        this.mFlingRunnable.stop(false);
        int n2 = (int)motionEvent.getX();
        int n3 = (int)motionEvent.getY();
        this.mDownTouchPosition = n = this.pointToPosition(n2, n3);
        if (this.mDownTouchPosition >= 0) {
            View view;
            int n4 = this.mDownTouchPosition;
            int n5 = this.mFirstPosition;
            int n6 = n4 - n5;
            this.mDownTouchView = view = this.getChildAt(n6);
            this.mDownTouchView.setPressed(true);
        }
        this.mIsFirstScroll = true;
        return true;
    }

    @Override
    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        if (!this.mShouldCallbackDuringFling) {
            Runnable runnable = this.mDisableSuppressSelectionChangedRunnable;
            boolean bl = this.removeCallbacks(runnable);
            if (!this.mSuppressSelectionChanged) {
                this.mSuppressSelectionChanged = true;
            }
        }
        FlingRunnable flingRunnable = this.mFlingRunnable;
        int n = (int)(-f);
        flingRunnable.startUsingVelocity(n);
        return true;
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (!bl) {
            return;
        }
        if (this.mSelectedChild == null) {
            return;
        }
        boolean bl2 = this.mSelectedChild.requestFocus(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        switch (n) {
            default: {
                return super.onKeyDown(n, keyEvent);
            }
            case 21: {
                if (!this.movePrevious()) return true;
                this.playSoundEffect(1);
                return true;
            }
            case 22: {
                if (!this.moveNext()) return true;
                this.playSoundEffect(3);
                return true;
            }
            case 23: 
            case 66: 
        }
        this.mReceivedInvokeKeyDown = true;
        return super.onKeyDown(n, keyEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        switch (n) {
            default: {
                return super.onKeyUp(n, keyEvent);
            }
            case 23: 
            case 66: 
        }
        if (this.mReceivedInvokeKeyDown && this.mItemCount > 0) {
            View view = this.mSelectedChild;
            this.dispatchPress(view);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Gallery.this.dispatchUnpress();
                }
            };
            long l = ViewConfiguration.getPressedStateDuration();
            boolean bl = this.postDelayed(runnable, l);
            int n2 = this.mSelectedPosition;
            int n3 = this.mFirstPosition;
            int n4 = n2 - n3;
            View view2 = this.getChildAt(n4);
            int n5 = this.mSelectedPosition;
            SpinnerAdapter spinnerAdapter = this.mAdapter;
            int n6 = this.mSelectedPosition;
            long l2 = spinnerAdapter.getItemId(n6);
            boolean bl2 = this.performItemClick(view2, n5, l2);
        }
        this.mReceivedInvokeKeyDown = false;
        return true;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    public void onLongPress(MotionEvent motionEvent) {
        if (this.mDownTouchPosition < 0) {
            return;
        }
        boolean bl = this.performHapticFeedback(0);
        int n = this.mDownTouchPosition;
        long l = this.getItemIdAtPosition(n);
        View view = this.mDownTouchView;
        int n2 = this.mDownTouchPosition;
        boolean bl2 = this.dispatchLongPress(view, n2, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        this.mParent.requestDisallowInterceptTouchEvent(true);
        if (!this.mShouldCallbackDuringFling) {
            if (this.mIsFirstScroll) {
                if (!this.mSuppressSelectionChanged) {
                    this.mSuppressSelectionChanged = true;
                }
                Runnable runnable = this.mDisableSuppressSelectionChangedRunnable;
                boolean bl = this.postDelayed(runnable, 250L);
            }
        } else if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
        }
        int n = (int)f * -1;
        this.trackMotionScroll(n);
        this.mIsFirstScroll = false;
        return true;
    }

    @Override
    public void onShowPress(MotionEvent motionEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onSingleTapUp(MotionEvent motionEvent) {
        if (this.mDownTouchPosition < 0) return false;
        int n = this.mDownTouchPosition;
        int n2 = this.mFirstPosition;
        int n3 = n - n2;
        boolean bl = this.scrollToChild(n3);
        if (!this.mShouldCallbackOnUnselectedItemClick) {
            int n4 = this.mDownTouchPosition;
            int n5 = this.mSelectedPosition;
            if (n4 == n5) return true;
        }
        View view = this.mDownTouchView;
        int n6 = this.mDownTouchPosition;
        SpinnerAdapter spinnerAdapter = this.mAdapter;
        int n7 = this.mDownTouchPosition;
        long l = spinnerAdapter.getItemId(n7);
        boolean bl2 = this.performItemClick(view, n6, l);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = this.mGestureDetector.onTouchEvent(motionEvent);
        int n = motionEvent.getAction();
        if (n == 1) {
            this.onUp();
            return bl;
        }
        if (n != 3) return bl;
        this.onCancel();
        return bl;
    }

    void onUp() {
        if (this.mFlingRunnable.mScroller.isFinished()) {
            this.scrollIntoSlots();
        }
        this.dispatchUnpress();
    }

    @Override
    void selectionChanged() {
        if (this.mSuppressSelectionChanged) {
            return;
        }
        super.selectionChanged();
    }

    public void setAnimationDuration(int n) {
        this.mAnimationDuration = n;
    }

    public void setCallbackDuringFling(boolean bl) {
        this.mShouldCallbackDuringFling = bl;
    }

    public void setCallbackOnUnselectedItemClick(boolean bl) {
        this.mShouldCallbackOnUnselectedItemClick = bl;
    }

    public void setGravity(int n) {
        if (this.mGravity != n) {
            return;
        }
        this.mGravity = n;
        this.requestLayout();
    }

    @Override
    void setSelectedPositionInt(int n) {
        super.setSelectedPositionInt(n);
        this.updateSelectedItemMetadata();
    }

    public void setSpacing(int n) {
        this.mSpacing = n;
    }

    public void setUnselectedAlpha(float f) {
        this.mUnselectedAlpha = f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean showContextMenu() {
        if (!this.isPressed()) return false;
        if (this.mSelectedPosition < 0) return false;
        int n = this.mSelectedPosition;
        int n2 = this.mFirstPosition;
        int n3 = n - n2;
        View view = this.getChildAt(n3);
        int n4 = this.mSelectedPosition;
        long l = this.mSelectedRowId;
        return this.dispatchLongPress(view, n4, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean showContextMenuForChild(View view) {
        int n = this.getPositionForView(view);
        if (n < 0) {
            return false;
        }
        long l = this.mAdapter.getItemId(n);
        return this.dispatchLongPress(view, n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    void trackMotionScroll(int n) {
        if (this.getChildCount() == 0) {
            return;
        }
        boolean bl = n < 0;
        int n2 = this.getLimitedMotionScrollAmount(bl, n);
        if (n2 != n) {
            this.mFlingRunnable.endFling(false);
            this.onFinishedMovement();
        }
        this.offsetChildrenLeftAndRight(n2);
        this.detachOffScreenChildren(bl);
        if (bl) {
            this.fillToGalleryRight();
        } else {
            this.fillToGalleryLeft();
        }
        this.mRecycler.clear();
        this.setSelectionToCenterChild();
        this.invalidate();
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    private class FlingRunnable
    implements Runnable {
        private int mLastFlingX;
        private Scroller mScroller;

        public FlingRunnable() {
            Scroller scroller;
            Context context = Gallery.this.getContext();
            this.mScroller = scroller = new Scroller(context);
        }

        private void endFling(boolean bl) {
            this.mScroller.forceFinished(true);
            if (!bl) {
                return;
            }
            Gallery.this.scrollIntoSlots();
        }

        private void startCommon() {
            boolean bl = Gallery.this.removeCallbacks(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            int n;
            if (Gallery.this.mItemCount == 0) {
                this.endFling(true);
                return;
            }
            boolean bl = Gallery.access$602(Gallery.this, false);
            Scroller scroller = this.mScroller;
            boolean bl2 = scroller.computeScrollOffset();
            int n2 = scroller.getCurrX();
            int n3 = this.mLastFlingX - n2;
            if (n3 > 0) {
                Gallery gallery = Gallery.this;
                int n4 = Gallery.this.mFirstPosition;
                int n5 = Gallery.access$702(gallery, n4);
                int n6 = Gallery.this.getWidth();
                int n7 = Gallery.this.mPaddingLeft;
                int n8 = n6 - n7;
                int n9 = Gallery.this.mPaddingRight;
                n = Math.min(n8 - n9 - 1, n3);
            } else {
                int n10 = Gallery.this.getChildCount() - 1;
                Gallery gallery = Gallery.this;
                int n11 = Gallery.this.mFirstPosition + n10;
                int n12 = Gallery.access$702(gallery, n11);
                int n13 = Gallery.this.getWidth();
                int n14 = Gallery.this.mPaddingRight;
                int n15 = n13 - n14;
                int n16 = Gallery.this.mPaddingLeft;
                n = Math.max(-(n15 - n16 - 1), n3);
            }
            Gallery.this.trackMotionScroll(n);
            if (bl2 && !Gallery.this.mShouldStopFling) {
                this.mLastFlingX = n2;
                boolean bl3 = Gallery.this.post(this);
                return;
            }
            this.endFling(true);
        }

        public void startUsingDistance(int n) {
            if (n == 0) {
                return;
            }
            this.startCommon();
            this.mLastFlingX = 0;
            Scroller scroller = this.mScroller;
            int n2 = -n;
            int n3 = Gallery.this.mAnimationDuration;
            int n4 = 0;
            int n5 = 0;
            scroller.startScroll(0, n4, n2, n5, n3);
            boolean bl = Gallery.this.post(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void startUsingVelocity(int n) {
            if (n == 0) {
                return;
            }
            this.startCommon();
            int n2 = n < 0 ? Integer.MAX_VALUE : 0;
            this.mLastFlingX = n2;
            Scroller scroller = this.mScroller;
            int n3 = n;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = Integer.MAX_VALUE;
            scroller.fling(n2, 0, n3, n4, n5, Integer.MAX_VALUE, n6, n7);
            boolean bl = Gallery.this.post(this);
        }

        public void stop(boolean bl) {
            boolean bl2 = Gallery.this.removeCallbacks(this);
            this.endFling(bl);
        }
    }
}

