/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.GridLayoutAnimationController;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.android.internal.R;

public class GridView
extends AbsListView {
    public static final int AUTO_FIT = 255;
    public static final int NO_STRETCH = 0;
    public static final int STRETCH_COLUMN_WIDTH = 2;
    public static final int STRETCH_SPACING = 1;
    public static final int STRETCH_SPACING_UNIFORM = 3;
    private int mColumnWidth;
    private int mGravity = 3;
    private int mHorizontalSpacing = 0;
    private int mNumColumns = -1;
    private View mReferenceView = null;
    private View mReferenceViewInSelectedRow = null;
    private int mRequestedColumnWidth;
    private int mRequestedHorizontalSpacing;
    private int mRequestedNumColumns;
    private int mStretchMode = 2;
    private final Rect mTempRect;
    private int mVerticalSpacing = 0;

    public GridView(Context context) {
        super(context);
        Rect rect;
        this.mTempRect = rect = new Rect();
    }

    public GridView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010071);
    }

    public GridView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        Rect rect;
        this.mTempRect = rect = new Rect();
        int[] nArray = R.styleable.GridView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        int n3 = typedArray.getDimensionPixelOffset(1, 0);
        this.setHorizontalSpacing(n3);
        int n4 = typedArray.getDimensionPixelOffset(2, 0);
        this.setVerticalSpacing(n4);
        int n5 = typedArray.getInt(3, 2);
        if (n5 >= 0) {
            this.setStretchMode(n5);
        }
        if ((n2 = typedArray.getDimensionPixelOffset(4, -1)) > 0) {
            this.setColumnWidth(n2);
        }
        int n6 = typedArray.getInt(5, 1);
        this.setNumColumns(n6);
        int n7 = typedArray.getInt(0, -1);
        if (n7 >= 0) {
            this.setGravity(n7);
        }
        typedArray.recycle();
    }

    private void adjustForBottomFadingEdge(View view, int n, int n2) {
        if (view.getBottom() <= n2) {
            return;
        }
        int n3 = view.getTop() - n;
        int n4 = view.getBottom() - n2;
        int n5 = -Math.min(n3, n4);
        this.offsetChildrenTopAndBottom(n5);
    }

    private void adjustForTopFadingEdge(View view, int n, int n2) {
        if (view.getTop() >= n) {
            return;
        }
        int n3 = view.getTop();
        int n4 = n - n3;
        int n5 = view.getBottom();
        int n6 = n2 - n5;
        int n7 = Math.min(n4, n6);
        this.offsetChildrenTopAndBottom(n7);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustViewsUpOrDown() {
        int n;
        int n2 = this.getChildCount();
        if (n2 <= 0) {
            return;
        }
        if (!this.mStackFromBottom) {
            int n3 = this.getChildAt(0).getTop();
            int n4 = this.mListPadding.top;
            n = n3 - n4;
            if (this.mFirstPosition != 0) {
                int n5 = this.mVerticalSpacing;
                n -= n5;
            }
            if (n < 0) {
                return;
            }
        } else {
            int n6 = n2 - 1;
            int n7 = this.getChildAt(n6).getBottom();
            int n8 = this.getHeight();
            int n9 = this.mListPadding.bottom;
            int n10 = n8 - n9;
            n = n7 - n10;
            int n11 = this.mFirstPosition + n2;
            int n12 = this.mItemCount;
            if (n11 < n12) {
                int n13 = this.mVerticalSpacing;
                int n14 = n + n13;
            }
            if (n > 0) {
                return;
            }
        }
        if (n == 0) {
            return;
        }
        int n15 = -n;
        this.offsetChildrenTopAndBottom(n15);
    }

    /*
     * Exception decompiling
     */
    private boolean commonKey(int var1_1, int var2_2, KeyEvent var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void correctTooHigh(int n, int n2, int n3) {
        int n4;
        int n5 = this.mFirstPosition + n3 - 1;
        int n6 = this.mItemCount - 1;
        if (n5 != n6) {
            return;
        }
        if (n3 <= 0) {
            return;
        }
        int n7 = n3 - 1;
        int n8 = this.getChildAt(n7).getBottom();
        int n9 = this.mBottom;
        int n10 = this.mTop;
        int n11 = n9 - n10;
        int n12 = this.mListPadding.bottom;
        int n13 = n11 - n12 - n8;
        View view = this.getChildAt(0);
        int n14 = view.getTop();
        if (n13 <= 0) {
            return;
        }
        if (this.mFirstPosition <= 0 && n14 >= (n4 = this.mListPadding.top)) {
            return;
        }
        if (this.mFirstPosition == 0) {
            int n15 = this.mListPadding.top - n14;
            n13 = Math.min(n13, n15);
        }
        this.offsetChildrenTopAndBottom(n13);
        if (this.mFirstPosition <= 0) {
            return;
        }
        int n16 = this.mFirstPosition;
        int n17 = this.mStackFromBottom ? 1 : n;
        int n18 = n16 - n17;
        int n19 = view.getTop() - n2;
        View view2 = this.fillUp(n18, n19);
        this.adjustViewsUpOrDown();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void correctTooLow(int n, int n2, int n3) {
        if (this.mFirstPosition != 0) {
            return;
        }
        if (n3 <= 0) {
            return;
        }
        int n4 = this.getChildAt(0).getTop();
        int n5 = this.mListPadding.top;
        int n6 = this.mBottom;
        int n7 = this.mTop;
        int n8 = n6 - n7;
        int n9 = this.mListPadding.bottom;
        int n10 = n8 - n9;
        int n11 = n4 - n5;
        int n12 = n3 - 1;
        View view = this.getChildAt(n12);
        int n13 = view.getBottom();
        int n14 = this.mFirstPosition + n3 - 1;
        if (n11 <= 0) {
            return;
        }
        int n15 = this.mItemCount - 1;
        if (n14 >= n15 && n13 <= n10) {
            return;
        }
        int n16 = this.mItemCount - 1;
        if (n14 != n16) {
            int n17 = n13 - n10;
            n11 = Math.min(n11, n17);
        }
        int n18 = -n11;
        this.offsetChildrenTopAndBottom(n18);
        int n19 = this.mItemCount - 1;
        if (n14 >= n19) {
            return;
        }
        int n20 = !this.mStackFromBottom ? 1 : n;
        int n21 = n20 + n14;
        int n22 = view.getBottom() + n2;
        View view2 = this.fillDown(n21, n22);
        this.adjustViewsUpOrDown();
    }

    /*
     * Exception decompiling
     */
    private void determineColumns(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private View fillDown(int n, int n2) {
        int n3;
        View view = null;
        int n4 = this.mBottom;
        int n5 = this.mTop;
        int n6 = n4 - n5;
        int n7 = this.mListPadding.bottom;
        int n8 = n6 - n7;
        while (n2 < n8 && n < (n3 = this.mItemCount)) {
            View view2 = this.makeRow(n, n2, true);
            if (view2 != null) {
                view = view2;
            }
            int n9 = this.mReferenceView.getBottom();
            int n10 = this.mVerticalSpacing;
            n2 = n9 + n10;
            int n11 = this.mNumColumns;
            n += n11;
        }
        return view;
    }

    private View fillFromBottom(int n, int n2) {
        int n3 = this.mSelectedPosition;
        int n4 = Math.max(n, n3);
        int n5 = this.mItemCount - 1;
        int n6 = Math.min(n4, n5);
        int n7 = this.mItemCount - 1 - n6;
        int n8 = this.mItemCount - 1;
        int n9 = this.mNumColumns;
        int n10 = n7 % n9;
        int n11 = n7 - n10;
        int n12 = n8 - n11;
        return this.fillUp(n12, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillFromSelection(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.getVerticalFadingEdgeLength();
        int n7 = this.mSelectedPosition;
        int n8 = this.mNumColumns;
        int n9 = this.mVerticalSpacing;
        int n10 = -1;
        if (!this.mStackFromBottom) {
            int n11 = n7 % n8;
            n5 = n7 - n11;
        } else {
            int n12 = this.mItemCount - 1 - n7;
            int n13 = this.mItemCount - 1;
            int n14 = n12 % n8;
            int n15 = n12 - n14;
            n10 = n13 - n15;
            int n16 = n10 - n8 + 1;
            n5 = Math.max(0, n16);
        }
        GridView gridView = this;
        int n17 = n2;
        int n18 = n6;
        int n19 = n5;
        int n20 = gridView.getTopSelectionPixel(n17, n18, n19);
        GridView gridView2 = this;
        int n21 = n3;
        int n22 = n6;
        int n23 = n8;
        int n24 = n5;
        int n25 = gridView2.getBottomSelectionPixel(n21, n22, n23, n24);
        int n26 = this.mStackFromBottom ? n10 : n5;
        GridView gridView3 = this;
        int n27 = n26;
        int n28 = n;
        boolean bl = true;
        View view = gridView3.makeRow(n27, n28, bl);
        this.mFirstPosition = n4 = n5;
        View view2 = this.mReferenceView;
        GridView gridView4 = this;
        View view3 = view2;
        int n29 = n20;
        int n30 = n25;
        gridView4.adjustForTopFadingEdge(view3, n29, n30);
        GridView gridView5 = this;
        View view4 = view2;
        int n31 = n20;
        int n32 = n25;
        gridView5.adjustForBottomFadingEdge(view4, n31, n32);
        if (!this.mStackFromBottom) {
            int n33 = n5 - n8;
            int n34 = view2.getTop() - n9;
            GridView gridView6 = this;
            int n35 = n33;
            int n36 = n34;
            View view5 = gridView6.fillUp(n35, n36);
            this.adjustViewsUpOrDown();
            int n37 = n5 + n8;
            int n38 = view2.getBottom() + n9;
            GridView gridView7 = this;
            int n39 = n37;
            int n40 = n38;
            View view6 = gridView7.fillDown(n39, n40);
            return view;
        }
        int n41 = n10 + n8;
        int n42 = view2.getBottom() + n9;
        GridView gridView8 = this;
        int n43 = n41;
        int n44 = n42;
        View view7 = gridView8.fillDown(n43, n44);
        this.adjustViewsUpOrDown();
        int n45 = n5 - 1;
        int n46 = view2.getTop() - n9;
        GridView gridView9 = this;
        int n47 = n45;
        int n48 = n46;
        View view8 = gridView9.fillUp(n47, n48);
        return view;
    }

    private View fillFromTop(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.mFirstPosition;
        int n6 = this.mSelectedPosition;
        int n7 = this.mFirstPosition = (n4 = Math.min(n5, n6));
        int n8 = this.mItemCount - 1;
        this.mFirstPosition = n3 = Math.min(n7, n8);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        int n9 = this.mFirstPosition;
        int n10 = this.mFirstPosition;
        int n11 = this.mNumColumns;
        int n12 = n10 % n11;
        int n13 = this.mFirstPosition = (n2 = n9 - n12);
        return this.fillDown(n13, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillSelection(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.reconcileSelectedPosition();
        int n6 = this.mNumColumns;
        int n7 = this.mVerticalSpacing;
        int n8 = -1;
        if (!this.mStackFromBottom) {
            int n9 = n5 % n6;
            n4 = n5 - n9;
        } else {
            int n10 = this.mItemCount - 1 - n5;
            int n11 = this.mItemCount - 1;
            int n12 = n10 % n6;
            int n13 = n10 - n12;
            n8 = n11 - n13;
            int n14 = n8 - n6 + 1;
            n4 = Math.max(0, n14);
        }
        int n15 = this.getVerticalFadingEdgeLength();
        GridView gridView = this;
        int n16 = n;
        int n17 = n15;
        int n18 = n4;
        int n19 = gridView.getTopSelectionPixel(n16, n17, n18);
        int n20 = this.mStackFromBottom ? n8 : n4;
        GridView gridView2 = this;
        int n21 = n20;
        int n22 = n19;
        boolean bl = true;
        View view = gridView2.makeRow(n21, n22, bl);
        this.mFirstPosition = n3 = n4;
        View view2 = this.mReferenceView;
        if (!this.mStackFromBottom) {
            int n23 = n4 + n6;
            int n24 = view2.getBottom() + n7;
            GridView gridView3 = this;
            int n25 = n23;
            int n26 = n24;
            View view3 = gridView3.fillDown(n25, n26);
            GridView gridView4 = this;
            int n27 = n2;
            gridView4.pinToBottom(n27);
            int n28 = n4 - n6;
            int n29 = view2.getTop() - n7;
            GridView gridView5 = this;
            int n30 = n28;
            int n31 = n29;
            View view4 = gridView5.fillUp(n30, n31);
            this.adjustViewsUpOrDown();
            return view;
        }
        GridView gridView6 = this;
        int n32 = n2;
        int n33 = n15;
        int n34 = n6;
        int n35 = n4;
        int n36 = gridView6.getBottomSelectionPixel(n32, n33, n34, n35);
        int n37 = view2.getBottom();
        int n38 = n36 - n37;
        GridView gridView7 = this;
        int n39 = n38;
        gridView7.offsetChildrenTopAndBottom(n39);
        int n40 = n4 - 1;
        int n41 = view2.getTop() - n7;
        GridView gridView8 = this;
        int n42 = n40;
        int n43 = n41;
        View view5 = gridView8.fillUp(n42, n43);
        this.pinToTop(n);
        int n44 = n8 + n6;
        int n45 = view2.getBottom() + n7;
        GridView gridView9 = this;
        int n46 = n44;
        int n47 = n45;
        View view6 = gridView9.fillDown(n46, n47);
        this.adjustViewsUpOrDown();
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillSpecific(int n, int n2) {
        View view;
        View view2;
        int n3;
        int n4 = this.mNumColumns;
        int n5 = -1;
        if (!this.mStackFromBottom) {
            int n6 = n % n4;
            n3 = n - n6;
        } else {
            int n7 = this.mItemCount - 1 - n;
            int n8 = this.mItemCount - 1;
            int n9 = n7 % n4;
            int n10 = n7 - n9;
            n5 = n8 - n10;
            int n11 = n5 - n4 + 1;
            n3 = Math.max(0, n11);
        }
        int n12 = this.mStackFromBottom ? n5 : n3;
        View view3 = this.makeRow(n12, n2, true);
        this.mFirstPosition = n3;
        View view4 = this.mReferenceView;
        if (view4 == null) {
            return null;
        }
        int n13 = this.mVerticalSpacing;
        if (!this.mStackFromBottom) {
            int n14 = n3 - n4;
            int n15 = view4.getTop() - n13;
            view2 = this.fillUp(n14, n15);
            this.adjustViewsUpOrDown();
            int n16 = n3 + n4;
            int n17 = view4.getBottom() + n13;
            view = this.fillDown(n16, n17);
            int n18 = this.getChildCount();
            if (n18 > 0) {
                this.correctTooHigh(n4, n13, n18);
            }
        } else {
            int n19 = n5 + n4;
            int n20 = view4.getBottom() + n13;
            view = this.fillDown(n19, n20);
            this.adjustViewsUpOrDown();
            int n21 = n3 - 1;
            int n22 = view4.getTop() - n13;
            view2 = this.fillUp(n21, n22);
            int n23 = this.getChildCount();
            if (n23 > 0) {
                this.correctTooLow(n4, n13, n23);
            }
        }
        if (view3 != null) {
            return view3;
        }
        if (view2 == null) return view;
        return view2;
    }

    private View fillUp(int n, int n2) {
        View view = null;
        int n3 = this.mListPadding.top;
        while (n2 > n3 && n >= 0) {
            View view2 = this.makeRow(n, n2, false);
            if (view2 != null) {
                view = view2;
            }
            int n4 = this.mReferenceView.getTop();
            int n5 = this.mVerticalSpacing;
            n2 = n4 - n5;
            this.mFirstPosition = n;
            int n6 = this.mNumColumns;
            n -= n6;
        }
        if (this.mStackFromBottom) {
            int n7;
            int n8 = n + 1;
            this.mFirstPosition = n7 = Math.max(0, n8);
        }
        return view;
    }

    private int getBottomSelectionPixel(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n4 + n3 - 1;
        int n7 = this.mItemCount - 1;
        if (n6 < n7) {
            n5 -= n2;
        }
        return n5;
    }

    private int getTopSelectionPixel(int n, int n2, int n3) {
        int n4 = n;
        if (n3 > 0) {
            n4 += n2;
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isCandidateSelection(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getChildCount();
        int n6 = n5 - 1 - n;
        if (!this.mStackFromBottom) {
            int n7 = this.mNumColumns;
            int n8 = n % n7;
            n4 = n - n8;
            n3 = Math.max(this.mNumColumns + n4 - 1, n5);
        } else {
            int n9 = n5 - 1;
            int n10 = this.mNumColumns;
            int n11 = n6 % n10;
            int n12 = n6 - n11;
            n3 = n9 - n12;
            int n13 = this.mNumColumns;
            int n14 = n3 - n13 + 1;
            n4 = Math.max(0, n14);
        }
        switch (n2) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 66: {
                if (n == n4) return false;
                return true;
            }
            case 130: {
                if (n4 != 0) return false;
                return true;
            }
            case 17: {
                if (n == n3) return false;
                return true;
            }
            case 33: 
        }
        int n15 = n5 - 1;
        if (n3 == n15) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View makeAndAddView(int n, int n2, boolean bl, int n3, boolean bl2, int n4) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.getActiveView(n)) != null) {
            GridView gridView = this;
            int n5 = n;
            int n6 = n2;
            boolean bl3 = bl;
            int n7 = n3;
            boolean bl4 = bl2;
            int n8 = n4;
            gridView.setupChild(view, n5, n6, bl3, n7, bl4, true, n8);
            return view;
        }
        boolean[] blArray = this.mIsScrap;
        View view2 = this.obtainView(n, blArray);
        boolean bl5 = this.mIsScrap[0];
        GridView gridView = this;
        int n9 = n;
        int n10 = n2;
        boolean bl6 = bl;
        int n11 = n3;
        boolean bl7 = bl2;
        int n12 = n4;
        gridView.setupChild(view2, n9, n10, bl6, n11, bl7, bl5, n12);
        return view2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View makeRow(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.mColumnWidth;
        int n5 = this.mHorizontalSpacing;
        int n6 = this.mListPadding.left;
        int n7 = this.mStretchMode == 3 ? n5 : 0;
        int n8 = n6 + n7;
        if (!this.mStackFromBottom) {
            int n9 = this.mNumColumns + n;
            int n10 = this.mItemCount;
            n3 = Math.min(n9, n10);
        } else {
            int n11;
            n3 = n + 1;
            int n12 = this.mNumColumns;
            int n13 = n - n12 + 1;
            int n14 = n3 - (n = Math.max(0, n13));
            if (n14 < (n11 = this.mNumColumns)) {
                int n15 = this.mNumColumns;
                int n16 = n3 - n;
                int n17 = n15 - n16;
                int n18 = n4 + n5;
                int n19 = n17 * n18;
                n8 += n19;
            }
        }
        View view = null;
        boolean bl2 = this.shouldShowSelector();
        boolean bl3 = this.touchModeDrawsInPressedState();
        int n20 = this.mSelectedPosition;
        View view2 = null;
        for (int i = n; i < n3; ++i) {
            boolean bl4 = i != n20;
            int n21 = bl ? -1 : i - n;
            GridView gridView = this;
            int n22 = n2;
            boolean bl5 = bl;
            view2 = gridView.makeAndAddView(i, n22, bl5, n8, bl4, n21);
            n8 += n4;
            int n23 = n3 - 1;
            if (i < n23) {
                int n24 = n8 + n5;
            }
            if (!bl4 || !bl2 && !bl3) continue;
            view = view2;
        }
        this.mReferenceView = view2;
        if (view != null) {
            View view3;
            this.mReferenceViewInSelectedRow = view3 = this.mReferenceView;
        }
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View moveSelection(int n, int n2, int n3) {
        View view;
        View view2;
        int n4;
        int n5;
        int n6;
        int n7 = this.getVerticalFadingEdgeLength();
        int n8 = this.mSelectedPosition;
        int n9 = this.mNumColumns;
        int n10 = this.mVerticalSpacing;
        int n11 = -1;
        if (!this.mStackFromBottom) {
            int n12 = n8 - n;
            int n13 = (n8 - n) % n9;
            n6 = n12 - n13;
            int n14 = n8 % n9;
            n5 = n8 - n14;
        } else {
            int n15 = this.mItemCount - 1 - n8;
            int n16 = this.mItemCount - 1;
            int n17 = n15 % n9;
            int n18 = n15 - n17;
            n11 = n16 - n18;
            int n19 = n11 - n9 + 1;
            n5 = Math.max(0, n19);
            int n20 = this.mItemCount - 1;
            int n21 = n8 - n;
            int n22 = n20 - n21;
            int n23 = this.mItemCount - 1;
            int n24 = n22 % n9;
            int n25 = n22 - n24;
            int n26 = n23 - n25 - n9 + 1;
            n6 = Math.max(0, n26);
        }
        int n27 = n5 - n6;
        GridView gridView = this;
        int n28 = n2;
        int n29 = n7;
        int n30 = n5;
        int n31 = gridView.getTopSelectionPixel(n28, n29, n30);
        GridView gridView2 = this;
        int n32 = n3;
        int n33 = n7;
        int n34 = n9;
        int n35 = n5;
        int n36 = gridView2.getBottomSelectionPixel(n32, n33, n34, n35);
        this.mFirstPosition = n4 = n5;
        if (n27 > 0) {
            int n37 = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getBottom();
            int n38 = this.mStackFromBottom ? n11 : n5;
            int n39 = n37 + n10;
            GridView gridView3 = this;
            int n40 = n38;
            int n41 = n39;
            boolean bl = true;
            view2 = gridView3.makeRow(n40, n41, bl);
            view = this.mReferenceView;
            GridView gridView4 = this;
            View view3 = view;
            int n42 = n31;
            int n43 = n36;
            gridView4.adjustForBottomFadingEdge(view3, n42, n43);
        } else if (n27 < 0) {
            int n44 = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            int n45 = this.mStackFromBottom ? n11 : n5;
            int n46 = n44 - n10;
            GridView gridView5 = this;
            int n47 = n45;
            int n48 = n46;
            boolean bl = false;
            view2 = gridView5.makeRow(n47, n48, bl);
            view = this.mReferenceView;
            GridView gridView6 = this;
            View view4 = view;
            int n49 = n31;
            int n50 = n36;
            gridView6.adjustForTopFadingEdge(view4, n49, n50);
        } else {
            int n51 = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            int n52 = this.mStackFromBottom ? n11 : n5;
            GridView gridView7 = this;
            int n53 = n52;
            int n54 = n51;
            boolean bl = true;
            view2 = gridView7.makeRow(n53, n54, bl);
            view = this.mReferenceView;
        }
        if (!this.mStackFromBottom) {
            int n55 = n5 - n9;
            int n56 = view.getTop() - n10;
            GridView gridView8 = this;
            int n57 = n55;
            int n58 = n56;
            View view5 = gridView8.fillUp(n57, n58);
            this.adjustViewsUpOrDown();
            int n59 = n5 + n9;
            int n60 = view.getBottom() + n10;
            GridView gridView9 = this;
            int n61 = n59;
            int n62 = n60;
            View view6 = gridView9.fillDown(n61, n62);
            return view2;
        }
        int n63 = n11 + n9;
        int n64 = view.getBottom() + n10;
        GridView gridView10 = this;
        int n65 = n63;
        int n66 = n64;
        View view7 = gridView10.fillDown(n65, n66);
        this.adjustViewsUpOrDown();
        int n67 = n5 - 1;
        int n68 = view.getTop() - n10;
        GridView gridView11 = this;
        int n69 = n67;
        int n70 = n68;
        View view8 = gridView11.fillUp(n69, n70);
        return view2;
    }

    private void pinToBottom(int n) {
        int n2;
        int n3 = this.getChildCount();
        int n4 = this.mFirstPosition + n3;
        if (n4 != (n2 = this.mItemCount)) {
            return;
        }
        int n5 = n3 - 1;
        int n6 = this.getChildAt(n5).getBottom();
        int n7 = n - n6;
        if (n7 <= 0) {
            return;
        }
        this.offsetChildrenTopAndBottom(n7);
    }

    private void pinToTop(int n) {
        if (this.mFirstPosition != 0) {
            return;
        }
        int n2 = this.getChildAt(0).getTop();
        int n3 = n - n2;
        if (n3 >= 0) {
            return;
        }
        this.offsetChildrenTopAndBottom(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupChild(View view, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl4 = bl2 && this.shouldShowSelector();
        boolean bl5 = bl4;
        boolean bl6 = view.isSelected();
        boolean bl7 = bl6;
        boolean bl8 = bl5 != bl7;
        int n11 = this.mTouchMode;
        boolean bl9 = n11 > 0 && (n10 = n11) < (n9 = 3) && (n8 = this.mMotionPosition) != (n7 = n);
        boolean bl10 = bl9;
        boolean bl11 = view.isPressed();
        boolean bl12 = bl11;
        boolean bl13 = bl10 != bl12;
        boolean bl14 = !bl3 || bl8 || view.isLayoutRequested();
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            AbsListView.LayoutParams layoutParams2 = layoutParams;
            int n12 = 65535;
            int n13 = 65534;
            int n14 = 0;
            layoutParams2(n12, n13, n14);
        }
        ListAdapter listAdapter = this.mAdapter;
        int n15 = n;
        layoutParams.viewType = n6 = listAdapter.getItemViewType(n15);
        if (bl3 && !layoutParams.forceAdd) {
            GridView gridView = this;
            View view2 = view;
            int n16 = n4;
            AbsListView.LayoutParams layoutParams3 = layoutParams;
            gridView.attachViewToParent(view2, n16, layoutParams3);
        } else {
            boolean bl15;
            layoutParams.forceAdd = bl15 = false;
            GridView gridView = this;
            View view3 = view;
            int n17 = n4;
            AbsListView.LayoutParams layoutParams4 = layoutParams;
            boolean bl16 = true;
            boolean bl17 = gridView.addViewInLayout(view3, n17, layoutParams4, bl16);
        }
        if (bl8) {
            View view4 = view;
            boolean bl18 = bl4;
            view4.setSelected(bl18);
            if (bl4) {
                boolean bl19 = this.requestFocus();
            }
        }
        if (bl13) {
            View view5 = view;
            boolean bl20 = bl9;
            view5.setPressed(bl20);
        }
        if (bl14) {
            int n18 = View.MeasureSpec.makeMeasureSpec(0, 0);
            int n19 = layoutParams.height;
            int n20 = ViewGroup.getChildMeasureSpec(n18, 0, n19);
            int n21 = View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000);
            int n22 = layoutParams.width;
            int n23 = ViewGroup.getChildMeasureSpec(n21, 0, n22);
            View view6 = view;
            int n24 = n23;
            int n25 = n20;
            view6.measure(n24, n25);
        } else {
            this.cleanupLayoutState(view);
        }
        int n26 = view.getMeasuredWidth();
        int n27 = view.getMeasuredHeight();
        int n28 = bl ? n2 : n2 - n27;
        switch (this.mGravity & 7) {
            default: {
                n5 = n3;
                break;
            }
            case 3: {
                n5 = n3;
                break;
            }
            case 1: {
                int n29 = (this.mColumnWidth - n26) / 2;
                n5 = n3 + n29;
                break;
            }
            case 5: {
                n5 = this.mColumnWidth + n3 - n26;
            }
        }
        if (bl14) {
            int n30 = n5 + n26;
            int n31 = n28 + n27;
            View view7 = view;
            int n32 = n5;
            int n33 = n28;
            int n34 = n30;
            int n35 = n31;
            view7.layout(n32, n33, n34, n35);
        } else {
            int n36 = view.getLeft();
            int n37 = n5 - n36;
            View view8 = view;
            int n38 = n37;
            view8.offsetLeftAndRight(n38);
            int n39 = view.getTop();
            int n40 = n28 - n39;
            View view9 = view;
            int n41 = n40;
            view9.offsetTopAndBottom(n41);
        }
        if (!this.mCachingStarted) {
            return;
        }
        View view10 = view;
        boolean bl21 = true;
        view10.setDrawingCacheEnabled(bl21);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean arrowScroll(int n) {
        int n2;
        int n3;
        int n4 = this.mSelectedPosition;
        int n5 = this.mNumColumns;
        boolean bl = false;
        if (!this.mStackFromBottom) {
            n3 = n4 / n5 * n5;
            int n6 = n3 + n5 - 1;
            int n7 = this.mItemCount - 1;
            n2 = Math.min(n6, n7);
        } else {
            int n8 = this.mItemCount - 1 - n4;
            int n9 = this.mItemCount - 1;
            int n10 = n8 / n5 * n5;
            n2 = n9 - n10;
            int n11 = n2 - n5 + 1;
            n3 = Math.max(0, n11);
        }
        switch (n) {
            case 33: {
                if (n3 <= 0) break;
                this.mLayoutMode = 6;
                int n12 = n4 - n5;
                int n13 = Math.max(0, n12);
                this.setSelectionInt(n13);
                bl = true;
                break;
            }
            case 130: {
                int n14 = this.mItemCount - 1;
                if (n2 >= n14) break;
                this.mLayoutMode = 6;
                int n15 = n4 + n5;
                int n16 = this.mItemCount - 1;
                int n17 = Math.min(n15, n16);
                this.setSelectionInt(n17);
                bl = true;
                break;
            }
            case 17: {
                if (n4 <= n3) break;
                this.mLayoutMode = 6;
                int n18 = n4 - 1;
                int n19 = Math.max(0, n18);
                this.setSelectionInt(n19);
                bl = true;
                break;
            }
            case 66: {
                if (n4 >= n2) break;
                this.mLayoutMode = 6;
                int n20 = n4 + 1;
                int n21 = this.mItemCount - 1;
                int n22 = Math.min(n20, n21);
                this.setSelectionInt(n22);
                bl = true;
                break;
            }
        }
        if (bl) {
            int n23 = SoundEffectConstants.getContantForFocusDirection(n);
            this.playSoundEffect(n23);
            this.invokeOnItemScrollListener();
        }
        if (bl) {
            boolean bl2 = this.awakenScrollBars();
        }
        return bl;
    }

    @Override
    protected void attachLayoutAnimationParameters(View view, ViewGroup.LayoutParams layoutParams, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        GridLayoutAnimationController.AnimationParameters animationParameters = (GridLayoutAnimationController.AnimationParameters)layoutParams.layoutAnimationParameters;
        if (animationParameters == null) {
            animationParameters = new GridLayoutAnimationController.AnimationParameters();
            layoutParams.layoutAnimationParameters = animationParameters;
        }
        animationParameters.count = n2;
        animationParameters.index = n;
        animationParameters.columnsCount = n6 = this.mNumColumns;
        int n7 = this.mNumColumns;
        animationParameters.rowsCount = n5 = n2 / n7;
        if (!this.mStackFromBottom) {
            int n8;
            int n9;
            int n10 = this.mNumColumns;
            animationParameters.column = n9 = n % n10;
            int n11 = this.mNumColumns;
            animationParameters.row = n8 = n / n11;
            return;
        }
        int n12 = n2 - 1 - n;
        int n13 = this.mNumColumns - 1;
        int n14 = this.mNumColumns;
        int n15 = n12 % n14;
        animationParameters.column = n4 = n13 - n15;
        int n16 = animationParameters.rowsCount - 1;
        int n17 = this.mNumColumns;
        int n18 = n12 / n17;
        animationParameters.row = n3 = n16 - n18;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int computeVerticalScrollExtent() {
        int n = this.getChildCount();
        if (n <= 0) return 0;
        int n2 = this.mNumColumns;
        int n3 = (n + n2 - 1) / n2 * 100;
        View view = this.getChildAt(0);
        int n4 = view.getTop();
        int n5 = view.getHeight();
        if (n5 > 0) {
            int n6 = n4 * 100 / n5;
            n3 += n6;
        }
        int n7 = n - 1;
        View view2 = this.getChildAt(n7);
        int n8 = view2.getBottom();
        int n9 = view2.getHeight();
        if (n9 <= 0) return n3;
        int n10 = this.getHeight();
        int n11 = (n8 - n10) * 100 / n9;
        n3 -= n11;
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int computeVerticalScrollOffset() {
        if (this.mFirstPosition < 0) return 0;
        if (this.getChildCount() <= 0) return 0;
        View view = this.getChildAt(0);
        int n = view.getTop();
        int n2 = view.getHeight();
        if (n2 <= 0) return 0;
        int n3 = this.mNumColumns;
        int n4 = this.mFirstPosition / n3;
        int n5 = (this.mItemCount + n3 - 1) / n3;
        int n6 = n4 * 100;
        int n7 = n * 100 / n2;
        int n8 = n6 - n7;
        float f = this.mScrollY;
        float f2 = this.getHeight();
        float f3 = f / f2;
        float f4 = n5;
        int n9 = (int)(f3 * f4 * 100.0f);
        return Math.max(n8 + n9, 0);
    }

    @Override
    protected int computeVerticalScrollRange() {
        int n = this.mNumColumns;
        int n2 = (this.mItemCount + n - 1) / n;
        int n3 = Math.max(n2 * 100, 0);
        if (this.mScrollY != 0) {
            float f = this.mScrollY;
            float f2 = this.getHeight();
            float f3 = f / f2;
            float f4 = n2;
            int n4 = Math.abs((int)(f3 * f4 * 100.0f));
            n3 += n4;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void fillGap(boolean bl) {
        int n;
        int n2 = this.mNumColumns;
        int n3 = this.mVerticalSpacing;
        int n4 = this.getChildCount();
        if (bl) {
            int n5;
            if (n4 > 0) {
                int n6 = n4 - 1;
                n5 = this.getChildAt(n6).getBottom() + n3;
            } else {
                n5 = this.getListPaddingTop();
            }
            int n7 = this.mFirstPosition + n4;
            if (this.mStackFromBottom) {
                int n8 = n2 - 1;
                n7 += n8;
            }
            View view = this.fillDown(n7, n5);
            int n9 = this.getChildCount();
            this.correctTooHigh(n2, n3, n9);
            return;
        }
        if (n4 > 0) {
            n = this.getChildAt(0).getTop() - n3;
        } else {
            int n10 = this.getHeight();
            int n11 = this.getListPaddingBottom();
            n = n10 - n11;
        }
        int n12 = this.mFirstPosition;
        int n13 = !this.mStackFromBottom ? n12 - n2 : n12 + -1;
        View view = this.fillUp(n13, n);
        int n14 = this.getChildCount();
        this.correctTooLow(n2, n3, n14);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    int findMotionRow(int n) {
        int n2 = this.getChildCount();
        if (n2 <= 0) return -1;
        int n3 = this.mNumColumns;
        if (!this.mStackFromBottom) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = this.getChildAt(n4).getBottom();
                if (n <= n5) {
                    return this.mFirstPosition + n4;
                }
                n4 += n3;
            }
            return -1;
        }
        int n6 = n2 - 1;
        while (n6 >= 0) {
            int n7 = this.getChildAt(n6).getTop();
            if (n >= n7) {
                return this.mFirstPosition + n6;
            }
            n6 -= n3;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean fullScroll(int n) {
        boolean bl = false;
        if (n == 33) {
            this.mLayoutMode = 2;
            this.setSelectionInt(0);
            this.invokeOnItemScrollListener();
            bl = true;
        } else if (n == 130) {
            this.mLayoutMode = 2;
            int n2 = this.mItemCount - 1;
            this.setSelectionInt(n2);
            this.invokeOnItemScrollListener();
            bl = true;
        }
        if (bl) {
            boolean bl2 = this.awakenScrollBars();
        }
        return bl;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getStretchMode() {
        return this.mStretchMode;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void layoutChildren() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 778->1283)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    int lookForSelectablePosition(int n, boolean bl) {
        if (this.mAdapter == null) return -1;
        if (this.isInTouchMode()) {
            return -1;
        }
        if (n < 0) return -1;
        int n2 = this.mItemCount;
        if (n < n2) return n;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        int n2 = -1;
        if (bl && rect != null) {
            int n3 = this.mScrollX;
            int n4 = this.mScrollY;
            rect.offset(n3, n4);
            Rect rect2 = this.mTempRect;
            int n5 = Integer.MAX_VALUE;
            int n6 = this.getChildCount();
            for (int i = 0; i < n6; ++i) {
                if (!this.isCandidateSelection(i, n)) continue;
                View view = this.getChildAt(i);
                view.getDrawingRect(rect2);
                this.offsetDescendantRectToMyCoords(view, rect2);
                int n7 = GridView.getDistance(rect, rect2, n);
                if (n7 >= n5) continue;
                n5 = n7;
                n2 = i;
            }
        }
        if (n2 >= 0) {
            int n8 = this.mFirstPosition + n2;
            this.setSelection(n8);
            return;
        }
        this.requestLayout();
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.commonKey(n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5;
        block12: {
            int n6;
            int n7;
            super.onMeasure(n, n2);
            int n8 = View.MeasureSpec.getMode(n);
            int n9 = View.MeasureSpec.getMode(n2);
            n5 = View.MeasureSpec.getSize(n);
            n4 = View.MeasureSpec.getSize(n2);
            if (n8 == 0) {
                int n10;
                if (this.mColumnWidth > 0) {
                    int n11 = this.mColumnWidth;
                    int n12 = this.mListPadding.left;
                    int n13 = n11 + n12;
                    int n14 = this.mListPadding.right;
                    n10 = n13 + n14;
                } else {
                    int n15 = this.mListPadding.left;
                    int n16 = this.mListPadding.right;
                    n10 = n15 + n16;
                }
                int n17 = this.getVerticalScrollbarWidth();
                n5 = n10 + n17;
            }
            int n18 = this.mListPadding.left;
            int n19 = n5 - n18;
            int n20 = this.mListPadding.right;
            int n21 = n19 - n20;
            GridView gridView = this;
            int n22 = n21;
            gridView.determineColumns(n22);
            int n23 = 0;
            int n24 = this.mAdapter == null ? 0 : this.mAdapter.getCount();
            int n25 = n24;
            this.mItemCount = n25;
            int n26 = this.mItemCount;
            if (n26 > 0) {
                boolean bl;
                int n27;
                GridView gridView2 = this;
                int n28 = 0;
                boolean[] blArray = this.mIsScrap;
                boolean[] blArray2 = blArray;
                View view = gridView2.obtainView(n28, blArray2);
                AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
                if (layoutParams == null) {
                    AbsListView.LayoutParams layoutParams2 = layoutParams;
                    int n29 = 65535;
                    int n30 = 65534;
                    int n31 = 0;
                    layoutParams2(n29, n30, n31);
                    view.setLayoutParams(layoutParams);
                }
                layoutParams.viewType = n27 = this.mAdapter.getItemViewType(0);
                layoutParams.forceAdd = bl = true;
                int n32 = View.MeasureSpec.makeMeasureSpec(0, 0);
                int n33 = layoutParams.height;
                int n34 = GridView.getChildMeasureSpec(n32, 0, n33);
                int n35 = View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000);
                int n36 = layoutParams.width;
                int n37 = GridView.getChildMeasureSpec(n35, 0, n36);
                view.measure(n37, n34);
                n23 = view.getMeasuredHeight();
                AbsListView.RecycleBin recycleBin = this.mRecycler;
                int n38 = layoutParams.viewType;
                if (recycleBin.shouldRecycleViewType(n38)) {
                    AbsListView.RecycleBin recycleBin2 = this.mRecycler;
                    View view2 = view;
                    recycleBin2.addScrapView(view2);
                }
            }
            if (n9 == 0) {
                int n39 = this.mListPadding.top;
                int n40 = this.mListPadding.bottom;
                int n41 = n39 + n40 + n23;
                int n42 = this.getVerticalFadingEdgeLength() * 2;
                n4 = n41 + n42;
            }
            if ((n7 = n9) != (n6 = Integer.MIN_VALUE)) break block12;
            int n43 = this.mListPadding.top;
            int n44 = this.mListPadding.bottom;
            int n45 = n43 + n44;
            int n46 = this.mNumColumns;
            int n47 = 0;
            while (true) {
                block14: {
                    block13: {
                        if (n47 >= n26) break block13;
                        n45 += n23;
                        int n48 = n47 + n46;
                        int n49 = n26;
                        if (n48 < n49) {
                            int n50 = this.mVerticalSpacing;
                            int n51 = n45 + n50;
                        }
                        if (n45 < n4) break block14;
                        n45 = n4;
                    }
                    n4 = n45;
                    break;
                }
                n47 += n46;
            }
        }
        GridView gridView = this;
        int n52 = n5;
        int n53 = n4;
        gridView.setMeasuredDimension(n52, n53);
        this.mWidthMeasureSpec = n3 = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean pageScroll(int n) {
        int n2 = -1;
        if (n == 33) {
            int n3 = this.mSelectedPosition;
            int n4 = this.getChildCount();
            int n5 = n3 - n4 - 1;
            n2 = Math.max(0, n5);
        } else if (n == 130) {
            int n6 = this.mItemCount - 1;
            int n7 = this.mSelectedPosition;
            int n8 = this.getChildCount();
            int n9 = n7 + n8 - 1;
            n2 = Math.min(n6, n9);
        }
        if (n2 < 0) return false;
        this.setSelectionInt(n2);
        this.invokeOnItemScrollListener();
        boolean bl = this.awakenScrollBars();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(ListAdapter listAdapter) {
        if (this.mAdapter != null) {
            ListAdapter listAdapter2 = this.mAdapter;
            AdapterView.AdapterDataSetObserver adapterDataSetObserver = this.mDataSetObserver;
            listAdapter2.unregisterDataSetObserver(adapterDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = listAdapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            int n;
            AdapterView.AdapterDataSetObserver adapterDataSetObserver;
            int n2;
            int n3;
            this.mOldItemCount = n3 = this.mItemCount;
            this.mItemCount = n2 = this.mAdapter.getCount();
            this.mDataChanged = true;
            this.checkFocus();
            this.mDataSetObserver = adapterDataSetObserver = new AdapterView.AdapterDataSetObserver();
            ListAdapter listAdapter3 = this.mAdapter;
            AdapterView.AdapterDataSetObserver adapterDataSetObserver2 = this.mDataSetObserver;
            listAdapter3.registerDataSetObserver(adapterDataSetObserver2);
            AbsListView.RecycleBin recycleBin = this.mRecycler;
            int n4 = this.mAdapter.getViewTypeCount();
            recycleBin.setViewTypeCount(n4);
            if (this.mStackFromBottom) {
                int n5 = this.mItemCount - 1;
                n = this.lookForSelectablePosition(n5, false);
            } else {
                n = this.lookForSelectablePosition(0, true);
            }
            this.setSelectedPositionInt(n);
            this.setNextSelectedPositionInt(n);
            this.checkSelectionChanged();
        } else {
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    public void setColumnWidth(int n) {
        int n2 = this.mRequestedColumnWidth;
        if (n != n2) {
            return;
        }
        this.mRequestedColumnWidth = n;
        this.requestLayoutIfNecessary();
    }

    public void setGravity(int n) {
        if (this.mGravity != n) {
            return;
        }
        this.mGravity = n;
        this.requestLayoutIfNecessary();
    }

    public void setHorizontalSpacing(int n) {
        int n2 = this.mRequestedHorizontalSpacing;
        if (n != n2) {
            return;
        }
        this.mRequestedHorizontalSpacing = n;
        this.requestLayoutIfNecessary();
    }

    public void setNumColumns(int n) {
        int n2 = this.mRequestedNumColumns;
        if (n != n2) {
            return;
        }
        this.mRequestedNumColumns = n;
        this.requestLayoutIfNecessary();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSelection(int n) {
        if (!this.isInTouchMode()) {
            this.setNextSelectedPositionInt(n);
        } else {
            this.mResurrectToPosition = n;
        }
        this.mLayoutMode = 2;
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void setSelectionInt(int n) {
        int n2;
        int n3 = this.mNextSelectedPosition;
        this.setNextSelectedPositionInt(n);
        this.layoutChildren();
        if (this.mStackFromBottom) {
            int n4 = this.mItemCount - 1;
            int n5 = this.mNextSelectedPosition;
            n2 = n4 - n5;
        } else {
            n2 = this.mNextSelectedPosition;
        }
        int n6 = this.mStackFromBottom ? this.mItemCount - 1 - n3 : n3;
        int n7 = this.mNumColumns;
        int n8 = n2 / n7;
        int n9 = this.mNumColumns;
        int n10 = n6 / n9;
        if (n8 != n10) {
            return;
        }
        boolean bl = this.awakenScrollBars();
    }

    public void setStretchMode(int n) {
        int n2 = this.mStretchMode;
        if (n != n2) {
            return;
        }
        this.mStretchMode = n;
        this.requestLayoutIfNecessary();
    }

    public void setVerticalSpacing(int n) {
        int n2 = this.mVerticalSpacing;
        if (n != n2) {
            return;
        }
        this.mVerticalSpacing = n;
        this.requestLayoutIfNecessary();
    }
}

