/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AnimationUtils;
import android.widget.EdgeGlow;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import java.util.ArrayList;

public class HorizontalScrollView
extends FrameLayout {
    private static final int ANIMATED_SCROLL_GAP = 250;
    private static final int INVALID_POINTER = 255;
    private static final float MAX_SCROLL_FACTOR = 0.5f;
    private int mActivePointerId;
    private View mChildToScrollTo;
    private EdgeGlow mEdgeGlowLeft;
    private EdgeGlow mEdgeGlowRight;
    private boolean mFillViewport;
    private boolean mIsBeingDragged;
    private boolean mIsLayoutDirty;
    private float mLastMotionX;
    private long mLastScroll;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private int mOverflingDistance;
    private int mOverscrollDistance;
    private boolean mScrollViewMovedFocus;
    private OverScroller mScroller;
    private boolean mSmoothScrollingEnabled;
    private final Rect mTempRect;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    public HorizontalScrollView(Context context) {
        this(context, null);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843471);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Rect rect;
        this.mTempRect = rect = new Rect();
        this.mIsLayoutDirty = true;
        this.mChildToScrollTo = null;
        this.mIsBeingDragged = false;
        this.mSmoothScrollingEnabled = true;
        this.mActivePointerId = -1;
        this.initScrollView();
        int[] nArray = R.styleable.HorizontalScrollView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        boolean bl = typedArray.getBoolean(0, false);
        this.setFillViewport(bl);
        typedArray.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canScroll() {
        int n;
        int n2;
        int n3;
        View view = this.getChildAt(0);
        if (view == null) return false;
        int n4 = view.getWidth();
        int n5 = this.getWidth();
        if (n5 >= (n3 = (n2 = this.mPaddingLeft + n4) + (n = this.mPaddingRight))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int clamp(int n, int n2, int n3) {
        if (n2 >= n3) return 0;
        if (n < 0) {
            return 0;
        }
        if (n2 + n <= n3) return n;
        return n3 - n2;
    }

    private void doScrollX(int n) {
        if (n == 0) {
            return;
        }
        if (this.mSmoothScrollingEnabled) {
            this.smoothScrollBy(n, 0);
            return;
        }
        this.scrollBy(n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View findFocusableViewInBounds(boolean bl, int n, int n2) {
        ArrayList<View> arrayList = this.getFocusables(2);
        View view = null;
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            View view2 = (View)arrayList.get(n4);
            int n5 = view2.getLeft();
            int n6 = view2.getRight();
            if (n < n6 && n5 < n2) {
                boolean bl2 = n < n5 && n6 < n2;
                if (view == null) {
                    view = view2;
                    boolean bl3 = bl2;
                } else {
                    int n7;
                    int n8;
                    boolean bl4 = bl && n5 < (n8 = view.getLeft()) || !bl && n6 > (n7 = view.getRight());
                    if (bl2) {
                        view = view2;
                    } else if (bl4) {
                        view = view2;
                    }
                }
            }
            ++n4;
        }
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View findFocusableViewInMyBounds(boolean bl, int n, View view) {
        int n2 = this.getHorizontalFadingEdgeLength() / 2;
        int n3 = n + n2;
        int n4 = this.getWidth() + n - n2;
        if (view == null) return this.findFocusableViewInBounds(bl, n3, n4);
        if (view.getLeft() >= n4) return this.findFocusableViewInBounds(bl, n3, n4);
        if (view.getRight() <= n3) return this.findFocusableViewInBounds(bl, n3, n4);
        return view;
    }

    private int getScrollRange() {
        int n = 0;
        if (this.getChildCount() > 0) {
            int n2 = this.getChildAt(0).getWidth();
            int n3 = this.getWidth();
            int n4 = this.mPaddingLeft;
            int n5 = n3 - n4;
            int n6 = this.mPaddingRight;
            int n7 = n5 - n6;
            int n8 = n2 - n7;
            n = Math.max(0, n8);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inChild(int n, int n2) {
        if (this.getChildCount() <= 0) return false;
        int n3 = this.mScrollX;
        View view = this.getChildAt(0);
        int n4 = view.getTop();
        if (n2 < n4) return false;
        int n5 = view.getBottom();
        if (n2 >= n5) return false;
        int n6 = view.getLeft() - n3;
        if (n < n6) return false;
        int n7 = view.getRight() - n3;
        if (n >= n7) return false;
        return true;
    }

    private void initScrollView() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        OverScroller overScroller;
        Context context = this.getContext();
        this.mScroller = overScroller = new OverScroller(context);
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = n5 = viewConfiguration.getScaledTouchSlop();
        this.mMinimumVelocity = n4 = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = n3 = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = n2 = viewConfiguration.getScaledOverscrollDistance();
        this.mOverflingDistance = n = viewConfiguration.getScaledOverflingDistance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOffScreen(View view) {
        if (this.isWithinDeltaOfScreen(view, 0)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isViewDescendantOf(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent viewParent = view.getParent();
        if (!(viewParent instanceof ViewGroup)) return false;
        View view3 = (View)((Object)viewParent);
        if (!this.isViewDescendantOf(view3, view2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWithinDeltaOfScreen(View view, int n) {
        int n2;
        Rect rect = this.mTempRect;
        view.getDrawingRect(rect);
        Rect rect2 = this.mTempRect;
        this.offsetDescendantRectToMyCoords(view, rect2);
        int n3 = this.mTempRect.right + n;
        int n4 = this.getScrollX();
        if (n3 < n4) return false;
        int n5 = this.mTempRect.left - n;
        int n6 = this.getScrollX();
        int n7 = n6 + (n2 = this.getWidth());
        if (n5 > n7) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n;
        float f;
        int n2;
        int n3 = (motionEvent.getAction() & 0xFF00) >> 8;
        int n4 = motionEvent.getPointerId(n3);
        if (n4 != (n2 = this.mActivePointerId)) {
            return;
        }
        int n5 = n3 == 0 ? 1 : 0;
        this.mLastMotionX = f = motionEvent.getX(n5);
        this.mActivePointerId = n = motionEvent.getPointerId(n5);
        if (this.mVelocityTracker == null) {
            return;
        }
        this.mVelocityTracker.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scrollAndFocus(int n, int n2, int n3) {
        View view;
        boolean bl = true;
        int n4 = this.getWidth();
        int n5 = this.getScrollX();
        int n6 = n5 + n4;
        boolean bl2 = n == 17;
        View view2 = this.findFocusableViewInBounds(bl2, n2, n3);
        if (view2 == null) {
            view2 = this;
        }
        if (n2 >= n5 && n3 <= n6) {
            bl = false;
        } else {
            int n7 = bl2 ? n2 - n5 : n3 - n6;
            this.doScrollX(n7);
        }
        if (view2 != (view = this.findFocus()) && view2.requestFocus(n)) {
            this.mScrollViewMovedFocus = true;
            this.mScrollViewMovedFocus = false;
        }
        return bl;
    }

    private void scrollToChild(View view) {
        Rect rect = this.mTempRect;
        view.getDrawingRect(rect);
        Rect rect2 = this.mTempRect;
        this.offsetDescendantRectToMyCoords(view, rect2);
        Rect rect3 = this.mTempRect;
        int n = this.computeScrollDeltaToGetChildRectOnScreen(rect3);
        if (n == 0) {
            return;
        }
        this.scrollBy(n, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scrollToChildRect(Rect rect, boolean bl) {
        int n = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        if (n == 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (bl) {
            this.scrollBy(n, 0);
            return bl2;
        }
        this.smoothScrollBy(n, 0);
        return bl2;
    }

    @Override
    public void addView(View view) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view);
    }

    @Override
    public void addView(View view, int n) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view, n);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view, n, layoutParams);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view, layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean arrowScroll(int n) {
        View view = this.findFocus();
        if (view == this) {
            view = null;
        }
        View view2 = FocusFinder.getInstance().findNextFocus(this, view, n);
        int n2 = this.getMaxScrollAmount();
        if (view2 != null && this.isWithinDeltaOfScreen(view2, n2)) {
            Rect rect = this.mTempRect;
            view2.getDrawingRect(rect);
            Rect rect2 = this.mTempRect;
            this.offsetDescendantRectToMyCoords(view2, rect2);
            Rect rect3 = this.mTempRect;
            int n3 = this.computeScrollDeltaToGetChildRectOnScreen(rect3);
            this.doScrollX(n3);
            boolean bl = view2.requestFocus(n);
        } else {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = n2;
            if (n == 17 && this.getScrollX() < n8) {
                n8 = this.getScrollX();
            } else if (n == 66 && this.getChildCount() > 0 && (n7 = this.getChildAt(0).getRight()) - (n6 = (n5 = this.getScrollX()) + (n4 = this.getWidth())) < n2) {
                n8 = n7 - n6;
            }
            if (n8 == 0) {
                return false;
            }
            int n9 = n == 66 ? n8 : -n8;
            this.doScrollX(n9);
        }
        if (view == null) return true;
        if (!view.isFocused()) return true;
        if (!this.isOffScreen(view)) return true;
        int n10 = this.getDescendantFocusability();
        this.setDescendantFocusability(131072);
        boolean bl = this.requestFocus();
        this.setDescendantFocusability(n10);
        return true;
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        int n = super.computeHorizontalScrollOffset();
        return Math.max(0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int computeHorizontalScrollRange() {
        int n = this.getChildCount();
        int n2 = this.getWidth();
        int n3 = this.mPaddingLeft;
        int n4 = n2 - n3;
        int n5 = this.mPaddingRight;
        int n6 = n4 - n5;
        if (n == 0) {
            return n6;
        }
        int n7 = this.getChildAt(0).getRight();
        int n8 = this.mScrollX;
        int n9 = n7 - n6;
        int n10 = Math.max(0, n9);
        if (n8 < 0) {
            n7 -= n8;
            return n7;
        }
        if (n8 <= n10) return n7;
        int n11 = n8 - n10;
        n7 += n11;
        return n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void computeScroll() {
        if (!this.mScroller.computeScrollOffset()) {
            return;
        }
        int n = this.mScrollX;
        int n2 = this.mScrollY;
        int n3 = this.mScroller.getCurrX();
        int n4 = this.mScroller.getCurrY();
        if (n == n3 || n2 != n4) {
            int n5 = n3 - n;
            int n6 = n4 - n2;
            int n7 = this.getScrollRange();
            int n8 = this.mOverflingDistance;
            HorizontalScrollView horizontalScrollView = this;
            int n9 = 0;
            boolean bl = false;
            boolean bl2 = horizontalScrollView.overScrollBy(n5, n6, n, n2, n7, 0, n8, n9, bl);
            int n10 = this.mScrollX;
            int n11 = this.mScrollY;
            this.onScrollChanged(n10, n11, n, n2);
            int n12 = this.getScrollRange();
            int n13 = this.getOverScrollMode();
            if (n13 == 0 || n13 == 1 && n12 > 0) {
                if (n3 < 0 && n >= 0) {
                    EdgeGlow edgeGlow = this.mEdgeGlowLeft;
                    int n14 = (int)this.mScroller.getCurrVelocity();
                    edgeGlow.onAbsorb(n14);
                } else if (n3 > n12 && n <= n12) {
                    EdgeGlow edgeGlow = this.mEdgeGlowRight;
                    int n15 = (int)this.mScroller.getCurrVelocity();
                    edgeGlow.onAbsorb(n15);
                }
            }
        }
        boolean bl = this.awakenScrollBars();
        this.postInvalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        int n;
        int n2;
        if (this.getChildCount() == 0) {
            return 0;
        }
        int n3 = this.getWidth();
        int n4 = this.getScrollX();
        int n5 = n4 + n3;
        int n6 = this.getHorizontalFadingEdgeLength();
        if (rect.left > 0) {
            n4 += n6;
        }
        if ((n2 = rect.right) < (n = this.getChildAt(0).getWidth())) {
            n5 -= n6;
        }
        int n7 = 0;
        if (rect.right > n5 && rect.left > n4) {
            int n8;
            if (rect.width() > n3) {
                int n9 = rect.left - n4;
                n8 = n7 + n9;
            } else {
                int n10 = rect.right - n5;
                n8 = n7 + n10;
            }
            int n11 = this.getChildAt(0).getRight() - n5;
            n7 = Math.min(n8, n11);
            return n7;
        } else {
            int n12;
            if (rect.left >= n4) return n7;
            if (rect.right >= n5) return n7;
            if (rect.width() > n3) {
                int n13 = rect.right;
                int n14 = n5 - n13;
                n12 = n7 - n14;
            } else {
                int n15 = rect.left;
                int n16 = n4 - n15;
                n12 = n7 - n16;
            }
            int n17 = -this.getScrollX();
            n7 = Math.max(n12, n17);
        }
        return n7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (super.dispatchKeyEvent(keyEvent)) return true;
        if (!this.executeKeyEvent(keyEvent)) return false;
        return true;
    }

    @Override
    public void draw(Canvas canvas) {
        int n;
        super.draw(canvas);
        if (this.mEdgeGlowLeft == null) {
            return;
        }
        int n2 = this.mScrollX;
        if (!this.mEdgeGlowLeft.isFinished()) {
            n = canvas.save();
            int n3 = this.getHeight();
            canvas.rotate(270.0f);
            float f = (float)(-n3) * 1.5f;
            float f2 = Math.min(0, n2);
            canvas.translate(f, f2);
            EdgeGlow edgeGlow = this.mEdgeGlowLeft;
            int n4 = this.getHeight() * 2;
            int n5 = this.getWidth();
            edgeGlow.setSize(n4, n5);
            if (this.mEdgeGlowLeft.draw(canvas)) {
                this.invalidate();
            }
            canvas.restoreToCount(n);
        }
        if (this.mEdgeGlowRight.isFinished()) {
            return;
        }
        n = canvas.save();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        canvas.rotate(90.0f);
        float f = -n7 / 2;
        float f3 = -(Math.max(this.getScrollRange(), n2) + n6);
        canvas.translate(f, f3);
        EdgeGlow edgeGlow = this.mEdgeGlowRight;
        int n8 = n7 * 2;
        edgeGlow.setSize(n8, n6);
        if (this.mEdgeGlowRight.draw(canvas)) {
            this.invalidate();
        }
        canvas.restoreToCount(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean executeKeyEvent(KeyEvent keyEvent) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            View view;
            if (!this.isFocused()) {
                return false;
            }
            View view2 = this.findFocus();
            if (view2 == this) {
                view2 = null;
            }
            if ((view = FocusFinder.getInstance().findNextFocus(this, view2, 66)) == null) return false;
            if (view == this) return false;
            if (!view.requestFocus(66)) return false;
            return true;
        }
        boolean bl = false;
        if (keyEvent.getAction() != 0) return bl;
        switch (keyEvent.getKeyCode()) {
            case 21: {
                if (!keyEvent.isAltPressed()) {
                    bl = this.arrowScroll(17);
                    return bl;
                }
                bl = this.fullScroll(17);
                return bl;
            }
            case 22: {
                if (!keyEvent.isAltPressed()) {
                    bl = this.arrowScroll(66);
                    return bl;
                }
                bl = this.fullScroll(66);
                return bl;
            }
            case 62: {
                int n = keyEvent.isShiftPressed() ? 17 : 66;
                boolean bl2 = this.pageScroll(n);
                return bl;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fling(int n) {
        int n2;
        View view;
        View view2;
        if (this.getChildCount() <= 0) {
            return;
        }
        int n3 = this.getWidth();
        int n4 = this.mPaddingRight;
        int n5 = n3 - n4;
        int n6 = this.mPaddingLeft;
        int n7 = n5 - n6;
        int n8 = this.getChildAt(0).getWidth();
        OverScroller overScroller = this.mScroller;
        int n9 = this.mScrollX;
        int n10 = this.mScrollY;
        int n11 = n8 - n7;
        int n12 = Math.max(0, n11);
        int n13 = n7 / 2;
        int n14 = n;
        overScroller.fling(n9, n10, n14, 0, 0, n12, 0, 0, n13, 0);
        boolean bl = n > 0;
        int n15 = this.mScroller.getFinalX();
        View view3 = this.findFocusableViewInMyBounds(bl, n15, view2 = this.findFocus());
        if (view3 == null) {
            view3 = this;
        }
        if (view3 != (view = this.findFocus()) && view3.requestFocus(n2 = bl ? 66 : 17)) {
            this.mScrollViewMovedFocus = true;
            this.mScrollViewMovedFocus = false;
        }
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean fullScroll(int n) {
        boolean bl = n == 66;
        int n2 = this.getWidth();
        this.mTempRect.left = 0;
        this.mTempRect.right = n2;
        if (bl && this.getChildCount() > 0) {
            int n3;
            int n4;
            View view = this.getChildAt(0);
            Rect rect = this.mTempRect;
            rect.right = n4 = view.getRight();
            Rect rect2 = this.mTempRect;
            rect2.left = n3 = this.mTempRect.right - n2;
        }
        int n5 = this.mTempRect.left;
        int n6 = this.mTempRect.right;
        return this.scrollAndFocus(n, n5, n6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected float getLeftFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int n = this.getHorizontalFadingEdgeLength();
        if (this.mScrollX >= n) return 1.0f;
        float f = this.mScrollX;
        float f2 = n;
        return f / f2;
    }

    public int getMaxScrollAmount() {
        int n = this.mRight;
        int n2 = this.mLeft;
        float f = n - n2;
        return (int)(0.5f * f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected float getRightFadingEdgeStrength() {
        int n;
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int n2 = this.getHorizontalFadingEdgeLength();
        int n3 = this.getWidth();
        int n4 = this.mPaddingRight;
        int n5 = n3 - n4;
        int n6 = this.getChildAt(0).getRight();
        int n7 = n6 - (n = this.mScrollX) - n5;
        if (n7 >= n2) return 1.0f;
        float f = n7;
        float f2 = n2;
        return f / f2;
    }

    public boolean isFillViewport() {
        return this.mFillViewport;
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    @Override
    protected void measureChild(View view, int n, int n2) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        int n3 = this.mPaddingTop;
        int n4 = this.mPaddingBottom;
        int n5 = n3 + n4;
        int n6 = layoutParams.height;
        int n7 = HorizontalScrollView.getChildMeasureSpec(n2, n5, n6);
        int n8 = View.MeasureSpec.makeMeasureSpec(0, 0);
        view.measure(n8, n7);
    }

    @Override
    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n5 = this.mPaddingTop;
        int n6 = this.mPaddingBottom;
        int n7 = n5 + n6;
        int n8 = marginLayoutParams.topMargin;
        int n9 = n7 + n8;
        int n10 = marginLayoutParams.bottomMargin;
        int n11 = n9 + n10 + n4;
        int n12 = marginLayoutParams.height;
        int n13 = HorizontalScrollView.getChildMeasureSpec(n3, n11, n12);
        int n14 = marginLayoutParams.leftMargin;
        int n15 = marginLayoutParams.rightMargin;
        int n16 = View.MeasureSpec.makeMeasureSpec(n14 + n15, 0);
        view.measure(n16, n13);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (n == 2 && this.mIsBeingDragged) {
            return true;
        }
        switch (n & 0xFF) {
            case 2: {
                int n2;
                float f;
                int n3 = this.mActivePointerId;
                if (n3 == -1) return this.mIsBeingDragged;
                int n4 = motionEvent.findPointerIndex(n3);
                float f2 = motionEvent.getX(n4);
                int n5 = (int)Math.abs(f2 - (f = this.mLastMotionX));
                if (n5 <= (n2 = this.mTouchSlop)) return this.mIsBeingDragged;
                this.mIsBeingDragged = true;
                this.mLastMotionX = f2;
                if (this.mParent == null) return this.mIsBeingDragged;
                this.mParent.requestDisallowInterceptTouchEvent(true);
                return this.mIsBeingDragged;
            }
            case 0: {
                int n6;
                float f = motionEvent.getX();
                int n7 = (int)f;
                int n8 = (int)motionEvent.getY();
                if (!this.inChild(n7, n8)) {
                    this.mIsBeingDragged = false;
                    return this.mIsBeingDragged;
                }
                this.mLastMotionX = f;
                this.mActivePointerId = n6 = motionEvent.getPointerId(0);
                boolean bl = !this.mScroller.isFinished();
                this.mIsBeingDragged = bl;
                return this.mIsBeingDragged;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                OverScroller overScroller = this.mScroller;
                int n9 = this.mScrollX;
                int n10 = this.mScrollY;
                int n11 = this.getScrollRange();
                int n12 = 0;
                int n13 = 0;
                if (!overScroller.springBack(n9, n10, 0, n11, n12, n13)) return this.mIsBeingDragged;
                this.invalidate();
                return this.mIsBeingDragged;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                return this.mIsBeingDragged;
            }
        }
        return this.mIsBeingDragged;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view;
        super.onLayout(bl, n, n2, n3, n4);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && this.isViewDescendantOf(view = this.mChildToScrollTo, this)) {
            View view2 = this.mChildToScrollTo;
            this.scrollToChild(view2);
        }
        this.mChildToScrollTo = null;
        int n5 = this.mScrollX;
        int n6 = this.mScrollY;
        this.scrollTo(n5, n6);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (!this.mFillViewport) {
            return;
        }
        if (View.MeasureSpec.getMode(n) == 0) {
            return;
        }
        if (this.getChildCount() <= 0) {
            return;
        }
        View view = this.getChildAt(0);
        int n3 = this.getMeasuredWidth();
        if (view.getMeasuredWidth() >= n3) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        int n4 = this.mPaddingTop;
        int n5 = this.mPaddingBottom;
        int n6 = n4 + n5;
        int n7 = layoutParams.height;
        int n8 = HorizontalScrollView.getChildMeasureSpec(n2, n6, n7);
        int n9 = this.mPaddingLeft;
        int n10 = n3 - n9;
        int n11 = this.mPaddingRight;
        int n12 = View.MeasureSpec.makeMeasureSpec(n10 - n11, 0x40000000);
        view.measure(n12, n8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        if (!this.mScroller.isFinished()) {
            this.mScrollX = n;
            this.mScrollY = n2;
            if (bl) {
                OverScroller overScroller = this.mScroller;
                int n3 = this.mScrollX;
                int n4 = this.mScrollY;
                int n5 = this.getScrollRange();
                int n6 = 0;
                int n7 = 0;
                boolean bl3 = overScroller.springBack(n3, n4, 0, n5, n6, n7);
            }
        } else {
            super.scrollTo(n, n2);
        }
        boolean bl4 = this.awakenScrollBars();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        if (n == 2) {
            n = 66;
        } else if (n == 1) {
            n = 17;
        }
        View view = rect == null ? FocusFinder.getInstance().findNextFocus(this, null, n) : FocusFinder.getInstance().findNextFocusFromRect(this, rect, n);
        if (view == null) {
            return false;
        }
        if (!this.isOffScreen(view)) return view.requestFocus(n, rect);
        return false;
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        View view = this.findFocus();
        if (view == null) {
            return;
        }
        if (this == view) {
            return;
        }
        int n5 = this.mRight;
        int n6 = this.mLeft;
        int n7 = n5 - n6;
        if (!this.isWithinDeltaOfScreen(view, n7)) {
            return;
        }
        Rect rect = this.mTempRect;
        view.getDrawingRect(rect);
        Rect rect2 = this.mTempRect;
        this.offsetDescendantRectToMyCoords(view, rect2);
        Rect rect3 = this.mTempRect;
        int n8 = this.computeScrollDeltaToGetChildRectOnScreen(rect3);
        this.doScrollX(n8);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent var1_1) {
        if (var1_1.getAction() == 0 && var1_1.getEdgeFlags() != 0) {
            var2_2 = false;
lbl3:
            // 3 sources

            return var2_2;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = var3_3 = VelocityTracker.obtain();
        }
        var4_4 = this.mVelocityTracker;
        var5_5 = var1_1;
        var4_4.addMovement(var5_5);
        switch (var1_1.getAction() & 255) lbl-1000:
        // 10 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_2 = true;
                    ** GOTO lbl3
                    break;
                }
            }
            case 0: {
                if (this.getChildCount() != 0) {
                    var6_6 = true;
lbl18:
                    // 2 sources

                    while (true) {
                        this.mIsBeingDragged = var7_7 = var6_6;
                        if (!this.mIsBeingDragged) {
                            var2_2 = false;
                            ** continue;
                        }
                        break;
                    }
                } else {
                    var6_6 = false;
                    ** continue;
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionX = var8_8 = var1_1.getX();
                var9_9 = var1_1;
                var10_10 = 0;
                this.mActivePointerId = var11_11 = var9_9.getPointerId(var10_10);
                ** GOTO lbl-1000
            }
            case 2: {
                if (!this.mIsBeingDragged) ** GOTO lbl-1000
                var12_12 = this.mActivePointerId;
                var13_13 = var1_1;
                var14_14 = var12_12;
                var15_15 = var13_13.findPointerIndex(var14_14);
                var16_16 = var1_1;
                var17_17 = var15_15;
                var18_18 = var16_16.getX(var17_17);
                var19_19 = (int)(this.mLastMotionX - var18_18);
                this.mLastMotionX = var20_20 = var18_18;
                var21_21 = this.mScrollX;
                var22_22 = this.mScrollY;
                var24_24 = this.mScrollX;
                var23_23 = this.getScrollRange();
                if (this.overScrollBy(var19_19, 0, var24_24, 0, var23_23, 0, var25_25 = this.mOverscrollDistance, 0, true)) {
                    this.mVelocityTracker.clear();
                }
                var26_26 = this.mScrollX;
                var27_27 = this.mScrollY;
                var28_28 = this;
                var29_29 = var26_26;
                var30_30 = var27_27;
                var31_31 = var21_21;
                var32_32 = var22_22;
                var28_28.onScrollChanged(var29_29, var30_30, var31_31, var32_32);
                var33_33 = this.getOverScrollMode();
                if (var33_33 != 0 && ((var34_34 = var33_33) != (var35_35 = 1) || var23_23 <= 0)) ** GOTO lbl-1000
                var36_36 = var21_21 + var19_19;
                if (var36_36 >= 0) ** GOTO lbl73
                var37_37 = this.mEdgeGlowLeft;
                var38_38 = var19_19;
                var39_39 = this.getWidth();
                var40_40 = var38_38 / var39_39;
                var37_37.onPull(var40_40);
                if (!this.mEdgeGlowRight.isFinished()) {
                    this.mEdgeGlowRight.onRelease();
                }
lbl69:
                // 6 sources

                while (true) {
                    if (!(this.mEdgeGlowLeft == null || this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished())) {
                        this.invalidate();
                    }
                    ** GOTO lbl-1000
                    break;
                }
lbl73:
                // 1 sources

                var41_41 = var36_36;
                var42_42 = var23_23;
                if (var41_41 <= var42_42) ** GOTO lbl69
                var43_43 = this.mEdgeGlowRight;
                var44_44 = var19_19;
                var45_45 = this.getWidth();
                var46_46 = var44_44 / var45_45;
                var43_43.onPull(var46_46);
                if (this.mEdgeGlowLeft.isFinished()) ** GOTO lbl69
                this.mEdgeGlowLeft.onRelease();
                ** continue;
            }
            case 1: {
                if (!this.mIsBeingDragged) ** GOTO lbl-1000
                var47_47 = this.mVelocityTracker;
                var48_48 = this.mMaximumVelocity;
                var49_49 = var47_47;
                var50_50 = 1000;
                var51_51 = var48_48;
                var49_49.computeCurrentVelocity(var50_50, var51_51);
                var52_52 = this.mActivePointerId;
                var53_53 = var47_47;
                var54_54 = var52_52;
                var55_55 = (int)var53_53.getXVelocity(var54_54);
                if (this.getChildCount() <= 0) ** GOTO lbl103
                var56_56 = Math.abs(var55_55);
                if (var56_56 <= (var57_57 = this.mMinimumVelocity)) ** GOTO lbl114
                var58_58 = -var55_55;
                var59_59 = this;
                var60_60 = var58_58;
                var59_59.fling(var60_60);
lbl103:
                // 4 sources

                while (true) {
                    this.mActivePointerId = var61_61 = -1;
                    this.mIsBeingDragged = var62_62 = false;
                    if (this.mVelocityTracker != null) {
                        this.mVelocityTracker.recycle();
                        var63_63 = null;
                        this.mVelocityTracker = var63_63;
                    }
                    if (this.mEdgeGlowLeft != null) {
                        this.mEdgeGlowLeft.onRelease();
                        this.mEdgeGlowRight.onRelease();
                    }
                    ** GOTO lbl-1000
                    break;
                }
lbl114:
                // 1 sources

                var65_65 = this.mScroller;
                var66_66 = this.mScrollX;
                var67_67 = this.mScrollY;
                var64_64 = this.getScrollRange();
                if (!var65_65.springBack(var66_66, var67_67, 0, var64_64, 0, 0)) ** GOTO lbl103
                this.invalidate();
                ** continue;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) ** GOTO lbl-1000
                var68_68 = this.mScroller;
                var69_69 = this.mScrollX;
                var70_70 = this.mScrollY;
                var71_71 = this.getScrollRange();
                if (var68_68.springBack(var69_69, var70_70, 0, var71_71, 0, 0)) {
                    this.invalidate();
                }
                this.mActivePointerId = var72_72 = -1;
                this.mIsBeingDragged = var73_73 = false;
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    var74_74 = null;
                    this.mVelocityTracker = var74_74;
                }
                if (this.mEdgeGlowLeft == null) ** GOTO lbl-1000
                this.mEdgeGlowLeft.onRelease();
                this.mEdgeGlowRight.onRelease();
                ** GOTO lbl-1000
            }
            case 6: 
        }
        this.onSecondaryPointerUp(var1_1);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean pageScroll(int n) {
        int n2;
        boolean bl = n == 66;
        int n3 = this.getWidth();
        if (bl) {
            View view;
            int n4;
            int n5;
            int n6;
            Rect rect = this.mTempRect;
            rect.left = n6 = this.getScrollX() + n3;
            if (this.getChildCount() > 0 && (n5 = this.mTempRect.left + n3) > (n4 = (view = this.getChildAt(0)).getRight())) {
                int n7;
                Rect rect2 = this.mTempRect;
                rect2.left = n7 = view.getRight() - n3;
            }
        } else {
            int n8;
            Rect rect = this.mTempRect;
            rect.left = n8 = this.getScrollX() - n3;
            if (this.mTempRect.left < 0) {
                this.mTempRect.left = 0;
            }
        }
        Rect rect = this.mTempRect;
        rect.right = n2 = this.mTempRect.left + n3;
        int n9 = this.mTempRect.left;
        int n10 = this.mTempRect.right;
        return this.scrollAndFocus(n, n9, n10);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void requestChildFocus(View view, View view2) {
        if (!this.mScrollViewMovedFocus) {
            if (!this.mIsLayoutDirty) {
                this.scrollToChild(view2);
            } else {
                this.mChildToScrollTo = view2;
            }
        }
        super.requestChildFocus(view, view2);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        int n = view.getLeft();
        int n2 = view.getScrollX();
        int n3 = n - n2;
        int n4 = view.getTop();
        int n5 = view.getScrollY();
        int n6 = n4 - n5;
        rect.offset(n3, n6);
        return this.scrollToChildRect(rect, bl);
    }

    @Override
    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    @Override
    public void scrollTo(int n, int n2) {
        int n3;
        if (this.getChildCount() <= 0) {
            return;
        }
        View view = this.getChildAt(0);
        int n4 = this.getWidth();
        int n5 = this.mPaddingRight;
        int n6 = n4 - n5;
        int n7 = this.mPaddingLeft;
        int n8 = n6 - n7;
        int n9 = view.getWidth();
        n = this.clamp(n, n8, n9);
        int n10 = this.getHeight();
        int n11 = this.mPaddingBottom;
        int n12 = n10 - n11;
        int n13 = this.mPaddingTop;
        int n14 = n12 - n13;
        int n15 = view.getHeight();
        n2 = this.clamp(n2, n14, n15);
        int n16 = this.mScrollX;
        if (n != n16 && n2 != (n3 = this.mScrollY)) {
            return;
        }
        super.scrollTo(n, n2);
    }

    public void setFillViewport(boolean bl) {
        boolean bl2 = this.mFillViewport;
        if (bl != bl2) {
            return;
        }
        this.mFillViewport = bl;
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setOverScrollMode(int n) {
        if (n != 2) {
            if (this.mEdgeGlowLeft == null) {
                EdgeGlow edgeGlow;
                EdgeGlow edgeGlow2;
                Resources resources = this.getContext().getResources();
                Drawable drawable2 = resources.getDrawable(17302072);
                Drawable drawable3 = resources.getDrawable(17302073);
                this.mEdgeGlowLeft = edgeGlow2 = new EdgeGlow(drawable2, drawable3);
                this.mEdgeGlowRight = edgeGlow = new EdgeGlow(drawable2, drawable3);
            }
        } else {
            this.mEdgeGlowLeft = null;
            this.mEdgeGlowRight = null;
        }
        super.setOverScrollMode(n);
    }

    public void setSmoothScrollingEnabled(boolean bl) {
        this.mSmoothScrollingEnabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void smoothScrollBy(int n, int n2) {
        long l;
        long l2;
        if (this.getChildCount() == 0) {
            return;
        }
        long l3 = AnimationUtils.currentAnimationTimeMillis();
        if (l3 - (l2 = this.mLastScroll) > 250L) {
            int n3 = this.getWidth();
            int n4 = this.mPaddingRight;
            int n5 = n3 - n4;
            int n6 = this.mPaddingLeft;
            int n7 = n5 - n6;
            int n8 = this.getChildAt(0).getWidth() - n7;
            int n9 = Math.max(0, n8);
            int n10 = this.mScrollX;
            int n11 = Math.min(n10 + n, n9);
            int n12 = Math.max(0, n11) - n10;
            OverScroller overScroller = this.mScroller;
            int n13 = this.mScrollY;
            overScroller.startScroll(n10, n13, n12, 0);
            this.invalidate();
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
            }
            this.scrollBy(n, n2);
        }
        this.mLastScroll = l = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void smoothScrollTo(int n, int n2) {
        int n3 = this.mScrollX;
        int n4 = n - n3;
        int n5 = this.mScrollY;
        int n6 = n2 - n5;
        this.smoothScrollBy(n4, n6);
    }
}

